/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.calimasaga.slavepits.util.StringList;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base32;

public class PropertiesReader {
    public static Properties loadLanguage(Properties properties, String language) {
        String newLine = System.getProperty("line.separator");
        try {
            FileHandle file = Gdx.files.local("messages_" + language + ".properties");
            if (file == null || !file.exists()) {
                file = Gdx.files.internal("data/messages_" + language + ".properties");
            }
            String content = file.readString("UTF-8");
            for (String currPair : content.split("\n")) {
                properties.setProperty(currPair.split("=")[0], currPair.endsWith("=") ? "" : currPair.split("=")[1].replace("\\n", newLine));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String getMessage(Properties messages, String key) {
        return PropertiesReader.getMessage(messages, key, false, "");
    }

    public static String getMessage(Properties messages, String key, Boolean violenceFilter) {
        return PropertiesReader.getMessage(messages, key, violenceFilter, "");
    }

    public static String getMessage(Properties messages, String key, String colorMark) {
        return PropertiesReader.getMessage(messages, key, false, colorMark);
    }

    public static String getMessage(Properties messages, String key, boolean violenceFilter, String colorMark) {
        String result = null;
        if (violenceFilter) {
            result = messages.getProperty(key + ".nonviolent");
        }
        if (result == null) {
            result = messages.getProperty(key);
        }
        if (result != null && !colorMark.equalsIgnoreCase("")) {
            String mark = colorMark.split(":")[0];
            String colorDest = colorMark.split(":")[1];
            while (result.indexOf(mark) >= 0) {
                result = result.replaceFirst(mark, "[#" + colorDest + "]");
                result = result.replaceFirst(mark, "[]");
            }
        }
        return result == null ? "" : result;
    }

    public static Properties loadSettings() {
        String newLine = System.getProperty("line.separator");
        Properties properties = new Properties();
        try {
            FileHandle file = Gdx.files.local("settings.properties");
            if (file == null || !file.exists()) {
                file = Gdx.files.internal("data/settings.properties");
                newLine = "\n";
            }
            String content = file.readString("UTF-8");
            for (String currPair : content.split(newLine)) {
                if (!currPair.contains("=")) continue;
                properties.setProperty(currPair.split("=")[0], currPair.split("=")[1].replace(newLine, "").replace("\n", ""));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static void saveSettings(Properties settings) {
        String newLine = System.getProperty("line.separator");
        FileHandle file = Gdx.files.local("settings.properties");
        try {
            file.writeString("#Game" + newLine, false);
            ArrayList<String> propertiesKeys = new ArrayList<String>(settings.stringPropertyNames());
            Collections.sort(propertiesKeys);
            for (String currKey : propertiesKeys) {
                file.writeString(currKey + "=" + settings.getProperty(currKey) + newLine, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getVersion() {
        String version = "";
        try {
            version = Gdx.files.internal("data/version.txt").readString("UTF-8").trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return version;
    }

    public static void setVersion(String version) {
        try {
            FileHandle file = Gdx.files.internal("data/version.txt");
            file.writeString(version, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMailKeyPair() {
        String newLine = System.getProperty("line.separator");
        String mail = "";
        String key = "";
        try {
            FileHandle mailkeypair = Gdx.files.local("key.txt");
            if (mailkeypair == null || !mailkeypair.exists()) {
                mail = "yourmail@yourdomain.com";
                key = "00000-00000-00000";
                PropertiesReader.setMailKeyPair(mail, key);
            } else {
                String content = mailkeypair.readString("UTF-8");
                mail = content.split(newLine)[0].trim();
                key = content.split(newLine)[1].trim();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mail + "@" + key;
    }

    public static void setMailKeyPair(String mail, String key) {
        String newLine = System.getProperty("line.separator");
        try {
            FileHandle file = Gdx.files.local("key.txt");
            file.writeString(mail + newLine + key, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean verifyMail(String mail) {
        Pattern ptr = Pattern.compile("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)");
        return ptr.matcher(mail).matches();
    }

    public static String verifyKey(String mail, String key, long checksum) {
        String result = "free";
        try {
            if (checksum >= 0L) {
                Base32 base32 = new Base32();
                if (key.contains("-") && key.split("-").length == 3) {
                    String keyHex1 = String.format("%1$5s", new String(base32.decode(key.split("-")[0]))).replace(' ', '0');
                    int counter = 1;
                    int numResult = 1;
                    int numResultCheck = 1;
                    for (int i = 0; i < mail.length(); ++i) {
                        counter = counter * mail.charAt(i) % 1048575;
                    }
                    numResult = counter % 1048575;
                    for (int k = 1; k < 10; ++k) {
                        int i;
                        counter = 1;
                        for (i = 0; i < ("slapit-" + k).length(); ++i) {
                            counter = counter * ("slapit-" + k).charAt(i) % 1048575;
                        }
                        numResultCheck = (numResult + counter % 1048575) % 1048575;
                        if (keyHex1.equalsIgnoreCase(String.format("%1$5s", Integer.toHexString(numResultCheck)).replace(' ', '0'))) {
                            result = "normal";
                            k = 10;
                            continue;
                        }
                        counter = 1;
                        for (i = 0; i < ("slapits-" + k).length(); ++i) {
                            counter = counter * ("slapits-" + k).charAt(i) % 1048575;
                        }
                        numResultCheck = (numResult + counter % 1048575) % 1048575;
                        if (!keyHex1.equalsIgnoreCase(String.format("%1$5s", Integer.toHexString(numResultCheck)).replace(' ', '0'))) continue;
                        result = "extra";
                        k = 10;
                    }
                    if (!result.equalsIgnoreCase("free")) {
                        numResult = numResultCheck;
                        String keyHexNum = String.format("%1$5s", new String(base32.decode(key.split("-")[1]))).replace(' ', '0') + String.format("%1$5s", new String(base32.decode(key.split("-")[2]))).replace(' ', '0');
                        String checkNum = String.format("%1$2s", Long.toHexString((long)numResult * 3331L % 256L)).replace(' ', '0');
                        if (key.length() != 26 || !keyHexNum.substring(0, 2).equalsIgnoreCase(checkNum)) {
                            result = "free";
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            result = "free";
        }
        return result;
    }

    public static long calculateChecksum(String mail, String key) {
        int i;
        long counter = 1L;
        for (i = 0; i < mail.length(); ++i) {
            counter += (long)mail.charAt(i);
        }
        for (i = 0; i < key.length(); ++i) {
            counter += (long)key.charAt(i);
        }
        return counter * (System.currentTimeMillis() / 1000L);
    }

    public static long getChecksum(String mail, String key, long checksum) {
        int i;
        long counter = 1L;
        for (i = 0; i < mail.length(); ++i) {
            counter += (long)mail.charAt(i);
        }
        for (i = 0; i < key.length(); ++i) {
            counter += (long)key.charAt(i);
        }
        return checksum / counter;
    }

    public static String getHashedValue(String value) {
        String result = "";
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-256");
            byte[] hash = sha.digest(value.getBytes("UTF-8"));
            String hashtext = DatatypeConverter.printHexBinary((byte[])sha.digest(value.getBytes()));
            result = hashtext.substring(0, 8).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static HashMap<String, String> loadGame(Integer position, String mail, String key, boolean debug) {
        String newLine = System.getProperty("line.separator");
        HashMap<String, String> gameStatus = new HashMap<String, String>();
        String rawContent = PropertiesReader.readSaveDataRaw(mail, key, debug);
        if (!rawContent.endsWith("$$$")) {
            StringBuilder saves = StringList.create(rawContent.substring(rawContent.indexOf("$$$") + 3), "###");
            if (StringList.size(saves, "###") < position) {
                gameStatus.put("name", "0");
            } else {
                String save = StringList.get(saves, position - 1, "###");
                for (String currStat : save.split(newLine)) {
                    if (currStat.equalsIgnoreCase("")) continue;
                    gameStatus.put(currStat.split("=")[0], currStat.split("=").length > 1 ? currStat.split("=")[1] : "");
                }
            }
        } else {
            gameStatus.put("name", "0");
        }
        return gameStatus;
    }

    public static void saveGame(HashMap<String, String> gameStatus, Integer position, String mail, String key, boolean debug) {
        String newLine = System.getProperty("line.separator");
        String rawContent = PropertiesReader.readSaveDataRaw(mail, key, debug);
        try {
            ArrayList<String> saveProperties = new ArrayList<String>(gameStatus.keySet());
            Collections.sort(saveProperties);
            String currSave = newLine;
            for (String currProperty : saveProperties) {
                currSave = currSave + currProperty + "=" + gameStatus.get(currProperty) + newLine;
            }
            String newRawContent = rawContent.substring(0, rawContent.indexOf("$$$") + 3);
            rawContent = rawContent.substring(rawContent.indexOf("$$$") + 3);
            int numSaves = rawContent.split("###").length;
            if (position > numSaves) {
                numSaves = position;
            }
            for (int i = 0; i < numSaves; ++i) {
                if (i != position - 1) {
                    if (rawContent.replace(newLine, "").trim().equalsIgnoreCase("") || rawContent.split("###").length < i) {
                        newRawContent = newRawContent + "name=0" + newLine + "###";
                        continue;
                    }
                    if (rawContent.split("###").length == 1) {
                        newRawContent = newRawContent + rawContent + "###";
                        continue;
                    }
                    newRawContent = newRawContent + rawContent.split("###")[i] + "###";
                    continue;
                }
                newRawContent = newRawContent + currSave + "###";
            }
            newRawContent = newRawContent.substring(0, newRawContent.length() - 3);
            FileHandle file = Gdx.files.local("sp.sav");
            file.writeBytes(PropertiesReader.encrypt(newRawContent.getBytes(), PropertiesReader.getEncriptionKey(mail, key)), false);
            if (debug) {
                FileHandle fileDebug = Gdx.files.local("sp.savDebug");
                fileDebug.writeBytes(newRawContent.getBytes(), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteGame(Integer position, String mail, String key) {
        HashMap<String, String> emptySave = new HashMap<String, String>();
        emptySave.put("name", "0");
        PropertiesReader.saveGame(emptySave, position, mail, key, false);
    }

    public static HashMap<String, String> loadAchievements(String mail, String key, boolean debug) {
        String newLine = System.getProperty("line.separator");
        HashMap<String, String> achievements = new HashMap<String, String>();
        String rawContent = PropertiesReader.readSaveDataRaw(mail, key, debug);
        if (!rawContent.startsWith("$$$")) {
            String achievementsData = rawContent.substring(0, rawContent.indexOf("$$$"));
            for (String currAchievement : achievementsData.split(newLine)) {
                if (currAchievement.equalsIgnoreCase("")) continue;
                achievements.put(currAchievement.split("=")[0], currAchievement.split("=").length > 1 ? currAchievement.split("=")[1] : "");
            }
        }
        return achievements;
    }

    public static void saveAchievements(HashMap<String, String> achievements, String mail, String key, boolean debug) {
        String newLine = System.getProperty("line.separator");
        String rawContent = PropertiesReader.readSaveDataRaw(mail, key, debug);
        try {
            ArrayList<String> achievementsProperties = new ArrayList<String>(achievements.keySet());
            Collections.sort(achievementsProperties);
            String currAchievements = "";
            for (String currProperty : achievementsProperties) {
                currAchievements = currAchievements + currProperty + "=" + achievements.get(currProperty) + newLine;
            }
            String newRawContent = currAchievements + rawContent.substring(rawContent.indexOf("$$$"));
            FileHandle file = Gdx.files.local("sp.sav");
            file.writeBytes(PropertiesReader.encrypt(newRawContent.getBytes(), PropertiesReader.getEncriptionKey(mail, key)), false);
            if (debug) {
                FileHandle fileDebug = Gdx.files.local("sp.savDebug");
                fileDebug.writeBytes(newRawContent.getBytes(), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readSaveDataRaw(String mail, String key, boolean debug) {
        String rawContent = "";
        try {
            FileHandle file;
            if (debug) {
                file = Gdx.files.local("sp.savDebug");
                if (file == null || !file.exists()) {
                    file = Gdx.files.internal("sp.savDebug");
                }
                if (file != null && file.exists()) {
                    rawContent = new String(file.readBytes());
                }
            }
            if (rawContent.equalsIgnoreCase("")) {
                file = Gdx.files.local("sp.sav");
                if (file == null || !file.exists()) {
                    file = Gdx.files.internal("sp.sav");
                }
                if (file == null || !file.exists()) {
                    file = Gdx.files.local("sp.sav");
                    rawContent = "$$$";
                    file.writeBytes(PropertiesReader.encrypt(rawContent.getBytes(), PropertiesReader.getEncriptionKey(mail, key)), false);
                } else {
                    rawContent = new String(PropertiesReader.decrypt(file.readBytes(), PropertiesReader.getEncriptionKey(mail, key)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rawContent = "$$$";
        }
        return rawContent;
    }

    public static void writeSaveDataRaw(String mail, String key, String data, boolean debug) {
        try {
            if (debug) {
                FileHandle file = Gdx.files.local("sp.savDebug");
                file.writeBytes(PropertiesReader.encrypt(data.getBytes(), PropertiesReader.getEncriptionKey(mail, key)), false);
            } else {
                FileHandle file = Gdx.files.local("sp.sav");
                file.writeBytes(PropertiesReader.encrypt(data.getBytes(), PropertiesReader.getEncriptionKey(mail, key)), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] getEncriptionKey(String mail, String key) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return md.digest(new String(mail + key).getBytes());
    }

    private static byte[] encrypt(byte[] plainText, byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, secretKey);
        return cipher.doFinal(plainText);
    }

    private static byte[] decrypt(byte[] cipherText, byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, secretKey);
        return cipher.doFinal(cipherText);
    }
}

