/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.HttpParametersUtils;
import com.badlogic.gdx.net.HttpRequestBuilder;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.util.Logger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class NetworkPort {
    private SlavePitsGame game;
    private NetworkSocket networkSocket;
    int gamePort = 3700;
    DatagramSocket appSocket;
    byte[] receiveData = new byte[1024];
    byte[] sendData = new byte[1024];
    public String state = "none";
    public String serverName;
    public String pass;
    public String myIP;
    public InetAddress pairIP;
    public InetAddress tempIP;
    int tempPort = 3700;

    public NetworkPort(SlavePitsGame g) {
        this.game = g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handshake(String destIP, String password) {
        int result = 0;
        this.serverName = destIP;
        this.pass = password;
        this.myIP = NetworkPort.getDeviceIPAddress(true);
        try {
            this.appSocket = new DatagramSocket(this.gamePort);
            this.receiveData = new byte[1024];
            this.sendData = new byte[1024];
            this.networkSocket = new NetworkSocket();
            this.networkSocket.start();
            if (this.game.gameMode.equalsIgnoreCase("server")) {
                if (!NetworkPort.validateIP(destIP)) {
                    this.pairIP = InetAddress.getByName("calimasaga.com");
                    StringBuilder data = new StringBuilder();
                    data.append("h#");
                    data.append(this.serverName);
                    data.append("#");
                    data.append(this.myIP);
                    data.append("#");
                    data.append(this.pass);
                    this.sendData(data.toString());
                } else {
                    this.state = "connected";
                    this.pairIP = null;
                    Logger.write("EVENT", "NetworkPort.handshake server game created");
                }
            } else if (this.game.gameMode.equalsIgnoreCase("client")) {
                if (!NetworkPort.validateIP(destIP)) {
                    this.pairIP = InetAddress.getByName("calimasaga.com");
                    StringBuilder data = new StringBuilder();
                    data.append("c#");
                    data.append(this.serverName);
                    data.append("#");
                    data.append(this.myIP);
                    data.append("#");
                    data.append(this.pass);
                    this.sendData(data.toString());
                } else {
                    this.state = "connected";
                    this.pairIP = InetAddress.getByName(destIP);
                    this.sendData("j" + this.pass);
                    this.sendData("j" + this.pass);
                    this.sendData("j" + this.pass);
                    Logger.write("EVENT", "NetworkPort.handshake client handshake initiated");
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            result = -1;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            result = -1;
        }
        finally {
            if (result == -1) {
                if (this.networkSocket != null) {
                    this.networkSocket.terminate();
                }
                if (this.appSocket != null) {
                    this.appSocket.close();
                }
            }
        }
        return result;
    }

    public void sendData(String content) {
        this.sendPacket(content, this.pairIP, this.gamePort);
    }

    public void keepAlive() {
        if (this.state.equalsIgnoreCase("connected")) {
            try {
                this.sendPacket("keepAlive", InetAddress.getByName("calimasaga.com"), this.gamePort);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void receivePacket(DatagramPacket receivedPacket) {
        try {
            InetAddress IPAddress = receivedPacket.getAddress();
            int port = receivedPacket.getPort();
            String content = "";
            content = new String(receivedPacket.getData(), 0, receivedPacket.getLength(), "UTF-8");
            Logger.write(Logger.DEBUG, "NetworkPort.receivePacket " + content);
            if (this.state.equalsIgnoreCase("none")) {
                if (this.pairIP == null && content.equalsIgnoreCase("j" + this.pass)) {
                    this.pairIP = IPAddress;
                    this.gamePort = port;
                    this.sendData("a");
                    this.sendData("a");
                    this.sendData("a");
                    this.state = "setup";
                    this.game.multiplayerPlayerNameServer = "Host";
                    this.game.multiplayerPlayerNameClient = "Guest";
                    this.game.multiplayerInput = "";
                    Logger.write("EVENT", "NetworkPort.receivePacket server handshake accepted");
                } else if (content.startsWith("a")) {
                    this.state = "setup";
                    this.game.multiplayerPlayerNameServer = "Host";
                    this.game.multiplayerPlayerNameClient = "Guest";
                    this.game.multiplayerInput = "";
                } else if (content.startsWith("ok")) {
                    if (this.game.gameMode.equalsIgnoreCase("server")) {
                        this.state = "connected";
                        this.pairIP = null;
                        Logger.write("EVENT", "NetworkPort.receivePacket server game created");
                    } else {
                        this.state = "connected";
                        String[] connectionDetails = content.split("#");
                        this.pairIP = InetAddress.getByName(connectionDetails[1]);
                        this.gamePort = Integer.parseInt(connectionDetails[2]);
                        this.tempIP = InetAddress.getByName(connectionDetails[3]);
                        this.sendData("j" + this.pass);
                        this.sendData("j" + this.pass);
                        this.sendData("j" + this.pass);
                        this.sendPacket("j" + this.pass, this.tempIP, this.tempPort);
                        this.sendPacket("j" + this.pass, this.tempIP, this.tempPort);
                        this.sendPacket("j" + this.pass, this.tempIP, this.tempPort);
                        Logger.write("EVENT", "NetworkPort.receivePacket client handshake initiated");
                    }
                }
            } else if (this.state.equalsIgnoreCase("connected")) {
                if (content.equalsIgnoreCase("j" + this.pass)) {
                    this.pairIP = IPAddress;
                    this.gamePort = port;
                    this.sendData("a");
                    this.sendData("a");
                    this.sendData("a");
                    this.state = "setup";
                    this.game.multiplayerPlayerNameServer = "Host";
                    this.game.multiplayerPlayerNameClient = "Guest";
                    this.game.multiplayerInput = "";
                    Logger.write("EVENT", "NetworkPort.receivePacket server handshake accepted");
                } else if (content.startsWith("a")) {
                    this.pairIP = IPAddress;
                    this.gamePort = port;
                    this.state = "setup";
                    this.game.multiplayerPlayerNameServer = "Host";
                    this.game.multiplayerPlayerNameClient = "Guest";
                    this.game.multiplayerInput = "";
                } else if (this.game.gameMode.equalsIgnoreCase("server") && content.startsWith("sync")) {
                    String[] connectionDetails = content.split("#");
                    this.pairIP = InetAddress.getByName(connectionDetails[4]);
                    this.gamePort = Integer.parseInt(connectionDetails[5]);
                    this.tempIP = InetAddress.getByName(connectionDetails[6]);
                    this.sendData("sync");
                    this.sendData("sync");
                    this.sendData("sync");
                    this.sendPacket("sync", this.tempIP, this.tempPort);
                    this.sendPacket("sync", this.tempIP, this.tempPort);
                    this.sendPacket("sync", this.tempIP, this.tempPort);
                    Logger.write("EVENT", "NetworkPort.receivePacket server handshake initiated");
                }
            } else if (this.state.equalsIgnoreCase("setup") && this.pairIP != null && IPAddress != null && this.pairIP.getHostAddress().equalsIgnoreCase(IPAddress.getHostAddress())) {
                ((BaseScreen)this.game.getScreen()).receivedPacket(content);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    private void sendPacket(String rawContent, InetAddress destIP, int destPort) {
        try {
            if (destIP != null) {
                Logger.write(Logger.DEBUG, "NetworkPort.sendPacket " + destIP.getHostAddress() + " " + destPort + " " + rawContent);
                this.sendData = rawContent.getBytes("UTF-8");
                DatagramPacket sendPacket = new DatagramPacket(this.sendData, this.sendData.length, destIP, destPort);
                this.appSocket.send(sendPacket);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void terminate() {
        if (this.networkSocket != null) {
            this.networkSocket.terminate();
        }
        if (this.appSocket != null) {
            this.appSocket.close();
        }
    }

    public static boolean validateIP(String ip) {
        String PATTERN = "^((0|1\\d?\\d?|2[0-4]?\\d?|25[0-5]?|[3-9]\\d?)\\.){3}(0|1\\d?\\d?|2[0-4]?\\d?|25[0-5]?|[3-9]\\d?)$";
        return ip.matches(PATTERN);
    }

    public void sendHttpRequest(String method, String url, String content, Map<String, String> params) {
        Logger.write(Logger.DEBUG, "NetworkPort.sendHttpRequest " + url + " " + method);
        HttpRequestBuilder requestBuilder = new HttpRequestBuilder();
        requestBuilder.newRequest().method(method).url(url);
        if (method.equalsIgnoreCase("GET")) {
            if (!content.equalsIgnoreCase("")) {
                requestBuilder.content(content);
            }
        } else if (params != null) {
            requestBuilder.header("Content-Type", "application/x-www-form-urlencoded");
            requestBuilder.content(HttpParametersUtils.convertHttpParameters(params));
        }
        Net.HttpRequest httpRequest = requestBuilder.build();
        Gdx.net.sendHttpRequest(httpRequest, new httpResult());
    }

    private static String getDeviceIPAddress(boolean useIPv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    if (addr.isLoopbackAddress()) continue;
                    String sAddr = addr.getHostAddress().toUpperCase();
                    boolean isIPv4 = NetworkPort.validateIP(sAddr);
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return sAddr;
                    }
                    if (isIPv4) continue;
                    int delim = sAddr.indexOf(37);
                    return delim < 0 ? sAddr : sAddr.substring(0, delim);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "";
    }

    private class httpResult
    implements Net.HttpResponseListener {
        private httpResult() {
        }

        @Override
        public void handleHttpResponse(Net.HttpResponse httpResponse) {
            ((BaseScreen)NetworkPort.this.game.getScreen()).receivedHttpResponse(httpResponse);
        }

        @Override
        public void failed(Throwable t) {
            ((BaseScreen)NetworkPort.this.game.getScreen()).receivedHttpResponse(null);
        }

        @Override
        public void cancelled() {
            ((BaseScreen)NetworkPort.this.game.getScreen()).receivedHttpResponse(null);
        }
    }

    private class NetworkSocket
    extends Thread
    implements Runnable {
        private boolean running = true;

        public void terminate() {
            this.running = false;
        }

        @Override
        public void run() {
            while (this.running) {
                if (NetworkPort.this.appSocket == null || NetworkPort.this.appSocket.isClosed()) continue;
                DatagramPacket receivePacket = new DatagramPacket(NetworkPort.this.receiveData, NetworkPort.this.receiveData.length);
                try {
                    NetworkPort.this.appSocket.receive(receivePacket);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                NetworkPort.this.receivePacket(receivePacket);
            }
        }
    }
}

