/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.TournamentEventScreen;
import com.calimasaga.slavepits.screen.TournamentSetupScreen;
import com.calimasaga.slavepits.util.PropertiesReader;

public class TrainerMenuScreen
extends BaseScreen {
    private BaseScreen previousScreen;
    public Fighter fighter;
    public int profits;
    public boolean extProfit = false;
    public int maxLifeOrig;
    public int maxStaminaOrig;
    public int maxBalanceOrig;
    private NinePatchActor iconsBackground;
    public Label profitsLabel;
    public BaseActor lifeBarMax;
    public Label lifePercentage;
    public BaseActor staminaBarMax;
    public Label staminaPercentage;
    public BaseActor balanceBarMax;
    public Label balancePercentage;
    public Button buyLife;
    public Button buyStamina;
    public Button buyBalance;
    public Button cancelLife;
    public Button cancelStamina;
    public Button cancelBalance;
    private Button applyButton;
    private Button exitButton;

    public TrainerMenuScreen(SlavePitsGame g, BaseScreen s, Fighter selectedFighter, int leftProfits, boolean onlyFree) {
        super(g);
        this.previousScreen = s;
        this.fighter = Fighter.clone(selectedFighter, true);
        this.maxLifeOrig = this.fighter.maxLife;
        this.maxStaminaOrig = this.fighter.maxStamina;
        this.maxBalanceOrig = this.fighter.maxBalance;
        this.extProfit = onlyFree;
        if (!(this.previousScreen instanceof TournamentSetupScreen)) {
            if (this.extProfit) {
                this.profits = Integer.parseInt(g.saveGame.get("store")) * 50;
            } else {
                this.profits = leftProfits;
                if (g.saveGame.get("store") != null) {
                    this.profits += Integer.parseInt(g.saveGame.get("store")) * 50;
                }
            }
        }
        this.create();
    }

    @Override
    public void create() {
        this.iconsBackground = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.iconsBackground.setWidth(UIHelpers.calcWidthProportion(this.game, 50.0f, 80.0f).floatValue());
        this.iconsBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 30.0f, 30.0f).floatValue());
        this.iconsBackground.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 10.0f).floatValue());
        this.iconsBackground.setY(UIHelpers.calcHeightProportion(this.game, 32.5f, 32.5f).floatValue());
        this.stage.addActor(this.iconsBackground);
        this.profitsLabel = new Label("" + this.profits, this.game.uiSkin, "default");
        this.profitsLabel.setColor(this.game.uiSkin.get("iron", Color.class));
        this.profitsLabel.setAlignment(1);
        this.profitsLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue());
        this.profitsLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.profitsLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.profitsLabel.getWidth() / 2.0f);
        this.profitsLabel.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 90.0f / 100.0f - this.profitsLabel.getPrefHeight());
        this.stage.addActor(this.profitsLabel);
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        Label lifeLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "common.life", this.game.violenceFilter), this.game.uiSkin, "default");
        lifeLabel.setColor(this.game.uiSkin.get("lightiron", Color.class));
        lifeLabel.setAlignment(16);
        lifeLabel.setWidth(this.iconsBackground.getWidth() * 30.0f / 100.0f);
        lifeLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        lifeLabel.setX(this.iconsBackground.getX());
        lifeLabel.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 70.0f / 100.0f - lifeLabel.getPrefHeight());
        this.stage.addActor(lifeLabel);
        Label staminaLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "common.stamin", this.game.violenceFilter), this.game.uiSkin, "default");
        staminaLabel.setColor(this.game.uiSkin.get("lightiron", Color.class));
        staminaLabel.setAlignment(16);
        staminaLabel.setWidth(this.iconsBackground.getWidth() * 30.0f / 100.0f);
        staminaLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        staminaLabel.setX(this.iconsBackground.getX());
        staminaLabel.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 50.0f / 100.0f - staminaLabel.getPrefHeight());
        this.stage.addActor(staminaLabel);
        Label balanceLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "common.balanc", this.game.violenceFilter), this.game.uiSkin, "default");
        balanceLabel.setColor(this.game.uiSkin.get("lightiron", Color.class));
        balanceLabel.setAlignment(16);
        balanceLabel.setWidth(this.iconsBackground.getWidth() * 30.0f / 100.0f);
        balanceLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        balanceLabel.setX(this.iconsBackground.getX());
        balanceLabel.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 30.0f / 100.0f - balanceLabel.getPrefHeight());
        this.stage.addActor(balanceLabel);
        BaseActor lifeBar = new BaseActor();
        lifeBar.setTexture(uiAtlas.findRegion("statbar"), UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        lifeBar.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 35.0f / 100.0f);
        lifeBar.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 59.0f / 100.0f);
        this.stage.addActor(lifeBar);
        float barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue() * (float)this.fighter.maxLife / 10000.0f;
        this.lifeBarMax = new BaseActor();
        this.lifeBarMax.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.lifeBarMax.getColor().a = 0.4f;
        this.lifeBarMax.setWidth(barWidth);
        this.lifeBarMax.regionWidth = Float.valueOf((float)(200 * this.fighter.maxLife) / 10000.0f).intValue();
        this.lifeBarMax.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 35.0f / 100.0f);
        this.lifeBarMax.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 59.0f / 100.0f);
        this.stage.addActor(this.lifeBarMax);
        BaseActor currentLifeBar = new BaseActor();
        currentLifeBar.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        currentLifeBar.setWidth(barWidth);
        currentLifeBar.regionWidth = Float.valueOf((float)(200 * this.fighter.life) / 10000.0f).intValue();
        currentLifeBar.setColor(1.0f, 0.0f, 0.0f, 1.0f);
        currentLifeBar.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 35.0f / 100.0f);
        currentLifeBar.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 59.0f / 100.0f);
        this.stage.addActor(currentLifeBar);
        BaseActor staminaBar = new BaseActor();
        staminaBar.setTexture(uiAtlas.findRegion("statbar"), UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        staminaBar.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 35.0f / 100.0f);
        staminaBar.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 39.0f / 100.0f);
        this.stage.addActor(staminaBar);
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue() * (float)this.fighter.maxStamina / 10000.0f;
        this.staminaBarMax = new BaseActor();
        this.staminaBarMax.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.staminaBarMax.getColor().a = 0.4f;
        this.staminaBarMax.setWidth(barWidth);
        this.staminaBarMax.regionWidth = Float.valueOf((float)(200 * this.fighter.maxStamina) / 10000.0f).intValue();
        this.staminaBarMax.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 35.0f / 100.0f);
        this.staminaBarMax.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 39.0f / 100.0f);
        this.stage.addActor(this.staminaBarMax);
        BaseActor currentStaminaBar = new BaseActor();
        currentStaminaBar.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        currentStaminaBar.setWidth(barWidth);
        currentStaminaBar.regionWidth = Float.valueOf((float)(200 * this.fighter.stamina) / 10000.0f).intValue();
        currentStaminaBar.setColor(1.0f, 1.0f, 0.0f, 1.0f);
        currentStaminaBar.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 35.0f / 100.0f);
        currentStaminaBar.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 39.0f / 100.0f);
        this.stage.addActor(currentStaminaBar);
        BaseActor balanceBar = new BaseActor();
        balanceBar.setTexture(uiAtlas.findRegion("statbar"), UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        balanceBar.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 35.0f / 100.0f);
        balanceBar.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 19.0f / 100.0f);
        this.stage.addActor(balanceBar);
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue() * (float)this.fighter.maxBalance / 10000.0f;
        this.balanceBarMax = new BaseActor();
        this.balanceBarMax.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.balanceBarMax.getColor().a = 0.4f;
        this.balanceBarMax.setWidth(barWidth);
        this.balanceBarMax.regionWidth = Float.valueOf((float)(200 * this.fighter.maxBalance) / 10000.0f).intValue();
        this.balanceBarMax.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 35.0f / 100.0f);
        this.balanceBarMax.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 19.0f / 100.0f);
        this.stage.addActor(this.balanceBarMax);
        BaseActor currentBalanceBar = new BaseActor();
        currentBalanceBar.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 18.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        currentBalanceBar.setWidth(barWidth);
        currentBalanceBar.regionWidth = Float.valueOf((float)(200 * this.fighter.balance) / 10000.0f).intValue();
        currentBalanceBar.setColor(0.0f, 1.0f, 0.0f, 1.0f);
        currentBalanceBar.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 35.0f / 100.0f);
        currentBalanceBar.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 19.0f / 100.0f);
        this.stage.addActor(currentBalanceBar);
        this.lifePercentage = new Label(this.fighter.maxLife / 100 + "%", this.game.uiSkin, "default");
        this.lifePercentage.setColor(new Color(1.0f, 0.0f, 0.0f, 1.0f));
        this.lifePercentage.setAlignment(8);
        this.lifePercentage.setWidth(UIHelpers.calcWidthProportion(this.game, 8.0f, 12.0f).floatValue());
        this.lifePercentage.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.lifePercentage.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 68.0f / 100.0f);
        this.lifePercentage.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 70.0f / 100.0f - this.lifePercentage.getPrefHeight());
        this.stage.addActor(this.lifePercentage);
        this.staminaPercentage = new Label(this.fighter.maxStamina / 100 + "%", this.game.uiSkin, "default");
        this.staminaPercentage.setColor(new Color(1.0f, 1.0f, 0.0f, 1.0f));
        this.staminaPercentage.setAlignment(8);
        this.staminaPercentage.setWidth(UIHelpers.calcWidthProportion(this.game, 8.0f, 12.0f).floatValue());
        this.staminaPercentage.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.staminaPercentage.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 68.0f / 100.0f);
        this.staminaPercentage.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 50.0f / 100.0f - this.staminaPercentage.getPrefHeight());
        this.stage.addActor(this.staminaPercentage);
        this.balancePercentage = new Label(this.fighter.maxBalance / 100 + "%", this.game.uiSkin, "default");
        this.balancePercentage.setColor(new Color(0.0f, 1.0f, 0.0f, 1.0f));
        this.balancePercentage.setAlignment(8);
        this.balancePercentage.setWidth(UIHelpers.calcWidthProportion(this.game, 8.0f, 12.0f).floatValue());
        this.balancePercentage.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.balancePercentage.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 68.0f / 100.0f);
        this.balancePercentage.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 30.0f / 100.0f - this.balancePercentage.getPrefHeight());
        this.stage.addActor(this.balancePercentage);
        this.buyLife = new Button(this.game.uiSkin, "add");
        this.buyLife.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TrainerMenuScreen.this.fighter.maxLife += 500;
                TrainerMenuScreen.this.profits = TrainerMenuScreen.this.profits - 100 * (TrainerMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(TrainerMenuScreen.this.game, "legkil") : 100) / 100;
                float barWidth = UIHelpers.calcHeightProportion(TrainerMenuScreen.this.game, 20.0f, 18.0f).floatValue() * (float)TrainerMenuScreen.this.fighter.maxLife / 10000.0f;
                TrainerMenuScreen.this.lifeBarMax.setWidth(barWidth);
                TrainerMenuScreen.this.lifeBarMax.regionWidth = Float.valueOf((float)(200 * TrainerMenuScreen.this.fighter.maxLife) / 10000.0f).intValue();
                TrainerMenuScreen.this.lifePercentage.setText(TrainerMenuScreen.this.fighter.maxLife / 100 + "%");
                TrainerMenuScreen.this.profitsLabel.setText("" + TrainerMenuScreen.this.profits);
                TrainerMenuScreen.this.game.manager.get(TrainerMenuScreen.this.game.getOverridenAsset("sound/talent.ogg"), Sound.class).play(TrainerMenuScreen.this.game.soundVolume);
                TrainerMenuScreen.this.buyLife.setVisible(TrainerMenuScreen.this.fighter.maxLife < 10000 && TrainerMenuScreen.this.profits >= 100);
                TrainerMenuScreen.this.buyStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.buyBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.cancelLife.setVisible(TrainerMenuScreen.this.fighter.maxLife > TrainerMenuScreen.this.maxLifeOrig);
                TrainerMenuScreen.this.cancelStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina > TrainerMenuScreen.this.maxStaminaOrig);
                TrainerMenuScreen.this.cancelBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance > TrainerMenuScreen.this.maxBalanceOrig);
            }
        });
        this.buyLife.setVisible(this.fighter.maxLife < 10000 && this.profits >= 100);
        this.buyLife.setWidth(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.buyLife.setHeight(this.buyLife.getWidth());
        this.buyLife.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 78.0f / 100.0f);
        this.buyLife.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 58.0f / 100.0f);
        this.stage.addActor(this.buyLife);
        this.cancelLife = new Button(this.game.uiSkin, "remove");
        this.cancelLife.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TrainerMenuScreen.this.fighter.maxLife -= 500;
                TrainerMenuScreen.this.profits = TrainerMenuScreen.this.profits + 100 * (TrainerMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(TrainerMenuScreen.this.game, "legkil") : 100) / 100;
                float barWidth = UIHelpers.calcHeightProportion(TrainerMenuScreen.this.game, 20.0f, 18.0f).floatValue() * (float)TrainerMenuScreen.this.fighter.maxLife / 10000.0f;
                TrainerMenuScreen.this.lifeBarMax.setWidth(barWidth);
                TrainerMenuScreen.this.lifeBarMax.regionWidth = Float.valueOf((float)(200 * TrainerMenuScreen.this.fighter.maxLife) / 10000.0f).intValue();
                TrainerMenuScreen.this.lifePercentage.setText(TrainerMenuScreen.this.fighter.maxLife / 100 + "%");
                TrainerMenuScreen.this.profitsLabel.setText("" + TrainerMenuScreen.this.profits);
                TrainerMenuScreen.this.game.manager.get(TrainerMenuScreen.this.game.getOverridenAsset("sound/talent.ogg"), Sound.class).play(TrainerMenuScreen.this.game.soundVolume);
                TrainerMenuScreen.this.buyLife.setVisible(TrainerMenuScreen.this.fighter.maxLife < 10000 && TrainerMenuScreen.this.profits >= 100);
                TrainerMenuScreen.this.buyStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.buyBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.cancelLife.setVisible(TrainerMenuScreen.this.fighter.maxLife > TrainerMenuScreen.this.maxLifeOrig);
                TrainerMenuScreen.this.cancelStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina > TrainerMenuScreen.this.maxStaminaOrig);
                TrainerMenuScreen.this.cancelBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance > TrainerMenuScreen.this.maxBalanceOrig);
            }
        });
        this.cancelLife.setVisible(this.fighter.maxLife < 10000 && this.profits >= 100);
        this.cancelLife.setWidth(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.cancelLife.setHeight(this.buyLife.getWidth());
        this.cancelLife.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 86.0f / 100.0f);
        this.cancelLife.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 58.0f / 100.0f);
        this.cancelLife.setVisible(false);
        this.stage.addActor(this.cancelLife);
        this.buyStamina = new Button(this.game.uiSkin, "add");
        this.buyStamina.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TrainerMenuScreen.this.fighter.maxStamina += 500;
                TrainerMenuScreen.this.profits = TrainerMenuScreen.this.profits - 50 * (TrainerMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(TrainerMenuScreen.this.game, "legkil") : 100) / 100;
                float barWidth = UIHelpers.calcHeightProportion(TrainerMenuScreen.this.game, 20.0f, 18.0f).floatValue() * (float)TrainerMenuScreen.this.fighter.maxStamina / 10000.0f;
                TrainerMenuScreen.this.staminaBarMax.setWidth(barWidth);
                TrainerMenuScreen.this.staminaBarMax.regionWidth = Float.valueOf((float)(200 * TrainerMenuScreen.this.fighter.maxStamina) / 10000.0f).intValue();
                TrainerMenuScreen.this.staminaPercentage.setText(TrainerMenuScreen.this.fighter.maxStamina / 100 + "%");
                TrainerMenuScreen.this.profitsLabel.setText("" + TrainerMenuScreen.this.profits);
                TrainerMenuScreen.this.game.manager.get(TrainerMenuScreen.this.game.getOverridenAsset("sound/talent.ogg"), Sound.class).play(TrainerMenuScreen.this.game.soundVolume);
                TrainerMenuScreen.this.buyLife.setVisible(TrainerMenuScreen.this.fighter.maxLife < 10000 && TrainerMenuScreen.this.profits >= 100);
                TrainerMenuScreen.this.buyStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.buyBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.cancelLife.setVisible(TrainerMenuScreen.this.fighter.maxLife > TrainerMenuScreen.this.maxLifeOrig);
                TrainerMenuScreen.this.cancelStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina > TrainerMenuScreen.this.maxStaminaOrig);
                TrainerMenuScreen.this.cancelBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance > TrainerMenuScreen.this.maxBalanceOrig);
            }
        });
        this.buyStamina.setVisible(this.fighter.maxStamina < 10000 && this.profits >= 50);
        this.buyStamina.setWidth(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.buyStamina.setHeight(this.buyStamina.getWidth());
        this.buyStamina.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 78.0f / 100.0f);
        this.buyStamina.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 38.0f / 100.0f);
        this.stage.addActor(this.buyStamina);
        this.cancelStamina = new Button(this.game.uiSkin, "remove");
        this.cancelStamina.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TrainerMenuScreen.this.fighter.maxStamina -= 500;
                TrainerMenuScreen.this.profits = TrainerMenuScreen.this.profits + 50 * (TrainerMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(TrainerMenuScreen.this.game, "legkil") : 100) / 100;
                float barWidth = UIHelpers.calcHeightProportion(TrainerMenuScreen.this.game, 20.0f, 18.0f).floatValue() * (float)TrainerMenuScreen.this.fighter.maxStamina / 10000.0f;
                TrainerMenuScreen.this.staminaBarMax.setWidth(barWidth);
                TrainerMenuScreen.this.staminaBarMax.regionWidth = Float.valueOf((float)(200 * TrainerMenuScreen.this.fighter.maxStamina) / 10000.0f).intValue();
                TrainerMenuScreen.this.staminaPercentage.setText(TrainerMenuScreen.this.fighter.maxStamina / 100 + "%");
                TrainerMenuScreen.this.profitsLabel.setText("" + TrainerMenuScreen.this.profits);
                TrainerMenuScreen.this.game.manager.get(TrainerMenuScreen.this.game.getOverridenAsset("sound/talent.ogg"), Sound.class).play(TrainerMenuScreen.this.game.soundVolume);
                TrainerMenuScreen.this.buyLife.setVisible(TrainerMenuScreen.this.fighter.maxLife < 10000 && TrainerMenuScreen.this.profits >= 100);
                TrainerMenuScreen.this.buyStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.buyBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.cancelLife.setVisible(TrainerMenuScreen.this.fighter.maxLife > TrainerMenuScreen.this.maxLifeOrig);
                TrainerMenuScreen.this.cancelStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina > TrainerMenuScreen.this.maxStaminaOrig);
                TrainerMenuScreen.this.cancelBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance > TrainerMenuScreen.this.maxBalanceOrig);
            }
        });
        this.cancelStamina.setVisible(this.fighter.maxLife < 10000 && this.profits >= 100);
        this.cancelStamina.setWidth(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.cancelStamina.setHeight(this.buyLife.getWidth());
        this.cancelStamina.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 86.0f / 100.0f);
        this.cancelStamina.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 38.0f / 100.0f);
        this.cancelStamina.setVisible(false);
        this.stage.addActor(this.cancelStamina);
        this.buyBalance = new Button(this.game.uiSkin, "add");
        this.buyBalance.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TrainerMenuScreen.this.fighter.maxBalance += 500;
                TrainerMenuScreen.this.profits = TrainerMenuScreen.this.profits - 50 * (TrainerMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(TrainerMenuScreen.this.game, "legkil") : 100) / 100;
                float barWidth = UIHelpers.calcHeightProportion(TrainerMenuScreen.this.game, 20.0f, 18.0f).floatValue() * (float)TrainerMenuScreen.this.fighter.maxBalance / 10000.0f;
                TrainerMenuScreen.this.balanceBarMax.setWidth(barWidth);
                TrainerMenuScreen.this.balanceBarMax.regionWidth = Float.valueOf((float)(200 * TrainerMenuScreen.this.fighter.maxBalance) / 10000.0f).intValue();
                TrainerMenuScreen.this.balancePercentage.setText(TrainerMenuScreen.this.fighter.maxBalance / 100 + "%");
                TrainerMenuScreen.this.profitsLabel.setText("" + TrainerMenuScreen.this.profits);
                TrainerMenuScreen.this.game.manager.get(TrainerMenuScreen.this.game.getOverridenAsset("sound/talent.ogg"), Sound.class).play(TrainerMenuScreen.this.game.soundVolume);
                TrainerMenuScreen.this.buyLife.setVisible(TrainerMenuScreen.this.fighter.maxLife < 10000 && TrainerMenuScreen.this.profits >= 100);
                TrainerMenuScreen.this.buyStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.buyBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.cancelLife.setVisible(TrainerMenuScreen.this.fighter.maxLife > TrainerMenuScreen.this.maxLifeOrig);
                TrainerMenuScreen.this.cancelStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina > TrainerMenuScreen.this.maxStaminaOrig);
                TrainerMenuScreen.this.cancelBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance > TrainerMenuScreen.this.maxBalanceOrig);
            }
        });
        this.buyBalance.setVisible(this.fighter.maxBalance < 10000 && this.profits >= 50);
        this.buyBalance.setWidth(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.buyBalance.setHeight(this.buyBalance.getWidth());
        this.buyBalance.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 78.0f / 100.0f);
        this.buyBalance.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 18.0f / 100.0f);
        this.stage.addActor(this.buyBalance);
        this.cancelBalance = new Button(this.game.uiSkin, "remove");
        this.cancelBalance.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TrainerMenuScreen.this.fighter.maxBalance -= 500;
                TrainerMenuScreen.this.profits = TrainerMenuScreen.this.profits + 50 * (TrainerMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(TrainerMenuScreen.this.game, "legkil") : 100) / 100;
                float barWidth = UIHelpers.calcHeightProportion(TrainerMenuScreen.this.game, 20.0f, 18.0f).floatValue() * (float)TrainerMenuScreen.this.fighter.maxBalance / 10000.0f;
                TrainerMenuScreen.this.balanceBarMax.setWidth(barWidth);
                TrainerMenuScreen.this.balanceBarMax.regionWidth = Float.valueOf((float)(200 * TrainerMenuScreen.this.fighter.maxBalance) / 10000.0f).intValue();
                TrainerMenuScreen.this.balancePercentage.setText(TrainerMenuScreen.this.fighter.maxBalance / 100 + "%");
                TrainerMenuScreen.this.profitsLabel.setText("" + TrainerMenuScreen.this.profits);
                TrainerMenuScreen.this.game.manager.get(TrainerMenuScreen.this.game.getOverridenAsset("sound/talent.ogg"), Sound.class).play(TrainerMenuScreen.this.game.soundVolume);
                TrainerMenuScreen.this.buyLife.setVisible(TrainerMenuScreen.this.fighter.maxLife < 10000 && TrainerMenuScreen.this.profits >= 100);
                TrainerMenuScreen.this.buyStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.buyBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance < 10000 && TrainerMenuScreen.this.profits >= 50);
                TrainerMenuScreen.this.cancelLife.setVisible(TrainerMenuScreen.this.fighter.maxLife > TrainerMenuScreen.this.maxLifeOrig);
                TrainerMenuScreen.this.cancelStamina.setVisible(TrainerMenuScreen.this.fighter.maxStamina > TrainerMenuScreen.this.maxStaminaOrig);
                TrainerMenuScreen.this.cancelBalance.setVisible(TrainerMenuScreen.this.fighter.maxBalance > TrainerMenuScreen.this.maxBalanceOrig);
            }
        });
        this.cancelBalance.setVisible(this.fighter.maxLife < 10000 && this.profits >= 100);
        this.cancelBalance.setWidth(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.cancelBalance.setHeight(this.buyLife.getWidth());
        this.cancelBalance.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 86.0f / 100.0f);
        this.cancelBalance.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 18.0f / 100.0f);
        this.cancelBalance.setVisible(false);
        this.stage.addActor(this.cancelBalance);
        this.applyButton = new Button(this.game.uiSkin, "ok");
        this.applyButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (TrainerMenuScreen.this.previousScreen instanceof TournamentEventScreen) {
                    TrainerMenuScreen.this.game.campaignFighter.maxLife = TrainerMenuScreen.this.fighter.maxLife;
                    TrainerMenuScreen.this.game.campaignFighter.maxStamina = TrainerMenuScreen.this.fighter.maxStamina;
                    TrainerMenuScreen.this.game.campaignFighter.maxBalance = TrainerMenuScreen.this.fighter.maxBalance;
                    if (!TrainerMenuScreen.this.extProfit) {
                        if (TrainerMenuScreen.this.game.saveGame.get("store") == null) {
                            TrainerMenuScreen.this.game.saveGame.put("profits", "" + TrainerMenuScreen.this.profits);
                        } else if (TrainerMenuScreen.this.profits > Integer.parseInt(TrainerMenuScreen.this.game.saveGame.get("profits"))) {
                            TrainerMenuScreen.this.game.saveGame.put("store", "" + (TrainerMenuScreen.this.profits - Integer.parseInt(TrainerMenuScreen.this.game.saveGame.get("profits"))) / 50);
                        } else {
                            TrainerMenuScreen.this.game.saveGame.put("store", "0");
                            TrainerMenuScreen.this.game.saveGame.put("profits", "" + TrainerMenuScreen.this.profits);
                        }
                    } else {
                        TrainerMenuScreen.this.game.saveGame.put("store", "" + TrainerMenuScreen.this.profits / 50);
                    }
                }
                TrainerMenuScreen.this.game.setScreen(TrainerMenuScreen.this.previousScreen);
                TrainerMenuScreen.this.dispose();
            }
        });
        this.applyButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.applyButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.applyButton.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - this.applyButton.getPrefWidth());
        this.applyButton.setY(UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
        this.stage.addActor(this.applyButton);
        this.exitButton = new Button(this.game.uiSkin, "cancel");
        this.exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TrainerMenuScreen.this.game.setScreen(TrainerMenuScreen.this.previousScreen);
                TrainerMenuScreen.this.dispose();
            }
        });
        this.exitButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.exitButton.setY(UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
        this.stage.addActor(this.exitButton);
    }

    @Override
    public void render(float delta) {
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }
}

