/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.DuelSetupScreen;
import com.calimasaga.slavepits.screen.PrepSetupScreen;
import com.calimasaga.slavepits.screen.TournamentEventScreen;
import com.calimasaga.slavepits.screen.TournamentSetupScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class TalentsMenuScreen
extends BaseScreen {
    private BaseScreen previousScreen;
    private FrameBuffer frameBufferLights;
    public boolean changeFrameBuffer;
    public Label reputationLabel;
    public Fighter fighter;
    public HashMap<String, Integer> talentsOrig;
    public String fighterType;
    public int maxReputation = 0;
    public int profits = 0;
    public boolean extProfit = false;
    private HashMap<String, ArrayList<BaseActor>> talentMap = new HashMap();
    private Label showLabel;
    private Button showButton;
    private Button applyButton;
    private Button exitButton;
    private Label tooltipText;
    private NinePatchActor tooltip;
    private Button tooltipButton;
    private String selectedTalent;
    private Boolean selectedHasRequisites;

    public TalentsMenuScreen(SlavePitsGame g, BaseScreen s, Fighter selectedFighter, String type, int reputationLimit, int leftProfits, boolean onlyFree) {
        super(g);
        this.previousScreen = s;
        this.fighter = Fighter.clone(selectedFighter, true);
        this.talentsOrig = new HashMap();
        for (String currKey : this.fighter.talents.keySet()) {
            this.talentsOrig.put(currKey, this.fighter.talents.get(currKey));
        }
        this.extProfit = onlyFree;
        if (!(this.previousScreen instanceof TournamentSetupScreen)) {
            if (this.extProfit) {
                this.profits = Integer.parseInt(g.saveGame.get("store")) * 100;
            } else {
                this.profits = leftProfits;
                if (g.saveGame.get("store") != null) {
                    this.profits += Integer.parseInt(g.saveGame.get("store")) * 100;
                }
            }
        }
        this.fighterType = type;
        this.maxReputation = reputationLimit;
        this.create();
    }

    @Override
    public void create() {
        BaseActor background = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, background, this.game.getOverridenFilename("data/backgrounds/talentsbackground.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.stage.addActor(background);
        background = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, background, this.game.getOverridenFilename("data/backgrounds/talentslevelsbackground.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.stage.addActor(background);
        StringBuilder reputationText = new StringBuilder();
        if (this.profits > 0) {
            reputationText.append("[#FF0000]");
            reputationText.append(this.fighter.reputation);
            reputationText.append(" [#999487]");
            reputationText.append(this.profits);
        } else {
            reputationText.append("[#FF0000]");
            reputationText.append(this.fighter.reputation);
            reputationText.append(" / ");
            reputationText.append(this.maxReputation == 0 ? "-" : Integer.valueOf(this.maxReputation));
        }
        this.reputationLabel = new Label(reputationText, this.game.uiSkin, "default");
        this.reputationLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.reputationLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.reputationLabel.setAlignment(1);
        this.reputationLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue());
        this.reputationLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.reputationLabel.getWidth() / 2.0f);
        this.reputationLabel.setY(UIHelpers.calcHeightProportion(this.game, 99.0f, 99.0f).floatValue() - this.reputationLabel.getPrefHeight());
        this.showButton = new Button(this.game.uiSkin, "check");
        this.showButton.setWidth(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.showButton.setHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.showButton.setX(this.game.viewWidth.floatValue() - UIHelpers.calcWidthProportion(this.game, 1.0f, 1.0f).floatValue() - this.showButton.getWidth());
        this.showButton.setY(UIHelpers.calcHeightProportion(this.game, 99.5f, 99.5f).floatValue() - this.showButton.getHeight());
        if (this.game.gameMode.equalsIgnoreCase("story")) {
            this.showButton.setChecked(false);
        } else {
            this.showButton.setChecked(true);
        }
        this.showButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TalentsMenuScreen.this.checkKnownTalents(false);
            }
        });
        this.stage.addActor(this.showButton);
        this.showLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "common.show.all"), this.game.uiSkin, "default");
        this.showLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.showLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.showLabel.setAlignment(16);
        this.showLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue());
        this.showLabel.setX(this.showButton.getX() - UIHelpers.calcWidthProportion(this.game, 0.5f, 0.5f).floatValue() - this.reputationLabel.getWidth());
        this.showLabel.setY(UIHelpers.calcHeightProportion(this.game, 99.0f, 99.0f).floatValue() - this.showLabel.getPrefHeight());
        this.frameBufferLights = new FrameBuffer(Pixmap.Format.RGBA8888, this.game.viewWidth.intValue(), this.game.viewHeight.intValue(), true);
        this.changeFrameBuffer = true;
        TextureAtlas talentAtlas = this.game.manager.get(this.game.getOverridenAsset("data/talents/talents.atlas"), TextureAtlas.class);
        TextureAtlas misceffectsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/misceffects.atlas"), TextureAtlas.class);
        float ratio = UIHelpers.calcHeightProportion(this.game, 37.5f, 35.0f).floatValue() / 370.0f;
        float talentSize = ratio * 47.0f;
        for (String currTalent : this.game.stats.get("talents").keySet()) {
            if ((currTalent.contains(":") || this.fighter.talentsBlocked.get(currTalent) != null) && (!currTalent.contains(":") || this.fighter.talentsBlocked.get(currTalent.subSequence(0, 1)) != null && this.fighter.talentsBlocked.get(currTalent.subSequence(0, 1)) <= Integer.parseInt(currTalent.substring(2, 3)))) continue;
            JSONObject currObjTalent = (JSONObject)this.game.stats.get("talents").get(currTalent);
            float currTalentX = Float.parseFloat(currObjTalent.getString("xPos"));
            float currTalentY = Float.parseFloat(currObjTalent.getString("yPos"));
            BaseActor currTalentFrame = new BaseActor();
            ArrayList<BaseActor> talentStack = new ArrayList<BaseActor>();
            currTalentFrame.setTexture(talentAtlas.findRegion("talenticonframe"), talentSize, talentSize);
            currTalentFrame.setPosition(currTalentX * ratio + this.game.viewWidth.floatValue() / 2.0f - currTalentFrame.getWidth() / 2.0f, currTalentY * ratio + this.game.viewHeight.floatValue() / 2.0f + talentSize - currTalentFrame.getWidth() / 2.0f);
            currTalentFrame.params.put("talent", currTalent);
            currTalentFrame.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent ev, float x, float y, int pointer, int button) {
                    BaseActor eventActor = (BaseActor)ev.getListenerActor();
                    if (!TalentsMenuScreen.this.game.input.equalsIgnoreCase("keyboard")) {
                        if (TalentsMenuScreen.this.tooltip.isVisible()) {
                            TalentsMenuScreen.this.tooltipText.setText("");
                            TalentsMenuScreen.this.tooltip.setVisible(false);
                            TalentsMenuScreen.this.tooltipButton.setVisible(false);
                        } else {
                            TalentsMenuScreen.this.showTalentInfo(eventActor);
                        }
                    } else {
                        TalentsMenuScreen.this.checkTalent((String)eventActor.params.get("talent"), (Boolean)eventActor.params.get("hasRequisites"));
                    }
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    if (TalentsMenuScreen.this.game.input.equalsIgnoreCase("keyboard")) {
                        TalentsMenuScreen.this.showTalentInfo((BaseActor)event.getListenerActor());
                    }
                }

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                    if (TalentsMenuScreen.this.game.input.equalsIgnoreCase("keyboard")) {
                        TalentsMenuScreen.this.tooltipText.setText("");
                        TalentsMenuScreen.this.tooltip.setVisible(false);
                        TalentsMenuScreen.this.tooltipButton.setVisible(false);
                    }
                }
            });
            currTalentFrame.setVisible(currTalent.contains(":") || this.showButton.isChecked() || this.hasRequisites(currTalent));
            this.stage.addActor(currTalentFrame);
            talentStack.add(currTalentFrame);
            BaseActor currTalentIcon = new BaseActor();
            currTalentIcon.setTexture(talentAtlas.findRegion(currObjTalent.getString("imagePrefix")), talentSize * 3.0f / 5.0f, talentSize * 3.0f / 5.0f);
            currTalentIcon.setColor(Color.valueOf(currObjTalent.getString("color")));
            currTalentIcon.setPosition(currTalentX * ratio + this.game.viewWidth.floatValue() / 2.0f - currTalentIcon.getWidth() / 2.0f, currTalentY * ratio + this.game.viewHeight.floatValue() / 2.0f + talentSize - currTalentIcon.getWidth() / 2.0f);
            talentStack.add(currTalentIcon);
            float lightRatio = 1.0f;
            if (currTalent.contains(":")) {
                lightRatio += 0.2f * Float.parseFloat(currTalent.split(":")[1]);
            }
            BaseActor currTalentIconBackground = new BaseActor();
            currTalentIconBackground.setTexture(talentAtlas.findRegion("talenticonbackground"), talentSize * 2.0f * lightRatio, talentSize * 2.0f * lightRatio);
            currTalentIconBackground.setPosition(currTalentX * ratio + this.game.viewWidth.floatValue() / 2.0f - currTalentIconBackground.getWidth() / 2.0f, currTalentY * ratio + this.game.viewHeight.floatValue() / 2.0f + talentSize - currTalentIconBackground.getWidth() / 2.0f);
            currTalentIconBackground.setVisible(false);
            talentStack.add(currTalentIconBackground);
            BaseActor currTalentIconLight = new BaseActor();
            currTalentIconLight.setTexture(misceffectsAtlas.findRegion("light2"), talentSize * 3.0f * lightRatio, talentSize * 3.0f * lightRatio);
            currTalentIconLight.setPosition(currTalentX * ratio + this.game.viewWidth.floatValue() / 2.0f - currTalentIconLight.getWidth() / 2.0f, currTalentY * ratio + this.game.viewHeight.floatValue() / 2.0f + talentSize - currTalentIconLight.getWidth() / 2.0f);
            currTalentIconLight.setVisible(false);
            talentStack.add(currTalentIconLight);
            this.talentMap.put(currTalent, talentStack);
        }
        this.checkKnownTalents(false);
        this.tooltipText = new Label("", this.game.uiSkin, "default");
        this.tooltipText.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.tooltipText.setAlignment(10);
        this.tooltipText.setColor(new Color(0.75f, 0.75f, 0.75f, 1.0f));
        this.tooltipText.setWrap(true);
        this.tooltipText.setWidth(UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue());
        this.tooltipText.setVisible(false);
        this.tooltip = new NinePatchActor(this.game.uiSkin.get("scrollpanel", NinePatch.class));
        this.tooltip.setWidth(UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue());
        this.tooltip.setHeight(UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue());
        this.tooltip.setVisible(false);
        this.tooltip.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TalentsMenuScreen.this.tooltipText.setText("");
                TalentsMenuScreen.this.tooltip.setVisible(false);
                TalentsMenuScreen.this.tooltipButton.setVisible(false);
            }
        });
        this.stage.addActor(this.tooltip);
        this.tooltipButton = new Button(this.game.uiSkin, "talentmenu");
        this.tooltipButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TalentsMenuScreen.this.checkTalent(TalentsMenuScreen.this.selectedTalent, TalentsMenuScreen.this.selectedHasRequisites);
                TalentsMenuScreen.this.tooltipText.setText("");
                TalentsMenuScreen.this.tooltip.setVisible(false);
                TalentsMenuScreen.this.tooltipButton.setVisible(false);
            }
        });
        this.tooltipButton.setWidth(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.tooltipButton.setHeight(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.tooltipButton.setVisible(false);
        this.stage.addActor(this.tooltipButton);
        if (!(this.previousScreen instanceof TournamentSetupScreen)) {
            this.applyButton = new Button(this.game.uiSkin, "ok");
            this.applyButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (TalentsMenuScreen.this.previousScreen instanceof DuelSetupScreen) {
                        if (TalentsMenuScreen.this.fighterType.equalsIgnoreCase("host")) {
                            ((DuelSetupScreen)((TalentsMenuScreen)TalentsMenuScreen.this).previousScreen).hostFighter = TalentsMenuScreen.this.fighter;
                            ((DuelSetupScreen)((TalentsMenuScreen)TalentsMenuScreen.this).previousScreen).reputationP1.setText(TalentsMenuScreen.this.fighter.reputation + " / " + (TalentsMenuScreen.this.maxReputation == 0 ? "-" : Integer.valueOf(TalentsMenuScreen.this.maxReputation)));
                        } else {
                            ((DuelSetupScreen)((TalentsMenuScreen)TalentsMenuScreen.this).previousScreen).clientFighter = TalentsMenuScreen.this.fighter;
                            ((DuelSetupScreen)((TalentsMenuScreen)TalentsMenuScreen.this).previousScreen).reputationP2.setText(TalentsMenuScreen.this.fighter.reputation + " / " + (TalentsMenuScreen.this.maxReputation == 0 ? "-" : Integer.valueOf(TalentsMenuScreen.this.maxReputation)));
                        }
                        ((DuelSetupScreen)TalentsMenuScreen.this.previousScreen).sendMessage("change", "");
                    } else if (TalentsMenuScreen.this.previousScreen instanceof PrepSetupScreen) {
                        ((PrepSetupScreen)((TalentsMenuScreen)TalentsMenuScreen.this).previousScreen).hostFighter.reputation = TalentsMenuScreen.this.fighter.reputation;
                        ((PrepSetupScreen)((TalentsMenuScreen)TalentsMenuScreen.this).previousScreen).hostFighter.talents = TalentsMenuScreen.this.fighter.talents;
                        ((PrepSetupScreen)((TalentsMenuScreen)TalentsMenuScreen.this).previousScreen).reputationLabel.setText(TalentsMenuScreen.this.fighter.reputation + " / " + TalentsMenuScreen.this.maxReputation);
                        TalentsMenuScreen.this.game.saveGame.put("talents", Fighter.getTalentsString(TalentsMenuScreen.this.fighter.talents));
                    } else if (TalentsMenuScreen.this.previousScreen instanceof TournamentEventScreen) {
                        TalentsMenuScreen.this.game.campaignFighter.reputation = TalentsMenuScreen.this.fighter.reputation;
                        TalentsMenuScreen.this.game.campaignFighter.talents = TalentsMenuScreen.this.fighter.talents;
                        TalentsMenuScreen.this.game.saveGame.put("reputation", "" + TalentsMenuScreen.this.fighter.reputation);
                        TalentsMenuScreen.this.game.saveGame.put("talents", Fighter.getTalentsString(TalentsMenuScreen.this.fighter.talents));
                        if (!TalentsMenuScreen.this.extProfit) {
                            if (TalentsMenuScreen.this.game.saveGame.get("store") == null) {
                                TalentsMenuScreen.this.game.saveGame.put("profits", "" + TalentsMenuScreen.this.profits);
                            } else if (TalentsMenuScreen.this.profits > Integer.parseInt(TalentsMenuScreen.this.game.saveGame.get("profits"))) {
                                TalentsMenuScreen.this.game.saveGame.put("store", "" + (TalentsMenuScreen.this.profits - Integer.parseInt(TalentsMenuScreen.this.game.saveGame.get("profits"))) / 100);
                            } else {
                                TalentsMenuScreen.this.game.saveGame.put("store", "0");
                                TalentsMenuScreen.this.game.saveGame.put("profits", "" + TalentsMenuScreen.this.profits);
                            }
                        } else {
                            TalentsMenuScreen.this.game.saveGame.put("store", "" + TalentsMenuScreen.this.profits / 100);
                        }
                    }
                    TalentsMenuScreen.this.game.setScreen(TalentsMenuScreen.this.previousScreen);
                }
            });
            this.applyButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.applyButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.applyButton.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - this.applyButton.getPrefWidth());
            this.applyButton.setY(UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
            this.stage.addActor(this.applyButton);
        }
        this.exitButton = new Button(this.game.uiSkin, "cancel");
        this.exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TalentsMenuScreen.this.game.setScreen(TalentsMenuScreen.this.previousScreen);
            }
        });
        this.exitButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.exitButton.setY(UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.stage.addActor(this.exitButton);
    }

    @Override
    public void render(float delta) {
        ArrayList<BaseActor> currStack;
        this.game.manager.update();
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.getBatch().setBlendFunction(770, 771);
        this.stage.draw();
        this.stage.getViewport().apply();
        if (this.changeFrameBuffer) {
            this.frameBufferLights.begin();
            Gdx.gl.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 1);
            this.stage.getBatch().begin();
            for (String currTalent : this.talentMap.keySet()) {
                currStack = this.talentMap.get(currTalent);
                if (!currTalent.contains(":") && !this.showButton.isChecked() && !this.hasRequisites(currTalent) && !this.hasTalentLevel(currTalent)) continue;
                currStack.get(3).draw(this.stage.getBatch(), 1.0f);
            }
            this.stage.getBatch().end();
            this.frameBufferLights.end(this.stage.getViewport().getScreenX(), this.stage.getViewport().getScreenY(), this.stage.getViewport().getScreenWidth(), this.stage.getViewport().getScreenHeight());
            this.changeFrameBuffer = false;
        }
        this.stage.getViewport().apply();
        this.stage.getBatch().setBlendFunction(774, 0);
        this.stage.getBatch().begin();
        this.stage.getBatch().draw((Texture)this.frameBufferLights.getColorBufferTexture(), 0.0f, 0.0f, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f, 1.0f, 1.0f);
        this.stage.getBatch().end();
        this.stage.getViewport().apply();
        this.stage.getBatch().setBlendFunction(770, 1);
        this.stage.getBatch().begin();
        for (String currTalent : this.talentMap.keySet()) {
            currStack = this.talentMap.get(currTalent);
            if (!currTalent.contains(":") && !this.showButton.isChecked() && !this.hasRequisites(currTalent) && !this.hasTalentLevel(currTalent)) continue;
            currStack.get(2).draw(this.stage.getBatch(), 1.0f);
        }
        this.stage.getBatch().end();
        this.stage.getViewport().apply();
        this.stage.getBatch().setBlendFunction(770, 771);
        this.stage.getBatch().begin();
        for (String currTalent : this.talentMap.keySet()) {
            currStack = this.talentMap.get(currTalent);
            if (!currTalent.contains(":") && !this.showButton.isChecked() && !this.hasRequisites(currTalent) && !this.hasTalentLevel(currTalent)) continue;
            currStack.get(1).draw(this.stage.getBatch(), 1.0f);
            currStack.get(0).draw(this.stage.getBatch(), 1.0f);
        }
        this.tooltip.draw(this.stage.getBatch(), 1.0f);
        this.reputationLabel.draw(this.stage.getBatch(), 1.0f);
        this.showButton.draw(this.stage.getBatch(), 1.0f);
        this.showLabel.draw(this.stage.getBatch(), 1.0f);
        if (!(this.previousScreen instanceof TournamentSetupScreen)) {
            this.applyButton.draw(this.stage.getBatch(), 1.0f);
        }
        this.exitButton.draw(this.stage.getBatch(), 1.0f);
        this.stage.getBatch().end();
        this.stage.getViewport().apply();
        this.stage.getBatch().setBlendFunction(770, 771);
        this.stage.getBatch().begin();
        this.tooltipText.draw(this.stage.getBatch(), 1.0f);
        if (this.tooltipButton.isVisible()) {
            this.tooltipButton.draw(this.stage.getBatch(), 1.0f);
        }
        this.stage.getBatch().end();
        this.stage.getViewport().apply();
    }

    @Override
    public void dispose() {
        UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset("data/backgrounds/talentsbackground.png"));
        UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset("data/backgrounds/talentslevelsbackground.png"));
    }

    @Override
    public void receivedPacket(String content) {
        if (this.previousScreen instanceof DuelSetupScreen) {
            this.previousScreen.receivedPacket(content);
        }
    }

    private void showTalentInfo(BaseActor talentActor) {
        String talent = (String)talentActor.params.get("talent");
        StringBuilder info = new StringBuilder();
        if (!talent.contains(":")) {
            info.append("[#C7DEE0]");
            info.append(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.talents.name." + talent));
            String requisites = ((JSONObject)this.game.stats.get("talents").get(talent)).getString("requisites");
            if (!requisites.equalsIgnoreCase("")) {
                info.append("\n[#FF3333](");
                String[] arrRequisites = requisites.split(",");
                for (int i = 0; i < arrRequisites.length; ++i) {
                    info.append(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.talents.name." + arrRequisites[i]));
                    if (i >= arrRequisites.length - 1) continue;
                    info.append(", ");
                }
                info.append(")");
            }
            info.append("\n[#DDDDDD]");
            info.append(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.talents.description." + talent, this.game.violenceFilter));
        } else {
            Integer currTalentLevel = this.fighter.talents.get(talent.split(":")[0]) != null ? this.fighter.talents.get(talent.split(":")[0]) : 0;
            info.append("[#C7DEE0]");
            info.append(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.talents.name." + talent).split(" ")[0] + " 1/2/3");
            info.append("\n[#FFFFFF]");
            info.append(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.talents.level.current"));
            info.append(": ");
            info.append("[#C7DEE0]");
            info.append(currTalentLevel);
            info.append("\n[#DDDDDD]");
            info.append(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.talents.description." + talent.split(":")[0] + ":1", this.game.violenceFilter));
        }
        this.tooltipText.setText(info.toString());
        this.tooltipText.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(this.tooltipText, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 80.0f / 100.0f);
        this.tooltip.setWidth(this.tooltipText.getWidth() + 80.0f);
        this.tooltip.setHeight(this.tooltipText.getPrefHeight() + 45.0f);
        if (talentActor.getX() + talentActor.getWidth() > this.game.viewWidth.floatValue() * 2.0f / 3.0f - 80.0f) {
            this.tooltipText.setX(talentActor.getX() - this.tooltipText.getWidth() - 38.0f);
        } else {
            this.tooltipText.setX(talentActor.getX() + talentActor.getWidth() + 42.0f);
        }
        this.tooltipText.setY(MathUtils.clamp(talentActor.getY() + talentActor.getHeight() / 2.0f + this.tooltipText.getPrefHeight() / 2.0f, this.tooltipText.getPrefHeight() + UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue()));
        this.tooltip.setX(this.tooltipText.getX() - 42.0f);
        this.tooltip.setY(this.tooltipText.getY() - this.tooltipText.getPrefHeight() - 20.0f);
        this.tooltip.setVisible(true);
        if (!this.game.input.equalsIgnoreCase("keyboard")) {
            this.selectedTalent = (String)talentActor.params.get("talent");
            this.selectedHasRequisites = (Boolean)talentActor.params.get("hasRequisites");
            this.tooltipButton.setX(this.tooltip.getX() + this.tooltip.getWidth() - this.tooltipButton.getWidth() - 10.0f);
            this.tooltipButton.setY(this.tooltip.getY() + 20.0f);
            Integer talentLevel = 1;
            if (this.selectedTalent.contains(":")) {
                talentLevel = Integer.parseInt(talent.substring(talent.indexOf(":") + 1));
            }
            if (!this.hasTalentLevel(this.selectedTalent) && this.canPayTalent(this.selectedTalent, false) && this.hasRequisites(this.selectedTalent) || this.hasTalentLevel(this.selectedTalent) && (this.talentsOrig.get(this.selectedTalent.substring(0, 1)) == null || this.talentsOrig.get(this.selectedTalent.substring(0, 1)) < talentLevel || this.game.saveGame.isEmpty()) && !this.talentIsRequired(this.selectedTalent)) {
                this.tooltipButton.setVisible(true);
            } else if (talentLevel > 1) {
                String previousTalent = this.selectedTalent.substring(0, 1) + ":" + (talentLevel - 1);
                if (this.hasTalentLevel(previousTalent) || this.hasTalentLevel(previousTalent) && (this.talentsOrig.get(previousTalent.substring(0, 1)) == null || this.talentsOrig.get(previousTalent.substring(0, 1)) < talentLevel || this.game.saveGame.isEmpty()) && !this.talentIsRequired(previousTalent)) {
                    this.tooltipButton.setVisible(true);
                }
            } else {
                this.tooltipButton.setVisible(false);
            }
        }
    }

    private void checkTalent(String talent, Boolean hasRequisites) {
        if (hasRequisites.booleanValue()) {
            int talentLevel;
            if (this.hasTalentLevel(talent)) {
                if (talent.contains(":")) {
                    if ((this.talentsOrig.get(talent.split(":")[0]) == null || this.game.saveGame.isEmpty()) && !this.talentIsRequired(talent) || !this.game.saveGame.isEmpty() && this.talentsOrig.get(talent.split(":")[0]) != null && this.talentsOrig.get(talent.split(":")[0]) < Integer.parseInt(talent.split(":")[1])) {
                        this.removeTalentMaxDepth(talent);
                        this.game.manager.get("sound/toggle.ogg", Sound.class).play(this.game.soundVolume);
                        this.changeFrameBuffer = true;
                    }
                } else if ((this.talentsOrig.get(talent) == null || this.game.saveGame.isEmpty()) && !this.talentIsRequired(talent)) {
                    this.removeTalentMaxDepth(talent);
                    this.game.manager.get("sound/toggle.ogg", Sound.class).play(this.game.soundVolume);
                    this.changeFrameBuffer = true;
                }
            } else if (this.canPayTalent(talent, true)) {
                this.addTalent(talent);
                this.game.manager.get("sound/talent.ogg", Sound.class).play(this.game.soundVolume);
                this.changeFrameBuffer = true;
                System.out.println(talent + "-" + PropertiesReader.getMessage(this.game.gameMessages, "game.stats.talents.name." + talent));
                StringBuilder blockTalents = new StringBuilder();
                for (String currTalent : this.game.stats.get("talents").keySet()) {
                    if (!currTalent.contains(":")) {
                        if (this.fighter.talents.get(currTalent) != null) continue;
                        blockTalents.append(currTalent);
                        blockTalents.append(";");
                        continue;
                    }
                    if (this.fighter.talents.get(currTalent.substring(0, 1)) == null || this.fighter.talents.get(currTalent.substring(0, 1)) >= Integer.parseInt(currTalent.substring(2, 3))) continue;
                    blockTalents.append(currTalent);
                    blockTalents.append(";");
                }
                System.out.println(blockTalents.toString());
            } else if (talent.contains(":") && (talentLevel = Integer.parseInt(talent.split(":")[1])) > 1) {
                if ((talent = talent.split(":")[0] + ":" + (talentLevel - 1)).contains(":")) {
                    if ((this.talentsOrig.get(talent.split(":")[0]) == null || this.game.saveGame.isEmpty()) && !this.talentIsRequired(talent) || !this.game.saveGame.isEmpty() && this.talentsOrig.get(talent.split(":")[0]) != null && this.talentsOrig.get(talent.split(":")[0]) < Integer.parseInt(talent.split(":")[1])) {
                        this.removeTalentMaxDepth(talent);
                        this.game.manager.get("sound/toggle.ogg", Sound.class).play(this.game.soundVolume);
                        this.changeFrameBuffer = true;
                    }
                } else if ((this.talentsOrig.get(talent) == null || this.game.saveGame.isEmpty()) && !this.talentIsRequired(talent)) {
                    this.removeTalentMaxDepth(talent);
                    this.game.manager.get("sound/toggle.ogg", Sound.class).play(this.game.soundVolume);
                    this.changeFrameBuffer = true;
                }
            }
            if (this.changeFrameBuffer) {
                this.checkKnownTalents(false);
            }
        }
    }

    private void checkKnownTalents(boolean updateReputation) {
        ArrayList<String> talentSet = new ArrayList<String>(this.talentMap.keySet());
        Collections.sort(talentSet);
        Iterator<String> iterator = talentSet.iterator();
        while (iterator.hasNext()) {
            String currMapTalent;
            String realMapTalent = currMapTalent = iterator.next();
            int currMapLevel = 1;
            if (currMapTalent.contains(":")) {
                realMapTalent = currMapTalent.split(":")[0];
                currMapLevel = Integer.parseInt(currMapTalent.split(":")[1]);
            }
            ArrayList<BaseActor> currMapStack = this.talentMap.get(currMapTalent);
            if (this.hasTalentLevel(currMapTalent)) {
                if (updateReputation) {
                    int reputationCost = Integer.parseInt(((JSONObject)this.game.stats.get("talents").get(currMapTalent)).getString("reputationCost"));
                    this.fighter.reputation += reputationCost;
                }
                if (currMapTalent.contains(":") && this.getKnownTalentLevel(currMapTalent) > currMapLevel) {
                    currMapStack.get(3).setVisible(false);
                    currMapStack.get(2).setVisible(false);
                    currMapStack.get(1).setVisible(false);
                    currMapStack.get(0).setVisible(false);
                    continue;
                }
                currMapStack.get(3).setVisible(true);
                currMapStack.get(2).setVisible(true);
                currMapStack.get(1).setVisible(true);
                currMapStack.get((int)0).params.put("hasRequisites", true);
                currMapStack.get(0).setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
                if (!currMapTalent.contains(":") || this.talentMap.get(realMapTalent + ":" + (currMapLevel + 1)) != null) continue;
                currMapStack.get(2).setColor(new Color(0.5f, 0.0f, 0.0f, 1.0f));
                continue;
            }
            currMapStack.get(3).setVisible(false);
            currMapStack.get(2).setVisible(false);
            currMapStack.get(1).setVisible(true);
            currMapStack.get(0).setVisible(true);
            if (this.hasRequisites(currMapTalent)) {
                currMapStack.get((int)0).params.put("hasRequisites", true);
                currMapStack.get(0).setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
            } else {
                if (!this.showButton.isChecked()) {
                    currMapStack.get(1).setVisible(false);
                    currMapStack.get(0).setVisible(false);
                }
                currMapStack.get((int)0).params.put("hasRequisites", false);
                currMapStack.get(0).setColor(new Color(0.0f, 0.0f, 0.0f, 1.0f));
            }
            if (!currMapTalent.contains(":")) continue;
            int knownLevel = this.getKnownTalentLevel(currMapTalent);
            if (knownLevel + 1 == currMapLevel && this.hasRequisites(currMapTalent)) {
                if (knownLevel <= 0) continue;
                ArrayList<BaseActor> currMapSubStack = this.talentMap.get(realMapTalent + ":" + knownLevel);
                currMapSubStack.get(1).setVisible(true);
                currMapStack.get(1).setVisible(false);
                currMapSubStack.get(0).setVisible(false);
                continue;
            }
            currMapStack.get(3).setVisible(false);
            currMapStack.get(2).setVisible(false);
            currMapStack.get(1).setVisible(false);
            currMapStack.get(0).setVisible(false);
        }
        StringBuilder reputationText = new StringBuilder();
        if (this.profits > 0) {
            reputationText.append("[#FF0000]");
            reputationText.append(this.fighter.reputation);
            reputationText.append(" [#999487]");
            reputationText.append(this.profits);
        } else {
            reputationText.append("[#FF0000]");
            reputationText.append(this.fighter.reputation);
            reputationText.append(" / ");
            reputationText.append(this.maxReputation == 0 ? "-" : Integer.valueOf(this.maxReputation));
        }
        this.reputationLabel.setText(reputationText);
    }

    private int getKnownTalentLevel(String talent) {
        String realTalent = talent;
        if (realTalent.contains(":")) {
            realTalent = realTalent.substring(0, realTalent.indexOf(":"));
        }
        return this.fighter.talents.get(realTalent) != null ? this.fighter.talents.get(realTalent) : 0;
    }

    private boolean hasTalentLevel(String talent) {
        if (talent.contains(":")) {
            int talentLevel = 1;
            talentLevel = Integer.parseInt(talent.substring(talent.indexOf(":") + 1));
            return this.getKnownTalentLevel(talent) >= talentLevel;
        }
        return this.getKnownTalentLevel(talent) != 0;
    }

    private boolean hasRequisites(String talent) {
        String requisites = ((JSONObject)this.game.stats.get("talents").get(talent)).getString("requisites");
        if (!requisites.equalsIgnoreCase("")) {
            String[] arrRequisites;
            for (String arrRequisite : arrRequisites = requisites.split(",")) {
                if (this.hasTalentLevel(arrRequisite)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean talentIsRequired(String talent) {
        for (String currTalent : this.fighter.talents.keySet()) {
            String requisites;
            if (this.fighter.talents.get(currTalent) != -1 || !(requisites = ((JSONObject)this.game.stats.get("talents").get(currTalent)).getString("requisites")).contains(talent)) continue;
            return true;
        }
        return false;
    }

    private void removeTalent(String talent) {
        String reputationCost = ((JSONObject)this.game.stats.get("talents").get(talent)).getString("reputationCost");
        String realTalent = talent;
        if (realTalent.contains(":")) {
            realTalent = realTalent.substring(0, realTalent.indexOf(":"));
        }
        this.fighter.talents.remove(realTalent);
        this.fighter.reputation -= Integer.parseInt(reputationCost);
        if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            this.profits += Integer.parseInt(reputationCost) * (this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(this.game, "legkil") : 100) / 100;
        }
    }

    private void removeTalentMaxDepth(String talent) {
        if (talent.contains(":")) {
            String realTalent = talent.split(":")[0];
            int realTalentLevel = Integer.parseInt(talent.split(":")[1]);
            while (realTalentLevel > 0 && (this.talentsOrig.get(realTalent) == null || this.game.saveGame.isEmpty()) && !this.talentIsRequired(realTalent + ":" + realTalentLevel) || !this.game.saveGame.isEmpty() && this.talentsOrig.get(realTalent) != null && this.talentsOrig.get(realTalent) < realTalentLevel) {
                this.removeTalent(realTalent + ":" + realTalentLevel);
                this.fighter.talents.put(realTalent, --realTalentLevel);
            }
            if (realTalentLevel == 0) {
                this.fighter.talents.remove(realTalent);
            }
        } else {
            this.removeTalent(talent);
        }
    }

    private void addTalent(String talent) {
        if (talent.contains(":")) {
            String[] talentParts = talent.split(":");
            this.fighter.talents.put(talentParts[0], Integer.parseInt(talentParts[1]));
        } else {
            this.fighter.talents.put(talent, -1);
        }
    }

    private boolean canPayTalent(String talent, boolean doPayment) {
        int reputationCost = Integer.parseInt(((JSONObject)this.game.stats.get("talents").get(talent)).getString("reputationCost"));
        if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            if (this.profits >= (reputationCost = reputationCost * (this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(this.game, "legkil") : 100) / 100)) {
                if (doPayment) {
                    this.fighter.reputation += reputationCost;
                    this.profits -= reputationCost;
                }
                return true;
            }
        } else if (this.maxReputation == 0 || this.fighter.reputation + reputationCost <= this.maxReputation) {
            if (doPayment) {
                this.fighter.reputation += reputationCost;
            }
            return true;
        }
        return false;
    }
}

