/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.TournamentEventScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SmithMenuScreen
extends BaseScreen {
    private BaseScreen previousScreen;
    public Fighter fighter;
    public int profits;
    public boolean surplus;
    public HashMap<String, Integer> stocksOrig;
    public HashMap<String, Integer> storeOrig;
    public HashMap<String, Integer> storeAfter;
    public int tierBonus = 0;
    private NinePatchActor iconListBackground;
    private NinePatchActor itemBackground;
    public NinePatchActor statsBackground;
    public Label profitsLabel;
    public WidgetGroup itemList;
    public ScrollPane itemPane;
    public ArrayList<BaseActor> availableItems = new ArrayList();
    public HashMap<String, ArrayList<Float>> weaponStats = new HashMap();
    public ArrayList<BaseActor> statsBars = new ArrayList();
    public BaseActor selectedItem;
    public Label selectedStock;
    public Label selectedStore;
    public Label selectedItemName;
    public Label selectedItemTier;
    public Label itemInfo;
    public Label extraItemInfo;
    public Button addItem;
    public Button removeItem;
    private Button applyButton;
    private Button exitButton;

    public SmithMenuScreen(SlavePitsGame g, BaseScreen s, Fighter selectedFighter, int leftProfits, boolean isSurplus) {
        super(g);
        this.previousScreen = s;
        this.fighter = Fighter.clone(selectedFighter, true);
        this.profits = leftProfits;
        this.surplus = isSurplus;
        this.stocksOrig = Tournament.getWeaponsAvailable(this.game);
        this.storeOrig = Tournament.getWeaponsStore(g, "");
        this.storeAfter = Tournament.getWeaponsStore(g, "");
        this.tierBonus = this.game.gameMode.equalsIgnoreCase("tournament") && this.game.saveGame.get("rewards").contains("crafts") ? Tournament.getRewardStock(this.game, "crafts") : 0;
        this.create();
    }

    @Override
    public void create() {
        float iconSize = UIHelpers.calcHeightProportion(this.game, 10.0f, 8.0f).floatValue();
        this.itemBackground = new NinePatchActor(this.game.uiSkin.get("scrollpanel", NinePatch.class));
        this.iconListBackground = new NinePatchActor(this.game.uiSkin.get("scrollpanel", NinePatch.class));
        this.iconListBackground.setHeight(iconSize * 160.0f / 100.0f);
        this.iconListBackground.setWidth(UIHelpers.calcWidthProportion(this.game, 80.0f, 98.0f).floatValue());
        this.iconListBackground.setX(UIHelpers.calcWidthProportion(this.game, 10.0f, 1.0f).floatValue());
        this.iconListBackground.setY(UIHelpers.calcHeightProportion(this.game, 60.0f, 60.0f).floatValue());
        this.itemBackground.setWidth(UIHelpers.calcWidthProportion(this.game, 80.0f, 98.0f).floatValue());
        this.itemBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 25.0f, 25.0f).floatValue());
        this.itemBackground.setX(UIHelpers.calcWidthProportion(this.game, 10.0f, 1.0f).floatValue());
        this.itemBackground.setY(this.iconListBackground.getY() - this.itemBackground.getHeight());
        this.itemList = new HorizontalGroup();
        ((HorizontalGroup)this.itemList).space(iconSize * 10.0f / 100.0f);
        this.itemList.setHeight(iconSize * 120.0f / 100.0f);
        this.itemPane = new ScrollPane((Actor)this.itemList);
        this.itemPane.setHeight(this.itemList.getHeight());
        this.itemPane.setY(this.iconListBackground.getY() + this.iconListBackground.getHeight() / 2.0f - this.itemPane.getHeight() / 2.0f);
        if (this.game.portraitmode) {
            this.itemPane.addListener(new DragListener(){

                @Override
                public void drag(InputEvent event, float x, float y, int pointer) {
                    super.drag(event, x, y, pointer);
                    SmithMenuScreen.this.itemPane.setScrollX(SmithMenuScreen.this.itemPane.getScrollX() - (float)((int)this.getDeltaX()));
                }
            });
        } else {
            this.itemPane.addListener(new InputListener(){

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                    SmithMenuScreen.this.stage.setScrollFocus(null);
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    SmithMenuScreen.this.stage.setScrollFocus(event.getListenerActor());
                }
            });
        }
        this.itemPane.setForceScroll(true, false);
        this.itemPane.setFlickScroll(false);
        this.itemPane.setOverscroll(true, false);
        this.stage.addActor(this.iconListBackground);
        this.stage.addActor(this.itemBackground);
        this.stage.addActor(this.itemPane);
        this.profitsLabel = new Label("" + this.profits, this.game.uiSkin, "default");
        this.profitsLabel.setColor(this.game.uiSkin.get("iron", Color.class));
        this.profitsLabel.setAlignment(1);
        this.profitsLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue());
        this.profitsLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.profitsLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.profitsLabel.getWidth() / 2.0f);
        this.profitsLabel.setY(this.iconListBackground.getY() + this.iconListBackground.getHeight() + UIHelpers.calcHeightProportion(this.game, 3.0f, 3.0f).floatValue() - this.profitsLabel.getPrefHeight());
        this.stage.addActor(this.profitsLabel);
        TextureAtlas equipmentAtlas = this.game.manager.get(this.game.getOverridenAsset("data/equipment/equipment.atlas"), TextureAtlas.class);
        this.selectedItem = new BaseActor();
        this.selectedItem.setTexture(equipmentAtlas.findRegion("empty"), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        this.selectedItem.setX(this.itemBackground.getX() + UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        this.selectedItem.setY(this.itemBackground.getY() + this.itemBackground.getHeight() - this.selectedItem.getHeight() - UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.selectedItem.setVisible(false);
        this.stage.addActor(this.selectedItem);
        this.selectedItemName = new Label("Weapon", this.game.uiSkin, "default");
        this.selectedItemName.setAlignment(1);
        this.selectedItemName.setWrap(true);
        this.selectedItemName.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.selectedItemName.setVisible(false);
        this.selectedItemName.setWidth(this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.selectedItemName.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.selectedItemName.setX(this.selectedItem.getX() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.selectedItemName.setY(this.selectedItem.getY() - UIHelpers.calcHeightProportion(this.game, 1.5f, 1.5f).floatValue() - this.selectedItemName.getPrefHeight());
        this.stage.addActor(this.selectedItemName);
        this.selectedItemTier = new Label("Tier: wood", this.game.uiSkin, "default");
        this.selectedItemTier.setAlignment(1);
        this.selectedItemTier.setWrap(true);
        this.selectedItemTier.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.selectedItemTier.setVisible(false);
        this.selectedItemTier.setWidth(this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.selectedItemTier.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 5.0f / 4.0f));
        this.selectedItemTier.setX(this.selectedItem.getX() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.selectedItemTier.setY(this.selectedItemName.getY() - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue() - this.selectedItemTier.getPrefHeight());
        this.stage.addActor(this.selectedItemTier);
        this.itemInfo = new Label("", this.game.uiSkin, "default");
        this.itemInfo.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 5.0f / 4.0f));
        this.itemInfo.setAlignment(10);
        this.itemInfo.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.itemInfo.setWrap(true);
        this.itemInfo.setWidth(this.itemBackground.getWidth() - UIHelpers.calcHeightProportion(this.game, 22.0f, 22.0f).floatValue());
        this.itemInfo.setX(MathUtils.clamp(this.selectedItemName.getX() + this.selectedItemName.getPrefWidth(), this.selectedItem.getX() + this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue(), this.itemBackground.getX() + this.itemBackground.getWidth()));
        this.itemInfo.setVisible(false);
        this.stage.addActor(this.itemInfo);
        this.extraItemInfo = new Label("", this.game.uiSkin, "default");
        this.extraItemInfo.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 5.0f / 4.0f));
        this.extraItemInfo.setAlignment(18);
        this.extraItemInfo.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.extraItemInfo.setWrap(true);
        this.extraItemInfo.setWidth(this.itemBackground.getWidth() - UIHelpers.calcHeightProportion(this.game, 22.0f, 22.0f).floatValue());
        this.extraItemInfo.setX(MathUtils.clamp(this.selectedItemName.getX() + this.selectedItemName.getPrefWidth(), this.selectedItem.getX() + this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue(), this.itemBackground.getX() + this.itemBackground.getWidth()));
        this.extraItemInfo.setVisible(false);
        this.stage.addActor(this.extraItemInfo);
        this.statsBackground = new NinePatchActor(this.game.uiSkin.get("statspane", NinePatch.class));
        this.statsBackground.setVisible(false);
        this.stage.addActor(this.statsBackground);
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        for (int i = 0; i < 6; ++i) {
            BaseActor newBar = new BaseActor();
            newBar.setTexture(uiAtlas.findRegion("stat"), 10.0f, 10.0f);
            newBar.setVisible(false);
            this.stage.addActor(newBar);
            this.statsBars.add(newBar);
        }
        this.removeItem = new Button(this.game.uiSkin, "remove");
        this.removeItem.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                SmithMenuScreen.this.stocksOrig.put((String)SmithMenuScreen.this.selectedItem.params.get("id"), SmithMenuScreen.this.stocksOrig.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) - 1);
                SmithMenuScreen.this.storeAfter.put((String)SmithMenuScreen.this.selectedItem.params.get("id"), SmithMenuScreen.this.storeAfter.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) + 1);
                SmithMenuScreen.this.profits = SmithMenuScreen.this.storeAfter.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) <= SmithMenuScreen.this.storeOrig.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) ? SmithMenuScreen.this.profits + Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * (SmithMenuScreen.this.surplus ? 2 : 3) / 3 * (SmithMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(SmithMenuScreen.this.game, "legkil") : 100) / 100 : (SmithMenuScreen.this.profits += Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * 2 / 3);
                SmithMenuScreen.this.profitsLabel.setText("" + SmithMenuScreen.this.profits);
                SmithMenuScreen.this.selectedStock.setText("x" + SmithMenuScreen.this.stocksOrig.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) + " ");
                SmithMenuScreen.this.selectedStock.setColor(SmithMenuScreen.this.game.uiSkin.get(SmithMenuScreen.this.stocksOrig.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) == 0 ? "red" : "green", Color.class));
                SmithMenuScreen.this.selectedStore.setText("x" + SmithMenuScreen.this.storeAfter.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) + " ");
                SmithMenuScreen.this.selectedItemName.setVisible(true);
                SmithMenuScreen.this.selectedItemTier.setVisible(true);
                SmithMenuScreen.this.addItem.setVisible(false);
                if (SmithMenuScreen.this.storeAfter.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) > 0 && SmithMenuScreen.this.profits > Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * (SmithMenuScreen.this.surplus ? 2 : 3) / 3) {
                    SmithMenuScreen.this.addItem.setVisible(true);
                    if (SmithMenuScreen.this.addItem.getX() != SmithMenuScreen.this.removeItem.getX()) {
                        SmithMenuScreen.this.addItem.setX(SmithMenuScreen.this.removeItem.getX());
                    }
                }
                SmithMenuScreen.this.removeItem.setVisible(false);
                if (SmithMenuScreen.this.stocksOrig.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) > 0) {
                    SmithMenuScreen.this.removeItem.setVisible(true);
                    if (SmithMenuScreen.this.addItem.getX() == SmithMenuScreen.this.removeItem.getX()) {
                        SmithMenuScreen.this.addItem.setX(SmithMenuScreen.this.addItem.getX() - SmithMenuScreen.this.addItem.getWidth() - 5.0f);
                    }
                }
                SmithMenuScreen.this.game.manager.get("sound/buyOption.ogg", Sound.class).play(SmithMenuScreen.this.game.soundVolume);
            }
        });
        this.removeItem.setVisible(false);
        this.removeItem.setWidth(UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        this.removeItem.setHeight(this.removeItem.getWidth());
        this.removeItem.setX(this.itemBackground.getX() + this.itemBackground.getWidth() - this.removeItem.getWidth() - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.removeItem.setY(this.itemBackground.getY() + UIHelpers.calcHeightProportion(this.game, 3.0f, 3.0f).floatValue());
        this.stage.addActor(this.removeItem);
        this.addItem = new Button(this.game.uiSkin, "add");
        this.addItem.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                SmithMenuScreen.this.stocksOrig.put((String)SmithMenuScreen.this.selectedItem.params.get("id"), SmithMenuScreen.this.stocksOrig.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) + 1);
                SmithMenuScreen.this.storeAfter.put((String)SmithMenuScreen.this.selectedItem.params.get("id"), SmithMenuScreen.this.storeAfter.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) - 1);
                SmithMenuScreen.this.profits = SmithMenuScreen.this.storeAfter.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) >= SmithMenuScreen.this.storeOrig.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) ? (SmithMenuScreen.this.profits -= Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * 2 / 3) : SmithMenuScreen.this.profits - Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * (SmithMenuScreen.this.surplus ? 2 : 3) / 3 * (SmithMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(SmithMenuScreen.this.game, "legkil") : 100) / 100;
                SmithMenuScreen.this.profitsLabel.setText("" + SmithMenuScreen.this.profits);
                SmithMenuScreen.this.selectedStock.setText("x" + SmithMenuScreen.this.stocksOrig.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) + " ");
                SmithMenuScreen.this.selectedStock.setColor(SmithMenuScreen.this.game.uiSkin.get(SmithMenuScreen.this.stocksOrig.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) == 0 ? "red" : "green", Color.class));
                SmithMenuScreen.this.selectedStore.setText("x" + SmithMenuScreen.this.storeAfter.get((String)SmithMenuScreen.this.selectedItem.params.get("id")) + " ");
                SmithMenuScreen.this.addItem.setVisible(false);
                if (SmithMenuScreen.this.storeAfter.get(SmithMenuScreen.this.selectedItem.params.get("id")) > 0 && SmithMenuScreen.this.profits > Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * (SmithMenuScreen.this.surplus ? 2 : 3) / 3) {
                    SmithMenuScreen.this.addItem.setVisible(true);
                    if (SmithMenuScreen.this.addItem.getX() != SmithMenuScreen.this.removeItem.getX()) {
                        SmithMenuScreen.this.addItem.setX(SmithMenuScreen.this.removeItem.getX());
                    }
                }
                SmithMenuScreen.this.removeItem.setVisible(false);
                if (SmithMenuScreen.this.stocksOrig.get(SmithMenuScreen.this.selectedItem.params.get("id")) > 0) {
                    SmithMenuScreen.this.removeItem.setVisible(true);
                    if (SmithMenuScreen.this.addItem.getX() == SmithMenuScreen.this.removeItem.getX()) {
                        SmithMenuScreen.this.addItem.setX(SmithMenuScreen.this.addItem.getX() - SmithMenuScreen.this.addItem.getWidth() - 5.0f);
                    }
                }
                SmithMenuScreen.this.game.manager.get("sound/buyOption.ogg", Sound.class).play(SmithMenuScreen.this.game.soundVolume);
            }
        });
        this.addItem.setVisible(false);
        this.addItem.setWidth(UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        this.addItem.setHeight(this.addItem.getWidth());
        this.addItem.setX(this.itemBackground.getX() + this.itemBackground.getWidth() - this.removeItem.getWidth() - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.addItem.setY(this.removeItem.getY());
        this.stage.addActor(this.addItem);
        this.applyButton = new Button(this.game.uiSkin, "ok");
        this.applyButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (SmithMenuScreen.this.previousScreen instanceof TournamentEventScreen) {
                    Tournament.setWeaponsAvailable(SmithMenuScreen.this.game, SmithMenuScreen.this.stocksOrig);
                    Tournament.setWeaponsStore(SmithMenuScreen.this.game, SmithMenuScreen.this.storeAfter);
                    SmithMenuScreen.this.game.saveGame.put("profits", "" + SmithMenuScreen.this.profits);
                }
                SmithMenuScreen.this.game.setScreen(SmithMenuScreen.this.previousScreen);
                SmithMenuScreen.this.dispose();
            }
        });
        this.applyButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.applyButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.applyButton.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - this.applyButton.getPrefWidth());
        this.applyButton.setY(this.itemBackground.getY() - this.applyButton.getHeight() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.stage.addActor(this.applyButton);
        this.exitButton = new Button(this.game.uiSkin, "cancel");
        this.exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                SmithMenuScreen.this.game.setScreen(SmithMenuScreen.this.previousScreen);
                SmithMenuScreen.this.dispose();
            }
        });
        this.exitButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.exitButton.setY(this.applyButton.getY());
        this.stage.addActor(this.exitButton);
        this.generateItemList();
    }

    @Override
    public void render(float delta) {
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    private void generateItemList() {
        float iconSize = UIHelpers.calcHeightProportion(this.game, 10.0f, 8.0f).floatValue();
        TextureAtlas equipmentAtlas = this.game.manager.get(this.game.getOverridenAsset("data/equipment/equipment.atlas"), TextureAtlas.class);
        for (BaseActor currItem : this.availableItems) {
            currItem.remove();
        }
        this.itemList.clearChildren();
        this.selectedItem.setVisible(false);
        this.selectedItemName.setVisible(false);
        this.selectedItemTier.setVisible(false);
        this.itemInfo.setVisible(false);
        this.statsBackground.setVisible(false);
        for (BaseActor currBar : this.statsBars) {
            currBar.setVisible(false);
        }
        this.addItem.setVisible(false);
        this.removeItem.setVisible(false);
        int numItems = 0;
        BaseActor helmetw = new BaseActor();
        helmetw.setTexture(equipmentAtlas.findRegion("ahelmetw"), iconSize, iconSize);
        helmetw.params.put("id", "helmet");
        helmetw.params.put("type", "helmet");
        helmetw.params.put("tier", "wood");
        helmetw.params.put("cost", this.game.stats.get("armors").getJSONObject("helmet").getString("cost"));
        Stack sHelmetw = new Stack();
        sHelmetw.add(helmetw);
        int numStock = this.stocksOrig.get("helmet");
        Label stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
        stock.setAlignment(18);
        stock.setColor(this.game.uiSkin.get(numStock == 0 ? "red" : "green", Color.class));
        stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        stock.setWidth(iconSize);
        stock.layout();
        sHelmetw.add(stock);
        Label store = new Label("x" + this.storeAfter.get("helmet") + " ", this.game.uiSkin, "default");
        store.setAlignment(20);
        store.setColor(this.game.uiSkin.get("lightiron", Color.class));
        store.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        store.setWidth(iconSize);
        store.layout();
        sHelmetw.add(store);
        sHelmetw.addListener(this.itemListener());
        this.itemList.addActor(sHelmetw);
        ++numItems;
        BaseActor bracersw = new BaseActor();
        bracersw.setTexture(equipmentAtlas.findRegion("abracersw"), iconSize, iconSize);
        bracersw.params.put("id", "bracers");
        bracersw.params.put("type", "bracers");
        bracersw.params.put("tier", "wood");
        bracersw.params.put("cost", this.game.stats.get("armors").getJSONObject("bracers").getString("cost"));
        Stack sBracersw = new Stack();
        sBracersw.add(bracersw);
        numStock = this.stocksOrig.get("bracers");
        stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
        stock.setAlignment(18);
        stock.setColor(this.game.uiSkin.get(numStock == 0 ? "red" : "green", Color.class));
        stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        stock.setWidth(iconSize);
        stock.layout();
        sBracersw.add(stock);
        store = new Label("x" + this.storeAfter.get("bracers") + " ", this.game.uiSkin, "default");
        store.setAlignment(20);
        store.setColor(this.game.uiSkin.get("lightiron", Color.class));
        store.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        store.setWidth(iconSize);
        store.layout();
        sBracersw.add(store);
        sBracersw.addListener(this.itemListener());
        this.itemList.addActor(sBracersw);
        ++numItems;
        BaseActor armorw = new BaseActor();
        armorw.setTexture(equipmentAtlas.findRegion("acuirassw"), iconSize, iconSize);
        armorw.params.put("id", "cuirass");
        armorw.params.put("type", "cuirass");
        armorw.params.put("tier", "wood");
        armorw.params.put("cost", this.game.stats.get("armors").getJSONObject("cuirass").getString("cost"));
        Stack sArmorw = new Stack();
        sArmorw.add(armorw);
        numStock = this.stocksOrig.get("cuirass");
        stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
        stock.setAlignment(18);
        stock.setColor(this.game.uiSkin.get(numStock == 0 ? "red" : "green", Color.class));
        stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        stock.setWidth(iconSize);
        stock.layout();
        sArmorw.add(stock);
        store = new Label("x" + this.storeAfter.get("cuirass") + " ", this.game.uiSkin, "default");
        store.setAlignment(20);
        store.setColor(this.game.uiSkin.get("lightiron", Color.class));
        store.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        store.setWidth(iconSize);
        store.layout();
        sArmorw.add(store);
        sArmorw.addListener(this.itemListener());
        this.itemList.addActor(sArmorw);
        ++numItems;
        HashMap weaponNumbers = new HashMap();
        weaponNumbers.put("baseDamage", new ArrayList());
        weaponNumbers.put("criticalChance", new ArrayList());
        weaponNumbers.put("attackTime", new ArrayList());
        weaponNumbers.put("staminaCost", new ArrayList());
        weaponNumbers.put("parryTime", new ArrayList());
        weaponNumbers.put("dodgeTime", new ArrayList());
        for (String currWeapon : this.game.stats.get("weapons").keySet()) {
            JSONObject currWeaponObject = this.game.stats.get("weapons").getJSONObject(currWeapon);
            if (currWeapon.equalsIgnoreCase("dagger")) continue;
            if (currWeaponObject.getString("baseDamage") != null && !currWeaponObject.getString("baseDamage").equalsIgnoreCase("")) {
                ((ArrayList)weaponNumbers.get("baseDamage")).add(Float.valueOf(currWeaponObject.getFloat("baseDamage")));
                ((ArrayList)weaponNumbers.get("criticalChance")).add(Float.valueOf(currWeaponObject.getFloat("criticalChance")));
                ((ArrayList)weaponNumbers.get("attackTime")).add(Float.valueOf(currWeaponObject.getFloat("attackTime")));
                if (currWeapon.equalsIgnoreCase("dagger") && (this.game.saveGame.isEmpty() || this.game.gameMode.equalsIgnoreCase("tournament") && this.game.saveGame.get("rewards").contains("dagger-fighting") || this.game.gameMode.equalsIgnoreCase("story") && this.game.saveGame.get("rewards").contains("dagger-fighting"))) {
                    ((ArrayList)weaponNumbers.get("parryTime")).add(Float.valueOf(0.75f));
                    ((ArrayList)weaponNumbers.get("dodgeTime")).add(Float.valueOf(0.75f));
                } else {
                    ((ArrayList)weaponNumbers.get("parryTime")).add(Float.valueOf(currWeaponObject.getFloat("parryTime")));
                    ((ArrayList)weaponNumbers.get("dodgeTime")).add(Float.valueOf(currWeaponObject.getFloat("dodgeTime")));
                }
                ((ArrayList)weaponNumbers.get("staminaCost")).add(Float.valueOf(currWeaponObject.getFloat("staminaCost")));
                JSONObject baseTier = (JSONObject)this.game.stats.get("tiers").get("caparace");
                ((ArrayList)weaponNumbers.get("baseDamage")).add(Float.valueOf(currWeaponObject.getFloat("baseDamage") * (float)(100 + baseTier.getInt("weaponBaseDamage") * (100 + this.tierBonus) / 100) / 100.0f));
                ((ArrayList)weaponNumbers.get("criticalChance")).add(Float.valueOf(currWeaponObject.getFloat("criticalChance") * (float)(100 + baseTier.getInt("weaponCriticalChance")) / 100.0f));
                ((ArrayList)weaponNumbers.get("attackTime")).add(Float.valueOf(currWeaponObject.getFloat("attackTime") * (float)(100 + baseTier.getInt("weaponAttackTime")) / 100.0f));
                ((ArrayList)weaponNumbers.get("staminaCost")).add(Float.valueOf(currWeaponObject.getFloat("staminaCost") * (float)(100 + baseTier.getInt("weaponStaminaCost")) / 100.0f));
                baseTier = (JSONObject)this.game.stats.get("tiers").get("iron");
                ((ArrayList)weaponNumbers.get("baseDamage")).add(Float.valueOf(currWeaponObject.getFloat("baseDamage") * (float)(100 + baseTier.getInt("weaponBaseDamage") * (100 + this.tierBonus) / 100) / 100.0f));
                ((ArrayList)weaponNumbers.get("criticalChance")).add(Float.valueOf(currWeaponObject.getFloat("criticalChance") * (float)(100 + baseTier.getInt("weaponCriticalChance")) / 100.0f));
                ((ArrayList)weaponNumbers.get("attackTime")).add(Float.valueOf(currWeaponObject.getFloat("attackTime") * (float)(100 + baseTier.getInt("weaponAttackTime")) / 100.0f));
                ((ArrayList)weaponNumbers.get("staminaCost")).add(Float.valueOf(currWeaponObject.getFloat("staminaCost") * (float)(100 + baseTier.getInt("weaponStaminaCost")) / 100.0f));
            }
            BaseActor weaponw = new BaseActor();
            weaponw.setTexture(equipmentAtlas.findRegion(currWeaponObject.getString("imagePrefix") + "w"), iconSize, iconSize);
            weaponw.params.put("id", currWeapon);
            weaponw.params.put("type", "weapons");
            weaponw.params.put("tier", "wood");
            weaponw.params.put("cost", this.game.stats.get("weapons").getJSONObject(currWeapon).getString("cost"));
            Stack sWeaponw = new Stack();
            sWeaponw.add(weaponw);
            numStock = this.stocksOrig.get(currWeapon);
            stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
            stock.setAlignment(18);
            stock.setColor(this.game.uiSkin.get(numStock == 0 ? "red" : "green", Color.class));
            stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            stock.setWidth(iconSize);
            stock.layout();
            sWeaponw.add(stock);
            store = new Label("x" + this.storeAfter.get(currWeapon) + " ", this.game.uiSkin, "default");
            store.setAlignment(20);
            store.setColor(this.game.uiSkin.get("lightiron", Color.class));
            store.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            store.setWidth(iconSize);
            store.layout();
            sWeaponw.add(store);
            sWeaponw.addListener(this.itemListener());
            this.itemList.addActor(sWeaponw);
            ++numItems;
        }
        for (String metric : weaponNumbers.keySet()) {
            ArrayList<Float> metricValues = new ArrayList<Float>();
            metricValues.add(Float.valueOf(10000.0f));
            metricValues.add(Float.valueOf(0.0f));
            Iterator iterator = ((ArrayList)weaponNumbers.get(metric)).iterator();
            while (iterator.hasNext()) {
                float currNumber = ((Float)iterator.next()).floatValue();
                if (((Float)metricValues.get(0)).floatValue() > currNumber) {
                    metricValues.set(0, Float.valueOf(currNumber));
                }
                if (!(((Float)metricValues.get(1)).floatValue() < currNumber)) continue;
                metricValues.set(1, Float.valueOf(currNumber));
            }
            this.weaponStats.put(metric, metricValues);
        }
        this.itemList.setWidth((float)numItems * UIHelpers.calcHeightProportion(this.game, 10.0f, 8.0f).floatValue() + (float)(numItems + 1) * UIHelpers.calcHeightProportion(this.game, 1.0f, 0.8f).floatValue());
        this.itemPane.setWidth(MathUtils.clamp(this.itemList.getWidth(), 0.0f, this.iconListBackground.getWidth() - 80.0f));
        this.itemPane.layout();
        this.itemPane.setX(this.iconListBackground.getX() + this.iconListBackground.getWidth() - this.itemPane.getWidth() - 40.0f);
        this.itemPane.setScrollX(0.0f);
    }

    private InputListener itemListener() {
        return new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                float iconSize = UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 10.0f, 8.0f).floatValue();
                Stack evStack = (Stack)event.getListenerActor();
                BaseActor evActor = null;
                SmithMenuScreen.this.selectedStock = null;
                SmithMenuScreen.this.selectedStore = null;
                for (Actor currActor : evStack.getChildren()) {
                    if (currActor instanceof BaseActor) {
                        evActor = (BaseActor)currActor;
                        continue;
                    }
                    if (!(currActor instanceof Label)) continue;
                    if (SmithMenuScreen.this.selectedStock == null) {
                        SmithMenuScreen.this.selectedStock = (Label)currActor;
                        continue;
                    }
                    if (SmithMenuScreen.this.selectedStore != null) continue;
                    SmithMenuScreen.this.selectedStore = (Label)currActor;
                }
                SmithMenuScreen.this.selectedItem.setVisible(true);
                SmithMenuScreen.this.selectedItem.setTexture(evActor.region, iconSize, iconSize);
                String itemId = (String)evActor.params.get("id");
                String itemType = (String)evActor.params.get("type");
                String realItemType = "armors";
                if (!(itemType.equalsIgnoreCase("helmet") || itemType.equalsIgnoreCase("bracers") || itemType.equalsIgnoreCase("cuirass"))) {
                    realItemType = "weapons";
                }
                String itemTier = (String)evActor.params.get("tier");
                String itemCost = (String)evActor.params.get("cost");
                SmithMenuScreen.this.selectedItem.params.put("id", itemId);
                SmithMenuScreen.this.selectedItem.params.put("type", itemType);
                SmithMenuScreen.this.selectedItem.params.put("tier", itemTier);
                SmithMenuScreen.this.selectedItem.params.put("cost", itemCost);
                SmithMenuScreen.this.selectedItemName.setVisible(true);
                SmithMenuScreen.this.selectedItemTier.setVisible(true);
                SmithMenuScreen.this.addItem.setVisible(false);
                if (SmithMenuScreen.this.storeAfter.get(itemId) > 0 && SmithMenuScreen.this.profits >= Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * (SmithMenuScreen.this.surplus ? 2 : 3) / 3) {
                    SmithMenuScreen.this.addItem.setVisible(true);
                    if (SmithMenuScreen.this.addItem.getX() != SmithMenuScreen.this.removeItem.getX()) {
                        SmithMenuScreen.this.addItem.setX(SmithMenuScreen.this.removeItem.getX());
                    }
                }
                SmithMenuScreen.this.removeItem.setVisible(false);
                if (SmithMenuScreen.this.stocksOrig.get(itemId) > 0) {
                    SmithMenuScreen.this.removeItem.setVisible(true);
                    if (SmithMenuScreen.this.addItem.getX() == SmithMenuScreen.this.removeItem.getX()) {
                        SmithMenuScreen.this.addItem.setX(SmithMenuScreen.this.addItem.getX() - SmithMenuScreen.this.addItem.getWidth() - 5.0f);
                    }
                }
                SmithMenuScreen.this.selectedItemName.setText(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.items." + realItemType + ".name." + itemId));
                StringBuilder tierInfo = new StringBuilder();
                tierInfo.append("[#D4D4D4]");
                tierInfo.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "common.tier"));
                tierInfo.append(": ");
                tierInfo.append("[#A8A8A8]");
                tierInfo.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.items.tiers.name." + itemTier));
                SmithMenuScreen.this.selectedItemTier.setText(tierInfo.toString());
                SmithMenuScreen.this.itemInfo.setVisible(true);
                StringBuilder info = new StringBuilder();
                StringBuilder extraInfo = new StringBuilder();
                JSONObject baseItem = (JSONObject)SmithMenuScreen.this.game.stats.get(realItemType).get(itemId);
                JSONObject baseTier = (JSONObject)SmithMenuScreen.this.game.stats.get("tiers").get(itemTier);
                if (realItemType.equalsIgnoreCase("armors")) {
                    info.append("[#D4D4D4]");
                    info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.combat.damage.reduction"));
                    info.append(": ");
                    info.append("[#A8A8A8]");
                    info.append(baseItem.getInt("damageReduction") + baseTier.getInt("armor") * (100 + SmithMenuScreen.this.tierBonus) / 100);
                    info.append("%");
                    info.append("\n");
                    info.append("[#D4D4D4]");
                    info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.combat.stamina.cost"));
                    info.append(": ");
                    info.append("[#A8A8A8]");
                    info.append(Integer.parseInt(baseItem.getString("staminaCost")) / 10 + baseTier.getInt("armor"));
                    info.append("\n");
                    if (baseItem.has("attackTime")) {
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.combat.time.attack"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append("x");
                        info.append(String.format("%.2f", Float.valueOf(baseItem.getFloat("attackTime") + baseTier.getFloat("armor") / 100.0f)));
                        info.append("\n");
                    }
                    if (baseItem.has("dodgeTime")) {
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.combat.time.dodge"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append("x");
                        info.append(String.format("%.2f", Float.valueOf(baseItem.getFloat("dodgeTime") - baseTier.getFloat("armor") / 100.0f)));
                        info.append("\n");
                    }
                    info.append("\n[#D4D4D4]");
                    info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "common.cost"));
                    info.append(": ");
                    info.append("[#A8A8A8]");
                    info.append(Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * (SmithMenuScreen.this.surplus ? 2 : 3) / 3 * (SmithMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(SmithMenuScreen.this.game, "legkil") : 100) / 100);
                    info.append("(");
                    info.append(Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * 2 / 3);
                    info.append(")");
                } else if (baseItem.has("baseDamage")) {
                    if (!baseItem.getString("baseDamage").equalsIgnoreCase("")) {
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.combat.damage.base"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(Integer.parseInt(baseItem.getString("baseDamage")) * (100 + baseTier.getInt("weaponBaseDamage") * (100 + SmithMenuScreen.this.tierBonus) / 100) / 1000);
                        info.append("\n");
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.combat.critical.chance"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(Integer.parseInt(baseItem.getString("criticalChance")) * (100 + baseTier.getInt("weaponCriticalChance")) / 100);
                        info.append("%");
                        info.append("\n");
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.combat.stamina.cost"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(Integer.parseInt(baseItem.getString("staminaCost")) * (100 + baseTier.getInt("weaponStaminaCost")) / 1000);
                        info.append("\n");
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.combat.time.attack"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(String.format("%.3f", Float.valueOf(Float.parseFloat(baseItem.getString("attackTime")) * (100.0f + (float)baseTier.getInt("weaponAttackTime")) / 100.0f / 1000.0f)));
                        info.append("s");
                        info.append("\n");
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.combat.time.parry"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append("x");
                        info.append(itemId.equalsIgnoreCase("dagger") && (SmithMenuScreen.this.game.saveGame.isEmpty() || SmithMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && SmithMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting") || SmithMenuScreen.this.game.gameMode.equalsIgnoreCase("story") && SmithMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting")) ? "0.65" : baseItem.getString("parryTime"));
                        info.append("\n");
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.combat.time.dodge"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append("x");
                        info.append(itemId.equalsIgnoreCase("dagger") && (SmithMenuScreen.this.game.saveGame.isEmpty() || SmithMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && SmithMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting") || SmithMenuScreen.this.game.gameMode.equalsIgnoreCase("story") && SmithMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting")) ? "0.65" : baseItem.getString("dodgeTime"));
                        extraInfo.append("[#D4D4D4]");
                        extraInfo.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "common.cost"));
                        extraInfo.append(": ");
                        extraInfo.append("[#A8A8A8]");
                        extraInfo.append(Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * (SmithMenuScreen.this.surplus ? 2 : 3) / 3 * (SmithMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(SmithMenuScreen.this.game, "legkil") : 100) / 100);
                        extraInfo.append("(");
                        extraInfo.append(Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * 2 / 3);
                        extraInfo.append(")");
                    } else {
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.combat.offhand.bonus"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "game.stats.items.weapons.offhand.bonus." + itemId));
                        info.append("\n\n[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(SmithMenuScreen.this.game.gameMessages, "common.cost"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * (SmithMenuScreen.this.surplus ? 2 : 3) / 3 * (SmithMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(SmithMenuScreen.this.game, "legkil") : 100) / 100);
                        info.append("(");
                        info.append(Integer.parseInt((String)SmithMenuScreen.this.selectedItem.params.get("cost")) * 2 / 3);
                        info.append(")");
                    }
                }
                SmithMenuScreen.this.itemInfo.setText(info.toString());
                SmithMenuScreen.this.itemInfo.layout();
                SmithMenuScreen.this.extraItemInfo.setText(extraInfo.toString());
                SmithMenuScreen.this.extraItemInfo.layout();
                if (realItemType.equalsIgnoreCase("weapons") && baseItem.has("baseDamage") && !baseItem.getString("baseDamage").equalsIgnoreCase("")) {
                    float prefHeightSafeguard = SmithMenuScreen.this.itemInfo.getPrefHeight();
                    float ySafeguard = SmithMenuScreen.this.itemBackground.getY() + SmithMenuScreen.this.itemBackground.getHeight() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 3.0f, 3.0f).floatValue();
                    SmithMenuScreen.this.statsBackground.setHeight(prefHeightSafeguard + UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue());
                    SmithMenuScreen.this.statsBackground.setWidth(SmithMenuScreen.this.statsBackground.getHeight());
                    SmithMenuScreen.this.statsBackground.setX(MathUtils.clamp(SmithMenuScreen.this.selectedItemName.getX() + SmithMenuScreen.this.selectedItemName.getPrefWidth(), SmithMenuScreen.this.selectedItem.getX() + SmithMenuScreen.this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 3.0f, 3.0f).floatValue(), SmithMenuScreen.this.itemBackground.getX() + SmithMenuScreen.this.itemBackground.getWidth()));
                    SmithMenuScreen.this.statsBackground.setY(ySafeguard - prefHeightSafeguard - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 3.0f, 3.0f).floatValue());
                    SmithMenuScreen.this.statsBackground.setVisible(true);
                    float baseDamage = baseItem.getFloat("baseDamage") * (100.0f + baseTier.getFloat("weaponBaseDamage") * (100.0f + (float)SmithMenuScreen.this.tierBonus) / 100.0f) / 100.0f;
                    SmithMenuScreen.this.statsBars.get(0).setWidth((baseDamage - SmithMenuScreen.this.weaponStats.get("baseDamage").get(0).floatValue()) / (SmithMenuScreen.this.weaponStats.get("baseDamage").get(1).floatValue() - SmithMenuScreen.this.weaponStats.get("baseDamage").get(0).floatValue()) * (SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                    if (SmithMenuScreen.this.statsBars.get(0).getWidth() == 0.0f) {
                        SmithMenuScreen.this.statsBars.get(0).setWidth((SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                    }
                    SmithMenuScreen.this.statsBars.get(0).setHeight((SmithMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(0).setX(SmithMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                    SmithMenuScreen.this.statsBars.get(0).setY(SmithMenuScreen.this.statsBackground.getY() + SmithMenuScreen.this.statsBackground.getHeight() * 83.5f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(0).setVisible(true);
                    float criticalChance = baseItem.getFloat("criticalChance") * (float)(100 + baseTier.getInt("weaponCriticalChance")) / 100.0f;
                    SmithMenuScreen.this.statsBars.get(1).setWidth((criticalChance - SmithMenuScreen.this.weaponStats.get("criticalChance").get(0).floatValue()) / (SmithMenuScreen.this.weaponStats.get("criticalChance").get(1).floatValue() - SmithMenuScreen.this.weaponStats.get("criticalChance").get(0).floatValue()) * (SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                    if (SmithMenuScreen.this.statsBars.get(1).getWidth() == 0.0f) {
                        SmithMenuScreen.this.statsBars.get(1).setWidth((SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                    }
                    SmithMenuScreen.this.statsBars.get(1).setHeight((SmithMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(1).setX(SmithMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                    SmithMenuScreen.this.statsBars.get(1).setY(SmithMenuScreen.this.statsBackground.getY() + SmithMenuScreen.this.statsBackground.getHeight() * 68.5f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(1).setVisible(true);
                    float staminaCost = baseItem.getFloat("staminaCost") * (float)(100 + baseTier.getInt("weaponStaminaCost")) / 100.0f;
                    SmithMenuScreen.this.statsBars.get(2).setWidth((1.0f - (staminaCost - SmithMenuScreen.this.weaponStats.get("staminaCost").get(0).floatValue()) / (SmithMenuScreen.this.weaponStats.get("staminaCost").get(1).floatValue() - SmithMenuScreen.this.weaponStats.get("staminaCost").get(0).floatValue())) * (SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                    if (SmithMenuScreen.this.statsBars.get(2).getWidth() == 0.0f) {
                        SmithMenuScreen.this.statsBars.get(2).setWidth((SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                    }
                    SmithMenuScreen.this.statsBars.get(2).setHeight((SmithMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(2).setX(SmithMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                    SmithMenuScreen.this.statsBars.get(2).setY(SmithMenuScreen.this.statsBackground.getY() + SmithMenuScreen.this.statsBackground.getHeight() * 53.5f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(2).setVisible(true);
                    float attackTime = baseItem.getFloat("attackTime") * (float)(100 + baseTier.getInt("weaponAttackTime")) / 100.0f;
                    SmithMenuScreen.this.statsBars.get(3).setWidth((1.0f - (attackTime - SmithMenuScreen.this.weaponStats.get("attackTime").get(0).floatValue()) / (SmithMenuScreen.this.weaponStats.get("attackTime").get(1).floatValue() - SmithMenuScreen.this.weaponStats.get("attackTime").get(0).floatValue())) * (SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                    if (SmithMenuScreen.this.statsBars.get(3).getWidth() == 0.0f) {
                        SmithMenuScreen.this.statsBars.get(3).setWidth((SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                    }
                    SmithMenuScreen.this.statsBars.get(3).setHeight((SmithMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(3).setX(SmithMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                    SmithMenuScreen.this.statsBars.get(3).setY(SmithMenuScreen.this.statsBackground.getY() + SmithMenuScreen.this.statsBackground.getHeight() * 38.5f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(3).setVisible(true);
                    float parryTime = baseItem.getFloat("parryTime");
                    if (itemId.equalsIgnoreCase("dagger") && (SmithMenuScreen.this.game.saveGame.isEmpty() || SmithMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting"))) {
                        parryTime = 0.75f;
                    }
                    SmithMenuScreen.this.statsBars.get(4).setWidth((1.0f - (parryTime - SmithMenuScreen.this.weaponStats.get("parryTime").get(0).floatValue()) / (SmithMenuScreen.this.weaponStats.get("parryTime").get(1).floatValue() - SmithMenuScreen.this.weaponStats.get("parryTime").get(0).floatValue())) * (SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                    if (SmithMenuScreen.this.statsBars.get(4).getWidth() == 0.0f) {
                        SmithMenuScreen.this.statsBars.get(4).setWidth((SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                    }
                    SmithMenuScreen.this.statsBars.get(4).setHeight((SmithMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(4).setX(SmithMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                    SmithMenuScreen.this.statsBars.get(4).setY(SmithMenuScreen.this.statsBackground.getY() + SmithMenuScreen.this.statsBackground.getHeight() * 24.0f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(4).setVisible(true);
                    float dodgeTime = baseItem.getFloat("dodgeTime");
                    if (itemId.equalsIgnoreCase("dagger") && (SmithMenuScreen.this.game.saveGame.isEmpty() || SmithMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting"))) {
                        dodgeTime = 0.75f;
                    }
                    SmithMenuScreen.this.statsBars.get(5).setWidth((1.0f - (dodgeTime - SmithMenuScreen.this.weaponStats.get("dodgeTime").get(0).floatValue()) / (SmithMenuScreen.this.weaponStats.get("dodgeTime").get(1).floatValue() - SmithMenuScreen.this.weaponStats.get("dodgeTime").get(0).floatValue())) * (SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                    if (SmithMenuScreen.this.statsBars.get(5).getWidth() == 0.0f) {
                        SmithMenuScreen.this.statsBars.get(5).setWidth((SmithMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                    }
                    SmithMenuScreen.this.statsBars.get(5).setHeight((SmithMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(5).setX(SmithMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                    SmithMenuScreen.this.statsBars.get(5).setY(SmithMenuScreen.this.statsBackground.getY() + SmithMenuScreen.this.statsBackground.getHeight() * 9.5f / 100.0f);
                    SmithMenuScreen.this.statsBars.get(5).setVisible(true);
                    SmithMenuScreen.this.itemInfo.setX(SmithMenuScreen.this.statsBackground.getX() + SmithMenuScreen.this.statsBackground.getWidth() + UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue());
                    SmithMenuScreen.this.itemInfo.setY(SmithMenuScreen.this.itemBackground.getY() + SmithMenuScreen.this.itemBackground.getHeight() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 5.0f, 5.0f).floatValue());
                    SmithMenuScreen.this.extraItemInfo.setVisible(true);
                    SmithMenuScreen.this.extraItemInfo.setX(SmithMenuScreen.this.itemBackground.getX() + SmithMenuScreen.this.itemBackground.getWidth() - SmithMenuScreen.this.itemBackground.getWidth() / 5.0f - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 5.0f, 5.0f).floatValue());
                    SmithMenuScreen.this.extraItemInfo.setWidth(SmithMenuScreen.this.itemBackground.getX() + SmithMenuScreen.this.itemBackground.getWidth() - SmithMenuScreen.this.extraItemInfo.getX() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 5.0f, 5.0f).floatValue());
                    SmithMenuScreen.this.extraItemInfo.setY(SmithMenuScreen.this.itemInfo.getY());
                    SmithMenuScreen.this.extraItemInfo.layout();
                } else {
                    SmithMenuScreen.this.extraItemInfo.setVisible(false);
                    SmithMenuScreen.this.statsBackground.setVisible(false);
                    for (BaseActor currBar : SmithMenuScreen.this.statsBars) {
                        currBar.setVisible(false);
                    }
                    SmithMenuScreen.this.itemInfo.setX(MathUtils.clamp(SmithMenuScreen.this.selectedItemName.getX() + SmithMenuScreen.this.selectedItemName.getPrefWidth(), SmithMenuScreen.this.selectedItem.getX() + SmithMenuScreen.this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 2.0f, 2.0f).floatValue(), SmithMenuScreen.this.itemBackground.getX() + SmithMenuScreen.this.itemBackground.getWidth()));
                    SmithMenuScreen.this.itemInfo.setY(SmithMenuScreen.this.itemBackground.getY() + SmithMenuScreen.this.itemBackground.getHeight() - UIHelpers.calcHeightProportion(SmithMenuScreen.this.game, 4.0f, 4.0f).floatValue());
                }
                SmithMenuScreen.this.stage.setScrollFocus(SmithMenuScreen.this.itemPane);
                SmithMenuScreen.this.itemPane.setScrollX(SmithMenuScreen.this.itemPane.getScrollX());
            }
        };
    }
}

