/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.game.Story;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.DuelSetupScreen;
import com.calimasaga.slavepits.screen.PrepSetupScreen;
import com.calimasaga.slavepits.screen.TournamentEventScreen;
import com.calimasaga.slavepits.screen.TournamentSetupScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.HashMap;

public class ServicesMenuScreen
extends BaseScreen {
    private BaseScreen previousScreen;
    public Fighter fighter;
    public String servicesOrig;
    public HashMap<String, Integer> stocksOrig;
    public HashMap<String, Integer> storeOrig;
    public HashMap<String, Integer> storeAfter;
    public String fighterType;
    public String opponent;
    public int maxReputation;
    public int profits;
    public String storeOption;
    private NinePatchActor iconsBackground;
    private NinePatchActor serviceBackground;
    public Label reputationLabel;
    public BaseActor shard;
    public BaseActor shardOutline;
    public Label shardStock;
    public Label shardstoremultiplier;
    public BaseActor powder;
    public BaseActor powderOutline;
    public Label powderStock;
    public Label powderstoremultiplier;
    public BaseActor net;
    public BaseActor netOutline;
    public Label netStock;
    public Label netstoremultiplier;
    public BaseActor upgradearmor;
    public BaseActor upgradearmorOutline;
    public Label upgradearmorStock;
    public Label upgradearmormultiplier;
    public Label upgradearmorstoremultiplier;
    public BaseActor upgradeweapon;
    public BaseActor upgradeweaponOutline;
    public Label upgradeweaponStock;
    public Label upgradeweaponmultiplier;
    public Label upgradeweaponstoremultiplier;
    public BaseActor choice;
    public BaseActor choiceOutline;
    public BaseActor care;
    public BaseActor careOutline;
    public Label careStock;
    public Label carestoremultiplier;
    public BaseActor info;
    public BaseActor infoOutline;
    public Label infoStock;
    public Label infostoremultiplier;
    public BaseActor potion;
    public BaseActor potionOutline;
    public Label potionStock;
    public Label potionstoremultiplier;
    public BaseActor selectedService;
    public Label selectedServiceName;
    public Label serviceInfo;
    public Button buyService;
    public Button cancelService;
    private Button applyButton;
    private Button exitButton;

    public ServicesMenuScreen(SlavePitsGame g, BaseScreen s, Fighter selectedFighter, String type, int reputationLimit, String opponentName, int leftProfits, String storeType) {
        super(g);
        this.previousScreen = s;
        this.fighter = Fighter.clone(selectedFighter, true);
        this.servicesOrig = this.fighter.services;
        if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            this.stocksOrig = Tournament.getServicesAvailable(g);
            this.storeOrig = Tournament.getServicesStore(g, "");
            this.storeAfter = Tournament.getServicesStore(g, "");
            this.storeOption = storeType;
        }
        this.fighterType = type;
        this.opponent = opponentName;
        this.maxReputation = reputationLimit;
        this.profits = leftProfits;
        this.create();
    }

    @Override
    public void create() {
        int numStock;
        int numStock2;
        int serviceMultiplierPosition;
        int numStock3;
        float iconSize = UIHelpers.calcHeightProportion(this.game, 10.0f, 8.0f).floatValue();
        this.iconsBackground = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.iconsBackground.setWidth(UIHelpers.calcWidthProportion(this.game, 80.0f, 98.0f).floatValue());
        this.iconsBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 53.0f, 59.0f).floatValue());
        this.iconsBackground.setX(UIHelpers.calcWidthProportion(this.game, 10.0f, 1.0f).floatValue());
        this.iconsBackground.setY(UIHelpers.calcHeightProportion(this.game, 42.0f, 40.0f).floatValue());
        this.stage.addActor(this.iconsBackground);
        this.serviceBackground = new NinePatchActor(this.game.uiSkin.get("scrollpanel", NinePatch.class));
        this.serviceBackground.setWidth(this.iconsBackground.getWidth());
        this.serviceBackground.setHeight(this.iconsBackground.getHeight() / 2.0f);
        this.serviceBackground.setX(this.iconsBackground.getX());
        this.serviceBackground.setY(this.iconsBackground.getY() - this.serviceBackground.getHeight());
        this.stage.addActor(this.serviceBackground);
        if (this.game.gameMode.equalsIgnoreCase("story")) {
            this.reputationLabel = new Label("" + this.profits, this.game.uiSkin, "default");
            this.reputationLabel.setColor(this.game.uiSkin.get("iron", Color.class));
        } else if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            if (this.storeAfter == null || this.stocksOrig.isEmpty()) {
                this.reputationLabel = new Label("", this.game.uiSkin, "default");
                this.reputationLabel.setColor(Color.RED);
            } else {
                this.reputationLabel = new Label("" + this.profits, this.game.uiSkin, "default");
                this.reputationLabel.setColor(this.game.uiSkin.get("iron", Color.class));
            }
        } else {
            this.reputationLabel = new Label(this.fighter.reputation + " / " + (this.maxReputation == 0 ? "-" : Integer.valueOf(this.maxReputation)), this.game.uiSkin, "default");
            this.reputationLabel.setColor(Color.RED);
        }
        this.reputationLabel.setAlignment(1);
        this.reputationLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue());
        this.reputationLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.reputationLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.reputationLabel.getWidth() / 2.0f);
        this.reputationLabel.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 95.0f / 100.0f - this.reputationLabel.getPrefHeight());
        this.stage.addActor(this.reputationLabel);
        TextureAtlas servicesAtlas = this.game.manager.get(this.game.getOverridenAsset("data/equipment/services.atlas"), TextureAtlas.class);
        Label usage = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.services.category.usage") + ": ", this.game.uiSkin, "default");
        usage.setAlignment(10);
        usage.setColor(this.game.uiSkin.get("lightiron", Color.class));
        usage.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        if (this.game.portraitmode) {
            usage.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() / 2.0f - usage.getPrefWidth() / 2.0f);
            usage.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 81.0f / 100.0f);
        } else {
            usage.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 5.0f / 100.0f);
            usage.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 70.0f / 100.0f);
        }
        this.stage.addActor(usage);
        int numService = 1;
        this.shard = new BaseActor();
        this.shard.setTexture(servicesAtlas.findRegion("sershard"), iconSize, iconSize);
        this.shard.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                ServicesMenuScreen.this.showService(ServicesMenuScreen.this.shard, "shard");
            }
        });
        this.shard.params.put("cost", "50");
        if (this.storeOption != null) {
            this.shard.params.put("cost", "" + (this.storeOption.equalsIgnoreCase("smuggler") ? 10 + MathUtils.random(15) : 15));
        }
        this.shard.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * (float)(5 + numService * 20) / 100.0f);
        this.shard.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 65.0f / 100.0f);
        this.shardOutline = new BaseActor();
        this.shardOutline.setTexture(servicesAtlas.findRegion("outlineOwned"), iconSize + 2.0f, iconSize + 2.0f);
        if (this.game.gameMode.equalsIgnoreCase("story") && Story.isServiceFree(this.game, "shard")) {
            this.shardOutline.setTexture(servicesAtlas.findRegion("outlineFree"), iconSize + 2.0f, iconSize + 2.0f);
        }
        this.shardOutline.setVisible(false);
        if (this.fighter.services.contains("shard")) {
            this.shardOutline.setVisible(true);
        }
        this.shardOutline.setX(this.shard.getX() - 1.0f);
        this.shardOutline.setY(this.shard.getY() - 1.0f);
        this.stage.addActor(this.shardOutline);
        this.stage.addActor(this.shard);
        if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            numStock3 = this.stocksOrig.get("shard");
            this.shardStock = new Label("x" + numStock3, this.game.uiSkin, "default");
            this.shardStock.setAlignment(10);
            this.shardStock.setColor(this.game.uiSkin.get(numStock3 == 0 ? "red" : "green", Color.class));
            this.shardStock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            this.shardStock.setWidth(iconSize / 2.0f);
            this.shardStock.setX(this.shard.getX() + this.shard.getWidth() + 3.0f);
            this.shardStock.setY(this.shard.getY() + this.shard.getHeight() - this.shardStock.getPrefHeight());
            this.shardStock.layout();
            this.stage.addActor(this.shardStock);
            if (this.storeAfter != null && !this.storeAfter.isEmpty()) {
                this.shardstoremultiplier = new Label("x" + this.storeAfter.get("shard"), this.game.uiSkin, "default");
                this.shardstoremultiplier.setAlignment(10);
                this.shardstoremultiplier.setColor(this.game.uiSkin.get("lightiron", Color.class));
                this.shardstoremultiplier.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                this.shardstoremultiplier.setX(this.shardOutline.getX() + this.shardOutline.getWidth() + 3.0f);
                this.shardstoremultiplier.setY(this.shardOutline.getY() + this.shardOutline.getHeight() / 2.0f - this.shardstoremultiplier.getPrefHeight() / 2.0f);
                this.shardstoremultiplier.setVisible(true);
                this.stage.addActor(this.shardstoremultiplier);
            }
        }
        ++numService;
        this.powder = new BaseActor();
        this.powder.setTexture(servicesAtlas.findRegion("serpowder"), iconSize, iconSize);
        this.powder.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                ServicesMenuScreen.this.showService(ServicesMenuScreen.this.powder, "powder");
            }
        });
        this.powder.params.put("cost", "50");
        if (this.storeOption != null) {
            this.powder.params.put("cost", "" + (this.storeOption.equalsIgnoreCase("smuggler") ? 10 + MathUtils.random(15) : 15));
        }
        this.powder.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * (float)(5 + numService * 20) / 100.0f);
        this.powder.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 65.0f / 100.0f);
        this.powderOutline = new BaseActor();
        this.powderOutline.setTexture(servicesAtlas.findRegion("outlineOwned"), iconSize + 2.0f, iconSize + 2.0f);
        if (this.game.gameMode.equalsIgnoreCase("story") && Story.isServiceFree(this.game, "powder")) {
            this.powderOutline.setTexture(servicesAtlas.findRegion("outlineFree"), iconSize + 2.0f, iconSize + 2.0f);
        }
        this.powderOutline.setVisible(false);
        if (this.fighter.services.contains("powder")) {
            this.powderOutline.setVisible(true);
        }
        this.powderOutline.setX(this.powder.getX() - 1.0f);
        this.powderOutline.setY(this.powder.getY() - 1.0f);
        this.stage.addActor(this.powderOutline);
        this.stage.addActor(this.powder);
        if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            numStock3 = this.stocksOrig.get("powder");
            this.powderStock = new Label("x" + numStock3, this.game.uiSkin, "default");
            this.powderStock.setAlignment(10);
            this.powderStock.setColor(this.game.uiSkin.get(numStock3 == 0 ? "red" : "green", Color.class));
            this.powderStock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            this.powderStock.setWidth(iconSize / 2.0f);
            this.powderStock.setX(this.powder.getX() + this.powder.getWidth() + 3.0f);
            this.powderStock.setY(this.powder.getY() + this.powder.getHeight() - this.powderStock.getPrefHeight());
            this.stage.addActor(this.powderStock);
            if (this.storeAfter != null && !this.storeAfter.isEmpty()) {
                this.powderstoremultiplier = new Label("x" + this.storeAfter.get("powder"), this.game.uiSkin, "default");
                this.powderstoremultiplier.setAlignment(10);
                this.powderstoremultiplier.setColor(this.game.uiSkin.get("lightiron", Color.class));
                this.powderstoremultiplier.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                this.powderstoremultiplier.setX(this.powderOutline.getX() + this.powderOutline.getWidth() + 3.0f);
                this.powderstoremultiplier.setY(this.powderOutline.getY() + this.powderOutline.getHeight() / 2.0f - this.powderstoremultiplier.getPrefHeight() / 2.0f);
                this.powderstoremultiplier.setVisible(true);
                this.stage.addActor(this.powderstoremultiplier);
            }
        }
        ++numService;
        this.net = new BaseActor();
        this.net.setTexture(servicesAtlas.findRegion("sernet"), iconSize, iconSize);
        this.net.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                ServicesMenuScreen.this.showService(ServicesMenuScreen.this.net, "net");
            }
        });
        this.net.params.put("cost", "50");
        if (this.storeOption != null) {
            this.net.params.put("cost", "" + (this.storeOption.equalsIgnoreCase("smuggler") ? 10 + MathUtils.random(15) : 15));
        }
        this.net.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * (float)(5 + numService * 20) / 100.0f);
        this.net.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 65.0f / 100.0f);
        this.netOutline = new BaseActor();
        this.netOutline.setTexture(servicesAtlas.findRegion("outlineOwned"), iconSize + 2.0f, iconSize + 2.0f);
        if (this.game.gameMode.equalsIgnoreCase("story") && Story.isServiceFree(this.game, "net")) {
            this.netOutline.setTexture(servicesAtlas.findRegion("outlineFree"), iconSize + 2.0f, iconSize + 2.0f);
        }
        this.netOutline.setVisible(false);
        if (this.fighter.services.contains("net")) {
            this.netOutline.setVisible(true);
        }
        this.netOutline.setX(this.net.getX() - 1.0f);
        this.netOutline.setY(this.net.getY() - 1.0f);
        if (this.game.gameMode.equalsIgnoreCase("story") && this.game.saveGame.get("phase").equalsIgnoreCase("pits")) {
            this.net.setVisible(false);
            this.netOutline.setVisible(false);
        }
        this.stage.addActor(this.netOutline);
        this.stage.addActor(this.net);
        if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            numStock3 = this.stocksOrig.get("net");
            this.netStock = new Label("x" + numStock3, this.game.uiSkin, "default");
            this.netStock.setAlignment(10);
            this.netStock.setColor(this.game.uiSkin.get(numStock3 == 0 ? "red" : "green", Color.class));
            this.netStock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            this.netStock.setWidth(iconSize / 2.0f);
            this.netStock.setX(this.net.getX() + this.net.getWidth() + 3.0f);
            this.netStock.setY(this.net.getY() + this.net.getHeight() - this.netStock.getPrefHeight());
            this.stage.addActor(this.netStock);
            if (this.storeAfter != null && !this.storeAfter.isEmpty()) {
                this.netstoremultiplier = new Label("x" + this.storeAfter.get("net"), this.game.uiSkin, "default");
                this.netstoremultiplier.setAlignment(10);
                this.netstoremultiplier.setColor(this.game.uiSkin.get("lightiron", Color.class));
                this.netstoremultiplier.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                this.netstoremultiplier.setX(this.netOutline.getX() + this.netOutline.getWidth() + 3.0f);
                this.netstoremultiplier.setY(this.netOutline.getY() + this.netOutline.getHeight() / 2.0f - this.netstoremultiplier.getPrefHeight() / 2.0f);
                this.netstoremultiplier.setVisible(true);
                this.stage.addActor(this.netstoremultiplier);
            }
        }
        Label equipment = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.services.category.equipment") + ": ", this.game.uiSkin, "default");
        equipment.setAlignment(10);
        equipment.setColor(this.game.uiSkin.get("lightiron", Color.class));
        equipment.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        if (this.game.portraitmode) {
            equipment.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() / 2.0f - equipment.getPrefWidth() / 2.0f);
            equipment.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 56.0f / 100.0f);
        } else {
            equipment.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 5.0f / 100.0f);
            equipment.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 45.0f / 100.0f);
        }
        this.stage.addActor(equipment);
        numService = 1;
        this.upgradearmor = new BaseActor();
        this.upgradearmor.setTexture(servicesAtlas.findRegion("serupgradearmor"), iconSize, iconSize);
        this.upgradearmor.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                ServicesMenuScreen.this.showService(ServicesMenuScreen.this.upgradearmor, "upgradearmor");
            }
        });
        this.upgradearmor.params.put("cost", "50");
        if (this.storeOption != null) {
            this.upgradearmor.params.put("cost", "" + (this.storeOption.equalsIgnoreCase("smuggler") ? 4 + MathUtils.random(6) : 6));
        }
        this.upgradearmor.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * (float)(5 + numService * 20) / 100.0f);
        this.upgradearmor.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 40.0f / 100.0f);
        this.upgradearmorOutline = new BaseActor();
        this.upgradearmorOutline.setTexture(servicesAtlas.findRegion("outlineOwned"), iconSize + 2.0f, iconSize + 2.0f);
        if (this.game.gameMode.equalsIgnoreCase("story") && Story.isServiceFree(this.game, "upgradearmor")) {
            this.upgradearmorOutline.setTexture(servicesAtlas.findRegion("outlineFree"), iconSize + 2.0f, iconSize + 2.0f);
        }
        this.upgradearmorOutline.setVisible(false);
        this.upgradearmorOutline.setX(this.upgradearmor.getX() - 1.0f);
        this.upgradearmorOutline.setY(this.upgradearmor.getY() - 1.0f);
        this.stage.addActor(this.upgradearmorOutline);
        this.stage.addActor(this.upgradearmor);
        this.upgradearmormultiplier = new Label("x0", this.game.uiSkin, "default");
        this.upgradearmormultiplier.setAlignment(10);
        this.upgradearmormultiplier.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.upgradearmormultiplier.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.upgradearmormultiplier.setX(this.upgradearmorOutline.getX() + this.upgradearmorOutline.getWidth() + 3.0f);
        this.upgradearmormultiplier.setY(this.upgradearmorOutline.getY() + this.upgradearmorOutline.getHeight() / 2.0f - this.upgradearmormultiplier.getPrefHeight() / 2.0f);
        this.upgradearmormultiplier.setVisible(false);
        this.stage.addActor(this.upgradearmormultiplier);
        if (this.fighter.services.contains("upgradearmor")) {
            serviceMultiplierPosition = this.fighter.services.indexOf("upgradearmor") + 13;
            int currArmorMultiplier = Integer.parseInt(this.fighter.services.substring(serviceMultiplierPosition, serviceMultiplierPosition + 1));
            this.upgradearmormultiplier.setText("x" + currArmorMultiplier);
            this.upgradearmormultiplier.setVisible(true);
            this.upgradearmorOutline.setVisible(true);
        }
        if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            numStock2 = this.stocksOrig.get("upgradearmor");
            this.upgradearmorStock = new Label("x" + numStock2, this.game.uiSkin, "default");
            this.upgradearmorStock.setAlignment(10);
            this.upgradearmorStock.setColor(this.game.uiSkin.get(numStock2 == 0 ? "red" : "green", Color.class));
            this.upgradearmorStock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            this.upgradearmorStock.setWidth(iconSize / 2.0f);
            this.upgradearmorStock.setX(this.upgradearmor.getX() + this.upgradearmor.getWidth() + 3.0f);
            this.upgradearmorStock.setY(this.upgradearmor.getY() + this.upgradearmor.getHeight() - this.upgradearmorStock.getPrefHeight());
            this.stage.addActor(this.upgradearmorStock);
            if (this.storeAfter != null && !this.storeAfter.isEmpty()) {
                this.upgradearmorstoremultiplier = new Label("x" + this.storeAfter.get("upgradearmor"), this.game.uiSkin, "default");
                this.upgradearmorstoremultiplier.setAlignment(10);
                this.upgradearmorstoremultiplier.setColor(this.game.uiSkin.get("lightiron", Color.class));
                this.upgradearmorstoremultiplier.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                this.upgradearmorstoremultiplier.setX(this.upgradearmorOutline.getX() + this.upgradearmorOutline.getWidth() + 3.0f);
                this.upgradearmorstoremultiplier.setY(this.upgradearmorOutline.getY() + this.upgradearmorOutline.getHeight() / 2.0f - this.upgradearmorstoremultiplier.getPrefHeight() / 2.0f);
                this.upgradearmorstoremultiplier.setVisible(true);
                this.stage.addActor(this.upgradearmorstoremultiplier);
            }
        }
        ++numService;
        this.upgradeweapon = new BaseActor();
        this.upgradeweapon.setTexture(servicesAtlas.findRegion("serupgradeweapon"), iconSize, iconSize);
        this.upgradeweapon.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                ServicesMenuScreen.this.showService(ServicesMenuScreen.this.upgradeweapon, "upgradeweapon");
            }
        });
        this.upgradeweapon.params.put("cost", "100");
        if (this.storeOption != null) {
            this.upgradeweapon.params.put("cost", "" + (this.storeOption.equalsIgnoreCase("smuggler") ? 11 + MathUtils.random(16) : 16));
        }
        this.upgradeweapon.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * (float)(5 + numService * 20) / 100.0f);
        this.upgradeweapon.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 40.0f / 100.0f);
        this.upgradeweaponOutline = new BaseActor();
        this.upgradeweaponOutline.setTexture(servicesAtlas.findRegion("outlineOwned"), iconSize + 2.0f, iconSize + 2.0f);
        if (this.game.gameMode.equalsIgnoreCase("story") && Story.isServiceFree(this.game, "upgradeweapon")) {
            this.upgradeweaponOutline.setTexture(servicesAtlas.findRegion("outlineFree"), iconSize + 2.0f, iconSize + 2.0f);
        }
        this.upgradeweaponOutline.setVisible(false);
        this.upgradeweaponOutline.setX(this.upgradeweapon.getX() - 1.0f);
        this.upgradeweaponOutline.setY(this.upgradeweapon.getY() - 1.0f);
        this.stage.addActor(this.upgradeweaponOutline);
        this.stage.addActor(this.upgradeweapon);
        this.upgradeweaponmultiplier = new Label("x0", this.game.uiSkin, "default");
        this.upgradeweaponmultiplier.setAlignment(10);
        this.upgradeweaponmultiplier.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.upgradeweaponmultiplier.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.upgradeweaponmultiplier.setX(this.upgradeweaponOutline.getX() + this.upgradeweaponOutline.getWidth() + 3.0f);
        this.upgradeweaponmultiplier.setY(this.upgradeweaponOutline.getY() + this.upgradeweaponOutline.getHeight() / 2.0f - this.upgradeweaponmultiplier.getPrefHeight() / 2.0f);
        this.upgradeweaponmultiplier.setVisible(false);
        this.stage.addActor(this.upgradeweaponmultiplier);
        if (this.fighter.services.contains("upgradeweapon")) {
            serviceMultiplierPosition = this.fighter.services.indexOf("upgradeweapon") + 14;
            int currWeaponMultiplier = Integer.parseInt(this.fighter.services.substring(serviceMultiplierPosition, serviceMultiplierPosition + 1));
            this.upgradeweaponmultiplier.setText("x" + currWeaponMultiplier);
            this.upgradeweaponmultiplier.setVisible(true);
            this.upgradeweaponOutline.setVisible(true);
        }
        if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            numStock2 = this.stocksOrig.get("upgradeweapon");
            this.upgradeweaponStock = new Label("x" + numStock2, this.game.uiSkin, "default");
            this.upgradeweaponStock.setAlignment(10);
            this.upgradeweaponStock.setColor(this.game.uiSkin.get(numStock2 == 0 ? "red" : "green", Color.class));
            this.upgradeweaponStock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            this.upgradeweaponStock.setWidth(iconSize / 2.0f);
            this.upgradeweaponStock.setX(this.upgradeweapon.getX() + this.upgradeweapon.getWidth() + 3.0f);
            this.upgradeweaponStock.setY(this.upgradeweapon.getY() + this.upgradeweapon.getHeight() - this.upgradeweaponStock.getPrefHeight());
            this.stage.addActor(this.upgradeweaponStock);
            if (this.storeAfter != null && !this.storeAfter.isEmpty()) {
                this.upgradeweaponstoremultiplier = new Label("x" + this.storeAfter.get("upgradeweapon"), this.game.uiSkin, "default");
                this.upgradeweaponstoremultiplier.setAlignment(10);
                this.upgradeweaponstoremultiplier.setColor(this.game.uiSkin.get("lightiron", Color.class));
                this.upgradeweaponstoremultiplier.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                this.upgradeweaponstoremultiplier.setX(this.upgradeweaponOutline.getX() + this.upgradeweaponOutline.getWidth() + 3.0f);
                this.upgradeweaponstoremultiplier.setY(this.upgradeweaponOutline.getY() + this.upgradeweaponOutline.getHeight() / 2.0f - this.upgradeweaponstoremultiplier.getPrefHeight() / 2.0f);
                this.upgradeweaponstoremultiplier.setVisible(true);
                this.stage.addActor(this.upgradeweaponstoremultiplier);
            }
        }
        ++numService;
        if (this.game.gameMode.equalsIgnoreCase("story")) {
            this.choice = new BaseActor();
            this.choice.setTexture(servicesAtlas.findRegion("serchoice"), iconSize, iconSize);
            this.choice.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    ServicesMenuScreen.this.showService(ServicesMenuScreen.this.choice, "choice");
                }
            });
            this.choice.params.put("cost", "100");
            this.choice.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * (float)(5 + numService * 20) / 100.0f);
            this.choice.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 40.0f / 100.0f);
            this.choiceOutline = new BaseActor();
            this.choiceOutline.setTexture(servicesAtlas.findRegion("outlineOwned"), iconSize + 2.0f, iconSize + 2.0f);
            if (this.game.gameMode.equalsIgnoreCase("story") && Story.isServiceFree(this.game, "choice")) {
                this.choiceOutline.setTexture(servicesAtlas.findRegion("outlineFree"), iconSize + 2.0f, iconSize + 2.0f);
            }
            this.choiceOutline.setVisible(false);
            if (this.fighter.services.contains("choice")) {
                this.choiceOutline.setVisible(true);
            }
            this.choiceOutline.setX(this.choice.getX() - 1.0f);
            this.choiceOutline.setY(this.choice.getY() - 1.0f);
            this.stage.addActor(this.choiceOutline);
            this.stage.addActor(this.choice);
            ++numService;
        }
        Label other = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.services.category.other") + ": ", this.game.uiSkin, "default");
        other.setAlignment(10);
        other.setColor(this.game.uiSkin.get("lightiron", Color.class));
        other.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        if (this.game.portraitmode) {
            other.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() / 2.0f - other.getPrefWidth() / 2.0f);
            other.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 31.0f / 100.0f);
        } else {
            other.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * 5.0f / 100.0f);
            other.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 20.0f / 100.0f);
        }
        this.stage.addActor(other);
        numService = 1;
        if (this.game.gameMode.equalsIgnoreCase("story") || this.game.gameMode.equalsIgnoreCase("tournament") && (this.game.saveGame.get("special") == null || !this.game.saveGame.get("special").contains("combat"))) {
            if (this.storeAfter != null || this.fighter.life < 10000) {
                this.care = new BaseActor();
                this.care.setTexture(servicesAtlas.findRegion("sercare"), iconSize, iconSize);
                this.care.addListener(new InputListener(){

                    @Override
                    public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                        return true;
                    }

                    @Override
                    public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                        ServicesMenuScreen.this.showService(ServicesMenuScreen.this.care, "care");
                    }
                });
                this.care.params.put("cost", "100");
                if (this.storeOption != null) {
                    this.care.params.put("cost", "" + (this.storeOption.equalsIgnoreCase("smuggler") ? 30 + MathUtils.random(40) : 40));
                }
                this.care.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * (float)(5 + numService * 20) / 100.0f);
                this.care.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 15.0f / 100.0f);
                this.careOutline = new BaseActor();
                this.careOutline.setTexture(servicesAtlas.findRegion("outlineOwned"), iconSize + 2.0f, iconSize + 2.0f);
                if (this.game.gameMode.equalsIgnoreCase("story") && Story.isServiceFree(this.game, "care")) {
                    this.careOutline.setTexture(servicesAtlas.findRegion("outlineFree"), iconSize + 2.0f, iconSize + 2.0f);
                }
                this.careOutline.setVisible(false);
                if (this.fighter.services.contains("care")) {
                    this.careOutline.setVisible(true);
                }
                this.careOutline.setX(this.care.getX() - 1.0f);
                this.careOutline.setY(this.care.getY() - 1.0f);
                this.stage.addActor(this.careOutline);
                this.stage.addActor(this.care);
                if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                    numStock = this.stocksOrig.get("care");
                    this.careStock = new Label("x" + numStock, this.game.uiSkin, "default");
                    this.careStock.setAlignment(10);
                    this.careStock.setColor(this.game.uiSkin.get(numStock == 0 ? "red" : "green", Color.class));
                    this.careStock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                    this.careStock.setWidth(iconSize / 2.0f);
                    this.careStock.setX(this.care.getX() + this.care.getWidth() + 3.0f);
                    this.careStock.setY(this.care.getY() + this.care.getHeight() - this.careStock.getPrefHeight());
                    this.stage.addActor(this.careStock);
                    if (this.storeAfter != null && !this.storeAfter.isEmpty()) {
                        this.carestoremultiplier = new Label("x" + this.storeAfter.get("care"), this.game.uiSkin, "default");
                        this.carestoremultiplier.setAlignment(10);
                        this.carestoremultiplier.setColor(this.game.uiSkin.get("lightiron", Color.class));
                        this.carestoremultiplier.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                        this.carestoremultiplier.setX(this.careOutline.getX() + this.careOutline.getWidth() + 3.0f);
                        this.carestoremultiplier.setY(this.careOutline.getY() + this.careOutline.getHeight() / 2.0f - this.carestoremultiplier.getPrefHeight() / 2.0f);
                        this.carestoremultiplier.setVisible(true);
                        this.stage.addActor(this.carestoremultiplier);
                    }
                }
                ++numService;
            }
            this.info = new BaseActor();
            this.info.setTexture(servicesAtlas.findRegion("serinfo"), iconSize, iconSize);
            this.info.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    ServicesMenuScreen.this.showService(ServicesMenuScreen.this.info, "info");
                }
            });
            this.info.params.put("cost", "100");
            if (this.storeOption != null) {
                this.info.params.put("cost", "" + (this.storeOption.equalsIgnoreCase("smuggler") ? 20 + MathUtils.random(30) : 30));
            }
            this.info.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * (float)(5 + numService * 20) / 100.0f);
            this.info.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 15.0f / 100.0f);
            this.infoOutline = new BaseActor();
            this.infoOutline.setTexture(servicesAtlas.findRegion("outlineOwned"), iconSize + 2.0f, iconSize + 2.0f);
            if (this.game.gameMode.equalsIgnoreCase("story") && Story.isServiceFree(this.game, "info")) {
                this.infoOutline.setTexture(servicesAtlas.findRegion("outlineFree"), iconSize + 2.0f, iconSize + 2.0f);
            }
            this.infoOutline.setVisible(false);
            if (this.fighter.services.contains("info")) {
                this.infoOutline.setVisible(true);
            }
            this.infoOutline.setX(this.info.getX() - 1.0f);
            this.infoOutline.setY(this.info.getY() - 1.0f);
            this.stage.addActor(this.infoOutline);
            this.stage.addActor(this.info);
            if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                numStock = this.stocksOrig.get("info");
                this.infoStock = new Label("x" + numStock, this.game.uiSkin, "default");
                this.infoStock.setAlignment(10);
                this.infoStock.setColor(this.game.uiSkin.get(numStock == 0 ? "red" : "green", Color.class));
                this.infoStock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                this.infoStock.setWidth(iconSize / 2.0f);
                this.infoStock.setX(this.info.getX() + this.info.getWidth() + 3.0f);
                this.infoStock.setY(this.info.getY() + this.info.getHeight() - this.infoStock.getPrefHeight());
                this.stage.addActor(this.infoStock);
                if (this.storeAfter != null && !this.storeAfter.isEmpty()) {
                    this.infostoremultiplier = new Label("x" + this.storeAfter.get("info"), this.game.uiSkin, "default");
                    this.infostoremultiplier.setAlignment(10);
                    this.infostoremultiplier.setColor(this.game.uiSkin.get("lightiron", Color.class));
                    this.infostoremultiplier.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                    this.infostoremultiplier.setX(this.infoOutline.getX() + this.infoOutline.getWidth() + 3.0f);
                    this.infostoremultiplier.setY(this.infoOutline.getY() + this.infoOutline.getHeight() / 2.0f - this.infostoremultiplier.getPrefHeight() / 2.0f);
                    this.infostoremultiplier.setVisible(true);
                    this.stage.addActor(this.infostoremultiplier);
                }
            }
            if (!this.opponent.equalsIgnoreCase("") && (this.opponent.equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "talk.boss1.name")) || this.opponent.equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "talk.boss2.name")) || this.opponent.equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "talk.boss3.name")) || this.opponent.equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "talk.tournamentboss1.name")) || this.opponent.equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "talk.tournamentboss2.name")) || this.opponent.equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "talk.tournamentboss3.name")))) {
                this.info.setVisible(false);
                this.infoOutline.setVisible(false);
                if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                    if (this.infoStock != null) {
                        this.infoStock.setVisible(false);
                    }
                    if (this.infostoremultiplier != null) {
                        this.infostoremultiplier.setVisible(false);
                    }
                }
            }
            ++numService;
        }
        this.potion = new BaseActor();
        this.potion.setTexture(servicesAtlas.findRegion("serpotion"), iconSize, iconSize);
        this.potion.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                ServicesMenuScreen.this.showService(ServicesMenuScreen.this.potion, "potion");
            }
        });
        this.potion.params.put("cost", "100");
        if (this.storeOption != null) {
            this.potion.params.put("cost", "" + (this.storeOption.equalsIgnoreCase("smuggler") ? 20 + MathUtils.random(30) : 30));
        }
        this.potion.setX(this.iconsBackground.getX() + this.iconsBackground.getWidth() * (float)(5 + numService * 20) / 100.0f);
        this.potion.setY(this.iconsBackground.getY() + this.iconsBackground.getHeight() * 15.0f / 100.0f);
        this.potionOutline = new BaseActor();
        this.potionOutline.setTexture(servicesAtlas.findRegion("outlineOwned"), iconSize + 2.0f, iconSize + 2.0f);
        if (this.game.gameMode.equalsIgnoreCase("story") && Story.isServiceFree(this.game, "potion")) {
            this.potionOutline.setTexture(servicesAtlas.findRegion("outlineFree"), iconSize + 2.0f, iconSize + 2.0f);
        }
        this.potionOutline.setVisible(false);
        if (this.fighter.services.contains("potion")) {
            this.potionOutline.setVisible(true);
        }
        this.potionOutline.setX(this.potion.getX() - 1.0f);
        this.potionOutline.setY(this.potion.getY() - 1.0f);
        if (this.game.gameMode.equalsIgnoreCase("story") && this.game.saveGame.get("phase").equalsIgnoreCase("pits")) {
            this.potion.setVisible(false);
            this.potionOutline.setVisible(false);
        }
        this.stage.addActor(this.potionOutline);
        this.stage.addActor(this.potion);
        if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            numStock = this.stocksOrig.get("potion");
            this.potionStock = new Label("x" + numStock, this.game.uiSkin, "default");
            this.potionStock.setAlignment(10);
            this.potionStock.setColor(this.game.uiSkin.get(numStock == 0 ? "red" : "green", Color.class));
            this.potionStock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            this.potionStock.setWidth(iconSize / 2.0f);
            this.potionStock.setX(this.potion.getX() + this.potion.getWidth() + 3.0f);
            this.potionStock.setY(this.potion.getY() + this.potion.getHeight() - this.potionStock.getPrefHeight());
            this.stage.addActor(this.potionStock);
            if (this.storeAfter != null && !this.storeAfter.isEmpty()) {
                this.potionstoremultiplier = new Label("x" + this.storeAfter.get("potion"), this.game.uiSkin, "default");
                this.potionstoremultiplier.setAlignment(10);
                this.potionstoremultiplier.setColor(this.game.uiSkin.get("lightiron", Color.class));
                this.potionstoremultiplier.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                this.potionstoremultiplier.setX(this.potionOutline.getX() + this.potionOutline.getWidth() + 3.0f);
                this.potionstoremultiplier.setY(this.potionOutline.getY() + this.potionOutline.getHeight() / 2.0f - this.potionstoremultiplier.getPrefHeight() / 2.0f);
                this.potionstoremultiplier.setVisible(true);
                this.stage.addActor(this.potionstoremultiplier);
            }
        }
        this.selectedService = new BaseActor();
        this.selectedService.setTexture(servicesAtlas.findRegion("serinfo"), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        this.selectedService.setVisible(false);
        this.selectedService.setX(this.serviceBackground.getX() + UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        this.selectedService.setY(this.serviceBackground.getY() + this.serviceBackground.getHeight() - this.selectedService.getHeight() - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.stage.addActor(this.selectedService);
        this.selectedServiceName = new Label("", this.game.uiSkin, "default");
        this.selectedServiceName.setAlignment(1);
        this.selectedServiceName.setWrap(true);
        this.selectedServiceName.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.selectedServiceName.setVisible(false);
        this.selectedServiceName.setWidth(this.selectedService.getWidth() + UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.selectedServiceName.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.selectedServiceName.setX(this.selectedService.getX() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.selectedServiceName.setY(this.selectedService.getY() - UIHelpers.calcHeightProportion(this.game, 1.5f, 1.5f).floatValue() - this.selectedServiceName.getPrefHeight());
        this.stage.addActor(this.selectedServiceName);
        this.serviceInfo = new Label("", this.game.uiSkin, "default");
        this.serviceInfo.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.serviceInfo.setAlignment(10);
        this.serviceInfo.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.serviceInfo.setWrap(true);
        this.serviceInfo.setWidth(this.serviceBackground.getWidth() - this.selectedService.getWidth() - UIHelpers.calcHeightProportion(this.game, 13.0f, 13.0f).floatValue());
        this.serviceInfo.setX(MathUtils.clamp(this.selectedServiceName.getX() + this.selectedServiceName.getPrefWidth(), this.selectedService.getX() + this.selectedService.getWidth() + UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue(), this.serviceBackground.getX() + this.serviceBackground.getWidth()));
        this.serviceInfo.setVisible(false);
        this.stage.addActor(this.serviceInfo);
        this.buyService = this.game.gameMode.equalsIgnoreCase("tournament") ? new Button(this.game.uiSkin, "add") : new Button(this.game.uiSkin, "servicesmenu");
        this.buyService.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                String type = (String)ServicesMenuScreen.this.selectedService.params.get("id");
                int cost = Integer.parseInt((String)ServicesMenuScreen.this.selectedService.params.get("cost"));
                if (ServicesMenuScreen.this.storeAfter != null && !ServicesMenuScreen.this.storeAfter.isEmpty()) {
                    ServicesMenuScreen.this.stocksOrig.put(type, ServicesMenuScreen.this.stocksOrig.get(type) + 1);
                    ServicesMenuScreen.this.storeAfter.put(type, ServicesMenuScreen.this.storeAfter.get(type) - 1);
                    ServicesMenuScreen.this.profits = ServicesMenuScreen.this.storeAfter.get(type) >= ServicesMenuScreen.this.storeOrig.get(type) ? ServicesMenuScreen.this.profits - cost * (2 + (ServicesMenuScreen.this.storeOption != null && ServicesMenuScreen.this.storeOption.equalsIgnoreCase("sell") ? 1 : 0)) / 3 : ServicesMenuScreen.this.profits - cost * (ServicesMenuScreen.this.storeOption.equalsIgnoreCase("surplus") ? 2 : 3) / 3 * (ServicesMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(ServicesMenuScreen.this.game, "legkil") : 100) / 100;
                    ServicesMenuScreen.this.reputationLabel.setText("" + ServicesMenuScreen.this.profits);
                    ServicesMenuScreen.this.resetStockCounters();
                    ServicesMenuScreen.this.buyService.setVisible(false);
                    if (ServicesMenuScreen.this.storeAfter.get(type) > 0 && ServicesMenuScreen.this.profits >= cost * (ServicesMenuScreen.this.storeOption.equalsIgnoreCase("surplus") ? 2 : 3) / 3) {
                        ServicesMenuScreen.this.buyService.setVisible(true);
                        if (ServicesMenuScreen.this.buyService.getX() != ServicesMenuScreen.this.cancelService.getX()) {
                            ServicesMenuScreen.this.buyService.setX(ServicesMenuScreen.this.cancelService.getX());
                        }
                    }
                    ServicesMenuScreen.this.cancelService.setVisible(false);
                    if (ServicesMenuScreen.this.stocksOrig.get(type) > 0) {
                        ServicesMenuScreen.this.cancelService.setVisible(true);
                        if (ServicesMenuScreen.this.buyService.getX() == ServicesMenuScreen.this.cancelService.getX()) {
                            ServicesMenuScreen.this.buyService.setX(ServicesMenuScreen.this.buyService.getX() - ServicesMenuScreen.this.buyService.getWidth() - 5.0f);
                        }
                    }
                    ServicesMenuScreen.this.game.manager.get("sound/buyOption.ogg", Sound.class).play(ServicesMenuScreen.this.game.soundVolume);
                } else {
                    int currMultiplier = 1;
                    boolean isReplacement = false;
                    if (type.startsWith("upgrade")) {
                        if (ServicesMenuScreen.this.fighter.services.contains(type)) {
                            int serviceMultiplierPosition = ServicesMenuScreen.this.fighter.services.indexOf(type) + type.length() + 1;
                            currMultiplier = Integer.parseInt(ServicesMenuScreen.this.fighter.services.substring(serviceMultiplierPosition, serviceMultiplierPosition + 1)) + 1;
                            ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services.substring(0, serviceMultiplierPosition) + currMultiplier + ServicesMenuScreen.this.fighter.services.substring(serviceMultiplierPosition + 1);
                        } else {
                            if (!ServicesMenuScreen.this.fighter.services.equalsIgnoreCase("")) {
                                ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services + ":";
                            }
                            ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services + type + "-1";
                        }
                        if (type.equalsIgnoreCase("upgradearmor")) {
                            ServicesMenuScreen.this.upgradearmormultiplier.setText("x" + currMultiplier);
                            ServicesMenuScreen.this.upgradearmormultiplier.setVisible(true);
                        } else {
                            ServicesMenuScreen.this.upgradeweaponmultiplier.setText("x" + currMultiplier);
                            ServicesMenuScreen.this.upgradeweaponmultiplier.setVisible(true);
                        }
                        ServicesMenuScreen.this.buyService.setVisible(ServicesMenuScreen.this.serviceLimit(type) > currMultiplier && (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("story") && ServicesMenuScreen.this.profits >= cost * 2 - (Story.isServiceDiscounted(ServicesMenuScreen.this.game, type) ? cost * 2 : 0) || ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && ServicesMenuScreen.this.stocksOrig.get(type) > 1 || ServicesMenuScreen.this.game.saveGame.isEmpty() && ServicesMenuScreen.this.maxReputation - ServicesMenuScreen.this.fighter.reputation >= cost * 2 || ServicesMenuScreen.this.maxReputation == 0));
                        if (ServicesMenuScreen.this.buyService.getX() == ServicesMenuScreen.this.cancelService.getX()) {
                            ServicesMenuScreen.this.buyService.setX(ServicesMenuScreen.this.buyService.getX() - ServicesMenuScreen.this.buyService.getWidth() - 5.0f);
                        }
                        if (ServicesMenuScreen.this.game.saveGame.isEmpty() || currMultiplier > 1 || ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") || ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("story") && !Story.isServiceFree(ServicesMenuScreen.this.game, type)) {
                            ServicesMenuScreen.this.cancelService.setVisible(true);
                        }
                    } else {
                        if (!ServicesMenuScreen.this.fighter.services.equalsIgnoreCase("")) {
                            ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services + ":";
                        }
                        ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services + type;
                        ServicesMenuScreen.this.buyService.setVisible(false);
                        if (ServicesMenuScreen.this.game.saveGame.isEmpty() || ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") || ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("story") && !Story.isServiceFree(ServicesMenuScreen.this.game, type)) {
                            ServicesMenuScreen.this.cancelService.setVisible(true);
                        }
                    }
                    if (type.equalsIgnoreCase("care")) {
                        ServicesMenuScreen.this.careOutline.setVisible(true);
                    } else if (type.equalsIgnoreCase("info")) {
                        ServicesMenuScreen.this.infoOutline.setVisible(true);
                    } else if (type.equalsIgnoreCase("potion")) {
                        ServicesMenuScreen.this.potionOutline.setVisible(true);
                    } else if (type.equalsIgnoreCase("shard")) {
                        ServicesMenuScreen.this.shardOutline.setVisible(true);
                        if (ServicesMenuScreen.this.powderOutline.isVisible()) {
                            ServicesMenuScreen.this.powderOutline.setVisible(false);
                            ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services.replace("powder:", "").replace(":powder", "").replace("powder", "");
                            isReplacement = true;
                            if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament")) {
                                ServicesMenuScreen.this.stocksOrig.put(type, ServicesMenuScreen.this.stocksOrig.get("powder") + 1);
                            }
                        }
                        if (ServicesMenuScreen.this.netOutline.isVisible()) {
                            ServicesMenuScreen.this.netOutline.setVisible(false);
                            ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services.replace("net:", "").replace(":net", "").replace("net", "");
                            isReplacement = true;
                            if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament")) {
                                ServicesMenuScreen.this.stocksOrig.put(type, ServicesMenuScreen.this.stocksOrig.get("net") + 1);
                            }
                        }
                    } else if (type.equalsIgnoreCase("powder")) {
                        ServicesMenuScreen.this.powderOutline.setVisible(true);
                        if (ServicesMenuScreen.this.shardOutline.isVisible()) {
                            ServicesMenuScreen.this.shardOutline.setVisible(false);
                            ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services.replace("shard:", "").replace(":shard", "").replace("shard", "");
                            isReplacement = true;
                            if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament")) {
                                ServicesMenuScreen.this.stocksOrig.put(type, ServicesMenuScreen.this.stocksOrig.get("shard") + 1);
                            }
                        }
                        if (ServicesMenuScreen.this.netOutline.isVisible()) {
                            ServicesMenuScreen.this.netOutline.setVisible(false);
                            ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services.replace("net:", "").replace(":net", "").replace("net", "");
                            isReplacement = true;
                            if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament")) {
                                ServicesMenuScreen.this.stocksOrig.put(type, ServicesMenuScreen.this.stocksOrig.get("net") + 1);
                            }
                        }
                    } else if (type.equalsIgnoreCase("net")) {
                        ServicesMenuScreen.this.netOutline.setVisible(true);
                        if (ServicesMenuScreen.this.shardOutline.isVisible()) {
                            ServicesMenuScreen.this.shardOutline.setVisible(false);
                            ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services.replace("shard:", "").replace(":shard", "").replace("shard", "");
                            isReplacement = true;
                            if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament")) {
                                ServicesMenuScreen.this.stocksOrig.put(type, ServicesMenuScreen.this.stocksOrig.get("shard") + 1);
                            }
                        }
                        if (ServicesMenuScreen.this.powderOutline.isVisible()) {
                            ServicesMenuScreen.this.powderOutline.setVisible(false);
                            ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services.replace("powder:", "").replace(":powder", "").replace("powder", "");
                            isReplacement = true;
                            if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament")) {
                                ServicesMenuScreen.this.stocksOrig.put(type, ServicesMenuScreen.this.stocksOrig.get("powder") + 1);
                            }
                        }
                    } else if (type.equalsIgnoreCase("choice")) {
                        ServicesMenuScreen.this.choiceOutline.setVisible(true);
                    } else if (type.equalsIgnoreCase("upgradearmor")) {
                        ServicesMenuScreen.this.upgradearmorOutline.setVisible(true);
                    } else if (type.equalsIgnoreCase("upgradeweapon")) {
                        ServicesMenuScreen.this.upgradeweaponOutline.setVisible(true);
                    }
                    if (!isReplacement) {
                        if (ServicesMenuScreen.this.game.saveGame.isEmpty()) {
                            ServicesMenuScreen.this.fighter.reputation += cost;
                            ServicesMenuScreen.this.reputationLabel.setText(ServicesMenuScreen.this.fighter.reputation + " / " + (ServicesMenuScreen.this.maxReputation == 0 ? "-" : Integer.valueOf(ServicesMenuScreen.this.maxReputation)));
                        } else if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("story") && (currMultiplier > 1 || ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("story") && !Story.isServiceFree(ServicesMenuScreen.this.game, type))) {
                            ServicesMenuScreen.this.profits = ServicesMenuScreen.this.profits - cost + (Story.isServiceDiscounted(ServicesMenuScreen.this.game, type) ? cost / 2 : 0);
                            ServicesMenuScreen.this.reputationLabel.setText("" + ServicesMenuScreen.this.profits);
                        }
                    }
                    if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament")) {
                        ServicesMenuScreen.this.stocksOrig.put(type, ServicesMenuScreen.this.stocksOrig.get(type) - 1);
                        ServicesMenuScreen.this.resetStockCounters();
                    }
                    ServicesMenuScreen.this.game.manager.get("sound/buyOption.ogg", Sound.class).play(ServicesMenuScreen.this.game.soundVolume);
                }
            }
        });
        this.buyService.setVisible(false);
        this.buyService.setWidth(UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        this.buyService.setHeight(this.buyService.getWidth());
        this.buyService.setX(this.serviceBackground.getX() + this.serviceBackground.getWidth() - this.buyService.getWidth() - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.buyService.setY(this.serviceBackground.getY() + UIHelpers.calcHeightProportion(this.game, 3.0f, 3.0f).floatValue());
        this.stage.addActor(this.buyService);
        this.cancelService = this.game.gameMode.equalsIgnoreCase("tournament") ? new Button(this.game.uiSkin, "remove") : new Button(this.game.uiSkin, "cancel");
        this.cancelService.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                String type = (String)ServicesMenuScreen.this.selectedService.params.get("id");
                int cost = Integer.parseInt((String)ServicesMenuScreen.this.selectedService.params.get("cost"));
                if (ServicesMenuScreen.this.storeAfter != null && !ServicesMenuScreen.this.storeAfter.isEmpty()) {
                    ServicesMenuScreen.this.stocksOrig.put(type, ServicesMenuScreen.this.stocksOrig.get(type) - 1);
                    ServicesMenuScreen.this.storeAfter.put(type, ServicesMenuScreen.this.storeAfter.get(type) + 1);
                    ServicesMenuScreen.this.profits = ServicesMenuScreen.this.storeAfter.get(type) <= ServicesMenuScreen.this.storeOrig.get(type) ? ServicesMenuScreen.this.profits + cost * (ServicesMenuScreen.this.storeOption.equalsIgnoreCase("surplus") ? 2 : 3) / 3 * (ServicesMenuScreen.this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(ServicesMenuScreen.this.game, "legkil") : 100) / 100 : ServicesMenuScreen.this.profits + cost * (2 + (ServicesMenuScreen.this.storeOption != null && ServicesMenuScreen.this.storeOption.equalsIgnoreCase("sell") ? 1 : 0)) / 3;
                    ServicesMenuScreen.this.reputationLabel.setText("" + ServicesMenuScreen.this.profits);
                    ServicesMenuScreen.this.resetStockCounters();
                    ServicesMenuScreen.this.buyService.setVisible(false);
                    if (ServicesMenuScreen.this.storeAfter.get(type) > 0 && ServicesMenuScreen.this.profits >= cost * (ServicesMenuScreen.this.storeOption.equalsIgnoreCase("surplus") ? 2 : 3) / 3) {
                        ServicesMenuScreen.this.buyService.setVisible(true);
                        if (ServicesMenuScreen.this.buyService.getX() != ServicesMenuScreen.this.cancelService.getX()) {
                            ServicesMenuScreen.this.buyService.setX(ServicesMenuScreen.this.cancelService.getX());
                        }
                    }
                    ServicesMenuScreen.this.cancelService.setVisible(false);
                    if (ServicesMenuScreen.this.stocksOrig.get(type) > 0) {
                        ServicesMenuScreen.this.cancelService.setVisible(true);
                        if (ServicesMenuScreen.this.buyService.getX() == ServicesMenuScreen.this.cancelService.getX()) {
                            ServicesMenuScreen.this.buyService.setX(ServicesMenuScreen.this.buyService.getX() - ServicesMenuScreen.this.buyService.getWidth() - 5.0f);
                        }
                    }
                    ServicesMenuScreen.this.game.manager.get("sound/buyOption.ogg", Sound.class).play(ServicesMenuScreen.this.game.soundVolume);
                } else {
                    int currMultiplier = 0;
                    if (type.startsWith("upgrade")) {
                        if (ServicesMenuScreen.this.fighter.services.contains(type + "-1")) {
                            ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services.contains(":") ? ServicesMenuScreen.this.fighter.services.replace(type + "-1:", "").replace(":" + type + "-1", "").replace(type + "-1", "") : "";
                        } else {
                            int serviceMultiplierPosition = ServicesMenuScreen.this.fighter.services.indexOf(type) + type.length() + 1;
                            currMultiplier = Integer.parseInt(ServicesMenuScreen.this.fighter.services.substring(serviceMultiplierPosition, serviceMultiplierPosition + 1)) - 1;
                            ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services.substring(0, serviceMultiplierPosition) + currMultiplier + ServicesMenuScreen.this.fighter.services.substring(serviceMultiplierPosition - 1);
                        }
                        if (type.equalsIgnoreCase("upgradearmor")) {
                            ServicesMenuScreen.this.upgradearmormultiplier.setText("x" + currMultiplier);
                            if (currMultiplier == 0) {
                                ServicesMenuScreen.this.upgradearmorOutline.setVisible(false);
                                ServicesMenuScreen.this.upgradearmormultiplier.setVisible(false);
                                ServicesMenuScreen.this.cancelService.setVisible(false);
                                if (ServicesMenuScreen.this.buyService.getX() != ServicesMenuScreen.this.cancelService.getX()) {
                                    ServicesMenuScreen.this.buyService.setX(ServicesMenuScreen.this.cancelService.getX());
                                }
                            } else if (ServicesMenuScreen.this.buyService.getX() == ServicesMenuScreen.this.cancelService.getX()) {
                                ServicesMenuScreen.this.buyService.setX(ServicesMenuScreen.this.buyService.getX() - ServicesMenuScreen.this.buyService.getWidth() - 5.0f);
                            }
                        } else {
                            ServicesMenuScreen.this.upgradeweaponmultiplier.setText("x" + currMultiplier);
                            if (currMultiplier == 0) {
                                ServicesMenuScreen.this.upgradeweaponOutline.setVisible(false);
                                ServicesMenuScreen.this.upgradeweaponmultiplier.setVisible(false);
                                ServicesMenuScreen.this.cancelService.setVisible(false);
                                if (ServicesMenuScreen.this.buyService.getX() != ServicesMenuScreen.this.cancelService.getX()) {
                                    ServicesMenuScreen.this.buyService.setX(ServicesMenuScreen.this.cancelService.getX());
                                }
                            } else {
                                if (ServicesMenuScreen.this.buyService.getX() == ServicesMenuScreen.this.cancelService.getX()) {
                                    ServicesMenuScreen.this.buyService.setX(ServicesMenuScreen.this.buyService.getX() - ServicesMenuScreen.this.buyService.getWidth() - 5.0f);
                                }
                                if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && currMultiplier == 1 && Tournament.getRewardStock(ServicesMenuScreen.this.game, "tinkerer") > 0) {
                                    ServicesMenuScreen.this.cancelService.setVisible(false);
                                }
                            }
                        }
                        ServicesMenuScreen.this.buyService.setVisible(true);
                    } else {
                        ServicesMenuScreen.this.fighter.services = ServicesMenuScreen.this.fighter.services.contains(":") ? ServicesMenuScreen.this.fighter.services.replace(type + ":", "").replace(":" + type, "").replace(type, "") : "";
                        ServicesMenuScreen.this.cancelService.setVisible(false);
                        ServicesMenuScreen.this.buyService.setVisible(true);
                    }
                    if (type.equalsIgnoreCase("care")) {
                        ServicesMenuScreen.this.careOutline.setVisible(false);
                    } else if (type.equalsIgnoreCase("info")) {
                        ServicesMenuScreen.this.infoOutline.setVisible(false);
                    } else if (type.equalsIgnoreCase("potion")) {
                        ServicesMenuScreen.this.potionOutline.setVisible(false);
                    } else if (type.equalsIgnoreCase("shard")) {
                        ServicesMenuScreen.this.powderOutline.setVisible(false);
                        ServicesMenuScreen.this.shardOutline.setVisible(false);
                        ServicesMenuScreen.this.netOutline.setVisible(false);
                    } else if (type.equalsIgnoreCase("powder")) {
                        ServicesMenuScreen.this.powderOutline.setVisible(false);
                        ServicesMenuScreen.this.shardOutline.setVisible(false);
                        ServicesMenuScreen.this.netOutline.setVisible(false);
                    } else if (type.equalsIgnoreCase("net")) {
                        ServicesMenuScreen.this.powderOutline.setVisible(false);
                        ServicesMenuScreen.this.shardOutline.setVisible(false);
                        ServicesMenuScreen.this.netOutline.setVisible(false);
                    } else if (type.equalsIgnoreCase("choice")) {
                        ServicesMenuScreen.this.choiceOutline.setVisible(false);
                    } else if (type.equalsIgnoreCase("upgradearmor")) {
                        if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament")) {
                            if (ServicesMenuScreen.this.fighter.body != null) {
                                Tournament.setRewardStock(ServicesMenuScreen.this.game, "cuirass", Tournament.getRewardStock(ServicesMenuScreen.this.game, "cuirass") + 1);
                            }
                            if (ServicesMenuScreen.this.fighter.head != null) {
                                Tournament.setRewardStock(ServicesMenuScreen.this.game, "helmet", Tournament.getRewardStock(ServicesMenuScreen.this.game, "helmet") + 1);
                            }
                            if (ServicesMenuScreen.this.fighter.arms != null) {
                                Tournament.setRewardStock(ServicesMenuScreen.this.game, "bracers", Tournament.getRewardStock(ServicesMenuScreen.this.game, "bracers") + 1);
                            }
                        }
                        ServicesMenuScreen.this.fighter.body = null;
                        ServicesMenuScreen.this.fighter.head = null;
                        ServicesMenuScreen.this.fighter.arms = null;
                    } else if (type.equalsIgnoreCase("upgradeweapon")) {
                        if (currMultiplier == 1) {
                            ServicesMenuScreen.this.fighter.weapon.tier = "caparace";
                            if (ServicesMenuScreen.this.fighter.offHand != null) {
                                ServicesMenuScreen.this.fighter.offHand.tier = "caparace";
                            }
                        } else {
                            ServicesMenuScreen.this.fighter.weapon.tier = "wood";
                            if (ServicesMenuScreen.this.fighter.offHand != null) {
                                ServicesMenuScreen.this.fighter.offHand.tier = "wood";
                            }
                        }
                    }
                    if (ServicesMenuScreen.this.game.saveGame.isEmpty()) {
                        ServicesMenuScreen.this.fighter.reputation -= cost;
                        ServicesMenuScreen.this.reputationLabel.setText(ServicesMenuScreen.this.fighter.reputation + " / " + (ServicesMenuScreen.this.maxReputation == 0 ? "-" : Integer.valueOf(ServicesMenuScreen.this.maxReputation)));
                    } else if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("story")) {
                        if (currMultiplier > 1 || ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("story") && !Story.isServiceFree(ServicesMenuScreen.this.game, type)) {
                            ServicesMenuScreen.this.profits = ServicesMenuScreen.this.profits + cost - (Story.isServiceDiscounted(ServicesMenuScreen.this.game, type) ? cost / 2 : 0);
                            ServicesMenuScreen.this.reputationLabel.setText("" + ServicesMenuScreen.this.profits);
                        }
                    } else if (ServicesMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament")) {
                        ServicesMenuScreen.this.stocksOrig.put(type, ServicesMenuScreen.this.stocksOrig.get(type) + 1);
                        ServicesMenuScreen.this.resetStockCounters();
                    }
                    ServicesMenuScreen.this.game.manager.get("sound/toggle.ogg", Sound.class).play(ServicesMenuScreen.this.game.soundVolume);
                }
            }
        });
        this.cancelService.setVisible(false);
        this.cancelService.setWidth(UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        this.cancelService.setHeight(this.buyService.getWidth());
        this.cancelService.setX(this.serviceBackground.getX() + this.serviceBackground.getWidth() - this.cancelService.getWidth() - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.cancelService.setY(this.serviceBackground.getY() + UIHelpers.calcHeightProportion(this.game, 3.0f, 3.0f).floatValue());
        this.stage.addActor(this.cancelService);
        this.applyButton = new Button(this.game.uiSkin, "ok");
        this.applyButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (ServicesMenuScreen.this.previousScreen instanceof DuelSetupScreen) {
                    if (ServicesMenuScreen.this.fighterType.equalsIgnoreCase("host")) {
                        ((DuelSetupScreen)((ServicesMenuScreen)ServicesMenuScreen.this).previousScreen).hostFighter = ServicesMenuScreen.this.fighter;
                        ((DuelSetupScreen)((ServicesMenuScreen)ServicesMenuScreen.this).previousScreen).reputationP1.setText(ServicesMenuScreen.this.fighter.reputation + " / " + (ServicesMenuScreen.this.maxReputation == 0 ? "-" : Integer.valueOf(ServicesMenuScreen.this.maxReputation)));
                    } else {
                        ((DuelSetupScreen)((ServicesMenuScreen)ServicesMenuScreen.this).previousScreen).clientFighter = ServicesMenuScreen.this.fighter;
                        ((DuelSetupScreen)((ServicesMenuScreen)ServicesMenuScreen.this).previousScreen).reputationP2.setText(ServicesMenuScreen.this.fighter.reputation + " / " + (ServicesMenuScreen.this.maxReputation == 0 ? "-" : Integer.valueOf(ServicesMenuScreen.this.maxReputation)));
                    }
                    ((DuelSetupScreen)ServicesMenuScreen.this.previousScreen).sendMessage("change", "");
                } else if (ServicesMenuScreen.this.previousScreen instanceof PrepSetupScreen) {
                    ((PrepSetupScreen)((ServicesMenuScreen)ServicesMenuScreen.this).previousScreen).hostFighter = ServicesMenuScreen.this.fighter;
                    ((PrepSetupScreen)((ServicesMenuScreen)ServicesMenuScreen.this).previousScreen).profits = ServicesMenuScreen.this.profits;
                    ((PrepSetupScreen)((ServicesMenuScreen)ServicesMenuScreen.this).previousScreen).profitsLabel.setText("" + ServicesMenuScreen.this.profits);
                    if (ServicesMenuScreen.this.fighter.services.contains("info")) {
                        ((PrepSetupScreen)ServicesMenuScreen.this.previousScreen).moveNextPane();
                        ((PrepSetupScreen)((ServicesMenuScreen)ServicesMenuScreen.this).previousScreen).infoPane.setVisible(true);
                    }
                    ((PrepSetupScreen)ServicesMenuScreen.this.previousScreen).calculateFinalLife(false);
                } else if (ServicesMenuScreen.this.previousScreen instanceof TournamentSetupScreen) {
                    ((TournamentSetupScreen)((ServicesMenuScreen)ServicesMenuScreen.this).previousScreen).hostFighter = ServicesMenuScreen.this.fighter;
                    if (ServicesMenuScreen.this.fighter.services.contains("info")) {
                        ((TournamentSetupScreen)ServicesMenuScreen.this.previousScreen).moveNextPane();
                        ((TournamentSetupScreen)((ServicesMenuScreen)ServicesMenuScreen.this).previousScreen).infoPane.setVisible(true);
                    }
                    ((TournamentSetupScreen)ServicesMenuScreen.this.previousScreen).calculateFinalLife(false);
                    Tournament.setServicesAvailable(ServicesMenuScreen.this.game, ServicesMenuScreen.this.stocksOrig);
                } else if (ServicesMenuScreen.this.previousScreen instanceof TournamentEventScreen) {
                    Tournament.setServicesAvailable(ServicesMenuScreen.this.game, ServicesMenuScreen.this.stocksOrig);
                    Tournament.setServicesStore(ServicesMenuScreen.this.game, ServicesMenuScreen.this.storeAfter);
                    ServicesMenuScreen.this.game.saveGame.put("profits", "" + ServicesMenuScreen.this.profits);
                }
                ServicesMenuScreen.this.game.setScreen(ServicesMenuScreen.this.previousScreen);
            }
        });
        this.applyButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.applyButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.applyButton.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - this.applyButton.getPrefWidth());
        this.applyButton.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 1.0f).floatValue());
        this.stage.addActor(this.applyButton);
        this.exitButton = new Button(this.game.uiSkin, "cancel");
        this.exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                ServicesMenuScreen.this.game.setScreen(ServicesMenuScreen.this.previousScreen);
            }
        });
        this.exitButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.exitButton.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 1.0f).floatValue());
        this.stage.addActor(this.exitButton);
    }

    @Override
    public void render(float delta) {
        this.game.manager.update();
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public void receivedPacket(String content) {
        if (this.previousScreen instanceof DuelSetupScreen) {
            this.previousScreen.receivedPacket(content);
        }
    }

    private void showService(BaseActor currActor, String type) {
        this.selectedService.setVisible(true);
        this.selectedService.setTexture(currActor.region, (float)Float.valueOf(currActor.getWidth()).intValue(), (float)Float.valueOf(currActor.getWidth()).intValue());
        this.selectedService.params.put("id", type);
        this.selectedService.params.put("cost", currActor.params.get("cost"));
        int cost = Integer.parseInt((String)this.selectedService.params.get("cost"));
        this.selectedServiceName.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.services." + type + ".name"));
        UIHelpers.fixLabelFontSize(this.selectedServiceName, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), this.serviceBackground.getWidth() - this.selectedService.getWidth() - UIHelpers.calcHeightProportion(this.game, 13.0f, 13.0f).floatValue(), 0.0f);
        this.selectedServiceName.setVisible(true);
        this.serviceInfo.setVisible(true);
        StringBuilder serviceDescription = new StringBuilder();
        serviceDescription.append(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.services." + type + ".description", this.game.violenceFilter));
        serviceDescription.append("\n[#D4D4D4]");
        serviceDescription.append(PropertiesReader.getMessage(this.game.gameMessages, "common.cost"));
        serviceDescription.append(": ");
        serviceDescription.append("[#A8A8A8]");
        if (this.storeOption != null) {
            serviceDescription.append(cost * (this.storeOption.equalsIgnoreCase("surplus") ? 2 : 3) / 3 * (this.game.saveGame.get("rewards").contains("legkil") ? 100 - Tournament.getRewardStock(this.game, "legkil") : 100) / 100);
            serviceDescription.append("(");
            serviceDescription.append(cost * (2 + (this.storeOption.equalsIgnoreCase("sell") ? 1 : 0)) / 3);
            serviceDescription.append(")");
        } else if (this.game.saveGame.isEmpty()) {
            serviceDescription.append("[#FF0000]");
            serviceDescription.append((String)this.selectedService.params.get("cost"));
        } else {
            serviceDescription.append(cost - (Story.isServiceDiscounted(this.game, type) ? cost / 2 : 0));
        }
        this.serviceInfo.setText(serviceDescription);
        this.serviceInfo.layout();
        this.serviceInfo.setX(MathUtils.clamp(this.selectedServiceName.getX() + this.selectedServiceName.getPrefWidth(), this.selectedService.getX() + this.selectedService.getWidth() + UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue(), this.serviceBackground.getX() + this.serviceBackground.getWidth()));
        this.serviceInfo.setY(this.serviceBackground.getY() + this.serviceBackground.getHeight() - UIHelpers.calcHeightProportion(this.game, 3.0f, 3.0f).floatValue());
        this.buyService.setVisible(false);
        this.buyService.setX(this.cancelService.getX());
        this.cancelService.setVisible(false);
        if (this.game.saveGame.isEmpty()) {
            if (this.fighter.services.contains(type)) {
                this.cancelService.setVisible(true);
                if (type.startsWith("upgrade")) {
                    int serviceMultiplierPosition = this.fighter.services.indexOf(type) + type.length() + 1;
                    int currMultiplier = Integer.parseInt(this.fighter.services.substring(serviceMultiplierPosition, serviceMultiplierPosition + 1));
                    if (this.serviceLimit(type) > currMultiplier) {
                        this.buyService.setX(this.buyService.getX() - this.buyService.getWidth() - 5.0f);
                        this.buyService.setVisible(true);
                    }
                }
            } else if (this.maxReputation == 0 || this.fighter.reputation <= this.maxReputation - cost) {
                this.buyService.setVisible(true);
                this.cancelService.setVisible(false);
            }
        } else if (this.game.gameMode.equalsIgnoreCase("story")) {
            if (this.fighter.services.contains(type)) {
                if (!(this.servicesOrig.contains(type) && !type.startsWith("upgrade") || (type.equalsIgnoreCase("shard") || type.equalsIgnoreCase("powder") || type.equalsIgnoreCase("net")) && this.game.gameMode.equalsIgnoreCase("story") && Story.isServiceFree(this.game, "shard"))) {
                    this.cancelService.setVisible(true);
                    if (type.startsWith("upgrade")) {
                        int serviceMultiplierPosition = this.fighter.services.indexOf(type) + type.length() + 1;
                        int currMultiplier = Integer.parseInt(this.fighter.services.substring(serviceMultiplierPosition, serviceMultiplierPosition + 1));
                        if (this.serviceLimit(type) > currMultiplier && this.profits >= cost - (Story.isServiceDiscounted(this.game, type) ? cost / 2 : 0)) {
                            this.buyService.setX(this.buyService.getX() - this.buyService.getWidth() - 5.0f);
                            this.buyService.setVisible(true);
                        }
                    }
                }
            } else if (this.profits >= cost - (Story.isServiceDiscounted(this.game, type) ? cost / 2 : 0) || (type.equalsIgnoreCase("shard") || type.equalsIgnoreCase("powder") || type.equalsIgnoreCase("net")) && this.game.gameMode.equalsIgnoreCase("story") && Story.isServiceFree(this.game, "shard")) {
                this.buyService.setVisible(true);
                this.cancelService.setVisible(false);
            }
        } else if (this.game.gameMode.equalsIgnoreCase("tournament") && this.previousScreen == this.game.tournamentSetupScreen) {
            if (this.fighter.services.contains(type)) {
                if (!(this.servicesOrig.contains(type) && !type.startsWith("upgrade") || type.equalsIgnoreCase("shard") || type.equalsIgnoreCase("powder") || type.equalsIgnoreCase("net"))) {
                    this.cancelService.setVisible(true);
                    if (type.startsWith("upgrade")) {
                        int serviceMultiplierPosition = this.fighter.services.indexOf(type) + type.length() + 1;
                        int currMultiplier = Integer.parseInt(this.fighter.services.substring(serviceMultiplierPosition, serviceMultiplierPosition + 1));
                        if (this.serviceLimit(type) > currMultiplier && this.stocksOrig.get(type) > 0) {
                            this.buyService.setX(this.buyService.getX() - this.buyService.getWidth() - 5.0f);
                            this.buyService.setVisible(true);
                        }
                        if (type.startsWith("upgradeweapon") && currMultiplier == 1 && Tournament.getRewardStock(this.game, "tinkerer") > 0) {
                            this.cancelService.setVisible(false);
                        }
                    }
                }
            } else if (this.stocksOrig.get(type) > 0) {
                this.cancelService.setVisible(false);
                this.buyService.setVisible(true);
            }
        } else if (this.game.gameMode.equalsIgnoreCase("tournament") && this.previousScreen == this.game.tournamentEventScreen) {
            if (this.storeAfter.get(type) > 0 && this.profits >= cost) {
                this.buyService.setVisible(true);
            }
            if (this.stocksOrig.get(type) > 0) {
                this.cancelService.setVisible(true);
                this.buyService.setX(this.buyService.getX() - this.buyService.getWidth() - 5.0f);
            }
        }
    }

    private int serviceLimit(String type) {
        if (type.equalsIgnoreCase("upgradearmor")) {
            if (this.game.gameMode.equalsIgnoreCase("story") && this.game.saveGame.get("phase").equalsIgnoreCase("pits")) {
                return 3;
            }
            return 6;
        }
        if (type.equalsIgnoreCase("upgradeweapon")) {
            if (this.game.gameMode.equalsIgnoreCase("story") && this.game.saveGame.get("phase").equalsIgnoreCase("pits")) {
                return 1;
            }
            return 2;
        }
        return 1;
    }

    private void resetStockCounters() {
        this.shardStock.setText("x" + this.stocksOrig.get("shard"));
        this.shardStock.setColor(this.game.uiSkin.get(this.stocksOrig.get("shard") == 0 ? "red" : "green", Color.class));
        this.shardStock.layout();
        this.powderStock.setText("x" + this.stocksOrig.get("powder"));
        this.powderStock.setColor(this.game.uiSkin.get(this.stocksOrig.get("powder") == 0 ? "red" : "green", Color.class));
        this.powderStock.layout();
        this.netStock.setText("x" + this.stocksOrig.get("net"));
        this.netStock.setColor(this.game.uiSkin.get(this.stocksOrig.get("net") == 0 ? "red" : "green", Color.class));
        this.netStock.layout();
        this.upgradearmorStock.setText("x" + this.stocksOrig.get("upgradearmor"));
        this.upgradearmorStock.setColor(this.game.uiSkin.get(this.stocksOrig.get("upgradearmor") == 0 ? "red" : "green", Color.class));
        this.upgradearmorStock.layout();
        this.upgradeweaponStock.setText("x" + this.stocksOrig.get("upgradeweapon"));
        this.upgradeweaponStock.setColor(this.game.uiSkin.get(this.stocksOrig.get("upgradeweapon") == 0 ? "red" : "green", Color.class));
        this.upgradeweaponStock.layout();
        if (this.careStock != null) {
            this.careStock.setText("x" + this.stocksOrig.get("care"));
            this.careStock.setColor(this.game.uiSkin.get(this.stocksOrig.get("care") == 0 ? "red" : "green", Color.class));
            this.careStock.layout();
        }
        if (this.infoStock != null) {
            this.infoStock.setText("x" + this.stocksOrig.get("info"));
            this.infoStock.setColor(this.game.uiSkin.get(this.stocksOrig.get("info") == 0 ? "red" : "green", Color.class));
            this.infoStock.layout();
        }
        this.potionStock.setText("x" + this.stocksOrig.get("potion"));
        this.potionStock.setColor(this.game.uiSkin.get(this.stocksOrig.get("potion") == 0 ? "red" : "green", Color.class));
        this.potionStock.layout();
        if (this.storeAfter != null && !this.storeAfter.isEmpty()) {
            this.shardstoremultiplier.setText("x" + this.storeAfter.get("shard"));
            this.shardstoremultiplier.layout();
            this.powderstoremultiplier.setText("x" + this.storeAfter.get("powder"));
            this.powderstoremultiplier.layout();
            this.netstoremultiplier.setText("x" + this.storeAfter.get("net"));
            this.netstoremultiplier.layout();
            this.upgradearmorstoremultiplier.setText("x" + this.storeAfter.get("upgradearmor"));
            this.upgradearmorstoremultiplier.layout();
            this.upgradeweaponstoremultiplier.setText("x" + this.storeAfter.get("upgradeweapon"));
            this.upgradeweaponstoremultiplier.layout();
            this.carestoremultiplier.setText("x" + this.storeAfter.get("care"));
            this.carestoremultiplier.layout();
            this.infostoremultiplier.setText("x" + this.storeAfter.get("info"));
            this.infostoremultiplier.layout();
            this.potionstoremultiplier.setText("x" + this.storeAfter.get("potion"));
            this.potionstoremultiplier.layout();
            this.reputationLabel.setText("" + this.profits);
        }
    }
}

