/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.SelectBoxFontScaling;
import com.calimasaga.slavepits.actor.TextFieldFontScaling;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Story;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class SaveGameScreen
extends BaseScreen {
    public float tsp = 30.0f;
    public float sp = 15.0f;
    private TextButton save1Button;
    private TextButton save2Button;
    private TextButton save3Button;
    private Button delete1Button;
    private Button delete2Button;
    private Button delete3Button;
    private TextButton exitButton;
    private NinePatchActor confirmationBackground;
    private NinePatchActor tooltipBackground;
    private Label nameLabel;
    private TextFieldFontScaling name;
    private Label difficultyLabel;
    private SelectBoxFontScaling<String> difficulty;
    private Label legendaryLabel;
    private Button legendary;
    private Label deleteLabel;
    private Label tooltipLabel;
    private Button infoButton;
    private Button newButton;
    private Button deleteButton;
    private Button cancelInfoButton;
    private Button cancelButton;
    int selectedPosition = 0;

    public SaveGameScreen(SlavePitsGame g) {
        super(g);
        this.create();
    }

    @Override
    public void create() {
        String button1Header = this.getSaveHeader(1);
        this.save1Button = new TextButton(button1Header, this.game.uiSkin, "big");
        this.save1Button.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (SaveGameScreen.this.save1Button.getLabel().getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(SaveGameScreen.this.game.gameMessages, "common.new"))) {
                    SaveGameScreen.this.showNewGame(1);
                } else {
                    SaveGameScreen.this.launchSaveGame(1);
                }
            }
        });
        this.save1Button.getLabel().setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.save1Button.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        this.save1Button.setWidth(UIHelpers.calcHeightProportion(this.game, 60.0f, 60.0f).floatValue());
        this.save1Button.setHeight(UIHelpers.calcHeightProportion(this.game, 14.0f, 14.0f).floatValue());
        UIHelpers.fixLabelFontSize(this.save1Button.getLabel(), this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), this.save1Button.getWidth() * 80.0f / 100.0f, this.save1Button.getHeight() * 90.0f / 100.0f);
        this.save1Button.setX(UIHelpers.calcWidthProportion(this.game, 48.0f, 48.0f).floatValue() - this.save1Button.getWidth() / 2.0f);
        this.save1Button.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp, 100.0f - this.tsp).floatValue() - this.save1Button.getHeight() / 2.0f);
        this.stage.addActor(this.save1Button);
        this.delete1Button = new Button(this.game.uiSkin, "cancel");
        this.delete1Button.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                SaveGameScreen.this.showConfirmation(1);
            }
        });
        this.delete1Button.setVisible(!this.save1Button.getLabel().getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "common.new")));
        this.delete1Button.setWidth(UIHelpers.calcHeightProportion(this.game, 6.25f, 6.25f).floatValue());
        this.delete1Button.setHeight(this.delete1Button.getWidth());
        this.delete1Button.setX(this.save1Button.getX() + this.save1Button.getWidth() + UIHelpers.calcWidthProportion(this.game, 0.25f, 0.25f).floatValue());
        this.delete1Button.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp, 100.0f - this.tsp).floatValue() - this.delete1Button.getHeight() / 2.0f);
        this.stage.addActor(this.delete1Button);
        if (this.save1Button.getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "common.new"))) {
            this.save1Button.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 2.0f));
            this.save1Button.getLabel().setColor(this.game.uiSkin.get("lightiron", Color.class));
            this.delete1Button.setVisible(false);
        }
        String button2Header = this.getSaveHeader(2);
        this.save2Button = new TextButton(button2Header, this.game.uiSkin, "big");
        this.save2Button.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (SaveGameScreen.this.save2Button.getLabel().getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(SaveGameScreen.this.game.gameMessages, "common.new"))) {
                    SaveGameScreen.this.showNewGame(2);
                } else {
                    SaveGameScreen.this.launchSaveGame(2);
                }
            }
        });
        this.save2Button.getLabel().setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.save2Button.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        this.save2Button.setWidth(UIHelpers.calcHeightProportion(this.game, 60.0f, 60.0f).floatValue());
        this.save2Button.setHeight(UIHelpers.calcHeightProportion(this.game, 14.0f, 14.0f).floatValue());
        UIHelpers.fixLabelFontSize(this.save2Button.getLabel(), this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), this.save2Button.getWidth() * 80.0f / 100.0f, this.save2Button.getHeight() * 90.0f / 100.0f);
        this.save2Button.setX(UIHelpers.calcWidthProportion(this.game, 48.0f, 48.0f).floatValue() - this.save2Button.getWidth() / 2.0f);
        this.save2Button.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp, 100.0f - this.tsp - this.sp).floatValue() - this.save2Button.getHeight() / 2.0f);
        this.stage.addActor(this.save2Button);
        this.delete2Button = new Button(this.game.uiSkin, "cancel");
        this.delete2Button.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                SaveGameScreen.this.showConfirmation(2);
            }
        });
        this.delete2Button.setVisible(!this.save2Button.getLabel().getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "common.new")));
        this.delete2Button.setWidth(UIHelpers.calcHeightProportion(this.game, 6.25f, 6.25f).floatValue());
        this.delete2Button.setHeight(this.delete2Button.getWidth());
        this.delete2Button.setX(this.save2Button.getX() + this.save2Button.getWidth() + UIHelpers.calcWidthProportion(this.game, 0.25f, 0.25f).floatValue());
        this.delete2Button.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp, 100.0f - this.tsp - this.sp).floatValue() - this.delete2Button.getHeight() / 2.0f);
        this.stage.addActor(this.delete2Button);
        if (this.save2Button.getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "common.new"))) {
            this.save2Button.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 2.0f));
            this.save2Button.getLabel().setColor(this.game.uiSkin.get("lightiron", Color.class));
            this.delete2Button.setVisible(false);
        }
        String button3Header = this.getSaveHeader(3);
        this.save3Button = new TextButton(button3Header, this.game.uiSkin, "big");
        this.save3Button.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (SaveGameScreen.this.save3Button.getLabel().getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(SaveGameScreen.this.game.gameMessages, "common.new"))) {
                    SaveGameScreen.this.showNewGame(3);
                } else {
                    SaveGameScreen.this.launchSaveGame(3);
                }
            }
        });
        this.save3Button.getLabel().setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.save3Button.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        this.save3Button.setWidth(UIHelpers.calcHeightProportion(this.game, 60.0f, 60.0f).floatValue());
        this.save3Button.setHeight(UIHelpers.calcHeightProportion(this.game, 12.5f, 12.5f).floatValue());
        UIHelpers.fixLabelFontSize(this.save3Button.getLabel(), this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), this.save3Button.getWidth() * 80.0f / 100.0f, this.save3Button.getHeight() * 90.0f / 100.0f);
        this.save3Button.setX(UIHelpers.calcWidthProportion(this.game, 48.0f, 48.0f).floatValue() - this.save3Button.getWidth() / 2.0f);
        this.save3Button.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 2.0f, 100.0f - this.tsp - this.sp * 2.0f).floatValue() - this.save3Button.getHeight() / 2.0f);
        this.stage.addActor(this.save3Button);
        this.delete3Button = new Button(this.game.uiSkin, "cancel");
        this.delete3Button.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                SaveGameScreen.this.showConfirmation(3);
            }
        });
        this.delete3Button.setVisible(!this.save3Button.getLabel().getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "common.new")));
        this.delete3Button.setWidth(UIHelpers.calcHeightProportion(this.game, 6.25f, 6.25f).floatValue());
        this.delete3Button.setHeight(this.delete3Button.getWidth());
        this.delete3Button.setX(this.save3Button.getX() + this.save3Button.getWidth() + UIHelpers.calcWidthProportion(this.game, 0.25f, 0.25f).floatValue());
        this.delete3Button.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 2.0f, 100.0f - this.tsp - this.sp * 2.0f).floatValue() - this.delete3Button.getHeight() / 2.0f);
        this.stage.addActor(this.delete3Button);
        if (this.save3Button.getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "common.new"))) {
            this.save3Button.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 2.0f));
            this.save3Button.getLabel().setColor(this.game.uiSkin.get("lightiron", Color.class));
            this.delete3Button.setVisible(false);
        }
        this.exitButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "common.exit"), this.game.uiSkin, "base");
        this.exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                SaveGameScreen.this.game.mainMenuScreen = new MainMenuScreen(SaveGameScreen.this.game);
                SaveGameScreen.this.game.setScreen(SaveGameScreen.this.game.mainMenuScreen);
                SaveGameScreen.this.dispose();
            }
        });
        this.exitButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        this.exitButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        this.exitButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), this.exitButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        this.exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.exitButton.getWidth() / 2.0f);
        this.exitButton.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 3.0f, 100.0f - this.tsp - this.sp * 3.0f).floatValue() - this.exitButton.getPrefHeight() / 2.0f);
        this.stage.addActor(this.exitButton);
        this.confirmationBackground = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.confirmationBackground.setWidth(UIHelpers.calcHeightProportion(this.game, 75.0f, 75.0f).floatValue());
        this.confirmationBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue());
        this.confirmationBackground.setPosition(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.confirmationBackground.getWidth() / 2.0f, UIHelpers.calcHeightProportion(this.game, 25.0f, 25.0f).floatValue());
        this.confirmationBackground.setVisible(false);
        this.stage.addActor(this.confirmationBackground);
        this.nameLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "common.name"), this.game.uiSkin, "default");
        this.nameLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.nameLabel.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        this.nameLabel.setAlignment(1);
        this.nameLabel.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() / 2.0f - this.nameLabel.getPrefWidth() / 2.0f);
        this.nameLabel.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 85.0f / 100.0f);
        this.nameLabel.setVisible(false);
        this.stage.addActor(this.nameLabel);
        this.name = UIHelpers.createTextField(this.game, UIHelpers.calcHeightProportion(this.game, 32.0f, 32.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.name.setMaxLength(20);
        this.name.setVisible(false);
        this.name.setWidth(this.name.getPrefWidth());
        this.name.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() / 2.0f - this.name.getPrefWidth() / 2.0f);
        this.name.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 75.0f / 100.0f);
        this.stage.addActor(this.name);
        this.difficultyLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty"), this.game.uiSkin, "default");
        this.difficultyLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.difficultyLabel.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        this.difficultyLabel.setAlignment(1);
        this.difficultyLabel.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() / 2.0f - this.difficultyLabel.getPrefWidth() / 2.0f);
        this.difficultyLabel.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 62.0f / 100.0f);
        this.difficultyLabel.setVisible(false);
        this.stage.addActor(this.difficultyLabel);
        this.difficulty = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String[] availableDifficulties = new String[]{PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.normal"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.hard"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.hardcore")};
        this.difficulty.setItems((String[])availableDifficulties);
        this.difficulty.setSelected(availableDifficulties[0]);
        this.difficulty.setVisible(false);
        this.difficulty.setWidth(this.difficulty.getPrefWidth());
        this.difficulty.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() / 2.0f - this.difficulty.getPrefWidth() / 2.0f);
        this.difficulty.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 52.0f / 100.0f);
        this.stage.addActor(this.difficulty);
        this.legendaryLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.legendary") + ": ", this.game.uiSkin, "default");
        this.legendaryLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.legendaryLabel.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        this.legendaryLabel.setAlignment(16);
        this.legendaryLabel.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() * 52.0f / 100.0f - this.legendaryLabel.getWidth());
        this.legendaryLabel.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 40.0f / 100.0f - this.legendaryLabel.getHeight() / 2.0f);
        this.legendaryLabel.setVisible(false);
        this.stage.addActor(this.legendaryLabel);
        this.legendary = new Button(this.game.uiSkin, "check");
        this.legendary.setChecked(false);
        this.legendary.setVisible(false);
        this.legendary.setWidth(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.legendary.setHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.legendary.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() * 53.0f / 100.0f);
        this.legendary.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 40.0f / 100.0f - this.legendary.getHeight() / 2.0f);
        this.stage.addActor(this.legendary);
        this.deleteLabel = new Label("", this.game.uiSkin, "default");
        this.deleteLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.deleteLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.deleteLabel.setAlignment(1);
        this.deleteLabel.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() / 2.0f - this.deleteLabel.getPrefWidth() / 2.0f);
        this.deleteLabel.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 60.0f / 100.0f);
        this.deleteLabel.setVisible(false);
        this.stage.addActor(this.deleteLabel);
        this.newButton = new Button(this.game.uiSkin, "ok");
        this.newButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (!SaveGameScreen.this.name.getText().equalsIgnoreCase("")) {
                    SaveGameScreen.this.game.saveGame = new HashMap();
                    Story.newGame(SaveGameScreen.this.game);
                    SaveGameScreen.this.game.saveGame.put("name", SaveGameScreen.this.name.getText());
                    String finalDifficulty = "normal";
                    if (((String)SaveGameScreen.this.difficulty.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(SaveGameScreen.this.game.gameMessages, "game.settings.difficulty.hard"))) {
                        finalDifficulty = "hard";
                    } else if (((String)SaveGameScreen.this.difficulty.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(SaveGameScreen.this.game.gameMessages, "game.settings.difficulty.hardcore"))) {
                        finalDifficulty = "hardcore";
                    }
                    SaveGameScreen.this.game.saveGame.put("difficulty", finalDifficulty);
                    SaveGameScreen.this.game.saveGame.put("legendary", "" + SaveGameScreen.this.legendary.isChecked());
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    SaveGameScreen.this.game.saveGame.put("time", sf.format(new Date()));
                    SaveGameScreen.this.game.saveGame.put("position", "" + SaveGameScreen.this.selectedPosition);
                    Story.getFixedEvent(SaveGameScreen.this.game, "start.1");
                    SaveGameScreen.this.dispose();
                }
            }
        });
        this.newButton.setVisible(false);
        this.newButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.newButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.newButton.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() * 47.0f / 100.0f - this.newButton.getWidth());
        this.newButton.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 10.0f / 100.0f);
        this.stage.addActor(this.newButton);
        this.infoButton = new Button(this.game.uiSkin, "info");
        this.infoButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                SaveGameScreen.this.showInfo();
            }
        });
        this.infoButton.setVisible(false);
        this.infoButton.setWidth(UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.infoButton.setHeight(UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.infoButton.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() * 96.0f / 100.0f - this.infoButton.getWidth());
        this.infoButton.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 96.0f / 100.0f - this.infoButton.getHeight());
        this.stage.addActor(this.infoButton);
        this.deleteButton = new Button(this.game.uiSkin, "ok");
        this.deleteButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.deleteButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.deleteButton.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() * 47.0f / 100.0f - this.deleteButton.getWidth());
        this.deleteButton.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 10.0f / 100.0f);
        this.deleteButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                SaveGameScreen.this.deleteSaveGame(SaveGameScreen.this.selectedPosition);
                SaveGameScreen.this.confirmationBackground.setVisible(false);
                SaveGameScreen.this.deleteLabel.setText("");
                SaveGameScreen.this.deleteLabel.setVisible(false);
                SaveGameScreen.this.deleteButton.setVisible(false);
                SaveGameScreen.this.cancelButton.setVisible(false);
                SaveGameScreen.this.save1Button.setVisible(true);
                if (!SaveGameScreen.this.save1Button.getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(SaveGameScreen.this.game.gameMessages, "common.new"))) {
                    SaveGameScreen.this.delete1Button.setVisible(true);
                }
                SaveGameScreen.this.save2Button.setVisible(true);
                if (!SaveGameScreen.this.save2Button.getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(SaveGameScreen.this.game.gameMessages, "common.new"))) {
                    SaveGameScreen.this.delete2Button.setVisible(true);
                }
                SaveGameScreen.this.save3Button.setVisible(true);
                if (!SaveGameScreen.this.save3Button.getText().toString().equalsIgnoreCase(PropertiesReader.getMessage(SaveGameScreen.this.game.gameMessages, "common.new"))) {
                    SaveGameScreen.this.delete3Button.setVisible(true);
                }
                SaveGameScreen.this.exitButton.setVisible(true);
            }
        });
        this.deleteButton.setVisible(false);
        this.stage.addActor(this.deleteButton);
        this.cancelButton = new Button(this.game.uiSkin, "cancel");
        this.cancelButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                SaveGameScreen.this.confirmationBackground.setVisible(false);
                SaveGameScreen.this.nameLabel.setVisible(false);
                SaveGameScreen.this.name.setVisible(false);
                SaveGameScreen.this.difficultyLabel.setVisible(false);
                SaveGameScreen.this.difficulty.setVisible(false);
                SaveGameScreen.this.legendaryLabel.setVisible(false);
                SaveGameScreen.this.legendary.setVisible(false);
                SaveGameScreen.this.deleteLabel.setText("");
                SaveGameScreen.this.deleteLabel.setVisible(false);
                SaveGameScreen.this.newButton.setVisible(false);
                SaveGameScreen.this.deleteButton.setVisible(false);
                SaveGameScreen.this.cancelButton.setVisible(false);
                SaveGameScreen.this.infoButton.setVisible(false);
                SaveGameScreen.this.save1Button.setVisible(true);
                SaveGameScreen.this.delete1Button.setVisible(true);
                SaveGameScreen.this.save2Button.setVisible(true);
                SaveGameScreen.this.delete2Button.setVisible(true);
                SaveGameScreen.this.save3Button.setVisible(true);
                SaveGameScreen.this.delete3Button.setVisible(true);
                SaveGameScreen.this.exitButton.setVisible(true);
            }
        });
        this.cancelButton.setVisible(false);
        this.cancelButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.cancelButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.cancelButton.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() * 53.0f / 100.0f);
        this.cancelButton.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 10.0f / 100.0f);
        this.stage.addActor(this.cancelButton);
        this.tooltipBackground = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.tooltipBackground.setWidth(UIHelpers.calcHeightProportion(this.game, 75.0f, 75.0f).floatValue());
        this.tooltipBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue());
        this.tooltipBackground.setPosition(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.tooltipBackground.getWidth() / 2.0f, UIHelpers.calcHeightProportion(this.game, 25.0f, 25.0f).floatValue());
        this.tooltipBackground.setVisible(false);
        this.stage.addActor(this.tooltipBackground);
        this.tooltipLabel = new Label("", this.game.uiSkin, "default");
        this.tooltipLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.tooltipLabel.setWrap(true);
        this.tooltipLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.tooltipLabel.setAlignment(2);
        this.tooltipLabel.setWidth(this.tooltipBackground.getWidth() * 94.0f / 100.0f);
        this.tooltipLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.tooltip"));
        UIHelpers.fixLabelFontSize(this.tooltipLabel, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.tooltipBackground.getHeight() * 75.0f / 100.0f);
        this.tooltipLabel.setX(this.tooltipBackground.getX() + this.tooltipBackground.getWidth() * 3.0f / 100.0f);
        this.tooltipLabel.setY(this.tooltipBackground.getY() + this.tooltipBackground.getHeight() * 95.0f / 100.0f);
        this.tooltipLabel.setVisible(false);
        this.stage.addActor(this.tooltipLabel);
        this.cancelInfoButton = new Button(this.game.uiSkin, "cancel");
        this.cancelInfoButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                SaveGameScreen.this.confirmationBackground.setVisible(true);
                SaveGameScreen.this.nameLabel.setVisible(true);
                SaveGameScreen.this.name.setVisible(true);
                SaveGameScreen.this.difficultyLabel.setVisible(true);
                SaveGameScreen.this.legendaryLabel.setVisible(true);
                SaveGameScreen.this.legendary.setVisible(true);
                SaveGameScreen.this.difficulty.setVisible(true);
                SaveGameScreen.this.newButton.setVisible(true);
                SaveGameScreen.this.cancelButton.setVisible(true);
                SaveGameScreen.this.infoButton.setVisible(true);
                SaveGameScreen.this.tooltipBackground.setVisible(false);
                SaveGameScreen.this.tooltipLabel.setVisible(false);
                SaveGameScreen.this.cancelInfoButton.setVisible(false);
            }
        });
        this.cancelInfoButton.setVisible(false);
        this.cancelInfoButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.cancelInfoButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.cancelInfoButton.setX(this.tooltipBackground.getX() + this.tooltipBackground.getWidth() * 50.0f / 100.0f - this.cancelInfoButton.getWidth() / 2.0f);
        this.cancelInfoButton.setY(this.tooltipBackground.getY() + this.tooltipBackground.getHeight() * 10.0f / 100.0f);
        this.stage.addActor(this.cancelInfoButton);
        if (!this.game.input.equalsIgnoreCase("keyboard")) {
            Button menuButton = new Button(this.game.uiSkin, "menu");
            menuButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            menuButton.setHeight(menuButton.getWidth());
            menuButton.setX(10.0f);
            menuButton.setY(this.game.viewHeight.floatValue() - menuButton.getWidth() - 10.0f);
            menuButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    SaveGameScreen.this.game.mainMenuScreen = new MainMenuScreen(SaveGameScreen.this.game);
                    SaveGameScreen.this.game.setScreen(SaveGameScreen.this.game.mainMenuScreen);
                    SaveGameScreen.this.dispose();
                }
            });
            menuButton.setVisible(true);
            this.stage.addActor(menuButton);
        }
    }

    @Override
    public void render(float delta) {
        this.game.manager.update();
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4 || keycode == 82) {
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
            this.dispose();
        }
        return false;
    }

    private String getSaveHeader(int position) {
        String header = "";
        HashMap<String, String> currSave = PropertiesReader.loadGame(position, this.game.mail, this.game.key, this.game.debugMode);
        if (currSave.get("name").equalsIgnoreCase("0")) {
            header = PropertiesReader.getMessage(this.game.gameMessages, "common.new");
        } else if (currSave.get("delete") != null && !currSave.get("delete").equalsIgnoreCase("") && currSave.get("legendary").equalsIgnoreCase("true")) {
            PropertiesReader.deleteGame(position, this.game.mail, this.game.key);
            header = PropertiesReader.getMessage(this.game.gameMessages, "common.new");
        } else {
            header = "[#D4D4D4]" + currSave.get("name") + " - [#A8A8A8]" + currSave.get("time") + "\n" + PropertiesReader.getMessage(this.game.gameMessages, "common.reputation") + ": [#FF0000]" + currSave.get("maxreputation") + "[#A8A8A8], " + PropertiesReader.getMessage(this.game.gameMessages, "common.phase") + ": [#FF0000]" + PropertiesReader.getMessage(this.game.gameMessages, "game.settings.phase." + currSave.get("phase")) + "[#A8A8A8], " + PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty") + ": [#FF0000]" + PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty." + currSave.get("difficulty"));
        }
        return header;
    }

    private void showNewGame(int position) {
        this.selectedPosition = position;
        this.save1Button.setVisible(false);
        this.delete1Button.setVisible(false);
        this.save2Button.setVisible(false);
        this.delete2Button.setVisible(false);
        this.save3Button.setVisible(false);
        this.delete3Button.setVisible(false);
        this.exitButton.setVisible(false);
        this.confirmationBackground.setVisible(true);
        this.nameLabel.setVisible(true);
        this.name.setVisible(true);
        this.name.setText("");
        this.stage.setKeyboardFocus(this.name);
        this.difficultyLabel.setVisible(true);
        this.difficulty.setSelected("normal");
        this.legendaryLabel.setVisible(true);
        this.legendary.setVisible(true);
        this.legendary.setChecked(false);
        this.difficulty.setVisible(true);
        this.newButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.infoButton.setVisible(true);
    }

    private void showConfirmation(int position) {
        this.selectedPosition = position;
        this.save1Button.setVisible(false);
        this.delete1Button.setVisible(false);
        this.save2Button.setVisible(false);
        this.delete2Button.setVisible(false);
        this.save3Button.setVisible(false);
        this.delete3Button.setVisible(false);
        this.exitButton.setVisible(false);
        this.confirmationBackground.setVisible(true);
        this.deleteLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "system.save.confirmation") + "?\n\n" + this.getSaveHeader(position));
        this.deleteLabel.setVisible(true);
        this.deleteButton.setVisible(true);
        this.cancelButton.setVisible(true);
    }

    private void showInfo() {
        this.confirmationBackground.setVisible(false);
        this.nameLabel.setVisible(false);
        this.name.setVisible(false);
        this.difficultyLabel.setVisible(false);
        this.legendaryLabel.setVisible(false);
        this.legendary.setVisible(false);
        this.difficulty.setVisible(false);
        this.newButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.infoButton.setVisible(false);
        this.tooltipBackground.setVisible(true);
        this.tooltipLabel.setVisible(true);
        this.cancelInfoButton.setVisible(true);
    }

    private void deleteSaveGame(int position) {
        PropertiesReader.deleteGame(position, this.game.mail, this.game.key);
        if (position == 1) {
            this.save1Button.getLabel().setText(PropertiesReader.getMessage(this.game.gameMessages, "common.new"));
            this.save1Button.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 2.0f));
            this.save1Button.getLabel().setColor(this.game.uiSkin.get("lightiron", Color.class));
            this.delete1Button.setVisible(false);
        } else if (position == 2) {
            this.save2Button.getLabel().setText(PropertiesReader.getMessage(this.game.gameMessages, "common.new"));
            this.save2Button.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 2.0f));
            this.save2Button.getLabel().setColor(this.game.uiSkin.get("lightiron", Color.class));
            this.delete2Button.setVisible(false);
        } else {
            this.save3Button.getLabel().setText(PropertiesReader.getMessage(this.game.gameMessages, "common.new"));
            this.save3Button.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 2.0f));
            this.save3Button.getLabel().setColor(this.game.uiSkin.get("lightiron", Color.class));
            this.delete3Button.setVisible(false);
        }
    }

    private void launchSaveGame(int position) {
        this.game.saveGame.clear();
        this.game.saveGame = PropertiesReader.loadGame(position, this.game.mail, this.game.key, this.game.debugMode);
        Story.loadState(this.game);
        this.dispose();
    }
}

