/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.AnimatedActor;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.ParticleEffectActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Story;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.screen.MessageScreen;
import com.calimasaga.slavepits.screen.PrepSetupScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import com.calimasaga.slavepits.util.StringList;
import java.util.ArrayList;
import java.util.HashMap;

public class LoreScreen
extends BaseScreen {
    public String musicTrack = "";
    public ArrayList<String> backgroundImages = new ArrayList();
    public String story = "";
    public Long time = null;
    public float timeElapsed = 0.0f;
    private ArrayList<FrameBuffer> listFrameBuffer = new ArrayList();
    private ArrayList<BaseActor> listAnimatedActor = new ArrayList();
    private ArrayList<ParticleEffectActor> listParticleEffectActor = new ArrayList();
    public HashMap<Integer, Label> availableOptions = new HashMap();
    public Label storyLabel;
    public Table storyTable;
    public ScrollPane storyPane;
    public NinePatchActor textOverlay;
    public Button skipButton;
    public Button nextButton;
    public Button menuButton;

    public LoreScreen(SlavePitsGame g, String selMusic, String selBackground, String selStory, Long selTime) {
        super(g);
        this.musicTrack = selMusic;
        this.backgroundImages.add(selBackground);
        this.story = selStory;
        this.time = selTime;
        this.timeElapsed = 0.0f;
        this.create();
    }

    @Override
    public void create() {
        if (this.game.track != null && this.game.track.isPlaying()) {
            this.game.track.stop();
            this.game.track.dispose();
        }
        this.game.track = Gdx.audio.newMusic(Gdx.files.internal(this.musicTrack));
        this.game.track.setLooping(true);
        this.game.track.setVolume(this.game.musicVolume);
        this.game.track.play();
        BaseActor background = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, background, this.backgroundImages.get(0), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.stage.addActor(background);
        this.textOverlay = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.textOverlay.getColor().a = 0.75f;
        this.textOverlay.setWidth(UIHelpers.calcWidthProportion(this.game, 72.0f, 76.0f).floatValue());
        this.textOverlay.setX(UIHelpers.calcWidthProportion(this.game, 14.0f, 12.0f).floatValue());
        this.storyLabel = new Label("", this.game.uiSkin, "default");
        this.storyLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.storyLabel.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.storyLabel.setAlignment(10);
        this.storyLabel.setWrap(true);
        this.storyLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 70.0f, 74.0f).floatValue());
        this.storyLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "zone." + this.story, this.game.violenceFilter, "##:" + new Color(this.game.uiSkin.get("lightiron", Color.class)).mul(0.9f).toString()));
        this.storyLabel.invalidate();
        this.storyTable = new Table();
        this.storyTable.left().top();
        this.storyTable.setWidth(UIHelpers.calcWidthProportion(this.game, 70.0f, 74.0f).floatValue());
        this.storyTable.add(this.storyLabel).width(this.storyTable.getWidth());
        this.storyPane = new ScrollPane((Actor)this.storyTable);
        this.storyPane.addListener(new InputListener(){

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                LoreScreen.this.stage.setScrollFocus(null);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                LoreScreen.this.stage.setScrollFocus(event.getListenerActor());
            }
        });
        this.storyPane.setForceScroll(false, true);
        this.storyPane.setFlickScroll(false);
        this.storyPane.setOverscroll(false, true);
        this.storyPane.setWidth(this.storyTable.getWidth());
        this.storyPane.setX(UIHelpers.calcWidthProportion(this.game, 15.0f, 13.0f).floatValue());
        this.storyPane.setHeight(UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue());
        this.storyPane.layout();
        this.storyPane.setY(0.0f - UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue());
        this.storyPane.setScrollY(0.0f);
        if (this.game.portraitmode) {
            this.storyPane.addListener(new DragListener(){

                @Override
                public void drag(InputEvent event, float x, float y, int pointer) {
                    super.drag(event, x, y, pointer);
                    LoreScreen.this.storyPane.setScrollY(LoreScreen.this.storyPane.getScrollY() + (float)((int)this.getDeltaY()));
                }
            });
        } else {
            this.storyPane.addListener(new InputListener(){

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                    LoreScreen.this.stage.setScrollFocus(null);
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    LoreScreen.this.stage.setScrollFocus(event.getListenerActor());
                }
            });
        }
        SequenceAction scroll = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.moveTo(UIHelpers.calcWidthProportion(this.game, 15.0f, 13.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue(), (float)this.time.longValue() / 1000.0f));
        this.storyPane.addAction(scroll);
        float textOverlaySize = this.storyTable.getCell(this.storyLabel).getPrefHeight();
        this.textOverlay.setHeight(Math.min(textOverlaySize * 104.0f / 100.0f, this.storyPane.getHeight() * 104.0f / 100.0f));
        this.textOverlay.setY(0.0f - this.textOverlay.getHeight() * 98.0f / 100.0f);
        SequenceAction scrolloverlay = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.moveTo(UIHelpers.calcWidthProportion(this.game, 14.0f, 12.0f).floatValue(), this.game.viewHeight.floatValue() - this.textOverlay.getHeight() * 98.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue(), (float)this.time.longValue() / 1000.0f));
        this.textOverlay.addAction(scrolloverlay);
        this.skipButton = new Button(this.game.uiSkin, "skip");
        this.skipButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.skipButton.setHeight(this.skipButton.getWidth());
        this.skipButton.setTransform(true);
        this.skipButton.rotateBy(270.0f);
        this.skipButton.setOrigin(this.skipButton.getWidth() / 2.0f, this.skipButton.getHeight() / 2.0f);
        this.skipButton.setX(10.0f);
        this.skipButton.setY(10.0f);
        this.skipButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                for (Actor currActor : LoreScreen.this.stage.getActors()) {
                    if (currActor.getActions() == null || currActor.getActions().size <= 0) continue;
                    for (Action currAction : currActor.getActions()) {
                        currAction.act(10000.0f);
                    }
                }
                LoreScreen.this.storyPane.scrollTo(0.0f, 0.0f, 0.0f, 0.0f);
            }
        });
        if (!this.game.input.equalsIgnoreCase("keyboard")) {
            this.menuButton = new Button(this.game.uiSkin, "menu");
            this.menuButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.menuButton.setHeight(this.menuButton.getWidth());
            this.menuButton.setX(10.0f);
            this.menuButton.setY(this.game.viewHeight.floatValue() - this.menuButton.getWidth() - 10.0f);
            this.menuButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    LoreScreen.this.game.mainMenuScreen = new MainMenuScreen(LoreScreen.this.game);
                    LoreScreen.this.game.setScreen(LoreScreen.this.game.mainMenuScreen);
                    LoreScreen.this.dispose();
                }
            });
            this.menuButton.setVisible(true);
        }
        this.addFadeOverlay(Float.valueOf(1.0f));
        this.addActorsByLoreId();
    }

    @Override
    public void render(float delta) {
        this.timeElapsed += delta;
        this.renderByLoreId(delta);
    }

    @Override
    public void dispose() {
        for (String currBackground : this.backgroundImages) {
            UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset(currBackground));
        }
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4 || keycode == 82) {
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
            this.dispose();
        } else if (keycode == Input.Keys.valueOf(this.game.nextkey)) {
            if (this.nextButton != null && this.nextButton.isVisible()) {
                InputEvent event = new InputEvent();
                event.setType(InputEvent.Type.touchUp);
                this.nextButton.fire(event);
                return true;
            }
        } else if ((keycode >= 7 || keycode <= 16) && this.availableOptions.get(keycode - 7) != null) {
            InputEvent event = new InputEvent();
            event.setType(InputEvent.Type.touchUp);
            this.availableOptions.get(keycode - 7).fire(event);
            return true;
        }
        return false;
    }

    private void addActorsByLoreId() {
        if (this.story.equalsIgnoreCase("start.1")) {
            this.storyPane.clearActions();
            this.storyPane.setY(this.game.viewHeight.floatValue() - this.storyPane.getHeight() - 200.0f);
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    Story.getFixedEvent(LoreScreen.this.game, "start.2");
                    LoreScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(5.0f));
        } else if (this.story.equalsIgnoreCase("lore.1")) {
            BaseActor nextbackground = new BaseActor();
            UIHelpers.portraitModeFixBackground(this.game, nextbackground, this.game.getOverridenFilename("data/backgrounds/backgroundLore1.jpg"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
            this.backgroundImages.add("data/backgrounds/backgroundLore1.jpg");
            nextbackground.getColor().a = 0.0f;
            this.stage.addActor(nextbackground);
            SequenceAction nextFadeIn = Actions.sequence((Action)Actions.delay(10.0f), (Action)Actions.fadeIn(10.0f));
            nextbackground.addAction(nextFadeIn);
            FrameBuffer frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, this.game.viewWidth.intValue(), this.game.viewHeight.intValue(), true);
            this.listFrameBuffer.add(frameBuffer);
            AnimatedActor l1 = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/misceffects.atlas"), "light", 3, this.game.viewWidth.floatValue() / 2.0f, this.game.viewWidth.floatValue() / 2.0f, false);
            l1.setPosition(this.game.viewWidth.floatValue() * 15.0f / 100.0f - l1.getWidth() / 2.0f, this.game.viewHeight.floatValue() * 77.0f / 100.0f - l1.getHeight() / 2.0f);
            l1.playAnimation(86400.0f, 0.1f, 5.0f);
            this.listAnimatedActor.add(l1);
            AnimatedActor l2 = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/misceffects.atlas"), "light", 3, this.game.viewWidth.floatValue() * 2.0f / 3.0f, this.game.viewWidth.floatValue() * 2.0f / 3.0f, false);
            l2.setPosition(this.game.viewWidth.floatValue() * 60.0f / 100.0f - l2.getWidth() / 2.0f, this.game.viewHeight.floatValue() * 77.0f / 100.0f - l2.getHeight() / 2.0f);
            l2.playAnimation(86400.0f, 0.1f, 5.0f);
            this.listAnimatedActor.add(l2);
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    Story.getFixedEvent(LoreScreen.this.game, "lore.2");
                    LoreScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            this.stage.addActor(this.skipButton);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            Label optionLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.skiptutorial"), this.game.uiSkin, "default");
            optionLabel.setFontScale(this.storyLabel.getFontScaleX());
            optionLabel.setColor(this.game.uiSkin.getColor("white"));
            optionLabel.setAlignment(1);
            optionLabel.setWrap(true);
            optionLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 70.0f, 74.0f).floatValue());
            optionLabel.addListener(new InputListener(){

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    event.getListenerActor().setColor(LoreScreen.this.game.uiSkin.getColor("red"));
                }

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                    event.getListenerActor().setColor(LoreScreen.this.game.uiSkin.getColor("white"));
                }

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    Story.getFixedEvent(LoreScreen.this.game, "chapter.1");
                    LoreScreen.this.dispose();
                }
            });
            optionLabel.layout();
            this.storyTable.row();
            this.storyTable.add(optionLabel).width(this.storyTable.getWidth());
            this.storyTable.getCell(optionLabel).padTop(UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
            this.textOverlay.clearActions();
            float textOverlaySize = this.storyTable.getCell(this.storyLabel).getPrefHeight() + this.storyTable.getCell(optionLabel).getPrefHeight() + UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue();
            this.textOverlay.setHeight(Math.min(textOverlaySize * 104.0f / 100.0f, this.storyPane.getHeight() * 104.0f / 100.0f));
            this.textOverlay.setY(0.0f - this.textOverlay.getHeight() * 98.0f / 100.0f);
            SequenceAction scrolloverlay = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.moveTo(UIHelpers.calcWidthProportion(this.game, 14.0f, 12.0f).floatValue(), this.game.viewHeight.floatValue() - this.textOverlay.getHeight() * 98.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue(), (float)this.time.longValue() / 1000.0f));
            this.textOverlay.addAction(scrolloverlay);
        } else if (this.story.equalsIgnoreCase("lore.2")) {
            FrameBuffer frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, this.game.viewWidth.intValue(), this.game.viewHeight.intValue(), true);
            this.listFrameBuffer.add(frameBuffer);
            AnimatedActor l1 = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/misceffects.atlas"), "light", 3, this.game.viewWidth.floatValue() / 2.0f, this.game.viewWidth.floatValue() / 2.0f, false);
            l1.setPosition(this.game.viewWidth.floatValue() * 45.0f / 100.0f - l1.getWidth() / 2.0f, this.game.viewHeight.floatValue() * 60.0f / 100.0f - l1.getHeight() / 2.0f);
            l1.playAnimation(86400.0f, 0.1f, 5.0f);
            this.listAnimatedActor.add(l1);
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            this.stage.addActor(this.skipButton);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    Story.getTutorialFight(LoreScreen.this.game);
                    LoreScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(10.0f));
        } else if (this.story.equalsIgnoreCase("lore.3")) {
            FrameBuffer frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, this.game.viewWidth.intValue(), this.game.viewHeight.intValue(), true);
            this.listFrameBuffer.add(frameBuffer);
            AnimatedActor l1 = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/misceffects.atlas"), "light", 3, this.game.viewWidth.floatValue() / 2.0f, this.game.viewWidth.floatValue() / 2.0f, false);
            l1.setPosition(this.game.viewWidth.floatValue() * 45.0f / 100.0f - l1.getWidth() / 2.0f, this.game.viewHeight.floatValue() * 60.0f / 100.0f - l1.getHeight() / 2.0f);
            l1.playAnimation(86400.0f, 0.1f, 5.0f);
            this.listAnimatedActor.add(l1);
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            this.stage.addActor(this.skipButton);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    Story.getFixedEvent(LoreScreen.this.game, "chapter.1");
                    LoreScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(10.0f));
        } else if (this.story.equalsIgnoreCase("lore.4")) {
            FrameBuffer frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, this.game.viewWidth.intValue(), this.game.viewHeight.intValue(), true);
            this.listFrameBuffer.add(frameBuffer);
            AnimatedActor l1 = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/misceffects.atlas"), "light", 3, this.game.viewWidth.floatValue() / 2.0f, this.game.viewWidth.floatValue() / 2.0f, false);
            l1.setPosition(this.game.viewWidth.floatValue() * 84.0f / 100.0f - l1.getWidth() / 2.0f, this.game.viewHeight.floatValue() * 90.0f / 100.0f - l1.getHeight() / 2.0f);
            l1.playAnimation(86400.0f, 0.1f, 5.0f);
            this.listAnimatedActor.add(l1);
            TextureAtlas misceffectsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/misceffects.atlas"), TextureAtlas.class);
            ParticleEffectActor t1 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenFilename("data/elements/torch.p")), misceffectsAtlas, this.game.viewWidth.floatValue() * 84.0f / 100.0f, this.game.viewHeight.floatValue() * 90.0f / 100.0f, true);
            this.listParticleEffectActor.add(t1);
            this.stage.addActor(t1);
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            this.stage.addActor(this.skipButton);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    LoreScreen.this.game.saveGame.put("fight", "0");
                    LoreScreen.this.game.campaignFighter = Story.getNewPlayerFighter(LoreScreen.this.game);
                    Story.getNextFight(LoreScreen.this.game);
                    LoreScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(10.0f));
        } else if (this.story.equalsIgnoreCase("lore.5")) {
            BaseActor nextbackground = new BaseActor();
            UIHelpers.portraitModeFixBackground(this.game, nextbackground, this.game.getOverridenFilename("data/backgrounds/backgroundLore4.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
            this.backgroundImages.add("data/backgrounds/backgroundLore4.png");
            Color origColor = new Color(nextbackground.getColor());
            nextbackground.setColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.stage.addActor(nextbackground);
            SequenceAction nextFadeIn = Actions.sequence((Action)Actions.delay(10.0f), (Action)Actions.fadeIn(2.0f), (Action)Actions.color(origColor, 4.0f));
            nextbackground.addAction(nextFadeIn);
            BaseActor overlay = new BaseActor();
            overlay.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/overlay.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
            overlay.setColor(0.0f, 0.0f, 0.0f, 0.3f);
            overlay.setPosition(0.0f, 0.0f);
            this.stage.addActor(overlay);
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            this.stage.addActor(this.skipButton);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (!PropertiesReader.verifyKey(LoreScreen.this.game.mail, LoreScreen.this.game.key, LoreScreen.this.game.checksum).equalsIgnoreCase("free")) {
                        Story.getBossFight(LoreScreen.this.game, 1);
                        LoreScreen.this.dispose();
                    } else {
                        LoreScreen.this.game.messageScreen = new MessageScreen(LoreScreen.this.game, PropertiesReader.getMessage(LoreScreen.this.game.gameMessages, "game.settings.endfree"), "00B3B3FF", LoreScreen.this.game.viewHeight.floatValue() / (LoreScreen.this.game.heightBASE.floatValue() / 2.0f), "mainmenu;fadein:1.0;", "chapter");
                        LoreScreen.this.game.setScreen(LoreScreen.this.game.messageScreen);
                        LoreScreen.this.dispose();
                    }
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(10.0f));
        } else if (this.story.equalsIgnoreCase("lore.6")) {
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            this.stage.addActor(this.skipButton);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    Story.getFixedEvent(LoreScreen.this.game, "chapter.2");
                    LoreScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(10.0f));
        } else if (this.story.equalsIgnoreCase("lore.7")) {
            BaseActor nextbackground = new BaseActor();
            UIHelpers.portraitModeFixBackground(this.game, nextbackground, this.game.getOverridenFilename("data/backgrounds/backgroundLore6.jpg"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
            this.backgroundImages.add("data/backgrounds/backgroundLore6.jpg");
            nextbackground.getColor().a = 0.0f;
            this.stage.addActor(nextbackground);
            SequenceAction nextFadeIn = Actions.sequence((Action)Actions.delay(10.0f), (Action)Actions.fadeIn(10.0f));
            nextbackground.addAction(nextFadeIn);
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            this.stage.addActor(this.skipButton);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    int fight = Integer.parseInt(LoreScreen.this.game.saveGame.get("fight"));
                    LoreScreen.this.game.messageScreen = new MessageScreen(LoreScreen.this.game, PropertiesReader.getMessage(LoreScreen.this.game.gameMessages, "game.settings.day") + " " + (fight + 1 + Integer.parseInt(LoreScreen.this.game.saveGame.get("lostDays"))), "E6E6E6FF", LoreScreen.this.game.viewHeight.floatValue() / (LoreScreen.this.game.heightBASE.floatValue() / 2.0f), "fighttimer:5.0;fadein:1.0;3.0;1.0", "day:1.0");
                    LoreScreen.this.game.setScreen(LoreScreen.this.game.messageScreen);
                    LoreScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(10.0f));
        } else if (this.story.equalsIgnoreCase("lore.10")) {
            BaseActor nextbackground = new BaseActor();
            UIHelpers.portraitModeFixBackground(this.game, nextbackground, this.game.getOverridenFilename("data/backgrounds/backgroundCity.jpg"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
            this.backgroundImages.add("data/backgrounds/backgroundCity.jpg");
            nextbackground.getColor().a = 0.0f;
            this.stage.addActor(nextbackground);
            SequenceAction nextFadeIn = Actions.sequence((Action)Actions.delay(10.0f), (Action)Actions.fadeIn(10.0f));
            nextbackground.addAction(nextFadeIn);
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            this.stage.addActor(this.skipButton);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    LoreScreen.this.game.prepSetupScreen = new PrepSetupScreen(LoreScreen.this.game, 10000, 500);
                    LoreScreen.this.game.setScreen(LoreScreen.this.game.prepSetupScreen);
                    LoreScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(10.0f));
        } else if (this.story.contains("duelplot")) {
            BaseActor nextbackground = new BaseActor();
            UIHelpers.portraitModeFixBackground(this.game, nextbackground, this.game.getOverridenFilename("data/backgrounds/backgroundLore7.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
            this.backgroundImages.add("data/backgrounds/backgroundLore7.png");
            Color origColor = new Color(nextbackground.getColor());
            nextbackground.setColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.stage.addActor(nextbackground);
            SequenceAction nextFadeIn = Actions.sequence((Action)Actions.delay(10.0f), (Action)Actions.fadeIn(2.0f), (Action)Actions.color(origColor, 4.0f));
            nextbackground.addAction(nextFadeIn);
            BaseActor overlay = new BaseActor();
            overlay.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/overlay.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
            overlay.setColor(0.0f, 0.0f, 0.0f, 0.3f);
            overlay.setPosition(0.0f, 0.0f);
            this.stage.addActor(overlay);
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            this.stage.addActor(this.skipButton);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    Story.getBossFight(LoreScreen.this.game, 2);
                    LoreScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(10.0f));
        } else if (this.story.contains("endplot")) {
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            this.stage.addActor(this.skipButton);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    Story.getFixedEvent(LoreScreen.this.game, "chapter.3");
                    LoreScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(10.0f));
        } else if (this.story.startsWith("event.")) {
            Stack fullPortrait = new Stack();
            fullPortrait.setSize(200.0f, 200.0f);
            TextureAtlas portraitsAtlas = this.game.manager.get("data/portraits/portraits.atlas", TextureAtlas.class);
            BaseActor portrait = new BaseActor();
            portrait.setTexture(portraitsAtlas.findRegion(((JSONObject)this.game.stats.get("story").get("portraits")).getString(this.story)), 200.0f, 200.0f);
            fullPortrait.add(portrait);
            BaseActor portraitFrame = new BaseActor();
            portraitFrame.setTexture(portraitsAtlas.findRegion("portraitframe"), 200.0f, 200.0f);
            fullPortrait.add(portraitFrame);
            fullPortrait.setX(this.game.viewWidth.floatValue() / 2.0f - 100.0f);
            fullPortrait.setY(0.0f);
            SequenceAction scroll = Actions.sequence((Action)Actions.moveTo(this.game.viewWidth.floatValue() / 2.0f - 100.0f, this.game.viewHeight.floatValue() - 220.0f, (float)this.time.longValue() / 1000.0f));
            fullPortrait.addAction(scroll);
            this.stage.addActor(fullPortrait);
            this.storyLabel.setColor(this.game.uiSkin.get("lightiron", Color.class));
            this.storyPane.setHeight(UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue() - 220.0f);
            this.storyPane.layout();
            this.storyPane.setY(0.0f - this.storyPane.getHeight() - 20.0f);
            this.storyPane.clearActions();
            SequenceAction scrollStory = Actions.sequence((Action)Actions.moveTo(UIHelpers.calcWidthProportion(this.game, 15.0f, 13.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue(), (float)this.time.longValue() / 1000.0f));
            this.storyPane.addAction(scrollStory);
            float textOverlaySize = this.storyTable.getCell(this.storyLabel).getPrefHeight();
            this.stage.addActor(this.textOverlay);
            this.stage.addActor(this.storyPane);
            this.stage.addActor(this.skipButton);
            if (!this.game.input.equalsIgnoreCase("keyboard")) {
                this.stage.addActor(this.menuButton);
            }
            if (this.story.contains("combo")) {
                this.story = this.story.substring(0, this.story.length() - 2);
            }
            if (!PropertiesReader.getMessage(this.game.gameMessages, "zone." + this.story + ".option1", this.game.violenceFilter).equalsIgnoreCase("")) {
                int i = 1;
                String text = PropertiesReader.getMessage(this.game.gameMessages, "zone." + this.story + ".option" + i, this.game.violenceFilter);
                while (!text.equalsIgnoreCase("")) {
                    if (Story.isValidCondition(this.game, this.story, i)) {
                        Label optionLabel = new Label(i + ". " + text, this.game.uiSkin, "default");
                        optionLabel.setFontScale(this.storyLabel.getFontScaleX());
                        optionLabel.setColor(this.game.uiSkin.getColor("white"));
                        optionLabel.setAlignment(10);
                        optionLabel.setWrap(true);
                        optionLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 70.0f, 74.0f).floatValue());
                        optionLabel.addListener(new InputListener(){

                            @Override
                            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                                event.getListenerActor().setColor(LoreScreen.this.game.uiSkin.getColor("red"));
                            }

                            @Override
                            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                                event.getListenerActor().setColor(LoreScreen.this.game.uiSkin.getColor("white"));
                            }

                            @Override
                            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                                return true;
                            }

                            @Override
                            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                                StringBuilder currRewards = StringList.create(LoreScreen.this.game.saveGame.get("rewards"), ";");
                                currRewards = StringList.set(currRewards, 1, ((Label)event.getListenerActor()).getText().toString().substring(0, 1), ";");
                                LoreScreen.this.game.saveGame.put("rewards", currRewards.toString());
                                Story.getNextScreen(LoreScreen.this.game, "event", ((Label)event.getListenerActor()).getText().toString().substring(0, 1));
                                LoreScreen.this.dispose();
                            }
                        });
                        this.stage.addActor(optionLabel);
                        this.availableOptions.put(i, optionLabel);
                        optionLabel.layout();
                        this.storyTable.row();
                        this.storyTable.add(optionLabel).width(this.storyTable.getWidth());
                        this.storyTable.getCell(optionLabel).padTop(UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
                        textOverlaySize = textOverlaySize + this.storyTable.getCell(optionLabel).getPrefHeight() + UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue();
                    }
                    text = PropertiesReader.getMessage(this.game.gameMessages, "zone." + this.story + ".option" + ++i, this.game.violenceFilter);
                }
                this.textOverlay.clearActions();
                this.textOverlay.setHeight(Math.min(textOverlaySize * 104.0f / 100.0f, this.storyPane.getHeight() * 104.0f / 100.0f));
                this.textOverlay.setY(0.0f - this.textOverlay.getHeight() * 98.0f / 100.0f - 20.0f);
                SequenceAction scrolloverlay = Actions.sequence((Action)Actions.moveTo(UIHelpers.calcWidthProportion(this.game, 14.0f, 12.0f).floatValue(), this.game.viewHeight.floatValue() - this.textOverlay.getHeight() * 98.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue() - 220.0f, (float)this.time.longValue() / 1000.0f));
                this.textOverlay.addAction(scrolloverlay);
            } else {
                this.textOverlay.setHeight(Math.min(textOverlaySize * 104.0f / 100.0f, this.storyPane.getHeight() * 104.0f / 100.0f));
                this.textOverlay.setY(0.0f - this.textOverlay.getHeight() * 98.0f / 100.0f - 20.0f);
                this.textOverlay.clearActions();
                SequenceAction scrolloverlay = Actions.sequence((Action)Actions.moveTo(UIHelpers.calcWidthProportion(this.game, 14.0f, 12.0f).floatValue(), this.game.viewHeight.floatValue() - this.textOverlay.getHeight() * 98.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue() - 220.0f, (float)this.time.longValue() / 1000.0f));
                this.textOverlay.addAction(scrolloverlay);
                this.nextButton = new Button(this.game.uiSkin, "next");
                this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
                this.nextButton.setHeight(this.nextButton.getWidth());
                this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
                this.nextButton.setY(10.0f);
                this.nextButton.addListener(new InputListener(){

                    @Override
                    public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                        return true;
                    }

                    @Override
                    public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                        Story.getNextScreen(LoreScreen.this.game, "event", "");
                        LoreScreen.this.dispose();
                    }
                });
                this.nextButton.setVisible(false);
                SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
                this.nextButton.addAction(showDelayed);
                this.stage.addActor(this.nextButton);
            }
            this.doFade("in", Float.valueOf(10.0f));
        }
    }

    private void renderByLoreId(float delta) {
        if (this.story.equalsIgnoreCase("lore.1")) {
            this.stage.act(delta);
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 771);
            this.stage.draw();
            this.stage.getViewport().apply();
            this.listFrameBuffer.get(0).begin();
            Gdx.gl.glClearColor(0.8f, 0.8f, 0.8f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 1);
            this.stage.getBatch().begin();
            this.listAnimatedActor.get(0).act(delta);
            this.listAnimatedActor.get(1).act(delta);
            this.listAnimatedActor.get(0).draw(this.stage.getBatch(), 1.0f);
            this.listAnimatedActor.get(1).draw(this.stage.getBatch(), 1.0f);
            this.stage.getBatch().end();
            this.listFrameBuffer.get(0).end(this.stage.getViewport().getScreenX(), this.stage.getViewport().getScreenY(), this.stage.getViewport().getScreenWidth(), this.stage.getViewport().getScreenHeight());
            this.stage.getBatch().setBlendFunction(774, 0);
            this.stage.getBatch().begin();
            this.stage.getBatch().draw((Texture)this.listFrameBuffer.get(0).getColorBufferTexture(), 0.0f, 0.0f, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f, 1.0f, 1.0f);
            this.stage.getBatch().end();
            this.stage.getViewport().apply();
        } else if (this.story.equalsIgnoreCase("lore.2") || this.story.equalsIgnoreCase("lore.3")) {
            this.stage.act(delta);
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 771);
            this.stage.draw();
            this.stage.getViewport().apply();
            this.listFrameBuffer.get(0).begin();
            Gdx.gl.glClearColor(0.8f, 0.8f, 0.8f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 1);
            this.stage.getBatch().begin();
            this.listAnimatedActor.get(0).act(delta);
            this.listAnimatedActor.get(0).draw(this.stage.getBatch(), 1.0f);
            this.stage.getBatch().end();
            this.listFrameBuffer.get(0).end(this.stage.getViewport().getScreenX(), this.stage.getViewport().getScreenY(), this.stage.getViewport().getScreenWidth(), this.stage.getViewport().getScreenHeight());
            this.stage.getBatch().setBlendFunction(774, 0);
            this.stage.getBatch().begin();
            this.stage.getBatch().draw((Texture)this.listFrameBuffer.get(0).getColorBufferTexture(), 0.0f, 0.0f, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f, 1.0f, 1.0f);
            this.stage.getBatch().end();
            this.stage.getViewport().apply();
        } else if (this.story.equalsIgnoreCase("lore.4")) {
            this.stage.act(delta);
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 771);
            this.listParticleEffectActor.get((int)0).pe.getEmitters().get(0).getTransparency().setHigh(MathUtils.clamp(this.timeElapsed / 10.0f, 0.0f, 1.0f));
            this.stage.draw();
            this.stage.getViewport().apply();
            this.listFrameBuffer.get(0).begin();
            Gdx.gl.glClearColor(0.8f, 0.8f, 0.8f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 1);
            this.stage.getBatch().begin();
            this.listAnimatedActor.get(0).act(delta);
            this.listAnimatedActor.get(0).draw(this.stage.getBatch(), 1.0f);
            this.stage.getBatch().end();
            this.listFrameBuffer.get(0).end(this.stage.getViewport().getScreenX(), this.stage.getViewport().getScreenY(), this.stage.getViewport().getScreenWidth(), this.stage.getViewport().getScreenHeight());
            this.stage.getBatch().setBlendFunction(774, 0);
            this.stage.getBatch().begin();
            this.stage.getBatch().draw((Texture)this.listFrameBuffer.get(0).getColorBufferTexture(), 0.0f, 0.0f, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f, 1.0f, 1.0f);
            this.stage.getBatch().end();
            this.stage.getViewport().apply();
        } else {
            this.stage.act(delta);
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.draw();
        }
    }
}

