/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.SelectBoxFontScaling;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.ArrayList;
import java.util.Collections;

public class LexiconScreen
extends BaseScreen {
    private BaseScreen previousScreen;
    private NinePatchActor termListBackground;
    private NinePatchActor descriptionBackground;
    private VerticalGroup termList;
    private ScrollPane termPane;
    private Button skipTermPane;
    private SelectBoxFontScaling<String> categories;
    private BaseActor termDescriptionImage;
    private Label termDescription;
    private ScrollPane descriptionPane;
    private Button skipDescriptionPane;
    private Label selectedEntry;

    public LexiconScreen(SlavePitsGame g, BaseScreen s) {
        super(g);
        this.previousScreen = s;
        this.create();
    }

    @Override
    public void create() {
        this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/constcombo.jpg"), Texture.class);
        this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/constparry.jpg"), Texture.class);
        this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/constrage.jpg"), Texture.class);
        this.game.manager.finishLoading();
        this.termListBackground = new NinePatchActor(this.game.uiSkin.get("scrollpanel-vertical", NinePatch.class));
        this.termListBackground.setWidth(UIHelpers.calcWidthProportion(this.game, 20.0f, 35.0f).floatValue());
        this.termListBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 80.0f, 89.0f).floatValue());
        this.termListBackground.setX(UIHelpers.calcWidthProportion(this.game, 10.0f, 1.0f).floatValue());
        this.termListBackground.setY(UIHelpers.calcHeightProportion(this.game, 15.0f, 10.0f).floatValue());
        this.stage.addActor(this.termListBackground);
        this.descriptionBackground = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.descriptionBackground.setWidth(UIHelpers.calcWidthProportion(this.game, 60.0f, 63.0f).floatValue());
        this.descriptionBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 80.0f, 89.0f).floatValue());
        this.descriptionBackground.setX(UIHelpers.calcWidthProportion(this.game, 30.0f, 36.0f).floatValue());
        this.descriptionBackground.setY(UIHelpers.calcHeightProportion(this.game, 15.0f, 10.0f).floatValue());
        this.stage.addActor(this.descriptionBackground);
        this.categories = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String[] availableCategories = new String[]{PropertiesReader.getMessage(this.game.gameMessages, "common.combat"), PropertiesReader.getMessage(this.game.gameMessages, "common.constellations"), PropertiesReader.getMessage(this.game.gameMessages, "common.effects"), PropertiesReader.getMessage(this.game.gameMessages, "common.general"), PropertiesReader.getMessage(this.game.gameMessages, "common.lore"), PropertiesReader.getMessage(this.game.gameMessages, "common.opponents")};
        this.categories.setItems((String[])availableCategories);
        this.categories.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "common.combat"));
        this.categories.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ArrayList<String> topicList = new ArrayList<String>();
                if (((String)LexiconScreen.this.categories.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.combat"))) {
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.attack"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.parry"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.dodge"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.chain"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.rispos"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.pressu"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.assault"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.life"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.stamin"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.balanc"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.vulnerablespot"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.hit"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.scenario"));
                    Collections.sort(topicList);
                } else if (((String)LexiconScreen.this.categories.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.constellations"))) {
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.constellation"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.constellation.combo"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.constellation.parry"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.constellation.rage"));
                    Collections.sort(topicList);
                } else if (((String)LexiconScreen.this.categories.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.general"))) {
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.combo"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.factions"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.reputation"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.phase"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.profits"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.services"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.surge"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.talent"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.weapons"));
                    Collections.sort(topicList);
                } else if (((String)LexiconScreen.this.categories.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.effects"))) {
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.buff.frenzy"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.buff.rage"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.buff.ready"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.buff.charge"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.buff.adrena"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.debuff.stun"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.debuff.bleed"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.debuff.exhaus"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.debuff.weaken"));
                    Collections.sort(topicList);
                } else if (((String)LexiconScreen.this.categories.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.lore"))) {
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.lore.cabal"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.lore.calima"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.lore.crafters"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.lore.trueworshippers"));
                    topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.lore.worshippers"));
                } else if (((String)LexiconScreen.this.categories.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "common.opponents"))) {
                    if (LexiconScreen.this.game.achievements.get("adam") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.adam.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("ayla") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.ayla.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("boris") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.boris.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("diego") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.diego.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("emma") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.emma.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("fenris") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.fenris.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("lea") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.lea.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("min") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.min.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("onur") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.onur.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("ponte") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.ponte.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("roe") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.roe.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("randombandit") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.randombandit.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("randomcrafter") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.randomcrafter.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("randommercenary") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.randommercenary.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("randomnoble") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.randomnoble.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("randomslave") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.randomslave.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("randomworshipper") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.randomworshipper.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("scala") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.scala.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("tara") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.tara.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("trent") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.trent.name"));
                    }
                    if (LexiconScreen.this.game.achievements.get("luntian") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.zola.luntian"));
                    }
                    if (LexiconScreen.this.game.achievements.get("blaire") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.zola.blaire"));
                    }
                    if (LexiconScreen.this.game.achievements.get("nattfrid") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.zola.nattfrid"));
                    }
                    if (LexiconScreen.this.game.achievements.get("sarah") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.zola.sarah"));
                    }
                    if (LexiconScreen.this.game.achievements.get("rishi") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.zola.rishi"));
                    }
                    if (LexiconScreen.this.game.achievements.get("bastien") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.zola.bastien"));
                    }
                    if (LexiconScreen.this.game.achievements.get("san") != null) {
                        topicList.add(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, "talk.zola.san"));
                    }
                    Collections.sort(topicList);
                }
                LexiconScreen.this.termList.clearChildren();
                float sizeControl = 1.0f;
                for (String currTopic : topicList) {
                    Label newTerm = new Label(currTopic, LexiconScreen.this.game.uiSkin, "default");
                    newTerm.setAlignment(10);
                    newTerm.setColor(LexiconScreen.this.game.uiSkin.get("silver", Color.class));
                    newTerm.addListener(new InputListener(){

                        @Override
                        public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                            Label actor = (Label)event.getListenerActor();
                            if (actor != LexiconScreen.this.selectedEntry) {
                                actor.setColor(LexiconScreen.this.game.uiSkin.get("silver", Color.class));
                            }
                        }

                        @Override
                        public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                            Label actor = (Label)event.getListenerActor();
                            if (actor != LexiconScreen.this.selectedEntry) {
                                actor.setColor(LexiconScreen.this.game.uiSkin.get("lightiron", Color.class));
                            }
                        }

                        @Override
                        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                            return true;
                        }

                        @Override
                        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                            Label actor = (Label)event.getListenerActor();
                            if (LexiconScreen.this.selectedEntry != null) {
                                LexiconScreen.this.selectedEntry.setColor(LexiconScreen.this.game.uiSkin.get("silver", Color.class));
                            }
                            LexiconScreen.this.selectedEntry = actor;
                            LexiconScreen.this.selectedEntry.setColor(LexiconScreen.this.game.uiSkin.get("lightiron", Color.class));
                            String realKey = "";
                            for (String currKey : LexiconScreen.this.game.gameMessages.stringPropertyNames()) {
                                if (currKey.startsWith("common.") && PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, currKey).equalsIgnoreCase(LexiconScreen.this.selectedEntry.getText().toString())) {
                                    realKey = currKey.replace("common", "lexicon");
                                    LexiconScreen.this.termDescription.setText(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, realKey, LexiconScreen.this.game.violenceFilter));
                                    break;
                                }
                                if (!currKey.startsWith("talk.") || !PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, currKey).equalsIgnoreCase(LexiconScreen.this.selectedEntry.getText().toString())) continue;
                                realKey = currKey.replace(".name", ".info");
                                LexiconScreen.this.termDescription.setText(PropertiesReader.getMessage(LexiconScreen.this.game.gameMessages, realKey, LexiconScreen.this.game.violenceFilter));
                                break;
                            }
                            float maxHeight = LexiconScreen.this.descriptionBackground.getHeight() - 34.0f - 26.0f;
                            if (realKey.startsWith("lexicon.constellation.")) {
                                LexiconScreen.this.termDescriptionImage.setTexture(LexiconScreen.this.game.manager.get(LexiconScreen.this.game.getOverridenAsset("data/backgrounds/const" + realKey.substring(22) + ".jpg"), Texture.class), LexiconScreen.this.descriptionBackground.getWidth() * (float)(LexiconScreen.this.game.portraitmode ? 100 : 75) / 100.0f - 68.0f, LexiconScreen.this.descriptionBackground.getWidth() * (float)(LexiconScreen.this.game.portraitmode ? 100 : 75) / 100.0f - 68.0f);
                                LexiconScreen.this.termDescriptionImage.setVisible(true);
                                maxHeight = maxHeight - LexiconScreen.this.termDescriptionImage.getHeight() - 10.0f;
                            } else {
                                LexiconScreen.this.termDescriptionImage.setVisible(false);
                            }
                            if (LexiconScreen.this.termDescription.getPrefHeight() > maxHeight) {
                                LexiconScreen.this.descriptionPane.setHeight(maxHeight);
                                LexiconScreen.this.skipDescriptionPane.setVisible(true);
                            } else {
                                LexiconScreen.this.descriptionPane.setHeight(LexiconScreen.this.termDescription.getPrefHeight());
                                LexiconScreen.this.skipDescriptionPane.setVisible(false);
                            }
                            LexiconScreen.this.descriptionPane.layout();
                            LexiconScreen.this.descriptionPane.setY(LexiconScreen.this.descriptionBackground.getY() + LexiconScreen.this.descriptionBackground.getHeight() - 34.0f - LexiconScreen.this.descriptionPane.getHeight() - (LexiconScreen.this.termDescriptionImage.isVisible() ? LexiconScreen.this.termDescriptionImage.getHeight() + 10.0f : 0.0f));
                            LexiconScreen.this.descriptionPane.setScrollY(0.0f);
                        }
                    });
                    newTerm.setFontScale(LexiconScreen.this.game.viewHeight.floatValue() / LexiconScreen.this.game.heightBASE.floatValue());
                    while (newTerm.getPrefWidth() * sizeControl >= LexiconScreen.this.termList.getWidth()) {
                        sizeControl -= 0.05f;
                    }
                    LexiconScreen.this.termList.addActor(newTerm);
                }
                for (Actor currLabel : LexiconScreen.this.termList.getChildren()) {
                    ((Label)currLabel).setFontScale(LexiconScreen.this.game.viewHeight.floatValue() / LexiconScreen.this.game.heightBASE.floatValue() * sizeControl);
                }
                LexiconScreen.this.termList.invalidate();
                LexiconScreen.this.termList.setHeight(LexiconScreen.this.termList.getPrefHeight());
                float maxHeight = LexiconScreen.this.termListBackground.getHeight() - 50.0f - LexiconScreen.this.categories.getPrefHeight() - UIHelpers.calcHeightProportion(LexiconScreen.this.game, 2.0f, 2.0f).floatValue() - 38.0f;
                if (LexiconScreen.this.termList.getHeight() > maxHeight) {
                    LexiconScreen.this.termPane.setHeight(maxHeight);
                    LexiconScreen.this.skipTermPane.setVisible(true);
                } else {
                    LexiconScreen.this.termPane.setHeight(LexiconScreen.this.termList.getHeight());
                    LexiconScreen.this.skipTermPane.setVisible(false);
                }
                LexiconScreen.this.termPane.layout();
                LexiconScreen.this.termPane.setY(LexiconScreen.this.categories.getY() - UIHelpers.calcHeightProportion(LexiconScreen.this.game, 2.0f, 2.0f).floatValue() - LexiconScreen.this.termPane.getHeight());
                LexiconScreen.this.termPane.setScrollY(0.0f);
            }
        });
        this.categories.setX(this.termListBackground.getX() + this.termListBackground.getWidth() / 2.0f - this.categories.getWidth() / 2.0f);
        this.categories.setY(this.termListBackground.getY() + this.termListBackground.getHeight() - 50.0f - this.categories.getPrefHeight());
        this.stage.addActor(this.categories);
        this.termList = new VerticalGroup();
        this.termList.setWidth(UIHelpers.calcWidthProportion(this.game, 15.0f, 30.0f).floatValue());
        this.termPane = new ScrollPane((Actor)this.termList);
        this.termPane.addListener(new InputListener(){

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                LexiconScreen.this.stage.setScrollFocus(null);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                LexiconScreen.this.stage.setScrollFocus(event.getListenerActor());
            }
        });
        this.termPane.setForceScroll(false, true);
        this.termPane.setFlickScroll(false);
        this.termPane.setOverscroll(false, true);
        this.termPane.setWidth(this.termList.getWidth());
        this.termPane.setX(this.termListBackground.getX() + this.termListBackground.getWidth() / 2.0f - this.termPane.getWidth() / 2.0f);
        this.stage.addActor(this.termPane);
        this.skipTermPane = new Button(this.game.uiSkin, "skip");
        this.skipTermPane.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                LexiconScreen.this.termPane.scrollTo(0.0f, 0.0f, 0.0f, 0.0f);
            }
        });
        this.skipTermPane.setVisible(false);
        this.skipTermPane.setWidth(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.skipTermPane.setHeight(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.skipTermPane.setTransform(true);
        this.skipTermPane.rotateBy(270.0f);
        this.skipTermPane.setOrigin(this.skipTermPane.getWidth() / 2.0f, this.skipTermPane.getHeight() / 2.0f);
        this.skipTermPane.setX(this.termListBackground.getX() + this.termListBackground.getWidth() - this.skipTermPane.getWidth() * 110.0f / 100.0f);
        this.skipTermPane.setY(this.termListBackground.getY() + this.skipTermPane.getHeight() * 10.0f / 100.0f);
        this.stage.addActor(this.skipTermPane);
        this.termDescriptionImage = new BaseActor();
        this.termDescriptionImage.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), this.descriptionBackground.getWidth() * (float)(this.game.portraitmode ? 100 : 75) / 100.0f - 68.0f, this.descriptionBackground.getWidth() * (float)(this.game.portraitmode ? 100 : 75) / 100.0f - 68.0f);
        this.termDescriptionImage.setX(this.descriptionBackground.getX() + this.descriptionBackground.getWidth() / 2.0f - this.termDescriptionImage.getWidth() / 2.0f);
        this.termDescriptionImage.setY(this.descriptionBackground.getY() + this.descriptionBackground.getHeight() - 34.0f - this.termDescriptionImage.getHeight());
        this.termDescriptionImage.setVisible(false);
        this.stage.addActor(this.termDescriptionImage);
        this.termDescription = new Label(PropertiesReader.getMessage(this.game.gameMessages, "lexicon.intro"), this.game.uiSkin, "default");
        this.termDescription.setAlignment(10);
        this.termDescription.setColor(this.game.uiSkin.get("silver", Color.class));
        this.termDescription.setWrap(true);
        this.termDescription.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.termDescription.setWidth(this.descriptionBackground.getWidth() - 68.0f);
        this.stage.addActor(this.termDescription);
        this.descriptionPane = new ScrollPane((Actor)this.termDescription);
        this.descriptionPane.addListener(new InputListener(){

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                LexiconScreen.this.stage.setScrollFocus(null);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                LexiconScreen.this.stage.setScrollFocus(event.getListenerActor());
            }
        });
        this.descriptionPane.setForceScroll(false, true);
        this.descriptionPane.setFlickScroll(false);
        this.descriptionPane.setOverscroll(false, true);
        this.descriptionPane.setWidth(this.termDescription.getWidth());
        this.descriptionPane.setX(this.descriptionBackground.getX() + 34.0f);
        this.descriptionPane.setHeight(this.termDescription.getPrefHeight());
        this.descriptionPane.layout();
        this.descriptionPane.setY(this.descriptionBackground.getY() + this.descriptionBackground.getHeight() - 34.0f - this.descriptionPane.getHeight());
        this.descriptionPane.setScrollY(0.0f);
        if (this.game.portraitmode) {
            this.descriptionPane.addListener(new DragListener(){

                @Override
                public void drag(InputEvent event, float x, float y, int pointer) {
                    super.drag(event, x, y, pointer);
                    LexiconScreen.this.descriptionPane.setScrollY(LexiconScreen.this.descriptionPane.getScrollY() + (float)((int)this.getDeltaY()));
                }
            });
        } else {
            this.descriptionPane.addListener(new InputListener(){

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                    LexiconScreen.this.stage.setScrollFocus(null);
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    LexiconScreen.this.stage.setScrollFocus(event.getListenerActor());
                }
            });
        }
        this.stage.addActor(this.descriptionPane);
        this.skipDescriptionPane = new Button(this.game.uiSkin, "skip");
        this.skipDescriptionPane.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                LexiconScreen.this.descriptionPane.scrollTo(0.0f, 0.0f, 0.0f, 0.0f);
            }
        });
        this.skipDescriptionPane.setVisible(false);
        this.skipDescriptionPane.setWidth(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.skipDescriptionPane.setHeight(UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.skipDescriptionPane.setTransform(true);
        this.skipDescriptionPane.rotateBy(270.0f);
        this.skipDescriptionPane.setOrigin(this.skipDescriptionPane.getWidth() / 2.0f, this.skipDescriptionPane.getHeight() / 2.0f);
        this.skipDescriptionPane.setX(this.descriptionBackground.getX() + this.descriptionBackground.getWidth() - this.skipDescriptionPane.getWidth() * 150.0f / 100.0f);
        this.skipDescriptionPane.setY(this.descriptionBackground.getY() + this.skipDescriptionPane.getHeight() * 50.0f / 100.0f);
        this.stage.addActor(this.skipDescriptionPane);
        TextButton exitButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "common.exit"), this.game.uiSkin, "base");
        exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                LexiconScreen.this.game.setScreen(LexiconScreen.this.previousScreen);
                LexiconScreen.this.dispose();
            }
        });
        exitButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        exitButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        exitButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), exitButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - exitButton.getPrefWidth() / 2.0f);
        exitButton.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 1.0f).floatValue());
        this.stage.addActor(exitButton);
    }

    @Override
    public void render(float delta) {
        this.game.manager.update();
        this.stage.act(delta);
        if (!this.termList.hasChildren()) {
            this.categories.fire(new ChangeListener.ChangeEvent());
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == Input.Keys.valueOf(this.game.nextkey)) {
            this.game.setScreen(this.previousScreen);
            this.dispose();
        }
        return false;
    }

    @Override
    public void dispose() {
        this.game.manager.unload(this.game.getOverridenAsset("data/backgrounds/constcombo.jpg"));
        this.game.manager.unload(this.game.getOverridenAsset("data/backgrounds/constparry.jpg"));
        this.game.manager.unload(this.game.getOverridenAsset("data/backgrounds/constrage.jpg"));
    }
}

