/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.RepeatAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.SelectBoxFontScaling;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Equipment;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.DuelSetupScreen;
import com.calimasaga.slavepits.screen.PrepSetupScreen;
import com.calimasaga.slavepits.screen.TournamentGameScreen;
import com.calimasaga.slavepits.screen.TournamentSetupScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import com.calimasaga.slavepits.util.StringList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class EquipmentMenuScreen
extends BaseScreen {
    private BaseScreen previousScreen;
    public Fighter fighter;
    public HashMap<String, Integer> stocksOrig;
    public int tierBonus = 0;
    public String fighterType;
    public int maxReputation;
    public int tierNumberArmor;
    public int tierNumberWeapon;
    private NinePatchActor charBackground;
    private NinePatchActor iconListBackground;
    private NinePatchActor itemBackground;
    public NinePatchActor statsBackground;
    private BaseActor charHelmet;
    private BaseActor charBracers;
    private BaseActor charArmor;
    private BaseActor charWeapon;
    private BaseActor charOffHand;
    private Button aspect;
    private Label lBodyType;
    private SelectBoxFontScaling<String> bodyType;
    private Label lBodySubType;
    private SelectBoxFontScaling<String> bodySubType;
    private Label lArmsType;
    private SelectBoxFontScaling<String> armsType;
    private Label lAccessories;
    private ArrayList<Button> accessoryList;
    private Button skinColor;
    private Button bodyColor;
    private Button accessoryColor;
    public Stack fighterCharacter;
    public BaseActor fighterBody;
    public BaseActor fighterBodyExtra;
    public BaseActor fighterBodyArmorL;
    public BaseActor fighterBodyArmorT;
    public BaseActor fighterBodyArmorTExtra;
    public BaseActor fighterSkin;
    public BaseActor fighterSkinExtra;
    public BaseActor fighterHead;
    public ArrayList<BaseActor> fighterAccessories;
    public BaseActor fighterArms;
    public BaseActor fighterArmsArmorSL;
    public BaseActor fighterArmsArmorBRL;
    public BaseActor fighterArmsArmorBRR;
    public BaseActor fighterArmsArmorSPL;
    public BaseActor fighterArmsArmorSPR;
    public BaseActor fighterWeapon;
    public BaseActor fighterOffHand;
    public boolean redrawFighter = false;
    public WidgetGroup itemList;
    public ScrollPane itemPane;
    public ArrayList<BaseActor> availableItems = new ArrayList();
    public HashMap<String, ArrayList<Float>> weaponStats = new HashMap();
    public ArrayList<BaseActor> statsBars = new ArrayList();
    public BaseActor selectedItem;
    public Label selectedItemName;
    public Label selectedItemTier;
    public Label itemInfo;
    public Button equipItem;
    public NinePatchActor pickColorFrame;
    public BaseActor pickColor;
    public Button exitColorButton;
    private Vector2 touchPos = new Vector2();
    private Button applyButton;
    private Button exitButton;

    public EquipmentMenuScreen(SlavePitsGame g, BaseScreen s, Fighter selectedFighter, String type, int reputationLimit) {
        super(g);
        this.previousScreen = s;
        this.fighter = Fighter.clone(selectedFighter, true);
        if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            this.stocksOrig = Tournament.getWeaponsAvailable(this.game);
        }
        this.tierBonus = this.game.gameMode.equalsIgnoreCase("tournament") && this.game.saveGame.get("rewards").contains("crafts") ? Tournament.getRewardStock(this.game, "crafts") : 0;
        this.fighterType = type;
        this.maxReputation = reputationLimit;
        this.tierNumberArmor = Fighter.getMaxTierNumber(this.fighter, "armor");
        this.tierNumberWeapon = Fighter.getMaxTierNumber(this.fighter, "weapon");
        this.redrawFighter = true;
        this.create();
    }

    @Override
    public void create() {
        String image;
        float iconSize = UIHelpers.calcHeightProportion(this.game, 10.0f, 8.0f).floatValue();
        this.charBackground = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.itemBackground = new NinePatchActor(this.game.uiSkin.get("scrollpanel", NinePatch.class));
        if (this.game.portraitmode) {
            this.iconListBackground = new NinePatchActor(this.game.uiSkin.get("scrollpanel", NinePatch.class));
            this.iconListBackground.setHeight(iconSize * 160.0f / 100.0f);
            this.charBackground.setWidth(MathUtils.clamp(UIHelpers.calcWidthProportion(this.game, 98.0f, 98.0f).floatValue(), this.iconListBackground.getHeight() * 3.0f, (UIHelpers.calcHeightProportion(this.game, 89.0f, 89.0f).floatValue() - this.iconListBackground.getHeight()) * 2.0f / 3.0f));
            this.charBackground.setHeight(this.charBackground.getWidth());
            this.charBackground.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.charBackground.getWidth() / 2.0f);
            this.charBackground.setY(UIHelpers.calcHeightProportion(this.game, 99.0f, 99.0f).floatValue() - this.charBackground.getHeight());
            this.iconListBackground.setWidth(UIHelpers.calcWidthProportion(this.game, 98.0f, 98.0f).floatValue());
            this.iconListBackground.setX(UIHelpers.calcWidthProportion(this.game, 1.0f, 1.0f).floatValue());
            this.iconListBackground.setY(this.charBackground.getY() - this.iconListBackground.getHeight());
            this.itemBackground.setWidth(UIHelpers.calcWidthProportion(this.game, 98.0f, 98.0f).floatValue());
            this.itemBackground.setHeight(this.charBackground.getHeight() / 2.0f);
            this.itemBackground.setX(UIHelpers.calcWidthProportion(this.game, 1.0f, 1.0f).floatValue());
            this.itemBackground.setY(this.iconListBackground.getY() - this.itemBackground.getHeight());
            this.itemList = new HorizontalGroup();
            ((HorizontalGroup)this.itemList).space(iconSize * 10.0f / 100.0f);
            this.itemList.setHeight(iconSize * 120.0f / 100.0f);
            this.itemPane = new ScrollPane((Actor)this.itemList);
            this.itemPane.setHeight(this.itemList.getHeight());
            this.itemPane.setY(this.iconListBackground.getY() + this.iconListBackground.getHeight() / 2.0f - this.itemPane.getHeight() / 2.0f);
        } else {
            this.iconListBackground = new NinePatchActor(this.game.uiSkin.get("scrollpanel-vertical", NinePatch.class));
            this.iconListBackground.setWidth(iconSize * 160.0f / 100.0f);
            this.charBackground.setWidth(MathUtils.clamp(UIHelpers.calcWidthProportion(this.game, 98.0f, 98.0f).floatValue() - this.iconListBackground.getWidth(), this.iconListBackground.getWidth() * 3.0f, UIHelpers.calcHeightProportion(this.game, 53.0f, 53.0f).floatValue()));
            this.charBackground.setHeight(this.charBackground.getWidth());
            this.charBackground.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.charBackground.getWidth() / 2.0f - this.iconListBackground.getWidth() / 2.0f);
            this.charBackground.setY(UIHelpers.calcHeightProportion(this.game, 95.0f, 95.0f).floatValue() - this.charBackground.getHeight());
            this.iconListBackground.setHeight(this.charBackground.getHeight());
            this.iconListBackground.setX(this.charBackground.getX() + this.charBackground.getWidth());
            this.iconListBackground.setY(this.charBackground.getY());
            this.itemBackground.setWidth(this.charBackground.getWidth() + this.iconListBackground.getWidth());
            this.itemBackground.setHeight(this.charBackground.getHeight() / 2.0f);
            this.itemBackground.setX(this.charBackground.getX());
            this.itemBackground.setY(this.charBackground.getY() - this.itemBackground.getHeight());
            this.itemList = new VerticalGroup();
            ((VerticalGroup)this.itemList).space(iconSize * 10.0f / 100.0f);
            this.itemList.setWidth(iconSize * 120.0f / 100.0f);
            this.itemPane = new ScrollPane((Actor)this.itemList);
            this.itemPane.setWidth(this.itemList.getWidth());
            this.itemPane.setX(this.iconListBackground.getX() + this.iconListBackground.getWidth() / 2.0f - this.itemPane.getWidth() / 2.0f);
        }
        if (this.game.portraitmode) {
            this.itemPane.addListener(new DragListener(){

                @Override
                public void drag(InputEvent event, float x, float y, int pointer) {
                    super.drag(event, x, y, pointer);
                    EquipmentMenuScreen.this.itemPane.setScrollX(EquipmentMenuScreen.this.itemPane.getScrollX() - (float)((int)this.getDeltaX()));
                }
            });
        } else {
            this.itemPane.addListener(new InputListener(){

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                    EquipmentMenuScreen.this.stage.setScrollFocus(null);
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    EquipmentMenuScreen.this.stage.setScrollFocus(event.getListenerActor());
                }
            });
        }
        this.itemPane.setForceScroll(this.game.portraitmode, !this.game.portraitmode);
        this.itemPane.setFlickScroll(false);
        this.itemPane.setOverscroll(this.game.portraitmode, !this.game.portraitmode);
        this.stage.addActor(this.charBackground);
        this.stage.addActor(this.iconListBackground);
        this.stage.addActor(this.itemBackground);
        this.stage.addActor(this.itemPane);
        this.fighterCharacter = new Stack();
        this.fighterCharacter.sizeBy(this.charBackground.getHeight() * 80.0f / 100.0f, this.charBackground.getHeight() * 80.0f / 100.0f);
        this.fighterCharacter.setX(this.charBackground.getX() + this.charBackground.getWidth() * 45.0f / 100.0f - this.fighterCharacter.getWidth() / 2.0f);
        this.fighterCharacter.setY(this.charBackground.getY() + this.charBackground.getHeight() * 5.0f / 100.0f);
        this.fighterSkin = new BaseActor();
        this.fighterCharacter.add(this.fighterSkin);
        this.fighterBody = new BaseActor();
        this.fighterCharacter.add(this.fighterBody);
        this.fighterBodyArmorL = new BaseActor();
        this.fighterCharacter.add(this.fighterBodyArmorL);
        this.fighterBodyArmorT = new BaseActor();
        this.fighterCharacter.add(this.fighterBodyArmorT);
        this.fighterAccessories = new ArrayList();
        for (int i = 0; i < 15; ++i) {
            BaseActor accessory = new BaseActor();
            accessory.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterAccessories.add(accessory);
            this.fighterCharacter.add(accessory);
        }
        this.fighterHead = new BaseActor();
        this.fighterCharacter.add(this.fighterHead);
        this.fighterArms = new BaseActor();
        this.fighterCharacter.add(this.fighterArms);
        this.fighterArmsArmorSL = new BaseActor();
        this.fighterCharacter.add(this.fighterArmsArmorSL);
        this.fighterArmsArmorSPL = new BaseActor();
        this.fighterCharacter.add(this.fighterArmsArmorSPL);
        this.fighterArmsArmorSPR = new BaseActor();
        this.fighterCharacter.add(this.fighterArmsArmorSPR);
        this.fighterArmsArmorBRL = new BaseActor();
        this.fighterCharacter.add(this.fighterArmsArmorBRL);
        this.fighterArmsArmorBRR = new BaseActor();
        this.fighterCharacter.add(this.fighterArmsArmorBRR);
        this.fighterSkinExtra = new BaseActor();
        this.fighterCharacter.add(this.fighterSkinExtra);
        this.fighterBodyExtra = new BaseActor();
        this.fighterCharacter.add(this.fighterBodyExtra);
        this.fighterBodyArmorTExtra = new BaseActor();
        this.fighterCharacter.add(this.fighterBodyArmorTExtra);
        this.fighterWeapon = new BaseActor();
        this.fighterCharacter.add(this.fighterWeapon);
        this.fighterOffHand = new BaseActor();
        this.fighterCharacter.add(this.fighterOffHand);
        this.fighterCharacter.setTransform(true);
        this.stage.addActor(this.fighterCharacter);
        TextureAtlas equipmentAtlas = this.game.manager.get(this.game.getOverridenAsset("data/equipment/equipment.atlas"), TextureAtlas.class);
        this.charHelmet = new BaseActor();
        if (this.fighter.head != null) {
            image = ((JSONObject)this.game.stats.get("armors").get(this.fighter.head.id)).getString("imagePrefix") + this.game.stats.get("tiers").getJSONObject(this.fighter.head.tier).getString("imageSuffix");
            this.charHelmet.setTexture(equipmentAtlas.findRegion(image), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        } else {
            this.charHelmet.setTexture(equipmentAtlas.findRegion("empty"), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        }
        this.charHelmet.setX(this.charBackground.getX() + this.charBackground.getWidth() * 10.0f / 100.0f);
        this.charHelmet.setY(this.charBackground.getY() + this.charBackground.getHeight() * 72.0f / 100.0f);
        this.charHelmet.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                EquipmentMenuScreen.this.generateItemList("helmet");
            }
        });
        this.stage.addActor(this.charHelmet);
        this.charBracers = new BaseActor();
        if (this.fighter.arms != null) {
            image = ((JSONObject)this.game.stats.get("armors").get(this.fighter.arms.id)).getString("imagePrefix") + this.game.stats.get("tiers").getJSONObject(this.fighter.arms.tier).getString("imageSuffix");
            this.charBracers.setTexture(equipmentAtlas.findRegion(image), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        } else {
            this.charBracers.setTexture(equipmentAtlas.findRegion("empty"), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        }
        this.charBracers.setX(this.charBackground.getX() + this.charBackground.getWidth() * 72.0f / 100.0f);
        this.charBracers.setY(this.charBackground.getY() + this.charBackground.getHeight() * 60.0f / 100.0f);
        this.charBracers.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                EquipmentMenuScreen.this.generateItemList("bracers");
            }
        });
        this.stage.addActor(this.charBracers);
        if (PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum).equalsIgnoreCase("extra")) {
            this.aspect = new Button(this.game.uiSkin, "aspect");
            this.aspect.setWidth(MathUtils.clamp(iconSize / 2.0f, 50.0f, 100.0f));
            this.aspect.setHeight(this.aspect.getWidth());
            this.aspect.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    EquipmentMenuScreen.this.generateAspectMenu();
                }
            });
            this.aspect.setX(this.charBackground.getX() + this.charBackground.getWidth() * 55.0f / 100.0f - this.aspect.getWidth() / 2.0f);
            this.aspect.setY(this.charBackground.getY() + this.charBackground.getHeight() * 5.0f / 100.0f);
            if (this.game.gameMode.equalsIgnoreCase("story")) {
                this.aspect.setVisible(false);
            }
            this.stage.addActor(this.aspect);
        }
        this.charArmor = new BaseActor();
        if (this.fighter.body != null) {
            image = ((JSONObject)this.game.stats.get("armors").get(this.fighter.body.id)).getString("imagePrefix") + this.game.stats.get("tiers").getJSONObject(this.fighter.body.tier).getString("imageSuffix");
            this.charArmor.setTexture(equipmentAtlas.findRegion(image), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        } else {
            this.charArmor.setTexture(equipmentAtlas.findRegion("empty"), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        }
        this.charArmor.setX(this.charBackground.getX() + this.charBackground.getWidth() * 72.0f / 100.0f);
        this.charArmor.setY(this.charBackground.getY() + this.charBackground.getHeight() * 35.0f / 100.0f);
        this.charArmor.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                EquipmentMenuScreen.this.generateItemList("armor");
            }
        });
        this.stage.addActor(this.charArmor);
        this.charWeapon = new BaseActor();
        if (this.fighter.weapon != null) {
            image = ((JSONObject)this.game.stats.get("weapons").get(this.fighter.weapon.id)).getString("imagePrefix") + this.game.stats.get("tiers").getJSONObject(this.fighter.weapon.tier).getString("imageSuffix");
            this.charWeapon.setTexture(equipmentAtlas.findRegion(image), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        } else {
            this.charWeapon.setTexture(equipmentAtlas.findRegion("empty"), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        }
        this.charWeapon.setX(this.charBackground.getX() + this.charBackground.getWidth() * 10.0f / 100.0f);
        this.charWeapon.setY(this.charBackground.getY() + this.charBackground.getHeight() * 10.0f / 100.0f);
        if (this.game.saveGame == null || this.game.saveGame.get("special") == null || !this.game.saveGame.get("special").contains("bet-weapon") && !this.game.saveGame.get("special").contains("quest11") && !this.game.saveGame.get("special").contains("quest12")) {
            this.charWeapon.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    EquipmentMenuScreen.this.generateItemList("weapons");
                }
            });
        }
        this.stage.addActor(this.charWeapon);
        this.charOffHand = new BaseActor();
        if (this.fighter.offHand != null) {
            image = ((JSONObject)this.game.stats.get("weapons").get(this.fighter.offHand.id)).getString("imagePrefix") + this.game.stats.get("tiers").getJSONObject(this.fighter.offHand.tier).getString("imageSuffix");
            this.charOffHand.setTexture(equipmentAtlas.findRegion(image), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        } else {
            this.charOffHand.setTexture(equipmentAtlas.findRegion("empty"), (float)Float.valueOf(iconSize).intValue(), (float)Float.valueOf(iconSize).intValue());
        }
        this.charOffHand.setX(this.charBackground.getX() + this.charBackground.getWidth() * 72.0f / 100.0f);
        this.charOffHand.setY(this.charBackground.getY() + this.charBackground.getHeight() * 10.0f / 100.0f);
        if (this.game.saveGame == null || this.game.saveGame.get("special") == null || !this.game.saveGame.get("special").contains("bet-weapon") && !this.game.saveGame.get("special").contains("quest11") && !this.game.saveGame.get("special").contains("quest12")) {
            this.charOffHand.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    EquipmentMenuScreen.this.generateItemList("offhand");
                }
            });
        }
        this.stage.addActor(this.charOffHand);
        this.selectedItem = new BaseActor();
        this.selectedItem.setTexture(equipmentAtlas.findRegion("empty"), (float)Float.valueOf(this.game.portraitmode ? iconSize : iconSize * 4.0f / 5.0f).intValue(), (float)Float.valueOf(this.game.portraitmode ? iconSize : iconSize * 4.0f / 5.0f).intValue());
        this.selectedItem.setX(this.itemBackground.getX() + UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        this.selectedItem.setY(this.itemBackground.getY() + this.itemBackground.getHeight() - this.selectedItem.getHeight() - UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.selectedItem.setVisible(false);
        this.stage.addActor(this.selectedItem);
        this.selectedItemName = new Label("Weapon", this.game.uiSkin, "default");
        this.selectedItemName.setAlignment(1);
        this.selectedItemName.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.selectedItemName.setVisible(false);
        this.selectedItemName.setWidth(this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(this.game, 3.0f, 4.0f).floatValue());
        this.selectedItemName.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.selectedItemName.setX(this.selectedItem.getX() - UIHelpers.calcHeightProportion(this.game, 1.5f, 2.0f).floatValue());
        this.selectedItemName.setY(this.selectedItem.getY() - UIHelpers.calcHeightProportion(this.game, 1.5f, 1.5f).floatValue() - this.selectedItemName.getPrefHeight());
        this.stage.addActor(this.selectedItemName);
        this.selectedItemTier = new Label("Tier: wood", this.game.uiSkin, "default");
        this.selectedItemTier.setAlignment(1);
        this.selectedItemTier.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.selectedItemTier.setVisible(false);
        this.selectedItemTier.setWidth(this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(this.game, 3.0f, 4.0f).floatValue());
        this.selectedItemTier.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.selectedItemTier.setX(this.selectedItem.getX() - UIHelpers.calcHeightProportion(this.game, 1.5f, 2.0f).floatValue());
        this.selectedItemTier.setY(this.selectedItemName.getY() - UIHelpers.calcHeightProportion(this.game, 1.5f, 1.5f).floatValue() - this.selectedItemTier.getPrefHeight());
        this.stage.addActor(this.selectedItemTier);
        this.itemInfo = new Label("", this.game.uiSkin, "default");
        this.itemInfo.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 5.0f / 4.0f));
        this.itemInfo.setAlignment(10);
        this.itemInfo.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.itemInfo.setWrap(true);
        this.itemInfo.setWidth(this.itemBackground.getWidth() - UIHelpers.calcHeightProportion(this.game, 22.0f, 22.0f).floatValue());
        this.itemInfo.setX(MathUtils.clamp(this.selectedItemName.getX() + this.selectedItemName.getPrefWidth(), this.selectedItem.getX() + this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue(), this.itemBackground.getX() + this.itemBackground.getWidth()));
        this.itemInfo.setVisible(false);
        this.stage.addActor(this.itemInfo);
        this.statsBackground = new NinePatchActor(this.game.uiSkin.get("statspane", NinePatch.class));
        this.statsBackground.setVisible(false);
        this.stage.addActor(this.statsBackground);
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        for (int i = 0; i < 6; ++i) {
            BaseActor newBar = new BaseActor();
            newBar.setTexture(uiAtlas.findRegion("stat"), 10.0f, 10.0f);
            newBar.setVisible(false);
            this.stage.addActor(newBar);
            this.statsBars.add(newBar);
        }
        this.equipItem = new Button(this.game.uiSkin, "equipmentmenu");
        this.equipItem.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                String image;
                Fighter.unloadFighterAssets(EquipmentMenuScreen.this.game, EquipmentMenuScreen.this.fighter, true, true);
                TextureAtlas equipmentAtlas = EquipmentMenuScreen.this.game.manager.get(EquipmentMenuScreen.this.game.getOverridenAsset("data/equipment/equipment.atlas"), TextureAtlas.class);
                String itemId = (String)EquipmentMenuScreen.this.selectedItem.params.get("id");
                String itemType = (String)EquipmentMenuScreen.this.selectedItem.params.get("type");
                String itemTier = (String)EquipmentMenuScreen.this.selectedItem.params.get("tier");
                if (EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && (!itemId.equalsIgnoreCase("empty") && !itemType.equalsIgnoreCase("offhand") || itemId.equalsIgnoreCase("shield"))) {
                    EquipmentMenuScreen.this.stocksOrig.put(itemId, EquipmentMenuScreen.this.stocksOrig.get(itemId) - 1);
                }
                if (itemType.equalsIgnoreCase("offhand")) {
                    if (EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && EquipmentMenuScreen.this.fighter.offHand != null && EquipmentMenuScreen.this.fighter.offHand.id.equalsIgnoreCase("shield")) {
                        EquipmentMenuScreen.this.stocksOrig.put(EquipmentMenuScreen.this.fighter.offHand.id, EquipmentMenuScreen.this.stocksOrig.get(EquipmentMenuScreen.this.fighter.offHand.id) + 1);
                    }
                    if (itemId.equalsIgnoreCase("empty")) {
                        EquipmentMenuScreen.this.fighter.offHand = null;
                        EquipmentMenuScreen.this.charOffHand.setTexture(equipmentAtlas.findRegion("empty"), EquipmentMenuScreen.this.charOffHand.getWidth(), EquipmentMenuScreen.this.charOffHand.getHeight());
                    } else {
                        EquipmentMenuScreen.this.fighter.offHand = new Equipment();
                        EquipmentMenuScreen.this.fighter.offHand.id = itemId;
                        EquipmentMenuScreen.this.fighter.offHand.tier = itemTier;
                        image = ((JSONObject)EquipmentMenuScreen.this.game.stats.get("weapons").get(EquipmentMenuScreen.this.fighter.offHand.id)).getString("imagePrefix") + EquipmentMenuScreen.this.game.stats.get("tiers").getJSONObject(itemTier).getString("imageSuffix");
                        EquipmentMenuScreen.this.charOffHand.setTexture(equipmentAtlas.findRegion(image), EquipmentMenuScreen.this.charOffHand.getWidth(), EquipmentMenuScreen.this.charOffHand.getHeight());
                    }
                } else if (itemType.equalsIgnoreCase("weapons")) {
                    if (EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && EquipmentMenuScreen.this.fighter.weapon != null && !EquipmentMenuScreen.this.fighter.weapon.id.equalsIgnoreCase("")) {
                        EquipmentMenuScreen.this.stocksOrig.put(EquipmentMenuScreen.this.fighter.weapon.id, EquipmentMenuScreen.this.stocksOrig.get(EquipmentMenuScreen.this.fighter.weapon.id) + 1);
                        if (EquipmentMenuScreen.this.fighter.offHand != null && EquipmentMenuScreen.this.fighter.offHand.id.equalsIgnoreCase("shield") && ((JSONObject)EquipmentMenuScreen.this.game.stats.get("weapons").get(itemId)).getString("type").startsWith("2h")) {
                            EquipmentMenuScreen.this.stocksOrig.put(EquipmentMenuScreen.this.fighter.offHand.id, EquipmentMenuScreen.this.stocksOrig.get(EquipmentMenuScreen.this.fighter.offHand.id) + 1);
                        }
                    }
                    EquipmentMenuScreen.this.fighter.weapon = new Equipment();
                    EquipmentMenuScreen.this.fighter.weapon.id = itemId;
                    EquipmentMenuScreen.this.fighter.weapon.tier = itemTier;
                    image = ((JSONObject)EquipmentMenuScreen.this.game.stats.get("weapons").get(EquipmentMenuScreen.this.fighter.weapon.id)).getString("imagePrefix") + EquipmentMenuScreen.this.game.stats.get("tiers").getJSONObject(itemTier).getString("imageSuffix");
                    EquipmentMenuScreen.this.charWeapon.setTexture(equipmentAtlas.findRegion(image), EquipmentMenuScreen.this.charWeapon.getWidth(), EquipmentMenuScreen.this.charWeapon.getHeight());
                    String weaponType = ((JSONObject)EquipmentMenuScreen.this.game.stats.get("weapons").get(EquipmentMenuScreen.this.fighter.weapon.id)).getString("type");
                    if (!weaponType.equalsIgnoreCase("1h")) {
                        EquipmentMenuScreen.this.fighter.offHand = null;
                        EquipmentMenuScreen.this.charOffHand.setTexture(equipmentAtlas.findRegion("empty"), EquipmentMenuScreen.this.charOffHand.getWidth(), EquipmentMenuScreen.this.charOffHand.getHeight());
                    }
                } else if (itemType.equalsIgnoreCase("armor")) {
                    if (EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && EquipmentMenuScreen.this.fighter.body != null && !EquipmentMenuScreen.this.fighter.body.id.equalsIgnoreCase("")) {
                        EquipmentMenuScreen.this.stocksOrig.put(EquipmentMenuScreen.this.fighter.body.id, EquipmentMenuScreen.this.stocksOrig.get(EquipmentMenuScreen.this.fighter.body.id) + 1);
                    }
                    if (itemId.equalsIgnoreCase("empty")) {
                        EquipmentMenuScreen.this.fighter.body = null;
                        EquipmentMenuScreen.this.charArmor.setTexture(equipmentAtlas.findRegion("empty"), EquipmentMenuScreen.this.charArmor.getWidth(), EquipmentMenuScreen.this.charArmor.getHeight());
                    } else {
                        EquipmentMenuScreen.this.fighter.body = new Equipment();
                        EquipmentMenuScreen.this.fighter.body.id = itemId;
                        EquipmentMenuScreen.this.fighter.body.tier = itemTier;
                        image = ((JSONObject)EquipmentMenuScreen.this.game.stats.get("armors").get(EquipmentMenuScreen.this.fighter.body.id)).getString("imagePrefix") + EquipmentMenuScreen.this.game.stats.get("tiers").getJSONObject(itemTier).getString("imageSuffix");
                        EquipmentMenuScreen.this.charArmor.setTexture(equipmentAtlas.findRegion(image), EquipmentMenuScreen.this.charArmor.getWidth(), EquipmentMenuScreen.this.charArmor.getHeight());
                    }
                } else if (itemType.equalsIgnoreCase("bracers")) {
                    if (EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && EquipmentMenuScreen.this.fighter.arms != null && !EquipmentMenuScreen.this.fighter.arms.id.equalsIgnoreCase("")) {
                        EquipmentMenuScreen.this.stocksOrig.put(EquipmentMenuScreen.this.fighter.arms.id, EquipmentMenuScreen.this.stocksOrig.get(EquipmentMenuScreen.this.fighter.arms.id) + 1);
                    }
                    if (itemId.equalsIgnoreCase("empty")) {
                        EquipmentMenuScreen.this.fighter.arms = null;
                        EquipmentMenuScreen.this.charBracers.setTexture(equipmentAtlas.findRegion("empty"), EquipmentMenuScreen.this.charBracers.getWidth(), EquipmentMenuScreen.this.charBracers.getHeight());
                    } else {
                        EquipmentMenuScreen.this.fighter.arms = new Equipment();
                        EquipmentMenuScreen.this.fighter.arms.id = itemId;
                        EquipmentMenuScreen.this.fighter.arms.tier = itemTier;
                        image = ((JSONObject)EquipmentMenuScreen.this.game.stats.get("armors").get(EquipmentMenuScreen.this.fighter.arms.id)).getString("imagePrefix") + EquipmentMenuScreen.this.game.stats.get("tiers").getJSONObject(itemTier).getString("imageSuffix");
                        EquipmentMenuScreen.this.charBracers.setTexture(equipmentAtlas.findRegion(image), EquipmentMenuScreen.this.charBracers.getWidth(), EquipmentMenuScreen.this.charBracers.getHeight());
                    }
                } else if (itemType.equalsIgnoreCase("helmet")) {
                    if (EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && EquipmentMenuScreen.this.fighter.head != null && !EquipmentMenuScreen.this.fighter.head.id.equalsIgnoreCase("")) {
                        EquipmentMenuScreen.this.stocksOrig.put(EquipmentMenuScreen.this.fighter.head.id, EquipmentMenuScreen.this.stocksOrig.get(EquipmentMenuScreen.this.fighter.head.id) + 1);
                    }
                    if (itemId.equalsIgnoreCase("empty")) {
                        EquipmentMenuScreen.this.fighter.head = null;
                        EquipmentMenuScreen.this.charHelmet.setTexture(equipmentAtlas.findRegion("empty"), EquipmentMenuScreen.this.charHelmet.getWidth(), EquipmentMenuScreen.this.charHelmet.getHeight());
                    } else {
                        EquipmentMenuScreen.this.fighter.head = new Equipment();
                        EquipmentMenuScreen.this.fighter.head.id = itemId;
                        EquipmentMenuScreen.this.fighter.head.tier = itemTier;
                        image = ((JSONObject)EquipmentMenuScreen.this.game.stats.get("armors").get(EquipmentMenuScreen.this.fighter.head.id)).getString("imagePrefix") + EquipmentMenuScreen.this.game.stats.get("tiers").getJSONObject(itemTier).getString("imageSuffix");
                        EquipmentMenuScreen.this.charHelmet.setTexture(equipmentAtlas.findRegion(image), EquipmentMenuScreen.this.charHelmet.getWidth(), EquipmentMenuScreen.this.charHelmet.getHeight());
                    }
                }
                EquipmentMenuScreen.this.game.manager.get(EquipmentMenuScreen.this.game.getOverridenAsset("sound/equip.ogg"), Sound.class).play(EquipmentMenuScreen.this.game.soundVolume);
                EquipmentMenuScreen.this.tierNumberArmor = Fighter.getMaxTierNumber(EquipmentMenuScreen.this.fighter, "armor");
                EquipmentMenuScreen.this.tierNumberWeapon = Fighter.getMaxTierNumber(EquipmentMenuScreen.this.fighter, "weapon");
                EquipmentMenuScreen.this.selectedItem.setVisible(false);
                EquipmentMenuScreen.this.selectedItemName.setVisible(false);
                EquipmentMenuScreen.this.selectedItemTier.setVisible(false);
                EquipmentMenuScreen.this.itemInfo.setVisible(false);
                EquipmentMenuScreen.this.statsBackground.setVisible(false);
                for (BaseActor currBar : EquipmentMenuScreen.this.statsBars) {
                    currBar.setVisible(false);
                }
                if (EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament")) {
                    EquipmentMenuScreen.this.generateItemList(itemType);
                }
                EquipmentMenuScreen.this.equipItem.setVisible(false);
                EquipmentMenuScreen.this.redrawFighter = true;
            }
        });
        this.equipItem.setVisible(false);
        this.equipItem.setWidth(UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        this.equipItem.setHeight(this.equipItem.getWidth());
        this.equipItem.setX(this.itemBackground.getX() + this.itemBackground.getWidth() - this.equipItem.getWidth() - UIHelpers.calcHeightProportion(this.game, 4.0f, 4.0f).floatValue());
        this.equipItem.setY(this.itemBackground.getY() + UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.stage.addActor(this.equipItem);
        this.bodyType = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        ArrayList<String> availableBodyTypes = new ArrayList<String>(this.game.stats.get("parts").getJSONObject("bodyTypes").keySet());
        Collections.sort(availableBodyTypes);
        String[] availableBodyTypesArr = new String[availableBodyTypes.size()];
        availableBodyTypesArr = availableBodyTypes.toArray(availableBodyTypesArr);
        this.bodyType.setItems((String[])availableBodyTypesArr);
        this.bodyType.setSelected(this.fighter.bodyType);
        this.bodyType.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Fighter.unloadFighterAssets(EquipmentMenuScreen.this.game, EquipmentMenuScreen.this.fighter, true, true);
                EquipmentMenuScreen.this.redrawFighter = true;
                String availableBodySubTypes = EquipmentMenuScreen.this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject((String)EquipmentMenuScreen.this.bodyType.getSelected()).getString("subTypes");
                EquipmentMenuScreen.this.bodySubType.setItems(availableBodySubTypes.split(","));
                EquipmentMenuScreen.this.bodySubType.setSelected(EquipmentMenuScreen.this.bodySubType.getItems().first());
                String availableArmsTypes = EquipmentMenuScreen.this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject((String)EquipmentMenuScreen.this.bodyType.getSelected()).getString("armsTypes");
                EquipmentMenuScreen.this.armsType.setItems(availableArmsTypes.split(","));
                EquipmentMenuScreen.this.armsType.setSelected(EquipmentMenuScreen.this.armsType.getItems().first());
                StringBuilder accessoriesAvailable = StringList.create(EquipmentMenuScreen.this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject((String)EquipmentMenuScreen.this.bodyType.getSelected()).getString("accessoryTypes"), ":");
                for (int i = 0; i < 15; ++i) {
                    String currAvailableAccessory = StringList.get(accessoriesAvailable, i, ":");
                    if (!currAvailableAccessory.equalsIgnoreCase("")) {
                        ((Button)EquipmentMenuScreen.this.accessoryList.get(i)).setVisible(true);
                    } else {
                        ((Button)EquipmentMenuScreen.this.accessoryList.get(i)).setVisible(false);
                    }
                    ((Button)EquipmentMenuScreen.this.accessoryList.get(i)).setChecked(false);
                }
                EquipmentMenuScreen.this.fighter.bodyType = (String)EquipmentMenuScreen.this.bodyType.getSelected();
                EquipmentMenuScreen.this.fighter.bodySubType = (String)EquipmentMenuScreen.this.bodySubType.getSelected();
                EquipmentMenuScreen.this.fighter.skinType = EquipmentMenuScreen.this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(EquipmentMenuScreen.this.fighter.bodyType).getString("skinType");
                EquipmentMenuScreen.this.fighter.armsType = (String)EquipmentMenuScreen.this.armsType.getSelected();
                EquipmentMenuScreen.this.fighter.accessoryTypes = "";
                EquipmentMenuScreen.this.fighter.headType = EquipmentMenuScreen.this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject((String)EquipmentMenuScreen.this.bodyType.getSelected()).getString("headTypes");
                EquipmentMenuScreen.this.fighter = Fighter.updateSpecials(EquipmentMenuScreen.this.game, EquipmentMenuScreen.this.fighter, EquipmentMenuScreen.this.game.saveGame.isEmpty() && EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament"));
            }
        });
        this.bodyType.setVisible(false);
        this.bodyType.setWidth(this.bodyType.getPrefWidth());
        this.bodyType.setX(this.itemBackground.getX() + this.itemBackground.getWidth() * 45.0f / 100.0f);
        this.bodyType.setY(this.itemBackground.getY() + this.itemBackground.getHeight() * 72.0f / 100.0f - this.bodyType.getHeight() / 2.0f);
        this.stage.addActor(this.bodyType);
        this.lBodyType = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.aspect.bodytype") + ": ", this.game.uiSkin, "default");
        this.lBodyType.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.lBodyType.setAlignment(16);
        this.lBodyType.setVisible(false);
        this.lBodyType.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(this.lBodyType, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), this.itemBackground.getWidth() * 25.0f / 100.0f, 0.0f);
        this.lBodyType.setX(this.itemBackground.getX() + this.itemBackground.getWidth() * 45.0f / 100.0f - this.lBodyType.getWidth() - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.lBodyType.setY(this.itemBackground.getY() + this.itemBackground.getHeight() * 72.0f / 100.0f - this.lBodyType.getPrefHeight() / 2.0f);
        this.stage.addActor(this.lBodyType);
        this.bodySubType = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String availableBodySubTypes = this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.bodyType.getSelected()).getString("subTypes");
        this.bodySubType.setItems((String[])availableBodySubTypes.split(","));
        this.bodySubType.setSelected(this.fighter.bodySubType);
        this.bodySubType.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!EquipmentMenuScreen.this.redrawFighter) {
                    Fighter.unloadFighterAssets(EquipmentMenuScreen.this.game, EquipmentMenuScreen.this.fighter, true, true);
                    EquipmentMenuScreen.this.redrawFighter = true;
                }
                EquipmentMenuScreen.this.fighter.bodySubType = (String)EquipmentMenuScreen.this.bodySubType.getSelected();
            }
        });
        this.bodySubType.setVisible(false);
        this.bodySubType.setWidth(this.bodySubType.getPrefWidth());
        this.bodySubType.setX(this.itemBackground.getX() + this.itemBackground.getWidth() * 85.0f / 100.0f);
        this.bodySubType.setY(this.itemBackground.getY() + this.itemBackground.getHeight() * 72.0f / 100.0f - this.bodySubType.getHeight() / 2.0f);
        this.stage.addActor(this.bodySubType);
        this.lBodySubType = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.aspect.bodysubtype") + ": ", this.game.uiSkin, "default");
        this.lBodySubType.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.lBodySubType.setAlignment(16);
        this.lBodySubType.setVisible(false);
        this.lBodySubType.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(this.lBodySubType, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), this.itemBackground.getWidth() * 25.0f / 100.0f, 0.0f);
        this.lBodySubType.setX(this.itemBackground.getX() + this.itemBackground.getWidth() * 85.0f / 100.0f - this.lBodySubType.getWidth() - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.lBodySubType.setY(this.itemBackground.getY() + this.itemBackground.getHeight() * 72.0f / 100.0f - this.lBodySubType.getPrefHeight() / 2.0f);
        this.stage.addActor(this.lBodySubType);
        this.armsType = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String availableArmsTypes = this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.bodyType.getSelected()).getString("armsTypes");
        this.armsType.setItems((String[])availableArmsTypes.split(","));
        this.armsType.setSelected(this.fighter.armsType);
        this.armsType.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!EquipmentMenuScreen.this.redrawFighter) {
                    Fighter.unloadFighterAssets(EquipmentMenuScreen.this.game, EquipmentMenuScreen.this.fighter, true, true);
                    EquipmentMenuScreen.this.redrawFighter = true;
                }
                EquipmentMenuScreen.this.fighter.armsType = (String)EquipmentMenuScreen.this.armsType.getSelected();
            }
        });
        this.armsType.setVisible(false);
        this.armsType.setWidth(this.armsType.getPrefWidth());
        this.armsType.setX(this.itemBackground.getX() + this.itemBackground.getWidth() * 45.0f / 100.0f);
        this.armsType.setY(this.itemBackground.getY() + this.itemBackground.getHeight() * 47.0f / 100.0f - this.armsType.getHeight() / 2.0f);
        this.stage.addActor(this.armsType);
        this.lArmsType = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.aspect.armstype") + ": ", this.game.uiSkin, "default");
        this.lArmsType.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.lArmsType.setAlignment(16);
        this.lArmsType.setVisible(false);
        this.lArmsType.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(this.lArmsType, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), this.itemBackground.getWidth() * 25.0f / 100.0f, 0.0f);
        this.lArmsType.setX(this.itemBackground.getX() + this.itemBackground.getWidth() * 45.0f / 100.0f - this.lArmsType.getWidth() - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.lArmsType.setY(this.itemBackground.getY() + this.itemBackground.getHeight() * 47.0f / 100.0f - this.lArmsType.getPrefHeight() / 2.0f);
        this.stage.addActor(this.lArmsType);
        this.lAccessories = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.aspect.accessories") + ": ", this.game.uiSkin, "default");
        this.lAccessories.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.lAccessories.setAlignment(16);
        this.lAccessories.setVisible(false);
        this.lAccessories.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(this.lAccessories, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), this.itemBackground.getWidth() * 25.0f / 100.0f, 0.0f);
        this.lAccessories.setX(this.itemBackground.getX() + this.itemBackground.getWidth() * 45.0f / 100.0f - this.lAccessories.getWidth() - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.lAccessories.setY(this.itemBackground.getY() + this.itemBackground.getHeight() * 22.0f / 100.0f - this.lAccessories.getPrefHeight() / 2.0f);
        this.stage.addActor(this.lAccessories);
        this.accessoryList = new ArrayList();
        StringBuilder accessoriesAvailable = StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.bodyType.getSelected()).getString("accessoryTypes"), ":");
        for (int i = 0; i < 15; ++i) {
            Button accessory = new Button(this.game.uiSkin, "check");
            accessory.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (!EquipmentMenuScreen.this.redrawFighter) {
                        Fighter.unloadFighterAssets(EquipmentMenuScreen.this.game, EquipmentMenuScreen.this.fighter, true, true);
                        EquipmentMenuScreen.this.redrawFighter = true;
                    }
                    StringBuilder accessoriesAvailable = StringList.create(EquipmentMenuScreen.this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject((String)EquipmentMenuScreen.this.bodyType.getSelected()).getString("accessoryTypes"), ":");
                    StringBuilder currAccessories = StringList.create(EquipmentMenuScreen.this.fighter.accessoryTypes, ":");
                    for (int j = 0; j < EquipmentMenuScreen.this.accessoryList.size(); ++j) {
                        if (EquipmentMenuScreen.this.accessoryList.get(j) != event.getListenerActor()) continue;
                        if (((Button)EquipmentMenuScreen.this.accessoryList.get(j)).isChecked()) {
                            EquipmentMenuScreen.this.fighter.accessoryTypes = StringList.append(currAccessories, StringList.get(accessoriesAvailable, j, ":"), ":").toString();
                            break;
                        }
                        EquipmentMenuScreen.this.fighter.accessoryTypes = StringList.remove(currAccessories, StringList.getPosition(currAccessories, StringList.get(accessoriesAvailable, j, ":"), ":"), ":").toString();
                        break;
                    }
                }
            });
            String currAvailableAccessory = StringList.get(accessoriesAvailable, i, ":");
            if (!currAvailableAccessory.equalsIgnoreCase("")) {
                if (this.fighter.accessoryTypes.contains(currAvailableAccessory)) {
                    accessory.setChecked(true);
                }
            } else {
                accessory.setChecked(false);
            }
            accessory.setVisible(false);
            accessory.setWidth(UIHelpers.calcHeightProportion(this.game, 3.5f, 3.5f).floatValue());
            accessory.setHeight(accessory.getWidth());
            accessory.setX(this.itemBackground.getX() + this.itemBackground.getWidth() * (float)(45 + i % 8 * 6) / 100.0f);
            accessory.setY(this.itemBackground.getY() + this.itemBackground.getHeight() * 22.0f / 100.0f - (float)(i / 8) * (accessory.getHeight() * 110.0f / 100.0f));
            this.accessoryList.add(accessory);
            this.stage.addActor(accessory);
        }
        this.skinColor = new Button(this.game.uiSkin, "colorpicker");
        this.skinColor.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                EquipmentMenuScreen.this.showColorPicker("skin");
            }
        });
        this.skinColor.setVisible(false);
        this.skinColor.setWidth(iconSize / 2.0f);
        this.skinColor.setHeight(iconSize / 2.0f);
        this.skinColor.setX(this.itemBackground.getX() + this.itemBackground.getWidth() * 8.0f / 100.0f);
        this.skinColor.setY(this.itemBackground.getY() + this.itemBackground.getHeight() * 47.0f / 100.0f - this.skinColor.getHeight() / 2.0f);
        this.stage.addActor(this.skinColor);
        this.bodyColor = new Button(this.game.uiSkin, "colorpicker");
        this.bodyColor.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                EquipmentMenuScreen.this.showColorPicker("body");
            }
        });
        this.bodyColor.setVisible(false);
        this.bodyColor.setWidth(iconSize / 2.0f);
        this.bodyColor.setHeight(iconSize / 2.0f);
        this.bodyColor.setX(this.itemBackground.getX() + this.itemBackground.getWidth() * 8.0f / 100.0f);
        this.bodyColor.setY(this.itemBackground.getY() + this.itemBackground.getHeight() * 72.0f / 100.0f - this.bodyColor.getHeight() / 2.0f);
        this.stage.addActor(this.bodyColor);
        this.accessoryColor = new Button(this.game.uiSkin, "colorpicker");
        this.accessoryColor.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                EquipmentMenuScreen.this.showColorPicker("accessory");
            }
        });
        this.accessoryColor.setVisible(false);
        this.accessoryColor.setWidth(iconSize / 2.0f);
        this.accessoryColor.setHeight(iconSize / 2.0f);
        this.accessoryColor.setX(this.itemBackground.getX() + this.itemBackground.getWidth() * 8.0f / 100.0f);
        this.accessoryColor.setY(this.itemBackground.getY() + this.itemBackground.getHeight() * 22.0f / 100.0f - this.accessoryColor.getHeight() / 2.0f);
        this.stage.addActor(this.accessoryColor);
        this.pickColor = new BaseActor();
        this.pickColor.setTexture(this.game.uiSkin.get("colors", TextureRegion.class), 600.0f, 388.0f);
        this.pickColor.setVisible(false);
        this.pickColor.setX((this.game.viewWidth.floatValue() - this.pickColor.getWidth()) / 2.0f);
        this.pickColor.setY(this.itemBackground.getY());
        this.stage.addActor(this.pickColor);
        this.pickColorFrame = new NinePatchActor(this.game.uiSkin.get("iconframe", NinePatch.class));
        this.pickColorFrame.setVisible(false);
        this.pickColorFrame.setTouchable(Touchable.disabled);
        this.pickColorFrame.setWidth(614.0f);
        this.pickColorFrame.setHeight(402.0f);
        this.pickColorFrame.setX(this.pickColor.getX() - 7.0f);
        this.pickColorFrame.setY(this.pickColor.getY() - 7.0f);
        this.stage.addActor(this.pickColorFrame);
        this.exitColorButton = new Button(this.game.uiSkin, "ok");
        this.exitColorButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                EquipmentMenuScreen.this.pickColorFrame.setVisible(false);
                EquipmentMenuScreen.this.pickColor.setVisible(false);
                EquipmentMenuScreen.this.exitColorButton.setVisible(false);
            }
        });
        this.exitColorButton.setVisible(false);
        this.exitColorButton.setWidth(UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue());
        this.exitColorButton.setHeight(UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue());
        this.exitColorButton.setX(this.pickColorFrame.getX() + this.pickColorFrame.getWidth());
        this.exitColorButton.setY(this.pickColorFrame.getY() + this.pickColorFrame.getHeight() - this.exitColorButton.getHeight());
        this.stage.addActor(this.exitColorButton);
        this.applyButton = new Button(this.game.uiSkin, "ok");
        this.applyButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (EquipmentMenuScreen.this.previousScreen instanceof DuelSetupScreen) {
                    if (EquipmentMenuScreen.this.fighterType.equalsIgnoreCase("host")) {
                        ((DuelSetupScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).hostFighter = EquipmentMenuScreen.this.fighter;
                    } else {
                        ((DuelSetupScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).clientFighter = EquipmentMenuScreen.this.fighter;
                    }
                    ((DuelSetupScreen)EquipmentMenuScreen.this.previousScreen).sendMessage("change", "");
                } else if (EquipmentMenuScreen.this.previousScreen instanceof PrepSetupScreen) {
                    ((PrepSetupScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).hostFighter = EquipmentMenuScreen.this.fighter;
                } else if (EquipmentMenuScreen.this.previousScreen instanceof TournamentGameScreen) {
                    ((TournamentGameScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).fighter.accessoryColor = EquipmentMenuScreen.this.fighter.accessoryColor;
                    ((TournamentGameScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).fighter.accessoryTypes = EquipmentMenuScreen.this.fighter.accessoryTypes;
                    ((TournamentGameScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).fighter.armsType = EquipmentMenuScreen.this.fighter.armsType;
                    ((TournamentGameScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).fighter.bodyColor = EquipmentMenuScreen.this.fighter.bodyColor;
                    ((TournamentGameScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).fighter.bodySubType = EquipmentMenuScreen.this.fighter.bodySubType;
                    ((TournamentGameScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).fighter.bodyType = EquipmentMenuScreen.this.fighter.bodyType;
                    ((TournamentGameScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).fighter.skinColor = EquipmentMenuScreen.this.fighter.skinColor;
                    ((TournamentGameScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).fighter.skinType = EquipmentMenuScreen.this.fighter.skinType;
                } else if (EquipmentMenuScreen.this.previousScreen instanceof TournamentSetupScreen) {
                    ((TournamentSetupScreen)((EquipmentMenuScreen)EquipmentMenuScreen.this).previousScreen).hostFighter = EquipmentMenuScreen.this.fighter;
                    Tournament.setWeaponsAvailable(EquipmentMenuScreen.this.game, EquipmentMenuScreen.this.stocksOrig);
                }
                EquipmentMenuScreen.this.game.setScreen(EquipmentMenuScreen.this.previousScreen);
                EquipmentMenuScreen.this.dispose();
            }
        });
        this.applyButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.applyButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.applyButton.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - this.applyButton.getPrefWidth());
        this.applyButton.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 1.0f).floatValue());
        this.stage.addActor(this.applyButton);
        this.exitButton = new Button(this.game.uiSkin, "cancel");
        this.exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                EquipmentMenuScreen.this.game.setScreen(EquipmentMenuScreen.this.previousScreen);
                EquipmentMenuScreen.this.dispose();
            }
        });
        this.exitButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.exitButton.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 1.0f).floatValue());
        this.stage.addActor(this.exitButton);
    }

    @Override
    public void render(float delta) {
        this.game.manager.update();
        this.stage.act(delta);
        if (this.redrawFighter) {
            Fighter.loadFighterAssets(this.game, this.fighter, true, true);
            this.drawFighter("idle", "");
            this.redrawFighter = false;
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public void receivedPacket(String content) {
        if (this.previousScreen instanceof DuelSetupScreen) {
            this.previousScreen.receivedPacket(content);
        }
    }

    private void generateItemList(String type) {
        this.bodyType.setVisible(false);
        this.lBodyType.setVisible(false);
        this.bodySubType.setVisible(false);
        this.lBodySubType.setVisible(false);
        this.armsType.setVisible(false);
        for (int i = 0; i < this.accessoryList.size(); ++i) {
            this.accessoryList.get(i).setVisible(false);
        }
        this.lArmsType.setVisible(false);
        this.lAccessories.setVisible(false);
        this.skinColor.setVisible(false);
        this.bodyColor.setVisible(false);
        this.accessoryColor.setVisible(false);
        TextureAtlas equipmentAtlas = this.game.manager.get(this.game.getOverridenAsset("data/equipment/equipment.atlas"), TextureAtlas.class);
        for (BaseActor currItem : this.availableItems) {
            currItem.remove();
        }
        this.availableItems = new ArrayList();
        this.itemList.clearChildren();
        this.selectedItem.setVisible(false);
        this.selectedItemName.setVisible(false);
        this.selectedItemTier.setVisible(false);
        this.itemInfo.setVisible(false);
        this.statsBackground.setVisible(false);
        for (BaseActor currBar : this.statsBars) {
            currBar.setVisible(false);
        }
        this.equipItem.setVisible(false);
        int currArmorMultiplier = 0;
        if (this.fighter.services.contains("upgradearmor")) {
            int serviceMultiplierPosition = this.fighter.services.indexOf("upgradearmor") + 13;
            currArmorMultiplier = Integer.parseInt(this.fighter.services.substring(serviceMultiplierPosition, serviceMultiplierPosition + 1));
        }
        int currWeaponMultiplier = 0;
        if (this.fighter.services.contains("upgradeweapon")) {
            int serviceMultiplierPosition = this.fighter.services.indexOf("upgradeweapon") + 14;
            currWeaponMultiplier = Integer.parseInt(this.fighter.services.substring(serviceMultiplierPosition, serviceMultiplierPosition + 1));
        }
        int numItems = 0;
        if (type.equalsIgnoreCase("helmet")) {
            BaseActor empty = new BaseActor();
            empty.setTexture(equipmentAtlas.findRegion("empty"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
            empty.params.put("id", "empty");
            empty.params.put("type", "helmet");
            empty.params.put("tier", "wood");
            Stack sEmpty = new Stack();
            sEmpty.add(empty);
            sEmpty.addListener(this.itemListener());
            this.itemList.addActor(sEmpty);
            ++numItems;
            if (!this.game.gameMode.equalsIgnoreCase("tournament") || this.stocksOrig.get("helmet") != null && this.stocksOrig.get("helmet") > 0) {
                Label stock;
                int numStock;
                BaseActor helmetw = new BaseActor();
                helmetw.setTexture(equipmentAtlas.findRegion("ahelmetw"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                helmetw.params.put("id", "helmet");
                helmetw.params.put("type", "helmet");
                helmetw.params.put("tier", "wood");
                Stack sHelmetw = new Stack();
                sHelmetw.add(helmetw);
                if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                    int numStock2 = this.stocksOrig.get("helmet");
                    Label stock2 = new Label("x" + numStock2 + " ", this.game.uiSkin, "default");
                    stock2.setAlignment(18);
                    stock2.setColor(this.game.uiSkin.get("lightiron", Color.class));
                    stock2.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                    stock2.setWidth(this.charHelmet.getWidth());
                    stock2.layout();
                    sHelmetw.add(stock2);
                }
                sHelmetw.addListener(this.itemListener());
                this.itemList.addActor(sHelmetw);
                ++numItems;
                if (this.fighter.services.contains("upgradearmor") && (this.tierNumberArmor % 10 < currArmorMultiplier && Fighter.getDiffTierNumber(this.fighter, "head", "caparace", Equipment.tierLevel("wood")) <= currArmorMultiplier - this.tierNumberArmor % 10 || this.fighter.head != null && this.fighter.head.tier.equalsIgnoreCase("caparace"))) {
                    BaseActor helmetc = new BaseActor();
                    helmetc.setTexture(equipmentAtlas.findRegion("ahelmetc"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                    helmetc.params.put("id", "helmet");
                    helmetc.params.put("type", "helmet");
                    helmetc.params.put("tier", "caparace");
                    Stack sHelmetc = new Stack();
                    sHelmetc.add(helmetc);
                    if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                        numStock = this.stocksOrig.get("helmet");
                        stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
                        stock.setAlignment(18);
                        stock.setColor(this.game.uiSkin.get("lightiron", Color.class));
                        stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                        stock.setWidth(this.charHelmet.getWidth());
                        stock.layout();
                        sHelmetc.add(stock);
                    }
                    sHelmetc.addListener(this.itemListener());
                    this.itemList.addActor(sHelmetc);
                    ++numItems;
                }
                if (this.fighter.services.contains("upgradearmor") && (this.equipmentLimit() == 2 && this.tierNumberArmor % 10 < currArmorMultiplier && Fighter.getDiffTierNumber(this.fighter, "head", "iron", Equipment.tierLevel("wood")) <= currArmorMultiplier - this.tierNumberArmor % 10 || this.fighter.head != null && this.fighter.head.tier.equalsIgnoreCase("iron"))) {
                    BaseActor helmeti = new BaseActor();
                    helmeti.setTexture(equipmentAtlas.findRegion("ahelmeti"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                    helmeti.params.put("id", "helmet");
                    helmeti.params.put("type", "helmet");
                    helmeti.params.put("tier", "iron");
                    Stack sHelmeti = new Stack();
                    sHelmeti.add(helmeti);
                    if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                        numStock = this.stocksOrig.get("helmet");
                        stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
                        stock.setAlignment(18);
                        stock.setColor(this.game.uiSkin.get("lightiron", Color.class));
                        stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                        stock.setWidth(this.charHelmet.getWidth());
                        stock.layout();
                        sHelmeti.add(stock);
                    }
                    sHelmeti.addListener(this.itemListener());
                    this.itemList.addActor(sHelmeti);
                    ++numItems;
                }
            }
        } else if (type.equalsIgnoreCase("bracers")) {
            BaseActor empty = new BaseActor();
            empty.setTexture(equipmentAtlas.findRegion("empty"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
            empty.params.put("id", "empty");
            empty.params.put("type", "bracers");
            empty.params.put("tier", "wood");
            Stack sEmpty = new Stack();
            sEmpty.add(empty);
            sEmpty.addListener(this.itemListener());
            this.itemList.addActor(sEmpty);
            ++numItems;
            if (!this.game.gameMode.equalsIgnoreCase("tournament") || this.stocksOrig.get("bracers") != null && this.stocksOrig.get("bracers") > 0) {
                Label stock;
                int numStock;
                BaseActor bracersw = new BaseActor();
                bracersw.setTexture(equipmentAtlas.findRegion("abracersw"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                bracersw.params.put("id", "bracers");
                bracersw.params.put("type", "bracers");
                bracersw.params.put("tier", "wood");
                Stack sBracersw = new Stack();
                sBracersw.add(bracersw);
                if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                    int numStock3 = this.stocksOrig.get("bracers");
                    Label stock3 = new Label("x" + numStock3 + " ", this.game.uiSkin, "default");
                    stock3.setAlignment(18);
                    stock3.setColor(this.game.uiSkin.get("lightiron", Color.class));
                    stock3.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                    stock3.setWidth(this.charHelmet.getWidth());
                    stock3.layout();
                    sBracersw.add(stock3);
                }
                sBracersw.addListener(this.itemListener());
                this.itemList.addActor(sBracersw);
                ++numItems;
                if (this.fighter.services.contains("upgradearmor") && (this.tierNumberArmor % 10 < currArmorMultiplier && Fighter.getDiffTierNumber(this.fighter, "arms", "caparace", Equipment.tierLevel("wood")) <= currArmorMultiplier - this.tierNumberArmor % 10 || this.fighter.arms != null && this.fighter.arms.tier.equalsIgnoreCase("caparace"))) {
                    BaseActor bracersc = new BaseActor();
                    bracersc.setTexture(equipmentAtlas.findRegion("abracersc"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                    bracersc.params.put("id", "bracers");
                    bracersc.params.put("type", "bracers");
                    bracersc.params.put("tier", "caparace");
                    Stack sBracersc = new Stack();
                    sBracersc.add(bracersc);
                    if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                        numStock = this.stocksOrig.get("bracers");
                        stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
                        stock.setAlignment(18);
                        stock.setColor(this.game.uiSkin.get("lightiron", Color.class));
                        stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                        stock.setWidth(this.charHelmet.getWidth());
                        stock.layout();
                        sBracersc.add(stock);
                    }
                    sBracersc.addListener(this.itemListener());
                    this.itemList.addActor(sBracersc);
                    ++numItems;
                }
                if (this.fighter.services.contains("upgradearmor") && (this.equipmentLimit() == 2 && this.tierNumberArmor % 10 < currArmorMultiplier && Fighter.getDiffTierNumber(this.fighter, "arms", "iron", Equipment.tierLevel("wood")) <= currArmorMultiplier - this.tierNumberArmor % 10 || this.fighter.arms != null && this.fighter.arms.tier.equalsIgnoreCase("iron"))) {
                    BaseActor bracersi = new BaseActor();
                    bracersi.setTexture(equipmentAtlas.findRegion("abracersi"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                    bracersi.params.put("id", "bracers");
                    bracersi.params.put("type", "bracers");
                    bracersi.params.put("tier", "iron");
                    Stack sBracersi = new Stack();
                    sBracersi.add(bracersi);
                    if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                        numStock = this.stocksOrig.get("bracers");
                        stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
                        stock.setAlignment(18);
                        stock.setColor(this.game.uiSkin.get("lightiron", Color.class));
                        stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                        stock.setWidth(this.charHelmet.getWidth());
                        stock.layout();
                        sBracersi.add(stock);
                    }
                    sBracersi.addListener(this.itemListener());
                    this.itemList.addActor(sBracersi);
                    ++numItems;
                }
            }
        } else if (type.equalsIgnoreCase("armor")) {
            BaseActor empty = new BaseActor();
            empty.setTexture(equipmentAtlas.findRegion("empty"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
            empty.params.put("id", "empty");
            empty.params.put("type", "armor");
            empty.params.put("tier", "wood");
            Stack sEmpty = new Stack();
            sEmpty.add(empty);
            sEmpty.addListener(this.itemListener());
            this.itemList.addActor(sEmpty);
            ++numItems;
            if (!this.game.gameMode.equalsIgnoreCase("tournament") || this.stocksOrig.get("cuirass") != null && this.stocksOrig.get("cuirass") > 0) {
                Label stock;
                int numStock;
                BaseActor armorw = new BaseActor();
                armorw.setTexture(equipmentAtlas.findRegion("acuirassw"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                armorw.params.put("id", "cuirass");
                armorw.params.put("type", "armor");
                armorw.params.put("tier", "wood");
                Stack sArmorw = new Stack();
                sArmorw.add(armorw);
                if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                    int numStock4 = this.stocksOrig.get("cuirass");
                    Label stock4 = new Label("x" + numStock4 + " ", this.game.uiSkin, "default");
                    stock4.setAlignment(18);
                    stock4.setColor(this.game.uiSkin.get("lightiron", Color.class));
                    stock4.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                    stock4.setWidth(this.charHelmet.getWidth());
                    stock4.layout();
                    sArmorw.add(stock4);
                }
                sArmorw.addListener(this.itemListener());
                this.itemList.addActor(sArmorw);
                ++numItems;
                if (this.fighter.services.contains("upgradearmor") && (this.tierNumberArmor % 10 < currArmorMultiplier && Fighter.getDiffTierNumber(this.fighter, "body", "caparace", Equipment.tierLevel("wood")) <= currArmorMultiplier - this.tierNumberArmor % 10 || this.fighter.body != null && this.fighter.body.tier.equalsIgnoreCase("caparace"))) {
                    BaseActor armorc = new BaseActor();
                    armorc.setTexture(equipmentAtlas.findRegion("acuirassc"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                    armorc.params.put("id", "cuirass");
                    armorc.params.put("type", "armor");
                    armorc.params.put("tier", "caparace");
                    Stack sArmorc = new Stack();
                    sArmorc.add(armorc);
                    if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                        numStock = this.stocksOrig.get("cuirass");
                        stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
                        stock.setAlignment(18);
                        stock.setColor(this.game.uiSkin.get("lightiron", Color.class));
                        stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                        stock.setWidth(this.charHelmet.getWidth());
                        stock.layout();
                        sArmorc.add(stock);
                    }
                    sArmorc.addListener(this.itemListener());
                    this.itemList.addActor(sArmorc);
                    ++numItems;
                }
                if (this.fighter.services.contains("upgradearmor") && (this.equipmentLimit() == 2 && this.tierNumberArmor % 10 < currArmorMultiplier && Fighter.getDiffTierNumber(this.fighter, "body", "iron", Equipment.tierLevel("wood")) <= currArmorMultiplier - this.tierNumberArmor % 10 || this.fighter.body != null && this.fighter.body.tier.equalsIgnoreCase("iron"))) {
                    BaseActor armori = new BaseActor();
                    armori.setTexture(equipmentAtlas.findRegion("acuirassi"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                    armori.params.put("id", "cuirass");
                    armori.params.put("type", "armor");
                    armori.params.put("tier", "iron");
                    Stack sArmorci = new Stack();
                    sArmorci.add(armori);
                    if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                        numStock = this.stocksOrig.get("cuirass");
                        stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
                        stock.setAlignment(18);
                        stock.setColor(this.game.uiSkin.get("lightiron", Color.class));
                        stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                        stock.setWidth(this.charHelmet.getWidth());
                        stock.layout();
                        sArmorci.add(stock);
                    }
                    sArmorci.addListener(this.itemListener());
                    this.itemList.addActor(sArmorci);
                    ++numItems;
                }
            }
        } else if (type.equalsIgnoreCase("weapons")) {
            Object baseTier;
            HashMap weaponNumbers = new HashMap();
            weaponNumbers.put("baseDamage", new ArrayList());
            weaponNumbers.put("criticalChance", new ArrayList());
            weaponNumbers.put("attackTime", new ArrayList());
            weaponNumbers.put("staminaCost", new ArrayList());
            weaponNumbers.put("parryTime", new ArrayList());
            weaponNumbers.put("dodgeTime", new ArrayList());
            for (String currWeapon : this.game.stats.get("weapons").keySet()) {
                Label stock;
                int numStock;
                JSONObject currWeaponObject = this.game.stats.get("weapons").getJSONObject(currWeapon);
                if (currWeaponObject.getString("baseDamage") == null || currWeaponObject.getString("baseDamage").equalsIgnoreCase("")) continue;
                ((ArrayList)weaponNumbers.get("baseDamage")).add(Float.valueOf(currWeaponObject.getFloat("baseDamage")));
                ((ArrayList)weaponNumbers.get("criticalChance")).add(Float.valueOf(currWeaponObject.getFloat("criticalChance")));
                ((ArrayList)weaponNumbers.get("attackTime")).add(Float.valueOf(currWeaponObject.getFloat("attackTime")));
                if (currWeapon.equalsIgnoreCase("dagger") && (this.game.saveGame.isEmpty() || this.game.gameMode.equalsIgnoreCase("tournament") && this.game.saveGame.get("rewards").contains("dagger-fighting") || this.game.gameMode.equalsIgnoreCase("story") && this.game.saveGame.get("rewards").contains("dagger-fighting"))) {
                    ((ArrayList)weaponNumbers.get("parryTime")).add(Float.valueOf(0.75f));
                    ((ArrayList)weaponNumbers.get("dodgeTime")).add(Float.valueOf(0.75f));
                } else {
                    ((ArrayList)weaponNumbers.get("parryTime")).add(Float.valueOf(currWeaponObject.getFloat("parryTime")));
                    ((ArrayList)weaponNumbers.get("dodgeTime")).add(Float.valueOf(currWeaponObject.getFloat("dodgeTime")));
                }
                ((ArrayList)weaponNumbers.get("staminaCost")).add(Float.valueOf(currWeaponObject.getFloat("staminaCost")));
                baseTier = (JSONObject)this.game.stats.get("tiers").get("caparace");
                ((ArrayList)weaponNumbers.get("baseDamage")).add(Float.valueOf(currWeaponObject.getFloat("baseDamage") * (float)(100 + ((JSONObject)baseTier).getInt("weaponBaseDamage") * (100 + this.tierBonus) / 100) / 100.0f));
                ((ArrayList)weaponNumbers.get("criticalChance")).add(Float.valueOf(currWeaponObject.getFloat("criticalChance") * (float)(100 + ((JSONObject)baseTier).getInt("weaponCriticalChance")) / 100.0f));
                ((ArrayList)weaponNumbers.get("attackTime")).add(Float.valueOf(currWeaponObject.getFloat("attackTime") * (float)(100 + ((JSONObject)baseTier).getInt("weaponAttackTime")) / 100.0f));
                ((ArrayList)weaponNumbers.get("staminaCost")).add(Float.valueOf(currWeaponObject.getFloat("staminaCost") * (float)(100 + ((JSONObject)baseTier).getInt("weaponStaminaCost")) / 100.0f));
                baseTier = (JSONObject)this.game.stats.get("tiers").get("iron");
                ((ArrayList)weaponNumbers.get("baseDamage")).add(Float.valueOf(currWeaponObject.getFloat("baseDamage") * (float)(100 + ((JSONObject)baseTier).getInt("weaponBaseDamage") * (100 + this.tierBonus) / 100) / 100.0f));
                ((ArrayList)weaponNumbers.get("criticalChance")).add(Float.valueOf(currWeaponObject.getFloat("criticalChance") * (float)(100 + ((JSONObject)baseTier).getInt("weaponCriticalChance")) / 100.0f));
                ((ArrayList)weaponNumbers.get("attackTime")).add(Float.valueOf(currWeaponObject.getFloat("attackTime") * (float)(100 + ((JSONObject)baseTier).getInt("weaponAttackTime")) / 100.0f));
                ((ArrayList)weaponNumbers.get("staminaCost")).add(Float.valueOf(currWeaponObject.getFloat("staminaCost") * (float)(100 + ((JSONObject)baseTier).getInt("weaponStaminaCost")) / 100.0f));
                if (!this.game.saveGame.isEmpty() && !this.fighter.services.contains("choice") && (!this.game.gameMode.equalsIgnoreCase("story") || StringList.indexOf(StringList.create(this.game.saveGame.get("availableWeapons"), ";"), currWeapon + ":1", 0, ";") < 0) && (!this.game.gameMode.equalsIgnoreCase("tournament") || this.stocksOrig.get(currWeapon) == null || this.stocksOrig.get(currWeapon) <= 0) || !(this.game.saveGame.isEmpty() || this.game.gameMode.equalsIgnoreCase("tournament") || !currWeapon.equalsIgnoreCase("whip") && !currWeapon.equalsIgnoreCase("longsword") || currWeapon.equalsIgnoreCase("whip") && !this.game.saveGame.get("phase").equalsIgnoreCase("pits")) && (!currWeapon.equalsIgnoreCase("longsword") || !this.game.saveGame.get("phase").equalsIgnoreCase("coliseum") && !this.game.saveGame.get("rewards").contains("lonswo"))) continue;
                BaseActor weaponw = new BaseActor();
                weaponw.setTexture(equipmentAtlas.findRegion(currWeaponObject.getString("imagePrefix") + "w"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                weaponw.params.put("id", currWeapon);
                weaponw.params.put("type", "weapons");
                weaponw.params.put("tier", "wood");
                Stack sWeaponw = new Stack();
                sWeaponw.add(weaponw);
                if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                    int numStock5 = this.stocksOrig.get(currWeapon);
                    Label stock5 = new Label("x" + numStock5 + " ", this.game.uiSkin, "default");
                    stock5.setAlignment(18);
                    stock5.setColor(this.game.uiSkin.get("lightiron", Color.class));
                    stock5.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                    stock5.setWidth(this.charHelmet.getWidth());
                    stock5.layout();
                    sWeaponw.add(stock5);
                }
                sWeaponw.addListener(this.itemListener());
                this.itemList.addActor(sWeaponw);
                ++numItems;
                if (this.fighter.services.contains("upgradeweapon") && (this.tierNumberWeapon % 10 < currWeaponMultiplier && Fighter.getDiffTierNumber(this.fighter, "weapon", "caparace", Equipment.tierLevel("wood")) <= currWeaponMultiplier - this.tierNumberWeapon % 10 || this.fighter.weapon.tier.equalsIgnoreCase("caparace"))) {
                    BaseActor weaponc = new BaseActor();
                    weaponc.setTexture(equipmentAtlas.findRegion(currWeaponObject.getString("imagePrefix") + "c"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                    weaponc.params.put("id", currWeapon);
                    weaponc.params.put("type", "weapons");
                    weaponc.params.put("tier", "caparace");
                    Stack sWeaponc = new Stack();
                    sWeaponc.add(weaponc);
                    if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                        numStock = this.stocksOrig.get(currWeapon);
                        stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
                        stock.setAlignment(18);
                        stock.setColor(this.game.uiSkin.get("lightiron", Color.class));
                        stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                        stock.setWidth(this.charHelmet.getWidth());
                        stock.layout();
                        sWeaponc.add(stock);
                    }
                    sWeaponc.addListener(this.itemListener());
                    this.itemList.addActor(sWeaponc);
                    ++numItems;
                }
                if (this.equipmentLimit() != 2 || !this.fighter.services.contains("upgradeweapon") || (this.tierNumberWeapon % 10 >= currWeaponMultiplier || Fighter.getDiffTierNumber(this.fighter, "weapon", "iron", Equipment.tierLevel("wood")) > currWeaponMultiplier - this.tierNumberWeapon % 10) && !this.fighter.weapon.tier.equalsIgnoreCase("iron")) continue;
                BaseActor weaponi = new BaseActor();
                weaponi.setTexture(equipmentAtlas.findRegion(currWeaponObject.getString("imagePrefix") + "i"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                weaponi.params.put("id", currWeapon);
                weaponi.params.put("type", "weapons");
                weaponi.params.put("tier", "iron");
                Stack sWeaponi = new Stack();
                sWeaponi.add(weaponi);
                if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                    numStock = this.stocksOrig.get(currWeapon);
                    stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
                    stock.setAlignment(18);
                    stock.setColor(this.game.uiSkin.get("lightiron", Color.class));
                    stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                    stock.setWidth(this.charHelmet.getWidth());
                    stock.layout();
                    sWeaponi.add(stock);
                }
                sWeaponi.addListener(this.itemListener());
                this.itemList.addActor(sWeaponi);
                ++numItems;
            }
            for (String metric : weaponNumbers.keySet()) {
                ArrayList<Float> metricValues = new ArrayList<Float>();
                metricValues.add(Float.valueOf(10000.0f));
                metricValues.add(Float.valueOf(0.0f));
                baseTier = ((ArrayList)weaponNumbers.get(metric)).iterator();
                while (baseTier.hasNext()) {
                    float currNumber = ((Float)baseTier.next()).floatValue();
                    if (((Float)metricValues.get(0)).floatValue() > currNumber) {
                        metricValues.set(0, Float.valueOf(currNumber));
                    }
                    if (!(((Float)metricValues.get(1)).floatValue() < currNumber)) continue;
                    metricValues.set(1, Float.valueOf(currNumber));
                }
                this.weaponStats.put(metric, metricValues);
            }
        } else if (type.equalsIgnoreCase("offhand")) {
            BaseActor empty = new BaseActor();
            empty.setTexture(equipmentAtlas.findRegion("empty"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
            empty.params.put("id", "empty");
            empty.params.put("type", "offhand");
            empty.params.put("tier", "wood");
            Stack sEmpty = new Stack();
            sEmpty.add(empty);
            sEmpty.addListener(this.itemListener());
            this.itemList.addActor(sEmpty);
            ++numItems;
            if (this.game.stats.get("weapons").getJSONObject(this.fighter.weapon.id).getString("type").equalsIgnoreCase("1h")) {
                for (String currOffhand : this.game.stats.get("weapons").keySet()) {
                    Label stock;
                    int numStock;
                    JSONObject currOffhandObject = this.game.stats.get("weapons").getJSONObject(currOffhand);
                    if (currOffhandObject.getString("offHandBonus") == null || currOffhandObject.getString("offHandBonus").equalsIgnoreCase("") || !this.game.saveGame.isEmpty() && !this.fighter.services.contains("choice") && (!this.game.gameMode.equalsIgnoreCase("story") || StringList.indexOf(StringList.create(this.game.saveGame.get("availableWeapons"), ";"), currOffhand + ":1", 0, ";") < 0) && (!this.game.gameMode.equalsIgnoreCase("tournament") || this.stocksOrig.get(currOffhand) == null || this.stocksOrig.get(currOffhand) <= 0)) continue;
                    BaseActor offhandw = new BaseActor();
                    offhandw.setTexture(equipmentAtlas.findRegion(currOffhandObject.getString("imagePrefix") + "w"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                    offhandw.params.put("id", currOffhand);
                    offhandw.params.put("type", "offhand");
                    offhandw.params.put("tier", "wood");
                    Stack sOffhandw = new Stack();
                    sOffhandw.add(offhandw);
                    if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                        int numStock6 = this.stocksOrig.get(currOffhand);
                        Label stock6 = new Label("x" + numStock6 + " ", this.game.uiSkin, "default");
                        stock6.setAlignment(18);
                        stock6.setColor(this.game.uiSkin.get("lightiron", Color.class));
                        stock6.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                        stock6.setWidth(this.charHelmet.getWidth());
                        stock6.layout();
                        sOffhandw.add(stock6);
                    }
                    sOffhandw.addListener(this.itemListener());
                    this.itemList.addActor(sOffhandw);
                    ++numItems;
                    if (currWeaponMultiplier > 0) {
                        BaseActor offhandc = new BaseActor();
                        offhandc.setTexture(equipmentAtlas.findRegion(currOffhandObject.getString("imagePrefix") + "c"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                        offhandc.params.put("id", currOffhand);
                        offhandc.params.put("type", "offhand");
                        offhandc.params.put("tier", "caparace");
                        Stack sOffhandc = new Stack();
                        sOffhandc.add(offhandc);
                        if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                            numStock = this.stocksOrig.get(currOffhand);
                            stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
                            stock.setAlignment(18);
                            stock.setColor(this.game.uiSkin.get("lightiron", Color.class));
                            stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                            stock.setWidth(this.charHelmet.getWidth());
                            stock.layout();
                            sOffhandc.add(stock);
                        }
                        sOffhandc.addListener(this.itemListener());
                        this.itemList.addActor(sOffhandc);
                        ++numItems;
                    }
                    if (this.equipmentLimit() != 2 || currWeaponMultiplier <= 1) continue;
                    BaseActor offhandi = new BaseActor();
                    offhandi.setTexture(equipmentAtlas.findRegion(currOffhandObject.getString("imagePrefix") + "i"), (float)Float.valueOf(this.charHelmet.getWidth()).intValue(), (float)Float.valueOf(this.charHelmet.getWidth()).intValue());
                    offhandi.params.put("id", currOffhand);
                    offhandi.params.put("type", "offhand");
                    offhandi.params.put("tier", "iron");
                    Stack sOffhandi = new Stack();
                    sOffhandi.add(offhandi);
                    if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                        numStock = this.stocksOrig.get(currOffhand);
                        stock = new Label("x" + numStock + " ", this.game.uiSkin, "default");
                        stock.setAlignment(18);
                        stock.setColor(this.game.uiSkin.get("lightiron", Color.class));
                        stock.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                        stock.setWidth(this.charHelmet.getWidth());
                        stock.layout();
                        sOffhandi.add(stock);
                    }
                    sOffhandi.addListener(this.itemListener());
                    this.itemList.addActor(sOffhandi);
                    ++numItems;
                }
            }
        }
        if (this.game.portraitmode) {
            this.itemList.setWidth((float)numItems * UIHelpers.calcHeightProportion(this.game, 10.0f, 8.0f).floatValue() + (float)(numItems + 1) * UIHelpers.calcHeightProportion(this.game, 1.0f, 0.8f).floatValue());
            this.itemPane.setWidth(MathUtils.clamp(this.itemList.getWidth(), 0.0f, this.iconListBackground.getWidth() - 80.0f));
            this.itemPane.layout();
            this.itemPane.setX(this.iconListBackground.getX() + this.iconListBackground.getWidth() - this.itemPane.getWidth() - 40.0f);
            this.itemPane.setScrollX(0.0f);
        } else {
            this.itemList.setHeight((float)numItems * UIHelpers.calcHeightProportion(this.game, 10.0f, 8.0f).floatValue() + (float)(numItems + 1) * UIHelpers.calcHeightProportion(this.game, 1.0f, 0.8f).floatValue());
            this.itemPane.setHeight(MathUtils.clamp(this.itemList.getHeight(), 0.0f, this.iconListBackground.getHeight() - 80.0f));
            this.itemPane.layout();
            this.itemPane.setY(this.iconListBackground.getY() + this.iconListBackground.getHeight() - this.itemPane.getHeight() - 40.0f);
            this.itemPane.setScrollY(0.0f);
        }
    }

    private void generateAspectMenu() {
        this.selectedItem.setVisible(false);
        this.selectedItemName.setVisible(false);
        this.selectedItemTier.setVisible(false);
        this.itemInfo.setVisible(false);
        this.statsBackground.setVisible(false);
        for (BaseActor currBar : this.statsBars) {
            currBar.setVisible(false);
        }
        this.equipItem.setVisible(false);
        this.bodyType.setVisible(true);
        this.lBodyType.setVisible(true);
        this.bodySubType.setVisible(true);
        this.lBodySubType.setVisible(true);
        this.armsType.setVisible(true);
        StringBuilder accessoriesAvailable = StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.bodyType.getSelected()).getString("accessoryTypes"), ":");
        for (int i = 0; i < 15; ++i) {
            String currAvailableAccessory = StringList.get(accessoriesAvailable, i, ":");
            if (!currAvailableAccessory.equalsIgnoreCase("")) {
                this.accessoryList.get(i).setVisible(true);
                if (!this.fighter.accessoryTypes.contains(currAvailableAccessory)) continue;
                this.accessoryList.get(i).setChecked(true);
                continue;
            }
            this.accessoryList.get(i).setVisible(false);
            this.accessoryList.get(i).setChecked(false);
        }
        this.lArmsType.setVisible(true);
        this.lAccessories.setVisible(true);
        this.skinColor.setVisible(true);
        this.bodyColor.setVisible(true);
        this.accessoryColor.setVisible(true);
    }

    private void showColorPicker(String type) {
        this.pickColorFrame.setVisible(true);
        this.pickColor.setVisible(true);
        this.exitColorButton.setVisible(true);
        this.pickColor.params.put("type", type);
        for (EventListener currListener : this.pickColor.getListeners()) {
            this.pickColor.removeListener(currListener);
        }
        this.pickColor.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                Texture texture = EquipmentMenuScreen.this.pickColor.region.getTexture();
                if (!texture.getTextureData().isPrepared()) {
                    texture.getTextureData().prepare();
                }
                Pixmap pixmap = texture.getTextureData().consumePixmap();
                int colorInt = pixmap.getPixel(Float.valueOf((float)EquipmentMenuScreen.this.pickColor.region.getRegionX() + x).intValue(), Float.valueOf((float)EquipmentMenuScreen.this.pickColor.region.getRegionY() + ((float)EquipmentMenuScreen.this.pickColor.region.getRegionHeight() - y)).intValue());
                Color newColor = new Color();
                Color.rgba8888ToColor(newColor, colorInt);
                if (!newColor.toString().equalsIgnoreCase("00000000")) {
                    String type = (String)((BaseActor)event.getListenerActor()).params.get("type");
                    System.out.println("color:" + newColor.toString().toUpperCase());
                    if (type.equalsIgnoreCase("body")) {
                        EquipmentMenuScreen.this.fighter.bodyColor = newColor.toString();
                    } else if (type.equalsIgnoreCase("skin")) {
                        EquipmentMenuScreen.this.fighter.skinColor = newColor.toString();
                    } else {
                        EquipmentMenuScreen.this.fighter.accessoryColor = newColor.toString();
                    }
                    EquipmentMenuScreen.this.redrawFighter = true;
                }
            }
        });
    }

    private InputListener itemListener() {
        return new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                EquipmentMenuScreen.this.bodyType.setVisible(false);
                EquipmentMenuScreen.this.lBodyType.setVisible(false);
                EquipmentMenuScreen.this.bodySubType.setVisible(false);
                EquipmentMenuScreen.this.lBodySubType.setVisible(false);
                EquipmentMenuScreen.this.armsType.setVisible(false);
                for (int i = 0; i < EquipmentMenuScreen.this.accessoryList.size(); ++i) {
                    ((Button)EquipmentMenuScreen.this.accessoryList.get(i)).setVisible(false);
                }
                EquipmentMenuScreen.this.lArmsType.setVisible(false);
                EquipmentMenuScreen.this.lAccessories.setVisible(false);
                EquipmentMenuScreen.this.skinColor.setVisible(false);
                EquipmentMenuScreen.this.bodyColor.setVisible(false);
                EquipmentMenuScreen.this.accessoryColor.setVisible(false);
                Stack evStack = (Stack)event.getListenerActor();
                BaseActor evActor = null;
                for (Actor currActor : evStack.getChildren()) {
                    if (!(currActor instanceof BaseActor)) continue;
                    evActor = (BaseActor)currActor;
                    break;
                }
                EquipmentMenuScreen.this.selectedItem.setVisible(true);
                EquipmentMenuScreen.this.selectedItem.setTexture(evActor.region, (float)Float.valueOf(EquipmentMenuScreen.this.game.portraitmode ? EquipmentMenuScreen.this.charHelmet.getWidth() : EquipmentMenuScreen.this.charHelmet.getWidth() * 4.0f / 5.0f).intValue(), (float)Float.valueOf(EquipmentMenuScreen.this.game.portraitmode ? EquipmentMenuScreen.this.charHelmet.getWidth() : EquipmentMenuScreen.this.charHelmet.getWidth() * 4.0f / 5.0f).intValue());
                String itemId = (String)evActor.params.get("id");
                String itemType = (String)evActor.params.get("type");
                String realItemType = "armors";
                if (itemType.equalsIgnoreCase("weapons") || itemType.equalsIgnoreCase("offhand")) {
                    realItemType = "weapons";
                }
                String itemTier = (String)evActor.params.get("tier");
                EquipmentMenuScreen.this.selectedItem.params.put("id", itemId);
                EquipmentMenuScreen.this.selectedItem.params.put("type", itemType);
                EquipmentMenuScreen.this.selectedItem.params.put("tier", itemTier);
                EquipmentMenuScreen.this.selectedItemName.setVisible(true);
                EquipmentMenuScreen.this.selectedItemTier.setVisible(true);
                EquipmentMenuScreen.this.equipItem.setVisible(true);
                if (itemId.equalsIgnoreCase("empty")) {
                    EquipmentMenuScreen.this.selectedItemName.setText(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.combat.empty"));
                    EquipmentMenuScreen.this.selectedItemTier.setText(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.combat.empty"));
                    EquipmentMenuScreen.this.itemInfo.setVisible(false);
                    EquipmentMenuScreen.this.statsBackground.setVisible(false);
                    for (BaseActor currBar : EquipmentMenuScreen.this.statsBars) {
                        currBar.setVisible(false);
                    }
                } else {
                    EquipmentMenuScreen.this.selectedItemName.setText(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.items." + realItemType + ".name." + itemId));
                    UIHelpers.fixLabelFontSize(EquipmentMenuScreen.this.selectedItemName, EquipmentMenuScreen.this.game.viewHeight.floatValue() / EquipmentMenuScreen.this.game.heightBASE.floatValue(), EquipmentMenuScreen.this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 4.0f, 4.0f).floatValue(), 0.0f);
                    StringBuilder tierInfo = new StringBuilder();
                    tierInfo.append("[#D4D4D4]");
                    tierInfo.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "common.tier"));
                    tierInfo.append(": ");
                    tierInfo.append("[#A8A8A8]");
                    tierInfo.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.items.tiers.name." + itemTier));
                    EquipmentMenuScreen.this.selectedItemTier.setText(tierInfo.toString());
                    UIHelpers.fixLabelFontSize(EquipmentMenuScreen.this.selectedItemTier, EquipmentMenuScreen.this.game.viewHeight.floatValue() / EquipmentMenuScreen.this.game.heightBASE.floatValue(), EquipmentMenuScreen.this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 4.0f, 4.0f).floatValue(), 0.0f);
                    EquipmentMenuScreen.this.itemInfo.setVisible(true);
                    StringBuilder info = new StringBuilder();
                    JSONObject baseItem = (JSONObject)EquipmentMenuScreen.this.game.stats.get(realItemType).get(itemId);
                    JSONObject baseTier = (JSONObject)EquipmentMenuScreen.this.game.stats.get("tiers").get(itemTier);
                    if (realItemType.equalsIgnoreCase("armors")) {
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.combat.damage.reduction"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(baseItem.getInt("damageReduction") + baseTier.getInt("armor") * (itemId.equalsIgnoreCase("cuirass") ? 2 : 1) * (100 + EquipmentMenuScreen.this.tierBonus) / 100);
                        info.append("%");
                        info.append("\n");
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.combat.stamina.cost"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(Integer.parseInt(baseItem.getString("staminaCost")) / 10 + baseTier.getInt("armor") * (itemId.equalsIgnoreCase("cuirass") ? 2 : 1));
                        info.append("\n");
                        if (baseItem.has("attackTime")) {
                            info.append("[#D4D4D4]");
                            info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.combat.time.attack"));
                            info.append(": ");
                            info.append("[#A8A8A8]");
                            info.append("x");
                            info.append(String.format("%.2f", Float.valueOf(baseItem.getFloat("attackTime") + baseTier.getFloat("armor") / 100.0f)));
                            info.append("\n");
                        }
                        if (baseItem.has("dodgeTime")) {
                            info.append("[#D4D4D4]");
                            info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.combat.time.dodge"));
                            info.append(": ");
                            info.append("[#A8A8A8]");
                            info.append("x");
                            info.append(String.format("%.2f", Float.valueOf(baseItem.getFloat("dodgeTime") - baseTier.getFloat("armor") / 100.0f)));
                        }
                    } else if (itemType.equalsIgnoreCase("weapons")) {
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.combat.damage.base"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(Integer.parseInt(baseItem.getString("baseDamage")) * (100 + baseTier.getInt("weaponBaseDamage") * (100 + EquipmentMenuScreen.this.tierBonus) / 100) / 1000);
                        info.append("\n");
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.combat.critical.chance"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(Integer.parseInt(baseItem.getString("criticalChance")) * (100 + baseTier.getInt("weaponCriticalChance")) / 100);
                        info.append("%");
                        info.append("\n");
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.combat.stamina.cost"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(Integer.parseInt(baseItem.getString("staminaCost")) * (100 + baseTier.getInt("weaponStaminaCost")) / 1000);
                        info.append("\n");
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.combat.time.attack"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(String.format("%.3f", Float.valueOf(Float.parseFloat(baseItem.getString("attackTime")) * (100.0f + (float)baseTier.getInt("weaponAttackTime")) / 100.0f / 1000.0f)));
                        info.append("s");
                        info.append("\n");
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.combat.time.parry"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append("x");
                        info.append(itemId.equalsIgnoreCase("dagger") && (EquipmentMenuScreen.this.game.saveGame.isEmpty() || EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && EquipmentMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting") || EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("story") && EquipmentMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting")) ? "0.65" : baseItem.getString("parryTime"));
                        info.append("\n");
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.combat.time.dodge"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append("x");
                        info.append(itemId.equalsIgnoreCase("dagger") && (EquipmentMenuScreen.this.game.saveGame.isEmpty() || EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("tournament") && EquipmentMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting") || EquipmentMenuScreen.this.game.gameMode.equalsIgnoreCase("story") && EquipmentMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting")) ? "0.65" : baseItem.getString("dodgeTime"));
                    } else if (itemType.equalsIgnoreCase("offhand")) {
                        info.append("[#D4D4D4]");
                        info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.combat.offhand.bonus"));
                        info.append(": ");
                        info.append("[#A8A8A8]");
                        info.append(PropertiesReader.getMessage(EquipmentMenuScreen.this.game.gameMessages, "game.stats.items.weapons.offhand.bonus." + itemId));
                    }
                    EquipmentMenuScreen.this.itemInfo.setText(info.toString());
                    EquipmentMenuScreen.this.itemInfo.layout();
                    if (itemType.equalsIgnoreCase("weapons")) {
                        float prefHeightSafeguard = EquipmentMenuScreen.this.itemInfo.getPrefHeight();
                        float ySafeguard = EquipmentMenuScreen.this.itemBackground.getY() + EquipmentMenuScreen.this.itemBackground.getHeight() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 3.0f, 3.0f).floatValue();
                        EquipmentMenuScreen.this.statsBackground.setHeight(prefHeightSafeguard + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue());
                        EquipmentMenuScreen.this.statsBackground.setWidth(EquipmentMenuScreen.this.statsBackground.getHeight());
                        EquipmentMenuScreen.this.statsBackground.setX(MathUtils.clamp(EquipmentMenuScreen.this.selectedItemName.getX() + EquipmentMenuScreen.this.selectedItemName.getPrefWidth(), EquipmentMenuScreen.this.selectedItem.getX() + EquipmentMenuScreen.this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.5f, 3.0f).floatValue(), EquipmentMenuScreen.this.itemBackground.getX() + EquipmentMenuScreen.this.itemBackground.getWidth()));
                        EquipmentMenuScreen.this.statsBackground.setY(ySafeguard - prefHeightSafeguard - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 3.0f, 3.0f).floatValue());
                        EquipmentMenuScreen.this.statsBackground.setVisible(true);
                        float baseDamage = baseItem.getFloat("baseDamage") * (100.0f + baseTier.getFloat("weaponBaseDamage") * (100.0f + (float)EquipmentMenuScreen.this.tierBonus) / 100.0f) / 100.0f;
                        EquipmentMenuScreen.this.statsBars.get(0).setWidth((baseDamage - EquipmentMenuScreen.this.weaponStats.get("baseDamage").get(0).floatValue()) / (EquipmentMenuScreen.this.weaponStats.get("baseDamage").get(1).floatValue() - EquipmentMenuScreen.this.weaponStats.get("baseDamage").get(0).floatValue()) * (EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                        if (EquipmentMenuScreen.this.statsBars.get(0).getWidth() == 0.0f) {
                            EquipmentMenuScreen.this.statsBars.get(0).setWidth((EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                        }
                        EquipmentMenuScreen.this.statsBars.get(0).setHeight((EquipmentMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(0).setX(EquipmentMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                        EquipmentMenuScreen.this.statsBars.get(0).setY(EquipmentMenuScreen.this.statsBackground.getY() + EquipmentMenuScreen.this.statsBackground.getHeight() * 83.5f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(0).setVisible(true);
                        float criticalChance = baseItem.getFloat("criticalChance") * (float)(100 + baseTier.getInt("weaponCriticalChance")) / 100.0f;
                        EquipmentMenuScreen.this.statsBars.get(1).setWidth((criticalChance - EquipmentMenuScreen.this.weaponStats.get("criticalChance").get(0).floatValue()) / (EquipmentMenuScreen.this.weaponStats.get("criticalChance").get(1).floatValue() - EquipmentMenuScreen.this.weaponStats.get("criticalChance").get(0).floatValue()) * (EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                        if (EquipmentMenuScreen.this.statsBars.get(1).getWidth() == 0.0f) {
                            EquipmentMenuScreen.this.statsBars.get(1).setWidth((EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                        }
                        EquipmentMenuScreen.this.statsBars.get(1).setHeight((EquipmentMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(1).setX(EquipmentMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                        EquipmentMenuScreen.this.statsBars.get(1).setY(EquipmentMenuScreen.this.statsBackground.getY() + EquipmentMenuScreen.this.statsBackground.getHeight() * 68.5f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(1).setVisible(true);
                        float staminaCost = baseItem.getFloat("staminaCost") * (float)(100 + baseTier.getInt("weaponStaminaCost")) / 100.0f;
                        EquipmentMenuScreen.this.statsBars.get(2).setWidth((1.0f - (staminaCost - EquipmentMenuScreen.this.weaponStats.get("staminaCost").get(0).floatValue()) / (EquipmentMenuScreen.this.weaponStats.get("staminaCost").get(1).floatValue() - EquipmentMenuScreen.this.weaponStats.get("staminaCost").get(0).floatValue())) * (EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                        if (EquipmentMenuScreen.this.statsBars.get(2).getWidth() == 0.0f) {
                            EquipmentMenuScreen.this.statsBars.get(2).setWidth((EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                        }
                        EquipmentMenuScreen.this.statsBars.get(2).setHeight((EquipmentMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(2).setX(EquipmentMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                        EquipmentMenuScreen.this.statsBars.get(2).setY(EquipmentMenuScreen.this.statsBackground.getY() + EquipmentMenuScreen.this.statsBackground.getHeight() * 53.5f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(2).setVisible(true);
                        float attackTime = baseItem.getFloat("attackTime") * (float)(100 + baseTier.getInt("weaponAttackTime")) / 100.0f;
                        EquipmentMenuScreen.this.statsBars.get(3).setWidth((1.0f - (attackTime - EquipmentMenuScreen.this.weaponStats.get("attackTime").get(0).floatValue()) / (EquipmentMenuScreen.this.weaponStats.get("attackTime").get(1).floatValue() - EquipmentMenuScreen.this.weaponStats.get("attackTime").get(0).floatValue())) * (EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                        if (EquipmentMenuScreen.this.statsBars.get(3).getWidth() == 0.0f) {
                            EquipmentMenuScreen.this.statsBars.get(3).setWidth((EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                        }
                        EquipmentMenuScreen.this.statsBars.get(3).setHeight((EquipmentMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(3).setX(EquipmentMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                        EquipmentMenuScreen.this.statsBars.get(3).setY(EquipmentMenuScreen.this.statsBackground.getY() + EquipmentMenuScreen.this.statsBackground.getHeight() * 38.5f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(3).setVisible(true);
                        float parryTime = baseItem.getFloat("parryTime");
                        if (itemId.equalsIgnoreCase("dagger") && (EquipmentMenuScreen.this.game.saveGame.isEmpty() || EquipmentMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting"))) {
                            parryTime = 0.75f;
                        }
                        EquipmentMenuScreen.this.statsBars.get(4).setWidth((1.0f - (parryTime - EquipmentMenuScreen.this.weaponStats.get("parryTime").get(0).floatValue()) / (EquipmentMenuScreen.this.weaponStats.get("parryTime").get(1).floatValue() - EquipmentMenuScreen.this.weaponStats.get("parryTime").get(0).floatValue())) * (EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                        if (EquipmentMenuScreen.this.statsBars.get(4).getWidth() == 0.0f) {
                            EquipmentMenuScreen.this.statsBars.get(4).setWidth((EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                        }
                        EquipmentMenuScreen.this.statsBars.get(4).setHeight((EquipmentMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(4).setX(EquipmentMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                        EquipmentMenuScreen.this.statsBars.get(4).setY(EquipmentMenuScreen.this.statsBackground.getY() + EquipmentMenuScreen.this.statsBackground.getHeight() * 24.0f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(4).setVisible(true);
                        float dodgeTime = baseItem.getFloat("dodgeTime");
                        if (itemId.equalsIgnoreCase("dagger") && (EquipmentMenuScreen.this.game.saveGame.isEmpty() || EquipmentMenuScreen.this.game.saveGame.get("rewards").contains("dagger-fighting"))) {
                            dodgeTime = 0.75f;
                        }
                        EquipmentMenuScreen.this.statsBars.get(5).setWidth((1.0f - (dodgeTime - EquipmentMenuScreen.this.weaponStats.get("dodgeTime").get(0).floatValue()) / (EquipmentMenuScreen.this.weaponStats.get("dodgeTime").get(1).floatValue() - EquipmentMenuScreen.this.weaponStats.get("dodgeTime").get(0).floatValue())) * (EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()));
                        if (EquipmentMenuScreen.this.statsBars.get(5).getWidth() == 0.0f) {
                            EquipmentMenuScreen.this.statsBars.get(5).setWidth((EquipmentMenuScreen.this.statsBackground.getWidth() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) / 100.0f);
                        }
                        EquipmentMenuScreen.this.statsBars.get(5).setHeight((EquipmentMenuScreen.this.statsBackground.getHeight() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue()) * 7.7f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(5).setX(EquipmentMenuScreen.this.statsBackground.getX() + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 1.0f, 1.0f).floatValue());
                        EquipmentMenuScreen.this.statsBars.get(5).setY(EquipmentMenuScreen.this.statsBackground.getY() + EquipmentMenuScreen.this.statsBackground.getHeight() * 9.5f / 100.0f);
                        EquipmentMenuScreen.this.statsBars.get(5).setVisible(true);
                        EquipmentMenuScreen.this.itemInfo.setX(EquipmentMenuScreen.this.statsBackground.getX() + EquipmentMenuScreen.this.statsBackground.getWidth() + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 1.5f, 2.0f).floatValue());
                        EquipmentMenuScreen.this.itemInfo.setY(EquipmentMenuScreen.this.itemBackground.getY() + EquipmentMenuScreen.this.itemBackground.getHeight() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 4.75f, 4.75f).floatValue());
                    } else {
                        EquipmentMenuScreen.this.statsBackground.setVisible(false);
                        for (BaseActor currBar : EquipmentMenuScreen.this.statsBars) {
                            currBar.setVisible(false);
                        }
                        EquipmentMenuScreen.this.itemInfo.setX(MathUtils.clamp(EquipmentMenuScreen.this.selectedItemName.getX() + EquipmentMenuScreen.this.selectedItemName.getPrefWidth(), EquipmentMenuScreen.this.selectedItem.getX() + EquipmentMenuScreen.this.selectedItem.getWidth() + UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 2.0f, 2.0f).floatValue(), EquipmentMenuScreen.this.itemBackground.getX() + EquipmentMenuScreen.this.itemBackground.getWidth()));
                        EquipmentMenuScreen.this.itemInfo.setY(EquipmentMenuScreen.this.itemBackground.getY() + EquipmentMenuScreen.this.itemBackground.getHeight() - UIHelpers.calcHeightProportion(EquipmentMenuScreen.this.game, 4.0f, 4.0f).floatValue());
                    }
                    EquipmentMenuScreen.this.stage.setScrollFocus(EquipmentMenuScreen.this.itemPane);
                    if (EquipmentMenuScreen.this.game.portraitmode) {
                        EquipmentMenuScreen.this.itemPane.setScrollX(EquipmentMenuScreen.this.itemPane.getScrollX());
                    } else {
                        EquipmentMenuScreen.this.itemPane.setScrollY(EquipmentMenuScreen.this.itemPane.getScrollY());
                    }
                }
            }
        };
    }

    private int equipmentLimit() {
        if (this.game.gameMode.equalsIgnoreCase("story") && this.game.saveGame.get("phase").equalsIgnoreCase("pits")) {
            return 1;
        }
        return 2;
    }

    private void drawFighter(String status, String direction) {
        String suffix = status;
        String weaponType = this.game.stats.get("weapons").getJSONObject(this.fighter.weapon.id).getString("type");
        if (weaponType.equalsIgnoreCase("2h3")) {
            weaponType = suffix.equalsIgnoreCase("middle") || suffix.startsWith("hit") ? "2h2" : "2h1";
        }
        this.fighterSkin.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.skinType + this.fighter.bodySubType + "skin.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        this.fighterSkin.setColor(Color.valueOf(this.fighter.skinColor));
        this.fighterBody.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.bodyType + this.fighter.bodySubType + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        this.fighterBody.setColor(Color.valueOf(this.fighter.bodyColor));
        for (int i = 0; i < this.fighterAccessories.size(); ++i) {
            this.fighterAccessories.get(i).setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        StringBuilder chosenAccessories = StringList.create(this.fighter.accessoryTypes, ":");
        for (int i = 0; i < StringList.size(chosenAccessories, ":"); ++i) {
            this.fighterAccessories.get(i).setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/bodycomp" + this.fighter.bodyType + "" + this.fighter.bodySubType + StringList.get(chosenAccessories, i, ":") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterAccessories.get(i).setColor(Color.valueOf(this.fighter.accessoryColor));
        }
        if (this.fighter.head != null && !this.fighter.special.contains("nohel")) {
            this.fighterHead.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.headType + this.fighter.portrait + this.game.stats.get("tiers").getJSONObject(this.fighter.head.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        } else {
            this.fighterHead.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.headType + this.fighter.portrait + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        this.fighterArms.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/arms" + weaponType + suffix + this.fighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        this.fighterArms.setColor(Color.valueOf(this.fighter.skinColor));
        if (this.fighter.arms != null && !this.fighter.special.contains("noarmsarmor")) {
            if (!this.fighter.special.contains("noaasl")) {
                this.fighterArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmssl" + weaponType + suffix + this.fighter.armsType + this.game.stats.get("tiers").getJSONObject(this.fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
            if (!this.fighter.special.contains("noaabra") && !this.fighter.special.contains("noaabrl")) {
                this.fighterArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsbrl" + weaponType + suffix + this.fighter.armsType + this.game.stats.get("tiers").getJSONObject(this.fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
            if (!this.fighter.special.contains("noaabra") && !this.fighter.special.contains("noaabrr")) {
                this.fighterArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsbrr" + weaponType + suffix + this.fighter.armsType + this.game.stats.get("tiers").getJSONObject(this.fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
            if (!this.fighter.special.contains("noaaspa") && !this.fighter.special.contains("noaaspl")) {
                this.fighterArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsspl" + weaponType + suffix + this.fighter.armsType + this.game.stats.get("tiers").getJSONObject(this.fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
            if (!this.fighter.special.contains("noaaspa") && !this.fighter.special.contains("noaaspr")) {
                this.fighterArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsspr" + weaponType + suffix + this.fighter.armsType + this.game.stats.get("tiers").getJSONObject(this.fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
        } else {
            this.fighterArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        if (this.fighter.body != null) {
            if (!this.fighter.special.contains("nocut")) {
                this.fighterBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + this.fighter.bodyType + this.fighter.bodySubType + this.game.stats.get("tiers").getJSONObject(this.fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
            if (!this.fighter.special.contains("nocul")) {
                this.fighterBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyl" + this.fighter.bodyType + this.fighter.bodySubType + this.game.stats.get("tiers").getJSONObject(this.fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
        } else {
            this.fighterBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.fighter.bodyType).getString("skinExtra"), ":"), "body" + this.fighter.bodyType + this.fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
            this.fighterSkinExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.bodyType + this.fighter.bodySubType + "skin" + weaponType + suffix + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterSkinExtra.setColor(Color.valueOf(this.fighter.skinColor));
            if (this.fighter.body != null && !this.fighter.special.contains("nocut")) {
                this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + this.fighter.bodyType + weaponType + suffix + this.game.stats.get("tiers").getJSONObject(this.fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
        } else {
            this.fighterSkinExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.fighter.bodyType).getString("bodyExtra"), ":"), "body" + this.fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
            this.fighterBodyExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.bodyType + weaponType + suffix + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterBodyExtra.setColor(Color.valueOf(this.fighter.bodyColor));
            if (this.fighter.body != null && !this.fighter.special.contains("nocut")) {
                this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + this.fighter.bodyType + weaponType + suffix + this.game.stats.get("tiers").getJSONObject(this.fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
        } else {
            this.fighterBodyExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        if (this.fighter.offHand != null) {
            this.fighterOffHand.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.fighter.offHand.id + this.game.stats.get("tiers").getJSONObject(this.fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + this.fighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        } else {
            this.fighterOffHand.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        if (suffix.equalsIgnoreCase("hit")) {
            suffix = suffix + direction.substring(0, 1);
        }
        this.fighterWeapon.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.fighter.weapon.id + this.game.stats.get("tiers").getJSONObject(this.fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + this.fighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        this.fighterCharacter.clearActions();
        this.fighterCharacter.setScale(Float.parseFloat(this.fighter.size), Float.parseFloat(this.fighter.size));
        RepeatAction idleMotion = new RepeatAction();
        idleMotion.setAction(Actions.sequence((Action)Actions.scaleTo(Float.parseFloat(this.fighter.size), Float.parseFloat(this.fighter.size) + 0.005f, 1.5f), (Action)Actions.scaleTo(Float.parseFloat(this.fighter.size), Float.parseFloat(this.fighter.size), 1.5f)));
        idleMotion.setCount(-1);
        this.fighterCharacter.addAction(idleMotion);
    }
}

