/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.MoveToAction;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.CreditsScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.ArrayList;

public class EndScreen
extends BaseScreen {
    public String musicTrack = "";
    public ArrayList<String> backgroundImages = new ArrayList();
    public String weapon = "";
    public String story = "";
    public String endStage = "shoutBoss";
    public float timeElapsed = 0.0f;
    private ArrayList<FrameBuffer> listFrameBuffer = new ArrayList();
    public float backgroundDeadShoutX = 0.0f;
    public BaseActor backgroundDeadShout;

    public EndScreen(SlavePitsGame g, String selWeapon) {
        super(g);
        this.weapon = selWeapon;
        this.create();
    }

    @Override
    public void create() {
        if (this.game.track != null && this.game.track.isPlaying()) {
            this.game.track.stop();
            this.game.track.dispose();
        }
        this.game.track = Gdx.audio.newMusic(Gdx.files.internal(this.game.getOverridenFilename("music/sl14e.ogg")));
        this.game.track.setLooping(false);
        this.game.track.setVolume(this.game.musicVolume);
        this.game.track.play();
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        BaseActor talkDirection = new BaseActor();
        talkDirection.setTexture(uiAtlas.findRegion("talkdirection"), UIHelpers.calcHeightProportion(this.game, 12.5f, 10.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue());
        talkDirection.setVisible(false);
        talkDirection.setX(UIHelpers.calcHeightProportion(this.game, 80.0f, 47.0f).floatValue());
        talkDirection.setY(UIHelpers.calcHeightProportion(this.game, 75.0f, 70.0f).floatValue());
        talkDirection.setVisible(false);
        this.stage.addActor(talkDirection);
        SequenceAction action1 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(0.1f), Actions.alpha(1.0f, 0.1f), Actions.delay(0.6f), Actions.hide());
        talkDirection.addAction(action1);
        BaseActor talkBackground = new BaseActor();
        talkBackground.setTexture(uiAtlas.findRegion("talkbackground"), UIHelpers.calcHeightProportion(this.game, 25.0f, 21.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 5.0f, 10.0f).floatValue());
        talkBackground.setVisible(false);
        talkBackground.setX(UIHelpers.calcHeightProportion(this.game, 87.0f, 50.0f).floatValue());
        talkBackground.setY(UIHelpers.calcHeightProportion(this.game, 80.0f, 75.0f).floatValue() - talkBackground.getHeight());
        talkBackground.setVisible(false);
        this.stage.addActor(talkBackground);
        SequenceAction action2 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(0.1f), Actions.alpha(1.0f, 0.1f), Actions.delay(0.6f), Actions.hide());
        talkBackground.addAction(action2);
        Label talkSentence = new Label("", this.game.uiSkin, "default");
        talkSentence.setAlignment(10);
        talkSentence.setColor(this.game.uiSkin.get("lightgrey", Color.class));
        talkSentence.setWrap(true);
        talkSentence.setVisible(false);
        talkSentence.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        talkSentence.setWidth(UIHelpers.calcHeightProportion(this.game, 22.0f, 19.0f).floatValue());
        talkSentence.setX(UIHelpers.calcHeightProportion(this.game, 89.0f, 51.0f).floatValue());
        talkSentence.setText(PropertiesReader.getMessage(this.game.gameMessages, "zone.lore.12"));
        talkSentence.layout();
        talkBackground.setHeight(talkSentence.getPrefHeight() + UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        talkBackground.setY(UIHelpers.calcHeightProportion(this.game, 80.0f, 75.0f).floatValue() - talkBackground.getHeight());
        talkSentence.setY(UIHelpers.calcHeightProportion(this.game, 79.0f, 74.0f).floatValue());
        this.stage.addActor(talkSentence);
        SequenceAction action3 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(0.1f), Actions.alpha(1.0f, 0.1f), Actions.delay(0.6f), Actions.hide());
        talkSentence.addAction(action3);
        BaseActor backgroundEyes = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundEyes, this.game.getOverridenFilename("data/backgrounds/fieryEyes.jpg"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/fieryEyes.jpg");
        backgroundEyes.setVisible(false);
        this.stage.addActor(backgroundEyes);
        SequenceAction action4 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(1.0f), Actions.alpha(1.0f, 0.3f), Actions.delay(1.2f), Actions.hide());
        backgroundEyes.addAction(action4);
        BaseActor backgroundTeeth = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundTeeth, this.game.getOverridenFilename("data/backgrounds/fieryTeeth.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/fieryTeeth.png");
        backgroundTeeth.setVisible(false);
        this.stage.addActor(backgroundTeeth);
        SequenceAction action5 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(1.7f), Actions.alpha(1.0f, 0.3f), Actions.delay(0.5f), Actions.hide());
        backgroundTeeth.addAction(action5);
        BaseActor redBackground = new BaseActor();
        redBackground.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/white.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
        redBackground.setColor(1.0f, 0.25f, 0.25f, 1.0f);
        redBackground.setPosition(0.0f, 0.0f);
        redBackground.setVisible(false);
        this.stage.addActor(redBackground);
        SequenceAction action60 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(2.5f), Actions.alpha(1.0f), Actions.delay(2.0f), Actions.color(new Color(0.0f, 0.0f, 0.0f, 1.0f), 1.0f), Actions.alpha(0.0f, 0.3f));
        redBackground.addAction(action60);
        this.backgroundDeadShout = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, this.backgroundDeadShout, this.game.getOverridenFilename("data/backgrounds/deadShout.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundDeadShoutX = this.backgroundDeadShout.getX();
        this.backgroundImages.add("data/backgrounds/deadShout.png");
        this.backgroundDeadShout.setVisible(false);
        this.stage.addActor(this.backgroundDeadShout);
        SequenceAction action6 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(2.5f), Actions.alpha(1.0f, 0.3f), Actions.delay(2.0f), Actions.color(new Color(0.0f, 0.0f, 0.0f, 1.0f), 1.0f), Actions.alpha(0.0f, 0.3f));
        this.backgroundDeadShout.addAction(action6);
        BaseActor backgroundDeadTarget = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundDeadTarget, this.game.getOverridenFilename("data/backgrounds/deadTarget.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), -this.game.viewWidth.floatValue() / 10.0f, -this.game.viewHeight.floatValue() / 20.0f);
        this.backgroundImages.add("data/backgrounds/deadTarget.png");
        backgroundDeadTarget.setVisible(false);
        this.stage.addActor(backgroundDeadTarget);
        MoveToAction jumpAction1 = Actions.action(MoveToAction.class);
        jumpAction1.setPosition(backgroundDeadTarget.getX() + this.game.viewWidth.floatValue() / 10.0f, backgroundDeadTarget.getY() + this.game.viewHeight.floatValue() / 20.0f);
        jumpAction1.setDuration(0.5f);
        jumpAction1.setInterpolation(Interpolation.circleOut);
        SequenceAction action7 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(2.5f), Actions.parallel((Action)Actions.alpha(1.0f, 0.3f), (Action)jumpAction1), Actions.delay(2.0f), Actions.color(new Color(0.0f, 0.0f, 0.0f, 1.0f), 1.0f), Actions.alpha(0.0f, 0.3f));
        backgroundDeadTarget.addAction(action7);
        BaseActor backgroundDeadAttack = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundDeadAttack, this.game.getOverridenFilename("data/backgrounds/deadAttack.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), -this.game.viewWidth.floatValue() / 5.0f, -this.game.viewHeight.floatValue() / 20.0f);
        this.backgroundImages.add("data/backgrounds/deadAttack.png");
        backgroundDeadAttack.setVisible(false);
        this.stage.addActor(backgroundDeadAttack);
        MoveToAction jumpAction2 = Actions.action(MoveToAction.class);
        jumpAction2.setPosition(backgroundDeadAttack.getX() + this.game.viewWidth.floatValue() / 5.0f, backgroundDeadTarget.getY() + this.game.viewHeight.floatValue() / 20.0f);
        jumpAction2.setDuration(0.5f);
        jumpAction2.setInterpolation(Interpolation.circleOut);
        SequenceAction action8 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(2.5f), Actions.parallel((Action)Actions.alpha(1.0f, 0.3f), (Action)jumpAction2), Actions.delay(3.0f), Actions.alpha(0.0f, 0.3f));
        backgroundDeadAttack.addAction(action8);
        BaseActor backgroundDeadWeapon = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundDeadWeapon, this.game.getOverridenFilename("data/backgrounds/dead" + this.weapon.substring(0, 1).toUpperCase() + this.weapon.substring(1) + ".png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), -this.game.viewWidth.floatValue() / 5.0f, -this.game.viewHeight.floatValue() / 20.0f);
        this.backgroundImages.add("data/backgrounds/dead" + this.weapon.substring(0, 1).toUpperCase() + this.weapon.substring(1) + ".png");
        backgroundDeadWeapon.setVisible(false);
        this.stage.addActor(backgroundDeadWeapon);
        MoveToAction jumpAction3 = Actions.action(MoveToAction.class);
        jumpAction3.setPosition(backgroundDeadWeapon.getX() + this.game.viewWidth.floatValue() / 5.0f, backgroundDeadTarget.getY() + this.game.viewHeight.floatValue() / 20.0f);
        jumpAction3.setDuration(0.5f);
        jumpAction3.setInterpolation(Interpolation.circleOut);
        SequenceAction action9 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(2.5f), Actions.parallel((Action)Actions.alpha(1.0f, 0.3f), (Action)jumpAction3), Actions.delay(3.0f), Actions.alpha(0.0f, 0.3f));
        backgroundDeadWeapon.addAction(action9);
        BaseActor backgroundLore9 = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundLore9, this.game.getOverridenFilename("data/backgrounds/backgroundLore9.jpg"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/backgroundLore9.jpg");
        backgroundLore9.setVisible(false);
        this.stage.addActor(backgroundLore9);
        SequenceAction action10 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(8.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(50.0f), Actions.alpha(0.0f, 0.5f), Actions.delay(26.0f), Actions.alpha(1.0f, 0.5f), Actions.delay(37.5f), Actions.alpha(0.0f, 0.5f));
        backgroundLore9.addAction(action10);
        if (!this.game.violenceFilter) {
            BaseActor backgroundLore9blood = new BaseActor();
            UIHelpers.portraitModeFixBackground(this.game, backgroundLore9blood, this.game.getOverridenFilename("data/backgrounds/backgroundLore9blood.png"), this.game.viewWidth.floatValue() / 3.0f, this.game.viewHeight.floatValue() / 3.0f, UIHelpers.calcWidthProportion(this.game, 21.0f, -21.0f).floatValue(), this.game.viewHeight.floatValue() / 6.0f);
            this.backgroundImages.add("data/backgrounds/backgroundLore9blood.png");
            backgroundLore9blood.setVisible(false);
            this.stage.addActor(backgroundLore9blood);
            SequenceAction action11 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(8.0f), Actions.alpha(1.0f, 1.0f), Actions.parallel((Action)Actions.sizeTo(1440.0f, this.game.viewHeight.floatValue(), 50.0f), (Action)Actions.moveTo(this.game.portraitmode ? -(1440.0f - this.game.viewWidth.floatValue()) / 2.0f : 0.0f, 0.0f, 50.0f)), Actions.alpha(0.0f, 0.5f), Actions.delay(26.0f), Actions.alpha(1.0f, 0.5f), Actions.delay(37.5f), Actions.alpha(0.0f, 0.5f));
            backgroundLore9blood.addAction(action11);
        }
        BaseActor backgroundLore9dead = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundLore9dead, this.game.getOverridenFilename("data/backgrounds/backgroundLore9dead.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/backgroundLore9dead.png");
        backgroundLore9dead.setVisible(false);
        this.stage.addActor(backgroundLore9dead);
        SequenceAction action12 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(8.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(50.0f), Actions.alpha(0.0f, 0.5f), Actions.delay(26.0f), Actions.alpha(1.0f, 0.5f), Actions.delay(37.5f), Actions.alpha(0.0f, 0.5f));
        backgroundLore9dead.addAction(action12);
        BaseActor backgroundLore9floor = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundLore9floor, this.game.getOverridenFilename("data/backgrounds/backgroundLore9floor.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/backgroundLore9floor.png");
        backgroundLore9floor.setVisible(false);
        this.stage.addActor(backgroundLore9floor);
        SequenceAction action14 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(111.5f), Actions.alpha(1.0f, 0.5f), Actions.delay(10.5f), Actions.alpha(0.0f, 0.5f));
        backgroundLore9floor.addAction(action14);
        BaseActor backgroundLore9dust = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundLore9dust, this.game.getOverridenFilename("data/backgrounds/backgroundLore9dust.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/backgroundLore9dust.png");
        backgroundLore9dust.setVisible(false);
        this.stage.addActor(backgroundLore9dust);
        SequenceAction action30 = Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.show(), (Action)Actions.delay(111.5f), (Action)Actions.alpha(0.5f, 1.0f), (Action)Actions.alpha(0.0f, 0.5f));
        backgroundLore9dust.addAction(action30);
        BaseActor backgroundLore9kneel = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundLore9kneel, this.game.getOverridenFilename("data/backgrounds/backgroundLore9kneel.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/backgroundLore9kneel.png");
        backgroundLore9kneel.setVisible(false);
        this.stage.addActor(backgroundLore9kneel);
        SequenceAction action13 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(8.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(50.0f), Actions.alpha(0.0f, 0.5f), Actions.delay(26.0f), Actions.alpha(1.0f, 0.5f), Actions.delay(25.5f), Actions.alpha(0.0f, 0.5f), Actions.delay(10.5f), Actions.alpha(1.0f, 0.5f), Actions.delay(0.5f), Actions.alpha(0.0f, 1.0f));
        backgroundLore9kneel.addAction(action13);
        String story = PropertiesReader.getMessage(this.game.gameMessages, "zone.lore.11", this.game.violenceFilter);
        NinePatchActor textOverlay1 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay1);
        Label storyLabel1 = new Label("", this.game.uiSkin, "default");
        storyLabel1.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel1.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel1.setAlignment(10);
        storyLabel1.setWrap(true);
        storyLabel1.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel1.setText(story.split("\n\n")[0].split("\n")[0]);
        storyLabel1.setX(UIHelpers.calcWidthProportion(this.game, 10.0f, 10.0f).floatValue());
        storyLabel1.setY(UIHelpers.calcHeightProportion(this.game, 85.0f, 85.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel1, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel1.setVisible(false);
        this.stage.addActor(storyLabel1);
        SequenceAction action21 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(13.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(45.0f), Actions.alpha(0.0f, 0.5f));
        storyLabel1.addAction(action21);
        textOverlay1.getColor().a = 0.75f;
        textOverlay1.setWidth(storyLabel1.getWidth() * 108.0f / 100.0f);
        textOverlay1.setHeight(storyLabel1.getPrefHeight() * 108.0f / 100.0f);
        textOverlay1.setX(storyLabel1.getX() - storyLabel1.getWidth() * 4.0f / 100.0f);
        textOverlay1.setY(storyLabel1.getY() - storyLabel1.getPrefHeight() - storyLabel1.getPrefHeight() * 4.0f / 100.0f);
        textOverlay1.setVisible(false);
        SequenceAction action211 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(13.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(45.0f), Actions.alpha(0.0f, 0.5f));
        textOverlay1.addAction(action211);
        NinePatchActor textOverlay2 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay2);
        Label storyLabel2 = new Label("", this.game.uiSkin, "default");
        storyLabel2.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel2.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel2.setAlignment(10);
        storyLabel2.setWrap(true);
        storyLabel2.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel2.setText(story.split("\n\n")[0].split("\n")[1]);
        storyLabel2.setX(UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        storyLabel2.setY(UIHelpers.calcHeightProportion(this.game, 70.0f, 70.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel2, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel2.setVisible(false);
        this.stage.addActor(storyLabel2);
        SequenceAction action22 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(23.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(35.0f), Actions.alpha(0.0f, 0.5f));
        storyLabel2.addAction(action22);
        textOverlay2.getColor().a = 0.75f;
        textOverlay2.setWidth(storyLabel2.getWidth() * 108.0f / 100.0f);
        textOverlay2.setHeight(storyLabel2.getPrefHeight() * 108.0f / 100.0f);
        textOverlay2.setX(storyLabel2.getX() - storyLabel2.getWidth() * 4.0f / 100.0f);
        textOverlay2.setY(storyLabel2.getY() - storyLabel2.getPrefHeight() - storyLabel2.getPrefHeight() * 4.0f / 100.0f);
        textOverlay2.setVisible(false);
        SequenceAction action221 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(23.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(35.0f), Actions.alpha(0.0f, 0.5f));
        textOverlay2.addAction(action221);
        NinePatchActor textOverlay3 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay3);
        Label storyLabel3 = new Label("", this.game.uiSkin, "default");
        storyLabel3.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel3.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel3.setAlignment(10);
        storyLabel3.setWrap(true);
        storyLabel3.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel3.setText(story.split("\n\n")[0].split("\n")[2]);
        storyLabel3.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue());
        storyLabel3.setY(UIHelpers.calcHeightProportion(this.game, 35.0f, 35.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel3, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel3.setVisible(false);
        this.stage.addActor(storyLabel3);
        SequenceAction action23 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(33.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(25.0f), Actions.alpha(0.0f, 0.5f));
        storyLabel3.addAction(action23);
        textOverlay3.getColor().a = 0.75f;
        textOverlay3.setWidth(storyLabel3.getWidth() * 108.0f / 100.0f);
        textOverlay3.setHeight(storyLabel3.getPrefHeight() * 108.0f / 100.0f);
        textOverlay3.setX(storyLabel3.getX() - storyLabel3.getWidth() * 4.0f / 100.0f);
        textOverlay3.setY(storyLabel3.getY() - storyLabel3.getPrefHeight() - storyLabel3.getPrefHeight() * 4.0f / 100.0f);
        textOverlay3.setVisible(false);
        SequenceAction action231 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(33.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(25.0f), Actions.alpha(0.0f, 0.5f));
        textOverlay3.addAction(action231);
        NinePatchActor textOverlay4 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay4);
        Label storyLabel4 = new Label("", this.game.uiSkin, "default");
        storyLabel4.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel4.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel4.setAlignment(10);
        storyLabel4.setWrap(true);
        storyLabel4.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel4.setText(story.split("\n\n")[0].split("\n")[3]);
        storyLabel4.setX(UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue());
        storyLabel4.setY(UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel4, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel4.setVisible(false);
        this.stage.addActor(storyLabel4);
        SequenceAction action24 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(43.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(15.0f), Actions.alpha(0.0f, 0.5f));
        storyLabel4.addAction(action24);
        textOverlay4.getColor().a = 0.75f;
        textOverlay4.setWidth(storyLabel4.getWidth() * 108.0f / 100.0f);
        textOverlay4.setHeight(storyLabel4.getPrefHeight() * 108.0f / 100.0f);
        textOverlay4.setX(storyLabel4.getX() - storyLabel4.getWidth() * 4.0f / 100.0f);
        textOverlay4.setY(storyLabel4.getY() - storyLabel4.getPrefHeight() - storyLabel4.getPrefHeight() * 4.0f / 100.0f);
        textOverlay4.setVisible(false);
        SequenceAction action241 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(43.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(15.0f), Actions.alpha(0.0f, 0.5f));
        textOverlay4.addAction(action241);
        NinePatchActor textOverlay9 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay9);
        Label storyLabel9 = new Label("", this.game.uiSkin, "default");
        storyLabel9.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel9.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel9.setAlignment(10);
        storyLabel9.setWrap(true);
        storyLabel9.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel9.setText(story.split("\n\n")[2].split("\n")[0]);
        storyLabel9.setX(UIHelpers.calcWidthProportion(this.game, 10.0f, 10.0f).floatValue());
        storyLabel9.setY(UIHelpers.calcHeightProportion(this.game, 85.0f, 85.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel9, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel9.setVisible(false);
        this.stage.addActor(storyLabel9);
        SequenceAction action91 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(88.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(35.0f), Actions.alpha(0.0f, 0.5f));
        storyLabel9.addAction(action91);
        textOverlay9.getColor().a = 0.75f;
        textOverlay9.setWidth(storyLabel9.getWidth() * 108.0f / 100.0f);
        textOverlay9.setHeight(storyLabel9.getPrefHeight() * 108.0f / 100.0f);
        textOverlay9.setX(storyLabel9.getX() - storyLabel9.getWidth() * 4.0f / 100.0f);
        textOverlay9.setY(storyLabel9.getY() - storyLabel9.getPrefHeight() - storyLabel9.getPrefHeight() * 4.0f / 100.0f);
        textOverlay9.setVisible(false);
        SequenceAction action291 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(88.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(35.0f), Actions.alpha(0.0f, 0.5f));
        textOverlay9.addAction(action291);
        NinePatchActor textOverlay10 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay10);
        Label storyLabel10 = new Label("", this.game.uiSkin, "default");
        storyLabel10.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel10.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel10.setAlignment(10);
        storyLabel10.setWrap(true);
        storyLabel10.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel10.setText(story.split("\n\n")[2].split("\n")[1]);
        storyLabel10.setX(UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        storyLabel10.setY(UIHelpers.calcHeightProportion(this.game, 70.0f, 70.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel10, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel10.setVisible(false);
        this.stage.addActor(storyLabel10);
        SequenceAction action2100 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(96.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(27.0f), Actions.alpha(0.0f, 0.5f));
        storyLabel10.addAction(action2100);
        textOverlay10.getColor().a = 0.75f;
        textOverlay10.setWidth(storyLabel10.getWidth() * 108.0f / 100.0f);
        textOverlay10.setHeight(storyLabel10.getPrefHeight() * 108.0f / 100.0f);
        textOverlay10.setX(storyLabel10.getX() - storyLabel10.getWidth() * 4.0f / 100.0f);
        textOverlay10.setY(storyLabel10.getY() - storyLabel10.getPrefHeight() - storyLabel10.getPrefHeight() * 4.0f / 100.0f);
        textOverlay10.setVisible(false);
        SequenceAction action2101 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(96.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(27.0f), Actions.alpha(0.0f, 0.5f));
        textOverlay10.addAction(action2101);
        NinePatchActor textOverlay11 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay11);
        Label storyLabel11 = new Label("", this.game.uiSkin, "default");
        storyLabel11.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel11.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel11.setAlignment(10);
        storyLabel11.setWrap(true);
        storyLabel11.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel11.setText(story.split("\n\n")[2].split("\n")[2]);
        storyLabel11.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue());
        storyLabel11.setY(UIHelpers.calcHeightProportion(this.game, 35.0f, 35.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel11, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel11.setVisible(false);
        this.stage.addActor(storyLabel11);
        SequenceAction action2110 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(104.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(19.0f), Actions.alpha(0.0f, 0.5f));
        storyLabel11.addAction(action2110);
        textOverlay11.getColor().a = 0.75f;
        textOverlay11.setWidth(storyLabel11.getWidth() * 108.0f / 100.0f);
        textOverlay11.setHeight(storyLabel11.getPrefHeight() * 108.0f / 100.0f);
        textOverlay11.setX(storyLabel11.getX() - storyLabel11.getWidth() * 4.0f / 100.0f);
        textOverlay11.setY(storyLabel11.getY() - storyLabel11.getPrefHeight() - storyLabel11.getPrefHeight() * 4.0f / 100.0f);
        textOverlay11.setVisible(false);
        SequenceAction action2111 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(104.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(19.0f), Actions.alpha(0.0f, 0.5f));
        textOverlay11.addAction(action2111);
        NinePatchActor textOverlay12 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay12);
        Label storyLabel12 = new Label("", this.game.uiSkin, "default");
        storyLabel12.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel12.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel12.setAlignment(10);
        storyLabel12.setWrap(true);
        storyLabel12.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel12.setText(story.split("\n\n")[2].split("\n")[3]);
        storyLabel12.setX(UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue());
        storyLabel12.setY(UIHelpers.calcHeightProportion(this.game, 20.0f, 25.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel12, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel12.setVisible(false);
        this.stage.addActor(storyLabel12);
        SequenceAction action2120 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(112.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(11.0f), Actions.alpha(0.0f, 0.5f));
        storyLabel12.addAction(action2120);
        textOverlay12.getColor().a = 0.75f;
        textOverlay12.setWidth(storyLabel12.getWidth() * 108.0f / 100.0f);
        textOverlay12.setHeight(storyLabel12.getPrefHeight() * 108.0f / 100.0f);
        textOverlay12.setX(storyLabel12.getX() - storyLabel12.getWidth() * 4.0f / 100.0f);
        textOverlay12.setY(storyLabel12.getY() - storyLabel12.getPrefHeight() - storyLabel12.getPrefHeight() * 4.0f / 100.0f);
        textOverlay12.setVisible(false);
        SequenceAction action2121 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(112.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(11.0f), Actions.alpha(0.0f, 0.5f));
        textOverlay12.addAction(action2121);
        NinePatchActor entryOverlay = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        entryOverlay.setWidth(this.game.viewWidth.floatValue());
        entryOverlay.setHeight(this.game.viewHeight.floatValue());
        entryOverlay.setX(0.0f);
        entryOverlay.setY(0.0f);
        entryOverlay.setVisible(false);
        SequenceAction action20 = Actions.sequence((Action)Actions.alpha(1.0f), (Action)Actions.delay(7.5f), (Action)Actions.show(), (Action)Actions.delay(0.5f), (Action)Actions.alpha(0.0f, 5.0f));
        entryOverlay.addAction(action20);
        this.stage.addActor(entryOverlay);
        BaseActor backgroundLore10 = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundLore10, this.game.getOverridenFilename("data/backgrounds/backgroundLore10.jpg"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/backgroundLore10.jpg");
        backgroundLore10.setVisible(false);
        this.stage.addActor(backgroundLore10);
        SequenceAction action15 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(60.0f), Actions.alpha(1.0f, 0.5f), Actions.delay(24.0f), Actions.alpha(0.0f, 0.5f), Actions.delay(39.0f), Actions.alpha(1.0f, 0.5f), Actions.delay(27.5f), Actions.alpha(0.0f, 1.0f));
        backgroundLore10.addAction(action15);
        BaseActor backgroundLore10kneel = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundLore10kneel, this.game.getOverridenFilename("data/backgrounds/backgroundLore10kneel.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/backgroundLore10kneel.png");
        backgroundLore10kneel.setVisible(false);
        this.stage.addActor(backgroundLore10kneel);
        SequenceAction action16 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(60.0f), Actions.alpha(1.0f, 0.5f), Actions.delay(24.0f), Actions.alpha(0.0f, 0.5f), Actions.delay(39.0f), Actions.alpha(1.0f, 0.5f), Actions.delay(27.5f), Actions.alpha(0.0f, 1.0f));
        backgroundLore10kneel.addAction(action16);
        BaseActor backgroundLore10sadeyes0 = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundLore10sadeyes0, this.game.getOverridenFilename("data/backgrounds/backgroundLore10sadeyes0.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/backgroundLore10sadeyes0.png");
        backgroundLore10sadeyes0.setVisible(false);
        this.stage.addActor(backgroundLore10sadeyes0);
        SequenceAction action17 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(60.0f), Actions.alpha(1.0f, 0.5f), Actions.delay(20.0f), Actions.alpha(0.0f, 0.5f));
        backgroundLore10sadeyes0.addAction(action17);
        BaseActor backgroundLore10sadeyesclosing = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundLore10sadeyesclosing, this.game.getOverridenFilename("data/backgrounds/backgroundLore10sadeyesclosing.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/backgroundLore10sadeyesclosing.png");
        backgroundLore10sadeyesclosing.setVisible(false);
        this.stage.addActor(backgroundLore10sadeyesclosing);
        SequenceAction action18 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(80.0f), Actions.alpha(1.0f, 0.5f), Actions.delay(2.5f), Actions.alpha(0.0f, 0.5f), Actions.delay(24.5f), Actions.alpha(0.0f, 1.0f), Actions.delay(38.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(2.0f), Actions.alpha(0.0f, 1.0f));
        backgroundLore10sadeyesclosing.addAction(action18);
        BaseActor backgroundLore10eyescontent = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, backgroundLore10eyescontent, this.game.getOverridenFilename("data/backgrounds/backgroundLore10eyescontent.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/backgroundLore10eyescontent.png");
        backgroundLore10eyescontent.setVisible(false);
        this.stage.addActor(backgroundLore10eyescontent);
        SequenceAction action19 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(126.0f), Actions.alpha(1.0f, 0.5f), Actions.delay(21.5f), Actions.alpha(0.0f, 1.0f));
        backgroundLore10eyescontent.addAction(action19);
        NinePatchActor textOverlay5 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay5);
        Label storyLabel5 = new Label("", this.game.uiSkin, "default");
        storyLabel5.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel5.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel5.setAlignment(10);
        storyLabel5.setWrap(true);
        storyLabel5.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel5.setText(story.split("\n\n")[1].split("\n")[0]);
        storyLabel5.setX(UIHelpers.calcWidthProportion(this.game, 45.0f, 45.0f).floatValue());
        storyLabel5.setY(UIHelpers.calcHeightProportion(this.game, 85.0f, 85.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel5, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel5.setVisible(false);
        this.stage.addActor(storyLabel5);
        SequenceAction action25 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(60.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(23.5f), Actions.alpha(0.0f, 0.5f));
        storyLabel5.addAction(action25);
        textOverlay5.getColor().a = 0.75f;
        textOverlay5.setWidth(storyLabel5.getWidth() * 108.0f / 100.0f);
        textOverlay5.setHeight(storyLabel5.getPrefHeight() * 108.0f / 100.0f);
        textOverlay5.setX(storyLabel5.getX() - storyLabel5.getWidth() * 4.0f / 100.0f);
        textOverlay5.setY(storyLabel5.getY() - storyLabel5.getPrefHeight() - storyLabel5.getPrefHeight() * 4.0f / 100.0f);
        textOverlay5.setVisible(false);
        SequenceAction action251 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(60.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(23.5f), Actions.alpha(0.0f, 0.5f));
        textOverlay5.addAction(action251);
        NinePatchActor textOverlay6 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay6);
        Label storyLabel6 = new Label("", this.game.uiSkin, "default");
        storyLabel6.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel6.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel6.setAlignment(10);
        storyLabel6.setWrap(true);
        storyLabel6.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel6.setText(story.split("\n\n")[1].split("\n")[1]);
        storyLabel6.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue());
        storyLabel6.setY(UIHelpers.calcHeightProportion(this.game, 65.0f, 65.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel6, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel6.setVisible(false);
        this.stage.addActor(storyLabel6);
        SequenceAction action26 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(64.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(19.5f), Actions.alpha(0.0f, 0.5f));
        storyLabel6.addAction(action26);
        textOverlay6.getColor().a = 0.75f;
        textOverlay6.setWidth(storyLabel6.getWidth() * 108.0f / 100.0f);
        textOverlay6.setHeight(storyLabel6.getPrefHeight() * 108.0f / 100.0f);
        textOverlay6.setX(storyLabel6.getX() - storyLabel6.getWidth() * 4.0f / 100.0f);
        textOverlay6.setY(storyLabel6.getY() - storyLabel6.getPrefHeight() - storyLabel6.getPrefHeight() * 4.0f / 100.0f);
        textOverlay6.setVisible(false);
        SequenceAction action261 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(64.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(19.5f), Actions.alpha(0.0f, 0.5f));
        textOverlay6.addAction(action261);
        NinePatchActor textOverlay7 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay7);
        Label storyLabel7 = new Label("", this.game.uiSkin, "default");
        storyLabel7.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel7.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel7.setAlignment(10);
        storyLabel7.setWrap(true);
        storyLabel7.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel7.setText(story.split("\n\n")[1].split("\n")[2]);
        storyLabel7.setX(UIHelpers.calcWidthProportion(this.game, 55.0f, 55.0f).floatValue());
        storyLabel7.setY(UIHelpers.calcHeightProportion(this.game, 40.0f, 45.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel7, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel7.setVisible(false);
        this.stage.addActor(storyLabel7);
        SequenceAction action27 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(68.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(15.5f), Actions.alpha(0.0f, 0.5f));
        storyLabel7.addAction(action27);
        textOverlay7.getColor().a = 0.75f;
        textOverlay7.setWidth(storyLabel7.getWidth() * 108.0f / 100.0f);
        textOverlay7.setHeight(storyLabel7.getPrefHeight() * 108.0f / 100.0f);
        textOverlay7.setX(storyLabel7.getX() - storyLabel7.getWidth() * 4.0f / 100.0f);
        textOverlay7.setY(storyLabel7.getY() - storyLabel7.getPrefHeight() - storyLabel7.getPrefHeight() * 4.0f / 100.0f);
        textOverlay7.setVisible(false);
        SequenceAction action271 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(68.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(15.5f), Actions.alpha(0.0f, 0.5f));
        textOverlay7.addAction(action271);
        NinePatchActor textOverlay8 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay8);
        Label storyLabel8 = new Label("", this.game.uiSkin, "default");
        storyLabel8.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel8.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel8.setAlignment(10);
        storyLabel8.setWrap(true);
        storyLabel8.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel8.setText(story.split("\n\n")[1].split("\n")[3]);
        storyLabel8.setX(UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue());
        storyLabel8.setY(UIHelpers.calcHeightProportion(this.game, 20.0f, 25.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel8, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel8.setVisible(false);
        this.stage.addActor(storyLabel8);
        SequenceAction action28 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(72.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(11.5f), Actions.alpha(0.0f, 0.5f));
        storyLabel8.addAction(action28);
        textOverlay8.getColor().a = 0.75f;
        textOverlay8.setWidth(storyLabel8.getWidth() * 108.0f / 100.0f);
        textOverlay8.setHeight(storyLabel8.getPrefHeight() * 108.0f / 100.0f);
        textOverlay8.setX(storyLabel8.getX() - storyLabel8.getWidth() * 4.0f / 100.0f);
        textOverlay8.setY(storyLabel8.getY() - storyLabel8.getPrefHeight() - storyLabel8.getPrefHeight() * 4.0f / 100.0f);
        textOverlay8.setVisible(false);
        SequenceAction action281 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(72.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(11.5f), Actions.alpha(0.0f, 0.5f));
        textOverlay8.addAction(action281);
        NinePatchActor textOverlay13 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay13);
        Label storyLabel13 = new Label("", this.game.uiSkin, "default");
        storyLabel13.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel13.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel13.setAlignment(10);
        storyLabel13.setWrap(true);
        storyLabel13.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel13.setText(story.split("\n\n")[3].split("\n")[0]);
        storyLabel13.setX(UIHelpers.calcWidthProportion(this.game, 45.0f, 45.0f).floatValue());
        storyLabel13.setY(UIHelpers.calcHeightProportion(this.game, 85.0f, 85.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel13, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel13.setVisible(false);
        this.stage.addActor(storyLabel13);
        SequenceAction action2130 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(126.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(25.5f), Actions.alpha(0.0f, 0.5f));
        storyLabel13.addAction(action2130);
        textOverlay13.getColor().a = 0.75f;
        textOverlay13.setWidth(storyLabel13.getWidth() * 108.0f / 100.0f);
        textOverlay13.setHeight(storyLabel13.getPrefHeight() * 108.0f / 100.0f);
        textOverlay13.setX(storyLabel13.getX() - storyLabel13.getWidth() * 4.0f / 100.0f);
        textOverlay13.setY(storyLabel13.getY() - storyLabel13.getPrefHeight() - storyLabel13.getPrefHeight() * 4.0f / 100.0f);
        textOverlay13.setVisible(false);
        SequenceAction action2131 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(126.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(25.5f), Actions.alpha(0.0f, 0.5f));
        textOverlay13.addAction(action2131);
        NinePatchActor textOverlay14 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay14);
        Label storyLabel14 = new Label("", this.game.uiSkin, "default");
        storyLabel14.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel14.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel14.setAlignment(10);
        storyLabel14.setWrap(true);
        storyLabel14.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel14.setText(story.split("\n\n")[3].split("\n")[1]);
        storyLabel14.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue());
        storyLabel14.setY(UIHelpers.calcHeightProportion(this.game, 65.0f, 65.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel14, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel14.setVisible(false);
        this.stage.addActor(storyLabel14);
        SequenceAction action2140 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(132.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(19.5f), Actions.alpha(0.0f, 0.5f));
        storyLabel14.addAction(action2140);
        textOverlay14.getColor().a = 0.75f;
        textOverlay14.setWidth(storyLabel14.getWidth() * 108.0f / 100.0f);
        textOverlay14.setHeight(storyLabel14.getPrefHeight() * 108.0f / 100.0f);
        textOverlay14.setX(storyLabel14.getX() - storyLabel14.getWidth() * 4.0f / 100.0f);
        textOverlay14.setY(storyLabel14.getY() - storyLabel14.getPrefHeight() - storyLabel14.getPrefHeight() * 4.0f / 100.0f);
        textOverlay14.setVisible(false);
        SequenceAction action2141 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(132.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(19.5f), Actions.alpha(0.0f, 0.5f));
        textOverlay14.addAction(action2141);
        NinePatchActor textOverlay15 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay15);
        Label storyLabel15 = new Label("", this.game.uiSkin, "default");
        storyLabel15.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel15.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel15.setAlignment(10);
        storyLabel15.setWrap(true);
        storyLabel15.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel15.setText(story.split("\n\n")[3].split("\n")[2]);
        storyLabel15.setX(UIHelpers.calcWidthProportion(this.game, 55.0f, 55.0f).floatValue());
        storyLabel15.setY(UIHelpers.calcHeightProportion(this.game, 40.0f, 45.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel15, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel15.setVisible(false);
        this.stage.addActor(storyLabel15);
        SequenceAction action2150 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(138.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(13.5f), Actions.alpha(0.0f, 0.5f));
        storyLabel15.addAction(action2150);
        textOverlay15.getColor().a = 0.75f;
        textOverlay15.setWidth(storyLabel15.getWidth() * 108.0f / 100.0f);
        textOverlay15.setHeight(storyLabel15.getPrefHeight() * 108.0f / 100.0f);
        textOverlay15.setX(storyLabel15.getX() - storyLabel15.getWidth() * 4.0f / 100.0f);
        textOverlay15.setY(storyLabel15.getY() - storyLabel15.getPrefHeight() - storyLabel15.getPrefHeight() * 4.0f / 100.0f);
        textOverlay15.setVisible(false);
        SequenceAction action2151 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(138.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(13.5f), Actions.alpha(0.0f, 0.5f));
        textOverlay15.addAction(action2151);
        NinePatchActor textOverlay16 = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.stage.addActor(textOverlay16);
        Label storyLabel16 = new Label("", this.game.uiSkin, "default");
        storyLabel16.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        storyLabel16.setColor(this.game.uiSkin.get("lightiron", Color.class));
        storyLabel16.setAlignment(10);
        storyLabel16.setWrap(true);
        storyLabel16.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        storyLabel16.setText(story.split("\n\n")[3].split("\n")[3]);
        storyLabel16.setX(UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue());
        storyLabel16.setY(UIHelpers.calcHeightProportion(this.game, 20.0f, 25.0f).floatValue());
        UIHelpers.fixLabelFontSize(storyLabel16, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.game.viewHeight.floatValue() * 15.0f / 100.0f);
        storyLabel16.setVisible(false);
        this.stage.addActor(storyLabel16);
        SequenceAction action2160 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(144.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(7.5f), Actions.alpha(0.0f, 0.5f));
        storyLabel16.addAction(action2160);
        textOverlay16.getColor().a = 0.75f;
        textOverlay16.setWidth(storyLabel16.getWidth() * 108.0f / 100.0f);
        textOverlay16.setHeight(storyLabel16.getPrefHeight() * 108.0f / 100.0f);
        textOverlay16.setX(storyLabel16.getX() - storyLabel16.getWidth() * 4.0f / 100.0f);
        textOverlay16.setY(storyLabel16.getY() - storyLabel16.getPrefHeight() - storyLabel16.getPrefHeight() * 4.0f / 100.0f);
        textOverlay16.setVisible(false);
        SequenceAction action2161 = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(144.0f), Actions.alpha(1.0f, 1.0f), Actions.delay(7.5f), Actions.alpha(0.0f, 0.5f));
        textOverlay16.addAction(action2161);
        this.addFadeOverlay(Float.valueOf(0.1f));
    }

    @Override
    public void render(float delta) {
        this.stage.act(delta);
        this.timeElapsed += delta;
        if (this.timeElapsed > 1.0f && this.endStage.equalsIgnoreCase("shoutBoss")) {
            this.endStage = "fieryEyes";
        } else if ((double)this.timeElapsed > 2.5 && this.endStage.equalsIgnoreCase("fieryEyes")) {
            this.endStage = "attack";
        } else if ((double)this.timeElapsed > 8.0 && this.endStage.equalsIgnoreCase("attack")) {
            this.endStage = "arena";
            if (this.game.track != null && this.game.track.isPlaying()) {
                this.game.track.stop();
                this.game.track.dispose();
            }
            this.game.track = Gdx.audio.newMusic(Gdx.files.internal(this.game.getOverridenFilename("music/sl15.ogg")));
            this.game.track.setLooping(false);
            this.game.track.setVolume(this.game.musicVolume);
            this.game.track.play();
        } else if ((double)this.timeElapsed > 159.0 && this.endStage.equalsIgnoreCase("arena")) {
            this.game.creditsScreen = new CreditsScreen(this.game, true);
            this.game.setScreen(this.game.creditsScreen);
        }
        if (this.endStage.equalsIgnoreCase("attack")) {
            this.backgroundDeadShout.setX(this.backgroundDeadShoutX + MathUtils.random(this.game.viewWidth.floatValue() / 200.0f));
            this.backgroundDeadShout.setY(MathUtils.random(this.game.viewWidth.floatValue() / 200.0f));
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public void dispose() {
        for (String currBackground : this.backgroundImages) {
            UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset(currBackground));
        }
    }

    @Override
    public boolean keyDown(int keycode) {
        this.game.mainMenuScreen = new MainMenuScreen(this.game);
        this.game.setScreen(this.game.mainMenuScreen);
        return true;
    }
}

