/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.RepeatAction;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.AnimatedActor;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.ParticleEffectActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.AI;
import com.calimasaga.slavepits.game.CombatEngine;
import com.calimasaga.slavepits.game.CombatServer;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.game.Story;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.DuelSetupScreen;
import com.calimasaga.slavepits.screen.EndScreen;
import com.calimasaga.slavepits.screen.GameMenuScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.util.Logger;
import com.calimasaga.slavepits.util.PropertiesReader;
import com.calimasaga.slavepits.util.StringList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class CombatScreen
extends BaseScreen {
    private static long INIT_TIME = 5000L;
    private static long RESOLUTION_TIME = 1000L;
    public static float PHASE_TIME = 100.0f;
    private float ATTACK_TIME = 1000.0f;
    public Boolean paused = false;
    public Boolean end = false;
    public Boolean receivedDisconnect = null;
    public Boolean receivedReplay = null;
    public Fighter hostFighter;
    public Fighter clientFighter;
    public int reputation;
    public String arena;
    public String music;
    public String difficulty;
    public long startingPlayer;
    public long crowdSound;
    public int profits = 0;
    public int initialLife = 10000;
    public AI clientAI;
    public AI hostAI;
    public HashMap<Integer, ArrayList<String>> tutorialSteps;
    public int currTutorialStep;
    public int currTutorialSubstep;
    public Boolean tutorialFail;
    public Label tutorialPC;
    public Label tutorialMasterFail;
    public Label tutorialFlavor;
    public Label tutorialInfo;
    public Button nextButton;
    public Boolean tutorialPause;
    public BaseActor overlayTutorial;
    public long tutorialElapsedTime;
    public long combatTime;
    public long timeLimitTime;
    public BaseActor timeLimitIndex;
    public long actionTime;
    public long lastStatusTime;
    public long elapsedTime = 0L;
    public boolean slomo = false;
    public BaseActor overlay;
    public BaseActor combatHitClient;
    public BaseActor combatHitHost;
    public BaseActor combatSurge;
    public AnimatedActor combatParry;
    public AnimatedActor combatDodgeLeft;
    public AnimatedActor combatDodgeRight;
    public BaseActor combatShardEffect;
    public BaseActor combatPowderEffect;
    public BaseActor combatNetEffect;
    public BaseActor pressureBar;
    public ArrayList<BaseActor> assaultClientBar;
    public ArrayList<BaseActor> assaultHostBar;
    public AnimatedActor comboHitParry;
    public AnimatedActor comboHitDodge;
    public Label timeLimitLabel;
    public Label combatLabel;
    public long logTime = 0L;
    public long labelTime;
    public long shakeTime;
    public long clearCamera;
    public BaseActor stunScreen;
    public ArrayList<BaseActor> stunParts = new ArrayList();
    public BaseActor bleedScreen;
    public BaseActor fireScreen;
    public BaseActor lightningScreen;
    public BaseActor endSplash;
    public Label endLabel;
    public TextButton replayButton;
    public TextButton endCombatButton;
    public boolean buffDebuffChange = false;
    public NinePatchActor rewardBackground;
    public Label rewardLabel;
    public Button rewardButton;
    public String scenario;
    public BaseActor scenarioFront;
    public BaseActor scenarioBack;
    public long talkTime;
    public BaseActor talkBackground;
    public BaseActor talkDirection;
    public Label talkSentence;
    public AnimatedActor upMiddleAttack;
    public AnimatedActor centerLeftAttack;
    public AnimatedActor centerRightAttack;
    public AnimatedActor upMiddleParry;
    public AnimatedActor centerLeftParry;
    public AnimatedActor centerRightParry;
    public AnimatedActor downLeft;
    public AnimatedActor downRight;
    public BaseActor upMiddleAttackb;
    public BaseActor centerLeftAttackb;
    public BaseActor centerRightAttackb;
    public BaseActor upMiddleParryb;
    public BaseActor centerLeftParryb;
    public BaseActor centerRightParryb;
    public BaseActor downLeftb;
    public BaseActor downRightb;
    public BaseActor surge;
    public int surgeRegionYinit = 0;
    public BaseActor useItem;
    public BaseActor bossActor1;
    public BaseActor bossActor2;
    public Label bossActor3;
    public BaseActor claim1;
    public Container<Label> claim1label;
    public BaseActor claim2;
    public Container<Label> claim2label;
    public BaseActor claim3;
    public Container<Label> claim3label;
    public BaseActor claim4;
    public Container<Label> claim4label;
    public BaseActor hostPortrait;
    public BaseActor hostLifeBar;
    public BaseActor hostLifeBarShadow;
    public BaseActor hostStaminaBar;
    public BaseActor hostStaminaBarShadow;
    public BaseActor hostBalanceBar;
    public BaseActor hostBalanceBarShadow;
    public ArrayList<BaseActor> hostIconBar;
    public Stack hostCharacter;
    public BaseActor hostBody;
    public BaseActor hostBodyArmor;
    public BaseActor hostHeadArmor;
    public BaseActor hostArmsArmorBR;
    public BaseActor hostBodyBuff;
    public BaseActor hostWeapon;
    public BaseActor hostOffHand;
    public BaseActor baseEventBar;
    public BaseActor surgeEventBar;
    public BaseActor clientPortrait;
    public BaseActor clientLifeBar;
    public BaseActor clientLifeBarShadow;
    public BaseActor clientStaminaBar;
    public BaseActor clientStaminaBarShadow;
    public BaseActor clientBalanceBar;
    public BaseActor clientBalanceBarShadow;
    public ArrayList<BaseActor> clientIconBar;
    public Stack clientCharacter;
    public BaseActor clientSkin;
    public BaseActor clientSkinExtra;
    public BaseActor clientBody;
    public BaseActor clientBodyBuff;
    public BaseActor clientBodyExtra;
    public BaseActor clientHead;
    public ArrayList<BaseActor> clientAccessories;
    public ArrayList<BaseActor> clientWounds;
    public BaseActor clientArms;
    public BaseActor clientArmsArmorSL;
    public BaseActor clientArmsArmorBRL;
    public BaseActor clientArmsArmorBRR;
    public BaseActor clientArmsArmorSPL;
    public BaseActor clientArmsArmorSPR;
    public BaseActor clientBodyArmorT;
    public BaseActor clientBodyArmorL;
    public BaseActor clientBodyArmorTExtra;
    public BaseActor clientWeapon;
    public BaseActor clientOffHand;
    public BaseActor clientKneel;
    public BaseActor clientCorpse;
    public boolean clientHasHit = false;
    public float clientSizeinit = 0.0f;
    public float clientXinit = 0.0f;
    public float clientYinit = 0.0f;
    public float clientMoveinit = 0.0f;
    public float hostSizeinit = 0.0f;
    public float hostXinit = 0.0f;
    public float hostYinit = 0.0f;
    public float hostMoveinit = 0.0f;
    public boolean hostWait = false;
    public boolean clientWait = false;
    public int messageIndex = 0;
    public LinkedList<String> messageHistory = new LinkedList();
    public LinkedList<StringBuilder> messagesToExecute = new LinkedList();
    public ShaderProgram greyscaleShader;
    public ShaderProgram borderShader;
    public Label fpsCounter;

    public CombatScreen(SlavePitsGame g, Fighter f1, Fighter f2, int selectedReputation, String selectedArena, String selectedMusic, String selectedDifficulty, boolean selHostAI, long selStartingPlayer, int timeLimit, String selScenario) {
        super(g);
        this.hostFighter = f1;
        this.hostFighter.isPlayer = true;
        this.clientFighter = f2;
        this.reputation = selectedReputation;
        this.arena = selectedArena;
        this.music = selectedMusic;
        this.difficulty = selectedDifficulty;
        this.clientAI = null;
        this.hostAI = null;
        this.startingPlayer = selStartingPlayer;
        this.timeLimitTime = (long)timeLimit * 1000L;
        this.scenario = selScenario;
        this.profits = 0;
        this.initialLife = this.hostFighter.life;
        this.elapsedTime = 0L;
        this.buffDebuffChange = false;
        this.hostWait = false;
        this.clientWait = false;
        this.messageIndex = 0;
        this.messageHistory = new LinkedList();
        this.messagesToExecute = new LinkedList();
        CombatServer.init(g);
        if (this.startingPlayer == 1L) {
            if (!this.game.gameMode.equalsIgnoreCase("client")) {
                this.hostFighter.isHost = true;
                CombatEngine.initialize(this.game, this.hostFighter, this.clientFighter, selectedDifficulty, true, this.scenario, this.game.isMultiplayerGame() ? this.game.multiplayerInput : this.game.input);
                this.hostWait = false;
                this.clientWait = true;
            } else {
                CombatEngine.initialize(this.game, this.clientFighter, this.hostFighter, selectedDifficulty, false, this.scenario, this.game.isMultiplayerGame() ? this.game.multiplayerInput : this.game.input);
                this.hostWait = true;
                this.clientWait = false;
            }
        } else if (!this.game.gameMode.equalsIgnoreCase("client")) {
            this.hostFighter.isHost = true;
            CombatEngine.initialize(this.game, this.clientFighter, this.hostFighter, selectedDifficulty, false, this.scenario, this.game.isMultiplayerGame() ? this.game.multiplayerInput : this.game.input);
            this.hostWait = true;
            this.clientWait = false;
        } else {
            CombatEngine.initialize(this.game, this.hostFighter, this.clientFighter, selectedDifficulty, true, this.scenario, this.game.isMultiplayerGame() ? this.game.multiplayerInput : this.game.input);
            this.hostWait = false;
            this.clientWait = true;
        }
        CombatEngine.initTalentEffects(this.clientFighter);
        CombatEngine.initTalentEffects(this.hostFighter);
        this.ATTACK_TIME = ((JSONObject)this.game.stats.get("timings").get("idle")).getFloat("time") + ((JSONObject)this.game.stats.get("timings").get("platform")).getFloat(CombatEngine.selectedInput);
        if (!this.game.isMultiplayerGame()) {
            this.clientAI = new AI(this.game, this.clientFighter, this.hostFighter, this.reputation, this.difficulty);
        }
        if (selHostAI) {
            this.hostAI = new AI(this.game, this.hostFighter, this.clientFighter, this.reputation, "hardcore");
        }
    }

    @Override
    public boolean keyTyped(char character) {
        return super.keyTyped(character);
    }

    @Override
    public boolean keyUp(int keycode) {
        return super.keyUp(keycode);
    }

    @Override
    public void create() {
        BaseActor assaultIndex;
        int i;
        String scenarioFrontImage;
        String scenarioBackImage;
        if (this.game.track != null && this.game.track.isPlaying()) {
            this.game.track.stop();
            this.game.track.dispose();
        }
        this.game.track = Gdx.audio.newMusic(Gdx.files.internal(this.game.getOverridenFilename("music/" + this.music + ".ogg")));
        this.game.track.setLooping(true);
        this.game.track.setVolume(this.game.musicVolume);
        this.game.track.play();
        this.crowdSound = this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).loop(this.game.soundVolume);
        BaseActor background = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, background, this.game.getOverridenFilename("data/backgrounds/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("background")), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.stage.addActor(background);
        if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.equalsIgnoreCase("boss3")) {
            BaseActor backgroundSoldiers = new BaseActor();
            UIHelpers.portraitModeFixBackground(this.game, backgroundSoldiers, this.game.getOverridenFilename("data/backgrounds/backgroundsoldiers.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
            this.stage.addActor(backgroundSoldiers);
        }
        if (this.arena.equalsIgnoreCase("boss3")) {
            ParticleEffectActor t3;
            ParticleEffectActor t2;
            ParticleEffectActor t1;
            TextureAtlas misceffectsAtlas;
            if (!this.game.portraitmode) {
                misceffectsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/misceffects.atlas"), TextureAtlas.class);
                t1 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenAsset("data/elements/torch.p")), misceffectsAtlas, this.game.viewWidth.floatValue() * 310.0f / 1000.0f, this.game.viewHeight.floatValue() * 555.0f / 1000.0f, true);
                this.stage.addActor(t1);
                t2 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenAsset("data/elements/torch.p")), misceffectsAtlas, this.game.viewWidth.floatValue() * 715.0f / 1000.0f, this.game.viewHeight.floatValue() * 555.0f / 1000.0f, true);
                this.stage.addActor(t2);
                t3 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenAsset("data/elements/torch.p")), misceffectsAtlas, this.game.viewWidth.floatValue() * 509.0f / 1000.0f, this.game.viewHeight.floatValue() * 610.0f / 1000.0f, true);
                this.stage.addActor(t3);
                ParticleEffectActor t4 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenAsset("data/elements/torch.p")), misceffectsAtlas, this.game.viewWidth.floatValue() * 0.0f / 1000.0f, this.game.viewHeight.floatValue() * 400.0f / 1000.0f, true);
                this.stage.addActor(t4);
                ParticleEffectActor t5 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenAsset("data/elements/torch.p")), misceffectsAtlas, this.game.viewWidth.floatValue() * 1000.0f / 1000.0f, this.game.viewHeight.floatValue() * 400.0f / 1000.0f, true);
                this.stage.addActor(t5);
            } else {
                misceffectsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/misceffects.atlas"), TextureAtlas.class);
                t1 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenAsset("data/elements/torch.p")), misceffectsAtlas, this.game.viewWidth.floatValue() * 160.0f / 1000.0f, this.game.viewHeight.floatValue() * 555.0f / 1000.0f, true);
                this.stage.addActor(t1);
                t2 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenAsset("data/elements/torch.p")), misceffectsAtlas, this.game.viewWidth.floatValue() * 875.0f / 1000.0f, this.game.viewHeight.floatValue() * 555.0f / 1000.0f, true);
                this.stage.addActor(t2);
                t3 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenAsset("data/elements/torch.p")), misceffectsAtlas, this.game.viewWidth.floatValue() * 509.0f / 1000.0f, this.game.viewHeight.floatValue() * 610.0f / 1000.0f, true);
                this.stage.addActor(t3);
            }
        }
        if (!this.scenario.equalsIgnoreCase("") && !(scenarioBackImage = ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getString("back")).equalsIgnoreCase("")) {
            this.scenarioBack = new BaseActor();
            UIHelpers.portraitModeFixBackground(this.game, this.scenarioBack, this.game.getOverridenFilename("data/backgrounds/" + scenarioBackImage), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
            this.stage.addActor(this.scenarioBack);
        }
        this.overlay = new BaseActor();
        this.overlay.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/overlay.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
        this.overlay.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.overlay.setPosition(0.0f, 0.0f);
        this.overlay.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (y >= CombatScreen.this.upMiddleAttack.getY() && (x >= CombatScreen.this.upMiddleAttack.getX() && x <= CombatScreen.this.upMiddleAttack.getX() + CombatScreen.this.upMiddleAttack.getWidth() || x < CombatScreen.this.upMiddleAttack.getX() && Math.pow(x, 2.0) + Math.pow(y, 2.0) >= Math.pow(CombatScreen.this.upMiddleAttack.getX(), 2.0) + Math.pow(CombatScreen.this.upMiddleAttack.getY(), 2.0) || x > CombatScreen.this.upMiddleAttack.getX() + CombatScreen.this.upMiddleAttack.getWidth() && Math.pow(CombatScreen.this.game.widthBASE.floatValue() - x, 2.0) + Math.pow(y, 2.0) >= Math.pow(CombatScreen.this.upMiddleAttack.getX() + CombatScreen.this.upMiddleAttack.getWidth(), 2.0) + Math.pow(CombatScreen.this.upMiddleAttack.getY(), 2.0))) {
                    if (CombatScreen.this.upMiddleAttack.isVisible()) {
                        CombatScreen.this.checkCombatIntput(CombatScreen.this.upMiddleAttack, "attack", "middle");
                    } else if (CombatScreen.this.upMiddleParry.isVisible()) {
                        CombatScreen.this.checkCombatIntput(CombatScreen.this.upMiddleParry, "parry", "middle");
                    }
                }
                if (y >= CombatScreen.this.centerLeftAttack.getY()) {
                    if (x <= CombatScreen.this.centerLeftAttack.getX() + CombatScreen.this.centerLeftAttack.getWidth() && Math.pow(x, 2.0) + Math.pow(y, 2.0) <= Math.pow(CombatScreen.this.centerLeftAttack.getX() + CombatScreen.this.centerLeftAttack.getWidth(), 2.0) + Math.pow(CombatScreen.this.centerLeftAttack.getY() + CombatScreen.this.centerLeftAttack.getHeight(), 2.0)) {
                        if (CombatScreen.this.centerLeftAttack.isVisible()) {
                            CombatScreen.this.checkCombatIntput(CombatScreen.this.centerLeftAttack, "attack", "left");
                        } else if (CombatScreen.this.centerLeftParry.isVisible()) {
                            CombatScreen.this.checkCombatIntput(CombatScreen.this.centerLeftParry, "parry", "left");
                        }
                    }
                    if (x >= CombatScreen.this.centerRightAttack.getX() && Math.pow(x, 2.0) + Math.pow(y, 2.0) >= Math.pow(CombatScreen.this.centerRightAttack.getX(), 2.0) + Math.pow(CombatScreen.this.centerRightAttack.getY() + CombatScreen.this.centerRightAttack.getHeight(), 2.0)) {
                        if (CombatScreen.this.centerRightAttack.isVisible()) {
                            CombatScreen.this.checkCombatIntput(CombatScreen.this.centerRightAttack, "attack", "right");
                        } else if (CombatScreen.this.centerRightParry.isVisible()) {
                            CombatScreen.this.checkCombatIntput(CombatScreen.this.centerRightParry, "parry", "right");
                        }
                    }
                }
                if (y <= CombatScreen.this.downLeft.getY() + CombatScreen.this.downLeft.getHeight()) {
                    if (x <= CombatScreen.this.downLeft.getX() + CombatScreen.this.downLeft.getWidth() && CombatScreen.this.downLeft.isVisible()) {
                        CombatScreen.this.checkCombatIntput(CombatScreen.this.downLeft, "dodge", "left");
                    } else if (x >= CombatScreen.this.downRight.getX() && CombatScreen.this.downRight.isVisible()) {
                        CombatScreen.this.checkCombatIntput(CombatScreen.this.downRight, "dodge", "right");
                    }
                }
                return true;
            }
        });
        this.stage.addActor(this.overlay);
        TextureAtlas combatElementsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/combateffects.atlas"), TextureAtlas.class);
        this.combatSurge = new BaseActor();
        this.combatSurge.setTexture(combatElementsAtlas.findRegion("surge"), UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue());
        this.combatSurge.setX(UIHelpers.calcWidthProportion(this.game, 55.0f, 55.0f).floatValue() - this.combatSurge.getWidth() / 2.0f);
        this.combatSurge.setY(UIHelpers.calcHeightProportion(this.game, 16.5f, 25.0f).floatValue());
        this.combatSurge.setOrigin(1);
        this.combatSurge.setVisible(false);
        this.stage.addActor(this.combatSurge);
        this.comboHitParry = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combateffects.atlas"), "comboHit", 15, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), false);
        this.comboHitParry.setPosition(0.0f, 0.0f);
        this.comboHitParry.setVisible(false);
        this.comboHitParry.setTouchable(Touchable.disabled);
        this.stage.addActor(this.comboHitParry);
        this.comboHitDodge = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combateffects.atlas"), "comboHit", 15, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), true);
        this.comboHitDodge.setPosition(0.0f, 0.0f);
        this.comboHitDodge.setVisible(false);
        this.comboHitDodge.setTouchable(Touchable.disabled);
        this.stage.addActor(this.comboHitDodge);
        this.combatHitClient = new BaseActor();
        this.combatHitClient.setTexture(combatElementsAtlas.findRegion(this.game.violenceFilter ? "damagenonviolent" : "damage"), UIHelpers.calcHeightProportion(this.game, 50.0f, 40.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 37.5f, 30.0f).floatValue());
        this.combatHitClient.setVisible(false);
        this.combatHitClient.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue());
        this.combatHitClient.setY(UIHelpers.calcHeightProportion(this.game, 50.0f, 60.0f).floatValue());
        this.stage.addActor(this.combatHitClient);
        this.clientSizeinit = UIHelpers.calcHeightProportion(this.game, 85.0f, 85.0f).floatValue();
        this.clientXinit = UIHelpers.calcWidthProportion(this.game, 18.0f, -6.65f).floatValue();
        this.clientYinit = UIHelpers.calcHeightProportion(this.game, 12.25f, 12.25f).floatValue();
        this.clientMoveinit = UIHelpers.calcWidthProportion(this.game, 18.0f, 18.0f).floatValue();
        this.hostSizeinit = this.clientSizeinit * 1.54f;
        this.hostXinit = this.clientXinit - this.clientSizeinit * 0.27f;
        this.hostYinit = this.clientYinit - this.clientSizeinit * 0.54f;
        this.hostMoveinit = this.clientMoveinit * 1.27f;
        this.bossActor1 = new BaseActor();
        this.bossActor2 = new BaseActor();
        if (this.clientFighter.name.equalsIgnoreCase("boss1")) {
            this.bossActor1.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
            this.bossActor1.params.put("type", "dogempty");
            this.bossActor1.params.put("border", "false");
            this.bossActor1.setVisible(false);
            this.stage.addActor(this.bossActor1);
            this.bossActor2.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
            this.bossActor2.params.put("type", "dogempty");
            this.bossActor2.params.put("border", "false");
            this.bossActor2.setVisible(false);
            this.stage.addActor(this.bossActor2);
        }
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        this.claim1 = new BaseActor();
        this.claim1.setTexture(uiAtlas.findRegion("shoutbackground"), UIHelpers.calcWidthProportion(this.game, 20.0f, 30.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 15.0f, 20.0f).floatValue());
        this.claim1.setX(UIHelpers.calcWidthProportion(this.game, 10.0f, 2.0f).floatValue());
        this.claim1.setY(UIHelpers.calcHeightProportion(this.game, 82.0f, 85.0f).floatValue());
        this.claim1.setVisible(false);
        this.stage.addActor(this.claim1);
        Label claimLabel1 = new Label(PropertiesReader.getMessage(this.game.gameMessages, "zone.claim"), this.game.uiSkin, "default");
        claimLabel1.setAlignment(1);
        claimLabel1.setColor(this.game.uiSkin.get("lightiron", Color.class));
        claimLabel1.setWrap(true);
        claimLabel1.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * (float)(this.game.portraitmode ? 4 : 3) / 4.0f));
        claimLabel1.setWidth(this.claim1.getWidth());
        claimLabel1.setX(this.claim1.getX());
        claimLabel1.setY(this.claim1.getY() + this.claim1.getHeight() / 2.0f - claimLabel1.getPrefHeight() / 2.0f);
        this.claim1label = new Container<Label>(claimLabel1);
        this.claim1label.setWidth(this.claim1.getWidth());
        this.claim1label.setX(this.claim1.getX());
        this.claim1label.setY(this.claim1.getY() + this.claim1.getHeight() / 2.0f - this.claim1label.getHeight() / 2.0f);
        this.claim1label.setVisible(false);
        this.claim1label.setTransform(true);
        this.stage.addActor(this.claim1label);
        this.claim2 = new BaseActor();
        this.claim2.setTexture(uiAtlas.findRegion("shoutbackground"), UIHelpers.calcWidthProportion(this.game, 20.0f, 30.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 15.0f, 20.0f).floatValue());
        this.claim2.setX(UIHelpers.calcWidthProportion(this.game, 55.0f, 28.0f).floatValue());
        this.claim2.setY(UIHelpers.calcHeightProportion(this.game, 82.0f, 85.0f).floatValue());
        this.claim2.setVisible(false);
        this.stage.addActor(this.claim2);
        Label claimLabel2 = new Label(PropertiesReader.getMessage(this.game.gameMessages, "zone.claim"), this.game.uiSkin, "default");
        claimLabel2.setAlignment(1);
        claimLabel2.setColor(this.game.uiSkin.get("lightiron", Color.class));
        claimLabel2.setWrap(true);
        claimLabel2.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * (float)(this.game.portraitmode ? 4 : 3) / 4.0f));
        claimLabel2.setWidth(this.claim2.getWidth());
        claimLabel2.setX(this.claim2.getX());
        claimLabel2.setY(this.claim2.getY() + this.claim2.getHeight() / 2.0f - claimLabel2.getPrefHeight() / 2.0f);
        this.claim2label = new Container<Label>(claimLabel2);
        this.claim2label.setWidth(this.claim2.getWidth());
        this.claim2label.setX(this.claim2.getX());
        this.claim2label.setY(this.claim2.getY() + this.claim2.getHeight() / 2.0f - this.claim2label.getHeight() / 2.0f);
        this.claim2label.setVisible(false);
        this.claim2label.setTransform(true);
        this.stage.addActor(this.claim2label);
        this.claim3 = new BaseActor();
        this.claim3.setTexture(uiAtlas.findRegion("shoutbackground"), UIHelpers.calcWidthProportion(this.game, 20.0f, 30.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 15.0f, 20.0f).floatValue());
        this.claim3.setX(UIHelpers.calcWidthProportion(this.game, 0.0f, -3.0f).floatValue());
        this.claim3.setY(UIHelpers.calcHeightProportion(this.game, 67.0f, 70.0f).floatValue());
        this.claim3.setVisible(false);
        this.stage.addActor(this.claim3);
        Label claimLabel3 = new Label(PropertiesReader.getMessage(this.game.gameMessages, "zone.claim"), this.game.uiSkin, "default");
        claimLabel3.setAlignment(1);
        claimLabel3.setColor(this.game.uiSkin.get("lightiron", Color.class));
        claimLabel3.setWrap(true);
        claimLabel3.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * (float)(this.game.portraitmode ? 4 : 3) / 4.0f));
        claimLabel3.setWidth(this.claim3.getWidth());
        claimLabel3.setX(this.claim3.getX());
        this.claim3label = new Container<Label>(claimLabel3);
        this.claim3label.setWidth(this.claim3.getWidth());
        this.claim3label.setX(this.claim3.getX());
        this.claim3label.setY(this.claim3.getY() + this.claim3.getHeight() / 2.0f - this.claim3label.getHeight() / 2.0f);
        this.claim3label.setVisible(false);
        this.claim3label.setTransform(true);
        this.stage.addActor(this.claim3label);
        this.claim4 = new BaseActor();
        this.claim4.setTexture(uiAtlas.findRegion("shoutbackground"), UIHelpers.calcWidthProportion(this.game, 20.0f, 30.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 15.0f, 20.0f).floatValue());
        this.claim4.setX(UIHelpers.calcWidthProportion(this.game, 80.0f, 70.0f).floatValue());
        this.claim4.setY(UIHelpers.calcHeightProportion(this.game, 67.0f, 70.0f).floatValue());
        this.claim4.setVisible(false);
        this.stage.addActor(this.claim4);
        Label claimLabel4 = new Label(PropertiesReader.getMessage(this.game.gameMessages, "zone.claim"), this.game.uiSkin, "default");
        claimLabel4.setAlignment(1);
        claimLabel4.setColor(this.game.uiSkin.get("lightiron", Color.class));
        claimLabel4.setWrap(true);
        claimLabel4.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * (float)(this.game.portraitmode ? 4 : 3) / 4.0f));
        claimLabel4.setWidth(this.claim4.getWidth());
        claimLabel4.setX(this.claim4.getX());
        claimLabel4.setY(this.claim4.getY() + this.claim4.getHeight() / 2.0f - claimLabel4.getPrefHeight() / 2.0f);
        this.claim4label = new Container<Label>(claimLabel4);
        this.claim4label.setWidth(this.claim4.getWidth());
        this.claim4label.setX(this.claim4.getX());
        this.claim4label.setY(this.claim4.getY() + this.claim4.getHeight() / 2.0f - this.claim4label.getHeight() / 2.0f);
        this.claim4label.setVisible(false);
        this.claim4label.setTransform(true);
        this.stage.addActor(this.claim4label);
        this.clientCharacter = new Stack();
        this.clientSkin = new BaseActor();
        this.clientCharacter.add(this.clientSkin);
        this.clientBody = new BaseActor();
        this.clientCharacter.add(this.clientBody);
        this.clientBodyArmorL = new BaseActor();
        this.clientCharacter.add(this.clientBodyArmorL);
        this.clientBodyArmorT = new BaseActor();
        this.clientCharacter.add(this.clientBodyArmorT);
        this.clientAccessories = new ArrayList();
        for (int i2 = 0; i2 < 5; ++i2) {
            BaseActor accessory = new BaseActor();
            accessory.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
            this.clientAccessories.add(accessory);
            this.clientCharacter.add(accessory);
        }
        this.clientHead = new BaseActor();
        this.clientCharacter.add(this.clientHead);
        this.clientWounds = new ArrayList();
        ArrayList<Integer> takenWounds = new ArrayList<Integer>();
        for (int i3 = 0; i3 < 3; ++i3) {
            BaseActor wound = new BaseActor();
            wound.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
            int woundType = MathUtils.random(5) + 1;
            while (takenWounds.contains(woundType)) {
                woundType = MathUtils.random(5) + 1;
            }
            wound.params.put("type", woundType);
            takenWounds.add(woundType);
            this.clientWounds.add(wound);
            this.clientCharacter.add(wound);
        }
        this.clientArms = new BaseActor();
        this.clientCharacter.add(this.clientArms);
        this.clientSkinExtra = new BaseActor();
        this.clientCharacter.add(this.clientSkinExtra);
        this.clientBodyExtra = new BaseActor();
        this.clientCharacter.add(this.clientBodyExtra);
        this.clientBodyArmorTExtra = new BaseActor();
        this.clientCharacter.add(this.clientBodyArmorTExtra);
        this.clientArmsArmorSL = new BaseActor();
        this.clientCharacter.add(this.clientArmsArmorSL);
        this.clientArmsArmorSPL = new BaseActor();
        this.clientCharacter.add(this.clientArmsArmorSPL);
        this.clientArmsArmorSPR = new BaseActor();
        this.clientCharacter.add(this.clientArmsArmorSPR);
        this.clientArmsArmorBRL = new BaseActor();
        this.clientCharacter.add(this.clientArmsArmorBRL);
        this.clientArmsArmorBRR = new BaseActor();
        this.clientCharacter.add(this.clientArmsArmorBRR);
        this.clientBodyBuff = new BaseActor();
        this.clientBodyBuff.setVisible(false);
        this.clientCharacter.add(this.clientBodyBuff);
        this.clientWeapon = new BaseActor();
        this.clientCharacter.add(this.clientWeapon);
        this.clientOffHand = new BaseActor();
        this.clientCharacter.add(this.clientOffHand);
        this.clientCharacter.setTransform(true);
        this.clientCharacter.setSize(this.clientSizeinit, this.clientSizeinit);
        this.clientBodyBuff.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/bodybuff.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
        this.stage.addActor(this.clientCharacter);
        this.drawEnemyFighter("idle", "", this.clientXinit, this.clientYinit, true);
        this.clientCorpse = new BaseActor();
        this.clientCorpse.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/bodyfloor.png"), Texture.class), UIHelpers.calcHeightProportion(this.game, 66.66f, 66.66f).floatValue(), UIHelpers.calcHeightProportion(this.game, 66.66f, 66.66f).floatValue());
        this.clientCorpse.setPosition(this.clientXinit, this.clientYinit);
        this.clientCorpse.setVisible(false);
        this.stage.addActor(this.clientCorpse);
        this.clientKneel = new BaseActor();
        this.clientKneel.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/bodykneel.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
        this.clientKneel.setPosition(this.clientXinit * 60.0f / 100.0f, this.clientYinit * 60.0f / 100.0f);
        this.clientKneel.setVisible(false);
        this.stage.addActor(this.clientKneel);
        if (!this.scenario.equalsIgnoreCase("") && !(scenarioFrontImage = ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getString("front")).equalsIgnoreCase("")) {
            this.scenarioFront = new BaseActor();
            UIHelpers.portraitModeFixBackground(this.game, this.scenarioFront, this.game.getOverridenFilename("data/backgrounds/" + scenarioFrontImage), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
            this.stage.addActor(this.scenarioFront);
        }
        if (this.clientFighter.name.equalsIgnoreCase("boss2")) {
            this.bossActor1.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/esplightcloud.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
            this.bossActor1.setX(0.0f);
            this.bossActor1.setY(0.0f);
            this.bossActor1.params.put("type", "lightcloud");
            this.bossActor1.setVisible(false);
            this.stage.addActor(this.bossActor1);
            this.bossActor2.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/esplightbolt.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
            this.bossActor2.params.put("type", "lightbolt");
            this.bossActor2.setVisible(false);
            this.stage.addActor(this.bossActor2);
        }
        this.hostCharacter = new Stack();
        this.hostBodyArmor = new BaseActor();
        this.hostCharacter.add(this.hostBodyArmor);
        this.hostHeadArmor = new BaseActor();
        this.hostCharacter.add(this.hostHeadArmor);
        this.hostArmsArmorBR = new BaseActor();
        this.hostCharacter.add(this.hostArmsArmorBR);
        this.hostBodyBuff = new BaseActor();
        this.hostBodyBuff.setVisible(false);
        this.hostCharacter.add(this.hostBodyBuff);
        this.hostWeapon = new BaseActor();
        this.hostCharacter.add(this.hostWeapon);
        this.hostOffHand = new BaseActor();
        this.hostCharacter.add(this.hostOffHand);
        this.hostBody = new BaseActor();
        this.hostCharacter.add(this.hostBody);
        this.hostCharacter.setTransform(true);
        this.hostCharacter.setSize(this.hostSizeinit, this.hostSizeinit);
        this.hostBodyBuff.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/pcarmsbuff.png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
        this.stage.addActor(this.hostCharacter);
        this.drawPCFighter("idle", "", this.hostXinit, this.hostYinit, true);
        if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.equalsIgnoreCase("boss3")) {
            this.bossActor1.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/espsmoke.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
            this.bossActor1.setVisible(false);
            this.bossActor1.params.put("type", this.game.saveGame.get("rewards").contains("warbos") ? "2" : "1");
            this.bossActor1.params.put("stage", "0");
            this.stage.addActor(this.bossActor1);
            this.bossActor2.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/espspearback.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
            this.bossActor2.setVisible(false);
            this.stage.addActor(this.bossActor2);
        }
        this.combatHitHost = new BaseActor();
        this.combatHitHost.setTexture(combatElementsAtlas.findRegion(this.game.violenceFilter ? "damagenonviolent" : "damage"), UIHelpers.calcHeightProportion(this.game, 50.0f, 40.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 37.5f, 30.0f).floatValue());
        this.combatHitHost.setVisible(false);
        this.combatHitHost.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue());
        this.combatHitHost.setY(UIHelpers.calcHeightProportion(this.game, 40.0f, 50.0f).floatValue());
        this.stage.addActor(this.combatHitHost);
        TextureAtlas portraitsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
        this.stunScreen = new BaseActor();
        this.stunScreen.setTexture(combatElementsAtlas.findRegion("stunscreen"), UIHelpers.calcWidthProportion(this.game, 140.0f, 180.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 140.0f, 140.0f).floatValue());
        this.stunScreen.setPosition(-UIHelpers.calcWidthProportion(this.game, 20.0f, 40.0f).floatValue(), -UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
        this.stunScreen.setVisible(false);
        this.stage.addActor(this.stunScreen);
        this.bleedScreen = new BaseActor();
        this.bleedScreen.setTexture(combatElementsAtlas.findRegion("bleedscreen"), UIHelpers.calcWidthProportion(this.game, 110.0f, 140.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 110.0f, 110.0f).floatValue());
        this.bleedScreen.setPosition(-UIHelpers.calcWidthProportion(this.game, 5.0f, 20.0f).floatValue(), -UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.bleedScreen.setVisible(false);
        this.stage.addActor(this.bleedScreen);
        this.fireScreen = new BaseActor();
        this.fireScreen.setTexture(combatElementsAtlas.findRegion("fire"), UIHelpers.calcWidthProportion(this.game, 100.0f, 100.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.fireScreen.setPosition(0.0f, 0.0f);
        this.fireScreen.setVisible(false);
        this.stage.addActor(this.fireScreen);
        this.lightningScreen = new BaseActor();
        this.lightningScreen.setTexture(combatElementsAtlas.findRegion("lightning"), UIHelpers.calcWidthProportion(this.game, 110.0f, 140.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 110.0f, 110.0f).floatValue());
        this.lightningScreen.setPosition(-UIHelpers.calcWidthProportion(this.game, 5.0f, 20.0f).floatValue(), -UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.lightningScreen.setVisible(false);
        this.stage.addActor(this.lightningScreen);
        BaseActor clientPanel = new BaseActor();
        clientPanel.setTexture(uiAtlas.findRegion("panel"), UIHelpers.calcHeightProportion(this.game, 32.0f, 32.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        clientPanel.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue() - clientPanel.getWidth());
        clientPanel.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue() - clientPanel.getHeight());
        this.stage.addActor(clientPanel);
        Stack portraitP1 = new Stack();
        portraitP1.setWidth(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        portraitP1.setHeight(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.clientPortrait = new BaseActor();
        this.clientPortrait.setTexture(portraitsAtlas.findRegion(this.clientFighter.portrait), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        portraitP1.add(this.clientPortrait);
        BaseActor portraitFrameP1 = new BaseActor();
        portraitFrameP1.setTexture(portraitsAtlas.findRegion("portraitframe"), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        portraitP1.add(portraitFrameP1);
        portraitP1.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 22.0f, 22.0f).floatValue() - portraitP1.getWidth());
        portraitP1.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - portraitP1.getHeight());
        this.stage.addActor(portraitP1);
        BaseActor baseLifeBarClient = new BaseActor();
        baseLifeBarClient.setTexture(uiAtlas.findRegion("statbar"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        baseLifeBarClient.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - baseLifeBarClient.getWidth());
        baseLifeBarClient.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - baseLifeBarClient.getHeight());
        this.stage.addActor(baseLifeBarClient);
        float barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)Math.min(this.clientFighter.maxLife, 10000) / 10000.0f;
        BaseActor clientLifeBarMax = new BaseActor();
        clientLifeBarMax.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        clientLifeBarMax.getColor().a = 0.4f;
        clientLifeBarMax.setWidth(barWidth);
        clientLifeBarMax.regionWidth = Float.valueOf((float)(200 * Math.min(this.clientFighter.maxLife, 10000)) / 10000.0f).intValue();
        clientLifeBarMax.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - clientLifeBarMax.getWidth());
        clientLifeBarMax.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - clientLifeBarMax.getHeight());
        this.stage.addActor(clientLifeBarMax);
        this.clientLifeBarShadow = new BaseActor();
        this.clientLifeBarShadow.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.clientLifeBarShadow.setWidth(barWidth);
        this.clientLifeBarShadow.regionWidth = Float.valueOf((float)(200 * Math.min(this.clientFighter.life, 10000)) / 10000.0f).intValue();
        this.clientLifeBarShadow.setColor(0.2f, 0.0f, 0.0f, 1.0f);
        this.clientLifeBarShadow.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - this.clientLifeBarShadow.getWidth());
        this.clientLifeBarShadow.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - this.clientLifeBarShadow.getHeight());
        this.stage.addActor(this.clientLifeBarShadow);
        this.clientLifeBar = new BaseActor();
        this.clientLifeBar.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.clientLifeBar.setWidth(barWidth);
        this.clientLifeBar.regionWidth = Float.valueOf((float)(200 * Math.min(this.clientFighter.life, 10000)) / 10000.0f).intValue();
        this.clientLifeBar.setColor(1.0f, 0.0f, 0.0f, 1.0f);
        this.clientLifeBar.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - this.clientLifeBar.getWidth());
        this.clientLifeBar.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - this.clientLifeBar.getHeight());
        this.stage.addActor(this.clientLifeBar);
        BaseActor baseStaminaBarClient = new BaseActor();
        baseStaminaBarClient.setTexture(uiAtlas.findRegion("statbar"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        baseStaminaBarClient.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - baseStaminaBarClient.getWidth());
        baseStaminaBarClient.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 5.35f, 5.35f).floatValue() - baseStaminaBarClient.getHeight());
        this.stage.addActor(baseStaminaBarClient);
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.clientFighter.maxStamina / 10000.0f;
        BaseActor clientStaminaBarMax = new BaseActor();
        clientStaminaBarMax.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        clientStaminaBarMax.getColor().a = 0.4f;
        clientStaminaBarMax.setWidth(barWidth);
        clientStaminaBarMax.regionWidth = Float.valueOf((float)(200 * this.clientFighter.maxStamina) / 10000.0f).intValue();
        clientStaminaBarMax.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - clientStaminaBarMax.getWidth());
        clientStaminaBarMax.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 5.35f, 5.35f).floatValue() - clientStaminaBarMax.getHeight());
        this.stage.addActor(clientStaminaBarMax);
        this.clientStaminaBarShadow = new BaseActor();
        this.clientStaminaBarShadow.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.clientStaminaBarShadow.setWidth(barWidth);
        this.clientStaminaBarShadow.regionWidth = Float.valueOf((float)(200 * this.clientFighter.stamina) / 10000.0f).intValue();
        this.clientStaminaBarShadow.setColor(0.2f, 0.2f, 0.0f, 1.0f);
        this.clientStaminaBarShadow.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - this.clientStaminaBarShadow.getWidth());
        this.clientStaminaBarShadow.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 5.35f, 5.35f).floatValue() - this.clientStaminaBarShadow.getHeight());
        this.stage.addActor(this.clientStaminaBarShadow);
        this.clientStaminaBar = new BaseActor();
        this.clientStaminaBar.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.clientStaminaBar.setWidth(barWidth);
        this.clientStaminaBar.regionWidth = Float.valueOf((float)(200 * this.clientFighter.stamina) / 10000.0f).intValue();
        this.clientStaminaBar.setColor(1.0f, 1.0f, 0.0f, 1.0f);
        this.clientStaminaBar.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - this.clientStaminaBar.getWidth());
        this.clientStaminaBar.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 5.35f, 5.35f).floatValue() - this.clientStaminaBar.getHeight());
        this.stage.addActor(this.clientStaminaBar);
        BaseActor baseBalanceBarClient = new BaseActor();
        baseBalanceBarClient.setTexture(uiAtlas.findRegion("statbar"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        baseBalanceBarClient.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - baseBalanceBarClient.getWidth());
        baseBalanceBarClient.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 8.7f, 8.7f).floatValue() - baseBalanceBarClient.getHeight());
        this.stage.addActor(baseBalanceBarClient);
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.clientFighter.maxBalance / 10000.0f;
        BaseActor clientBalanceBarMax = new BaseActor();
        clientBalanceBarMax.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        clientBalanceBarMax.getColor().a = 0.4f;
        clientBalanceBarMax.setWidth(barWidth);
        clientBalanceBarMax.regionWidth = Float.valueOf((float)(200 * this.clientFighter.maxBalance) / 10000.0f).intValue();
        clientBalanceBarMax.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - clientBalanceBarMax.getWidth());
        clientBalanceBarMax.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 8.7f, 8.7f).floatValue() - clientBalanceBarMax.getHeight());
        this.stage.addActor(clientBalanceBarMax);
        this.clientBalanceBarShadow = new BaseActor();
        this.clientBalanceBarShadow.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.clientBalanceBarShadow.setWidth(barWidth);
        this.clientBalanceBarShadow.regionWidth = Float.valueOf((float)(200 * this.clientFighter.balance) / 10000.0f).intValue();
        this.clientBalanceBarShadow.setColor(0.0f, 0.2f, 0.0f, 1.0f);
        this.clientBalanceBarShadow.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - this.clientBalanceBarShadow.getWidth());
        this.clientBalanceBarShadow.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 8.7f, 8.7f).floatValue() - this.clientBalanceBarShadow.getHeight());
        this.stage.addActor(this.clientBalanceBarShadow);
        this.clientBalanceBar = new BaseActor();
        this.clientBalanceBar.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.clientBalanceBar.setWidth(barWidth);
        this.clientBalanceBar.regionWidth = Float.valueOf((float)(200 * this.clientFighter.balance) / 10000.0f).intValue();
        this.clientBalanceBar.setColor(0.0f, 1.0f, 0.0f, 1.0f);
        this.clientBalanceBar.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - this.clientBalanceBar.getWidth());
        this.clientBalanceBar.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 8.7f, 8.7f).floatValue() - this.clientBalanceBar.getHeight());
        this.stage.addActor(this.clientBalanceBar);
        this.clientIconBar = new ArrayList();
        for (int i4 = 0; i4 < 8; ++i4) {
            BaseActor effectActor = new BaseActor();
            effectActor.setX(clientPanel.getX() - UIHelpers.calcHeightProportion(this.game, 5.5f, 5.5f).floatValue() * (float)(i4 + 1));
            effectActor.setY(clientPanel.getY() + clientPanel.getHeight() / 2.0f - UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue());
            effectActor.setVisible(false);
            this.stage.addActor(effectActor);
            this.clientIconBar.add(effectActor);
        }
        if (this.game.gameMode.equalsIgnoreCase("tournament") && this.clientFighter.name.equalsIgnoreCase("boss3")) {
            this.bossActor3 = new Label("", this.game.uiSkin, "default");
            this.bossActor3.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 2.0f));
            this.bossActor3.setColor(1.0f, 0.5f, 0.0f, 1.0f);
            this.bossActor3.setText("++");
            this.bossActor3.setAlignment(16);
            this.bossActor3.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue());
            this.bossActor3.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 3.75f, 3.75f).floatValue());
            this.bossActor3.setVisible(true);
            this.stage.addActor(this.bossActor3);
        }
        BaseActor hostPanel = new BaseActor();
        hostPanel.setTexture(uiAtlas.findRegion("panel"), UIHelpers.calcHeightProportion(this.game, 32.0f, 32.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        hostPanel.setX(UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        hostPanel.setY(UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.stage.addActor(hostPanel);
        Stack portraitP2 = new Stack();
        portraitP2.setWidth(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        portraitP2.setHeight(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.hostPortrait = new BaseActor();
        this.hostPortrait.setTexture(portraitsAtlas.findRegion(this.hostFighter.portrait), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        portraitP2.add(this.hostPortrait);
        BaseActor portraitFrameP2 = new BaseActor();
        portraitFrameP2.setTexture(portraitsAtlas.findRegion("portraitframe"), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        portraitP2.add(portraitFrameP2);
        portraitP2.setX(UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        portraitP2.setY(UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.stage.addActor(portraitP2);
        BaseActor baseLifeBarHost = new BaseActor();
        baseLifeBarHost.setTexture(uiAtlas.findRegion("statbar"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        baseLifeBarHost.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        baseLifeBarHost.setY(UIHelpers.calcHeightProportion(this.game, 8.7f, 8.7f).floatValue());
        this.stage.addActor(baseLifeBarHost);
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.hostFighter.maxLife / 10000.0f;
        BaseActor hostLifeBarMax = new BaseActor();
        hostLifeBarMax.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        hostLifeBarMax.getColor().a = 0.4f;
        hostLifeBarMax.setWidth(barWidth);
        hostLifeBarMax.regionWidth = Float.valueOf((float)(200 * this.hostFighter.maxLife) / 10000.0f).intValue();
        hostLifeBarMax.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        hostLifeBarMax.setY(UIHelpers.calcHeightProportion(this.game, 8.7f, 8.7f).floatValue());
        this.stage.addActor(hostLifeBarMax);
        this.hostLifeBarShadow = new BaseActor();
        this.hostLifeBarShadow.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.hostLifeBarShadow.setWidth(barWidth);
        this.hostLifeBarShadow.regionWidth = Float.valueOf((float)(200 * this.hostFighter.life) / 10000.0f).intValue();
        this.hostLifeBarShadow.setColor(0.2f, 0.0f, 0.0f, 1.0f);
        this.hostLifeBarShadow.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        this.hostLifeBarShadow.setY(UIHelpers.calcHeightProportion(this.game, 8.7f, 8.7f).floatValue());
        this.stage.addActor(this.hostLifeBarShadow);
        this.hostLifeBar = new BaseActor();
        this.hostLifeBar.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.hostLifeBar.setWidth(barWidth);
        this.hostLifeBar.regionWidth = Float.valueOf((float)(200 * this.hostFighter.life) / 10000.0f).intValue();
        this.hostLifeBar.setColor(1.0f, 0.0f, 0.0f, 1.0f);
        this.hostLifeBar.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        this.hostLifeBar.setY(UIHelpers.calcHeightProportion(this.game, 8.7f, 8.7f).floatValue());
        this.stage.addActor(this.hostLifeBar);
        BaseActor baseStaminaBarHost = new BaseActor();
        baseStaminaBarHost.setTexture(uiAtlas.findRegion("statbar"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        baseStaminaBarHost.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        baseStaminaBarHost.setY(UIHelpers.calcHeightProportion(this.game, 5.35f, 5.35f).floatValue());
        this.stage.addActor(baseStaminaBarHost);
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.hostFighter.maxStamina / 10000.0f;
        BaseActor hostStaminaBarMax = new BaseActor();
        hostStaminaBarMax.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        hostStaminaBarMax.getColor().a = 0.4f;
        hostStaminaBarMax.setWidth(barWidth);
        hostStaminaBarMax.regionWidth = Float.valueOf((float)(200 * this.hostFighter.maxStamina) / 10000.0f).intValue();
        hostStaminaBarMax.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        hostStaminaBarMax.setY(UIHelpers.calcHeightProportion(this.game, 5.35f, 5.35f).floatValue());
        this.stage.addActor(hostStaminaBarMax);
        this.hostStaminaBarShadow = new BaseActor();
        this.hostStaminaBarShadow.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.hostStaminaBarShadow.setWidth(barWidth);
        this.hostStaminaBarShadow.regionWidth = Float.valueOf((float)(200 * this.hostFighter.stamina) / 10000.0f).intValue();
        this.hostStaminaBarShadow.setColor(0.2f, 0.2f, 0.0f, 1.0f);
        this.hostStaminaBarShadow.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        this.hostStaminaBarShadow.setY(UIHelpers.calcHeightProportion(this.game, 5.35f, 5.35f).floatValue());
        this.stage.addActor(this.hostStaminaBarShadow);
        this.hostStaminaBar = new BaseActor();
        this.hostStaminaBar.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.hostStaminaBar.setWidth(barWidth);
        this.hostStaminaBar.regionWidth = Float.valueOf((float)(200 * this.hostFighter.stamina) / 10000.0f).intValue();
        this.hostStaminaBar.setColor(1.0f, 1.0f, 0.0f, 1.0f);
        this.hostStaminaBar.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        this.hostStaminaBar.setY(UIHelpers.calcHeightProportion(this.game, 5.35f, 5.35f).floatValue());
        this.stage.addActor(this.hostStaminaBar);
        BaseActor baseBalanceBarHost = new BaseActor();
        baseBalanceBarHost.setTexture(uiAtlas.findRegion("statbar"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        baseBalanceBarHost.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        baseBalanceBarHost.setY(UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.stage.addActor(baseBalanceBarHost);
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.hostFighter.maxBalance / 10000.0f;
        BaseActor hostBalanceBarMax = new BaseActor();
        hostBalanceBarMax.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        hostBalanceBarMax.getColor().a = 0.4f;
        hostBalanceBarMax.setWidth(barWidth);
        hostBalanceBarMax.regionWidth = Float.valueOf((float)(200 * this.hostFighter.maxBalance) / 10000.0f).intValue();
        hostBalanceBarMax.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        hostBalanceBarMax.setY(UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.stage.addActor(hostBalanceBarMax);
        this.hostBalanceBarShadow = new BaseActor();
        this.hostBalanceBarShadow.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.0f, 3.0f).floatValue());
        this.hostBalanceBarShadow.setWidth(barWidth);
        this.hostBalanceBarShadow.regionWidth = Float.valueOf((float)(200 * this.hostFighter.balance) / 10000.0f).intValue();
        this.hostBalanceBarShadow.setColor(0.0f, 0.2f, 0.0f, 1.0f);
        this.hostBalanceBarShadow.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        this.hostBalanceBarShadow.setY(UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.stage.addActor(this.hostBalanceBarShadow);
        this.hostBalanceBar = new BaseActor();
        this.hostBalanceBar.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.0f, 3.0f).floatValue());
        this.hostBalanceBar.setWidth(barWidth);
        this.hostBalanceBar.regionWidth = Float.valueOf((float)(200 * this.hostFighter.balance) / 10000.0f).intValue();
        this.hostBalanceBar.setColor(0.0f, 1.0f, 0.0f, 1.0f);
        this.hostBalanceBar.setX(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
        this.hostBalanceBar.setY(UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.stage.addActor(this.hostBalanceBar);
        this.hostIconBar = new ArrayList();
        for (int i5 = 0; i5 < 8; ++i5) {
            BaseActor effectActor = new BaseActor();
            effectActor.setX(hostPanel.getX() + hostPanel.getWidth() + UIHelpers.calcHeightProportion(this.game, 0.5f, 0.5f).floatValue() + UIHelpers.calcHeightProportion(this.game, 5.5f, 5.5f).floatValue() * (float)i5);
            effectActor.setY(hostPanel.getY() + hostPanel.getHeight() / 2.0f - UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue());
            effectActor.setVisible(false);
            this.stage.addActor(effectActor);
            this.hostIconBar.add(effectActor);
        }
        this.talkDirection = new BaseActor();
        this.talkDirection.setTexture(uiAtlas.findRegion("talkdirection"), UIHelpers.calcHeightProportion(this.game, 12.5f, 10.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.talkDirection.setVisible(false);
        this.talkDirection.setX(UIHelpers.calcHeightProportion(this.game, 80.0f, 47.0f).floatValue());
        this.talkDirection.setY(UIHelpers.calcHeightProportion(this.game, 74.0f, 69.0f).floatValue());
        this.stage.addActor(this.talkDirection);
        this.talkBackground = new BaseActor();
        this.talkBackground.setTexture(uiAtlas.findRegion("talkbackground"), UIHelpers.calcHeightProportion(this.game, 25.0f, 21.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 5.0f, 10.0f).floatValue());
        this.talkBackground.setVisible(false);
        this.talkBackground.setX(UIHelpers.calcHeightProportion(this.game, 87.0f, 50.0f).floatValue());
        this.talkBackground.setY(UIHelpers.calcHeightProportion(this.game, 80.0f, 75.0f).floatValue() - this.talkBackground.getHeight());
        this.stage.addActor(this.talkBackground);
        this.talkSentence = new Label("", this.game.uiSkin, "default");
        this.talkSentence.setAlignment(10);
        this.talkSentence.setColor(this.game.uiSkin.get("lightgrey", Color.class));
        this.talkSentence.setWrap(true);
        this.talkSentence.setVisible(false);
        this.talkSentence.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.talkSentence.setWidth(UIHelpers.calcHeightProportion(this.game, 22.0f, 19.0f).floatValue());
        this.talkSentence.setX(UIHelpers.calcHeightProportion(this.game, 89.0f, 51.0f).floatValue());
        this.talkSentence.setY(UIHelpers.calcHeightProportion(this.game, 79.0f, 74.0f).floatValue());
        this.stage.addActor(this.talkSentence);
        TextureAtlas combatButtonsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), TextureAtlas.class);
        this.timeLimitLabel = new Label(this.timeLimitTime > 0L ? "" + this.timeLimitTime / 1000L : "", this.game.uiSkin, "combat");
        this.timeLimitLabel.setColor(this.game.uiSkin.get("darkgrey", Color.class));
        this.timeLimitLabel.setAlignment(1);
        this.timeLimitLabel.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 2.0f));
        this.timeLimitLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 5.0f, 10.0f).floatValue());
        this.timeLimitLabel.setHeight(this.timeLimitLabel.getPrefHeight());
        this.timeLimitLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.timeLimitLabel.getWidth() / 2.0f);
        this.timeLimitLabel.setY(UIHelpers.calcHeightProportion(this.game, 92.0f, 87.0f).floatValue());
        this.timeLimitLabel.setVisible(this.timeLimitTime > 0L);
        this.stage.addActor(this.timeLimitLabel);
        this.timeLimitIndex = new BaseActor();
        this.timeLimitIndex.setTexture(combatButtonsAtlas.findRegion("assaultindex"), UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.timeLimitIndex.setColor(new Color(0.0f, 0.7f, 0.7f, 1.0f));
        this.timeLimitIndex.setX(UIHelpers.calcWidthProportion(this.game, 49.0f, 49.0f).floatValue() - this.timeLimitIndex.getWidth() - this.timeLimitLabel.getWidth() / 2.0f);
        this.timeLimitIndex.setY(this.timeLimitLabel.getY() + this.timeLimitLabel.getPrefHeight() / 2.0f - this.timeLimitIndex.getHeight() / 2.0f);
        this.timeLimitIndex.rotateBy(180.0f);
        this.timeLimitIndex.setOrigin(this.timeLimitIndex.getWidth() / 2.0f, this.timeLimitIndex.getHeight() / 2.0f);
        this.timeLimitIndex.setVisible(false);
        this.stage.addActor(this.timeLimitIndex);
        this.combatLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.start") + "\n5", this.game.uiSkin, "combat");
        this.combatLabel.setColor(this.game.uiSkin.get("darkgrey", Color.class));
        this.combatLabel.setAlignment(1);
        this.combatLabel.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 2.0f));
        this.combatLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 65.0f, 75.0f).floatValue());
        this.combatLabel.setHeight(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.combatLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.combatLabel.getWidth() / 2.0f);
        this.combatLabel.setY(UIHelpers.calcHeightProportion(this.game, 80.0f, 75.0f).floatValue());
        this.stage.addActor(this.combatLabel);
        this.combatParry = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combateffects.atlas"), "parry", 13, UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue(), false);
        this.combatParry.setWidth(UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue());
        this.combatParry.setHeight(UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue());
        this.combatParry.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.combatParry.getWidth() / 2.0f);
        this.combatParry.setY(UIHelpers.calcHeightProportion(this.game, 16.5f, 25.0f).floatValue());
        this.stage.addActor(this.combatParry);
        this.combatDodgeLeft = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combateffects.atlas"), "dodgeleft", 4, UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue(), false);
        this.combatDodgeLeft.setWidth(UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue());
        this.combatDodgeLeft.setHeight(UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue());
        this.combatDodgeLeft.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.combatDodgeLeft.getWidth() / 2.0f);
        this.combatDodgeLeft.setY(UIHelpers.calcHeightProportion(this.game, 16.5f, 25.0f).floatValue());
        this.stage.addActor(this.combatDodgeLeft);
        this.combatDodgeRight = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combateffects.atlas"), "dodgeright", 4, UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue(), false);
        this.combatDodgeRight.setWidth(UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue());
        this.combatDodgeRight.setHeight(UIHelpers.calcHeightProportion(this.game, 65.0f, 50.0f).floatValue());
        this.combatDodgeRight.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.combatDodgeRight.getWidth() / 2.0f);
        this.combatDodgeRight.setY(UIHelpers.calcHeightProportion(this.game, 16.5f, 25.0f).floatValue());
        this.stage.addActor(this.combatDodgeRight);
        this.combatShardEffect = new BaseActor();
        this.combatShardEffect.setTexture(combatElementsAtlas.findRegion("shardeffect"), UIHelpers.calcHeightProportion(this.game, 16.5f, 12.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 16.5f, 12.5f).floatValue());
        this.combatShardEffect.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.combatShardEffect.getWidth() / 2.0f);
        this.combatShardEffect.setY(UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue() - this.combatShardEffect.getHeight() / 2.0f);
        this.combatShardEffect.setVisible(false);
        this.stage.addActor(this.combatShardEffect);
        this.combatPowderEffect = new BaseActor();
        this.combatPowderEffect.setTexture(combatElementsAtlas.findRegion("powdereffect"), UIHelpers.calcHeightProportion(this.game, 33.0f, 25.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 33.0f, 25.0f).floatValue());
        this.combatPowderEffect.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.combatPowderEffect.getWidth() / 2.0f);
        this.combatPowderEffect.setY(UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue() - this.combatPowderEffect.getHeight() / 2.0f);
        this.combatPowderEffect.setVisible(false);
        this.stage.addActor(this.combatPowderEffect);
        this.combatNetEffect = new BaseActor();
        this.combatNetEffect.setTexture(combatElementsAtlas.findRegion("neteffect"), UIHelpers.calcHeightProportion(this.game, 33.0f, 25.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 33.0f, 25.0f).floatValue());
        this.combatNetEffect.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.combatNetEffect.getWidth() * 2.0f / 3.0f);
        this.combatNetEffect.setY(UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue() - this.combatNetEffect.getHeight() * 2.0f / 3.0f);
        this.combatNetEffect.setVisible(false);
        this.stage.addActor(this.combatNetEffect);
        this.baseEventBar = new BaseActor();
        this.baseEventBar.setTexture(uiAtlas.findRegion("eventbar"), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue(), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
        this.baseEventBar.setX(UIHelpers.calcHeightProportion(this.game, 4.35f, 4.35f).floatValue());
        this.baseEventBar.setY(UIHelpers.calcHeightProportion(this.game, 40.0f, 40.0f).floatValue());
        this.stage.addActor(this.baseEventBar);
        this.surgeEventBar = new BaseActor();
        this.surgeEventBar.setTexture(new TextureRegion(uiAtlas.findRegion("eventbarfill")), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue(), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
        this.surgeEventBar.setColor(0.976f, 0.564f, 0.0f, 1.0f);
        this.surgeEventBar.setX(UIHelpers.calcHeightProportion(this.game, 4.35f, 4.35f).floatValue());
        this.surgeEventBar.setY(UIHelpers.calcHeightProportion(this.game, 40.0f, 40.0f).floatValue());
        this.surgeRegionYinit = this.surgeEventBar.regionY;
        this.stage.addActor(this.surgeEventBar);
        this.pressureBar = new BaseActor();
        this.pressureBar.setTexture(uiAtlas.findRegion("pressure"), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.pressureBar.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 11.0f, 11.0f).floatValue());
        this.pressureBar.setY(this.game.viewHeight.floatValue() / 2.0f - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.stage.addActor(this.pressureBar);
        RepeatAction beat = new RepeatAction();
        beat.setAction(Actions.sequence((Action)Actions.scaleTo(1.05f, 1.05f, 1.0f), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f)));
        beat.setCount(-1);
        this.pressureBar.addAction(beat);
        this.assaultClientBar = new ArrayList();
        for (i = 0; i < 5; ++i) {
            assaultIndex = new BaseActor();
            assaultIndex.setTexture(combatButtonsAtlas.findRegion("assaultindex"), UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue());
            assaultIndex.setColor(new Color(0.7f, 0.0f, 0.0f, 1.0f));
            assaultIndex.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 3.5f, 3.5f).floatValue() - UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue() * (float)i);
            assaultIndex.setY(this.game.viewHeight.floatValue() / 2.0f + UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
            assaultIndex.rotateBy(180.0f);
            assaultIndex.setOrigin(assaultIndex.getWidth() / 2.0f, assaultIndex.getHeight() / 2.0f);
            assaultIndex.setVisible(false);
            this.assaultClientBar.add(assaultIndex);
            this.stage.addActor(assaultIndex);
        }
        this.assaultHostBar = new ArrayList();
        for (i = 0; i < 5; ++i) {
            assaultIndex = new BaseActor();
            assaultIndex.setTexture(combatButtonsAtlas.findRegion("assaultindex"), UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue());
            assaultIndex.setColor(new Color(0.0f, 0.3f, 0.7f, 1.0f));
            assaultIndex.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 3.5f, 3.5f).floatValue() - UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue() * (float)i);
            assaultIndex.setY(this.game.viewHeight.floatValue() / 2.0f - UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue() - UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue());
            assaultIndex.setVisible(false);
            this.assaultHostBar.add(assaultIndex);
            this.stage.addActor(assaultIndex);
        }
        this.upMiddleAttack = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), "buttonattack", 20, UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), false);
        this.upMiddleAttack.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent ev, float x, float y, int pointer, int button) {
                CombatScreen.this.checkCombatIntput(CombatScreen.this.upMiddleAttack, "attack", "middle");
                return true;
            }
        });
        this.upMiddleAttack.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.upMiddleAttack.getWidth() / 2.0f);
        this.upMiddleAttack.setY(UIHelpers.calcHeightProportion(this.game, 80.0f, 80.0f).floatValue() - this.upMiddleAttack.getHeight() / 2.0f);
        this.stage.addActor(this.upMiddleAttack);
        this.upMiddleAttackb = new BaseActor();
        this.upMiddleAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)(Float.valueOf(this.upMiddleAttack.getWidth()).intValue() + 2), (float)(Float.valueOf(this.upMiddleAttack.getHeight()).intValue() + 2));
        this.upMiddleAttackb.setX(this.upMiddleAttack.getX() - 1.0f);
        this.upMiddleAttackb.setY(this.upMiddleAttack.getY() - 1.0f);
        this.upMiddleAttackb.setVisible(false);
        this.upMiddleAttackb.setTouchable(Touchable.disabled);
        this.stage.addActor(this.upMiddleAttackb);
        this.upMiddleParry = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), "buttonparry", 20, UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), false);
        this.upMiddleParry.rotateBy(270.0f);
        this.upMiddleParry.setOrigin(this.upMiddleParry.getWidth() / 2.0f, this.upMiddleParry.getHeight() / 2.0f);
        this.upMiddleParry.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent ev, float x, float y, int pointer, int button) {
                CombatScreen.this.checkCombatIntput(CombatScreen.this.upMiddleParry, "parry", "middle");
                return true;
            }
        });
        this.upMiddleParry.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.upMiddleParry.getWidth() / 2.0f);
        this.upMiddleParry.setY(UIHelpers.calcHeightProportion(this.game, 80.0f, 80.0f).floatValue() - this.upMiddleParry.getHeight() / 2.0f);
        this.stage.addActor(this.upMiddleParry);
        this.upMiddleParryb = new BaseActor();
        this.upMiddleParryb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)(Float.valueOf(this.upMiddleParry.getWidth()).intValue() + 2), (float)(Float.valueOf(this.upMiddleParry.getHeight()).intValue() + 2));
        this.upMiddleParryb.rotateBy(270.0f);
        this.upMiddleParryb.setOrigin(this.upMiddleParryb.getWidth() / 2.0f, this.upMiddleParryb.getHeight() / 2.0f);
        this.upMiddleParryb.setX(this.upMiddleParry.getX() - 1.0f);
        this.upMiddleParryb.setY(this.upMiddleParry.getY() - 1.0f);
        this.upMiddleParryb.setVisible(false);
        this.upMiddleParryb.setTouchable(Touchable.disabled);
        if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("parryTime") < 1.0f) {
            this.upMiddleParryb.setColor(Color.valueOf("FF0000FF"));
        }
        this.stage.addActor(this.upMiddleParryb);
        this.centerLeftAttack = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), "buttonattack", 20, UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), false);
        this.centerLeftAttack.rotateBy(45.0f);
        this.centerLeftAttack.setOrigin(this.centerLeftAttack.getWidth() / 2.0f, this.centerLeftAttack.getHeight() / 2.0f);
        this.centerLeftAttack.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent ev, float x, float y, int pointer, int button) {
                CombatScreen.this.checkCombatIntput(CombatScreen.this.centerLeftAttack, "attack", "left");
                return true;
            }
        });
        this.centerLeftAttack.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue() - this.centerLeftAttack.getWidth() / 2.0f);
        this.centerLeftAttack.setY(UIHelpers.calcHeightProportion(this.game, 60.0f, 60.0f).floatValue() - this.centerLeftAttack.getHeight() / 2.0f);
        this.stage.addActor(this.centerLeftAttack);
        this.centerLeftAttackb = new BaseActor();
        this.centerLeftAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)(Float.valueOf(this.centerLeftAttack.getWidth()).intValue() + 2), (float)(Float.valueOf(this.centerLeftAttack.getHeight()).intValue() + 2));
        this.centerLeftAttackb.rotateBy(45.0f);
        this.centerLeftAttackb.setOrigin(this.centerLeftAttackb.getWidth() / 2.0f, this.centerLeftAttackb.getHeight() / 2.0f);
        this.centerLeftAttackb.setX(this.centerLeftAttack.getX() - 1.0f);
        this.centerLeftAttackb.setY(this.centerLeftAttack.getY() - 1.0f);
        this.centerLeftAttackb.setVisible(false);
        this.centerLeftAttackb.setTouchable(Touchable.disabled);
        this.stage.addActor(this.centerLeftAttackb);
        this.centerLeftParry = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), "buttonparry", 20, UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), false);
        this.centerLeftParry.rotateBy(315.0f);
        this.centerLeftParry.setOrigin(this.centerLeftParry.getWidth() / 2.0f, this.centerLeftParry.getHeight() / 2.0f);
        this.centerLeftParry.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent ev, float x, float y, int pointer, int button) {
                CombatScreen.this.checkCombatIntput(CombatScreen.this.centerLeftParry, "parry", "left");
                return true;
            }
        });
        this.centerLeftParry.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue() - this.centerLeftParry.getWidth() / 2.0f);
        this.centerLeftParry.setY(UIHelpers.calcHeightProportion(this.game, 60.0f, 60.0f).floatValue() - this.centerLeftParry.getHeight() / 2.0f);
        this.stage.addActor(this.centerLeftParry);
        this.centerLeftParryb = new BaseActor();
        this.centerLeftParryb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)(Float.valueOf(this.centerLeftParry.getWidth()).intValue() + 2), (float)(Float.valueOf(this.centerLeftParry.getHeight()).intValue() + 2));
        this.centerLeftParryb.rotateBy(315.0f);
        this.centerLeftParryb.setOrigin(this.centerLeftParryb.getWidth() / 2.0f, this.centerLeftParryb.getHeight() / 2.0f);
        this.centerLeftParryb.setX(this.centerLeftParry.getX() - 1.0f);
        this.centerLeftParryb.setY(this.centerLeftParry.getY() - 1.0f);
        this.centerLeftParryb.setVisible(false);
        this.centerLeftParryb.setTouchable(Touchable.disabled);
        if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("parryTime") < 1.0f) {
            this.centerLeftParryb.setColor(Color.valueOf("FF0000FF"));
        }
        this.stage.addActor(this.centerLeftParryb);
        this.centerRightAttack = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), "buttonattack", 20, UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), false);
        this.centerRightAttack.rotateBy(315.0f);
        this.centerRightAttack.setOrigin(this.centerRightAttack.getWidth() / 2.0f, this.centerRightAttack.getHeight() / 2.0f);
        this.centerRightAttack.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent ev, float x, float y, int pointer, int button) {
                CombatScreen.this.checkCombatIntput(CombatScreen.this.centerRightAttack, "attack", "right");
                return true;
            }
        });
        this.centerRightAttack.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 75.0f).floatValue() - this.centerRightAttack.getWidth() / 2.0f);
        this.centerRightAttack.setY(UIHelpers.calcHeightProportion(this.game, 60.0f, 60.0f).floatValue() - this.centerRightAttack.getHeight() / 2.0f);
        this.stage.addActor(this.centerRightAttack);
        this.centerRightAttackb = new BaseActor();
        this.centerRightAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)(Float.valueOf(this.centerRightAttack.getWidth()).intValue() + 2), (float)(Float.valueOf(this.centerRightAttack.getHeight()).intValue() + 2));
        this.centerRightAttackb.rotateBy(315.0f);
        this.centerRightAttackb.setOrigin(this.centerRightAttackb.getWidth() / 2.0f, this.centerRightAttackb.getHeight() / 2.0f);
        this.centerRightAttackb.setX(this.centerRightAttack.getX() - 1.0f);
        this.centerRightAttackb.setY(this.centerRightAttack.getY() - 1.0f);
        this.centerRightAttackb.setVisible(false);
        this.centerRightAttackb.setTouchable(Touchable.disabled);
        this.stage.addActor(this.centerRightAttackb);
        this.centerRightParry = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), "buttonparry", 20, UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), false);
        this.centerRightParry.rotateBy(225.0f);
        this.centerRightParry.setOrigin(this.centerRightParry.getWidth() / 2.0f, this.centerRightParry.getHeight() / 2.0f);
        this.centerRightParry.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent ev, float x, float y, int pointer, int button) {
                CombatScreen.this.checkCombatIntput(CombatScreen.this.centerRightParry, "parry", "right");
                return true;
            }
        });
        this.centerRightParry.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 75.0f).floatValue() - this.centerRightParry.getWidth() / 2.0f);
        this.centerRightParry.setY(UIHelpers.calcHeightProportion(this.game, 60.0f, 60.0f).floatValue() - this.centerRightParry.getHeight() / 2.0f);
        this.stage.addActor(this.centerRightParry);
        this.centerRightParryb = new BaseActor();
        this.centerRightParryb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)(Float.valueOf(this.centerRightParry.getWidth()).intValue() + 2), (float)(Float.valueOf(this.centerRightParry.getHeight()).intValue() + 2));
        this.centerRightParryb.rotateBy(225.0f);
        this.centerRightParryb.setOrigin(this.centerRightParryb.getWidth() / 2.0f, this.centerRightParryb.getHeight() / 2.0f);
        this.centerRightParryb.setX(this.centerRightParry.getX() - 1.0f);
        this.centerRightParryb.setY(this.centerRightParry.getY() - 1.0f);
        this.centerRightParryb.setVisible(false);
        this.centerRightParryb.setTouchable(Touchable.disabled);
        if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("parryTime") < 1.0f) {
            this.centerRightParryb.setColor(Color.valueOf("FF0000FF"));
        }
        this.stage.addActor(this.centerRightParryb);
        this.downLeft = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), "buttondodge", 20, UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), false);
        this.downLeft.rotateBy(180.0f);
        this.downLeft.setOrigin(this.downLeft.getWidth() / 2.0f, this.downLeft.getHeight() / 2.0f);
        this.downLeft.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent ev, float x, float y, int pointer, int button) {
                CombatScreen.this.checkCombatIntput(CombatScreen.this.centerRightParry, "dodge", "left");
                return true;
            }
        });
        this.downLeft.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue() - this.downLeft.getWidth() / 2.0f);
        this.downLeft.setY(UIHelpers.calcHeightProportion(this.game, 40.0f, 40.0f).floatValue() - this.downLeft.getHeight() / 2.0f);
        this.stage.addActor(this.downLeft);
        this.downLeftb = new BaseActor();
        this.downLeftb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)(Float.valueOf(this.downLeft.getWidth()).intValue() + 2), (float)(Float.valueOf(this.downLeft.getHeight()).intValue() + 2));
        this.downLeftb.rotateBy(180.0f);
        this.downLeftb.setOrigin(this.downLeftb.getWidth() / 2.0f, this.downLeftb.getHeight() / 2.0f);
        this.downLeftb.setX(this.downLeft.getX() - 1.0f);
        this.downLeftb.setY(this.downLeft.getY() - 1.0f);
        this.downLeftb.setVisible(false);
        this.downLeftb.setTouchable(Touchable.disabled);
        if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("dodgeTime") < 1.0f) {
            this.downLeftb.setColor(Color.valueOf("FF0000FF"));
        }
        this.stage.addActor(this.downLeftb);
        this.downRight = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), "buttondodge", 20, UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), false);
        this.downRight.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent ev, float x, float y, int pointer, int button) {
                CombatScreen.this.checkCombatIntput(CombatScreen.this.centerRightParry, "dodge", "right");
                return true;
            }
        });
        this.downRight.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 75.0f).floatValue() - this.downRight.getWidth() / 2.0f);
        this.downRight.setY(UIHelpers.calcHeightProportion(this.game, 40.0f, 40.0f).floatValue() - this.downRight.getHeight() / 2.0f);
        this.stage.addActor(this.downRight);
        this.downRightb = new BaseActor();
        this.downRightb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)(Float.valueOf(this.downRight.getWidth()).intValue() + 2), (float)(Float.valueOf(this.downRight.getHeight()).intValue() + 2));
        this.downRightb.setX(this.downRight.getX() - 1.0f);
        this.downRightb.setY(this.downRight.getY() - 1.0f);
        this.downRightb.setVisible(false);
        this.downRightb.setTouchable(Touchable.disabled);
        if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("dodgeTime") < 1.0f) {
            this.downRightb.setColor(Color.valueOf("FF0000FF"));
        }
        this.stage.addActor(this.downRightb);
        BaseActor touchScreen = new BaseActor();
        touchScreen.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
        touchScreen.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        touchScreen.setPosition(0.0f, 0.0f);
        touchScreen.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (x >= CombatScreen.this.upMiddleAttack.getX() - CombatScreen.this.upMiddleAttack.getWidth() && x <= CombatScreen.this.upMiddleAttack.getX() + CombatScreen.this.upMiddleAttack.getWidth() * 2.0f && y >= CombatScreen.this.upMiddleAttack.getY() - CombatScreen.this.upMiddleAttack.getHeight() && y <= CombatScreen.this.upMiddleAttack.getY() + CombatScreen.this.upMiddleAttack.getHeight() * 2.0f) {
                    if (CombatScreen.this.upMiddleAttack.isVisible()) {
                        CombatScreen.this.checkCombatIntput(CombatScreen.this.upMiddleAttack, "attack", "middle");
                    } else if (CombatScreen.this.upMiddleParry.isVisible()) {
                        CombatScreen.this.checkCombatIntput(CombatScreen.this.upMiddleParry, "parry", "middle");
                    }
                } else if (x >= CombatScreen.this.centerLeftAttack.getX() - CombatScreen.this.centerLeftAttack.getWidth() && x <= CombatScreen.this.centerLeftAttack.getX() + CombatScreen.this.centerLeftAttack.getWidth() * 2.0f && y >= CombatScreen.this.centerLeftAttack.getY() - CombatScreen.this.centerLeftAttack.getHeight() && y <= CombatScreen.this.centerLeftAttack.getY() + CombatScreen.this.centerLeftAttack.getHeight() * 2.0f) {
                    if (CombatScreen.this.centerLeftAttack.isVisible()) {
                        CombatScreen.this.checkCombatIntput(CombatScreen.this.centerLeftAttack, "attack", "left");
                    } else if (CombatScreen.this.centerLeftParry.isVisible()) {
                        CombatScreen.this.checkCombatIntput(CombatScreen.this.centerLeftParry, "parry", "left");
                    }
                } else if (x >= CombatScreen.this.centerRightAttack.getX() - CombatScreen.this.centerRightAttack.getWidth() && x <= CombatScreen.this.centerRightAttack.getX() + CombatScreen.this.centerRightAttack.getWidth() * 2.0f && y >= CombatScreen.this.centerRightAttack.getY() - CombatScreen.this.centerRightAttack.getHeight() && y <= CombatScreen.this.centerRightAttack.getY() + CombatScreen.this.centerRightAttack.getHeight() * 2.0f) {
                    if (CombatScreen.this.centerRightAttack.isVisible()) {
                        CombatScreen.this.checkCombatIntput(CombatScreen.this.centerRightAttack, "attack", "right");
                    } else if (CombatScreen.this.centerRightParry.isVisible()) {
                        CombatScreen.this.checkCombatIntput(CombatScreen.this.centerRightParry, "parry", "right");
                    }
                } else if (x >= CombatScreen.this.downLeft.getX() - CombatScreen.this.downLeft.getWidth() && x <= CombatScreen.this.downLeft.getX() + CombatScreen.this.downLeft.getWidth() * 2.0f && y >= CombatScreen.this.downLeft.getY() - CombatScreen.this.downLeft.getHeight() && y <= CombatScreen.this.downLeft.getY() + CombatScreen.this.downLeft.getHeight() * 2.0f) {
                    if (CombatScreen.this.downLeft.isVisible()) {
                        CombatScreen.this.checkCombatIntput(CombatScreen.this.downLeft, "dodge", "left");
                    }
                } else if (x >= CombatScreen.this.downRight.getX() - CombatScreen.this.downRight.getWidth() && x <= CombatScreen.this.downRight.getX() + CombatScreen.this.downRight.getWidth() * 2.0f && y >= CombatScreen.this.downRight.getY() - CombatScreen.this.downRight.getHeight() && y <= CombatScreen.this.downRight.getY() + CombatScreen.this.downRight.getHeight() * 2.0f && CombatScreen.this.downRight.isVisible()) {
                    CombatScreen.this.checkCombatIntput(CombatScreen.this.downRight, "dodge", "right");
                }
                return true;
            }
        });
        this.stage.addActor(touchScreen);
        this.surge = new BaseActor();
        this.surge.setTexture(combatButtonsAtlas.findRegion("buttonsurge"), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.surge.setX(UIHelpers.calcWidthProportion(this.game, 1.0f, 1.0f).floatValue());
        this.surge.setY(UIHelpers.calcHeightProportion(this.game, 29.0f, 29.0f).floatValue());
        this.surge.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent ev, float x, float y, int pointer, int button) {
                CombatScreen.this.checkCombatIntput(CombatScreen.this.surge, "surge", "right");
                return true;
            }
        });
        this.surge.setVisible(false);
        this.stage.addActor(this.surge);
        TextureAtlas servicesAtlas = this.game.manager.get(this.game.getOverridenAsset("data/equipment/services.atlas"), TextureAtlas.class);
        if (this.hostFighter.services.contains("shard") || this.hostFighter.services.contains("powder") || this.hostFighter.services.contains("net")) {
            this.useItem = new BaseActor();
            this.useItem.setTexture(servicesAtlas.findRegion("sershard"), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
            if (this.hostFighter.services.contains("powder")) {
                this.useItem.setTexture(servicesAtlas.findRegion("serpowder"), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
            } else if (this.hostFighter.services.contains("net")) {
                this.useItem.setTexture(servicesAtlas.findRegion("sernet"), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
            }
            this.useItem.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.useItem.getWidth() / 2.0f);
            this.useItem.setY(UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() - this.useItem.getHeight() / 2.0f);
            this.useItem.addCaptureListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent ev, float x, float y, int pointer, int button) {
                    CombatScreen.this.checkCombatIntput(CombatScreen.this.useItem, "useItem", "right");
                    return true;
                }
            });
            this.useItem.setVisible(false);
            this.stage.addActor(this.useItem);
        }
        this.endSplash = new BaseActor();
        this.endSplash.setTexture(uiAtlas.findRegion("splash"), UIHelpers.calcHeightProportion(this.game, 53.0f, 53.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 32.0f, 32.0f).floatValue());
        this.endSplash.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.endSplash.getWidth() / 2.0f);
        this.endSplash.setY(UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue() - this.endSplash.getHeight() / 2.0f);
        this.endSplash.setVisible(false);
        this.stage.addActor(this.endSplash);
        this.endLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.victory") + "!", this.game.uiSkin, "combat");
        this.endLabel.setAlignment(1);
        this.endLabel.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 2.0f));
        this.endLabel.setColor(new Color(0.9f, 0.9f, 0.0f, 1.0f));
        this.endLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 65.0f, 75.0f).floatValue());
        this.endLabel.setHeight(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.endLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.combatLabel.getWidth() / 2.0f);
        this.endLabel.setY(UIHelpers.calcHeightProportion(this.game, 48.75f, 48.75f).floatValue());
        this.endLabel.setVisible(false);
        this.stage.addActor(this.endLabel);
        this.replayButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.anotherround") + "?", this.game.uiSkin, "base");
        if (this.game.gameMode.equalsIgnoreCase("client")) {
            this.replayButton.setDisabled(true);
            this.replayButton.setVisible(false);
        } else {
            this.replayButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (CombatScreen.this.elapsedTime == 0L) {
                        CombatScreen.this.doFade("out", Float.valueOf(2.0f));
                        CombatScreen.this.elapsedTime = CombatScreen.this.combatTime + 2000L;
                    }
                }
            });
        }
        this.replayButton.setVisible(false);
        this.replayButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        this.replayButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        this.replayButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), this.replayButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        this.replayButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.replayButton.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.replayButton.getWidth() / 2.0f);
        this.replayButton.setY(UIHelpers.calcHeightProportion(this.game, 46.25f, 46.25f).floatValue() - this.replayButton.getHeight() / 2.0f);
        this.stage.addActor(this.replayButton);
        this.rewardBackground = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.rewardBackground.setVisible(false);
        this.rewardBackground.setWidth(UIHelpers.calcHeightProportion(this.game, 60.0f, 50.0f).floatValue());
        this.rewardBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 50.0f, 40.0f).floatValue());
        this.rewardBackground.setPosition(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.rewardBackground.getWidth() / 2.0f, UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue() - this.rewardBackground.getHeight() / 2.0f);
        this.stage.addActor(this.rewardBackground);
        this.rewardLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "common.reward") + ":\n\n", this.game.uiSkin, "default");
        this.rewardLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.rewardLabel.setWrap(true);
        this.rewardLabel.setAlignment(1);
        this.rewardLabel.setVisible(false);
        this.rewardLabel.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        this.rewardLabel.setWidth(this.rewardBackground.getWidth() * 80.0f / 100.0f);
        this.rewardLabel.layout();
        this.rewardLabel.setX(this.rewardBackground.getX() + this.rewardBackground.getWidth() / 2.0f - this.rewardLabel.getWidth() / 2.0f);
        this.rewardLabel.setY(this.rewardBackground.getY() + this.rewardBackground.getHeight() * 90.0f / 100.0f - this.rewardLabel.getHeight());
        this.stage.addActor(this.rewardLabel);
        this.rewardButton = new Button(this.game.uiSkin, "ok");
        this.rewardButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                CombatScreen.this.rewardBackground.setVisible(false);
                CombatScreen.this.rewardLabel.setVisible(false);
                CombatScreen.this.rewardButton.setVisible(false);
            }
        });
        this.rewardButton.setVisible(false);
        this.rewardButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.rewardButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.rewardButton.setX(this.rewardBackground.getX() + this.rewardBackground.getWidth() / 2.0f - this.rewardButton.getWidth() / 2.0f);
        this.rewardButton.setY(this.rewardBackground.getY() + this.rewardBackground.getHeight() * 4.0f / 100.0f);
        this.stage.addActor(this.rewardButton);
        this.greyscaleShader = new ShaderProgram(Gdx.files.internal(this.game.getOverridenAsset("data/shaders/v_greyscale.glsl")), Gdx.files.internal(this.game.getOverridenAsset("data/shaders/f_greyscale.glsl")));
        this.borderShader = new ShaderProgram(Gdx.files.internal(this.game.getOverridenAsset("data/shaders/v_border.glsl")), Gdx.files.internal(this.game.getOverridenAsset("data/shaders/f_border.glsl")));
        this.addFadeOverlay(Float.valueOf(0.0f));
        this.doFade("in", Float.valueOf(0.1f));
        if (!CombatEngine.selectedInput.equalsIgnoreCase("keyboard")) {
            Button menuButton = new Button(this.game.uiSkin, "menu");
            menuButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            menuButton.setHeight(menuButton.getWidth());
            menuButton.setX(10.0f);
            menuButton.setY(this.game.viewHeight.floatValue() - menuButton.getWidth() - 10.0f);
            menuButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (!CombatScreen.this.game.isMultiplayerGame()) {
                        CombatScreen.this.paused = true;
                        CombatScreen.this.game.manager.get(CombatScreen.this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)CombatScreen.this.game.stats.get("phases").get("arenas")).get(CombatScreen.this.arena)).getString("crowd") + ".ogg"), Sound.class).stop();
                        CombatScreen.this.game.gameMenuScreen = new GameMenuScreen(CombatScreen.this.game, CombatScreen.this.game.combatScreen);
                        CombatScreen.this.game.setScreen(CombatScreen.this.game.gameMenuScreen);
                    } else {
                        CombatScreen.this.game.networkPort.sendData("0_d_h");
                        if (CombatScreen.this.game.networkPort != null) {
                            CombatScreen.this.game.networkPort.terminate();
                            CombatScreen.this.game.networkPort = null;
                        }
                        CombatScreen.this.game.manager.get(CombatScreen.this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)CombatScreen.this.game.stats.get("phases").get("arenas")).get(CombatScreen.this.arena)).getString("crowd") + ".ogg"), Sound.class).stop();
                        CombatScreen.this.game.mainMenuScreen = new MainMenuScreen(CombatScreen.this.game);
                        CombatScreen.this.game.setScreen(CombatScreen.this.game.mainMenuScreen);
                        CombatScreen.this.dispose();
                    }
                }
            });
            menuButton.setVisible(true);
            this.stage.addActor(menuButton);
        }
        this.fpsCounter = new Label("", this.game.uiSkin, "default");
        this.fpsCounter.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.fpsCounter.setPosition(UIHelpers.calcWidthProportion(this.game, 0.5f, 0.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 99.0f, 99.0f).floatValue());
        this.stage.addActor(this.fpsCounter);
        this.fpsCounter.setText("[#BFBFBF]FPS: " + Gdx.graphics.getFramesPerSecond());
        if (!CombatEngine.selectedInput.equalsIgnoreCase("keyboard")) {
            this.fpsCounter.setX(10.0f + UIHelpers.calcHeightProportion(this.game, 8.5f, 8.5f).floatValue());
            this.fpsCounter.setY(this.game.viewHeight.floatValue() - this.game.viewWidth.floatValue() / 40.0f - 10.0f - this.fpsCounter.getHeight() / 2.0f);
        }
        if (!Logger.debugLevel) {
            this.fpsCounter.setVisible(false);
        }
        this.tutorialPause = false;
        if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.contains("tutorial")) {
            this.initTutorial();
        } else {
            this.overlayTutorial = new BaseActor();
            this.overlayTutorial.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/overlay.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
            this.overlayTutorial.setColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.overlayTutorial.setPosition(0.0f, 0.0f);
            this.overlayTutorial.setVisible(false);
            this.stage.addActor(this.overlayTutorial);
            this.tutorialElapsedTime = 0L;
        }
        this.talkTime = -1000L;
        this.labelTime = 0L;
        this.combatTime = 0L;
        this.lastStatusTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(float delta) {
        int i;
        int i2;
        int i3;
        if (this.receivedDisconnect != null) {
            if (this.game.networkPort != null) {
                this.game.networkPort.terminate();
                this.game.networkPort = null;
            }
            this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).stop();
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
        }
        if (this.receivedReplay != null) {
            this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).stop();
            this.game.duelSetupScreen = new DuelSetupScreen(this.game, this.reputation, this.difficulty, Fighter.clone(this.hostFighter, false), Fighter.clone(this.clientFighter, false));
            this.game.setScreen(this.game.duelSetupScreen);
            this.dispose();
        }
        if (this.paused.booleanValue()) {
            return;
        }
        this.fpsCounter.setText("[#BFBFBF]FPS: " + Gdx.graphics.getFramesPerSecond());
        UIHelpers.elapseHighlights(this.highlights, delta);
        if (this.game.gameMode.equalsIgnoreCase("server")) {
            CombatServer.sendUpdates(delta);
        }
        if (!this.messagesToExecute.isEmpty()) {
            LinkedList<StringBuilder> linkedList;
            if (this.game.gameMode.equalsIgnoreCase("client")) {
                linkedList = this.messagesToExecute;
                synchronized (linkedList) {
                    while (!this.messagesToExecute.isEmpty()) {
                        this.executeMessage(this.messagesToExecute.pop());
                    }
                }
            }
            linkedList = this.messagesToExecute;
            synchronized (linkedList) {
                while (!this.messagesToExecute.isEmpty()) {
                    StringBuilder nextEvent = this.messagesToExecute.pop();
                    String type = StringList.get(nextEvent, 1, "_");
                    String direction = StringList.get(nextEvent, 2, "_");
                    int deviation = Integer.parseInt(StringList.get(nextEvent, 3, "_"));
                    Fighter actingFighter = StringList.get(nextEvent, 4, "_").equalsIgnoreCase("c") ? this.clientFighter : this.hostFighter;
                    this.generateEvent(type, direction, deviation, actingFighter);
                }
            }
        }
        if (this.combatTime == 0L) {
            this.combatTime = 1L;
        } else {
            this.combatTime += Float.valueOf(delta * 1000.0f).longValue();
            if (this.timeLimitTime > 0L) {
                if (!this.replayButton.isVisible()) {
                    int favourableAssault = CombatEngine.combatState.getAssaultFighter() == this.hostFighter ? CombatEngine.combatState.assaultPressure + 1 : 1;
                    this.timeLimitTime -= Float.valueOf(delta * 1000.0f).longValue() / (long)favourableAssault;
                    this.timeLimitLabel.setText("" + (this.timeLimitTime > 1000L ? Long.valueOf(this.timeLimitTime / 1000L) : ""));
                    this.timeLimitIndex.setVisible(favourableAssault > 1);
                }
            } else {
                this.timeLimitLabel.setVisible(false);
            }
        }
        if (this.combatTime >= this.labelTime + this.lastStatusTime) {
            if (this.combatTime < INIT_TIME) {
                this.combatLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.start") + "\n" + (INIT_TIME + 999L - this.combatTime) / 1000L);
                if (this.timeLimitTime > 0L) {
                    this.timeLimitTime += Float.valueOf(delta * 1000.0f).longValue();
                }
            } else {
                this.combatLabel.setVisible(false);
            }
        }
        CombatEngine.removeEffectsByTime(this.hostFighter, this.combatTime);
        CombatEngine.removeEffectsByTime(this.clientFighter, this.combatTime);
        if (!this.game.gameMode.equalsIgnoreCase("client")) {
            CombatEngine.checkFightersRecover(this.hostFighter, this.clientFighter, delta);
        }
        float barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)Math.min(this.clientFighter.life, 10000) / 10000.0f;
        if (this.clientLifeBarShadow.getWidth() > barWidth) {
            float widthReduction = (this.clientLifeBarShadow.getWidth() - barWidth) / 100.0f;
            if (widthReduction < 1.0f) {
                widthReduction = 1.0f;
            }
            this.clientLifeBarShadow.setWidth(this.clientLifeBarShadow.getWidth() - widthReduction);
            widthReduction = this.clientLifeBarShadow.getWidth() / UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue();
            this.clientLifeBarShadow.regionWidth = Float.valueOf(200.0f * widthReduction / 1.0f).intValue();
        } else {
            this.clientLifeBarShadow.setWidth(barWidth);
            this.clientLifeBarShadow.regionWidth = Float.valueOf((float)(200 * Math.min(this.clientFighter.life, 10000)) / 10000.0f).intValue();
        }
        this.clientLifeBar.setWidth(barWidth);
        this.clientLifeBar.regionWidth = Float.valueOf((float)(200 * Math.min(this.clientFighter.life, 10000)) / 10000.0f).intValue();
        if (this.game.gameMode.equalsIgnoreCase("tournament") && this.clientFighter.name.equalsIgnoreCase("boss3")) {
            if (this.clientFighter.life > 11000) {
                this.bossActor3.setText("++");
            } else if (this.clientFighter.life > 10000) {
                this.bossActor3.setText("+");
            } else {
                this.bossActor3.setText("");
            }
        }
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.clientFighter.stamina / 10000.0f;
        if (this.clientStaminaBarShadow.getWidth() > barWidth) {
            float widthReduction = (this.clientStaminaBarShadow.getWidth() - barWidth) / 100.0f;
            if (widthReduction < 1.0f) {
                widthReduction = 1.0f;
            }
            this.clientStaminaBarShadow.setWidth(this.clientStaminaBarShadow.getWidth() - widthReduction);
            widthReduction = this.clientStaminaBarShadow.getWidth() / UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue();
            this.clientStaminaBarShadow.regionWidth = Float.valueOf(200.0f * widthReduction / 1.0f).intValue();
        } else {
            this.clientStaminaBarShadow.setWidth(barWidth);
            this.clientStaminaBarShadow.regionWidth = Float.valueOf((float)(200 * this.clientFighter.stamina) / 10000.0f).intValue();
        }
        this.clientStaminaBar.setWidth(Float.valueOf(UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.clientFighter.stamina / 10000.0f).intValue());
        this.clientStaminaBar.regionWidth = Float.valueOf((float)(200 * this.clientFighter.stamina) / 10000.0f).intValue();
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.clientFighter.balance / 10000.0f;
        if (this.clientBalanceBarShadow.getWidth() > barWidth) {
            float widthReduction = (this.clientBalanceBarShadow.getWidth() - barWidth) / 100.0f;
            if (widthReduction < 1.0f) {
                widthReduction = 1.0f;
            }
            this.clientBalanceBarShadow.setWidth(this.clientBalanceBarShadow.getWidth() - widthReduction);
            widthReduction = this.clientBalanceBarShadow.getWidth() / UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue();
            this.clientBalanceBarShadow.regionWidth = Float.valueOf(200.0f * widthReduction / 1.0f).intValue();
        } else {
            this.clientBalanceBarShadow.setWidth(barWidth);
            this.clientBalanceBarShadow.regionWidth = Float.valueOf((float)(200 * this.clientFighter.balance) / 10000.0f).intValue();
        }
        this.clientBalanceBar.setWidth(Float.valueOf(UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.clientFighter.balance / 10000.0f).intValue());
        this.clientBalanceBar.regionWidth = Float.valueOf((float)(200 * this.clientFighter.balance) / 10000.0f).intValue();
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.hostFighter.life / 10000.0f;
        if (this.hostLifeBarShadow.getWidth() > barWidth) {
            float widthReduction = (this.hostLifeBarShadow.getWidth() - barWidth) / 100.0f;
            if (widthReduction < 1.0f) {
                widthReduction = 1.0f;
            }
            this.hostLifeBarShadow.setWidth(this.hostLifeBarShadow.getWidth() - widthReduction);
            widthReduction = this.hostLifeBarShadow.getWidth() / UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue();
            this.hostLifeBarShadow.regionWidth = Float.valueOf(200.0f * widthReduction / 1.0f).intValue();
        } else {
            this.hostLifeBarShadow.setWidth(barWidth);
            this.hostLifeBarShadow.regionWidth = Float.valueOf((float)(200 * this.hostFighter.life) / 10000.0f).intValue();
        }
        this.hostLifeBar.setWidth(Float.valueOf(UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.hostFighter.life / 10000.0f).intValue());
        this.hostLifeBar.regionWidth = Float.valueOf((float)(200 * this.hostFighter.life) / 10000.0f).intValue();
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.hostFighter.stamina / 10000.0f;
        if (this.hostStaminaBarShadow.getWidth() > barWidth) {
            float widthReduction = (this.hostStaminaBarShadow.getWidth() - barWidth) / 100.0f;
            if (widthReduction < 1.0f) {
                widthReduction = 1.0f;
            }
            this.hostStaminaBarShadow.setWidth(this.hostStaminaBarShadow.getWidth() - widthReduction);
            widthReduction = this.hostStaminaBarShadow.getWidth() / UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue();
            this.hostStaminaBarShadow.regionWidth = Float.valueOf(200.0f * widthReduction / 1.0f).intValue();
        } else {
            this.hostStaminaBarShadow.setWidth(barWidth);
            this.hostStaminaBarShadow.regionWidth = Float.valueOf((float)(200 * this.hostFighter.stamina) / 10000.0f).intValue();
        }
        this.hostStaminaBar.setWidth(Float.valueOf(UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.hostFighter.stamina / 10000.0f).intValue());
        this.hostStaminaBar.regionWidth = Float.valueOf((float)(200 * this.hostFighter.stamina) / 10000.0f).intValue();
        barWidth = UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.hostFighter.balance / 10000.0f;
        if (this.hostBalanceBarShadow.getWidth() > barWidth) {
            float widthReduction = (this.hostBalanceBarShadow.getWidth() - barWidth) / 100.0f;
            if (widthReduction < 1.0f) {
                widthReduction = 1.0f;
            }
            this.hostBalanceBarShadow.setWidth(this.hostBalanceBarShadow.getWidth() - widthReduction);
            widthReduction = this.hostBalanceBarShadow.getWidth() / UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue();
            this.hostBalanceBarShadow.regionWidth = Float.valueOf(200.0f * widthReduction / 1.0f).intValue();
        } else {
            this.hostBalanceBarShadow.setWidth(barWidth);
            this.hostBalanceBarShadow.regionWidth = Float.valueOf((float)(200 * this.hostFighter.balance) / 10000.0f).intValue();
        }
        this.hostBalanceBar.setWidth(Float.valueOf(UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.hostFighter.balance / 10000.0f).intValue());
        this.hostBalanceBar.regionWidth = Float.valueOf((float)(200 * this.hostFighter.balance) / 10000.0f).intValue();
        this.surgeEventBar.setHeight(Float.valueOf(UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.hostFighter.surge / 10000.0f).intValue());
        this.surgeEventBar.regionHeight = Float.valueOf((float)(200 * this.hostFighter.surge) / 10000.0f).intValue();
        this.surgeEventBar.regionY = this.surgeRegionYinit + (200 - this.surgeEventBar.regionHeight);
        if (CombatEngine.combatState.clientFighter.surge == 0 || CombatEngine.combatState.clientSurgeType.equalsIgnoreCase("") || CombatEngine.combatState.clientSurgeType.equalsIgnoreCase("default")) {
            this.combatSurge.setVisible(false);
        }
        this.pressureBar.setColor(new Color(1.0f - CombatEngine.combatState.timePressure.floatValue() / 2.0f, 0.0f, 0.0f, 1.0f - CombatEngine.combatState.timePressure.floatValue() / 2.0f));
        this.pressureBar.setWidth(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue() * (2.0f - CombatEngine.combatState.timePressure.floatValue()));
        this.pressureBar.setHeight(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue() * (2.0f - CombatEngine.combatState.timePressure.floatValue()));
        this.pressureBar.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue() - UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue() * (2.0f - CombatEngine.combatState.timePressure.floatValue()));
        this.pressureBar.setY(this.game.viewHeight.floatValue() / 2.0f - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue() * (2.0f - CombatEngine.combatState.timePressure.floatValue()));
        for (i3 = 0; i3 < this.assaultClientBar.size(); ++i3) {
            if (CombatEngine.combatState.getAssaultFighter() == this.clientFighter) {
                if (i3 < CombatEngine.combatState.assaultPressure) {
                    this.assaultClientBar.get(i3).setVisible(true);
                    continue;
                }
                this.assaultClientBar.get(i3).setVisible(false);
                continue;
            }
            this.assaultClientBar.get(i3).setVisible(false);
        }
        for (i3 = 0; i3 < this.assaultHostBar.size(); ++i3) {
            if (CombatEngine.combatState.getAssaultFighter() == this.hostFighter) {
                if (i3 < CombatEngine.combatState.assaultPressure) {
                    this.assaultHostBar.get(i3).setVisible(true);
                    continue;
                }
                this.assaultHostBar.get(i3).setVisible(false);
                continue;
            }
            this.assaultHostBar.get(i3).setVisible(false);
        }
        TextureAtlas combatButtonsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), TextureAtlas.class);
        if (this.buffDebuffChange) {
            this.game.manager.get(this.game.getOverridenFilename("sound/endEffect.ogg"), Sound.class).play(this.game.soundVolume);
        }
        int numIcon = 0;
        for (BaseActor currIcon : this.clientIconBar) {
            currIcon.setVisible(false);
        }
        for (i2 = 0; i2 < StringList.size(this.clientFighter.buffs, ","); ++i2) {
            String currBuff = StringList.get(this.clientFighter.buffs, i2, ",");
            if (currBuff.equalsIgnoreCase("surge")) {
                currBuff = CombatEngine.combatState.clientSurgeType;
            }
            this.clientIconBar.get(numIcon).setTexture(combatButtonsAtlas.findRegion(currBuff), 50.0f, 50.0f);
            this.clientIconBar.get(numIcon).setColor(new Color(0.0f, 0.3f, 0.7f, 1.0f));
            this.clientIconBar.get(numIcon).setVisible(true);
            ++numIcon;
        }
        for (i2 = 0; i2 < StringList.size(this.clientFighter.debuffs, ","); ++i2) {
            String currDebuff = StringList.get(this.clientFighter.debuffs, i2, ",");
            this.clientIconBar.get(numIcon).setTexture(combatButtonsAtlas.findRegion(currDebuff), 50.0f, 50.0f);
            this.clientIconBar.get(numIcon).setColor(new Color(0.7f, 0.0f, 0.0f, 1.0f));
            this.clientIconBar.get(numIcon).setVisible(true);
            ++numIcon;
        }
        for (BaseActor currIcon : this.hostIconBar) {
            currIcon.setVisible(false);
        }
        numIcon = 0;
        for (i = 0; i < StringList.size(this.hostFighter.buffs, ","); ++i) {
            String currBuff = StringList.get(this.hostFighter.buffs, i, ",");
            if (currBuff.equalsIgnoreCase("surge")) {
                currBuff = CombatEngine.combatState.hostSurgeType;
            }
            this.hostIconBar.get(numIcon).setTexture(combatButtonsAtlas.findRegion(currBuff), 50.0f, 50.0f);
            this.hostIconBar.get(numIcon).setColor(new Color(0.0f, 0.3f, 0.7f, 1.0f));
            this.hostIconBar.get(numIcon).setVisible(true);
            ++numIcon;
        }
        this.stunScreen.setVisible(false);
        this.bleedScreen.setVisible(false);
        this.stage.getBatch().setShader(null);
        for (i = 0; i < StringList.size(this.hostFighter.debuffs, ","); ++i) {
            String currDebuff = StringList.get(this.hostFighter.debuffs, i, ",");
            this.hostIconBar.get(numIcon).setTexture(combatButtonsAtlas.findRegion(currDebuff), 50.0f, 50.0f);
            this.hostIconBar.get(numIcon).setColor(new Color(0.7f, 0.0f, 0.0f, 1.0f));
            this.hostIconBar.get(numIcon).setVisible(true);
            if (currDebuff.equalsIgnoreCase("stun")) {
                this.stunScreen.setVisible(true);
                this.shakeTime = this.combatTime + 100L;
            } else if (currDebuff.equalsIgnoreCase("bleed")) {
                this.bleedScreen.setVisible(true);
            } else if (currDebuff.equalsIgnoreCase("exhaus")) {
                this.stage.getBatch().setShader(this.greyscaleShader);
            } else if (currDebuff.equalsIgnoreCase("weaken")) {
                this.hostOffHand.setColor(0.0f, 0.0f, 0.0f, 1.0f);
                this.hostWeapon.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            }
            ++numIcon;
        }
        if (this.logTime < this.combatTime) {
            Object textFloat;
            if (StringList.size(CombatEngine.combatState.hostLog, "#") > 0) {
                String currLog = StringList.get(CombatEngine.combatState.hostLog, 0, "#");
                CombatEngine.combatState.hostLog = StringList.remove(CombatEngine.combatState.hostLog, 0, "#");
                Label logLabel = new Label(currLog.substring(2), this.game.uiSkin, "default");
                logLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                if (currLog.startsWith("r;")) {
                    logLabel.setColor(new Color(0.7f, 0.0f, 0.0f, 1.0f));
                } else if (currLog.startsWith("g;")) {
                    logLabel.setColor(new Color(0.0f, 0.7f, 0.0f, 1.0f));
                } else if (currLog.startsWith("b;")) {
                    logLabel.setColor(new Color(0.0f, 0.3f, 0.7f, 1.0f));
                } else if (currLog.startsWith("l;")) {
                    logLabel.setColor(new Color(0.78f, 0.87f, 0.88f, this.game.debugMode ? 1.0f : 0.0f));
                }
                logLabel.setAlignment(1);
                logLabel.setWidth(UIHelpers.calcHeightProportion(this.game, 35.0f, 35.0f).floatValue());
                logLabel.setX(UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
                logLabel.setY(UIHelpers.calcHeightProportion(this.game, 12.0f, 12.0f).floatValue());
                logLabel.setTouchable(Touchable.disabled);
                textFloat = Actions.sequence((Action)Actions.moveTo(UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 37.0f, 37.0f).floatValue() - logLabel.getHeight(), 5.0f), (Action)Actions.removeActor());
                logLabel.addAction((Action)textFloat);
                this.stage.addActor(logLabel);
                this.logTime = this.combatTime + 500L;
            }
            if (StringList.size(CombatEngine.combatState.clientLog, "#") > 0) {
                String currLog = StringList.get(CombatEngine.combatState.clientLog, 0, "#");
                CombatEngine.combatState.clientLog = StringList.remove(CombatEngine.combatState.clientLog, 0, "#");
                Label logLabel = new Label(currLog.substring(2), this.game.uiSkin, "default");
                logLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
                if (currLog.startsWith("r;")) {
                    logLabel.setColor(new Color(0.8f, 0.0f, 0.0f, 1.0f));
                } else if (currLog.startsWith("g;")) {
                    logLabel.setColor(new Color(0.0f, 0.8f, 0.0f, 1.0f));
                } else if (currLog.startsWith("b;")) {
                    logLabel.setColor(new Color(0.0f, 0.4f, 0.8f, 1.0f));
                } else if (currLog.startsWith("l;")) {
                    logLabel.setColor(new Color(0.78f, 0.87f, 0.88f, this.game.debugMode ? 1.0f : 0.0f));
                }
                logLabel.setAlignment(1);
                logLabel.setWidth(UIHelpers.calcHeightProportion(this.game, 35.0f, 35.0f).floatValue());
                logLabel.setX(UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
                logLabel.setY(this.game.viewHeight.floatValue() - UIHelpers.calcHeightProportion(this.game, 37.0f, 37.0f).floatValue());
                logLabel.setTouchable(Touchable.disabled);
                textFloat = Actions.sequence((Action)Actions.moveTo(UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 88.0f, 88.0f).floatValue() - logLabel.getHeight(), 5.0f), (Action)Actions.removeActor());
                logLabel.addAction((Action)textFloat);
                this.stage.addActor(logLabel);
                this.logTime = this.combatTime + 500L;
            }
        }
        if (!(StringList.size(CombatEngine.combatState.soundsToPlay, ",") <= 0 || this.clientFighter.life <= 0 && this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.equalsIgnoreCase("boss3"))) {
            for (int i4 = 0; i4 < StringList.size(CombatEngine.combatState.soundsToPlay, ","); ++i4) {
                String currSound = StringList.get(CombatEngine.combatState.soundsToPlay, i4, ",");
                this.game.manager.get(this.game.getOverridenFilename("sound/" + currSound + ".ogg"), Sound.class).play(this.game.soundVolume);
            }
            CombatEngine.combatState.soundsToPlay = new StringBuilder();
        }
        if (StringList.size(CombatEngine.combatState.effectsToPlay, ",") > 0) {
            for (int i5 = 0; i5 < StringList.size(CombatEngine.combatState.effectsToPlay, ","); ++i5) {
                SequenceAction buffEffect;
                String currEffect = StringList.get(CombatEngine.combatState.effectsToPlay, i5, ",");
                if (currEffect.split(":")[0].equalsIgnoreCase(this.game.gameMode.equalsIgnoreCase("client") ? "h" : "c")) {
                    Color colorOrig;
                    if (currEffect.split(":")[1].equalsIgnoreCase("bleed")) {
                        this.profits += 5;
                        for (Actor currActorPart : this.clientCharacter.getChildren()) {
                            colorOrig = currActorPart.getColor();
                            SequenceAction bleedEffect = Actions.sequence((Action)Actions.color(new Color(1.0f, 0.0f, 0.0f, 0.7f), 0.5f), (Action)Actions.color(colorOrig, 0.5f));
                            currActorPart.addAction(bleedEffect);
                        }
                        continue;
                    }
                    if (currEffect.split(":")[1].equalsIgnoreCase("stun")) {
                        this.profits += 5;
                        for (Actor currActorPart : this.clientCharacter.getChildren()) {
                            colorOrig = currActorPart.getColor();
                            SequenceAction stunEffect = Actions.sequence((Action)Actions.color(new Color(0.0f, 0.0f, 0.0f, 0.7f), 0.5f), (Action)Actions.color(colorOrig, 0.5f));
                            currActorPart.addAction(stunEffect);
                        }
                        continue;
                    }
                    if (currEffect.split(":")[1].equalsIgnoreCase("exhaus")) {
                        this.profits += 5;
                        for (Actor currActorPart : this.clientCharacter.getChildren()) {
                            colorOrig = currActorPart.getColor();
                            SequenceAction exhausEffect = Actions.sequence((Action)Actions.color(new Color(0.37f, 0.38f, 0.04f, 0.7f), 0.5f), (Action)Actions.color(colorOrig, 0.5f));
                            currActorPart.addAction(exhausEffect);
                        }
                        continue;
                    }
                    if (currEffect.split(":")[1].equalsIgnoreCase("weaken")) {
                        this.profits += 5;
                        for (Actor currActorPart : this.clientCharacter.getChildren()) {
                            if (currActorPart != this.clientWeapon && currActorPart != this.clientOffHand && currActorPart != this.clientArms) continue;
                            colorOrig = currActorPart.getColor();
                            SequenceAction weakenEffect = Actions.sequence((Action)Actions.color(new Color(0.0f, 0.0f, 0.0f, 1.0f), 0.5f), (Action)Actions.delay(1.0f), (Action)Actions.color(colorOrig, 0.5f));
                            currActorPart.addAction(weakenEffect);
                        }
                        continue;
                    }
                    if (currEffect.split(":")[1].equalsIgnoreCase("rage")) {
                        this.clientBodyBuff.clearActions();
                        buffEffect = Actions.sequence(Actions.show(), Actions.color(new Color(1.0f, 0.0f, 0.0f, 0.0f)), Actions.color(new Color(1.0f, 0.0f, 0.0f, 1.0f), 1.0f), Actions.color(new Color(1.0f, 0.0f, 0.0f, 0.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 1.0f, 0.0f)), Actions.hide());
                        this.clientBodyBuff.addAction(buffEffect);
                        continue;
                    }
                    if (currEffect.split(":")[1].equalsIgnoreCase("frenzy")) {
                        this.clientBodyBuff.clearActions();
                        buffEffect = Actions.sequence(Actions.show(), Actions.color(new Color(1.0f, 0.5f, 0.0f, 0.0f)), Actions.color(new Color(1.0f, 0.5f, 0.0f, 1.0f), 1.0f), Actions.color(new Color(1.0f, 0.5f, 0.0f, 0.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 1.0f, 0.0f)), Actions.hide());
                        this.clientBodyBuff.addAction(buffEffect);
                        continue;
                    }
                    if (currEffect.split(":")[1].equalsIgnoreCase("adrena")) {
                        this.clientBodyBuff.clearActions();
                        buffEffect = Actions.sequence(Actions.show(), Actions.color(new Color(1.0f, 1.0f, 0.0f, 0.0f)), Actions.color(new Color(1.0f, 1.0f, 0.0f, 1.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 0.0f, 0.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 1.0f, 0.0f)), Actions.hide());
                        this.clientBodyBuff.addAction(buffEffect);
                        continue;
                    }
                    if (currEffect.split(":")[1].equalsIgnoreCase("ready")) {
                        this.clientBodyBuff.clearActions();
                        buffEffect = Actions.sequence(Actions.show(), Actions.color(new Color(0.0f, 1.0f, 1.0f, 0.0f)), Actions.color(new Color(0.0f, 1.0f, 1.0f, 1.0f), 1.0f), Actions.color(new Color(0.0f, 1.0f, 1.0f, 0.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 1.0f, 0.0f)), Actions.hide());
                        this.clientBodyBuff.addAction(buffEffect);
                        continue;
                    }
                    if (currEffect.split(":")[1].equalsIgnoreCase("charge")) {
                        this.clientBodyBuff.clearActions();
                        buffEffect = Actions.sequence(Actions.show(), Actions.color(new Color(0.0f, 1.0f, 0.0f, 0.0f)), Actions.color(new Color(0.0f, 1.0f, 0.0f, 1.0f), 1.0f), Actions.color(new Color(0.0f, 1.0f, 0.0f, 0.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 1.0f, 0.0f)), Actions.hide());
                        this.clientBodyBuff.addAction(buffEffect);
                        continue;
                    }
                    if (!currEffect.split(":")[1].equalsIgnoreCase("scenario")) continue;
                    if (this.scenario.equalsIgnoreCase("barricades")) {
                        this.game.manager.get(this.game.getOverridenFilename("sound/woodbreak.ogg"), Sound.class).play(this.game.soundVolume);
                        this.scenarioBack.clearActions();
                        SequenceAction destroy1 = Actions.sequence((Action)Actions.color(Color.valueOf("000000FF"), 0.5f), (Action)Actions.delay(0.5f), (Action)Actions.color(Color.valueOf("00000000"), 0.5f), (Action)Actions.hide());
                        this.scenarioBack.addAction(destroy1);
                        this.scenarioFront.clearActions();
                        SequenceAction destroy2 = Actions.sequence((Action)Actions.color(Color.valueOf("000000FF"), 0.5f), (Action)Actions.delay(0.5f), (Action)Actions.color(Color.valueOf("00000000"), 0.5f), (Action)Actions.hide());
                        this.scenarioFront.addAction(destroy2);
                        continue;
                    }
                    if (!this.scenario.equalsIgnoreCase("coal")) continue;
                    this.game.manager.get(this.game.getOverridenFilename("sound/fire.ogg"), Sound.class).play(this.game.soundVolume);
                    this.fireScreen.clearActions();
                    SequenceAction appear = Actions.sequence((Action)Actions.show(), (Action)Actions.color(Color.valueOf("FFFFFFFF"), 0.5f), (Action)Actions.color(Color.valueOf("FFFFFF00"), 0.5f), (Action)Actions.hide());
                    this.fireScreen.addAction(appear);
                    continue;
                }
                if (currEffect.split(":")[1].equalsIgnoreCase("rage")) {
                    this.profits += 5;
                    this.hostBodyBuff.clearActions();
                    buffEffect = Actions.sequence(Actions.show(), Actions.color(new Color(1.0f, 0.0f, 0.0f, 0.0f)), Actions.color(new Color(1.0f, 0.0f, 0.0f, 1.0f), 1.0f), Actions.color(new Color(1.0f, 0.0f, 0.0f, 0.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 1.0f, 0.0f)), Actions.hide());
                    this.hostBodyBuff.addAction(buffEffect);
                    continue;
                }
                if (currEffect.split(":")[1].equalsIgnoreCase("frenzy")) {
                    this.profits += 5;
                    this.hostBodyBuff.clearActions();
                    buffEffect = Actions.sequence(Actions.show(), Actions.color(new Color(1.0f, 0.5f, 0.0f, 0.0f)), Actions.color(new Color(1.0f, 0.5f, 0.0f, 1.0f), 1.0f), Actions.color(new Color(1.0f, 0.5f, 0.0f, 0.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 1.0f, 0.0f)), Actions.hide());
                    this.hostBodyBuff.addAction(buffEffect);
                    continue;
                }
                if (currEffect.split(":")[1].equalsIgnoreCase("adrena")) {
                    this.profits += 5;
                    this.hostBodyBuff.clearActions();
                    buffEffect = Actions.sequence(Actions.show(), Actions.color(new Color(1.0f, 1.0f, 0.0f, 0.0f)), Actions.color(new Color(1.0f, 1.0f, 0.0f, 1.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 0.0f, 0.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 1.0f, 0.0f)), Actions.hide());
                    this.hostBodyBuff.addAction(buffEffect);
                    continue;
                }
                if (currEffect.split(":")[1].equalsIgnoreCase("ready")) {
                    this.profits += 5;
                    this.hostBodyBuff.clearActions();
                    buffEffect = Actions.sequence(Actions.show(), Actions.color(new Color(0.0f, 1.0f, 1.0f, 0.0f)), Actions.color(new Color(0.0f, 1.0f, 1.0f, 1.0f), 1.0f), Actions.color(new Color(0.0f, 1.0f, 1.0f, 0.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 1.0f, 0.0f)), Actions.hide());
                    this.hostBodyBuff.addAction(buffEffect);
                    continue;
                }
                if (!currEffect.split(":")[1].equalsIgnoreCase("charge")) continue;
                this.profits += 5;
                this.hostBodyBuff.clearActions();
                buffEffect = Actions.sequence(Actions.show(), Actions.color(new Color(0.0f, 1.0f, 0.0f, 0.0f)), Actions.color(new Color(0.0f, 1.0f, 0.0f, 1.0f), 1.0f), Actions.color(new Color(0.0f, 1.0f, 0.0f, 0.0f), 1.0f), Actions.color(new Color(1.0f, 1.0f, 1.0f, 0.0f)), Actions.hide());
                this.hostBodyBuff.addAction(buffEffect);
            }
            CombatEngine.combatState.effectsToPlay = new StringBuilder();
        }
        if (StringList.size(CombatEngine.combatState.highlights, ",") > 0) {
            for (int i6 = 0; i6 < StringList.size(CombatEngine.combatState.highlights, ","); ++i6) {
                String currHighlight = StringList.get(CombatEngine.combatState.highlights, i6, ",");
                String[] highlightInfo = currHighlight.split(":");
                if (highlightInfo[0].equalsIgnoreCase(this.game.gameMode.equalsIgnoreCase("client") ? "c" : "h")) {
                    if (highlightInfo[1].equalsIgnoreCase("life")) {
                        UIHelpers.hightlightUIElement(this.highlights, this.hostLifeBar, 0.5f, UIHelpers.hightlightColor(this.hostLifeBar, Integer.parseInt(highlightInfo[2])));
                        continue;
                    }
                    if (highlightInfo[1].equalsIgnoreCase("stamin")) {
                        UIHelpers.hightlightUIElement(this.highlights, this.hostStaminaBar, 0.5f, UIHelpers.hightlightColor(this.hostStaminaBar, Integer.parseInt(highlightInfo[2])));
                        continue;
                    }
                    if (highlightInfo[1].equalsIgnoreCase("balanc")) {
                        UIHelpers.hightlightUIElement(this.highlights, this.hostBalanceBar, 0.5f, UIHelpers.hightlightColor(this.hostBalanceBar, Integer.parseInt(highlightInfo[2])));
                        continue;
                    }
                    if (!highlightInfo[1].equalsIgnoreCase("surge")) continue;
                    UIHelpers.hightlightUIElement(this.highlights, this.surgeEventBar, 0.5f, UIHelpers.hightlightColor(this.surgeEventBar, Integer.parseInt(highlightInfo[2])));
                    continue;
                }
                if (highlightInfo[1].equalsIgnoreCase("life")) {
                    UIHelpers.hightlightUIElement(this.highlights, this.clientLifeBar, 0.5f, UIHelpers.hightlightColor(this.clientLifeBar, Integer.parseInt(highlightInfo[2])));
                    continue;
                }
                if (highlightInfo[1].equalsIgnoreCase("stamin")) {
                    UIHelpers.hightlightUIElement(this.highlights, this.clientStaminaBar, 0.5f, UIHelpers.hightlightColor(this.clientStaminaBar, Integer.parseInt(highlightInfo[2])));
                    continue;
                }
                if (!highlightInfo[1].equalsIgnoreCase("balanc")) continue;
                UIHelpers.hightlightUIElement(this.highlights, this.clientBalanceBar, 0.5f, UIHelpers.hightlightColor(this.clientBalanceBar, Integer.parseInt(highlightInfo[2])));
            }
            CombatEngine.combatState.highlights = new StringBuilder();
        }
        if (!this.end.booleanValue()) {
            if (this.clientFighter.life <= 0) {
                if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.equalsIgnoreCase("boss3")) {
                    this.end = true;
                    this.game.endScreen = new EndScreen(this.game, this.hostFighter.weapon.id);
                    this.game.setScreen(this.game.endScreen);
                    this.dispose();
                    return;
                }
                this.drawCombatStatus("victory");
                this.end = true;
                if (!this.game.gameMode.equalsIgnoreCase("client")) {
                    this.checkEnding();
                }
            } else if (this.hostFighter.life <= 0) {
                this.drawCombatStatus("defeat");
                this.end = true;
                if (!this.game.gameMode.equalsIgnoreCase("client")) {
                    this.checkEnding();
                }
            } else if (this.combatTime > INIT_TIME) {
                if (this.actionTime == 0L) {
                    if (this.tutorialPause.booleanValue()) {
                        if (!this.overlayTutorial.isVisible()) {
                            this.showTutorialInfo(1);
                        }
                    } else {
                        this.drawCombatStatus("");
                    }
                } else if (this.combatTime > this.actionTime + this.lastStatusTime) {
                    if (this.hostWait && !this.clientWait && !this.game.isMultiplayerGame()) {
                        if (this.tutorialPause.booleanValue()) {
                            if (!this.clientFighter.name.contains("tutorial")) {
                                if (this.tutorialElapsedTime > 0L && this.combatTime > this.tutorialElapsedTime) {
                                    this.tutorialElapsedTime = 0L;
                                    this.overlayTutorial.setVisible(false);
                                    this.overlay.setVisible(false);
                                    this.tutorialPause = false;
                                }
                            } else if (!this.overlayTutorial.isVisible()) {
                                this.showTutorialInfo(this.tutorialFail != false ? 2 : 0);
                            }
                        } else {
                            Logger.write(Logger.DEBUG, "CombatScreen.render sending CLIENT idle because of timeout actionTime");
                            this.sendMessage("idle_xxx_0_c", true);
                        }
                    } else if (!this.hostWait && this.clientWait) {
                        if (this.tutorialPause.booleanValue()) {
                            if (!this.clientFighter.name.contains("tutorial")) {
                                if (this.tutorialElapsedTime > 0L && this.combatTime > this.tutorialElapsedTime) {
                                    this.tutorialElapsedTime = 0L;
                                    this.overlayTutorial.setVisible(false);
                                    this.overlay.setVisible(false);
                                    this.tutorialPause = false;
                                }
                            } else if (!this.overlayTutorial.isVisible()) {
                                this.showTutorialInfo(this.tutorialFail != false ? 2 : 0);
                            }
                        } else {
                            Logger.write(Logger.DEBUG, "CombatScreen.render sending HOST idle because of timeout actionTime");
                            this.sendMessage("idle_xxx_0_h", true);
                        }
                    }
                } else if (this.tutorialPause.booleanValue() && this.clientFighter.name.equalsIgnoreCase("boss3") && this.game.gameMode.equalsIgnoreCase("story") && this.game.saveGame.get("rewards").contains("warbos") && this.tutorialElapsedTime > 0L && this.combatTime > this.tutorialElapsedTime - 3500L && !this.hostFighter.debuffs.toString().contains("laceration")) {
                    CombatEngine.addDebuff(this.hostFighter, "laceration", "laceration1", 20000L, this.combatTime, CombatEngine.combatState.hostLog, false);
                }
            }
            if (!this.game.isMultiplayerGame() && this.clientAI.act(delta) && (this.hostWait && !this.clientWait || this.clientAI.action.equalsIgnoreCase("surge"))) {
                if (this.tutorialPause.booleanValue()) {
                    if (!this.clientFighter.name.contains("tutorial")) {
                        if (this.tutorialElapsedTime > 0L && this.combatTime > this.tutorialElapsedTime) {
                            this.tutorialElapsedTime = 0L;
                            this.overlayTutorial.setVisible(false);
                            this.overlay.setVisible(false);
                            this.tutorialPause = false;
                        }
                    } else if (!this.overlayTutorial.isVisible()) {
                        this.showTutorialInfo(this.tutorialFail != false ? 2 : 0);
                    }
                } else {
                    Logger.write(Logger.DEBUG, "CombatScreen.render sending CLIENT AI action");
                    CombatEngine.combatState.randomNumber = MathUtils.random(999);
                    this.sendMessage(this.clientAI.action + "_" + this.clientAI.option + "_" + (int)this.clientAI.deviation + "_c", !this.clientAI.action.equalsIgnoreCase("surge"));
                }
            }
            if (this.hostAI != null && this.hostAI.act(delta) && (!this.hostWait && this.clientWait || this.hostAI.action.equalsIgnoreCase("surge"))) {
                Logger.write(Logger.DEBUG, "CombatScreen.render sending HOST AI action");
                CombatEngine.combatState.randomNumber = MathUtils.random(999);
                this.sendMessage(this.hostAI.action + "_" + this.hostAI.option + "_" + (int)this.hostAI.deviation + "_h", !this.hostAI.action.equalsIgnoreCase("surge"));
            }
        } else if (this.elapsedTime > 0L) {
            if (this.combatTime > this.elapsedTime) {
                this.doEnding();
            } else {
                this.game.track.setVolume(this.game.musicVolume * ((float)(this.elapsedTime - this.combatTime) / 2000.0f));
            }
        }
        if (this.shakeTime != 0L) {
            OrthographicCamera camera = (OrthographicCamera)this.stage.getCamera();
            if (this.shakeTime > this.combatTime) {
                camera.translate(MathUtils.random(this.game.viewHeight.floatValue() / 100.0f) - this.game.viewHeight.floatValue() / 200.0f, MathUtils.random(this.game.viewHeight.floatValue() / 100.0f) - this.game.viewHeight.floatValue() / 200.0f);
            } else {
                this.shakeTime = 0L;
                camera.position.x = this.game.viewWidth.floatValue() / 2.0f;
                camera.position.y = this.game.viewHeight.floatValue() / 2.0f;
            }
            this.stage.getBatch().setProjectionMatrix(camera.combined);
            camera.update();
        }
        OrthographicCamera camera = (OrthographicCamera)this.stage.getCamera();
        if (this.clearCamera < 0L) {
            camera.zoom = 1.0f;
            camera.update();
            this.timeLimitLabel.setY(UIHelpers.calcHeightProportion(this.game, 92.0f, 87.0f).floatValue());
            this.timeLimitIndex.setY(this.timeLimitLabel.getY() + this.timeLimitLabel.getPrefHeight() / 2.0f - this.timeLimitIndex.getHeight() / 2.0f);
            this.combatLabel.setY(UIHelpers.calcHeightProportion(this.game, 80.0f, 75.0f).floatValue());
            this.surge.setX(UIHelpers.calcWidthProportion(this.game, 1.0f, 1.0f).floatValue());
            this.stage.getBatch().setProjectionMatrix(camera.combined);
            this.clearCamera = 0L;
        } else if (camera.zoom != 1.0f) {
            this.clearCamera -= Float.valueOf(delta * 1000.0f).longValue();
        }
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        if (this.stage.getBatch().getShader() != this.greyscaleShader) {
            if (this.bossActor1.isVisible() && this.bossActor1.params.get("type") != null && ((String)this.bossActor1.params.get("type")).contains("dog") && ((String)this.bossActor1.params.get("border")).equalsIgnoreCase("true")) {
                this.bossActor1.shader = this.borderShader;
                this.bossActor1.shaderName = "border";
            } else if (this.bossActor2.isVisible() && this.bossActor2.params.get("type") != null && ((String)this.bossActor2.params.get("type")).contains("dog") && ((String)this.bossActor2.params.get("border")).equalsIgnoreCase("true")) {
                this.bossActor2.shader = this.borderShader;
                this.bossActor2.shaderName = "border";
            }
        }
        this.stage.draw();
        this.bossActor1.shader = null;
        this.bossActor2.shader = null;
    }

    @Override
    public void dispose() {
        String scenarioFrontImage;
        String scenarioBackImage;
        this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).stop();
        UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset("data/backgrounds/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("background")));
        if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.equalsIgnoreCase("boss3")) {
            this.game.manager.unload(this.game.getOverridenAsset("data/backgrounds/backgroundsoldiers.png"));
        }
        if (!this.scenario.equalsIgnoreCase("") && !(scenarioBackImage = ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getString("back")).equalsIgnoreCase("")) {
            UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset("data/backgrounds/" + scenarioBackImage));
        }
        if (!this.scenario.equalsIgnoreCase("") && !(scenarioFrontImage = ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getString("front")).equalsIgnoreCase("")) {
            UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset("data/backgrounds/" + scenarioFrontImage));
        }
        Fighter.unloadFighterAssets(this.game, this.clientFighter, true, false);
        Fighter.unloadFighterAssets(this.game, this.hostFighter, false, false);
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4 || keycode == 82) {
            if (!this.game.isMultiplayerGame()) {
                this.paused = true;
                this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).stop();
                this.game.gameMenuScreen = new GameMenuScreen(this.game, this);
                this.game.setScreen(this.game.gameMenuScreen);
            } else {
                this.game.networkPort.sendData("0_d_h");
                if (this.game.networkPort != null) {
                    this.game.networkPort.terminate();
                    this.game.networkPort = null;
                }
                this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).stop();
                this.game.mainMenuScreen = new MainMenuScreen(this.game);
                this.game.setScreen(this.game.mainMenuScreen);
                this.dispose();
            }
            return true;
        }
        if (keycode == 250 && this.game.mail.equalsIgnoreCase("info@calimasaga.com")) {
            this.clientFighter.life = 0;
        } else if (keycode == 246 && this.game.mail.equalsIgnoreCase("info@calimasaga.com")) {
            this.slomo = !this.slomo;
        } else if (keycode == Input.Keys.valueOf(this.game.nextkey)) {
            if (this.nextButton != null && this.nextButton.isVisible()) {
                InputEvent event = new InputEvent();
                event.setType(InputEvent.Type.touchUp);
                this.nextButton.fire(event);
                return true;
            }
            if (this.rewardButton != null && this.rewardButton.isVisible()) {
                InputEvent event = new InputEvent();
                event.setType(InputEvent.Type.touchUp);
                this.rewardButton.fire(event);
                return true;
            }
            if (this.replayButton != null && this.replayButton.isVisible() && this.elapsedTime == 0L) {
                InputEvent event = new InputEvent();
                event.setType(InputEvent.Type.touchUp);
                this.replayButton.fire(event);
                return true;
            }
        }
        if (CombatEngine.selectedInput.equalsIgnoreCase("keyboard")) {
            if (keycode == Input.Keys.valueOf(this.game.upmiddlekey) && this.upMiddleAttack.isVisible()) {
                this.checkCombatIntput(this.upMiddleAttack, "attack", "middle");
                return true;
            }
            if (keycode == Input.Keys.valueOf(this.game.upmiddlekey) && this.upMiddleParry.isVisible()) {
                this.checkCombatIntput(this.upMiddleParry, "parry", "middle");
                return true;
            }
            if (keycode == Input.Keys.valueOf(this.game.upleftkey) && this.centerLeftAttack.isVisible()) {
                this.checkCombatIntput(this.centerLeftAttack, "attack", "left");
                return true;
            }
            if (keycode == Input.Keys.valueOf(this.game.upleftkey) && this.centerLeftParry.isVisible()) {
                this.checkCombatIntput(this.centerLeftParry, "parry", "left");
                return true;
            }
            if (keycode == Input.Keys.valueOf(this.game.uprightkey) && this.centerRightAttack.isVisible()) {
                this.checkCombatIntput(this.centerRightAttack, "attack", "right");
                return true;
            }
            if (keycode == Input.Keys.valueOf(this.game.uprightkey) && this.centerRightParry.isVisible()) {
                this.checkCombatIntput(this.centerRightParry, "parry", "right");
                return true;
            }
            if (keycode == Input.Keys.valueOf(this.game.leftkey) && this.downLeft.isVisible()) {
                this.checkCombatIntput(this.downLeft, "dodge", "left");
                return true;
            }
            if (keycode == Input.Keys.valueOf(this.game.rightkey) && this.downRight.isVisible()) {
                this.checkCombatIntput(this.downRight, "dodge", "right");
                return true;
            }
            if (keycode == Input.Keys.valueOf(this.game.usekey) && this.useItem != null && this.useItem.isVisible()) {
                this.checkCombatIntput(this.useItem, "useItem", "right");
                return true;
            }
            if (keycode == Input.Keys.valueOf(this.game.surgekey) && this.surge.isVisible()) {
                this.checkCombatIntput(this.surge, "surge", "right");
                return true;
            }
        }
        return false;
    }

    private void drawEnemyFighter(String status, String direction, float newX, float newY, boolean idleMotion) {
        block99: {
            block98: {
                BaseActor moreWeapon;
                String moreWeaponType;
                BaseActor moreOffHands;
                BaseActor moreArms;
                boolean stunned;
                int i;
                String suffix = status;
                String weaponType = this.game.stats.get("weapons").getJSONObject(this.clientFighter.weapon.id).getString("type");
                if (weaponType.equalsIgnoreCase("2h3")) {
                    weaponType = suffix.equalsIgnoreCase("middle") || suffix.startsWith("hit") ? "2h2" : "2h1";
                }
                this.clientSkin.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.clientFighter.skinType + this.clientFighter.bodySubType + "skin.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                this.clientSkin.setColor(Color.valueOf(this.clientFighter.skinColor));
                this.clientBody.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.clientFighter.bodyType + this.clientFighter.bodySubType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                this.clientBody.setColor(Color.valueOf(this.clientFighter.bodyColor));
                StringBuilder chosenAccessories = StringList.create(this.clientFighter.accessoryTypes, ":");
                for (i = 0; i < StringList.size(chosenAccessories, ":"); ++i) {
                    this.clientAccessories.get(i).setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/bodycomp" + this.clientFighter.bodyType + "" + this.clientFighter.bodySubType + StringList.get(chosenAccessories, i, ":") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    this.clientAccessories.get(i).setColor(Color.valueOf(this.clientFighter.accessoryColor));
                }
                if (this.clientFighter.head != null && !this.clientFighter.special.contains("nohel")) {
                    this.clientHead.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.clientFighter.headType + this.clientFighter.portrait + this.game.stats.get("tiers").getJSONObject(this.clientFighter.head.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                } else {
                    this.clientHead.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.clientFighter.headType + this.clientFighter.portrait + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                }
                if (!this.game.violenceFilter) {
                    for (i = 0; i < (11000 - this.clientFighter.life) / 3000; ++i) {
                        this.clientWounds.get(i).setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/wound" + (this.hostFighter.weapon.id.equalsIgnoreCase("mace") || this.hostFighter.weapon.id.equalsIgnoreCase("hammer") ? "b" : "c") + this.clientWounds.get((int)i).params.get("type") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                }
                if (CombatEngine.combatState.isUse.booleanValue() && CombatEngine.combatState.getAttacker() == this.clientFighter) {
                    this.clientArms.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/arms1h" + suffix + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    this.clientArms.setColor(Color.valueOf(this.clientFighter.skinColor));
                } else {
                    this.clientArms.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/arms" + weaponType + suffix + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    this.clientArms.setColor(Color.valueOf(this.clientFighter.skinColor));
                }
                if (this.clientFighter.body != null) {
                    if (!this.clientFighter.special.contains("nocut")) {
                        this.clientBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + this.clientFighter.bodyType + this.clientFighter.bodySubType + this.game.stats.get("tiers").getJSONObject(this.clientFighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    } else {
                        this.clientBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                    if (!this.clientFighter.special.contains("nocul")) {
                        this.clientBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyl" + this.clientFighter.bodyType + this.clientFighter.bodySubType + this.game.stats.get("tiers").getJSONObject(this.clientFighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    } else {
                        this.clientBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                } else {
                    this.clientBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    this.clientBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                }
                if (CombatEngine.combatState.isUse.booleanValue() && CombatEngine.combatState.getAttacker() == this.clientFighter) {
                    if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.clientFighter.bodyType).getString("skinExtra"), ":"), "body" + this.clientFighter.bodyType + this.clientFighter.bodySubType + "skin1h" + suffix, 0, ":") >= 0) {
                        this.clientSkinExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.clientFighter.bodyType + this.clientFighter.bodySubType + "skin1h" + suffix + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        this.clientSkinExtra.setColor(Color.valueOf(this.clientFighter.skinColor));
                    } else {
                        this.clientSkinExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                    if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.clientFighter.bodyType).getString("bodyExtra"), ":"), "body" + this.clientFighter.bodyType + "1h" + suffix, 0, ":") >= 0) {
                        this.clientBodyExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.clientFighter.bodyType + "1h" + suffix + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        this.clientBodyExtra.setColor(Color.valueOf(this.clientFighter.bodyColor));
                    } else {
                        this.clientBodyExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                } else {
                    if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.clientFighter.bodyType).getString("skinExtra"), ":"), "body" + this.clientFighter.bodyType + this.clientFighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                        this.clientSkinExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.clientFighter.bodyType + this.clientFighter.bodySubType + "skin" + weaponType + suffix + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        this.clientSkinExtra.setColor(Color.valueOf(this.clientFighter.skinColor));
                    } else {
                        this.clientSkinExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                    if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.clientFighter.bodyType).getString("bodyExtra"), ":"), "body" + this.clientFighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                        this.clientBodyExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.clientFighter.bodyType + weaponType + suffix + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        this.clientBodyExtra.setColor(Color.valueOf(this.clientFighter.bodyColor));
                    } else {
                        this.clientBodyExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                }
                if (this.clientFighter.arms != null && !this.clientFighter.special.contains("noarmsarmor")) {
                    if (!this.clientFighter.special.contains("noaasl")) {
                        this.clientArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmssl" + weaponType + suffix + this.clientFighter.armsType + this.game.stats.get("tiers").getJSONObject(this.clientFighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    } else {
                        this.clientArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                    if (!this.clientFighter.special.contains("noaabra") && !this.clientFighter.special.contains("noaabrl")) {
                        this.clientArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsbrl" + weaponType + suffix + this.clientFighter.armsType + this.game.stats.get("tiers").getJSONObject(this.clientFighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    } else {
                        this.clientArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                    if (!this.clientFighter.special.contains("noaabra") && !this.clientFighter.special.contains("noaabrr")) {
                        this.clientArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsbrr" + weaponType + suffix + this.clientFighter.armsType + this.game.stats.get("tiers").getJSONObject(this.clientFighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    } else {
                        this.clientArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                    if (!this.clientFighter.special.contains("noaaspa") && !this.clientFighter.special.contains("noaaspl")) {
                        this.clientArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsspl" + weaponType + suffix + this.clientFighter.armsType + this.game.stats.get("tiers").getJSONObject(this.clientFighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    } else {
                        this.clientArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                    if (!this.clientFighter.special.contains("noaaspa") && !this.clientFighter.special.contains("noaaspr")) {
                        this.clientArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsspr" + weaponType + suffix + this.clientFighter.armsType + this.game.stats.get("tiers").getJSONObject(this.clientFighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    } else {
                        this.clientArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                } else {
                    this.clientArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    this.clientArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    this.clientArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    this.clientArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    this.clientArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                }
                if (CombatEngine.combatState.isUse.booleanValue() && CombatEngine.combatState.getAttacker() == this.clientFighter) {
                    if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.clientFighter.bodyType).getString("bodyExtra"), ":"), "body" + this.clientFighter.bodyType + "1h" + suffix, 0, ":") >= 0) {
                        if (this.clientFighter.body != null && !this.clientFighter.special.contains("nocut")) {
                            this.clientBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + this.clientFighter.bodyType + weaponType + suffix + this.game.stats.get("tiers").getJSONObject(this.clientFighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        } else {
                            this.clientBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        }
                    } else {
                        this.clientBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                } else {
                    if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.clientFighter.bodyType).getString("skinExtra"), ":"), "body" + this.clientFighter.bodyType + this.clientFighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                        if (this.clientFighter.body != null && !this.clientFighter.special.contains("nocut")) {
                            this.clientBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + this.clientFighter.bodyType + weaponType + suffix + this.game.stats.get("tiers").getJSONObject(this.clientFighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        } else {
                            this.clientBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        }
                    } else {
                        this.clientBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                    if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.clientFighter.bodyType).getString("bodyExtra"), ":"), "body" + this.clientFighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                        if (this.clientFighter.body != null && !this.clientFighter.special.contains("nocut")) {
                            this.clientBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + this.clientFighter.bodyType + weaponType + suffix + this.game.stats.get("tiers").getJSONObject(this.clientFighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        } else {
                            this.clientBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        }
                    } else {
                        this.clientBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    }
                }
                if (this.clientFighter.offHand != null) {
                    this.clientOffHand.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.clientFighter.offHand.id + this.game.stats.get("tiers").getJSONObject(this.clientFighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                } else {
                    this.clientOffHand.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                }
                this.clientBody.flip = false;
                this.clientSkin.flip = false;
                this.clientHead.flip = false;
                this.clientSkinExtra.flip = false;
                this.clientBodyExtra.flip = false;
                this.clientBodyBuff.flip = false;
                this.clientBodyArmorT.flip = false;
                this.clientBodyArmorL.flip = false;
                this.clientBodyArmorTExtra.flip = false;
                for (i = 0; i < StringList.size(chosenAccessories, ":"); ++i) {
                    this.clientAccessories.get((int)i).flip = false;
                }
                if (!this.game.violenceFilter) {
                    for (i = 0; i < (11000 - this.clientFighter.life) / 3000; ++i) {
                        this.clientWounds.get((int)i).flip = false;
                    }
                }
                if (this.clientHasHit) {
                    if (newX != 0.0f) {
                        newX -= this.clientCharacter.getX() - this.clientXinit;
                    }
                    this.clientHasHit = false;
                }
                this.clientCharacter.setX(this.clientXinit);
                this.clientHasHit = false;
                if (suffix.equalsIgnoreCase("left")) {
                    this.clientBody.flip = true;
                    this.clientSkin.flip = true;
                    this.clientHead.flip = true;
                    this.clientSkinExtra.flip = true;
                    this.clientBodyExtra.flip = true;
                    this.clientBodyBuff.flip = true;
                    this.clientBodyArmorT.flip = true;
                    this.clientBodyArmorL.flip = true;
                    this.clientBodyArmorTExtra.flip = true;
                    for (i = 0; i < StringList.size(chosenAccessories, ":"); ++i) {
                        this.clientAccessories.get((int)i).flip = true;
                    }
                    if (!this.game.violenceFilter) {
                        for (i = 0; i < (11000 - this.clientFighter.life) / 3000; ++i) {
                            this.clientWounds.get((int)i).flip = true;
                        }
                    }
                } else if (suffix.startsWith("hit")) {
                    suffix = suffix + direction.substring(0, 1);
                    if (weaponType.equalsIgnoreCase("1h") || direction.substring(0, 1).equalsIgnoreCase("left") || CombatEngine.combatState.isUse.booleanValue() && CombatEngine.combatState.getAttacker() == this.clientFighter) {
                        this.clientBody.flip = true;
                        this.clientSkin.flip = true;
                        this.clientHead.flip = true;
                        this.clientSkinExtra.flip = true;
                        this.clientBodyExtra.flip = true;
                        this.clientBodyBuff.flip = true;
                        this.clientBodyArmorT.flip = true;
                        this.clientBodyArmorL.flip = true;
                        this.clientBodyArmorTExtra.flip = true;
                        for (i = 0; i < StringList.size(chosenAccessories, ":"); ++i) {
                            this.clientAccessories.get((int)i).flip = true;
                        }
                        if (!this.game.violenceFilter) {
                            for (i = 0; i < (11000 - this.clientFighter.life) / 3000; ++i) {
                                this.clientWounds.get((int)i).flip = true;
                            }
                        }
                        this.clientCharacter.setX(this.clientXinit + this.clientXinit / 4.0f);
                        newX += this.clientXinit / 4.0f;
                        this.clientHasHit = true;
                    }
                }
                this.clientWeapon.setVisible(true);
                if (CombatEngine.combatState.isUse.booleanValue() && CombatEngine.combatState.getAttacker() == this.clientFighter) {
                    if (CombatEngine.combatState.stage.equalsIgnoreCase("attack")) {
                        String item = "shard";
                        if (this.clientFighter.services.contains("powder")) {
                            item = "powder";
                        } else if (this.clientFighter.services.contains("net")) {
                            item = "net";
                        }
                        this.clientWeapon.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + item + "1hright" + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    } else {
                        this.clientWeapon.setVisible(false);
                    }
                } else {
                    this.clientWeapon.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.clientFighter.weapon.id + this.game.stats.get("tiers").getJSONObject(this.clientFighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                }
                if (newX != 0.0f || newY != 0.0f) {
                    this.clientCharacter.setX(newX);
                    this.clientCharacter.setY(newY);
                }
                if (!suffix.equalsIgnoreCase("left") && !suffix.equalsIgnoreCase("right") && !suffix.equalsIgnoreCase("middle")) break block98;
                boolean bl = stunned = StringList.getPosition(this.hostFighter.debuffs, "stun", ",") >= 0;
                if (!stunned) break block99;
                if (!suffix.equalsIgnoreCase("left")) {
                    moreArms = new BaseActor();
                    moreArms.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/arms" + weaponType + "left" + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    moreArms.setPosition(this.clientArms.getX(), this.clientArms.getY());
                    moreArms.getColor().a = 0.5f;
                    moreArms.setVisible(true);
                    this.stunParts.add(moreArms);
                    this.clientCharacter.add(moreArms);
                    if (this.clientFighter.offHand != null) {
                        moreOffHands = new BaseActor();
                        moreOffHands.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.clientFighter.offHand.id + this.game.stats.get("tiers").getJSONObject(this.clientFighter.offHand.tier).getString("imageSuffix") + "ohleft" + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        moreOffHands.setPosition(this.clientArms.getX(), this.clientArms.getY());
                        moreOffHands.getColor().a = 0.5f;
                        moreOffHands.setVisible(true);
                        this.stunParts.add(moreOffHands);
                        this.clientCharacter.add(moreOffHands);
                    }
                    if ((moreWeaponType = this.game.stats.get("weapons").getJSONObject(this.clientFighter.weapon.id).getString("type")).equalsIgnoreCase("2h3")) {
                        moreWeaponType = "2h1";
                    }
                    moreWeapon = new BaseActor();
                    moreWeapon.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.clientFighter.weapon.id + this.game.stats.get("tiers").getJSONObject(this.clientFighter.weapon.tier).getString("imageSuffix") + moreWeaponType + "left" + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    moreWeapon.setPosition(this.clientArms.getX(), this.clientArms.getY());
                    moreWeapon.getColor().a = 0.5f;
                    moreWeapon.setVisible(true);
                    this.stunParts.add(moreWeapon);
                    this.clientCharacter.add(moreWeapon);
                }
                if (!suffix.equalsIgnoreCase("right")) {
                    moreArms = new BaseActor();
                    moreArms.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/arms" + weaponType + "right" + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    moreArms.setPosition(this.clientArms.getX(), this.clientArms.getY());
                    moreArms.getColor().a = 0.5f;
                    moreArms.setVisible(true);
                    this.stunParts.add(moreArms);
                    this.clientCharacter.add(moreArms);
                    if (this.clientFighter.offHand != null) {
                        moreOffHands = new BaseActor();
                        moreOffHands.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.clientFighter.offHand.id + this.game.stats.get("tiers").getJSONObject(this.clientFighter.offHand.tier).getString("imageSuffix") + "ohright" + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                        moreOffHands.setPosition(this.clientArms.getX(), this.clientArms.getY());
                        moreOffHands.getColor().a = 0.5f;
                        moreOffHands.setVisible(true);
                        this.stunParts.add(moreOffHands);
                        this.clientCharacter.add(moreOffHands);
                    }
                    if ((moreWeaponType = this.game.stats.get("weapons").getJSONObject(this.clientFighter.weapon.id).getString("type")).equalsIgnoreCase("2h3")) {
                        moreWeaponType = "2h1";
                    }
                    moreWeapon = new BaseActor();
                    moreWeapon.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.clientFighter.weapon.id + this.game.stats.get("tiers").getJSONObject(this.clientFighter.weapon.tier).getString("imageSuffix") + moreWeaponType + "right" + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    moreWeapon.setPosition(this.clientArms.getX(), this.clientArms.getY());
                    moreWeapon.getColor().a = 0.5f;
                    moreWeapon.setVisible(true);
                    this.stunParts.add(moreWeapon);
                    this.clientCharacter.add(moreWeapon);
                }
                if (suffix.equalsIgnoreCase("middle")) break block99;
                String moreWeaponType2 = this.game.stats.get("weapons").getJSONObject(this.clientFighter.weapon.id).getString("type");
                if (moreWeaponType2.equalsIgnoreCase("2h3")) {
                    moreWeaponType2 = "2h2";
                }
                BaseActor moreArms2 = new BaseActor();
                moreArms2.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/arms" + moreWeaponType2 + "middle" + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                moreArms2.setPosition(this.clientArms.getX(), this.clientArms.getY());
                moreArms2.getColor().a = 0.5f;
                moreArms2.setVisible(true);
                this.stunParts.add(moreArms2);
                this.clientCharacter.add(moreArms2);
                if (this.clientFighter.offHand != null) {
                    BaseActor moreOffHands2 = new BaseActor();
                    moreOffHands2.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.clientFighter.offHand.id + this.game.stats.get("tiers").getJSONObject(this.clientFighter.offHand.tier).getString("imageSuffix") + "ohmiddle" + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                    moreOffHands2.setPosition(this.clientArms.getX(), this.clientArms.getY());
                    moreOffHands2.getColor().a = 0.5f;
                    moreOffHands2.setVisible(true);
                    this.stunParts.add(moreOffHands2);
                    this.clientCharacter.add(moreOffHands2);
                }
                moreWeapon = new BaseActor();
                moreWeapon.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.clientFighter.weapon.id + this.game.stats.get("tiers").getJSONObject(this.clientFighter.weapon.tier).getString("imageSuffix") + moreWeaponType2 + "middle" + this.clientFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.clientCharacter.getWidth()).intValue(), (float)Float.valueOf(this.clientCharacter.getHeight()).intValue());
                moreWeapon.setPosition(this.clientArms.getX(), this.clientArms.getY());
                moreWeapon.getColor().a = 0.5f;
                moreWeapon.setVisible(true);
                this.stunParts.add(moreWeapon);
                this.clientCharacter.add(moreWeapon);
                break block99;
            }
            for (BaseActor currStunPart : this.stunParts) {
                this.clientCharacter.removeActor(currStunPart);
                currStunPart.remove();
            }
        }
        if (idleMotion) {
            this.clientCharacter.clearActions();
            this.clientCharacter.setScale(Float.parseFloat(this.clientFighter.size), Float.parseFloat(this.clientFighter.size));
            RepeatAction idleMotionAction = new RepeatAction();
            idleMotionAction.setAction(Actions.sequence((Action)Actions.scaleTo(Float.parseFloat(this.clientFighter.size), Float.parseFloat(this.clientFighter.size) + 0.005f, 1.0f * (0.5f + CombatEngine.combatState.timePressure.floatValue() / 2.0f)), (Action)Actions.scaleTo(Float.parseFloat(this.clientFighter.size), Float.parseFloat(this.clientFighter.size), 1.0f * (0.5f + CombatEngine.combatState.timePressure.floatValue() / 2.0f))));
            idleMotionAction.setCount(-1);
            this.clientCharacter.addAction(idleMotionAction);
        }
        if (this.clientFighter.name.equalsIgnoreCase("boss1")) {
            if (this.bossActor1.isVisible() && this.tutorialElapsedTime == 0L) {
                this.bossActor1.clearActions();
                this.bossActor1.setScale(1.0f, 1.0f);
                if (status.equalsIgnoreCase("left") || CombatEngine.combatState.clientBossSpecial.equalsIgnoreCase("left")) {
                    this.bossActor1.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/espdogright.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
                    this.bossActor1.params.put("type", "dogright");
                    this.bossActor1.params.put("border", "true");
                } else if (status.equalsIgnoreCase("hit") && direction.equalsIgnoreCase("left")) {
                    this.bossActor1.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/espdoghit.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
                    this.bossActor1.params.put("type", "doghit");
                    this.bossActor1.params.put("border", "true");
                } else {
                    this.bossActor1.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/espdogidle.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
                    this.bossActor1.params.put("type", "dogidle");
                    this.bossActor1.params.put("border", "false");
                }
                if (idleMotion) {
                    RepeatAction idleMotionActionb1 = new RepeatAction();
                    idleMotionActionb1.setAction(Actions.sequence((Action)Actions.scaleTo(1.0f, 1.005f, 1.0f * (0.5f + CombatEngine.combatState.timePressure.floatValue() / 2.0f)), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f * (0.5f + CombatEngine.combatState.timePressure.floatValue() / 2.0f))));
                    idleMotionActionb1.setCount(-1);
                    this.bossActor1.addAction(idleMotionActionb1);
                }
            }
            if (this.bossActor2.isVisible() && this.tutorialElapsedTime == 0L) {
                this.bossActor2.clearActions();
                this.bossActor2.setScale(1.0f, 1.0f);
                if (status.equalsIgnoreCase("right") || CombatEngine.combatState.clientBossSpecial.equalsIgnoreCase("right")) {
                    this.bossActor2.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/espdogright.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
                    this.bossActor2.params.put("type", "dogright");
                    this.bossActor2.params.put("border", "true");
                } else if (status.equalsIgnoreCase("hit") && direction.equalsIgnoreCase("right")) {
                    this.bossActor2.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/espdoghit.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
                    this.bossActor2.params.put("type", "doghit");
                    this.bossActor2.params.put("border", "true");
                } else {
                    this.bossActor2.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/espdogidle.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
                    this.bossActor2.params.put("type", "dogidle");
                    this.bossActor2.params.put("border", "false");
                }
                if (idleMotion) {
                    RepeatAction idleMotionActionb2 = new RepeatAction();
                    idleMotionActionb2.setAction(Actions.sequence((Action)Actions.scaleTo(1.0f, 1.005f, 1.0f * (0.5f + CombatEngine.combatState.timePressure.floatValue() / 2.0f)), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f * (0.5f + CombatEngine.combatState.timePressure.floatValue() / 2.0f))));
                    idleMotionActionb2.setCount(-1);
                    this.bossActor2.addAction(idleMotionActionb2);
                }
            }
        }
    }

    private void drawPCFighter(String status, String direction, float newX, float newY, boolean idleMotion) {
        String suffix = status;
        String weaponType = this.game.stats.get("weapons").getJSONObject(this.hostFighter.weapon.id).getString("type");
        if (weaponType.equalsIgnoreCase("2h3")) {
            weaponType = suffix.equalsIgnoreCase("middle") || suffix.startsWith("hit") ? "2h2" : "2h1";
        }
        this.hostBodyBuff.flip = false;
        this.hostBodyArmor.flip = false;
        this.hostHeadArmor.flip = false;
        if (CombatEngine.combatState.isUse.booleanValue() && CombatEngine.combatState.getAttacker() == this.hostFighter) {
            this.hostBody.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/pcarms1h" + suffix + ".png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
            this.hostBodyBuff.flip = suffix.equalsIgnoreCase("hit");
            this.hostBodyArmor.flip = suffix.equalsIgnoreCase("hit");
            this.hostHeadArmor.flip = suffix.equalsIgnoreCase("hit");
        } else {
            this.hostBody.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/pcarms" + weaponType + suffix + ".png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
            if (suffix.equalsIgnoreCase("left") || suffix.equalsIgnoreCase("hit") && weaponType.equalsIgnoreCase("1h")) {
                this.hostBodyBuff.flip = true;
                this.hostBodyArmor.flip = true;
                this.hostHeadArmor.flip = true;
            }
        }
        this.hostBody.setColor(1.0f, 1.0f * ((float)this.hostFighter.life / (float)this.hostFighter.maxLife), 0.0f, 0.5f);
        if (this.hostFighter.arms != null) {
            if (CombatEngine.combatState.isUse.booleanValue() && CombatEngine.combatState.getAttacker() == this.hostFighter) {
                this.hostArmsArmorBR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/pcarmorarmsbr1h" + suffix + ".png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
            } else {
                this.hostArmsArmorBR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
            }
            this.hostArmsArmorBR.setColor(1.0f, 1.0f * ((float)this.hostFighter.life / (float)this.hostFighter.maxLife), 0.0f, 1.0f);
        } else {
            this.hostArmsArmorBR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
        }
        if (this.hostFighter.head != null) {
            this.hostHeadArmor.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/pcarmorhead" + this.game.stats.get("tiers").getJSONObject(this.hostFighter.head.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
            this.hostHeadArmor.setColor(1.0f, 1.0f * ((float)this.hostFighter.life / (float)this.hostFighter.maxLife), 0.0f, 1.0f);
        } else {
            this.hostHeadArmor.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
        }
        if (this.hostFighter.body != null) {
            this.hostBodyArmor.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/pcarmorbody" + this.game.stats.get("tiers").getJSONObject(this.hostFighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
            this.hostBodyArmor.setColor(1.0f, 1.0f * ((float)this.hostFighter.life / (float)this.hostFighter.maxLife), 0.0f, 1.0f);
        } else {
            this.hostBodyArmor.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
        }
        if (this.hostFighter.offHand != null) {
            this.hostOffHand.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.hostFighter.offHand.id + "pc" + this.game.stats.get("tiers").getJSONObject(this.hostFighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + this.hostFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
            this.hostOffHand.setColor(1.0f, 1.0f * ((float)this.hostFighter.life / (float)this.hostFighter.maxLife), 0.0f, 1.0f);
        } else {
            this.hostOffHand.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
        }
        if (suffix.equalsIgnoreCase("hit")) {
            suffix = suffix + direction.substring(0, 1);
        }
        this.hostWeapon.setVisible(true);
        if (CombatEngine.combatState.isUse.booleanValue() && CombatEngine.combatState.getAttacker() == this.hostFighter) {
            if (CombatEngine.combatState.stage.equalsIgnoreCase("attack")) {
                String item = "shard";
                if (this.hostFighter.services.contains("powder")) {
                    item = "powder";
                } else if (this.hostFighter.services.contains("net")) {
                    item = "net";
                }
                this.hostWeapon.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + item + "pc1hright" + this.hostFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
                this.useItem.setVisible(false);
            } else {
                this.hostWeapon.setVisible(false);
            }
        } else {
            this.hostWeapon.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.hostFighter.weapon.id + "pc" + this.game.stats.get("tiers").getJSONObject(this.hostFighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + this.hostFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.hostCharacter.getWidth()).intValue(), (float)Float.valueOf(this.hostCharacter.getHeight()).intValue());
        }
        this.hostWeapon.setColor(1.0f, 1.0f * ((float)this.hostFighter.life / (float)this.hostFighter.maxLife), 0.0f, 1.0f);
        if (newX != 0.0f || newY != 0.0f) {
            this.hostCharacter.setX(newX);
            this.hostCharacter.setY(newY);
        }
        if (idleMotion) {
            this.hostCharacter.clearActions();
            this.hostCharacter.setScale(1.0f, 1.0f);
            RepeatAction idleMotionAction = new RepeatAction();
            idleMotionAction.setAction(Actions.sequence((Action)Actions.scaleTo(1.0f, 1.005f, 1.0f * (0.5f + CombatEngine.combatState.timePressure.floatValue() / 2.0f)), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f * (0.5f + CombatEngine.combatState.timePressure.floatValue() / 2.0f))));
            idleMotionAction.setCount(-1);
            this.hostCharacter.addAction(idleMotionAction);
        }
    }

    private void drawCombatStatus(String status) {
        String currStep;
        Logger.write(Logger.DEBUG, "CombatScreen.drawCombatStatus status " + status + ", attacker " + CombatEngine.combatState.attacker);
        if (status.startsWith("surge")) {
            if (status.contains("attacker")) {
                this.renderSurge(CombatEngine.combatState.getAttacker());
            } else {
                this.renderSurge(CombatEngine.combatState.getDefender());
            }
            return;
        }
        this.upMiddleAttack.visibleTime = 0.0f;
        this.centerLeftAttack.visibleTime = 0.0f;
        this.centerRightAttack.visibleTime = 0.0f;
        this.upMiddleParry.visibleTime = 0.0f;
        this.centerLeftParry.visibleTime = 0.0f;
        this.centerRightParry.visibleTime = 0.0f;
        this.downLeft.visibleTime = 0.0f;
        this.downRight.visibleTime = 0.0f;
        this.downLeft.visibleTime = 0.0f;
        this.downRight.visibleTime = 0.0f;
        this.upMiddleAttackb.clearActions();
        this.upMiddleAttackb.setVisible(false);
        this.centerLeftAttackb.clearActions();
        this.centerLeftAttackb.setVisible(false);
        this.centerRightAttackb.clearActions();
        this.centerRightAttackb.setVisible(false);
        this.upMiddleParryb.clearActions();
        this.upMiddleParryb.setVisible(false);
        this.centerLeftParryb.clearActions();
        this.centerLeftParryb.setVisible(false);
        this.centerRightParryb.clearActions();
        this.centerRightParryb.setVisible(false);
        this.downLeftb.clearActions();
        this.downLeftb.setVisible(false);
        this.downRightb.clearActions();
        this.downRightb.setVisible(false);
        this.surge.setVisible(this.hostFighter.surge == 10000);
        if (this.useItem != null) {
            this.useItem.setVisible(false);
        }
        this.combatHitClient.setVisible(false);
        this.combatHitClient.setScale(1.0f);
        this.combatHitClient.setOrigin(12);
        this.combatHitClient.setRotation(-this.combatHitClient.getRotation());
        this.combatHitClient.setOrigin(this.combatHitClient.getWidth() / 2.0f, this.combatHitClient.getHeight() / 2.0f);
        this.combatHitClient.setOrigin(16);
        this.combatHitClient.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue());
        this.combatHitClient.setY(UIHelpers.calcHeightProportion(this.game, 50.0f, 60.0f).floatValue());
        this.combatHitHost.setVisible(false);
        this.combatHitHost.setScale(1.0f);
        this.combatHitHost.setOrigin(12);
        this.combatHitHost.setRotation(-this.combatHitHost.getRotation());
        this.combatHitHost.setOrigin(this.combatHitHost.getWidth() / 2.0f, this.combatHitClient.getHeight() / 2.0f);
        this.combatHitHost.setOrigin(16);
        this.combatHitHost.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue());
        this.combatHitHost.setY(UIHelpers.calcHeightProportion(this.game, 40.0f, 50.0f).floatValue());
        this.combatParry.visibleTime = 0.0f;
        this.combatDodgeLeft.visibleTime = 0.0f;
        this.combatDodgeRight.visibleTime = 0.0f;
        this.comboHitParry.visibleTime = 0.0f;
        this.comboHitDodge.setVisible(false);
        this.timeLimitLabel.setY(UIHelpers.calcHeightProportion(this.game, 92.0f, 87.0f).floatValue());
        this.timeLimitIndex.setY(this.timeLimitLabel.getY() + this.timeLimitLabel.getPrefHeight() / 2.0f - this.timeLimitIndex.getHeight() / 2.0f);
        this.combatLabel.setColor(this.game.uiSkin.getColor("darkgrey"));
        this.combatLabel.setY(UIHelpers.calcHeightProportion(this.game, 80.0f, 75.0f).floatValue());
        this.clientCharacter.setScale(Float.parseFloat(this.clientFighter.size));
        this.hostCharacter.setScale(1.0f);
        this.pressureBar.setVisible(true);
        this.surgeEventBar.setVisible(true);
        this.baseEventBar.setVisible(true);
        if (this.scenarioFront != null) {
            this.scenarioFront.setVisible(true);
        }
        this.labelTime = 0L;
        if (this.talkTime < this.combatTime) {
            this.talkDirection.setVisible(false);
            this.talkBackground.setVisible(false);
            this.talkSentence.setVisible(false);
            this.claim1.clearActions();
            this.claim1.setVisible(false);
            this.claim1label.clearActions();
            this.claim1label.setVisible(false);
            this.claim2.clearActions();
            this.claim2.setVisible(false);
            this.claim2label.clearActions();
            this.claim2label.setVisible(false);
            this.claim3.clearActions();
            this.claim3.setVisible(false);
            this.claim3label.clearActions();
            this.claim3label.setVisible(false);
            this.claim4.clearActions();
            this.claim4.setVisible(false);
            this.claim4label.clearActions();
            this.claim4label.setVisible(false);
        }
        this.checkSentence(status);
        ArrayList<Long> availableTimes = new ArrayList<Long>();
        if (status.equalsIgnoreCase("") || status.startsWith("start")) {
            float currentAttackTime = (!this.game.isMultiplayerGame() && CombatEngine.combatState.getAttacker() == this.hostFighter ? this.ATTACK_TIME * CombatEngine.playerTimeMultiplier : this.ATTACK_TIME) * (float)(this.slomo && this.hostFighter == CombatEngine.combatState.getAttacker() ? 5 : 1);
            this.actionTime = Float.valueOf(currentAttackTime * MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * 2.0f, 0.5f, 1.0f)).longValue() + (long)PHASE_TIME;
            availableTimes.add(this.actionTime);
            if (!this.game.isMultiplayerGame() && this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.startsWith("boss3") && this.checkBossStep()) {
                this.hostWait = true;
                this.clientWait = false;
                this.clientAI.takeDecision(availableTimes);
                this.clientAI.actionTime += 2000L;
                this.actionTime += 2000L;
                this.lastStatusTime = this.combatTime;
                return;
            }
            if (!this.game.isMultiplayerGame()) {
                this.checkExceptionalEvent();
            }
            if (CombatEngine.combatState.getAttacker() == this.hostFighter) {
                TextureAtlas combatButtonsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), TextureAtlas.class);
                this.upMiddleAttack.playAnimation(currentAttackTime / 1000.0f * MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * 2.0f, 0.5f, 1.0f), currentAttackTime / 20000.0f * MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * 2.0f, 0.5f, 1.0f), PHASE_TIME / 1000.0f);
                this.centerLeftAttack.playAnimation(currentAttackTime / 1000.0f * MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * 2.0f, 0.5f, 1.0f), currentAttackTime / 20000.0f * MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * 2.0f, 0.5f, 1.0f), PHASE_TIME / 1000.0f);
                this.centerRightAttack.playAnimation(currentAttackTime / 1000.0f * MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * 2.0f, 0.5f, 1.0f), currentAttackTime / 20000.0f * MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * 2.0f, 0.5f, 1.0f), PHASE_TIME / 1000.0f);
                this.upMiddleAttack.setX(this.upMiddleAttackb.getX() + 1.0f);
                this.upMiddleAttack.setY(this.upMiddleAttackb.getY() + 1.0f);
                this.centerLeftAttack.setX(this.centerLeftAttackb.getX() + 1.0f);
                this.centerLeftAttack.setY(this.centerLeftAttackb.getY() + 1.0f);
                this.centerRightAttack.setX(this.centerRightAttackb.getX() + 1.0f);
                this.centerRightAttack.setY(this.centerRightAttackb.getY() + 1.0f);
                SequenceAction showBorder = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(currentAttackTime / 1000.0f * MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * 2.0f, 0.5f, 1.0f)), (Action)Actions.hide());
                this.upMiddleAttackb.clearActions();
                if (CombatEngine.combatState.vulnerableDirection.equalsIgnoreCase("middle")) {
                    this.upMiddleAttackb.setTexture(combatButtonsAtlas.findRegion("buttonweakborder"), (float)Float.valueOf(this.upMiddleAttackb.getWidth()).intValue(), (float)Float.valueOf(this.upMiddleAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.upMiddleAttackb.setColor(Color.valueOf("CC0000FF"));
                    } else {
                        this.upMiddleAttackb.setColor(Color.valueOf("D99BD7FF"));
                    }
                } else {
                    this.upMiddleAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)Float.valueOf(this.upMiddleAttackb.getWidth()).intValue(), (float)Float.valueOf(this.upMiddleAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.upMiddleAttackb.setColor(Color.valueOf("FF0000FF"));
                    } else {
                        this.upMiddleAttackb.setColor(Color.valueOf("C7DEE0FF"));
                    }
                }
                this.upMiddleAttackb.setVisible(true);
                this.upMiddleAttackb.addAction(showBorder);
                showBorder = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(currentAttackTime / 1000.0f * MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * 2.0f, 0.5f, 1.0f)), (Action)Actions.hide());
                this.centerLeftAttackb.clearActions();
                if (CombatEngine.combatState.vulnerableDirection.equalsIgnoreCase("left")) {
                    this.centerLeftAttackb.setTexture(combatButtonsAtlas.findRegion("buttonweakborder"), (float)Float.valueOf(this.centerLeftAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerLeftAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.centerLeftAttackb.setColor(Color.valueOf("CC0000FF"));
                    } else {
                        this.centerLeftAttackb.setColor(Color.valueOf("D99BD7FF"));
                    }
                } else {
                    this.centerLeftAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)Float.valueOf(this.centerLeftAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerLeftAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.centerLeftAttackb.setColor(Color.valueOf("FF0000FF"));
                    } else {
                        this.centerLeftAttackb.setColor(Color.valueOf("C7DEE0FF"));
                    }
                }
                this.centerLeftAttackb.setVisible(true);
                this.centerLeftAttackb.addAction(showBorder);
                showBorder = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(currentAttackTime / 1000.0f * MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * 2.0f, 0.5f, 1.0f)), (Action)Actions.hide());
                this.centerRightAttackb.clearActions();
                if (CombatEngine.combatState.vulnerableDirection.equalsIgnoreCase("right")) {
                    this.centerRightAttackb.setTexture(combatButtonsAtlas.findRegion("buttonweakborder"), (float)Float.valueOf(this.centerRightAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerRightAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.centerRightAttackb.setColor(Color.valueOf("CC0000FF"));
                    } else {
                        this.centerRightAttackb.setColor(Color.valueOf("D99BD7FF"));
                    }
                } else {
                    this.centerRightAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)Float.valueOf(this.centerRightAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerRightAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.centerRightAttackb.setColor(Color.valueOf("FF0000FF"));
                    } else {
                        this.centerRightAttackb.setColor(Color.valueOf("C7DEE0FF"));
                    }
                }
                this.centerRightAttackb.setVisible(true);
                this.centerRightAttackb.addAction(showBorder);
                if (this.useItem != null && this.hostFighter.itemUses > 0) {
                    this.useItem.clearActions();
                    SequenceAction showDelay = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show());
                    this.useItem.addAction(showDelay);
                }
                this.hostWait = false;
                this.clientWait = true;
                CombatEngine.addLogTrace(CombatEngine.combatState.hostLog, "l;Action time: " + availableTimes.get(0));
            } else {
                this.hostWait = true;
                this.clientWait = false;
                CombatEngine.addLogTrace(CombatEngine.combatState.clientLog, "l;Action time: " + availableTimes.get(0));
            }
            this.clientCharacter.clearActions();
            this.hostCharacter.clearActions();
            this.clientCharacter.addAction(Actions.moveTo(this.clientXinit, this.clientYinit, 0.1f));
            this.hostCharacter.addAction(Actions.moveTo(this.hostXinit, 0.0f, 0.1f));
            this.drawEnemyFighter("idle", "", this.clientXinit, this.clientYinit, true);
            this.drawPCFighter("idle", "", this.hostXinit, this.hostYinit, true);
            if (!this.game.isMultiplayerGame()) {
                this.clientAI.takeDecision(availableTimes);
            }
            if (this.hostAI != null) {
                this.hostAI.takeDecision(availableTimes);
            }
            Logger.write(Logger.DEBUG, "CombatScreen.drawCombatStatus actionTime " + this.actionTime + ", hostWait " + this.hostWait + ", clientWait " + this.clientWait);
        } else if (status.startsWith("parry") || status.startsWith("dodge")) {
            String[] statusPhases = status.split(";");
            this.actionTime = 0L;
            for (String currPhase : statusPhases) {
                float phaseTime;
                if (currPhase.equalsIgnoreCase("")) continue;
                String[] phaseElements = currPhase.split(":");
                if (phaseElements[0].equalsIgnoreCase("parry")) {
                    phaseTime = Float.parseFloat(phaseElements[1]) * (float)(this.slomo && this.hostFighter == CombatEngine.combatState.getDefender() ? 5 : 1);
                    availableTimes.add((long)phaseTime + (long)PHASE_TIME);
                    if (this.actionTime < (long)phaseTime + (long)PHASE_TIME) {
                        this.actionTime = (long)phaseTime + (long)PHASE_TIME;
                    }
                    if (this.hostFighter != CombatEngine.combatState.getDefender()) continue;
                    this.upMiddleParry.playAnimation(phaseTime / 1000.0f, phaseTime / 20000.0f, PHASE_TIME / 1000.0f);
                    this.centerLeftParry.playAnimation(phaseTime / 1000.0f, phaseTime / 20000.0f, PHASE_TIME / 1000.0f);
                    this.centerRightParry.playAnimation(phaseTime / 1000.0f, phaseTime / 20000.0f, PHASE_TIME / 1000.0f);
                    this.upMiddleParry.setX(this.upMiddleParryb.getX() + 1.0f);
                    this.upMiddleParry.setY(this.upMiddleParryb.getY() + 1.0f);
                    this.centerLeftParry.setX(this.centerLeftParryb.getX() + 1.0f);
                    this.centerLeftParry.setY(this.centerLeftParryb.getY() + 1.0f);
                    this.centerRightParry.setX(this.centerRightParryb.getX() + 1.0f);
                    this.centerRightParry.setY(this.centerRightParryb.getY() + 1.0f);
                    this.upMiddleParryb.clearActions();
                    this.upMiddleParryb.setVisible(true);
                    SequenceAction showParry = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(phaseTime / 1000.0f), (Action)Actions.hide());
                    this.upMiddleParryb.addAction(showParry);
                    this.centerLeftParryb.clearActions();
                    this.centerLeftParryb.setVisible(true);
                    showParry = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(phaseTime / 1000.0f), (Action)Actions.hide());
                    this.centerLeftParryb.addAction(showParry);
                    this.centerRightParryb.clearActions();
                    this.centerRightParryb.setVisible(true);
                    showParry = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(phaseTime / 1000.0f), (Action)Actions.hide());
                    this.centerRightParryb.addAction(showParry);
                    continue;
                }
                if (!phaseElements[0].equalsIgnoreCase("dodge")) continue;
                phaseTime = Float.parseFloat(phaseElements[1]) * (float)(this.slomo && this.hostFighter == CombatEngine.combatState.getDefender() ? 5 : 1);
                availableTimes.add((long)phaseTime + (long)PHASE_TIME);
                if (this.actionTime < (long)phaseTime) {
                    this.actionTime = (long)phaseTime;
                }
                if (this.hostFighter != CombatEngine.combatState.getDefender()) continue;
                this.downLeft.playAnimation(phaseTime / 1000.0f, phaseTime / 20000.0f, PHASE_TIME / 1000.0f);
                this.downRight.playAnimation(phaseTime / 1000.0f, phaseTime / 20000.0f, PHASE_TIME / 1000.0f);
                this.downLeft.setX(this.downLeftb.getX() + 1.0f);
                this.downLeft.setY(this.downLeftb.getY() + 1.0f);
                this.downRight.setX(this.downRightb.getX() + 1.0f);
                this.downRight.setY(this.downRightb.getY() + 1.0f);
                this.downLeftb.clearActions();
                this.downLeftb.setVisible(true);
                SequenceAction showDodge = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(phaseTime / 1000.0f), (Action)Actions.hide());
                this.downLeftb.addAction(showDodge);
                this.downRightb.clearActions();
                this.downRightb.setVisible(true);
                showDodge = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(phaseTime / 1000.0f), (Action)Actions.hide());
                this.downRightb.addAction(showDodge);
            }
            this.clientCharacter.clearActions();
            this.hostCharacter.clearActions();
            if (this.hostFighter == CombatEngine.combatState.getDefender()) {
                String currCombo;
                if (this.scenarioFront != null) {
                    this.scenarioFront.setVisible(false);
                }
                if (CombatEngine.combatState.clientBossSpecial.contains("lightattack")) {
                    this.bossActor1.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/esplightcloud.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
                    this.bossActor1.setX(0.0f);
                    this.bossActor1.setY(0.0f);
                    if (CombatEngine.combatState.clientBossSpecial.contains("left")) {
                        this.bossActor1.flip = true;
                        this.bossActor2.flip = true;
                    }
                    this.bossActor1.clearActions();
                    SequenceAction appear = Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.show(), (Action)Actions.alpha(1.0f, (float)this.actionTime / 1000.0f));
                    this.bossActor1.addAction(appear);
                }
                if ((currCombo = CombatEngine.combatState.clientComboHappenning).contains(":commi")) {
                    String missType = currCombo.substring(currCombo.indexOf(":commi") + 6, currCombo.indexOf(":commi") + 7);
                    if (missType.equalsIgnoreCase("d")) {
                        this.comboHitParry.setColor(new Color(0.0f, 1.0f, 1.0f, 0.15f));
                        this.comboHitParry.playAnimation((float)this.actionTime / 1000.0f, (float)this.actionTime / 40000.0f, PHASE_TIME / 1000.0f);
                        this.comboHitParry.clearActions();
                        this.comboHitParry.setVisible(true);
                        SequenceAction showComboHit = Actions.sequence((Action)Actions.delay((float)this.actionTime / 1000.0f + PHASE_TIME / 1000.0f), (Action)Actions.hide());
                        this.comboHitParry.addAction(showComboHit);
                    } else {
                        this.comboHitDodge.setColor(new Color(0.0f, 1.0f, 0.0f, 0.15f));
                        this.comboHitDodge.playAnimation((float)this.actionTime / 1000.0f, (float)this.actionTime / 40000.0f, PHASE_TIME / 1000.0f);
                        this.comboHitDodge.clearActions();
                        this.comboHitDodge.setVisible(true);
                        SequenceAction showComboHit = Actions.sequence((Action)Actions.delay((float)this.actionTime / 1000.0f + PHASE_TIME / 1000.0f), (Action)Actions.hide());
                        this.comboHitDodge.addAction(showComboHit);
                    }
                }
                SequenceAction prepare = null;
                prepare = CombatEngine.combatState.direction.equalsIgnoreCase("left") ? Actions.sequence((Action)Actions.parallel((Action)Actions.scaleTo(Float.parseFloat(this.clientFighter.size) + 0.05f, Float.parseFloat(this.clientFighter.size) + 0.05f, (float)this.actionTime / 1000.0f), (Action)Actions.moveTo(this.clientCharacter.getX() + this.clientMoveinit / 8.0f, this.clientCharacter.getY() - this.clientMoveinit / 4.0f, (float)this.actionTime / 1000.0f))) : (CombatEngine.combatState.direction.equalsIgnoreCase("right") ? Actions.sequence((Action)Actions.parallel((Action)Actions.scaleTo(Float.parseFloat(this.clientFighter.size) + 0.05f, Float.parseFloat(this.clientFighter.size) + 0.05f, (float)this.actionTime / 1000.0f), (Action)Actions.moveTo(this.clientCharacter.getX() - this.clientMoveinit / 2.0f, this.clientCharacter.getY() - this.clientMoveinit / 4.0f, (float)this.actionTime / 1000.0f))) : Actions.sequence((Action)Actions.parallel((Action)Actions.scaleTo(Float.parseFloat(this.clientFighter.size) + 0.05f, Float.parseFloat(this.clientFighter.size) + 0.05f, (float)this.actionTime / 1000.0f), (Action)Actions.moveTo(this.clientCharacter.getX() - this.clientMoveinit / 8.0f, this.clientCharacter.getY() - this.clientMoveinit / 4.0f, (float)this.actionTime / 1000.0f))));
                this.drawEnemyFighter(CombatEngine.combatState.direction, "", this.clientXinit, this.clientYinit, false);
                this.clientCharacter.addAction(prepare);
                this.hostWait = false;
                this.clientWait = true;
                CombatEngine.addLogTrace(CombatEngine.combatState.hostLog, "l;Parry time: " + availableTimes.get(0) + ", Dodge time " + availableTimes.get(1));
            } else {
                SequenceAction prepare = null;
                prepare = CombatEngine.combatState.direction.equalsIgnoreCase("left") ? Actions.sequence((Action)Actions.parallel((Action)Actions.scaleTo(1.0f, 1.0f, (float)this.actionTime / 1000.0f), (Action)Actions.moveTo(this.hostCharacter.getX() - this.hostMoveinit / 2.0f, this.hostCharacter.getY() + this.hostMoveinit / 4.0f, (float)this.actionTime / 1000.0f))) : (CombatEngine.combatState.direction.equalsIgnoreCase("right") ? Actions.sequence((Action)Actions.parallel((Action)Actions.scaleTo(1.0f, 1.0f, (float)this.actionTime / 1000.0f), (Action)Actions.moveTo(this.hostCharacter.getX() + this.hostMoveinit / 8.0f, this.hostCharacter.getY() + this.hostMoveinit / 4.0f, (float)this.actionTime / 1000.0f))) : Actions.sequence((Action)Actions.parallel((Action)Actions.scaleTo(1.0f, 1.0f, (float)this.actionTime / 1000.0f), (Action)Actions.moveTo(this.hostCharacter.getX() - this.hostMoveinit / 8.0f, this.hostCharacter.getY() + this.hostMoveinit / 4.0f, (float)this.actionTime / 1000.0f))));
                this.drawPCFighter(CombatEngine.combatState.direction, "", this.hostXinit, this.hostYinit, false);
                this.hostCharacter.addAction(prepare);
                this.hostWait = true;
                this.clientWait = false;
                CombatEngine.addLogTrace(CombatEngine.combatState.clientLog, "l;Parry time: " + availableTimes.get(0) + ", Dodge time " + availableTimes.get(1));
            }
            if (!this.game.isMultiplayerGame()) {
                this.clientAI.takeDecision(availableTimes);
            }
            if (this.hostAI != null) {
                this.hostAI.takeDecision(availableTimes);
            }
        } else if (status.startsWith("miss-parry")) {
            String[] statusPhases;
            this.labelTime = this.actionTime = RESOLUTION_TIME + (long)(CombatEngine.combatState.randomNumber / 2);
            for (String currPhase : statusPhases = status.split(";")) {
                if (!currPhase.startsWith("miss-parry")) continue;
                this.combatLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.parry") + "\n" + Integer.parseInt(currPhase.split(":")[1]) / 10);
                break;
            }
            this.combatLabel.setColor(new Color(0.4f, 0.84f, 0.85f, 1.0f));
            this.combatLabel.setVisible(true);
            this.combatParry.playAnimation(0.5f, 0.03846154f, 0.0f);
            UIHelpers.hightlightUIElement(this.highlights, this.pressureBar, 0.5f, UIHelpers.hightlightColor(this.pressureBar, 1));
            SequenceAction fadeInOverlay = Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.show(), (Action)Actions.color(new Color(0.0f, 0.0f, 0.0f, 0.6f), 0.3f), (Action)Actions.delay((float)this.actionTime / 1000.0f), (Action)Actions.alpha(0.0f));
            this.overlay.addAction(fadeInOverlay);
            this.clientCharacter.clearActions();
            this.hostCharacter.clearActions();
            if (this.hostFighter == CombatEngine.combatState.getDefender()) {
                if (this.scenarioFront != null) {
                    this.scenarioFront.setVisible(false);
                }
                if (CombatEngine.combatState.clientBossSpecial.contains("lightattack")) {
                    this.bossActor1.clearActions();
                    SequenceAction disappear = Actions.sequence((Action)Actions.alpha(1.0f), (Action)Actions.show(), (Action)Actions.delay(1.0f), (Action)Actions.alpha(0.0f), (Action)Actions.hide());
                    this.bossActor1.addAction(disappear);
                    this.bossActor2.clearActions();
                    this.bossActor2.setVisible(true);
                    SequenceAction appear = Actions.sequence((Action)Actions.alpha(1.0f), (Action)Actions.delay(1.0f), (Action)Actions.alpha(0.0f));
                    this.bossActor2.addAction(appear);
                    this.lightningScreen.clearActions();
                    SequenceAction hideDelay = Actions.sequence((Action)Actions.show(), (Action)Actions.delay(1.0f), (Action)Actions.hide());
                    this.lightningScreen.addAction(hideDelay);
                    this.shakeTime = this.combatTime + 500L;
                    CombatEngine.combatState.clientBossSpecial = "";
                    this.clientAI.itemInterval = 6;
                }
                float clientMoveX = 0.0f;
                float clientMoveY = 0.0f;
                float hostMoveX = 0.0f;
                float hostMoveY = 0.0f;
                if (CombatEngine.combatState.direction.equalsIgnoreCase("left")) {
                    clientMoveX = this.clientMoveinit / 8.0f;
                    clientMoveY = -this.clientMoveinit / 12.8f;
                    hostMoveX = this.hostMoveinit / 8.0f;
                    hostMoveY = 0.0f;
                } else if (CombatEngine.combatState.direction.equalsIgnoreCase("right")) {
                    clientMoveX = -this.clientMoveinit / 8.0f;
                    clientMoveY = -this.clientMoveinit / 12.8f;
                    hostMoveX = -this.hostMoveinit / 8.0f;
                    hostMoveY = 0.0f;
                } else {
                    clientMoveX = 0.0f;
                    clientMoveY = -this.clientMoveinit / 12.8f;
                    hostMoveX = 0.0f;
                    hostMoveY = 0.0f;
                }
                this.drawEnemyFighter("hit", CombatEngine.combatState.direction, this.clientCharacter.getX() + clientMoveX, this.clientCharacter.getY() + clientMoveY, false);
                this.clientCharacter.addAction(Actions.moveTo(this.clientCharacter.getX() + clientMoveX * 2.0f, this.clientCharacter.getY() + clientMoveY * 2.0f, (float)this.actionTime / 1000.0f));
                this.drawPCFighter("parry", CombatEngine.combatState.direction, this.hostCharacter.getX() + hostMoveX, this.hostCharacter.getY() + hostMoveY, false);
                this.hostCharacter.addAction(Actions.moveTo(this.hostCharacter.getX() + hostMoveX * 2.0f, this.hostCharacter.getY() + hostMoveY * 2.0f, (float)this.actionTime / 1000.0f));
            } else {
                float clientMoveX = 0.0f;
                float clientMoveY = 0.0f;
                float hostMoveX = 0.0f;
                float hostMoveY = 0.0f;
                if (CombatEngine.combatState.direction.equalsIgnoreCase("left")) {
                    clientMoveX = -this.clientMoveinit / 8.0f;
                    clientMoveY = 0.0f;
                    hostMoveX = -this.hostMoveinit / 8.0f;
                    hostMoveY = this.hostMoveinit / 12.8f;
                } else if (CombatEngine.combatState.direction.equalsIgnoreCase("right")) {
                    clientMoveX = this.clientMoveinit / 8.0f;
                    clientMoveY = 0.0f;
                    hostMoveX = this.hostMoveinit / 8.0f;
                    hostMoveY = this.hostMoveinit / 12.8f;
                } else {
                    clientMoveX = 0.0f;
                    clientMoveY = 0.0f;
                    hostMoveX = 0.0f;
                    hostMoveY = this.hostMoveinit / 12.8f;
                }
                this.drawEnemyFighter("parry", CombatEngine.combatState.direction, this.clientCharacter.getX() + clientMoveX, this.clientCharacter.getY() + clientMoveY, false);
                this.clientCharacter.addAction(Actions.moveTo(this.clientCharacter.getX() + clientMoveX * 2.0f, this.clientCharacter.getY() + clientMoveY * 2.0f, (float)this.actionTime / 1000.0f));
                this.drawPCFighter("hit", CombatEngine.combatState.direction, this.hostCharacter.getX() + hostMoveX, this.hostCharacter.getY() + hostMoveY, false);
                this.hostCharacter.addAction(Actions.moveTo(this.hostCharacter.getX() + hostMoveX * 2.0f, this.hostCharacter.getY() + hostMoveY * 2.0f, (float)this.actionTime / 1000.0f));
            }
            if (!this.game.isMultiplayerGame()) {
                this.clientAI.reset();
            }
            if (this.hostAI != null) {
                this.hostAI.reset();
            }
            this.hostWait = this.game.gameMode.equalsIgnoreCase("client");
            this.clientWait = true;
        } else if (status.startsWith("miss-dodge")) {
            this.labelTime = this.actionTime = RESOLUTION_TIME + (long)(CombatEngine.combatState.randomNumber / 2);
            this.combatLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.dodge"));
            this.combatLabel.setColor(new Color(0.4f, 0.85f, 0.5f, 1.0f));
            this.combatLabel.setVisible(true);
            if (CombatEngine.combatState.direction.equalsIgnoreCase("right")) {
                this.combatDodgeRight.playAnimation(0.5f, 0.125f, 0.1f);
            } else {
                this.combatDodgeLeft.playAnimation(0.5f, 0.125f, 0.1f);
            }
            UIHelpers.hightlightUIElement(this.highlights, this.pressureBar, 0.5f, UIHelpers.hightlightColor(this.pressureBar, 1));
            SequenceAction fadeInOverlay = Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.show(), (Action)Actions.color(new Color(0.0f, 0.0f, 0.0f, 0.6f), 0.3f), (Action)Actions.delay((float)this.actionTime / 1000.0f), (Action)Actions.alpha(0.0f));
            this.overlay.addAction(fadeInOverlay);
            this.clientCharacter.clearActions();
            this.hostCharacter.clearActions();
            if (this.hostFighter == CombatEngine.combatState.getDefender()) {
                if (this.scenarioFront != null) {
                    this.scenarioFront.setVisible(false);
                }
                if (CombatEngine.combatState.clientBossSpecial.contains("lightattack")) {
                    this.bossActor1.clearActions();
                    SequenceAction disappear = Actions.sequence((Action)Actions.alpha(1.0f), (Action)Actions.show(), (Action)Actions.delay(1.0f), (Action)Actions.alpha(0.0f), (Action)Actions.hide());
                    this.bossActor1.addAction(disappear);
                    this.bossActor2.clearActions();
                    this.bossActor2.setVisible(true);
                    SequenceAction appear = Actions.sequence((Action)Actions.alpha(1.0f), (Action)Actions.delay(1.0f), (Action)Actions.alpha(0.0f));
                    this.bossActor2.addAction(appear);
                    CombatEngine.combatState.clientBossSpecial = "";
                    this.clientAI.itemInterval = 6;
                }
                float clientMoveX = 0.0f;
                float clientMoveY = -this.clientMoveinit / 12.8f;
                float hostMoveX = 0.0f;
                float hostMoveY = 0.0f;
                this.drawEnemyFighter("hit", CombatEngine.combatState.direction, this.clientCharacter.getX() + clientMoveX, this.clientCharacter.getY() + clientMoveY, false);
                this.clientCharacter.addAction(Actions.moveTo(this.clientCharacter.getX() + clientMoveX * 2.0f, this.clientCharacter.getY() + clientMoveY * 2.0f, (float)this.actionTime / 1000.0f));
                if (status.split(":")[1].equalsIgnoreCase("left")) {
                    hostMoveX = -this.hostMoveinit / 4.0f;
                    hostMoveY = 0.0f;
                } else {
                    hostMoveX = this.hostMoveinit / 4.0f;
                    hostMoveY = 0.0f;
                }
                this.drawPCFighter("idle", CombatEngine.combatState.direction, this.hostCharacter.getX() + hostMoveX, this.hostCharacter.getY() + hostMoveY, false);
                this.hostCharacter.addAction(Actions.moveTo(this.hostCharacter.getX() + hostMoveX * 2.0f, this.hostCharacter.getY() + hostMoveY * 2.0f, (float)this.actionTime / 1000.0f));
            } else {
                float clientMoveX = 0.0f;
                float clientMoveY = -this.clientMoveinit / 12.8f;
                float hostMoveX = 0.0f;
                float hostMoveY = this.hostMoveinit / 12.8f;
                if (status.split(":")[1].equalsIgnoreCase("left")) {
                    clientMoveX = this.clientMoveinit / 4.0f;
                    clientMoveY = 0.0f;
                } else {
                    clientMoveX = -this.clientMoveinit / 4.0f;
                    clientMoveY = 0.0f;
                }
                this.drawEnemyFighter("idle", CombatEngine.combatState.direction, this.clientCharacter.getX() + clientMoveX, this.clientCharacter.getY() + clientMoveY, false);
                this.clientCharacter.addAction(Actions.moveTo(this.clientCharacter.getX() + clientMoveX * 2.0f, this.clientCharacter.getY() + clientMoveY * 2.0f, (float)this.actionTime / 1000.0f));
                this.drawPCFighter("hit", CombatEngine.combatState.direction, this.hostCharacter.getX() + hostMoveX, this.hostCharacter.getY() + hostMoveY, false);
                this.hostCharacter.addAction(Actions.moveTo(this.hostCharacter.getX() + hostMoveX * 2.0f, this.hostCharacter.getY() + hostMoveY * 2.0f, (float)this.actionTime / 1000.0f));
            }
            if (!this.game.isMultiplayerGame()) {
                this.clientAI.reset();
            }
            if (this.hostAI != null) {
                this.hostAI.reset();
            }
            this.hostWait = this.game.gameMode.equalsIgnoreCase("client");
            this.clientWait = true;
        } else if (status.startsWith("hit")) {
            String[] statusPhases;
            if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.equalsIgnoreCase("boss3") && this.clientFighter.life <= 0) {
                this.game.endScreen = new EndScreen(this.game, this.hostFighter.weapon.id);
                this.game.setScreen(this.game.endScreen);
                this.dispose();
                return;
            }
            if (!this.game.isMultiplayerGame()) {
                this.checkExceptionalEvent();
            }
            this.labelTime = this.actionTime = RESOLUTION_TIME + (long)(CombatEngine.combatState.randomNumber / 2);
            for (String currPhase : statusPhases = status.split(";")) {
                long soundId;
                if (!currPhase.startsWith("hit")) continue;
                if (this.hostFighter == CombatEngine.combatState.getDefender()) {
                    if (status.contains("critical")) {
                        soundId = this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("yay") + ".ogg"), Sound.class).play(this.game.soundVolume);
                        this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("yay") + ".ogg"), Sound.class).setPitch(soundId, 0.75f + (float)CombatEngine.combatState.randomNumber.intValue() / 2000.0f);
                        this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).setVolume(this.crowdSound, this.game.soundVolume / 2.0f + this.game.soundVolume * (float)CombatEngine.combatState.randomNumber.intValue() / 20.0f / 100.0f);
                        this.profits += 15;
                        this.combatLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.damage.critical") + "\n" + Integer.parseInt(currPhase.split(":")[1]) / 10);
                        this.shakeTime = this.combatTime + 500L;
                        this.timeLimitLabel.setY(UIHelpers.calcHeightProportion(this.game, 72.0f, 67.0f).floatValue());
                        this.timeLimitIndex.setY(this.timeLimitLabel.getY() + this.timeLimitLabel.getPrefHeight() / 2.0f - this.timeLimitIndex.getHeight() / 2.0f);
                        this.combatLabel.setY(UIHelpers.calcHeightProportion(this.game, 60.0f, 55.0f).floatValue());
                        this.surge.setX(UIHelpers.calcWidthProportion(this.game, 18.0f, 18.0f).floatValue());
                        OrthographicCamera camera = (OrthographicCamera)this.stage.getCamera();
                        camera.zoom = 0.7f;
                        camera.update();
                        this.stage.getBatch().setProjectionMatrix(camera.combined);
                        this.clearCamera = this.actionTime;
                        this.pressureBar.setVisible(false);
                        this.surgeEventBar.setVisible(false);
                        this.baseEventBar.setVisible(false);
                        break;
                    }
                    if (CombatEngine.combatState.randomNumber / 10 < 50) {
                        soundId = this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("yay") + ".ogg"), Sound.class).play(this.game.soundVolume);
                        this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("yay") + ".ogg"), Sound.class).setPitch(soundId, 0.75f + (float)CombatEngine.combatState.randomNumber.intValue() / 2000.0f);
                        this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).setVolume(this.crowdSound, this.game.soundVolume / 2.0f + this.game.soundVolume * (float)CombatEngine.combatState.randomNumber.intValue() / 20.0f / 100.0f);
                    }
                    this.combatLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.damage") + "\n" + Integer.parseInt(currPhase.split(":")[1]) / 10);
                    break;
                }
                if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.contains("tutorial") && this.getTutorialStep(false, 0).equalsIgnoreCase("end")) {
                    status = "hit:" + this.clientFighter.life / 10 + ";critical:0";
                    this.clientFighter.life = 0;
                }
                if (status.contains("critical")) {
                    soundId = this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("yay") + ".ogg"), Sound.class).play(this.game.soundVolume);
                    this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("yay") + ".ogg"), Sound.class).setPitch(soundId, 0.75f + (float)CombatEngine.combatState.randomNumber.intValue() / 2000.0f);
                    this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).setVolume(this.crowdSound, this.game.soundVolume / 2.0f + this.game.soundVolume * (float)CombatEngine.combatState.randomNumber.intValue() / 20.0f / 100.0f);
                    this.profits += 15;
                    this.combatLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.hit.critical") + "\n" + Integer.parseInt(currPhase.split(":")[1]) / 10);
                    this.shakeTime = this.combatTime + 500L;
                    this.timeLimitLabel.setY(UIHelpers.calcHeightProportion(this.game, 72.0f, 67.0f).floatValue());
                    this.timeLimitIndex.setY(this.timeLimitLabel.getY() + this.timeLimitLabel.getPrefHeight() / 2.0f - this.timeLimitIndex.getHeight() / 2.0f);
                    this.combatLabel.setY(UIHelpers.calcHeightProportion(this.game, 60.0f, 55.0f).floatValue());
                    this.surge.setX(UIHelpers.calcWidthProportion(this.game, 18.0f, 18.0f).floatValue());
                    OrthographicCamera camera = (OrthographicCamera)this.stage.getCamera();
                    camera.zoom = 0.7f;
                    camera.update();
                    this.stage.getBatch().setProjectionMatrix(camera.combined);
                    this.clearCamera = this.actionTime;
                    this.pressureBar.setVisible(false);
                    this.surgeEventBar.setVisible(false);
                    this.baseEventBar.setVisible(false);
                    break;
                }
                if (CombatEngine.combatState.randomNumber / 10 < 50) {
                    soundId = this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("yay") + ".ogg"), Sound.class).play(this.game.soundVolume);
                    this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("yay") + ".ogg"), Sound.class).setPitch(soundId, 0.75f + (float)CombatEngine.combatState.randomNumber.intValue() / 2000.0f);
                    this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).setVolume(this.crowdSound, this.game.soundVolume / 2.0f + this.game.soundVolume * (float)CombatEngine.combatState.randomNumber.intValue() / 20.0f / 100.0f);
                }
                this.combatLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.hit") + "\n" + Integer.parseInt(currPhase.split(":")[1]) / 10);
                break;
            }
            this.combatLabel.setColor(this.game.uiSkin.getColor("red"));
            this.combatLabel.setVisible(true);
            if (CombatEngine.combatState.isUse.booleanValue()) {
                SequenceAction scaleHideDelay = Actions.sequence((Action)Actions.scaleTo(2.0f, 2.0f, 1.0f), (Action)Actions.hide(), (Action)Actions.scaleTo(0.5f, 0.5f));
                if (CombatEngine.combatState.getAttacker().services.contains("shard")) {
                    this.combatShardEffect.setVisible(true);
                    this.combatShardEffect.addAction(scaleHideDelay);
                } else if (CombatEngine.combatState.getAttacker().services.contains("powder")) {
                    this.combatPowderEffect.setVisible(true);
                    this.combatPowderEffect.addAction(scaleHideDelay);
                } else if (CombatEngine.combatState.getAttacker().services.contains("net")) {
                    this.combatNetEffect.setVisible(true);
                    this.combatNetEffect.addAction(scaleHideDelay);
                }
            } else if (this.hostFighter == CombatEngine.combatState.getDefender()) {
                this.combatHitHost.setScale(1.0f);
                if (CombatEngine.combatState.direction.equalsIgnoreCase("right")) {
                    this.combatHitHost.setX(UIHelpers.calcWidthProportion(this.game, 2.0f, -15.0f).floatValue());
                    this.combatHitHost.setY(UIHelpers.calcHeightProportion(this.game, 15.0f, 20.0f).floatValue());
                    this.combatHitHost.setOrigin(12);
                    this.combatHitHost.setRotation(180.0f + MathUtils.random(30.0f));
                    this.combatHitHost.setOrigin(this.combatHitHost.getWidth() / 2.0f, this.combatHitHost.getHeight() / 2.0f);
                    this.combatHitHost.setOrigin(16);
                    this.combatHitHost.addAction(Actions.scaleTo(1.5f * (status.contains("critical") ? 1.5f : 1.0f), 1.5f * (status.contains("critical") ? 1.5f : 1.0f), 0.3f));
                } else if (CombatEngine.combatState.direction.equalsIgnoreCase("left")) {
                    this.combatHitHost.setX(UIHelpers.calcWidthProportion(this.game, 55.0f, 55.0f).floatValue() - this.combatHitHost.getWidth());
                    this.combatHitHost.setY(UIHelpers.calcHeightProportion(this.game, 15.0f, 20.0f).floatValue());
                    this.combatHitHost.setOrigin(12);
                    this.combatHitHost.setRotation(329.0f + MathUtils.random(30.0f));
                    this.combatHitHost.setOrigin(this.combatHitHost.getWidth() / 2.0f, this.combatHitHost.getHeight() / 2.0f);
                    this.combatHitHost.setOrigin(16);
                    this.combatHitHost.addAction(Actions.scaleTo(1.5f * (status.contains("critical") ? 1.5f : 1.0f), 1.5f * (status.contains("critical") ? 1.5f : 1.0f), 0.3f));
                } else {
                    this.combatHitHost.setX(UIHelpers.calcWidthProportion(this.game, 45.0f, 45.0f).floatValue() - this.combatHitHost.getWidth());
                    this.combatHitHost.setY(UIHelpers.calcHeightProportion(this.game, 20.0f, 25.0f).floatValue());
                    this.combatHitHost.setOrigin(12);
                    this.combatHitHost.setRotation(75.0f + MathUtils.random(30.0f));
                    this.combatHitHost.setOrigin(this.combatHitHost.getWidth() / 2.0f, this.combatHitHost.getHeight() / 2.0f);
                    this.combatHitHost.setOrigin(16);
                    this.combatHitHost.addAction(Actions.scaleTo(1.25f * (status.contains("critical") ? 1.5f : 1.0f), 2.0f * (status.contains("critical") ? 1.5f : 1.0f), 0.3f));
                }
                this.combatHitHost.setVisible(true);
            } else {
                if (CombatEngine.combatState.randomNumber / 10 % 2 == 0) {
                    long hurtId = this.game.manager.get(this.game.getOverridenFilename("sound/hurt" + this.clientFighter.hurt.split(":")[0] + ".ogg"), Sound.class).play(this.game.soundVolume);
                    this.game.manager.get(this.game.getOverridenFilename("sound/hurt" + this.clientFighter.hurt.split(":")[0] + ".ogg"), Sound.class).setPitch(hurtId, 0.5f + Float.parseFloat(this.clientFighter.hurt.split(":")[1]));
                    this.combatHitClient.setScale(1.0f);
                }
                if (CombatEngine.combatState.direction.equalsIgnoreCase("left")) {
                    this.combatHitClient.setX(UIHelpers.calcWidthProportion(this.game, 12.0f, 0.0f).floatValue());
                    this.combatHitClient.setY(UIHelpers.calcHeightProportion(this.game, 35.0f, 40.0f).floatValue());
                    this.combatHitClient.setOrigin(12);
                    this.combatHitClient.setRotation(180.0f + MathUtils.random(30.0f));
                    this.combatHitClient.setOrigin(this.combatHitClient.getWidth() / 2.0f, this.combatHitClient.getHeight() / 2.0f);
                    this.combatHitClient.setOrigin(16);
                    this.combatHitClient.addAction(Actions.scaleTo(1.25f * (status.contains("critical") ? 1.5f : 1.0f), 1.25f * (status.contains("critical") ? 1.5f : 1.0f), 0.3f));
                } else if (CombatEngine.combatState.direction.equalsIgnoreCase("right")) {
                    this.combatHitClient.setX(UIHelpers.calcWidthProportion(this.game, 60.0f, 65.0f).floatValue() - this.combatHitClient.getWidth());
                    this.combatHitClient.setY(UIHelpers.calcHeightProportion(this.game, 35.0f, 40.0f).floatValue());
                    this.combatHitClient.setOrigin(12);
                    this.combatHitClient.setRotation(329.0f + MathUtils.random(30.0f));
                    this.combatHitClient.setOrigin(this.combatHitClient.getWidth() / 2.0f, this.combatHitClient.getHeight() / 2.0f);
                    this.combatHitClient.setOrigin(16);
                    this.combatHitClient.addAction(Actions.scaleTo(1.25f * (status.contains("critical") ? 1.5f : 1.0f), 1.25f * (status.contains("critical") ? 1.5f : 1.0f), 0.3f));
                } else {
                    this.combatHitClient.setX(UIHelpers.calcWidthProportion(this.game, 55.0f, 55.0f).floatValue() - this.combatHitClient.getWidth());
                    this.combatHitClient.setY(UIHelpers.calcHeightProportion(this.game, 40.0f, 45.0f).floatValue());
                    this.combatHitClient.setOrigin(12);
                    this.combatHitClient.setRotation(75.0f + MathUtils.random(30.0f));
                    this.combatHitClient.setOrigin(this.combatHitClient.getWidth() / 2.0f, this.combatHitClient.getHeight() / 2.0f);
                    this.combatHitClient.setOrigin(16);
                    this.combatHitClient.addAction(Actions.scaleTo(1.0f * (status.contains("critical") ? 1.5f : 1.0f), 1.65f * (status.contains("critical") ? 1.5f : 1.0f), 0.3f));
                }
                this.combatHitClient.setVisible(true);
            }
            SequenceAction fadeInOverlay = Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.show(), (Action)Actions.color(new Color(0.0f, 0.0f, 0.0f, 0.6f), 0.3f), (Action)Actions.delay((float)this.actionTime / 1000.0f), (Action)Actions.alpha(0.0f));
            this.overlay.addAction(fadeInOverlay);
            this.clientCharacter.clearActions();
            this.hostCharacter.clearActions();
            if (this.hostFighter == CombatEngine.combatState.getDefender()) {
                if (this.scenarioFront != null) {
                    this.scenarioFront.setVisible(false);
                }
                if (CombatEngine.combatState.clientBossSpecial.contains("lightattack")) {
                    this.bossActor1.clearActions();
                    SequenceAction disappear = Actions.sequence((Action)Actions.alpha(1.0f), (Action)Actions.show(), (Action)Actions.delay(1.0f), (Action)Actions.alpha(0.0f), (Action)Actions.hide());
                    this.bossActor1.addAction(disappear);
                    this.bossActor2.clearActions();
                    this.bossActor2.setVisible(true);
                    SequenceAction appear = Actions.sequence((Action)Actions.alpha(1.0f), (Action)Actions.delay(1.0f), (Action)Actions.alpha(0.0f));
                    this.bossActor2.addAction(appear);
                    this.lightningScreen.clearActions();
                    SequenceAction hideDelay = Actions.sequence((Action)Actions.show(), (Action)Actions.delay(1.0f), (Action)Actions.hide());
                    this.lightningScreen.addAction(hideDelay);
                    this.shakeTime = this.combatTime + 500L;
                    CombatEngine.combatState.clientBossSpecial = "";
                    this.clientAI.itemInterval = 6;
                }
                float clientMoveX = 0.0f;
                float clientMoveY = 0.0f;
                float hostMoveX = 0.0f;
                float hostMoveY = 0.0f;
                if (CombatEngine.combatState.direction.equalsIgnoreCase("left")) {
                    clientMoveX = this.clientMoveinit / 8.0f;
                    clientMoveY = -this.clientMoveinit / 12.8f;
                    hostMoveX = this.hostMoveinit / 8.0f;
                    hostMoveY = 0.0f;
                } else if (CombatEngine.combatState.direction.equalsIgnoreCase("right")) {
                    clientMoveX = -this.clientMoveinit / 8.0f;
                    clientMoveY = -this.clientMoveinit / 12.8f;
                    hostMoveX = -this.hostMoveinit / 8.0f;
                    hostMoveY = 0.0f;
                } else {
                    clientMoveX = 0.0f;
                    clientMoveY = -this.clientMoveinit / 12.8f;
                    hostMoveX = 0.0f;
                    hostMoveY = 0.0f;
                }
                this.drawEnemyFighter("hit", CombatEngine.combatState.direction, this.clientCharacter.getX() + clientMoveX, this.clientCharacter.getY() + clientMoveY, false);
                this.clientCharacter.addAction(Actions.moveTo(this.clientCharacter.getX() + clientMoveX * 2.0f, this.clientCharacter.getY() + clientMoveY * 2.0f, (float)this.actionTime / 1000.0f));
                this.drawPCFighter("parry", CombatEngine.combatState.direction, this.hostCharacter.getX() + hostMoveX, this.hostCharacter.getY() + hostMoveY, false);
                this.hostCharacter.addAction(Actions.moveTo(this.hostCharacter.getX() + hostMoveX * 2.0f, this.hostCharacter.getY() + hostMoveY * 2.0f, (float)this.actionTime / 1000.0f));
            } else {
                float clientMoveX = 0.0f;
                float clientMoveY = 0.0f;
                float hostMoveX = 0.0f;
                float hostMoveY = 0.0f;
                if (CombatEngine.combatState.direction.equalsIgnoreCase("left")) {
                    clientMoveX = -this.clientMoveinit / 8.0f;
                    clientMoveY = 0.0f;
                    hostMoveX = -this.hostMoveinit / 8.0f;
                    hostMoveY = this.hostMoveinit / 12.8f;
                } else if (CombatEngine.combatState.direction.equalsIgnoreCase("right")) {
                    clientMoveX = this.clientMoveinit / 8.0f;
                    clientMoveY = 0.0f;
                    hostMoveX = this.hostMoveinit / 8.0f;
                    hostMoveY = this.hostMoveinit / 12.8f;
                } else {
                    clientMoveX = 0.0f;
                    clientMoveY = 0.0f;
                    hostMoveX = 0.0f;
                    hostMoveY = this.hostMoveinit / 12.8f;
                }
                this.drawEnemyFighter("parry", CombatEngine.combatState.direction, this.clientCharacter.getX() + clientMoveX, this.clientCharacter.getY() + clientMoveY, false);
                this.clientCharacter.addAction(Actions.moveTo(this.clientCharacter.getX() + clientMoveX * 2.0f, this.clientCharacter.getY() + clientMoveY * 2.0f, (float)this.actionTime / 1000.0f));
                this.drawPCFighter("hit", CombatEngine.combatState.direction, this.hostCharacter.getX() + hostMoveX, this.hostCharacter.getY() + hostMoveY, false);
                this.hostCharacter.addAction(Actions.moveTo(this.hostCharacter.getX() + hostMoveX * 2.0f, this.hostCharacter.getY() + hostMoveY * 2.0f, (float)this.actionTime / 1000.0f));
            }
            if (!this.game.isMultiplayerGame()) {
                this.clientAI.reset();
            }
            if (this.hostAI != null) {
                this.hostAI.reset();
            }
            this.hostWait = false;
            this.clientWait = true;
        } else if (status.startsWith("chain")) {
            String[] phaseElements = status.split(":");
            float phaseTime = Float.parseFloat(phaseElements[1]) * (float)(this.slomo && this.hostFighter == CombatEngine.combatState.getAttacker() ? 5 : 1);
            this.actionTime = (long)phaseTime + (long)PHASE_TIME;
            availableTimes.add(this.actionTime);
            if (!this.game.isMultiplayerGame()) {
                if (this.clientFighter.name.startsWith("boss") && this.checkBossStep()) {
                    this.hostWait = true;
                    this.clientWait = false;
                    this.clientAI.takeDecision(availableTimes);
                    this.clientAI.actionTime += 2000L;
                    this.actionTime += 2000L;
                    this.lastStatusTime = this.combatTime;
                    return;
                }
                this.checkExceptionalEvent();
            }
            if (this.hostFighter == CombatEngine.combatState.getAttacker()) {
                TextureAtlas combatButtonsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), TextureAtlas.class);
                this.upMiddleAttack.playAnimation(phaseTime / 1000.0f, phaseTime / 20000.0f, PHASE_TIME / 1000.0f);
                this.centerLeftAttack.playAnimation(phaseTime / 1000.0f, phaseTime / 20000.0f, PHASE_TIME / 1000.0f);
                this.centerRightAttack.playAnimation(phaseTime / 1000.0f, phaseTime / 20000.0f, PHASE_TIME / 1000.0f);
                this.upMiddleAttack.setX(this.upMiddleAttackb.getX() + 1.0f);
                this.upMiddleAttack.setY(this.upMiddleAttackb.getY() + 1.0f);
                this.centerLeftAttack.setX(this.centerLeftAttackb.getX() + 1.0f);
                this.centerLeftAttack.setY(this.centerLeftAttackb.getY() + 1.0f);
                this.centerRightAttack.setX(this.centerRightAttackb.getX() + 1.0f);
                this.centerRightAttack.setY(this.centerRightAttackb.getY() + 1.0f);
                SequenceAction showBorder = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(phaseTime / 1000.0f), (Action)Actions.hide());
                this.upMiddleAttackb.clearActions();
                if (CombatEngine.combatState.vulnerableDirection.equalsIgnoreCase("middle")) {
                    this.upMiddleAttackb.setTexture(combatButtonsAtlas.findRegion("buttonweakborder"), (float)Float.valueOf(this.upMiddleAttackb.getWidth()).intValue(), (float)Float.valueOf(this.upMiddleAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.upMiddleAttackb.setColor(Color.valueOf("CC0000FF"));
                    } else {
                        this.upMiddleAttackb.setColor(Color.valueOf("D99BD7FF"));
                    }
                } else {
                    this.upMiddleAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)Float.valueOf(this.upMiddleAttackb.getWidth()).intValue(), (float)Float.valueOf(this.upMiddleAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.upMiddleAttackb.setColor(Color.valueOf("FF0000FF"));
                    } else {
                        this.upMiddleAttackb.setColor(Color.valueOf("C7DEE0FF"));
                    }
                }
                this.upMiddleAttackb.setVisible(true);
                this.upMiddleAttackb.addAction(showBorder);
                showBorder = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(phaseTime / 1000.0f), (Action)Actions.hide());
                this.centerLeftAttackb.clearActions();
                if (CombatEngine.combatState.vulnerableDirection.equalsIgnoreCase("left")) {
                    this.centerLeftAttackb.setTexture(combatButtonsAtlas.findRegion("buttonweakborder"), (float)Float.valueOf(this.centerLeftAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerLeftAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.upMiddleAttackb.setColor(Color.valueOf("CC0000FF"));
                    } else {
                        this.centerLeftAttackb.setColor(Color.valueOf("D99BD7FF"));
                    }
                } else {
                    this.centerLeftAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)Float.valueOf(this.centerLeftAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerLeftAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.upMiddleAttackb.setColor(Color.valueOf("FF0000FF"));
                    } else {
                        this.centerLeftAttackb.setColor(Color.valueOf("C7DEE0FF"));
                    }
                }
                this.centerLeftAttackb.setVisible(true);
                this.centerLeftAttackb.addAction(showBorder);
                showBorder = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(phaseTime / 1000.0f), (Action)Actions.hide());
                this.centerRightAttackb.clearActions();
                if (CombatEngine.combatState.vulnerableDirection.equalsIgnoreCase("right")) {
                    this.centerRightAttackb.setTexture(combatButtonsAtlas.findRegion("buttonweakborder"), (float)Float.valueOf(this.centerRightAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerRightAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.upMiddleAttackb.setColor(Color.valueOf("CC0000FF"));
                    } else {
                        this.centerRightAttackb.setColor(Color.valueOf("D99BD7FF"));
                    }
                } else {
                    this.centerRightAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)Float.valueOf(this.centerRightAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerRightAttackb.getHeight()).intValue());
                    if (!this.scenario.equalsIgnoreCase("") && ((JSONObject)((JSONObject)this.game.stats.get("phases").get("scenarios")).get(this.scenario)).getFloat("damageReduction") > 0.0f && CombatEngine.combatState.scenarioLife > 0) {
                        this.upMiddleAttackb.setColor(Color.valueOf("FF0000FF"));
                    } else {
                        this.centerRightAttackb.setColor(Color.valueOf("C7DEE0FF"));
                    }
                }
                this.centerRightAttackb.setVisible(true);
                this.centerRightAttackb.addAction(showBorder);
                if (this.useItem != null && this.hostFighter.itemUses > 0) {
                    this.useItem.clearActions();
                    SequenceAction showDelay = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show());
                    this.useItem.addAction(showDelay);
                }
                this.hostWait = false;
                this.clientWait = true;
                CombatEngine.addLogTrace(CombatEngine.combatState.hostLog, "l;Action time: " + availableTimes.get(0));
            } else {
                this.hostWait = true;
                this.clientWait = false;
                CombatEngine.addLogTrace(CombatEngine.combatState.clientLog, "l;Action time: " + availableTimes.get(0));
            }
            this.clientCharacter.clearActions();
            this.hostCharacter.clearActions();
            this.clientCharacter.addAction(Actions.moveTo(this.clientXinit, this.clientYinit, 0.1f));
            this.hostCharacter.addAction(Actions.moveTo(this.hostXinit, this.hostYinit, 0.1f));
            this.drawEnemyFighter("idle", "", 0.0f, 0.0f, false);
            this.drawPCFighter("idle", "", 0.0f, 0.0f, false);
            if (!this.game.isMultiplayerGame()) {
                this.clientAI.takeDecision(availableTimes);
            }
            if (this.hostAI != null) {
                this.hostAI.takeDecision(availableTimes);
            }
        } else if (status.startsWith("risposte")) {
            String[] phaseElements = status.split(":");
            float phaseTime = Float.parseFloat(phaseElements[1]) * (float)(this.slomo && this.hostFighter == CombatEngine.combatState.getAttacker() ? 5 : 1);
            this.actionTime = (long)phaseTime + (long)PHASE_TIME;
            availableTimes.add(this.actionTime);
            if (!this.game.isMultiplayerGame()) {
                if (this.clientFighter.name.startsWith("boss") && this.checkBossStep()) {
                    this.hostWait = true;
                    this.clientWait = false;
                    this.clientAI.takeDecision(availableTimes);
                    this.clientAI.actionTime += 2000L;
                    this.actionTime += 2000L;
                    this.lastStatusTime = this.combatTime;
                    return;
                }
                this.checkExceptionalEvent();
            }
            if (this.hostFighter == CombatEngine.combatState.getAttacker()) {
                TextureAtlas combatButtonsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), TextureAtlas.class);
                this.upMiddleAttack.playAnimation(phaseTime / 1000.0f, phaseTime / 20000.0f, PHASE_TIME / 1000.0f);
                this.centerLeftAttack.playAnimation(phaseTime / 1000.0f, phaseTime / 20000.0f, PHASE_TIME / 1000.0f);
                this.centerRightAttack.playAnimation(phaseTime / 1000.0f, phaseTime / 20000.0f, PHASE_TIME / 1000.0f);
                this.upMiddleAttack.setX(this.upMiddleAttackb.getX() + 1.0f);
                this.upMiddleAttack.setY(this.upMiddleAttackb.getY() + 1.0f);
                this.centerLeftAttack.setX(this.centerLeftAttackb.getX() + 1.0f);
                this.centerLeftAttack.setY(this.centerLeftAttackb.getY() + 1.0f);
                this.centerRightAttack.setX(this.centerRightAttackb.getX() + 1.0f);
                this.centerRightAttack.setY(this.centerRightAttackb.getY() + 1.0f);
                SequenceAction showBorder = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(phaseTime / 1000.0f), (Action)Actions.hide());
                this.upMiddleAttackb.clearActions();
                if (CombatEngine.combatState.vulnerableDirection.equalsIgnoreCase("middle")) {
                    this.upMiddleAttackb.setTexture(combatButtonsAtlas.findRegion("buttonweakborder"), (float)Float.valueOf(this.upMiddleAttackb.getWidth()).intValue(), (float)Float.valueOf(this.upMiddleAttackb.getHeight()).intValue());
                    this.upMiddleAttackb.setColor(Color.valueOf("D99BD7FF"));
                } else {
                    this.upMiddleAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)Float.valueOf(this.upMiddleAttackb.getWidth()).intValue(), (float)Float.valueOf(this.upMiddleAttackb.getHeight()).intValue());
                    this.upMiddleAttackb.setColor(Color.valueOf("C7DEE0FF"));
                }
                this.upMiddleAttackb.setVisible(true);
                this.upMiddleAttackb.addAction(showBorder);
                showBorder = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(phaseTime / 1000.0f), (Action)Actions.hide());
                this.centerLeftAttackb.clearActions();
                if (CombatEngine.combatState.vulnerableDirection.equalsIgnoreCase("left")) {
                    this.centerLeftAttackb.setTexture(combatButtonsAtlas.findRegion("buttonweakborder"), (float)Float.valueOf(this.centerLeftAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerLeftAttackb.getHeight()).intValue());
                    this.centerLeftAttackb.setColor(Color.valueOf("D99BD7FF"));
                } else {
                    this.centerLeftAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)Float.valueOf(this.centerLeftAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerLeftAttackb.getHeight()).intValue());
                    this.centerLeftAttackb.setColor(Color.valueOf("C7DEE0FF"));
                }
                this.centerLeftAttackb.setVisible(true);
                this.centerLeftAttackb.addAction(showBorder);
                showBorder = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show(), (Action)Actions.delay(phaseTime / 1000.0f), (Action)Actions.hide());
                this.centerRightAttackb.clearActions();
                if (CombatEngine.combatState.vulnerableDirection.equalsIgnoreCase("right")) {
                    this.centerRightAttackb.setTexture(combatButtonsAtlas.findRegion("buttonweakborder"), (float)Float.valueOf(this.centerRightAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerRightAttackb.getHeight()).intValue());
                    this.centerRightAttackb.setColor(Color.valueOf("D99BD7FF"));
                } else {
                    this.centerRightAttackb.setTexture(combatButtonsAtlas.findRegion("buttonborder"), (float)Float.valueOf(this.centerRightAttackb.getWidth()).intValue(), (float)Float.valueOf(this.centerRightAttackb.getHeight()).intValue());
                    this.centerRightAttackb.setColor(Color.valueOf("C7DEE0FF"));
                }
                this.centerRightAttackb.setVisible(true);
                this.centerRightAttackb.addAction(showBorder);
                if (this.useItem != null && this.hostFighter.itemUses > 0) {
                    this.useItem.clearActions();
                    SequenceAction showDelay = Actions.sequence((Action)Actions.hide(), (Action)Actions.delay(PHASE_TIME / 1000.0f), (Action)Actions.show());
                    this.useItem.addAction(showDelay);
                }
                this.hostWait = false;
                this.clientWait = true;
                CombatEngine.addLogTrace(CombatEngine.combatState.hostLog, "l;Action time: " + availableTimes.get(0));
            } else {
                this.hostWait = true;
                this.clientWait = false;
                CombatEngine.addLogTrace(CombatEngine.combatState.clientLog, "l;Action time: " + availableTimes.get(0));
            }
            this.clientCharacter.clearActions();
            this.hostCharacter.clearActions();
            this.clientCharacter.addAction(Actions.moveTo(this.clientXinit, this.clientYinit, 0.1f));
            this.hostCharacter.addAction(Actions.moveTo(this.hostXinit, this.hostYinit, 0.1f));
            this.drawEnemyFighter("idle", "", 0.0f, 0.0f, false);
            this.drawPCFighter("idle", "", 0.0f, 0.0f, false);
            if (!this.game.isMultiplayerGame()) {
                this.clientAI.takeDecision(availableTimes);
            }
            if (this.hostAI != null) {
                this.hostAI.takeDecision(availableTimes);
            }
        } else if (status.startsWith("victory")) {
            long hurtId = this.game.manager.get(this.game.getOverridenFilename("sound/hurt" + this.clientFighter.hurt.split(":")[0] + ".ogg"), Sound.class).play(this.game.soundVolume);
            this.game.manager.get(this.game.getOverridenFilename("sound/hurt" + this.clientFighter.hurt.split(":")[0] + ".ogg"), Sound.class).setPitch(hurtId, 0.5f + Float.parseFloat(this.clientFighter.hurt.split(":")[1]));
            this.combatHitClient.setScale(1.0f);
            this.game.manager.get(this.game.getOverridenFilename("sound/bodydrop.ogg"), Sound.class).play(this.game.soundVolume);
            this.talkDirection.setVisible(false);
            this.talkBackground.setVisible(false);
            this.talkSentence.setVisible(false);
            this.talkTime = this.combatTime + 60000L;
            this.launchClaim();
            this.timeLimitLabel.setY(UIHelpers.calcHeightProportion(this.game, 72.0f, 67.0f).floatValue());
            this.timeLimitIndex.setY(this.timeLimitLabel.getY() + this.timeLimitLabel.getPrefHeight() / 2.0f - this.timeLimitIndex.getHeight() / 2.0f);
            this.lastStatusTime = this.combatTime;
            this.labelTime = 60000L;
            this.combatLabel.setVisible(false);
            this.clientCharacter.clearActions();
            OrthographicCamera camera = (OrthographicCamera)this.stage.getCamera();
            camera.zoom = 0.7f;
            camera.update();
            this.stage.getBatch().setProjectionMatrix(camera.combined);
            this.clearCamera = 1000L;
            for (Actor currPart : this.clientCharacter.getChildren()) {
                currPart.addAction(Actions.color(Color.valueOf("000000FF"), 1.0f));
            }
            SequenceAction die = Actions.sequence((Action)Actions.color(Color.valueOf("000000FF"), 0.3f), (Action)Actions.parallel((Action)Actions.scaleTo(1.0f, 0.9f, 0.5f), (Action)Actions.moveTo((this.clientKneel.getX() + this.clientCharacter.getX()) / 2.0f, (this.clientKneel.getY() + this.clientCharacter.getY()) / 2.0f, 0.5f)), (Action)Actions.hide());
            this.clientCharacter.addAction(die);
            SequenceAction kneelCorpse = Actions.sequence((Action)Actions.delay(0.8f), (Action)Actions.show(), (Action)Actions.delay(1.2f), (Action)Actions.hide());
            this.clientKneel.setX((this.clientKneel.getX() + this.clientCharacter.getX()) / 2.0f);
            this.clientKneel.setY((this.clientKneel.getY() + this.clientCharacter.getY()) / 2.0f);
            this.clientKneel.addAction(kneelCorpse);
            SequenceAction dieCorpse = Actions.sequence((Action)Actions.delay(2.0f), (Action)Actions.show());
            this.clientCorpse.addAction(dieCorpse);
            if (!this.game.isMultiplayerGame()) {
                if (this.clientFighter.name.equalsIgnoreCase("boss1")) {
                    if (this.bossActor1.isVisible()) {
                        this.bossActor1.clearActions();
                        SequenceAction die1 = Actions.sequence((Action)Actions.delay(0.5f), (Action)Actions.color(Color.valueOf("000000FF"), 1.0f), (Action)Actions.delay(0.5f), (Action)Actions.color(Color.valueOf("00000000"), 1.0f), (Action)Actions.hide());
                        this.bossActor1.addAction(die1);
                    }
                    if (this.bossActor2.isVisible()) {
                        this.bossActor2.clearActions();
                        SequenceAction die2 = Actions.sequence((Action)Actions.delay(0.5f), (Action)Actions.color(Color.valueOf("000000FF"), 1.0f), (Action)Actions.delay(0.5f), (Action)Actions.color(Color.valueOf("00000000"), 1.0f), (Action)Actions.hide());
                        this.bossActor2.addAction(die2);
                    }
                }
                if ((this.game.gameMode.equalsIgnoreCase("story") || this.game.gameMode.equalsIgnoreCase("tournament")) && this.clientFighter.name.contains("boss3")) {
                    this.game.track.stop();
                    this.game.track.dispose();
                    this.game.track = Gdx.audio.newMusic(Gdx.files.internal(this.game.getOverridenFilename("music/sl14e.ogg")));
                    this.game.track.setLooping(false);
                    this.game.track.setVolume(this.game.musicVolume);
                    this.game.track.play();
                    if (this.game.gameMode.equalsIgnoreCase("story")) {
                        this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).stop();
                    }
                }
            }
            if (!this.game.isMultiplayerGame()) {
                this.clientAI.reset();
            }
            if (this.hostAI != null) {
                this.hostAI.reset();
            }
            this.hostWait = true;
            this.clientWait = true;
        } else if (status.startsWith("defeat")) {
            if (this.scenarioFront != null) {
                this.scenarioFront.setVisible(false);
            }
            this.talkDirection.setVisible(false);
            this.talkBackground.setVisible(false);
            this.talkSentence.setVisible(false);
            this.claim1.clearActions();
            this.claim1.setVisible(false);
            this.claim1label.setVisible(false);
            this.claim2.clearActions();
            this.claim2.setVisible(false);
            this.claim2label.setVisible(false);
            this.claim3.clearActions();
            this.claim3.setVisible(false);
            this.claim3label.setVisible(false);
            this.claim4.clearActions();
            this.claim4.setVisible(false);
            this.claim4label.setVisible(false);
            this.timeLimitLabel.setY(UIHelpers.calcHeightProportion(this.game, 72.0f, 67.0f).floatValue());
            this.timeLimitIndex.setY(this.timeLimitLabel.getY() + this.timeLimitLabel.getPrefHeight() / 2.0f - this.timeLimitIndex.getHeight() / 2.0f);
            this.lastStatusTime = this.combatTime;
            this.labelTime = 60000L;
            this.combatLabel.setVisible(false);
            this.endLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.defeat") + "!");
            this.endLabel.setColor(new Color(0.6f, 0.1f, 0.0f, 1.0f));
            this.hostCharacter.clearActions();
            OrthographicCamera camera = (OrthographicCamera)this.stage.getCamera();
            camera.zoom = 0.7f;
            camera.update();
            this.stage.getBatch().setProjectionMatrix(camera.combined);
            this.clearCamera = 1000L;
            for (Actor currPart : this.hostCharacter.getChildren()) {
                currPart.addAction(Actions.color(Color.valueOf("000000FF"), 1.0f));
            }
            SequenceAction die = Actions.sequence((Action)Actions.delay(0.5f), (Action)Actions.color(Color.valueOf("000000FF"), 1.0f), (Action)Actions.color(Color.valueOf("00000000"), 0.5f), (Action)Actions.hide());
            this.hostCharacter.addAction(die);
            if (!this.game.isMultiplayerGame()) {
                this.clientAI.reset();
            }
            if (this.hostAI != null) {
                this.hostAI.reset();
            }
            this.hostWait = true;
            this.clientWait = true;
        }
        if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.contains("tutorial") && !(currStep = this.getTutorialStep(false, 0)).equalsIgnoreCase("end") && !currStep.contains("check")) {
            this.upMiddleAttack.visibleTime = 0.0f;
            this.centerLeftAttack.visibleTime = 0.0f;
            this.centerRightAttack.visibleTime = 0.0f;
            this.upMiddleParry.visibleTime = 0.0f;
            this.centerLeftParry.visibleTime = 0.0f;
            this.centerRightParry.visibleTime = 0.0f;
            this.downLeft.visibleTime = 0.0f;
            this.downRight.visibleTime = 0.0f;
            this.downLeft.visibleTime = 0.0f;
            this.downRight.visibleTime = 0.0f;
            this.upMiddleAttackb.clearActions();
            this.upMiddleAttackb.setVisible(false);
            this.centerLeftAttackb.clearActions();
            this.centerLeftAttackb.setVisible(false);
            this.centerRightAttackb.clearActions();
            this.centerRightAttackb.setVisible(false);
            this.upMiddleParryb.clearActions();
            this.upMiddleParryb.setVisible(false);
            this.centerLeftParryb.clearActions();
            this.centerLeftParryb.setVisible(false);
            this.centerRightParryb.clearActions();
            this.centerRightParryb.setVisible(false);
            this.downLeftb.clearActions();
            this.downLeftb.setVisible(false);
            this.downRightb.clearActions();
            this.downRightb.setVisible(false);
        }
        this.lastStatusTime = this.combatTime;
    }

    private void renderSurge(Fighter fighter) {
        if (!fighter.isHost && !CombatEngine.combatState.clientSurgeType.equalsIgnoreCase("default")) {
            this.combatSurge.setVisible(true);
            this.combatSurge.clearActions();
            if (CombatEngine.combatState.clientSurgeType.equalsIgnoreCase("strain")) {
                this.combatSurge.setColor(Color.valueOf("DD0011FF"));
            } else if (CombatEngine.combatState.clientSurgeType.equalsIgnoreCase("pierce")) {
                this.combatSurge.setColor(Color.valueOf("DDAA00FF"));
            } else if (CombatEngine.combatState.clientSurgeType.equalsIgnoreCase("press")) {
                this.combatSurge.setColor(Color.valueOf("55DD00FF"));
            } else if (CombatEngine.combatState.clientSurgeType.equalsIgnoreCase("brink")) {
                this.combatSurge.setColor(Color.valueOf("0011AAFF"));
            } else if (CombatEngine.combatState.clientSurgeType.equalsIgnoreCase("barrie")) {
                this.combatSurge.setColor(Color.valueOf("AA00DDFF"));
            }
            RepeatAction rotate = Actions.repeat(300000, Actions.rotateBy(360.0f, 6.0f));
            this.combatSurge.addAction(rotate);
        }
    }

    private Action actionShake(float x, float y, int iterations, float force, float time) {
        return Actions.repeat(iterations, Actions.sequence((Action)Actions.moveTo(x + force, y + force, time), (Action)Actions.moveTo(x - force * 2.0f, y - force * 2.0f, time), (Action)Actions.moveTo(x + force, y + force, time), (Action)Actions.moveTo(x, y)));
    }

    private void checkCombatIntput(BaseActor actor, String type, String direction) {
        if (actor == this.surge) {
            if (this.hostFighter.surge == 10000) {
                this.surge.setVisible(false);
                String surgeType = CombatEngine.useSurge(this.hostFighter);
                this.sendMessage("surge_" + surgeType + "_0_h", false);
                return;
            }
        } else {
            if (this.hostWait) {
                return;
            }
            if (actor == this.useItem) {
                if (this.hostFighter.itemUses > 0) {
                    this.sendMessage("use_right_0_h", true);
                    return;
                }
            } else {
                AnimatedActor animActor = (AnimatedActor)actor;
                int finalDeviation = Float.valueOf(Math.abs(0.5f - (animActor.elapsedTime - animActor.delayTime) / animActor.visibleTime) * 10.0f).intValue() * 10;
                if (finalDeviation > 50) {
                    finalDeviation = 50;
                } else if (finalDeviation < 0) {
                    finalDeviation = 0;
                }
                int newRandomNumber = MathUtils.random(999);
                if (this.hostAI == null && animActor.visibleTime + animActor.delayTime - animActor.elapsedTime >= animActor.visibleTime / 20.0f && CombatEngine.canPayActionCost(type, direction, finalDeviation, this.hostFighter, this.clientFighter, newRandomNumber) && !CombatEngine.combatState.clientBossSpecial.equalsIgnoreCase(direction)) {
                    CombatEngine.combatState.randomNumber = newRandomNumber;
                    this.sendMessage(type + "_" + direction + "_" + finalDeviation + "_h", true);
                    return;
                }
            }
        }
        actor.addAction(this.actionShake(actor.getX(), actor.getY(), 10, 3.0f, 0.02f));
    }

    private void checkSentence(String status) {
        if (!this.game.isMultiplayerGame() && this.clientFighter.life > 0 && this.talkTime < this.combatTime - 2000L && (status.equalsIgnoreCase("") || status.startsWith("start")) && MathUtils.random(99) < 25 + (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.contains("tutorial") ? 25 : 0) + (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.startsWith("boss") ? 10 : 0)) {
            String suffix = "base.";
            suffix = this.clientFighter.life < 35000 && this.clientFighter.life * 2 < this.hostFighter.life ? "losing.1" : suffix + (MathUtils.random(2) + 1);
            String textSentence = "";
            textSentence = this.clientFighter.name.equalsIgnoreCase("") || this.clientFighter.name.equalsIgnoreCase("custom") || this.clientFighter.name.equalsIgnoreCase("Host") || this.clientFighter.name.equalsIgnoreCase("Client") ? PropertiesReader.getMessage(this.game.gameMessages, "talk.emma." + suffix, this.game.violenceFilter, "##:" + new Color(this.game.uiSkin.get("lightgrey", Color.class)).mul(0.9f).toString()) : PropertiesReader.getMessage(this.game.gameMessages, "talk." + this.clientFighter.name + "." + suffix, this.game.violenceFilter, "##:" + new Color(this.game.uiSkin.get("lightgrey", Color.class)).mul(0.9f).toString());
            if (!textSentence.trim().equalsIgnoreCase("")) {
                this.showSentence(textSentence);
                this.talkTime = this.combatTime + 3000L;
            } else {
                this.talkDirection.setVisible(false);
                this.talkBackground.setVisible(false);
                this.talkSentence.setVisible(false);
            }
            if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.startsWith("boss")) {
                this.talkTime = this.combatTime + 3000L;
                this.launchClaim();
            }
        }
    }

    private void launchClaim() {
        StringBuilder currRewards = StringList.create(this.game.saveGame.get("rewards"), ";");
        if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.contains("boss") && (StringList.indexOf(currRewards, "fambo1", 0, ";") > 0 && this.clientFighter.name.equalsIgnoreCase("boss1") || StringList.indexOf(currRewards, "fambo2", 0, ";") > 0 && this.clientFighter.name.equalsIgnoreCase("boss2") || StringList.indexOf(currRewards, "fambo3", 0, ";") > 0 && this.clientFighter.name.equalsIgnoreCase("boss3") || this.clientFighter.life < 6000)) {
            this.claim1.clearActions();
            RepeatAction shout1 = new RepeatAction();
            shout1.setAction(Actions.sequence((Action)Actions.scaleTo(0.95f, 0.95f, 1.0f), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f)));
            shout1.setCount(-1);
            this.claim1.addAction(shout1);
            this.claim1.setVisible(true);
            this.claim1label.clearActions();
            RepeatAction shout1l = new RepeatAction();
            shout1l.setAction(Actions.sequence((Action)Actions.scaleTo(0.95f, 0.95f, 1.0f), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f)));
            shout1l.setCount(-1);
            this.claim1label.addAction(shout1l);
            this.claim1label.setVisible(true);
            this.claim2.clearActions();
            RepeatAction shout2 = new RepeatAction();
            shout2.setAction(Actions.sequence((Action)Actions.scaleTo(0.95f, 0.95f, 1.0f), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f)));
            shout2.setCount(-1);
            this.claim2.addAction(shout2);
            this.claim2.setVisible(true);
            this.claim2label.clearActions();
            RepeatAction shout2l = new RepeatAction();
            shout2l.setAction(Actions.sequence((Action)Actions.scaleTo(0.95f, 0.95f, 1.0f), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f)));
            shout2l.setCount(-1);
            this.claim2label.addAction(shout2l);
            this.claim2label.setVisible(true);
        }
        if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.contains("boss") && (StringList.indexOf(currRewards, "fambo1", 0, ";") > 0 && this.clientFighter.name.equalsIgnoreCase("boss1") || StringList.indexOf(currRewards, "fambo2", 0, ";") > 0 && this.clientFighter.name.equalsIgnoreCase("boss2") || StringList.indexOf(currRewards, "fambo3", 0, ";") > 0 && this.clientFighter.name.equalsIgnoreCase("boss3") || this.clientFighter.life < 3000)) {
            this.claim3.clearActions();
            RepeatAction shout3 = new RepeatAction();
            shout3.setAction(Actions.sequence((Action)Actions.scaleTo(0.95f, 0.95f, 1.0f), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f)));
            shout3.setCount(-1);
            this.claim3.addAction(shout3);
            this.claim3.setVisible(true);
            this.claim3label.clearActions();
            RepeatAction shout3l = new RepeatAction();
            shout3l.setAction(Actions.sequence((Action)Actions.scaleTo(0.95f, 0.95f, 1.0f), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f)));
            shout3l.setCount(-1);
            this.claim3label.addAction(shout3l);
            this.claim3label.setVisible(true);
            this.claim4.clearActions();
            RepeatAction shout4 = new RepeatAction();
            shout4.setAction(Actions.sequence((Action)Actions.scaleTo(0.95f, 0.95f, 1.0f), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f)));
            shout4.setCount(-1);
            this.claim4.addAction(shout4);
            this.claim4.setVisible(true);
            this.claim4label.clearActions();
            RepeatAction shout4l = new RepeatAction();
            shout4l.setAction(Actions.sequence((Action)Actions.scaleTo(0.95f, 0.95f, 1.0f), (Action)Actions.scaleTo(1.0f, 1.0f, 1.0f)));
            shout4l.setCount(-1);
            this.claim4label.addAction(shout4l);
            this.claim4label.setVisible(true);
        }
    }

    private void showSentence(String textSentence) {
        if (this.stunScreen.isVisible()) {
            String[] sentenceParts = textSentence.split(" ");
            StringBuilder dazeSentence = new StringBuilder();
            for (String currPart : sentenceParts) {
                if (MathUtils.randomBoolean()) {
                    char[] noiseArray = new char[2 + MathUtils.random(4)];
                    Arrays.fill(noiseArray, '.');
                    dazeSentence.append("*");
                    dazeSentence.append(noiseArray);
                    dazeSentence.append("*");
                } else {
                    dazeSentence.append(currPart);
                }
                dazeSentence.append(" ");
            }
            textSentence = dazeSentence.toString().trim();
        }
        this.talkSentence.setText(textSentence);
        this.talkSentence.setVisible(true);
        this.talkSentence.layout();
        this.talkBackground.setHeight(this.talkSentence.getPrefHeight() + UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.talkBackground.setY(UIHelpers.calcHeightProportion(this.game, 80.0f, 75.0f).floatValue() - this.talkBackground.getHeight());
        this.talkDirection.setVisible(true);
        this.talkBackground.setVisible(true);
    }

    private void generateEvent(String type, String option, int deviation, Fighter actingFighter) {
        Logger.write(Logger.DEBUG, "CombatScreen.generateEvent type " + type + ", option " + option + ", deviation " + deviation + ", actingIsHost " + (actingFighter == this.hostFighter));
        if (!this.paused.booleanValue() && !this.end.booleanValue()) {
            if (this.game.gameMode.equalsIgnoreCase("story") && this.clientFighter.name.contains("tutorial") && !this.tutorialPause.booleanValue() && (CombatEngine.combatState.stage.equalsIgnoreCase("") || CombatEngine.combatState.stage.equalsIgnoreCase("start") || CombatEngine.combatState.stage.equalsIgnoreCase("attack") || CombatEngine.combatState.stage.equalsIgnoreCase("chain") || CombatEngine.combatState.stage.equalsIgnoreCase("risposte"))) {
                this.checkTutorialStep(type, option, deviation, actingFighter);
            } else {
                this.drawCombatStatus(CombatEngine.applyCombatEvent(type, option, deviation, actingFighter, actingFighter == this.hostFighter ? this.clientFighter : this.hostFighter, this.combatTime));
            }
        }
    }

    private void checkEnding() {
        if (this.game.gameMode.equalsIgnoreCase("story") || this.game.gameMode.equalsIgnoreCase("tournament")) {
            String rewardText;
            String string = rewardText = this.game.gameMode.equalsIgnoreCase("story") ? Story.checkRewardText(this.game, (float)this.hostFighter.life / (float)this.initialLife, this.timeLimitTime) : Tournament.addCombatReward(this.game, this.hostFighter.life, this.initialLife, this.timeLimitTime);
            if (this.hostFighter.life > 0 && !rewardText.equalsIgnoreCase("")) {
                SequenceAction showReplay1 = Actions.sequence((Action)Actions.delay(2.5f), (Action)Actions.show());
                this.rewardBackground.addAction(showReplay1);
                this.rewardLabel.setText(this.rewardLabel.getText().append(rewardText));
                UIHelpers.fixLabelFontSize(this.rewardLabel, this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f), 0.0f, this.rewardBackground.getHeight() * 3.0f / 4.0f);
                this.rewardLabel.setHeight(this.rewardLabel.getPrefHeight());
                this.rewardLabel.layout();
                this.rewardLabel.setY(this.rewardBackground.getY() + this.rewardBackground.getHeight() * 95.0f / 100.0f - this.rewardLabel.getPrefHeight());
                SequenceAction showReplay2 = Actions.sequence((Action)Actions.delay(2.5f), (Action)Actions.show());
                this.rewardLabel.addAction(showReplay2);
                SequenceAction showReplay3 = Actions.sequence((Action)Actions.delay(2.5f), (Action)Actions.show());
                this.rewardButton.addAction(showReplay3);
            }
            this.replayButton.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.combat.endcombat"));
            this.replayButton.setWidth(this.replayButton.getPrefWidth());
            this.replayButton.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.replayButton.getWidth() / 2.0f);
            this.replayButton.setY(UIHelpers.calcHeightProportion(this.game, 46.25f, 46.25f).floatValue() - this.replayButton.getHeight() / 2.0f);
            if (this.game.gameMode.equalsIgnoreCase("story")) {
                if (this.game.saveGame.get("phase").equalsIgnoreCase("pits")) {
                    this.profits = this.profits + (this.hostFighter.maxLife - this.hostFighter.life) / 66 + (this.clientFighter.maxLife - this.clientFighter.life) / 132;
                } else if (this.game.saveGame.get("phase").equalsIgnoreCase("caravan")) {
                    this.profits = this.profits + (this.hostFighter.maxLife - this.hostFighter.life) / 66 + (this.clientFighter.maxLife - this.clientFighter.life) / 132;
                } else if (this.game.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
                    this.profits = this.profits + this.hostFighter.life / 100 + (this.clientFighter.maxLife - this.clientFighter.life) / 132;
                }
                Story.advancePlayer(this.game, this.hostFighter.life, this.initialLife, this.timeLimitTime, this.profits, this.clientFighter.name);
            } else {
                Tournament.advancePlayer(this.game, this.hostFighter.life, this.initialLife, this.clientFighter.name);
            }
        }
        SequenceAction showReplay1 = Actions.sequence((Action)Actions.delay(2.5f), (Action)Actions.show());
        this.replayButton.addAction(showReplay1);
        SequenceAction showReplay2 = Actions.sequence((Action)Actions.delay(2.5f), (Action)Actions.show());
        this.endSplash.addAction(showReplay2);
        SequenceAction showReplay3 = Actions.sequence((Action)Actions.delay(2.5f), (Action)Actions.show());
        this.endLabel.addAction(showReplay3);
        this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("end") + ".ogg"), Sound.class).play(this.game.soundVolume);
    }

    private void doEnding() {
        this.game.manager.get(this.game.getOverridenFilename("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(this.arena)).getString("crowd") + ".ogg"), Sound.class).stop();
        if (this.game.gameMode.equalsIgnoreCase("story")) {
            Story.getNextScreen(this.game, "fight", "");
            this.dispose();
        } else if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            Tournament.getNextScreen(this.game, "fight", "");
            this.dispose();
        } else {
            this.game.duelSetupScreen = new DuelSetupScreen(this.game, this.reputation, this.difficulty, Fighter.clone(this.hostFighter, false), Fighter.clone(this.clientFighter, false));
            this.game.setScreen(this.game.duelSetupScreen);
            this.game.networkPort.sendData("0_r_h");
            this.dispose();
        }
    }

    public void initTutorial() {
        this.tutorialSteps = new HashMap();
        ArrayList<String> steps = new ArrayList<String>();
        steps.add("attack_right_50_c");
        steps.add("check_dodge_right_1");
        this.tutorialSteps.put(1, steps);
        steps = new ArrayList();
        steps.add("idle_xxx_0");
        steps.add("attack_left_50_c");
        steps.add("check_parry_right_2");
        this.tutorialSteps.put(2, steps);
        steps = new ArrayList();
        steps.add("check_attack_xxx_2");
        steps.add("idle_xxx_0");
        this.tutorialSteps.put(3, steps);
        steps = new ArrayList();
        steps.add("idle_xxx_0");
        steps.add("attack_right_50_c");
        steps.add("check_defense_right_4");
        steps.add("idle_xxx_0");
        steps.add("attack_left_50_c");
        steps.add("check_defense_left_4");
        steps.add("idle_xxx_0");
        steps.add("attack_middle_50_c");
        steps.add("check_defense_middle_4");
        this.tutorialSteps.put(4, steps);
        steps = new ArrayList();
        steps.add("check_attackgood_xxx_4");
        steps.add("idle_xxx_0");
        this.tutorialSteps.put(5, steps);
        this.currTutorialStep = 1;
        this.currTutorialSubstep = 0;
        this.tutorialFail = false;
        this.overlayTutorial = new BaseActor();
        this.overlayTutorial.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/overlay.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
        this.overlayTutorial.setColor(0.0f, 0.0f, 0.0f, 0.7f);
        this.overlayTutorial.setPosition(0.0f, 0.0f);
        this.overlayTutorial.setVisible(false);
        this.stage.addActor(this.overlayTutorial);
        this.tutorialPC = new Label("", this.game.uiSkin, "default");
        this.tutorialPC.setColor(this.game.uiSkin.get("silver", Color.class));
        this.tutorialPC.setFontScale(this.game.viewHeight.floatValue() / this.game.viewHeightMAX.floatValue());
        this.tutorialPC.setAlignment(1);
        this.tutorialPC.setWrap(true);
        this.tutorialPC.setWidth(UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue());
        this.tutorialPC.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.tutorialPC.getWidth() / 2.0f);
        this.tutorialPC.setY(UIHelpers.calcHeightProportion(this.game, 80.0f, 80.0f).floatValue());
        this.tutorialPC.setVisible(false);
        this.stage.addActor(this.tutorialPC);
        this.tutorialMasterFail = new Label("", this.game.uiSkin, "combat");
        this.tutorialMasterFail.setFontScale(this.game.viewHeight.floatValue() / this.game.viewHeightMAX.floatValue());
        this.tutorialMasterFail.setColor(this.game.uiSkin.getColor("white"));
        this.tutorialMasterFail.setAlignment(1);
        this.tutorialMasterFail.setWrap(true);
        this.tutorialMasterFail.setWidth(UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue());
        this.tutorialMasterFail.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.tutorialMasterFail.getWidth() / 2.0f);
        this.tutorialMasterFail.setY(UIHelpers.calcHeightProportion(this.game, 70.0f, 70.0f).floatValue());
        this.tutorialMasterFail.setVisible(false);
        this.stage.addActor(this.tutorialMasterFail);
        this.tutorialFlavor = new Label("", this.game.uiSkin, "combat");
        this.tutorialFlavor.setFontScale(this.game.viewHeight.floatValue() / this.game.viewHeightMAX.floatValue());
        this.tutorialFlavor.setColor(this.game.uiSkin.getColor("white"));
        this.tutorialFlavor.setAlignment(1);
        this.tutorialFlavor.setWrap(true);
        this.tutorialFlavor.setWidth(UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue());
        this.tutorialFlavor.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.tutorialFlavor.getWidth() / 2.0f);
        this.tutorialFlavor.setY(UIHelpers.calcHeightProportion(this.game, 70.0f, 70.0f).floatValue());
        this.tutorialFlavor.setVisible(false);
        this.stage.addActor(this.tutorialFlavor);
        this.tutorialInfo = new Label("", this.game.uiSkin, "default");
        this.tutorialInfo.setFontScale(this.game.viewHeight.floatValue() / this.game.viewHeightMAX.floatValue());
        this.tutorialInfo.setColor(this.game.uiSkin.getColor("white"));
        this.tutorialInfo.setAlignment(1);
        this.tutorialInfo.setWrap(true);
        this.tutorialInfo.setWidth(UIHelpers.calcWidthProportion(this.game, 50.0f, 80.0f).floatValue());
        this.tutorialInfo.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.tutorialInfo.getWidth() / 2.0f);
        this.tutorialInfo.setY(UIHelpers.calcHeightProportion(this.game, 30.0f, 30.0f).floatValue());
        this.tutorialInfo.setVisible(false);
        this.stage.addActor(this.tutorialInfo);
        this.nextButton = new Button(this.game.uiSkin, "next");
        this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.nextButton.setHeight(this.nextButton.getWidth());
        this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
        this.nextButton.setY(10.0f);
        this.nextButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                CombatScreen.this.overlay.setColor(0.0f, 0.0f, 0.0f, 0.0f);
                CombatScreen.this.overlayTutorial.setVisible(false);
                CombatScreen.this.overlay.setVisible(false);
                CombatScreen.this.tutorialFlavor.setVisible(false);
                CombatScreen.this.tutorialInfo.setVisible(false);
                CombatScreen.this.nextButton.setVisible(false);
                CombatScreen.this.tutorialPause = false;
            }
        });
        this.nextButton.setVisible(false);
        this.stage.addActor(this.nextButton);
        this.tutorialPause = true;
        this.tutorialElapsedTime = 0L;
    }

    public void showTutorialInfo(int option) {
        this.overlay.clearActions();
        this.overlay.setVisible(false);
        this.overlayTutorial.setVisible(true);
        if (option == 1) {
            this.tutorialPC.setText(this.game.gameMessages.getProperty("tutorial.0"));
            SequenceAction delay2 = Actions.sequence((Action)Actions.show(), (Action)Actions.delay(3.0f), (Action)Actions.hide());
            this.tutorialPC.addAction(delay2);
        } else if (option == 2) {
            this.tutorialPC.setText(this.game.gameMessages.getProperty("tutorial.fail.1"));
            SequenceAction delay3 = Actions.sequence((Action)Actions.show(), (Action)Actions.delay(3.0f), (Action)Actions.hide());
            this.tutorialPC.addAction(delay3);
            this.tutorialMasterFail.setText(this.game.gameMessages.getProperty("tutorial.fail.2"));
            SequenceAction delay4 = Actions.sequence((Action)Actions.show(), (Action)Actions.delay(3.0f), (Action)Actions.hide());
            this.tutorialMasterFail.addAction(delay4);
            this.tutorialFail = false;
        }
        this.tutorialFlavor.setText(this.game.gameMessages.getProperty("tutorial.flavor." + this.currTutorialStep));
        this.tutorialInfo.setText(this.game.gameMessages.getProperty("tutorial.info." + this.currTutorialStep));
        SequenceAction delay5 = Actions.sequence((Action)Actions.delay(option == 0 ? 1.0f : 3.0f), (Action)Actions.show());
        this.tutorialFlavor.addAction(delay5);
        SequenceAction delay6 = Actions.sequence((Action)Actions.delay(option == 0 ? 1.0f : 3.0f), (Action)Actions.show());
        this.tutorialInfo.addAction(delay6);
        SequenceAction delay7 = Actions.sequence((Action)Actions.delay(option == 0 ? 1.0f : 3.0f), (Action)Actions.show());
        this.nextButton.addAction(delay7);
    }

    public void checkTutorialStep(String type, String option, int deviation, Fighter actingFighter) {
        String[] currStep = this.getTutorialStep(false, 0).split("_");
        if (currStep[0].equalsIgnoreCase("check") && actingFighter == this.hostFighter) {
            if (currStep[1].equalsIgnoreCase(type) && currStep[2].equalsIgnoreCase(option) || currStep[1].equalsIgnoreCase("defense") && (type.equalsIgnoreCase("dodge") && (currStep[2].equalsIgnoreCase(option) || CombatEngine.combatState.direction.equalsIgnoreCase("middle")) || type.equalsIgnoreCase("parry") && (!currStep[2].equalsIgnoreCase(option) || option.equalsIgnoreCase("middle"))) || currStep[1].equalsIgnoreCase("attack") && type.equalsIgnoreCase("attack") || currStep[1].equalsIgnoreCase("attackgood") && type.equalsIgnoreCase("attack") && deviation <= 10) {
                this.getTutorialStep(true, 0);
                if (this.tutorialSteps.get(this.currTutorialStep) != null && this.currTutorialSubstep == 0) {
                    this.tutorialPause = true;
                }
                this.drawCombatStatus(CombatEngine.applyCombatEvent(type, option, deviation, this.hostFighter, this.clientFighter, this.combatTime));
            } else {
                this.tutorialPause = true;
                this.tutorialFail = true;
                if (this.currTutorialStep == 1) {
                    this.getTutorialStep(false, Integer.parseInt(currStep[3]));
                    this.drawCombatStatus(CombatEngine.applyCombatEvent("idle", "xxx", 0, this.hostFighter, this.clientFighter, this.combatTime));
                } else {
                    currStep = this.getTutorialStep(false, Integer.parseInt(currStep[3])).split("_");
                    this.drawCombatStatus(CombatEngine.applyCombatEvent(currStep[0], currStep[1], Integer.parseInt(currStep[2]), this.hostFighter, this.clientFighter, this.combatTime));
                    this.getTutorialStep(true, 0);
                }
            }
        } else {
            this.getTutorialStep(true, 0);
            this.drawCombatStatus(CombatEngine.applyCombatEvent(currStep[0], currStep[1], Integer.parseInt(currStep[2]), actingFighter == this.hostFighter ? this.hostFighter : this.clientFighter, actingFighter == this.hostFighter ? this.clientFighter : this.hostFighter, this.combatTime));
            if (this.tutorialSteps.get(this.currTutorialStep) != null && this.currTutorialSubstep == 0) {
                this.tutorialPause = true;
            }
        }
    }

    public String getTutorialStep(boolean advance, int reset) {
        if (this.tutorialSteps.get(this.currTutorialStep) == null) {
            return "end";
        }
        if (advance) {
            if (this.currTutorialSubstep == this.tutorialSteps.get(this.currTutorialStep).size() - 1) {
                ++this.currTutorialStep;
                this.currTutorialSubstep = 0;
            } else {
                ++this.currTutorialSubstep;
            }
        } else if (reset > 0) {
            this.currTutorialSubstep = 0;
            this.currTutorialStep = reset;
            CombatEngine.combatState.assaultPressure = 0;
            CombatEngine.combatState.timePressure = Float.valueOf(1.0f);
        }
        if (this.tutorialSteps.get(this.currTutorialStep) == null) {
            return "end";
        }
        return this.tutorialSteps.get(this.currTutorialStep).get(this.currTutorialSubstep);
    }

    public void showBossStep(int option) {
        this.overlay.clearActions();
        this.overlay.setVisible(true);
        this.tutorialPause = true;
        if (option == 11) {
            this.game.manager.get(this.game.getOverridenFilename("sound/whipcrack.ogg"), Sound.class).play(this.game.soundVolume);
            this.talkTime = this.combatTime + 5000L;
            this.showSentence(PropertiesReader.getMessage(this.game.gameMessages, "talk.boss1.1", this.game.violenceFilter, "##:" + new Color(this.game.uiSkin.get("lightgrey", Color.class)).mul(0.9f).toString()));
            this.bossActor1.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/espdogidle.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
            this.bossActor1.params.put("type", "dogidle");
            this.bossActor1.setX(this.clientXinit);
            this.bossActor1.setY(this.clientYinit);
            this.bossActor1.clearActions();
            Color origColor = new Color(this.bossActor1.getColor());
            this.bossActor1.setColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.bossActor1.setVisible(true);
            SequenceAction appear1 = Actions.sequence((Action)Actions.delay(2.0f), (Action)Actions.color(new Color(0.0f, 0.0f, 0.0f, 1.0f), 1.0f), (Action)Actions.color(origColor, 2.0f));
            this.bossActor1.addAction(appear1);
            this.tutorialElapsedTime = this.combatTime + 5000L;
            this.clientCharacter.clearActions();
            this.hostCharacter.clearActions();
            this.clientCharacter.addAction(Actions.moveTo(this.clientXinit, this.clientYinit, 0.1f));
            this.hostCharacter.addAction(Actions.moveTo(this.hostXinit, this.hostYinit, 0.1f));
            this.drawEnemyFighter("idle", "", 0.0f, 0.0f, false);
            this.drawPCFighter("idle", "", 0.0f, 0.0f, false);
        } else if (option == 12) {
            Color origColor;
            this.game.manager.get(this.game.getOverridenFilename("sound/whipcrack.ogg"), Sound.class).play(this.game.soundVolume);
            this.talkTime = this.combatTime + 5000L;
            this.showSentence(PropertiesReader.getMessage(this.game.gameMessages, "talk.boss1.1", this.game.violenceFilter, "##:" + new Color(this.game.uiSkin.get("lightgrey", Color.class)).mul(0.9f).toString()));
            if (!this.bossActor1.isVisible()) {
                this.bossActor1.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/espdogidle.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
                this.bossActor1.params.put("type", "dogidle");
                this.bossActor1.setX(this.clientXinit);
                this.bossActor1.setY(this.clientYinit);
                origColor = new Color(this.bossActor1.getColor());
                this.bossActor1.setColor(0.0f, 0.0f, 0.0f, 0.0f);
                this.bossActor1.setVisible(true);
                SequenceAction appear1 = Actions.sequence((Action)Actions.delay(2.0f), (Action)Actions.color(new Color(0.0f, 0.0f, 0.0f, 1.0f), 1.0f), (Action)Actions.color(origColor, 2.0f));
                this.bossActor1.addAction(appear1);
            }
            this.bossActor2.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/espdogidle.png"), Texture.class), this.clientSizeinit, this.clientSizeinit);
            this.bossActor2.setX(this.clientXinit);
            this.bossActor2.setY(this.clientYinit);
            this.bossActor2.flip = true;
            origColor = new Color(this.bossActor2.getColor());
            this.bossActor2.setColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.bossActor2.setVisible(true);
            SequenceAction appear2 = Actions.sequence((Action)Actions.delay(2.0f), (Action)Actions.color(new Color(0.0f, 0.0f, 0.0f, 1.0f), 1.0f), (Action)Actions.color(origColor, 2.0f));
            this.bossActor2.addAction(appear2);
            this.tutorialElapsedTime = this.combatTime + 5000L;
            this.clientCharacter.clearActions();
            this.hostCharacter.clearActions();
            this.clientCharacter.addAction(Actions.moveTo(this.clientXinit, this.clientYinit, 0.1f));
            this.hostCharacter.addAction(Actions.moveTo(this.hostXinit, this.hostYinit, 0.1f));
            this.drawEnemyFighter("idle", "", 0.0f, 0.0f, false);
            this.drawPCFighter("idle", "", 0.0f, 0.0f, false);
        } else if (option == 21) {
            this.game.manager.get(this.game.getOverridenFilename("sound/lightcrackle.ogg"), Sound.class).play(this.game.soundVolume);
            this.talkTime = this.combatTime + 2000L;
            this.showSentence(PropertiesReader.getMessage(this.game.gameMessages, "talk.boss2.1", this.game.violenceFilter, "##:" + new Color(this.game.uiSkin.get("lightgrey", Color.class)).mul(0.9f).toString()));
            this.drawEnemyFighter("middle", "", this.clientXinit, this.clientYinit, false);
            this.clientCharacter.clearActions();
            this.bossActor1.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/esplightcharge.png"), Texture.class), this.clientSizeinit * Float.parseFloat(this.clientFighter.size), this.clientSizeinit * Float.parseFloat(this.clientFighter.size));
            this.bossActor1.setX(this.clientCharacter.getX());
            this.bossActor1.setY(this.clientCharacter.getY());
            this.bossActor1.flip = false;
            this.bossActor2.flip = false;
            this.bossActor1.params.put("type", "lightcharge");
            this.bossActor1.clearActions();
            SequenceAction appear = Actions.sequence((Action)Actions.alpha(1.0f), (Action)Actions.show(), (Action)Actions.delay(2.0f), (Action)Actions.hide());
            this.bossActor1.addAction(appear);
            this.tutorialElapsedTime = this.combatTime + 2000L;
            this.hostCharacter.clearActions();
            this.hostCharacter.addAction(Actions.moveTo(this.hostXinit, this.hostYinit, 0.1f));
            this.drawPCFighter("idle", "", 0.0f, 0.0f, false);
        } else if (option >= 30 && option <= 32) {
            CombatEngine.addDebuff(this.hostFighter, "poison", "poison1", 600000L, this.combatTime, CombatEngine.combatState.hostLog, false);
            this.talkTime = this.combatTime + 2000L;
            this.showSentence(PropertiesReader.getMessage(this.game.gameMessages, "talk.boss3." + option, this.game.violenceFilter, "##:" + new Color(this.game.uiSkin.get("lightgrey", Color.class)).mul(0.9f).toString()));
            this.drawEnemyFighter("idle", "", this.clientXinit, this.clientYinit, false);
            this.clientCharacter.clearActions();
            this.tutorialElapsedTime = this.combatTime + 2000L;
            this.hostCharacter.clearActions();
            this.hostCharacter.addAction(Actions.moveTo(this.hostXinit, this.hostYinit, 0.1f));
            this.drawPCFighter("idle", "", 0.0f, 0.0f, false);
        } else if (option >= 40 && option <= 42) {
            this.game.manager.get(this.game.getOverridenFilename("sound/smoke.ogg"), Sound.class).play(this.game.soundVolume);
            this.talkTime = this.combatTime + 5000L;
            this.showSentence(PropertiesReader.getMessage(this.game.gameMessages, "talk.boss3." + option, this.game.violenceFilter, "##:" + new Color(this.game.uiSkin.get("lightgrey", Color.class)).mul(0.9f).toString()));
            this.drawEnemyFighter("idle", "", this.clientXinit, this.clientYinit, false);
            this.clientCharacter.clearActions();
            this.bossActor2.flip = MathUtils.randomBoolean();
            this.bossActor1.clearActions();
            SequenceAction appear = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(1.0f), Actions.alpha(1.0f, 1.0f), Actions.alpha(0.0f, 2.0f), Actions.hide());
            this.bossActor1.addAction(appear);
            this.bossActor2.clearActions();
            SequenceAction hit = Actions.sequence(Actions.alpha(0.0f), Actions.show(), Actions.delay(1.5f), Actions.alpha(1.0f, 0.5f), Actions.alpha(0.0f, 1.0f), Actions.hide());
            this.bossActor2.addAction(hit);
            SequenceAction scaleHideDelay = Actions.sequence((Action)Actions.delay(1.5f), (Action)Actions.show(), (Action)Actions.scaleTo(2.0f, 2.0f, 1.0f), (Action)Actions.hide(), (Action)Actions.scaleTo(0.5f, 0.5f));
            this.combatShardEffect.addAction(scaleHideDelay);
            this.tutorialElapsedTime = this.combatTime + 5000L;
            this.hostCharacter.clearActions();
            this.hostCharacter.addAction(Actions.moveTo(this.hostXinit, this.hostYinit, 0.1f));
            this.drawPCFighter("idle", "", 0.0f, 0.0f, false);
        }
    }

    public boolean checkBossStep() {
        if (this.clientFighter.name.equalsIgnoreCase("boss1")) {
            if (!this.bossActor1.isVisible() && this.clientFighter.life < 6000) {
                this.showBossStep(11);
                return true;
            }
            if (!this.bossActor2.isVisible() && this.clientFighter.life < 3000) {
                this.showBossStep(12);
                return true;
            }
        } else if (this.clientFighter.name.equalsIgnoreCase("boss2")) {
            if (this.clientAI.itemInterval <= 0 && CombatEngine.combatState.clientBossSpecial.equalsIgnoreCase("")) {
                CombatEngine.combatState.clientBossSpecial = "lightcharge";
                this.showBossStep(21);
                return true;
            }
        } else if (this.clientFighter.name.equalsIgnoreCase("boss3") && this.game.gameMode.equalsIgnoreCase("story")) {
            if (((String)this.bossActor1.params.get("stage")).equalsIgnoreCase("0")) {
                this.bossActor1.params.put("stage", "1");
                this.showBossStep(this.game.saveGame.get("rewards").contains("warbos") ? 40 : 30);
                return true;
            }
            if (!((String)this.bossActor1.params.get("stage")).equalsIgnoreCase("3") && this.clientFighter.life < 3000) {
                this.bossActor1.params.put("stage", "3");
                this.showBossStep((this.game.saveGame.get("rewards").contains("warbos") ? 40 : 30) + 2);
                return true;
            }
            if (((String)this.bossActor1.params.get("stage")).equalsIgnoreCase("1") && this.clientFighter.life < 6000) {
                this.bossActor1.params.put("stage", "2");
                this.showBossStep((this.game.saveGame.get("rewards").contains("warbos") ? 40 : 30) + 1);
                return true;
            }
        }
        return false;
    }

    public void checkExceptionalEvent() {
        if (!CombatEngine.combatState.clientExceptionalEvent.equalsIgnoreCase("")) {
            this.talkTime = this.combatTime + 2000L;
            this.showSentence(PropertiesReader.getMessage(this.game.gameMessages, "talk.effect." + CombatEngine.combatState.clientExceptionalEvent, this.game.violenceFilter, "##:" + new Color(this.game.uiSkin.get("lightgrey", Color.class)).mul(0.9f).toString()));
            CombatEngine.combatState.clientExceptionalEvent = "";
        }
    }

    public void executeMessage(StringBuilder message) {
        if (StringList.get(message, 1, "&").equalsIgnoreCase("s")) {
            CombatEngine.combatState.lastCombatEvent = StringList.remove(StringList.remove(message, 0, "&"), 0, "&").toString();
            this.drawCombatStatus(CombatEngine.combatState.lastCombatEvent);
        } else {
            for (int i = 1; i < StringList.size(message, "&"); ++i) {
                String currTerm = StringList.get(message, i, "&");
                if (currTerm.startsWith("hli")) {
                    CombatEngine.combatState.clientFighter.life = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("hst")) {
                    CombatEngine.combatState.clientFighter.stamina = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("hba")) {
                    CombatEngine.combatState.clientFighter.balance = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("hsu")) {
                    CombatEngine.combatState.clientFighter.surge = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("cli")) {
                    CombatEngine.combatState.hostFighter.life = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("cst")) {
                    CombatEngine.combatState.hostFighter.stamina = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("cba")) {
                    CombatEngine.combatState.hostFighter.balance = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("csu")) {
                    CombatEngine.combatState.hostFighter.surge = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("sta")) {
                    CombatEngine.combatState.stage = currTerm.substring(3);
                    continue;
                }
                if (currTerm.startsWith("ata")) {
                    CombatEngine.combatState.attacker = currTerm.substring(3).equalsIgnoreCase("host") ? "client" : "host";
                    continue;
                }
                if (currTerm.startsWith("def")) {
                    CombatEngine.combatState.defender = currTerm.substring(3).equalsIgnoreCase("host") ? "client" : "host";
                    continue;
                }
                if (currTerm.startsWith("ran")) {
                    CombatEngine.combatState.randomNumber = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("dir")) {
                    CombatEngine.combatState.direction = currTerm.substring(3);
                    continue;
                }
                if (currTerm.startsWith("vdi")) {
                    CombatEngine.combatState.vulnerableDirection = currTerm.substring(3);
                    continue;
                }
                if (currTerm.startsWith("tpr")) {
                    CombatEngine.combatState.timePressure = Float.valueOf(Float.parseFloat(currTerm.substring(3)));
                    continue;
                }
                if (currTerm.startsWith("asf")) {
                    CombatEngine.combatState.assaultFighter = currTerm.substring(3);
                    continue;
                }
                if (currTerm.startsWith("asp")) {
                    CombatEngine.combatState.assaultPressure = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("hch")) {
                    CombatEngine.combatState.hostComboHappenning = currTerm.substring(3);
                    continue;
                }
                if (currTerm.startsWith("cch")) {
                    CombatEngine.combatState.clientComboHappenning = currTerm.substring(3);
                    continue;
                }
                if (currTerm.startsWith("hse")) {
                    CombatEngine.combatState.clientSurgeType = currTerm.substring(3);
                    continue;
                }
                if (currTerm.startsWith("cse")) {
                    CombatEngine.combatState.hostSurgeType = currTerm.substring(3);
                    continue;
                }
                if (currTerm.startsWith("ius")) {
                    CombatEngine.combatState.isUse = Integer.parseInt(currTerm.substring(3)) == 1;
                    continue;
                }
                if (currTerm.startsWith("aso")) {
                    CombatEngine.combatState.soundsToPlay = StringList.append(CombatEngine.combatState.soundsToPlay, currTerm.substring(3), ",");
                    continue;
                }
                if (currTerm.startsWith("aef")) {
                    CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, currTerm.substring(3), ",");
                    continue;
                }
                if (currTerm.startsWith("ahi")) {
                    CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, currTerm.substring(3), ",");
                    continue;
                }
                if (currTerm.startsWith("ahl")) {
                    CombatEngine.combatState.hostLog = StringList.append(CombatEngine.combatState.hostLog, currTerm.substring(3), "#");
                    continue;
                }
                if (currTerm.startsWith("acl")) {
                    CombatEngine.combatState.clientLog = StringList.append(CombatEngine.combatState.clientLog, currTerm.substring(3), "#");
                    continue;
                }
                if (currTerm.startsWith("scl")) {
                    CombatEngine.combatState.scenarioLife = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("hdb")) {
                    CombatEngine.combatState.clientFighter.debuffs = StringList.create(currTerm.substring(3), ",");
                    continue;
                }
                if (currTerm.startsWith("hbu")) {
                    CombatEngine.combatState.clientFighter.buffs = StringList.create(currTerm.substring(3), ",");
                    continue;
                }
                if (currTerm.startsWith("hiu")) {
                    CombatEngine.combatState.clientFighter.itemUses = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (currTerm.startsWith("hcs")) {
                    CombatEngine.combatState.clientFighter.comboStage = currTerm.substring(3);
                    continue;
                }
                if (currTerm.startsWith("cdb")) {
                    CombatEngine.combatState.hostFighter.debuffs = StringList.create(currTerm.substring(3), ",");
                    continue;
                }
                if (currTerm.startsWith("cbu")) {
                    CombatEngine.combatState.hostFighter.buffs = StringList.create(currTerm.substring(3), ",");
                    continue;
                }
                if (currTerm.startsWith("ciu")) {
                    CombatEngine.combatState.hostFighter.itemUses = Integer.parseInt(currTerm.substring(3));
                    continue;
                }
                if (!currTerm.startsWith("ccs")) continue;
                CombatEngine.combatState.hostFighter.comboStage = currTerm.substring(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String data, boolean forceWait) {
        if (forceWait) {
            this.hostWait = true;
            this.clientWait = true;
        }
        if (this.game.gameMode.equalsIgnoreCase("client")) {
            String indexedContent = this.messageIndex + "_" + data.substring(0, data.length() - 2) + "_c";
            Logger.write(Logger.DEBUG, "CombatScreen.sendMessage sending CLIENT message " + indexedContent);
            ++this.messageIndex;
            this.game.networkPort.sendData(indexedContent);
            this.game.networkPort.sendData(indexedContent);
            this.game.networkPort.sendData(indexedContent);
        } else {
            LinkedList<StringBuilder> linkedList = this.messagesToExecute;
            synchronized (linkedList) {
                this.messagesToExecute.addLast(new StringBuilder("0_" + data));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(String indexedContent) {
        StringBuilder parsedMessage = StringList.create(indexedContent, "$");
        LinkedList<StringBuilder> linkedList = this.messagesToExecute;
        synchronized (linkedList) {
            for (int i = 0; i < StringList.size(parsedMessage, "$"); ++i) {
                StringBuilder currMessage = StringList.create(StringList.get(parsedMessage, i, "$"), "&");
                if (this.messageHistory.contains(currMessage.toString())) continue;
                this.messageHistory.addLast(currMessage.toString());
                if (this.messageHistory.size() > 5) {
                    this.messageHistory.poll();
                }
                this.messagesToExecute.addLast(currMessage);
            }
        }
    }

    @Override
    public void receivedPacket(String indexedContent) {
        StringBuilder parsedMessage = StringList.create(indexedContent, "_");
        String messageType = StringList.get(parsedMessage, 1, "_");
        if (messageType.equalsIgnoreCase("d")) {
            this.receivedDisconnect = true;
        } else if (messageType.equalsIgnoreCase("r")) {
            this.receivedReplay = true;
        } else if (this.game.gameMode.equalsIgnoreCase("client")) {
            this.receiveMessage(indexedContent);
        } else {
            CombatServer.receiveMessage(indexedContent);
        }
    }
}

