/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.game;

import com.badlogic.gdx.math.MathUtils;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.game.Equipment;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.screen.ColiseumScreen;
import com.calimasaga.slavepits.screen.CombatScreen;
import com.calimasaga.slavepits.screen.LoreScreen;
import com.calimasaga.slavepits.screen.MessageScreen;
import com.calimasaga.slavepits.screen.PrepSetupScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import com.calimasaga.slavepits.util.StringList;
import java.util.ArrayList;

public class Story {
    public static void newGame(SlavePitsGame g) {
        g.saveGame.put("phase", "pits");
        g.saveGame.put("maxreputation", "0");
        g.saveGame.put("talents", "");
        g.saveGame.put("life", "10000");
        g.saveGame.put("profits", "0");
        g.saveGame.put("lost", "0");
        g.saveGame.put("lostDays", "0");
        g.saveGame.put("behavior", "");
        g.saveGame.remove("special");
        Story.generateChapter(g);
        g.saveGame.put("fight", "-1");
    }

    public static void generateChapter(SlavePitsGame g) {
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            ArrayList<String> listPairs = new ArrayList<String>();
            listPairs.add("min,2-scala,1;diego,1-boris,1");
            listPairs.add("min,1-scala,2;onur,2-zola,1");
            listPairs.add("min,1-scala,1;ayla,2-trent,2");
            listPairs.add("diego,1-boris,1;onur,2-zola,1");
            listPairs.add("diego,2-boris,2;ayla,1-trent,2");
            listPairs.add("onur,1-zola,2;ayla,2-trent,1");
            String plotCharacter = "emma";
            if (MathUtils.random(1) == 0) {
                plotCharacter = "adam";
            }
            String choosenPair = (String)listPairs.get(MathUtils.random(listPairs.size() - 1));
            int c1 = MathUtils.random(1);
            int c11 = MathUtils.random(1);
            int c21 = MathUtils.random(1);
            int a2 = MathUtils.random(1);
            ArrayList<String> listEvents = new ArrayList<String>();
            ArrayList<String> listOpponents = new ArrayList<String>();
            listOpponents.add("x");
            listEvents.add("alone1");
            listOpponents.add("x");
            listEvents.add(choosenPair.split(";")[c1].split("-")[c11].split(",")[0] + ".combo." + choosenPair.split(";")[c1].split("-")[c11].split(",")[1]);
            listOpponents.add(choosenPair.split(";")[c1].split("-")[(c11 + 1) % 2].split(",")[0]);
            listEvents.add(choosenPair.split(";")[(c1 + 1) % 2].split("-")[c21].split(",")[0] + ".combo." + choosenPair.split(";")[(c1 + 1) % 2].split("-")[c21].split(",")[1]);
            listOpponents.add(choosenPair.split(";")[(c1 + 1) % 2].split("-")[(c21 + 1) % 2].split(",")[0]);
            listEvents.add(plotCharacter + ".plot1");
            listOpponents.add("x");
            if (a2 == 0) {
                if (MathUtils.random(1) == 1) {
                    listEvents.add("alone2");
                } else {
                    listEvents.add("x");
                }
                listOpponents.add("x");
                listEvents.add(choosenPair.split(";")[c1].split("-")[(c11 + 1) % 2].split(",")[0] + ".combo." + choosenPair.split(";")[c1].split("-")[(c11 + 1) % 2].split(",")[1]);
                listOpponents.add(choosenPair.split(";")[c1].split("-")[c11].split(",")[0]);
            } else {
                listEvents.add(choosenPair.split(";")[c1].split("-")[(c11 + 1) % 2].split(",")[0] + ".combo." + choosenPair.split(";")[c1].split("-")[(c11 + 1) % 2].split(",")[1]);
                listOpponents.add(choosenPair.split(";")[c1].split("-")[c11].split(",")[0]);
                if (MathUtils.random(1) == 1) {
                    listEvents.add("alone2");
                } else {
                    listEvents.add("x");
                }
                listOpponents.add("x");
            }
            listEvents.add(choosenPair.split(";")[(c1 + 1) % 2].split("-")[(c21 + 1) % 2].split(",")[0] + ".combo." + choosenPair.split(";")[(c1 + 1) % 2].split("-")[(c21 + 1) % 2].split(",")[1]);
            listOpponents.add(choosenPair.split(";")[(c1 + 1) % 2].split("-")[c21].split(",")[0]);
            listEvents.add(plotCharacter + ".plot2");
            listOpponents.add("x");
            ArrayList<String> listExtraOpponents = new ArrayList<String>();
            if (listOpponents.indexOf("zola") < 0) {
                listExtraOpponents.add("zola");
            }
            if (listOpponents.indexOf("min") < 0) {
                listExtraOpponents.add("min");
            }
            if (listOpponents.indexOf("scala") < 0) {
                listExtraOpponents.add("scala");
            }
            if (listOpponents.indexOf("ayla") < 0) {
                listExtraOpponents.add("ayla");
            }
            if (listOpponents.indexOf("diego") < 0) {
                listExtraOpponents.add("diego");
            }
            if (listOpponents.indexOf("trent") < 0) {
                listExtraOpponents.add("trent");
            }
            if (listOpponents.indexOf("boris") < 0) {
                listExtraOpponents.add("boris");
            }
            if (listOpponents.indexOf("onur") < 0) {
                listExtraOpponents.add("onur");
            }
            if (plotCharacter.equalsIgnoreCase("emma")) {
                listExtraOpponents.add("adam");
            } else {
                listExtraOpponents.add("emma");
            }
            for (int i = 0; i < listOpponents.size(); ++i) {
                if (!((String)listOpponents.get(i)).equalsIgnoreCase("x")) continue;
                int opponentIndex = MathUtils.random(listExtraOpponents.size() - (i == 0 ? 2 : 1));
                listOpponents.set(i, (String)listExtraOpponents.get(opponentIndex));
                listExtraOpponents.remove(opponentIndex);
            }
            StringBuilder finalEvents = new StringBuilder();
            for (int i = 0; i < listEvents.size(); ++i) {
                finalEvents.append((String)listEvents.get(i)).append(",");
            }
            g.saveGame.put("events", finalEvents.substring(0, finalEvents.length() - 1));
            g.saveGame.put("rewards", "none;0;facwor:0;facjus:0");
            StringBuilder finalOpponents = new StringBuilder();
            for (int i = 0; i < listOpponents.size(); ++i) {
                finalOpponents.append((String)listOpponents.get(i)).append(",");
            }
            g.saveGame.put("opponents", finalOpponents.substring(0, finalOpponents.length() - 1));
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            g.saveGame.put("life", "10000");
            g.saveGame.put("profits", "100");
            g.saveGame.put("fight", "10");
            g.saveGame.put("lostDays", "" + (Integer.parseInt(g.saveGame.get("lostDays")) + 3));
            boolean taraLea = MathUtils.randomBoolean();
            ArrayList<String> listEvents = new ArrayList<String>();
            ArrayList<String> listOpponents = new ArrayList<String>();
            listEvents.add("none");
            listOpponents.add("boss1");
            listEvents.add("merchanttalkslaves");
            listOpponents.add(taraLea ? "tara" : "lea");
            listEvents.add("sit");
            listOpponents.add(taraLea ? "lea" : "tara");
            listEvents.add("x");
            listOpponents.add("x");
            listEvents.add("ambush");
            listOpponents.add("randombandit:p290");
            listEvents.add("x");
            listOpponents.add("x");
            listEvents.add("x");
            listOpponents.add("x");
            listEvents.add("merchanttalkcoliseum");
            listOpponents.add("ponte");
            listEvents.add("x");
            listOpponents.add("x");
            listEvents.add("x");
            listOpponents.add("x");
            StringBuilder finalEvents = new StringBuilder(g.saveGame.get("events") + ",");
            for (int i = 0; i < listEvents.size(); ++i) {
                finalEvents.append((String)listEvents.get(i)).append(",");
            }
            g.saveGame.put("events", finalEvents.substring(0, finalEvents.length() - 1));
            StringBuilder finalOpponents = new StringBuilder(g.saveGame.get("opponents") + ",");
            for (int i = 0; i < listOpponents.size(); ++i) {
                finalOpponents.append((String)listOpponents.get(i)).append(",");
            }
            g.saveGame.put("opponents", finalOpponents.substring(0, finalOpponents.length() - 1));
            StringBuilder newRewards = StringList.create("", ";");
            StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
            for (int j = 2; j < StringList.size(rewards, ";"); ++j) {
                String currReward = StringList.get(rewards, j, ";");
                if (!currReward.startsWith("fac") && !currReward.startsWith("dagger-fighting")) continue;
                newRewards = StringList.append(newRewards, currReward, ";");
            }
            g.saveGame.put("rewards", "none;0;" + newRewards.toString());
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            g.saveGame.put("life", "10000");
            g.saveGame.put("profits", "300");
            g.saveGame.put("fight", "20");
            g.saveGame.put("lostDays", "" + (Integer.parseInt(g.saveGame.get("lostDays")) + 5));
            StringBuilder houses = StringList.create("x#x#luntian#sarah#x#x#blaire#rishi#x#x#nattfrid#bastien", "#");
            StringBuilder culling = StringList.create("x#x#x", "#");
            int randomHouse = MathUtils.random(5);
            if (randomHouse == 0) {
                houses = StringList.set(houses, 0, "scala", "#");
                houses = StringList.set(houses, 1, "boris", "#");
                culling = StringList.set(culling, 0, "tara", "#");
            } else if (randomHouse == 1) {
                houses = StringList.set(houses, 0, "scala", "#");
                houses = StringList.set(houses, 1, "tara", "#");
                culling = StringList.set(culling, 0, "boris", "#");
            } else if (randomHouse == 2) {
                houses = StringList.set(houses, 0, "boris", "#");
                houses = StringList.set(houses, 1, "scala", "#");
                culling = StringList.set(culling, 0, "tara", "#");
            } else if (randomHouse == 3) {
                houses = StringList.set(houses, 0, "boris", "#");
                houses = StringList.set(houses, 1, "tara", "#");
                culling = StringList.set(culling, 0, "scala", "#");
            } else if (randomHouse == 4) {
                houses = StringList.set(houses, 0, "tara", "#");
                houses = StringList.set(houses, 1, "scala", "#");
                culling = StringList.set(culling, 0, "boris", "#");
            } else {
                houses = StringList.set(houses, 0, "tara", "#");
                houses = StringList.set(houses, 1, "boris", "#");
                culling = StringList.set(culling, 0, "scala", "#");
            }
            randomHouse = MathUtils.random(5);
            if (randomHouse == 0) {
                houses = StringList.set(houses, 4, "zola", "#");
                houses = StringList.set(houses, 5, "roe", "#");
                culling = StringList.set(culling, 1, "ponte", "#");
            } else if (randomHouse == 1) {
                houses = StringList.set(houses, 4, "zola", "#");
                houses = StringList.set(houses, 5, "ponte", "#");
                culling = StringList.set(culling, 1, "roe", "#");
            } else if (randomHouse == 2) {
                houses = StringList.set(houses, 4, "roe", "#");
                houses = StringList.set(houses, 5, "zola", "#");
                culling = StringList.set(culling, 1, "ponte", "#");
            } else if (randomHouse == 3) {
                houses = StringList.set(houses, 4, "roe", "#");
                houses = StringList.set(houses, 5, "ponte", "#");
                culling = StringList.set(culling, 1, "zola", "#");
            } else if (randomHouse == 4) {
                houses = StringList.set(houses, 4, "ponte", "#");
                houses = StringList.set(houses, 5, "zola", "#");
                culling = StringList.set(culling, 1, "roe", "#");
            } else {
                houses = StringList.set(houses, 4, "ponte", "#");
                houses = StringList.set(houses, 5, "roe", "#");
                culling = StringList.set(culling, 1, "zola", "#");
            }
            randomHouse = MathUtils.random(5);
            if (randomHouse == 0) {
                houses = StringList.set(houses, 8, "ayla", "#");
                houses = StringList.set(houses, 9, "lea", "#");
                culling = StringList.set(culling, 2, "min", "#");
            } else if (randomHouse == 1) {
                houses = StringList.set(houses, 8, "ayla", "#");
                houses = StringList.set(houses, 9, "min", "#");
                culling = StringList.set(culling, 2, "lea", "#");
            } else if (randomHouse == 2) {
                houses = StringList.set(houses, 8, "lea", "#");
                houses = StringList.set(houses, 9, "ayla", "#");
                culling = StringList.set(culling, 2, "min", "#");
            } else if (randomHouse == 3) {
                houses = StringList.set(houses, 8, "lea", "#");
                houses = StringList.set(houses, 9, "min", "#");
                culling = StringList.set(culling, 2, "ayla", "#");
            } else if (randomHouse == 4) {
                houses = StringList.set(houses, 8, "min", "#");
                houses = StringList.set(houses, 9, "ayla", "#");
                culling = StringList.set(culling, 2, "lea", "#");
            } else {
                houses = StringList.set(houses, 8, "min", "#");
                houses = StringList.set(houses, 9, "lea", "#");
                culling = StringList.set(culling, 2, "ayla", "#");
            }
            g.saveGame.put("houses", houses.toString());
            int numChanges = MathUtils.random(2);
            for (int i = 0; i < numChanges; ++i) {
                int randomPosition = MathUtils.random(2) + 1;
                String currOpponent = StringList.get(culling, randomPosition, "#");
                StringList.remove(culling, randomPosition, "#");
                StringList.append(culling, currOpponent, "#");
            }
            g.saveGame.put("culling", culling.toString());
            ArrayList<String> listEvents = new ArrayList<String>();
            ArrayList<String> listOpponents = new ArrayList<String>();
            if (Story.getFactionValue(g, "facwor") < 20 && Story.getFactionValue(g, "facwor") > -20 && Story.getFactionValue(g, "facjus") < 20) {
                StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
                for (int j = 2; j < StringList.size(rewards, ";"); ++j) {
                    String currReward = StringList.get(rewards, j, ";");
                    if (!currReward.startsWith("facjus")) continue;
                    int finalfac = -20;
                    rewards = StringList.set(rewards, j, "facjus:" + finalfac, ";");
                    g.saveGame.put("rewards", "none;0;" + rewards.toString());
                    break;
                }
            }
            if (Story.getFactionValue(g, "facwor") >= 20) {
                listEvents.add("none");
                listOpponents.add("boss2");
                listEvents.add("coliseumentry");
                listOpponents.add(StringList.get(culling, 0, "#"));
                listEvents.add("culling");
                listOpponents.add(StringList.get(houses, 8, "#"));
                listEvents.add("worshipper.resources1");
                listOpponents.add("x");
                listEvents.add("worshipper.slave");
                listOpponents.add(StringList.get(houses, 1, "#"));
                listEvents.add("worshipper.historic1");
                listOpponents.add(StringList.get(houses, 5, "#"));
                listEvents.add("worshipper.historic2");
                listOpponents.add("randomworshipper:p23" + MathUtils.random(1));
                listEvents.add("worshipper.rise");
                listOpponents.add(StringList.get(houses, 2, "#"));
                listEvents.add("worshipper.resources2");
                listOpponents.add("x");
                listEvents.add("worshipper.assassination");
                listOpponents.add("randomworshipper:p230");
                listEvents.add("worshipper.rishi");
                listOpponents.add(StringList.get(houses, 7, "#"));
                listEvents.add("worshipper.sarah");
                listOpponents.add(StringList.get(houses, 3, "#"));
                listEvents.add("worshipper.prince");
                listOpponents.add("boss3");
            } else if (Story.getFactionValue(g, "facwor") <= -20) {
                listEvents.add("none");
                listOpponents.add("boss2");
                listEvents.add("coliseumentry");
                listOpponents.add(StringList.get(culling, 0, "#"));
                listEvents.add("culling");
                listOpponents.add(StringList.get(houses, 8, "#"));
                listEvents.add("crafter.resources1");
                listOpponents.add("x");
                listEvents.add("crafter.pride");
                listOpponents.add(StringList.get(houses, 5, "#"));
                listEvents.add("crafter.historic1");
                listOpponents.add(StringList.get(houses, 1, "#"));
                listEvents.add("crafter.historic2");
                listOpponents.add(StringList.get(houses, 9, "#"));
                listEvents.add("crafter.rise");
                listOpponents.add(StringList.get(houses, 10, "#"));
                listEvents.add("crafter.resources2");
                listOpponents.add("x");
                listEvents.add("crafter.challenge");
                listOpponents.add(StringList.get(houses, 2, "#"));
                listEvents.add("crafter.head1");
                listOpponents.add("x");
                listEvents.add("crafter.head2");
                listOpponents.add("x");
                listEvents.add("crafter.prince");
                listOpponents.add("boss3");
            } else if (Story.getFactionValue(g, "facjus") >= 20) {
                listEvents.add("none");
                listOpponents.add("boss2");
                listEvents.add("coliseumentry");
                listOpponents.add(StringList.get(culling, 0, "#"));
                listEvents.add("culling");
                listOpponents.add(MathUtils.random(1) == 0 ? StringList.get(houses, 0, "#") : StringList.get(houses, 4, "#"));
                listEvents.add("merc.resources1");
                listOpponents.add("x");
                listEvents.add("merc.slave");
                listOpponents.add(StringList.get(houses, 9, "#"));
                listEvents.add("merc.special");
                listOpponents.add("fenris");
                listEvents.add("none");
                listOpponents.add("x");
                listEvents.add("merc.assassinationwor");
                listOpponents.add("randomworshipper:p230");
                listEvents.add("merc.resources2");
                listOpponents.add("x");
                listEvents.add("merc.assault1");
                listOpponents.add("x");
                listEvents.add("merc.assault2");
                listOpponents.add("x");
                listEvents.add("merc.headjus");
                listOpponents.add("x");
                listEvents.add("merc.princejus");
                listOpponents.add("boss3");
            } else if (Story.getFactionValue(g, "facjus") <= -20) {
                listEvents.add("none");
                listOpponents.add("boss2");
                listEvents.add("coliseumentry");
                listOpponents.add(StringList.get(culling, 0, "#"));
                listEvents.add("culling");
                listOpponents.add(MathUtils.random(1) == 0 ? StringList.get(houses, 0, "#") : StringList.get(houses, 4, "#"));
                listEvents.add("merc.resources1");
                listOpponents.add("x");
                listEvents.add("merc.bully");
                listOpponents.add(StringList.get(houses, 9, "#"));
                listEvents.add("merc.special");
                listOpponents.add("fenris");
                listEvents.add("none");
                listOpponents.add("x");
                listEvents.add("merc.assassinationmer");
                listOpponents.add(StringList.get(houses, 10, "#"));
                listEvents.add("merc.resources2");
                listOpponents.add("x");
                listEvents.add("merc.glory1");
                listOpponents.add("x");
                listEvents.add("merc.glory2");
                listOpponents.add("x");
                listEvents.add("merc.headven");
                listOpponents.add("x");
                listEvents.add("merc.princeven");
                listOpponents.add("boss3");
            }
            StringBuilder finalEvents = new StringBuilder(g.saveGame.get("events") + ",");
            for (int i = 0; i < listEvents.size(); ++i) {
                finalEvents.append((String)listEvents.get(i)).append(",");
            }
            g.saveGame.put("events", finalEvents.substring(0, finalEvents.length() - 1));
            StringBuilder finalOpponents = new StringBuilder(g.saveGame.get("opponents") + ",");
            for (int i = 0; i < listOpponents.size(); ++i) {
                finalOpponents.append((String)listOpponents.get(i)).append(",");
            }
            g.saveGame.put("opponents", finalOpponents.substring(0, finalOpponents.length() - 1));
            StringBuilder newRewards = StringList.create("", ";");
            StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
            for (int j = 2; j < StringList.size(rewards, ";"); ++j) {
                String currReward = StringList.get(rewards, j, ";");
                if (!currReward.startsWith("fac") && !currReward.startsWith("dagger-fighting")) continue;
                newRewards = StringList.append(newRewards, currReward, ";");
            }
            g.saveGame.put("rewards", "none;0;" + newRewards.toString());
        }
    }

    public static Fighter getDefaultPlayerFighter(SlavePitsGame g) {
        Fighter result = new Fighter();
        result.portrait = "p00";
        result.weapon = new Equipment();
        result.weapon.id = "dagger";
        result.weapon.tier = "wood";
        result.skinColor = g.stats.get("parts").getJSONObject("portraits").getJSONObject(result.portrait).getString("skinColor");
        result.bodyColor = g.stats.get("parts").getJSONObject("portraits").getJSONObject(result.portrait).getString("bodyColor");
        result.life = Integer.parseInt(g.saveGame.get("life"));
        result.talents = Fighter.getTalentsHashMap(g.saveGame.get("talents"));
        result.behavior = g.saveGame.get("behavior");
        if (g.saveGame.get("behavior") != null) {
            result.behavior = g.saveGame.get("behavior");
        }
        result.isPlayer = true;
        if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            result.bodyType = "2";
            result.bodySubType = "2";
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            result.bodyType = "3";
            result.bodySubType = "2";
        } else {
            result.bodyType = "1";
            result.bodySubType = "2";
        }
        return result;
    }

    public static Fighter getNewPlayerFighter(SlavePitsGame g) {
        Fighter result = Story.getDefaultPlayerFighter(g);
        int randomWeapon = MathUtils.random(1);
        String string = result.weapon.id = randomWeapon == 1 ? "hatchet" : "mace";
        if (g.saveGame.get("difficulty").equalsIgnoreCase("hard")) {
            result.life = 6000 + MathUtils.random(2500);
        } else if (g.saveGame.get("difficulty").equalsIgnoreCase("hardcore")) {
            result.life = 5000 + MathUtils.random(2000);
            if (MathUtils.random(2) == 0) {
                result.weapon.id = "dagger";
            }
        }
        result.isPlayer = true;
        return result;
    }

    public static int getFactionValue(SlavePitsGame g, String faction) {
        StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
        for (int i = 2; i < StringList.size(currRewards, ";"); ++i) {
            String currReward = StringList.get(currRewards, i, ";");
            if (!currReward.startsWith(faction)) continue;
            return Integer.parseInt(currReward.split(":")[1]);
        }
        return 0;
    }

    public static String getWeaponsAvailable(SlavePitsGame g) {
        String result = "dagger:1";
        if (g.saveGame.get("special") == null || !g.saveGame.get("special").equalsIgnoreCase("weapons")) {
            int[] weapons = new int[10];
            int sum = 0;
            for (int i = 0; i < 10; ++i) {
                weapons[i] = (MathUtils.random(1) + 1) % 2;
                sum += weapons[i];
            }
            if (sum < 2) {
                weapons[MathUtils.random((int)9)] = 1;
                weapons[MathUtils.random((int)9)] = 1;
            }
            if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
                result = result + ";hatchet:" + weapons[0] + ";mace:" + weapons[1] + ";sword:" + weapons[2] + ";axe:" + weapons[3] + ";hammer:" + weapons[4] + ";spear:" + weapons[5] + ";shield:" + weapons[6];
            } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
                result = result + ";hatchet:" + weapons[0] + ";mace:" + weapons[1] + ";sword:" + weapons[2] + ";axe:" + weapons[3] + ";hammer:" + weapons[4] + ";spear:" + weapons[5] + ";shield:" + weapons[6] + ";whip:" + weapons[7];
                if (g.saveGame.get("rewards").contains("lonswo")) {
                    result = result + ";longsword:1";
                }
            } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
                result = result + ";hatchet:" + weapons[0] + ";mace:" + weapons[1] + ";sword:" + weapons[2] + ";axe:" + weapons[3] + ";hammer:" + weapons[4] + ";spear:" + weapons[5] + ";shield:" + weapons[6] + ";longsword:" + weapons[7] + ";whip:" + weapons[8];
            }
            g.saveGame.put("special", result);
        }
        return result;
    }

    public static boolean isServiceFree(SlavePitsGame g, String service) {
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            if (service.equalsIgnoreCase("shard") || service.equalsIgnoreCase("powder")) {
                return g.saveGame.get("rewards").contains("item");
            }
            if (service.equalsIgnoreCase("upgradeweapon") || service.equalsIgnoreCase("upgradearmor")) {
                return g.saveGame.get("rewards").contains("upgrad");
            }
            if (service.equalsIgnoreCase("choice")) {
                return g.saveGame.get("rewards").contains("choice");
            }
            if (service.equalsIgnoreCase("info")) {
                return g.saveGame.get("rewards").contains("gossip");
            }
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan") && service.equalsIgnoreCase("info")) {
            return g.saveGame.get("rewards").contains("gossip");
        }
        return false;
    }

    public static boolean isServiceDiscounted(SlavePitsGame g, String service) {
        if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            if (service.equalsIgnoreCase("upgradearmor") || service.equalsIgnoreCase("upgradeweapon")) {
                return g.saveGame.get("rewards").contains("arsena");
            }
            if (service.equalsIgnoreCase("potion")) {
                return g.saveGame.get("rewards").contains("medici");
            }
            if (service.equalsIgnoreCase("care") || service.equalsIgnoreCase("powder")) {
                return g.saveGame.get("rewards").contains("slawor");
            }
            if (service.equalsIgnoreCase("choice") || service.equalsIgnoreCase("shard")) {
                return g.saveGame.get("rewards").contains("slacra");
            }
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            if (service.equalsIgnoreCase("upgradearmor") || service.equalsIgnoreCase("upgradeweapon") || service.equalsIgnoreCase("choice")) {
                return g.saveGame.get("rewards").contains("suphir");
            }
            if (service.equalsIgnoreCase("potion") || service.equalsIgnoreCase("care") || service.equalsIgnoreCase("info")) {
                return g.saveGame.get("rewards").contains("suphfi");
            }
            if (service.equalsIgnoreCase("powder") || service.equalsIgnoreCase("shard") || service.equalsIgnoreCase("net")) {
                return g.saveGame.get("rewards").contains("suphfo");
            }
        }
        return false;
    }

    public static String getRandomOpponent(SlavePitsGame g, String phase) {
        String result = "";
        if (phase.equalsIgnoreCase("caravan")) {
            String currOpponents = g.saveGame.get("opponents");
            ArrayList<String> listPossibleOpponents = new ArrayList<String>();
            if (currOpponents.indexOf("diego", currOpponents.indexOf("diego") + 1) < 0) {
                listPossibleOpponents.add("diego");
            }
            if (currOpponents.indexOf("trent", currOpponents.indexOf("trent") + 1) < 0) {
                listPossibleOpponents.add("trent");
            }
            if (currOpponents.indexOf("onur", currOpponents.indexOf("onur") + 1) < 0) {
                listPossibleOpponents.add("onur");
            }
            if (currOpponents.indexOf("adam", currOpponents.indexOf("adam") + 1) < 0) {
                listPossibleOpponents.add("adam");
            }
            if (currOpponents.indexOf("emma", currOpponents.indexOf("emma") + 1) < 0) {
                listPossibleOpponents.add("emma");
            }
            result = (String)listPossibleOpponents.get(MathUtils.random(listPossibleOpponents.size() - 1));
        }
        return result;
    }

    public static String getNextOpponent(SlavePitsGame g) {
        return g.saveGame.get("opponents").split(",")[Integer.parseInt(g.saveGame.get("fight"))];
    }

    public static int getNextOpponentReputation(SlavePitsGame g) {
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            int fight = Integer.parseInt(g.saveGame.get("fight"));
            return MathUtils.clamp((fight == 0 ? 1 : 100) + fight * 100, 0, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("pits")).getString("maxReputation")));
        }
        if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            int fight = Integer.parseInt(g.saveGame.get("fight"));
            return MathUtils.clamp((fight - 1) * 100, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("pits")).getString("maxReputation")), Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation")));
        }
        if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            int fight = Integer.parseInt(g.saveGame.get("fight"));
            return MathUtils.clamp((fight - 2) * 100, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation")), Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("coliseum")).getString("maxReputation")));
        }
        return 0;
    }

    public static String getNextPrepInfo(SlavePitsGame g, int life, int profits, String markColor) {
        StringBuilder info = new StringBuilder();
        String colorMark = "##:" + markColor;
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            info.append("ppitsmaster");
            info.append("$");
            if (profits >= 200) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.pits.profits.high", g.violenceFilter, colorMark));
            } else if (profits >= 100) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.pits.profits.medium", g.violenceFilter, colorMark));
            } else {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.pits.profits.low", g.violenceFilter, colorMark));
            }
            info.append("\n");
            if (life >= 8000) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.pits.life.high", g.violenceFilter, colorMark));
            } else if (life >= 3000) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.pits.life.medium", g.violenceFilter, colorMark));
            } else if (life > 0) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.pits.life.low", g.violenceFilter, colorMark));
            } else {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.pits.life.lost", g.violenceFilter, colorMark));
            }
            info.append("$");
            String opponent = Story.getNextOpponent(g);
            JSONObject opponentData = (JSONObject)g.stats.get("opponents").get(opponent.split(":")[0]);
            if (opponent.startsWith("random")) {
                info.append(opponent.split(":")[1]);
                opponent = opponent.split(":")[0];
            } else {
                info.append(opponentData.getString("portrait"));
            }
            info.append("$");
            if (!PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".name", g.violenceFilter).equalsIgnoreCase("")) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".name", g.violenceFilter));
            } else {
                info.append(opponent);
            }
            info.append("$");
            info.append("backgroundPrepPits.jpg");
            info.append("$");
            info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".info"));
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            int fight = Integer.parseInt(g.saveGame.get("fight"));
            if (fight == 10) {
                info.append("pcaravanmaster");
                info.append("$");
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.caravan.start", g.violenceFilter, colorMark));
            } else if (fight == 13) {
                info.append("peiko");
                info.append("$");
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.caravan.ambush", g.violenceFilter, colorMark));
            } else if (fight >= 18) {
                if (Story.getFactionValue(g, "facjus") > 0) {
                    info.append("pcaravanmaster");
                } else {
                    info.append("peiko");
                }
                info.append("$");
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.caravan.ambush", g.violenceFilter, colorMark));
            } else {
                info.append("pcaravanmaster");
                info.append("$");
                if (profits >= 200) {
                    info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.caravan.profits.low", g.violenceFilter, colorMark));
                } else if (profits >= 100) {
                    info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.caravan.profits.medium", g.violenceFilter, colorMark));
                } else {
                    info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.caravan.profits.high", g.violenceFilter, colorMark));
                }
                info.append("\n");
                if (life >= 8000) {
                    info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.caravan.life.high", g.violenceFilter, colorMark));
                } else if (life >= 3000) {
                    info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.caravan.life.medium", g.violenceFilter, colorMark));
                } else if (life > 0) {
                    info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.caravan.life.low", g.violenceFilter, colorMark));
                } else {
                    info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.caravan.life.lost", g.violenceFilter, colorMark));
                }
            }
            info.append("$");
            String opponent = Story.getNextOpponent(g);
            JSONObject opponentData = (JSONObject)g.stats.get("opponents").get(opponent.split(":")[0]);
            if (opponent.startsWith("random")) {
                info.append(opponent.split(":")[1]);
                opponent = opponent.split(":")[0];
            } else {
                info.append(opponentData.getString("portrait"));
            }
            info.append("$");
            if (!PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".name", g.violenceFilter).equalsIgnoreCase("")) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".name", g.violenceFilter));
            } else {
                info.append(opponent);
            }
            info.append("$");
            info.append("backgroundPrepCaravan.jpg");
            info.append("$");
            if (opponent.equalsIgnoreCase("diego") || opponent.equalsIgnoreCase("adam") || opponent.equalsIgnoreCase("onur") || opponent.equalsIgnoreCase("trent") || opponent.equalsIgnoreCase("emma")) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".infoextra"));
                info.append("\n\n");
            }
            info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".info"));
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            int fight = Integer.parseInt(g.saveGame.get("fight"));
            if (fight == 20) {
                if (Story.getFactionValue(g, "facjus") > 0) {
                    info.append("pcaravanmaster");
                } else {
                    info.append("peiko");
                }
                info.append("$");
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.coliseum.start", g.violenceFilter, colorMark));
            } else if (fight == 21) {
                if (Story.getFactionValue(g, "facjus") > 0) {
                    info.append("pcaravanmaster");
                } else {
                    info.append("peiko");
                }
                info.append("$");
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.coliseum.culling", g.violenceFilter, colorMark));
            } else if (fight == 31) {
                info.append("p00");
                info.append("$");
            } else {
                if (Story.getFactionValue(g, "facwor") >= 20) {
                    if (fight == 30) {
                        info.append("plaura");
                    } else {
                        info.append("p31");
                    }
                } else if (Story.getFactionValue(g, "facwor") <= -20) {
                    info.append("p32");
                } else if (Story.getFactionValue(g, "facjus") >= 20) {
                    info.append("p33");
                } else if (Story.getFactionValue(g, "facjus") <= -20) {
                    info.append("p33");
                } else {
                    info.append("p40");
                }
                info.append("$");
                if (Story.getFactionValue(g, "facwor") >= 20 && fight == 30) {
                    info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.coliseum.laura", g.violenceFilter, colorMark));
                } else {
                    if (profits >= 200) {
                        info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.coliseum.profits.low", g.violenceFilter, colorMark));
                    } else if (profits >= 100) {
                        info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.coliseum.profits.medium", g.violenceFilter, colorMark));
                    } else {
                        info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.coliseum.profits.high", g.violenceFilter, colorMark));
                    }
                    info.append("\n");
                    if (life >= 8000) {
                        info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.coliseum.life.high", g.violenceFilter, colorMark));
                    } else if (life >= 3000) {
                        info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.coliseum.life.medium", g.violenceFilter, colorMark));
                    } else if (life > 0) {
                        info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.coliseum.life.low", g.violenceFilter, colorMark));
                    } else {
                        info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.coliseum.life.lost", g.violenceFilter, colorMark));
                    }
                }
            }
            info.append("$");
            String opponent = Story.getNextOpponent(g);
            JSONObject opponentData = (JSONObject)g.stats.get("opponents").get(opponent.split(":")[0]);
            if (opponent.startsWith("random")) {
                info.append(opponent.split(":")[1]);
                opponent = opponent.split(":")[0];
            } else {
                info.append(opponentData.getString("portrait"));
            }
            info.append("$");
            if (!PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".name", g.violenceFilter).equalsIgnoreCase("")) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".name", g.violenceFilter));
            } else {
                info.append(opponent);
            }
            info.append("$");
            info.append("backgroundPrepColiseum.jpg");
            info.append("$");
            if (opponent.equalsIgnoreCase("min") || opponent.equalsIgnoreCase("scala") || opponent.equalsIgnoreCase("ayla") || opponent.equalsIgnoreCase("zola") || opponent.equalsIgnoreCase("boris") || opponent.equalsIgnoreCase("tara") || opponent.equalsIgnoreCase("lea") || opponent.equalsIgnoreCase("fenris") || opponent.equalsIgnoreCase("ponte") || opponent.equalsIgnoreCase("roe")) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".infoextra"));
                info.append("\n\n");
            }
            if (opponent.contains("boss")) {
                info.append("-");
            } else {
                info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".info"));
            }
        }
        return info.toString();
    }

    public static String getNextColiseumRanking(SlavePitsGame g) {
        StringBuilder result = new StringBuilder();
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        if (Story.getFactionValue(g, "facwor") >= 20) {
            if (fight == 22) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("0");
            } else if (fight == 23) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("0");
            } else if (fight == 24) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("0");
                result.append(";");
                result.append("1");
            } else if (fight == 25) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("1");
            } else if (fight == 26) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("1");
            } else if (fight == 27) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("1");
                result.append(";");
                result.append("2");
            } else if (fight == 29) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("2");
            } else if (fight == 30) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("2");
            }
        } else if (Story.getFactionValue(g, "facwor") <= -20) {
            if (fight == 22) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("4");
            } else if (fight == 23) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("4");
            } else if (fight == 24) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("4");
                result.append(";");
                result.append("5");
            } else if (fight == 25) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("5");
            } else if (fight == 26) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("5");
                result.append(";");
                result.append("6");
            } else if (fight == 27) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("6");
            } else if (fight == 28) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("6");
            } else if (fight == 29) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("6");
            } else if (fight == 30) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("6");
                result.append(";");
                result.append("7");
            }
        } else if (Story.getFactionValue(g, "facjus") >= 20) {
            if (fight == 22) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("8");
            } else if (fight == 23) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("8");
            } else if (fight == 24) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("8");
                result.append(";");
                result.append("9");
            } else if (fight == 25) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("9");
            } else if (fight == 27) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("9");
                result.append(";");
                result.append("10");
            } else if (fight == 28) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("10");
            } else if (fight == 29) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("10");
            } else if (fight == 30) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("10");
                result.append(";");
                result.append("11");
            }
        } else if (Story.getFactionValue(g, "facjus") <= -20) {
            if (fight == 22) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("8");
            } else if (fight == 23) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("8");
            } else if (fight == 24) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("8");
                result.append(";");
                result.append("9");
            } else if (fight == 25) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("9");
            } else if (fight == 27) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("9");
                result.append(";");
                result.append("10");
            } else if (fight == 28) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("10");
            } else if (fight == 29) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("10");
            } else if (fight == 30) {
                result.append(StringList.getPosition(new StringBuilder(g.saveGame.get("houses")), Story.getNextOpponent(g), "#"));
                result.append(";");
                result.append("10");
                result.append(";");
                result.append("11");
            }
        }
        return result.toString();
    }

    public static void getNextScreen(SlavePitsGame g, String type, String option) {
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            if (type.equalsIgnoreCase("prep")) {
                Story.getNextEvent(g);
            } else if (type.equalsIgnoreCase("event")) {
                Story.getNextFight(g);
            } else if (type.equalsIgnoreCase("fight")) {
                if (g.saveGame.get("aftermatch").equalsIgnoreCase("gameover")) {
                    int fight = Integer.parseInt(g.saveGame.get("fight"));
                    g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "game.settings.gameover"), "FF0000FF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), g.saveGame.get("legendary").equalsIgnoreCase("true") || fight <= 0 ? "mainmenu;fadein:1.0;" : "restart;mainmenu;fadein:1.0;", "gameover:0.5");
                    g.setScreen(g.messageScreen);
                } else if (g.saveGame.get("aftermatch").equalsIgnoreCase("fight")) {
                    Story.getNextFight(g);
                } else if (g.saveGame.get("aftermatch").equalsIgnoreCase("day")) {
                    g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "game.settings.day") + " " + (Integer.parseInt(g.saveGame.get("fight")) + 1 + Integer.parseInt(g.saveGame.get("lostDays"))), "E6E6E6FF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "fighttimer:3.5;fadein:0.5;2.0;1.0", "day:0.5");
                    g.setScreen(g.messageScreen);
                } else {
                    Story.getFixedEvent(g, g.saveGame.get("aftermatch"));
                }
            } else if (type.equalsIgnoreCase("day")) {
                g.prepSetupScreen = new PrepSetupScreen(g, Integer.parseInt(g.saveGame.get("life")), Integer.parseInt(g.saveGame.get("profits")));
                g.setScreen(g.prepSetupScreen);
            }
            Story.getFixedEvent(g, type);
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            if (type.equalsIgnoreCase("prep")) {
                Story.getNextFight(g);
            } else if (type.equalsIgnoreCase("event")) {
                int fight = Integer.parseInt(g.saveGame.get("fight"));
                String nextEvent = g.saveGame.get("events").split(",")[fight - 1];
                if (fight == 13 && option.equalsIgnoreCase("2")) {
                    g.campaignFighter = Story.getDefaultPlayerFighter(g);
                    g.campaignFighter.weapon.id = "hammer";
                    g.campaignFighter.life = Math.min(g.campaignFighter.life + 2500, g.campaignFighter.maxLife);
                    Story.getNextFight(g);
                    return;
                }
                if (Story.getNextOpponent(g).equalsIgnoreCase("x")) {
                    String finalOpponent = "x";
                    if (fight == 15) {
                        if (nextEvent.equalsIgnoreCase("assassin1")) {
                            if (option.equalsIgnoreCase("1")) {
                                finalOpponent = "fenris";
                            } else {
                                StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
                                String currPrize = g.stats.get("story").getJSONObject("choices").getString("event.caravan." + nextEvent + ".option" + option);
                                String currCondition = g.stats.get("story").getJSONObject("choices").getString("event.caravan." + nextEvent + ".condition" + option);
                                g.saveGame.put("lost", "0");
                                g.saveGame.put("fight", "" + (fight + 1));
                                g.saveGame.put("life", "" + (g.campaignFighter.life + 3500));
                                currRewards = Story.addCombatReward(g, currRewards, currPrize, currCondition, ((float)g.campaignFighter.life + 3500.0f) / (float)g.campaignFighter.life, 0L);
                                g.saveGame.put("rewards", "none;0;" + currRewards.toString());
                                g.saveGame.remove("delete");
                                PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                                g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "game.settings.day") + " " + (fight + 1 + Integer.parseInt(g.saveGame.get("lostDays"))), "E6E6E6FF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "fighttimer:5.0;fadein:1.0;3.0;1.0", "day:1.0");
                                g.setScreen(g.messageScreen);
                            }
                        } else {
                            finalOpponent = Story.getRandomOpponent(g, g.saveGame.get("phase"));
                        }
                    } else if (fight == 17) {
                        finalOpponent = option.equalsIgnoreCase("1") ? (nextEvent.equalsIgnoreCase("bet") ? "randomcrafter:p28" + MathUtils.random(1) : "roe") : "roe";
                    } else if (fight == 18 && g.saveGame.get("special") != null && g.saveGame.get("special").equalsIgnoreCase("combat")) {
                        Story.getBossFight(g, 2);
                    }
                    StringBuilder currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                    currOpponents = StringList.set(currOpponents, fight, finalOpponent, ",");
                    g.saveGame.put("opponents", currOpponents.toString());
                }
                g.prepSetupScreen = new PrepSetupScreen(g, Integer.parseInt(g.saveGame.get("life")), Integer.parseInt(g.saveGame.get("profits")));
                g.setScreen(g.prepSetupScreen);
            } else if (type.equalsIgnoreCase("fight")) {
                if (g.saveGame.get("aftermatch").equalsIgnoreCase("gameover")) {
                    g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "game.settings.gameover"), "FF0000FF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), g.saveGame.get("legendary").equalsIgnoreCase("true") ? "mainmenu;fadein:1.0;" : "restart;mainmenu;fadein:1.0;", "gameover:0.5");
                    g.setScreen(g.messageScreen);
                } else if (g.saveGame.get("aftermatch").equalsIgnoreCase("fight")) {
                    Story.getNextFight(g);
                } else if (g.saveGame.get("aftermatch").equalsIgnoreCase("day")) {
                    g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "game.settings.day") + " " + (Integer.parseInt(g.saveGame.get("fight")) + 1 + Integer.parseInt(g.saveGame.get("lostDays"))), "E6E6E6FF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "fighttimer:3.5;fadein:0.5;2.0;1.0", "day:0.5");
                    g.setScreen(g.messageScreen);
                } else {
                    Story.getFixedEvent(g, g.saveGame.get("aftermatch"));
                }
            } else if (type.equalsIgnoreCase("day")) {
                Story.getNextEvent(g);
            }
            Story.getFixedEvent(g, type);
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            if (type.equalsIgnoreCase("prep")) {
                if (!g.saveGame.get("aftermatch").equalsIgnoreCase("")) {
                    String[] params = g.saveGame.get("aftermatch").split(";");
                    g.coliseumScreen = new ColiseumScreen(g, params.length > 0 ? params[0] : "", params.length > 1 ? params[1] : "", params.length > 2 ? params[2] : "");
                    g.setScreen(g.coliseumScreen);
                } else {
                    Story.getNextFight(g);
                }
            } else if (type.equalsIgnoreCase("ranking")) {
                g.saveGame.put("aftermatch", "");
                Story.getNextFight(g);
            } else if (type.equalsIgnoreCase("event")) {
                StringBuilder currOpponents;
                String finalOpponent;
                int fight = Integer.parseInt(g.saveGame.get("fight"));
                String nextEvent = g.saveGame.get("events").split(",")[fight - 1];
                if (Story.getFactionValue(g, "facwor") >= 20) {
                    if (Story.getNextOpponent(g).equalsIgnoreCase("x")) {
                        finalOpponent = "x";
                        currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                        if (fight == 22) {
                            finalOpponent = option.equalsIgnoreCase("1") ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 5, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 9, "#");
                        } else if (fight == 27) {
                            finalOpponent = StringList.get(currOpponents, 22, ",").equalsIgnoreCase(StringList.get(new StringBuilder(g.saveGame.get("houses")), 9, "#")) ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 6, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 10, "#");
                        }
                        currOpponents = StringList.set(currOpponents, fight, finalOpponent, ",");
                        g.saveGame.put("opponents", currOpponents.toString());
                    }
                    if (fight == 23 && option.equalsIgnoreCase("1")) {
                        g.saveGame.put("profits", "0");
                    }
                    if (fight == 25 || fight == 28) {
                        Story.getNextFight(g);
                        return;
                    }
                } else if (Story.getFactionValue(g, "facwor") <= -20) {
                    if (Story.getNextOpponent(g).equalsIgnoreCase("x")) {
                        finalOpponent = "x";
                        currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                        if (fight == 22) {
                            finalOpponent = option.equalsIgnoreCase("1") ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 1, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 9, "#");
                        } else if (fight == 27) {
                            finalOpponent = StringList.get(currOpponents, 22, ",").equalsIgnoreCase(StringList.get(new StringBuilder(g.saveGame.get("houses")), 9, "#")) ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 1, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 9, "#");
                        } else if (fight == 29) {
                            finalOpponent = option.equalsIgnoreCase("1") ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 3, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 11, "#");
                        } else if (fight == 30) {
                            finalOpponent = StringList.get(currOpponents, 29, ",").equalsIgnoreCase(StringList.get(new StringBuilder(g.saveGame.get("houses")), 11, "#")) ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 3, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 11, "#");
                        }
                        currOpponents = StringList.set(currOpponents, fight, finalOpponent, ",");
                        g.saveGame.put("opponents", currOpponents.toString());
                    }
                    if (fight == 23 && option.equalsIgnoreCase("1")) {
                        g.saveGame.put("profits", "0");
                    }
                    if (fight == 25) {
                        Story.getNextFight(g);
                        return;
                    }
                } else if (Story.getFactionValue(g, "facjus") >= 20) {
                    if (Story.getNextOpponent(g).equalsIgnoreCase("x")) {
                        finalOpponent = "x";
                        currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                        if (fight == 22) {
                            finalOpponent = option.equalsIgnoreCase("1") ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 1, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 5, "#");
                        } else if (fight == 27) {
                            finalOpponent = StringList.get(currOpponents, 22, ",").equalsIgnoreCase(StringList.get(new StringBuilder(g.saveGame.get("houses")), 5, "#")) ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 1, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 5, "#");
                        } else if (fight == 28) {
                            finalOpponent = option.equalsIgnoreCase("1") ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 2, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 6, "#");
                        } else if (fight == 29) {
                            finalOpponent = StringList.get(currOpponents, 28, ",").equalsIgnoreCase(StringList.get(new StringBuilder(g.saveGame.get("houses")), 6, "#")) ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 2, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 6, "#");
                        } else if (fight == 30) {
                            finalOpponent = option.equalsIgnoreCase("1") ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 3, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 7, "#");
                        }
                        currOpponents = StringList.set(currOpponents, fight, finalOpponent, ",");
                        g.saveGame.put("opponents", currOpponents.toString());
                    }
                    if (fight == 23 && option.equalsIgnoreCase("1")) {
                        g.saveGame.put("profits", "0");
                    }
                    if (fight == 26 || fight == 29) {
                        Story.getNextFight(g);
                        return;
                    }
                } else if (Story.getFactionValue(g, "facjus") <= -20) {
                    if (Story.getNextOpponent(g).equalsIgnoreCase("x")) {
                        finalOpponent = "x";
                        currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                        if (fight == 22) {
                            finalOpponent = option.equalsIgnoreCase("1") ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 1, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 5, "#");
                        } else if (fight == 27) {
                            finalOpponent = StringList.get(currOpponents, 22, ",").equalsIgnoreCase(StringList.get(new StringBuilder(g.saveGame.get("houses")), 5, "#")) ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 1, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 5, "#");
                        } else if (fight == 28) {
                            finalOpponent = option.equalsIgnoreCase("1") ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 2, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 6, "#");
                        } else if (fight == 29) {
                            finalOpponent = StringList.get(currOpponents, 28, ",").equalsIgnoreCase(StringList.get(new StringBuilder(g.saveGame.get("houses")), 6, "#")) ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 2, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 6, "#");
                        } else if (fight == 30) {
                            finalOpponent = option.equalsIgnoreCase("1") ? StringList.get(new StringBuilder(g.saveGame.get("houses")), 3, "#") : StringList.get(new StringBuilder(g.saveGame.get("houses")), 7, "#");
                        }
                        currOpponents = StringList.set(currOpponents, fight, finalOpponent, ",");
                        g.saveGame.put("opponents", currOpponents.toString());
                    }
                    if (fight == 23 && option.equalsIgnoreCase("1")) {
                        g.saveGame.put("profits", "0");
                    }
                    if (fight == 26) {
                        Story.getNextFight(g);
                        return;
                    }
                }
                if (fight == 31) {
                    StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
                    if (StringList.indexOf(currRewards, "lifbo3", 0, ";") > 0) {
                        int finalLife = Integer.parseInt(g.saveGame.get("life")) + 5000;
                        if (finalLife > 10000) {
                            finalLife = 10000;
                        }
                        g.saveGame.put("life", "" + finalLife);
                    }
                    g.saveGame.put("profits", "500");
                    Story.getFixedEvent(g, "chapter.4");
                    return;
                }
                g.prepSetupScreen = new PrepSetupScreen(g, Integer.parseInt(g.saveGame.get("life")), Integer.parseInt(g.saveGame.get("profits")));
                g.setScreen(g.prepSetupScreen);
            } else if (type.equalsIgnoreCase("fight")) {
                if (g.saveGame.get("aftermatch").equalsIgnoreCase("gameover")) {
                    g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "game.settings.gameover"), "FF0000FF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), g.saveGame.get("legendary").equalsIgnoreCase("true") ? "mainmenu;fadein:1.0;" : "restart;mainmenu;fadein:1.0;", "gameover:0.5");
                    g.setScreen(g.messageScreen);
                } else if (g.saveGame.get("aftermatch").equalsIgnoreCase("event")) {
                    Story.getNextEvent(g);
                } else if (g.saveGame.get("aftermatch").equalsIgnoreCase("fight")) {
                    Story.getNextFight(g);
                } else if (g.saveGame.get("aftermatch").equalsIgnoreCase("day")) {
                    g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "game.settings.day") + " " + (Integer.parseInt(g.saveGame.get("fight")) + 1 + Integer.parseInt(g.saveGame.get("lostDays"))), "E6E6E6FF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "fighttimer:3.5;fadein:0.5;2.0;1.0", "day:0.5");
                    g.setScreen(g.messageScreen);
                } else {
                    Story.getFixedEvent(g, g.saveGame.get("aftermatch"));
                }
            } else if (type.equalsIgnoreCase("day")) {
                Story.getNextEvent(g);
            }
            Story.getFixedEvent(g, type);
        }
    }

    public static void getNextFight(SlavePitsGame g) {
        StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        if (g.saveGame.get("legendary").equalsIgnoreCase("true")) {
            g.saveGame.put("delete", "true");
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
        }
        int timeLimit = 0;
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            if (fight > 0) {
                String condition;
                String currReward = StringList.get(currRewards, 0, ";");
                String currChoice = StringList.get(currRewards, 1, ";");
                String currPrize = !currReward.equalsIgnoreCase("none") && !currChoice.equalsIgnoreCase("0") ? g.stats.get("story").getJSONObject("choices").getString(currReward.replace(".combo", "").replace("single", "3") + ".option" + currChoice) : "";
                String string = condition = !currReward.equalsIgnoreCase("none") && !currChoice.equalsIgnoreCase("0") ? g.stats.get("story").getJSONObject("choices").getString(currReward.replace(".combo", "").replace("single", "3") + ".condition" + currChoice) : "";
                if (currPrize.equalsIgnoreCase("dourep") && !currChoice.equalsIgnoreCase("3")) {
                    String currEvent = g.saveGame.get("events").split(",")[fight - 1];
                    String currOpponent = currEvent.replace("event.pits.", "");
                    currOpponent = currOpponent.substring(0, currOpponent.indexOf("."));
                    Fighter realFighter = Fighter.clone(g.campaignFighter, false);
                    (realFighter.weapon = new Equipment()).id = currChoice.equalsIgnoreCase("1") ? "whip" : "hammer";
                    realFighter.weapon.tier = "improvised";
                    realFighter.offHand = null;
                    realFighter.head = null;
                    realFighter.arms = null;
                    realFighter.body = null;
                    realFighter.services = "";
                    Fighter opponent = Fighter.createOpponent(g, currOpponent, Story.getNextOpponentReputation(g), false);
                    g.combatScreen = new CombatScreen(g, realFighter, opponent, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("pits")).getString("maxReputation")), "pitsnight", "sl09", g.saveGame.get("difficulty"), !realFighter.behavior.equalsIgnoreCase(""), MathUtils.random(1) + 1, 0, "");
                    Fighter.loadFighterAssets(g, opponent, true, false);
                    Fighter.loadFighterAssets(g, realFighter, false, false);
                    g.combatScreen.create();
                    g.setScreen(g.combatScreen);
                    return;
                }
                if (condition.startsWith("time")) {
                    timeLimit = Integer.parseInt(condition.split(":")[2]);
                }
            }
            String music = "sl09";
            if (fight > 0 && MathUtils.random(100) > 40) {
                music = "sl0" + (5 + MathUtils.random(3));
            }
            String arena = MathUtils.random(1) == 0 ? "pits1" : "pits2";
            Fighter opponent = Fighter.createOpponent(g, Story.getNextOpponent(g), Story.getNextOpponentReputation(g), false);
            g.combatScreen = new CombatScreen(g, g.campaignFighter, opponent, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("pits")).getString("maxReputation")), arena, music, g.saveGame.get("difficulty"), g.campaignFighter != null ? !g.campaignFighter.behavior.equalsIgnoreCase("") : false, MathUtils.random(1) + 1, timeLimit, "");
            Fighter.loadFighterAssets(g, opponent, true, false);
            Fighter.loadFighterAssets(g, g.campaignFighter, false, false);
            g.combatScreen.create();
            g.setScreen(g.combatScreen);
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            Fighter opponent;
            String nextOpponent;
            String condition;
            String currReward = StringList.get(currRewards, 0, ";");
            String currChoice = StringList.get(currRewards, 1, ";");
            String string = condition = !currReward.equalsIgnoreCase("none") && !currChoice.equalsIgnoreCase("0") ? g.stats.get("story").getJSONObject("choices").getString(currReward + ".condition" + currChoice) : "";
            if (fight == 13 && currChoice.equalsIgnoreCase("2")) {
                g.campaignFighter.weapon = new Equipment();
                g.campaignFighter.weapon.id = "hammer";
                g.campaignFighter.weapon.tier = "improvised";
                g.campaignFighter.offHand = null;
                g.campaignFighter.head = null;
                g.campaignFighter.arms = null;
                g.campaignFighter.body = null;
                g.campaignFighter.services = "";
                g.campaignFighter.life += 2500;
                if (g.campaignFighter.life > 10000) {
                    g.campaignFighter.life = 10000;
                }
            }
            if ((nextOpponent = Story.getNextOpponent(g)).startsWith("random")) {
                opponent = Fighter.createOpponent(g, nextOpponent.split(":")[0], Story.getNextOpponentReputation(g), false);
                opponent = Fighter.changeAppearance(g, nextOpponent.split(":")[1], opponent, false, false);
            } else {
                opponent = Fighter.createOpponent(g, nextOpponent, Story.getNextOpponentReputation(g), false);
            }
            String music = "sl10";
            if (fight == 13 || fight == 18) {
                music = "sl08";
            } else if (fight > 10 && MathUtils.random(100) > 40) {
                music = "sl0" + (5 + MathUtils.random(3));
            }
            String arena = "caravan2";
            if (fight < 12) {
                arena = "caravan1";
            } else if (fight == 13 || fight == 18) {
                arena = "caravan3";
            }
            if (condition.startsWith("time")) {
                timeLimit = Integer.parseInt(condition.split(":")[2]);
            }
            g.combatScreen = new CombatScreen(g, g.campaignFighter, opponent, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation")), arena, music, g.saveGame.get("difficulty"), g.campaignFighter != null ? !g.campaignFighter.behavior.equalsIgnoreCase("") : false, MathUtils.random(1) + 1, timeLimit, "");
            Fighter.loadFighterAssets(g, opponent, true, false);
            Fighter.loadFighterAssets(g, g.campaignFighter, false, false);
            g.combatScreen.create();
            g.setScreen(g.combatScreen);
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            Fighter opponent;
            String nextOpponent;
            String condition;
            if (fight == 31) {
                Story.getBossFight(g, 3);
                return;
            }
            String currReward = StringList.get(currRewards, 0, ";");
            String currChoice = StringList.get(currRewards, 1, ";");
            String string = condition = !currReward.equalsIgnoreCase("none") && !currChoice.equalsIgnoreCase("0") ? g.stats.get("story").getJSONObject("choices").getString(currReward + ".condition" + currChoice) : "";
            if (Story.getFactionValue(g, "facwor") >= 20) {
                if (fight == 28) {
                    (g.campaignFighter.weapon = new Equipment()).id = currChoice.equalsIgnoreCase("1") ? "dagger" : (currChoice.equalsIgnoreCase("2") ? "whip" : "hammer");
                    g.campaignFighter.weapon.tier = "improvised";
                    g.campaignFighter.offHand = null;
                    g.campaignFighter.head = null;
                    g.campaignFighter.arms = null;
                    g.campaignFighter.body = null;
                    g.campaignFighter.services = "";
                    g.campaignFighter.life += 2500;
                    if (g.campaignFighter.life > 10000) {
                        g.campaignFighter.life = 10000;
                    }
                }
            } else if (Story.getFactionValue(g, "facwor") > -20 && (Story.getFactionValue(g, "facjus") >= 20 || Story.getFactionValue(g, "facjus") <= -20) && fight == 26) {
                (g.campaignFighter.weapon = new Equipment()).id = currChoice.equalsIgnoreCase("1") ? "whip" : "hammer";
                g.campaignFighter.weapon.tier = "improvised";
                g.campaignFighter.offHand = null;
                g.campaignFighter.head = null;
                g.campaignFighter.arms = null;
                g.campaignFighter.body = null;
                g.campaignFighter.services = "";
                g.campaignFighter.life += 2500;
                if (g.campaignFighter.life > 10000) {
                    g.campaignFighter.life = 10000;
                }
            }
            if ((nextOpponent = Story.getNextOpponent(g)).startsWith("random")) {
                opponent = Fighter.createOpponent(g, nextOpponent.split(":")[0], Story.getNextOpponentReputation(g), false);
                opponent = Fighter.changeAppearance(g, nextOpponent.split(":")[1], opponent, false, false);
            } else {
                opponent = Fighter.createOpponent(g, nextOpponent, Story.getNextOpponentReputation(g), false);
            }
            String music = "sl11";
            if (fight > 21 && fight < 30 && MathUtils.random(100) > 40) {
                music = "sl0" + (5 + MathUtils.random(3));
            }
            String arena = "coliseum1";
            String scenario = "";
            if (Story.getFactionValue(g, "facwor") >= 20) {
                if (fight > 21) {
                    if (fight == 22 || fight == 27 || fight == 29 || fight == 30) {
                        arena = "coliseum2";
                    } else if (fight == 28) {
                        arena = "coliseumnight";
                    }
                }
                if (fight == 22 || fight == 27) {
                    scenario = MathUtils.random(3) == 0 ? "barricades" : (MathUtils.random(2) == 0 ? "cage" : (MathUtils.random(1) == 0 ? "caltrops" : "coal"));
                }
            } else if (Story.getFactionValue(g, "facwor") <= -20) {
                if (fight > 21 && (fight == 22 || fight >= 27)) {
                    arena = "coliseum2";
                }
                if (fight == 22 || fight == 26) {
                    scenario = MathUtils.random(3) == 0 ? "barricades" : (MathUtils.random(2) == 0 ? "cage" : (MathUtils.random(1) == 0 ? "caltrops" : "coal"));
                } else if (fight == 28) {
                    scenario = "coal";
                }
            } else if (Story.getFactionValue(g, "facjus") >= 20) {
                if (fight > 21) {
                    if (fight == 22 || fight >= 27 && fight != 29) {
                        arena = "coliseum2";
                    } else if (fight == 29) {
                        arena = "coliseum1";
                    } else if (fight == 26) {
                        arena = "coliseumnight";
                    }
                }
                if (fight == 22 || fight == 24 || fight == 27) {
                    scenario = MathUtils.random(3) == 0 ? "barricades" : (MathUtils.random(2) == 0 ? "cage" : (MathUtils.random(1) == 0 ? "caltrops" : "coal"));
                }
            } else if (Story.getFactionValue(g, "facjus") <= -20) {
                if (fight > 21) {
                    if (fight == 22 || fight >= 27) {
                        arena = "coliseum2";
                    } else if (fight == 26) {
                        arena = "coliseumnight";
                    }
                }
                if (fight == 22 || fight == 24 || fight == 27) {
                    String string2 = MathUtils.random(3) == 0 ? "barricades" : (MathUtils.random(2) == 0 ? "cage" : (scenario = MathUtils.random(1) == 0 ? "caltrops" : "coal"));
                }
            }
            if (condition.startsWith("time")) {
                timeLimit = Integer.parseInt(condition.split(":")[2]);
            }
            g.combatScreen = new CombatScreen(g, g.campaignFighter, opponent, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("coliseum")).getString("maxReputation")), arena, music, g.saveGame.get("difficulty"), g.campaignFighter != null ? !g.campaignFighter.behavior.equalsIgnoreCase("") : false, MathUtils.random(1) + 1, timeLimit, scenario);
            Fighter.loadFighterAssets(g, opponent, true, false);
            Fighter.loadFighterAssets(g, g.campaignFighter, false, false);
            g.combatScreen.create();
            g.setScreen(g.combatScreen);
        }
    }

    public static void getTutorialFight(SlavePitsGame g) {
        g.saveGame.put("delete", "true");
        Fighter pc = Story.getDefaultPlayerFighter(g);
        pc.weapon.tier = "improvised";
        String music = "sl14t";
        Fighter opponent = Fighter.createOpponent(g, "tutorial", 0, false);
        g.combatScreen = new CombatScreen(g, pc, opponent, 0, "tutorial", music, "normal", false, 0L, 0, "");
        Fighter.loadFighterAssets(g, opponent, true, false);
        Fighter.loadFighterAssets(g, pc, false, false);
        g.combatScreen.create();
        g.setScreen(g.combatScreen);
    }

    public static void getBossFight(SlavePitsGame g, int bossNum) {
        if (g.saveGame.get("legendary").equalsIgnoreCase("true")) {
            g.saveGame.put("delete", "true");
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
        }
        if (bossNum == 1) {
            StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
            if (StringList.indexOf(currRewards, "lifbo1", 0, ";") > 0) {
                g.campaignFighter.life += 5000;
                if (g.campaignFighter.life > 10000) {
                    g.campaignFighter.life = 10000;
                }
            }
            Fighter boss1 = Fighter.createOpponent(g, "boss1", 1000, false);
            g.combatScreen = new CombatScreen(g, g.campaignFighter, boss1, 1000, "boss1", "sl12", g.saveGame.get("difficulty"), g.campaignFighter != null ? !g.campaignFighter.behavior.equalsIgnoreCase("") : false, 1L, 0, "");
            Fighter.loadFighterAssets(g, boss1, true, false);
            Fighter.loadFighterAssets(g, g.campaignFighter, false, false);
            g.combatScreen.create();
            g.setScreen(g.combatScreen);
        } else if (bossNum == 2) {
            StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
            if (StringList.indexOf(currRewards, "lifbo2", 0, ";") > 0) {
                g.campaignFighter.life += 5000;
                if (g.campaignFighter.life > 10000) {
                    g.campaignFighter.life = 10000;
                }
            }
            Fighter boss2 = Fighter.createOpponent(g, "boss2", 2000, false);
            g.combatScreen = new CombatScreen(g, g.campaignFighter, boss2, 2000, "boss2", "sl13", g.saveGame.get("difficulty"), g.campaignFighter != null ? !g.campaignFighter.behavior.equalsIgnoreCase("") : false, 1L, 0, "");
            Fighter.loadFighterAssets(g, boss2, true, false);
            Fighter.loadFighterAssets(g, g.campaignFighter, false, false);
            g.combatScreen.create();
            g.setScreen(g.combatScreen);
        } else if (bossNum == 3) {
            Fighter boss3 = Fighter.createOpponent(g, "boss3", 2000, false);
            g.combatScreen = new CombatScreen(g, g.campaignFighter, boss3, 3000, "boss3", "sl14t", g.saveGame.get("difficulty"), g.campaignFighter != null ? !g.campaignFighter.behavior.equalsIgnoreCase("") : false, 1L, 0, "");
            Fighter.loadFighterAssets(g, boss3, true, false);
            Fighter.loadFighterAssets(g, g.campaignFighter, false, false);
            g.combatScreen.create();
            g.setScreen(g.combatScreen);
        }
    }

    public static void getNextEvent(SlavePitsGame g) {
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            String nextEvent = g.saveGame.get("events").split(",")[fight - 1];
            if (nextEvent.contains("plot")) {
                currRewards = StringList.set(currRewards, 0, "none", ";");
                currRewards = StringList.set(currRewards, 1, "0", ";");
                g.saveGame.put("rewards", currRewards.toString());
                g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl03.ogg"), g.getOverridenFilename("data/backgrounds/backgroundNightPits.jpg"), "event.pits." + nextEvent, 60000L);
                g.setScreen(g.loreScreen);
            } else if (nextEvent.equalsIgnoreCase("x")) {
                String currEvents = g.saveGame.get("events");
                String[] currOpponents = g.saveGame.get("opponents").split(",");
                String possibleEvents = "";
                for (int i = 0; i < fight; ++i) {
                    String currCandidate = currOpponents[i];
                    if (currEvents.contains(currCandidate) || !(currCandidate.equalsIgnoreCase("scala") && !currEvents.contains("zola.single") && !currEvents.contains("min.combo") || currCandidate.equalsIgnoreCase("min") && !currEvents.contains("scala.combo") || currCandidate.equalsIgnoreCase("diego") && !currEvents.contains("boris.combo") || currCandidate.equalsIgnoreCase("boris") && !currEvents.contains("diego.combo") || currCandidate.equalsIgnoreCase("onur") && !currEvents.contains("zola.combo") || currCandidate.equalsIgnoreCase("zola") && !currEvents.contains("scala.single") && !currEvents.contains("onur.combo") || currCandidate.equalsIgnoreCase("ayla") && !currEvents.contains("trent.combo")) && (!currCandidate.equalsIgnoreCase("trent") || currEvents.contains("ayla.combo") || currCandidate.equalsIgnoreCase("adam") || currCandidate.equalsIgnoreCase("emma"))) continue;
                    possibleEvents = possibleEvents + currCandidate + ",";
                }
                if (possibleEvents.equalsIgnoreCase("")) {
                    possibleEvents = "alone2";
                    currEvents = currEvents.replaceFirst(",x,", "," + possibleEvents + ",");
                    currRewards = StringList.set(currRewards, 0, "none", ";");
                    currRewards = StringList.set(currRewards, 1, "0", ";");
                    g.saveGame.put("rewards", currRewards.toString());
                } else {
                    possibleEvents = possibleEvents.substring(0, possibleEvents.length() - 1);
                    String selectedEvent = possibleEvents.split(",")[MathUtils.random(possibleEvents.split(",").length - 1)];
                    currEvents = currEvents.replaceFirst(",x,", "," + selectedEvent + ".single,");
                    currRewards = StringList.set(currRewards, 0, "event.pits." + selectedEvent + ".single", ";");
                    currRewards = StringList.set(currRewards, 1, "0", ";");
                    g.saveGame.put("rewards", currRewards.toString());
                }
                g.saveGame.put("events", currEvents);
                PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                Story.getNextEvent(g);
            } else {
                currRewards = StringList.set(currRewards, 0, "event.pits." + nextEvent, ";");
                currRewards = StringList.set(currRewards, 1, "1", ";");
                g.saveGame.put("rewards", currRewards.toString());
                g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl03.ogg"), g.getOverridenFilename("data/backgrounds/backgroundNightPits.jpg"), "event.pits." + nextEvent, 60000L);
                g.setScreen(g.loreScreen);
            }
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            String nextEvent = g.saveGame.get("events").split(",")[fight - 1];
            if (nextEvent.contains("plot")) {
                currRewards = StringList.set(currRewards, 0, "none", ";");
                currRewards = StringList.set(currRewards, 1, "0", ";");
                g.saveGame.put("rewards", currRewards.toString());
                if (nextEvent.contains("escapeplot")) {
                    g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                    g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl08.ogg"), g.getOverridenFilename("data/backgrounds/arenacaravan3.jpg"), "event.caravan." + nextEvent, 60000L);
                } else if (nextEvent.contains("duelplot")) {
                    g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl10.ogg"), g.getOverridenFilename("data/backgrounds/arenaboss2.jpg"), "event.caravan." + nextEvent, 60000L);
                } else if (nextEvent.contains("endplot")) {
                    g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundLore6.jpg"), "event.caravan." + nextEvent, 60000L);
                }
                g.setScreen(g.loreScreen);
            } else if (nextEvent.equalsIgnoreCase("x")) {
                String selectedEvent = "";
                String selectedOpponent = "";
                StringBuilder currEvents = StringList.create(g.saveGame.get("events"), ",");
                StringBuilder currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                if (fight == 12) {
                    selectedEvent = StringList.indexOf(currRewards, "slawor", 0, ";") > 0 ? "sickness" : "arsenal";
                    selectedOpponent = Story.getRandomOpponent(g, g.saveGame.get("phase"));
                } else if (fight == 14) {
                    if (StringList.indexOf(currRewards, "slawor", 0, ";") > 0) {
                        selectedEvent = "river";
                        selectedOpponent = Story.getRandomOpponent(g, g.saveGame.get("phase"));
                    } else {
                        selectedEvent = "hunt";
                        selectedOpponent = Story.getRandomOpponent(g, g.saveGame.get("phase"));
                    }
                } else if (fight == 15) {
                    selectedEvent = g.campaignFighter.life < 5000 ? "assassin1" : "assassin2";
                    selectedOpponent = "x";
                } else if (fight == 17) {
                    selectedEvent = StringList.indexOf(currRewards, "slawor", 0, ";") > 0 ? "bet" : "stand";
                    selectedOpponent = "x";
                } else if (fight == 18) {
                    if (Story.getFactionValue(g, "facjus") > 0) {
                        selectedEvent = "escapeplot1";
                        selectedOpponent = "randombandit:p29" + MathUtils.random(1);
                    } else {
                        selectedEvent = "escapeplot2";
                        selectedOpponent = "randomworshipper:p23" + MathUtils.random(1);
                    }
                }
                currEvents = StringList.set(currEvents, fight - 1, selectedEvent, ",");
                currOpponents = StringList.set(currOpponents, fight, selectedOpponent, ",");
                currRewards = StringList.set(currRewards, 0, "event.caravan." + selectedEvent, ";");
                currRewards = StringList.set(currRewards, 1, "0", ";");
                g.saveGame.put("events", currEvents.toString());
                g.saveGame.put("opponents", currOpponents.toString());
                g.saveGame.put("rewards", currRewards.toString());
                PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                Story.getNextEvent(g);
            } else {
                String music = g.getOverridenFilename("music/sl03.ogg");
                if (nextEvent.contains("escapeplot")) {
                    music = g.getOverridenFilename("music/sl08.ogg");
                }
                currRewards = StringList.set(currRewards, 0, "event.caravan." + nextEvent, ";");
                currRewards = StringList.set(currRewards, 1, "0", ";");
                g.saveGame.put("rewards", currRewards.toString());
                g.loreScreen = new LoreScreen(g, music, g.getOverridenFilename("data/backgrounds/backgroundLore6.jpg"), "event.caravan." + nextEvent, 60000L);
                g.setScreen(g.loreScreen);
            }
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            String nextEvent = g.saveGame.get("events").split(",")[fight - 1];
            if (fight == 22) {
                currRewards = Story.getFactionValue(g, "facwor") >= 20 ? StringList.append(currRewards, "suphfi", ";") : (Story.getFactionValue(g, "facwor") <= -20 ? StringList.append(currRewards, "suphir", ";") : StringList.append(currRewards, "suphfo", ";"));
                g.saveGame.put("rewards", currRewards.toString());
            }
            if (fight == 25 && (Story.getFactionValue(g, "facwor") >= 20 || Story.getFactionValue(g, "facwor") <= -20)) {
                String music = g.getOverridenFilename("music/sl11.ogg");
                currRewards = StringList.set(currRewards, 0, "event.coliseum." + nextEvent, ";");
                currRewards = StringList.set(currRewards, 1, "0", ";");
                g.saveGame.put("rewards", currRewards.toString());
                g.loreScreen = new LoreScreen(g, music, g.getOverridenFilename("data/backgrounds/backgroundColiseum.jpg"), "event.coliseum." + nextEvent, 60000L);
                g.setScreen(g.loreScreen);
                return;
            }
            if (fight == 31 && !g.saveGame.get("rewards").contains("warbos")) {
                nextEvent = "prince";
            }
            String rewardOption = "0";
            if (fight == 30 || fight == 29 && Story.getFactionValue(g, "facwor") < 20 && Story.getFactionValue(g, "facwor") > -20 || fight == 28 && Story.getFactionValue(g, "facwor") < 20) {
                rewardOption = "1";
            }
            String music = g.getOverridenFilename("music/sl03.ogg");
            currRewards = StringList.set(currRewards, 0, "event.coliseum." + nextEvent, ";");
            currRewards = StringList.set(currRewards, 1, rewardOption, ";");
            g.saveGame.put("rewards", currRewards.toString());
            g.loreScreen = new LoreScreen(g, music, g.getOverridenFilename("data/backgrounds/backgroundLore8.jpg"), "event.coliseum." + nextEvent, 60000L);
            g.setScreen(g.loreScreen);
        }
    }

    public static void getFixedEvent(SlavePitsGame g, String type) {
        if (type.equalsIgnoreCase("start.1")) {
            g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl17.ogg"), g.getOverridenFilename("data/figures/empty.png"), "start.1", 10L);
            g.setScreen(g.loreScreen);
        } else if (type.equalsIgnoreCase("start.2")) {
            g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "zone.start.2"), "FFFFFFFF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() * 3.0f / 4.0f), "event:lore.1;background:data/backgrounds/fieryEyes.jpg;loretimer:0.8;fadein:2.0;", "continue");
            g.setScreen(g.messageScreen);
        } else if (type.equalsIgnoreCase("lore.1")) {
            g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/fieryEyes.jpg"), "lore.1", 60000L);
            g.setScreen(g.loreScreen);
        } else if (type.equalsIgnoreCase("lore.2")) {
            g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundLore2.jpg"), "lore.2", 60000L);
            g.setScreen(g.loreScreen);
        } else if (type.equalsIgnoreCase("lore.3")) {
            g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundLore2.jpg"), "lore.3", 60000L);
            g.setScreen(g.loreScreen);
        } else if (type.equalsIgnoreCase("lore.4")) {
            g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundLore3.jpg"), "lore.4", 60000L);
            g.setScreen(g.loreScreen);
        } else if (type.equalsIgnoreCase("lore.5")) {
            g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl12b.ogg"), g.getOverridenFilename("data/backgrounds/arenaboss1.jpg"), "lore.5", 60000L);
            g.setScreen(g.loreScreen);
        } else if (type.equalsIgnoreCase("lore.6")) {
            g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/arenaboss1.jpg"), "lore.6", 60000L);
            g.setScreen(g.loreScreen);
        } else if (type.equalsIgnoreCase("lore.7")) {
            g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/fieryEyes.jpg"), "lore.7", 60000L);
            g.setScreen(g.loreScreen);
        } else if (type.equalsIgnoreCase("lore.8")) {
            g.loreScreen = g.saveGame.get("rewards").contains("slawor") ? (Story.getFactionValue(g, "facjus") > 0 ? new LoreScreen(g, g.getOverridenFilename("music/sl10.ogg"), g.getOverridenFilename("data/backgrounds/arenaboss2.jpg"), "event.caravan.duelplot1", 60000L) : new LoreScreen(g, g.getOverridenFilename("music/sl10.ogg"), g.getOverridenFilename("data/backgrounds/arenaboss2.jpg"), "event.caravan.duelplot2", 60000L)) : (Story.getFactionValue(g, "facjus") > 0 ? new LoreScreen(g, g.getOverridenFilename("music/sl10.ogg"), g.getOverridenFilename("data/backgrounds/arenaboss2.jpg"), "event.caravan.duelplot3", 60000L) : new LoreScreen(g, g.getOverridenFilename("music/sl10.ogg"), g.getOverridenFilename("data/backgrounds/arenaboss2.jpg"), "event.caravan.duelplot4", 60000L));
            g.setScreen(g.loreScreen);
        } else if (type.equalsIgnoreCase("lore.9")) {
            g.loreScreen = g.saveGame.get("rewards").contains("slawor") ? (Story.getFactionValue(g, "facjus") > 0 ? new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundLore6.jpg"), "event.caravan.endplot1", 60000L) : new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundLore6.jpg"), "event.caravan.endplot2", 60000L)) : (Story.getFactionValue(g, "facjus") > 0 ? new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundLore6.jpg"), "event.caravan.endplot3", 60000L) : new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundLore6.jpg"), "event.caravan.endplot4", 60000L));
            g.setScreen(g.loreScreen);
        } else if (type.equalsIgnoreCase("lore.10")) {
            g.loreScreen = new LoreScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/fieryEyes.jpg"), "lore.10", 60000L);
            g.setScreen(g.loreScreen);
        } else if (type.equalsIgnoreCase("chapter.1")) {
            g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "zone.oldwarrior.chapter.1"), "FFFFFFFF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "event:lore.4;loretimer:2.0;fadein:1.0;", "sl17");
            g.setScreen(g.messageScreen);
        } else if (type.equalsIgnoreCase("chapter.2")) {
            g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "zone.oldwarrior.chapter.2"), "FFFFFFFF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "event:lore.7;loretimer:2.0;fadein:1.0;", "sl17");
            g.setScreen(g.messageScreen);
        } else if (type.equalsIgnoreCase("chapter.3")) {
            g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "zone.oldwarrior.chapter.3"), "FFFFFFFF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "event:lore.10;loretimer:2.0;fadein:1.0;", "sl17");
            g.setScreen(g.messageScreen);
        } else if (type.equalsIgnoreCase("chapter.4")) {
            g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "zone.oldwarrior.chapter.4"), "FFFFFFFF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "prep;loretimer:2.0;fadein:1.0;", "sl17");
            g.setScreen(g.messageScreen);
        }
    }

    public static boolean isValidCondition(SlavePitsGame g, String event, int choice) {
        if (event.equalsIgnoreCase("event.caravan.sit")) {
            if (choice == 1) {
                return Story.getFactionValue(g, "facwor") > -10;
            }
            if (choice == 2) {
                return Story.getFactionValue(g, "facwor") < 10;
            }
        }
        return true;
    }

    public static boolean checkRewardCondition(String condition, float lifeRatio, long timeLeft) {
        if (!condition.equalsIgnoreCase("")) {
            if (condition.startsWith("life")) {
                if (condition.contains("more")) {
                    return lifeRatio * 100.0f > (float)Integer.parseInt(condition.split(":")[2]);
                }
                return lifeRatio * 100.0f < (float)Integer.parseInt(condition.split(":")[2]);
            }
            if (condition.startsWith("time")) {
                if (condition.contains("more")) {
                    return timeLeft <= 0L;
                }
                return timeLeft > 0L;
            }
        }
        return true;
    }

    public static String checkRewardText(SlavePitsGame g, float lifeRatio, long timeLeft) {
        StringBuilder result = new StringBuilder();
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        if (fight != 13 && fight != 15 && fight != 17 && fight != 18 || g.saveGame.get("special") != null && g.saveGame.get("special").equalsIgnoreCase("combat")) {
            StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
            String currReward = StringList.get(rewards, 0, ";").replace(".combo", "").replace(".single", ".3");
            String choice = StringList.get(rewards, 1, ";");
            String prize = !currReward.equalsIgnoreCase("none") && !choice.equalsIgnoreCase("0") ? g.stats.get("story").getJSONObject("choices").getString(currReward + ".option" + choice) : "";
            String condition = !currReward.equalsIgnoreCase("none") && !choice.equalsIgnoreCase("0") ? g.stats.get("story").getJSONObject("choices").getString(currReward + ".condition" + choice) : "";
            StringBuilder currPrizes = StringList.create(prize, ";");
            for (int i = 0; i < StringList.size(currPrizes, ";"); ++i) {
                String currPrize = StringList.get(currPrizes, i, ";");
                if (currPrize.equalsIgnoreCase("suphot")) {
                    if (Story.getFactionValue(g, "facwor") >= 20) {
                        currPrize = g.saveGame.get("rewards").contains("suphfo") ? "suphir" : "suphfo";
                    } else if (Story.getFactionValue(g, "facwor") <= -20) {
                        currPrize = g.saveGame.get("rewards").contains("suphfo") ? "suphfi" : "suphfo";
                    } else {
                        String string = currPrize = g.saveGame.get("rewards").contains("suphfi") ? "suphir" : "suphfi";
                    }
                }
                if (currPrize.startsWith("probo1") && g.saveGame.get("rewards").contains("probo1")) {
                    currPrize = "lifbo1";
                }
                if (currPrize.startsWith("reppen") || currPrize.startsWith("fac") || currPrize.contains(":") || currPrize.startsWith("dourep") && !choice.equalsIgnoreCase("3") || !Story.checkRewardCondition(condition, lifeRatio, timeLeft)) continue;
                result.append("- ");
                result.append(PropertiesReader.getMessage(g.gameMessages, "journal.reward." + currPrize));
                result.append("\n");
            }
        }
        return result.toString();
    }

    public static float getRewardReputationPenalty(SlavePitsGame g) {
        float result = 1.0f;
        StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
        for (int i = 2; i < StringList.size(currRewards, ";"); ++i) {
            String currReward = StringList.get(currRewards, i, ";");
            if (!currReward.startsWith("reppen")) continue;
            return result - Float.parseFloat(currReward.split(":")[1]);
        }
        return result;
    }

    public static StringBuilder addCombatReward(SlavePitsGame g, StringBuilder rewards, String prize, String condition, float lifeRatio, long timeLeft) {
        StringBuilder currPrizes = StringList.create(prize, ";");
        block0: for (int i = 0; i < StringList.size(currPrizes, ";"); ++i) {
            String currReward;
            int j;
            String currPrize = StringList.get(currPrizes, i, ";");
            if (currPrize.startsWith("reppen") && Story.checkRewardCondition(condition, lifeRatio, timeLeft) && rewards.indexOf("reppen") >= 0) {
                for (j = 2; j < StringList.size(rewards, ";"); ++j) {
                    currReward = StringList.get(rewards, j, ";");
                    if (!currReward.startsWith("reppen")) continue;
                    float finalreppen = Float.parseFloat(currReward.split(":")[1]) + Float.parseFloat(currPrize.split(":")[1]);
                    rewards = StringList.set(rewards, j, "reppen:" + finalreppen, ";");
                    continue block0;
                }
                continue;
            }
            if (currPrize.startsWith("fac") && currPrize.contains(":")) {
                for (j = 2; j < StringList.size(rewards, ";"); ++j) {
                    currReward = StringList.get(rewards, j, ";");
                    if (!currReward.startsWith(currPrize.split(":")[0])) continue;
                    int finalfac = Integer.parseInt(currReward.split(":")[1]) + Integer.parseInt(currPrize.split(":")[1]);
                    rewards = StringList.set(rewards, j, currReward.split(":")[0] + ":" + finalfac, ";");
                    continue block0;
                }
                continue;
            }
            if (!Story.checkRewardCondition(condition, lifeRatio, timeLeft)) continue;
            if (currPrize.equalsIgnoreCase("suphot")) {
                if (Story.getFactionValue(g, "facwor") >= 20) {
                    currPrize = g.saveGame.get("rewards").contains("suphfo") ? "suphir" : "suphfo";
                } else if (Story.getFactionValue(g, "facwor") <= -20) {
                    currPrize = g.saveGame.get("rewards").contains("suphfo") ? "suphfi" : "suphfo";
                } else {
                    String string = currPrize = g.saveGame.get("rewards").contains("suphfi") ? "suphir" : "suphfi";
                }
            }
            if (currPrize.startsWith("probo1") && g.saveGame.get("rewards").contains("probo1")) {
                currPrize = "lifbo1";
            }
            rewards = StringList.append(rewards, currPrize, ";");
        }
        return rewards;
    }

    public static void applyEarnedRewards(SlavePitsGame g, Fighter fighter) {
        if (Story.isServiceFree(g, "shard")) {
            if (!fighter.services.equalsIgnoreCase("")) {
                fighter.services = fighter.services + ",";
            }
            fighter.services = fighter.services + "shard";
        }
        if (Story.isServiceFree(g, "upgradearmor")) {
            if (!fighter.services.equalsIgnoreCase("")) {
                fighter.services = fighter.services + ",";
            }
            fighter.services = fighter.services + "upgradearmor-1";
        }
        if (Story.isServiceFree(g, "upgradeweapon")) {
            if (!fighter.services.equalsIgnoreCase("")) {
                fighter.services = fighter.services + ",";
            }
            fighter.services = fighter.services + "upgradeweapon-1";
        }
        if (Story.isServiceFree(g, "choice")) {
            if (!fighter.services.equalsIgnoreCase("")) {
                fighter.services = fighter.services + ",";
            }
            fighter.services = fighter.services + "choice";
        }
        if (Story.isServiceFree(g, "info")) {
            if (!fighter.services.equalsIgnoreCase("")) {
                fighter.services = fighter.services + ",";
            }
            fighter.services = fighter.services + "info";
        }
    }

    public static void advancePlayer(SlavePitsGame g, int life, int initialLife, long timeLeft, int profits, String opponentName) {
        StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
        String currReward = StringList.get(currRewards, 0, ";").replace(".combo", "").replace(".single", ".3");
        String currChoice = StringList.get(currRewards, 1, ";");
        String currPrize = !currReward.equalsIgnoreCase("none") && !currChoice.equalsIgnoreCase("0") ? g.stats.get("story").getJSONObject("choices").getString(currReward + ".option" + currChoice) : "";
        String currCondition = !currReward.equalsIgnoreCase("none") && !currChoice.equalsIgnoreCase("0") ? g.stats.get("story").getJSONObject("choices").getString(currReward + ".condition" + currChoice) : "";
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        g.achievements.put(opponentName, "1");
        PropertiesReader.saveAchievements(g.achievements, g.mail, g.key, g.debugMode);
        if (fight == -1) {
            if (life <= 0) {
                g.saveGame.put("aftermatch", "gameover");
                return;
            }
            g.saveGame.put("fight", "0");
            g.saveGame.put("aftermatch", "lore.3");
            return;
        }
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            int reputationCap;
            if (life <= 0 && g.saveGame.get("legendary").equalsIgnoreCase("true")) {
                g.saveGame.put("aftermatch", "gameover");
                return;
            }
            if (fight == 8) {
                int reputationCap2;
                if (life <= 0) {
                    g.saveGame.put("aftermatch", "gameover");
                    return;
                }
                if (opponentName.equalsIgnoreCase("boss1")) {
                    int maxreputation = 50 + life / (initialLife / 100) / 2;
                    maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                    int reputationCap3 = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("pits")).getString("maxReputation"));
                    if ((maxreputation += g.campaignFighter.reputation) > reputationCap3) {
                        maxreputation = reputationCap3;
                    }
                    g.saveGame.put("maxreputation", "" + maxreputation);
                    g.saveGame.put("phase", "caravan");
                    Story.generateChapter(g);
                    g.saveGame.remove("delete");
                    g.saveGame.remove("special");
                    PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                    g.saveGame.put("aftermatch", "lore.6");
                    return;
                }
                Fighter newFighter = Fighter.clone(g.campaignFighter, false);
                newFighter.life = life;
                g.campaignFighter = newFighter;
                int maxreputation = 50 + life / (initialLife / 100) / 2;
                maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap2 = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("pits")).getString("maxReputation")))) {
                    maxreputation = reputationCap2;
                }
                g.campaignFighter.reputation = maxreputation;
                g.saveGame.put("aftermatch", "lore.5");
                return;
            }
            if (currPrize.equalsIgnoreCase("dourep") && currReward.contains(opponentName)) {
                if (life <= 0) {
                    g.saveGame.put("aftermatch", "gameover");
                    return;
                }
                g.campaignFighter.life = life;
                currRewards = StringList.set(currRewards, 1, "3", ";");
                g.saveGame.put("rewards", currRewards.toString());
                g.saveGame.put("aftermatch", "fight");
                return;
            }
            int maxreputation = 0;
            if (life <= 0) {
                int lost = Integer.parseInt(g.saveGame.get("lost"));
                g.saveGame.put("lost", "" + (lost + 1));
                g.saveGame.put("aftermatch", "gameover");
                g.saveGame.remove("delete");
                g.saveGame.remove("special");
                return;
            }
            g.saveGame.put("lost", "0");
            maxreputation = maxreputation + 50 + life / (initialLife / 100) / 2;
            g.saveGame.put("fight", "" + (fight + 1));
            if (currPrize.equalsIgnoreCase("dourep") && Story.checkRewardCondition(currCondition, (float)life / (float)initialLife, timeLeft)) {
                maxreputation += 75;
            }
            maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
            if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("pits")).getString("maxReputation")))) {
                maxreputation = reputationCap;
            }
            currRewards = Story.addCombatReward(g, currRewards, currPrize, currCondition, (float)life / (float)initialLife, timeLeft);
            g.saveGame.put("life", "" + life);
            g.saveGame.put("maxreputation", "" + maxreputation);
            if (StringList.indexOf(currRewards, "probo1", 0, ";") > 0 && fight == 7) {
                profits += 200;
            }
            g.saveGame.put("profits", "" + profits);
            if (!currReward.equalsIgnoreCase("none")) {
                String[] currEvents = g.saveGame.get("events").split(",");
                String finalEvents = "";
                String eventRemoved = "none";
                for (int i = 0; i < currEvents.length; ++i) {
                    if (i == fight - 1) {
                        if (fight < 4) {
                            if (currEvents[i].contains("min")) {
                                eventRemoved = "scala";
                            } else if (currEvents[i].contains("scala")) {
                                eventRemoved = "min";
                            } else if (currEvents[i].contains("diego")) {
                                eventRemoved = "boris";
                            } else if (currEvents[i].contains("boris")) {
                                eventRemoved = "diego";
                            } else if (currEvents[i].contains("ayla")) {
                                eventRemoved = "trent";
                            } else if (currEvents[i].contains("trent")) {
                                eventRemoved = "ayla";
                            } else if (currEvents[i].contains("onur")) {
                                eventRemoved = "zola";
                            } else if (currEvents[i].contains("zola")) {
                                eventRemoved = "onur";
                            }
                        }
                    } else if (currEvents[i].contains(eventRemoved)) {
                        currEvents[i] = "x";
                    }
                    finalEvents = finalEvents + currEvents[i] + ",";
                }
                finalEvents = finalEvents.substring(0, finalEvents.length() - 1);
                g.saveGame.put("events", finalEvents);
                currRewards = StringList.set(currRewards, 0, "none", ";");
                currRewards = StringList.set(currRewards, 1, "0", ";");
                g.saveGame.put("rewards", currRewards.toString());
            }
            g.saveGame.put("availableWeapons", "" + Story.getWeaponsAvailable(g));
            g.saveGame.remove("delete");
            g.saveGame.remove("special");
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
            g.saveGame.put("aftermatch", "day");
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            int reputationCap;
            if (life <= 0 && g.saveGame.get("legendary").equalsIgnoreCase("true")) {
                g.saveGame.put("aftermatch", "gameover");
                return;
            }
            if ((fight == 13 || fight == 15 || fight == 17 || fight == 18) && life <= 0) {
                g.saveGame.put("aftermatch", "gameover");
                return;
            }
            if (fight == 13) {
                if (opponentName.startsWith("randombandit") && currChoice.equalsIgnoreCase("1") && (g.saveGame.get("special") == null || !g.saveGame.get("special").equalsIgnoreCase("combat"))) {
                    int reputationCap4;
                    Fighter newFighter = Fighter.clone(g.campaignFighter, false);
                    newFighter.life = life;
                    g.campaignFighter = newFighter;
                    int maxreputation = 50 + life / (initialLife / 100) / 2;
                    maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                    if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap4 = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation")))) {
                        maxreputation = reputationCap4;
                    }
                    g.saveGame.put("maxreputation", "" + maxreputation);
                    StringBuilder currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                    currOpponents = StringList.set(currOpponents, fight, "randombandit:p291", ",");
                    g.saveGame.put("opponents", currOpponents.toString());
                    g.saveGame.put("special", "combat");
                    g.saveGame.put("aftermatch", "fight");
                    return;
                }
            } else if (fight == 15) {
                if (!(opponentName.equalsIgnoreCase("fenris") || opponentName.equalsIgnoreCase("none") || !currChoice.equalsIgnoreCase("1") || g.saveGame.get("special") != null && g.saveGame.get("special").equalsIgnoreCase("combat"))) {
                    int reputationCap5;
                    Fighter newFighter = Fighter.clone(g.campaignFighter, false);
                    newFighter.life = life;
                    g.campaignFighter = newFighter;
                    int maxreputation = 50 + life / (initialLife / 100) / 2;
                    maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                    if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap5 = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation")))) {
                        maxreputation = reputationCap5;
                    }
                    g.saveGame.put("maxreputation", "" + maxreputation);
                    StringBuilder currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                    currOpponents = StringList.set(currOpponents, fight, "fenris", ",");
                    g.saveGame.put("opponents", currOpponents.toString());
                    g.saveGame.put("special", "combat");
                    g.saveGame.put("aftermatch", "fight");
                    return;
                }
            } else if (fight == 17) {
                if (opponentName.startsWith("randomcrafter") && currReward.equalsIgnoreCase("event.caravan.bet") && currChoice.equalsIgnoreCase("1") && (g.saveGame.get("special") == null || !g.saveGame.get("special").equalsIgnoreCase("combat"))) {
                    int reputationCap6;
                    Fighter newFighter = Fighter.clone(g.campaignFighter, false);
                    newFighter.life = life;
                    g.campaignFighter = newFighter;
                    int maxreputation = 50 + life / (initialLife / 100) / 2;
                    maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                    if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap6 = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation")))) {
                        maxreputation = reputationCap6;
                    }
                    g.saveGame.put("maxreputation", "" + maxreputation);
                    StringBuilder currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                    currOpponents = StringList.set(currOpponents, fight, "roe", ",");
                    g.saveGame.put("opponents", currOpponents.toString());
                    g.saveGame.put("special", "combat");
                    g.saveGame.put("aftermatch", "fight");
                    return;
                }
            } else if (fight == 18) {
                int reputationCap7;
                if (opponentName.equalsIgnoreCase("boss2")) {
                    int maxreputation = 50 + life / (initialLife / 100) / 2;
                    maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                    int reputationCap8 = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation"));
                    if ((maxreputation += g.campaignFighter.reputation) > reputationCap8) {
                        maxreputation = reputationCap8;
                    }
                    g.saveGame.put("maxreputation", "" + maxreputation);
                    g.saveGame.put("phase", "coliseum");
                    Story.generateChapter(g);
                    g.saveGame.put("fight", "" + (fight + 2));
                    g.saveGame.remove("delete");
                    g.saveGame.remove("special");
                    PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                    g.saveGame.put("aftermatch", "lore.9");
                    return;
                }
                Fighter newFighter = Fighter.clone(g.campaignFighter, false);
                newFighter.life = life;
                g.campaignFighter = newFighter;
                int maxreputation = 50 + life / (initialLife / 100) / 2;
                maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap7 = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation")))) {
                    maxreputation = reputationCap7;
                }
                g.campaignFighter.reputation = maxreputation;
                g.saveGame.put("special", "combat");
                g.saveGame.put("aftermatch", "lore.8");
                return;
            }
            int maxreputation = 0;
            if (life <= 0) {
                int lost = Integer.parseInt(g.saveGame.get("lost"));
                g.saveGame.put("lost", "" + (lost + 1));
                g.saveGame.put("aftermatch", "gameover");
                g.saveGame.remove("delete");
                g.saveGame.remove("special");
                return;
            }
            g.saveGame.put("lost", "0");
            maxreputation = maxreputation + 50 + life / (initialLife / 100) / 2;
            g.saveGame.put("fight", "" + (fight + 1));
            if (currPrize.equalsIgnoreCase("dourep") && Story.checkRewardCondition(currCondition, (float)life / (float)initialLife, timeLeft)) {
                maxreputation += 75;
            }
            g.saveGame.put("lostDays", "" + (Integer.parseInt(g.saveGame.get("lostDays")) + (fight < 17 ? 2 : 0)));
            maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
            if (fight == 13 || fight == 17) {
                maxreputation += Integer.parseInt(g.saveGame.get("maxreputation")) - g.campaignFighter.reputation;
            }
            if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation")))) {
                maxreputation = reputationCap;
            }
            currRewards = Story.addCombatReward(g, currRewards, currPrize, currCondition, (float)life / (float)initialLife, timeLeft);
            g.saveGame.put("life", "" + life);
            g.saveGame.put("maxreputation", "" + maxreputation);
            if (fight != 13 && (fight != 14 || currChoice.equalsIgnoreCase("1"))) {
                if (StringList.indexOf(currRewards, "probo2", 0, ";") > 0 && fight == 17) {
                    profits += 200;
                }
                g.saveGame.put("profits", "" + profits);
            }
            if (!currReward.equalsIgnoreCase("none")) {
                currRewards = StringList.set(currRewards, 0, "none", ";");
                currRewards = StringList.set(currRewards, 1, "0", ";");
                g.saveGame.put("rewards", currRewards.toString());
            }
            g.saveGame.put("availableWeapons", "" + Story.getWeaponsAvailable(g));
            g.saveGame.remove("delete");
            g.saveGame.remove("special");
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
            g.saveGame.put("aftermatch", "day");
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            if (life <= 0 && (fight != 20 && g.saveGame.get("legendary").equalsIgnoreCase("true") || fight == 20 && opponentName.equalsIgnoreCase(StringList.get(new StringBuilder(g.saveGame.get("culling")), 0, "#")) || fight == 25 || fight == 26 && Story.getFactionValue(g, "facwor") < 20 && Story.getFactionValue(g, "facwor") > -20 || fight == 28 && Story.getFactionValue(g, "facwor") >= 20 || fight == 29 && Story.getFactionValue(g, "facwor") < 20 && Story.getFactionValue(g, "facwor") > -20 && Story.getFactionValue(g, "facjus") >= 20)) {
                g.saveGame.put("aftermatch", "gameover");
                return;
            }
            if (fight == 20) {
                if (life <= 0) {
                    g.saveGame.put("life", "5000");
                    g.saveGame.put("profits", "100");
                    g.saveGame.put("availableWeapons", "" + Story.getWeaponsAvailable(g));
                    g.saveGame.put("fight", "" + (fight + 1));
                    g.saveGame.put("lostDays", "" + (Integer.parseInt(g.saveGame.get("lostDays")) - 1));
                    g.saveGame.remove("delete");
                    g.saveGame.remove("special");
                    PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                    g.saveGame.put("aftermatch", "day");
                    return;
                }
                if (opponentName.equalsIgnoreCase(StringList.get(new StringBuilder(g.saveGame.get("culling")), 0, "#"))) {
                    int reputationCap;
                    Fighter newFighter = Fighter.clone(g.campaignFighter, false);
                    newFighter.life = life;
                    g.campaignFighter = newFighter;
                    int maxreputation = 50 + life / (initialLife / 100) / 2;
                    maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                    if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("coliseum")).getString("maxReputation")))) {
                        maxreputation = reputationCap;
                    }
                    g.saveGame.put("maxreputation", "" + maxreputation);
                    StringBuilder currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                    currOpponents = StringList.set(currOpponents, fight, StringList.get(new StringBuilder(g.saveGame.get("culling")), 1, "#"), ",");
                    g.saveGame.put("opponents", currOpponents.toString());
                    g.saveGame.put("special", "combat");
                    g.saveGame.put("aftermatch", "fight");
                    return;
                }
                if (opponentName.equalsIgnoreCase(StringList.get(new StringBuilder(g.saveGame.get("culling")), 1, "#"))) {
                    int reputationCap;
                    Fighter newFighter = Fighter.clone(g.campaignFighter, false);
                    newFighter.life = life;
                    g.campaignFighter = newFighter;
                    int maxreputation = 50 + life / (initialLife / 100) / 2;
                    maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                    if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("coliseum")).getString("maxReputation")))) {
                        maxreputation = reputationCap;
                    }
                    g.saveGame.put("maxreputation", "" + maxreputation);
                    StringBuilder currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                    currOpponents = StringList.set(currOpponents, fight, StringList.get(new StringBuilder(g.saveGame.get("culling")), 2, "#"), ",");
                    g.saveGame.put("opponents", currOpponents.toString());
                    g.saveGame.put("special", "combat");
                    g.saveGame.put("aftermatch", "fight");
                    return;
                }
                if (opponentName.equalsIgnoreCase(StringList.get(new StringBuilder(g.saveGame.get("culling")), 2, "#"))) {
                    int reputationCap;
                    int maxreputation = 50 + life / (initialLife / 100) / 2;
                    maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                    if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("coliseum")).getString("maxReputation")))) {
                        maxreputation = reputationCap;
                    }
                    g.saveGame.put("maxreputation", "" + maxreputation);
                    g.saveGame.put("life", "" + Math.max(life, 1000));
                    g.saveGame.put("profits", "200");
                    g.saveGame.put("availableWeapons", "" + Story.getWeaponsAvailable(g));
                    g.saveGame.put("fight", "" + (fight + 2));
                    g.saveGame.put("lostDays", "" + (Integer.parseInt(g.saveGame.get("lostDays")) - 1));
                    g.saveGame.remove("delete");
                    g.saveGame.remove("special");
                    PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                    g.saveGame.put("aftermatch", "day");
                    return;
                }
            } else {
                if (fight == 24 && (Story.getFactionValue(g, "facwor") >= 20 || Story.getFactionValue(g, "facwor") <= -20)) {
                    int reputationCap;
                    Fighter newFighter = Fighter.clone(g.campaignFighter, false);
                    newFighter.life = life;
                    g.campaignFighter = newFighter;
                    int maxreputation = 50 + life / (initialLife / 100) / 2;
                    maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                    if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("coliseum")).getString("maxReputation")))) {
                        maxreputation = reputationCap;
                    }
                    g.saveGame.put("maxreputation", "" + maxreputation);
                    g.saveGame.put("fight", "" + (fight + 1));
                    g.saveGame.put("lostDays", "" + (Integer.parseInt(g.saveGame.get("lostDays")) - 1));
                    g.saveGame.put("aftermatch", "event");
                    return;
                }
                if (fight == 26 && Story.getFactionValue(g, "facwor") < 20 && Story.getFactionValue(g, "facwor") > -20) {
                    int reputationCap;
                    int maxreputation = 50 + life / (initialLife / 100) / 2;
                    maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                    if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > (reputationCap = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("coliseum")).getString("maxReputation")))) {
                        maxreputation = reputationCap;
                    }
                    g.saveGame.put("maxreputation", "" + maxreputation);
                    g.saveGame.put("fight", "" + (fight + 1));
                    g.saveGame.put("lostDays", "" + (Integer.parseInt(g.saveGame.get("lostDays")) - 1));
                    g.saveGame.put("aftermatch", "event");
                    return;
                }
                if (fight == 28 && Story.getFactionValue(g, "facwor") < 20 && Story.getFactionValue(g, "facwor") > -20 && Story.getFactionValue(g, "facjus") >= 20) {
                    Fighter newFighter = Fighter.clone(g.campaignFighter, false);
                    newFighter.life = life;
                    if (newFighter.services.contains("potion")) {
                        newFighter.life += 20000;
                        if (newFighter.life > 10000) {
                            newFighter.life = 10000;
                        }
                    } else {
                        if (!newFighter.services.equalsIgnoreCase("")) {
                            newFighter.services = newFighter.services + ":";
                        }
                        newFighter.services = newFighter.services + "potion";
                        newFighter.life += 10000;
                        if (newFighter.life > 10000) {
                            newFighter.life = 10000;
                        }
                    }
                    newFighter.weapon.id = Tournament.getRandomWeapon("");
                    String string = MathUtils.random(2) == 0 ? "iron" : (newFighter.weapon.tier = MathUtils.random(2) == 0 ? "caparace" : "wood");
                    if (!g.stats.get("weapons").getJSONObject(newFighter.weapon.id).getString("type").startsWith("2")) {
                        newFighter.offHand = new Equipment();
                        newFighter.offHand.id = Tournament.getRandomWeapon("oh");
                        newFighter.offHand.tier = newFighter.weapon.tier;
                    } else {
                        newFighter.offHand = null;
                    }
                    g.campaignFighter = newFighter;
                    int maxreputation = 50 + life / (initialLife / 100) / 2;
                    maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
                    int reputationCap = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("coliseum")).getString("maxReputation"));
                    if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > reputationCap) {
                        maxreputation = reputationCap;
                    }
                    g.saveGame.put("maxreputation", "" + maxreputation);
                    g.saveGame.put("fight", "" + (fight + 1));
                    g.saveGame.put("lostDays", "" + (Integer.parseInt(g.saveGame.get("lostDays")) - 1));
                    g.saveGame.put("aftermatch", "event");
                    return;
                }
            }
            int maxreputation = 0;
            if (life <= 0) {
                int lost = Integer.parseInt(g.saveGame.get("lost"));
                g.saveGame.put("lost", "" + (lost + 1));
                g.saveGame.put("aftermatch", "gameover");
                g.saveGame.remove("delete");
                g.saveGame.remove("special");
                return;
            }
            g.saveGame.put("lost", "0");
            maxreputation = maxreputation + 50 + life / (initialLife / 100) / 2;
            g.saveGame.put("fight", "" + (fight + 1));
            if (fight == 24 && Story.getFactionValue(g, "facwor") < 20 && Story.getFactionValue(g, "facwor") > -20) {
                g.saveGame.put("fight", "" + (fight + 2));
                g.saveGame.put("lostDays", "" + (Integer.parseInt(g.saveGame.get("lostDays")) - 1));
            }
            g.saveGame.put("lostDays", "" + (Integer.parseInt(g.saveGame.get("lostDays")) + 1));
            maxreputation = Float.valueOf((float)maxreputation * Story.getRewardReputationPenalty(g)).intValue();
            int reputationCap = Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("coliseum")).getString("maxReputation"));
            if ((maxreputation += Integer.parseInt(g.saveGame.get("maxreputation"))) > reputationCap) {
                maxreputation = reputationCap;
            }
            currRewards = Story.addCombatReward(g, currRewards, currPrize, currCondition, (float)life / (float)initialLife, timeLeft);
            g.saveGame.put("life", "" + life);
            g.saveGame.put("maxreputation", "" + maxreputation);
            g.saveGame.put("profits", "" + profits);
            if (!currReward.equalsIgnoreCase("none")) {
                currRewards = StringList.set(currRewards, 0, "none", ";");
                currRewards = StringList.set(currRewards, 1, "0", ";");
                g.saveGame.put("rewards", currRewards.toString());
            }
            g.saveGame.put("availableWeapons", "" + Story.getWeaponsAvailable(g));
            g.saveGame.remove("delete");
            g.saveGame.remove("special");
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
            g.saveGame.put("aftermatch", "day");
        }
    }

    public static void loadState(SlavePitsGame g) {
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            g.prepSetupScreen = new PrepSetupScreen(g, Integer.parseInt(g.saveGame.get("life")), Integer.parseInt(g.saveGame.get("profits")));
            g.setScreen(g.prepSetupScreen);
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            if (g.saveGame.get("fighter") != null) {
                g.campaignFighter = Fighter.stringToFighter(g.saveGame.get("fighter"));
            }
            Story.getNextEvent(g);
        } else {
            if (g.saveGame.get("fighter") != null) {
                g.campaignFighter = Fighter.stringToFighter(g.saveGame.get("fighter"));
            }
            if (g.saveGame.get("fight").equalsIgnoreCase("20")) {
                Story.getFixedEvent(g, "lore.10");
            } else {
                Story.getNextEvent(g);
            }
        }
    }
}

