/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.game;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.MathUtils;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.game.Effect;
import com.calimasaga.slavepits.game.Equipment;
import com.calimasaga.slavepits.util.Logger;
import com.calimasaga.slavepits.util.StringList;
import java.util.ArrayList;
import java.util.HashMap;

public class Fighter {
    public String portrait = "";
    public String bodyType = "1";
    public String skinType = "1";
    public String bodySubType = "1";
    public String armsType = "1";
    public String headType = "1";
    public String accessoryTypes = "";
    public String skinColor = "";
    public String bodyColor = "";
    public String accessoryColor = "";
    public String size = "1.0";
    public String name = "";
    public String behavior = "";
    public String hurt = "1:0.5";
    public String special = "";
    public Equipment weapon = null;
    public Equipment offHand = null;
    public Equipment body = null;
    public Equipment head = null;
    public Equipment arms = null;
    public HashMap<String, Integer> talents = new HashMap();
    public HashMap<String, Integer> talentsBlocked = new HashMap();
    public String services = "";
    public int reputation = 0;
    public int itemUses = 0;
    public boolean isPlayer = false;
    public boolean isHost = false;
    public StringBuilder buffs = new StringBuilder();
    public StringBuilder debuffs = new StringBuilder();
    public ArrayList<Effect> effects = new ArrayList();
    public ArrayList<String> knownCombos = new ArrayList();
    public String comboStage = "";
    public int life = 10000;
    public int maxLife = 10000;
    public int balance = 10000;
    public int maxBalance = 10000;
    public int stamina = 10000;
    public int maxStamina = 10000;
    public int surge = 0;
    public int preCalculatedCriticalChance = 0;
    public int preCalculatedDamageReduction = 0;

    public static String fighterToString(Fighter fighterToConvert) {
        StringBuilder result = new StringBuilder();
        if (fighterToConvert != null) {
            result.append(fighterToConvert.portrait);
            result.append(",");
            result.append(fighterToConvert.bodyType);
            result.append(",");
            result.append(fighterToConvert.skinType);
            result.append(",");
            result.append(fighterToConvert.bodySubType);
            result.append(",");
            result.append(fighterToConvert.armsType);
            result.append(",");
            result.append(fighterToConvert.headType);
            result.append(",");
            result.append(fighterToConvert.accessoryTypes);
            result.append(",");
            result.append(fighterToConvert.skinColor);
            result.append(",");
            result.append(fighterToConvert.bodyColor);
            result.append(",");
            result.append(fighterToConvert.accessoryColor);
            result.append(",");
            result.append(fighterToConvert.size);
            result.append(",");
            result.append(fighterToConvert.hurt);
            result.append(",");
            result.append(fighterToConvert.special);
            result.append(",");
            result.append(fighterToConvert.name);
            result.append(";");
            result.append(fighterToConvert.life);
            result.append(";");
            result.append(fighterToConvert.maxLife);
            result.append(";");
            result.append(fighterToConvert.maxStamina);
            result.append(";");
            result.append(fighterToConvert.maxBalance);
            result.append(";");
            if (fighterToConvert.weapon != null) {
                result.append(fighterToConvert.weapon.id);
                result.append(",");
                result.append(fighterToConvert.weapon.tier);
            } else {
                result.append("e");
            }
            result.append(";");
            if (fighterToConvert.offHand != null) {
                result.append(fighterToConvert.offHand.id);
                result.append(",");
                result.append(fighterToConvert.offHand.tier);
            } else {
                result.append("e");
            }
            result.append(";");
            if (fighterToConvert.body != null) {
                result.append(fighterToConvert.body.id);
                result.append(",");
                result.append(fighterToConvert.body.tier);
            } else {
                result.append("e");
            }
            result.append(";");
            if (fighterToConvert.head != null) {
                result.append(fighterToConvert.head.id);
                result.append(",");
                result.append(fighterToConvert.head.tier);
            } else {
                result.append("e");
            }
            result.append(";");
            if (fighterToConvert.arms != null) {
                result.append(fighterToConvert.arms.id);
                result.append(",");
                result.append(fighterToConvert.arms.tier);
            } else {
                result.append("e");
            }
            result.append(";");
            if (!fighterToConvert.talents.isEmpty()) {
                for (String currTalent : fighterToConvert.talents.keySet()) {
                    result.append(currTalent);
                    result.append(":");
                    result.append(fighterToConvert.talents.get(currTalent));
                    result.append(",");
                }
                result.setLength(result.length() - 1);
            } else {
                result.append("e");
            }
            result.append(";");
            if (!fighterToConvert.talentsBlocked.isEmpty()) {
                for (String currTalent : fighterToConvert.talentsBlocked.keySet()) {
                    result.append(currTalent);
                    result.append(":");
                    result.append(fighterToConvert.talentsBlocked.get(currTalent));
                    result.append(",");
                }
                result.setLength(result.length() - 1);
            } else {
                result.append("e");
            }
            result.append(";");
            if (!fighterToConvert.services.equalsIgnoreCase("")) {
                result.append(fighterToConvert.services);
            } else {
                result.append("e");
            }
            result.append(";");
        }
        Logger.write(Logger.DEBUG, "Fighter.fighterToString " + result);
        return result.toString();
    }

    public static Fighter stringToFighter(String convertedFighter) {
        Fighter result = new Fighter();
        Logger.write(Logger.DEBUG, "Fighter.stringToFighter " + convertedFighter);
        if (!convertedFighter.equalsIgnoreCase("")) {
            String[] fighterData = convertedFighter.split(";");
            if (!fighterData[0].equalsIgnoreCase("")) {
                String[] style = fighterData[0].split(",", -1);
                result.portrait = style[0];
                result.bodyType = style[1];
                result.skinType = style[2];
                result.bodySubType = style[3];
                result.armsType = style[4];
                result.headType = style[5];
                result.accessoryTypes = style[6];
                result.skinColor = style[7];
                result.bodyColor = style[8];
                result.accessoryColor = style[9];
                result.size = style[10];
                result.hurt = style[11];
                result.special = style[12];
                result.name = style[13];
            }
            result.life = Integer.parseInt(fighterData[1]);
            result.maxLife = Integer.parseInt(fighterData[2]);
            result.maxStamina = Integer.parseInt(fighterData[3]);
            result.maxBalance = Integer.parseInt(fighterData[4]);
            if (!fighterData[5].equalsIgnoreCase("e")) {
                result.weapon = new Equipment();
                result.weapon.id = fighterData[5].split(",")[0];
                result.weapon.tier = fighterData[5].split(",")[1];
            }
            if (!fighterData[6].equalsIgnoreCase("e")) {
                result.offHand = new Equipment();
                result.offHand.id = fighterData[6].split(",")[0];
                result.offHand.tier = fighterData[6].split(",")[1];
            }
            if (!fighterData[7].equalsIgnoreCase("e")) {
                result.body = new Equipment();
                result.body.id = fighterData[7].split(",")[0];
                result.body.tier = fighterData[7].split(",")[1];
            }
            if (!fighterData[8].equalsIgnoreCase("e")) {
                result.head = new Equipment();
                result.head.id = fighterData[8].split(",")[0];
                result.head.tier = fighterData[8].split(",")[1];
            }
            if (!fighterData[9].equalsIgnoreCase("e")) {
                result.arms = new Equipment();
                result.arms.id = fighterData[9].split(",")[0];
                result.arms.tier = fighterData[9].split(",")[1];
            }
            if (!fighterData[10].equalsIgnoreCase("e")) {
                for (String currTalent : fighterData[10].split(",")) {
                    result.talents.put(currTalent.split(":")[0], Integer.parseInt(currTalent.split(":")[1]));
                }
            }
            if (!fighterData[11].equalsIgnoreCase("e")) {
                for (String currTalent : fighterData[11].split(",")) {
                    result.talentsBlocked.put(currTalent.split(":")[0], Integer.parseInt(currTalent.split(":")[1]));
                }
            }
            if (!fighterData[12].equalsIgnoreCase("e")) {
                result.services = fighterData[12];
            }
        }
        return result;
    }

    public static Fighter createOpponent(SlavePitsGame game, String opponent, int maxReputation, boolean isTournament) {
        Fighter result = new Fighter();
        JSONObject opponentData = isTournament ? (JSONObject)game.stats.get("tournament").getJSONObject("characters").get(opponent) : (JSONObject)game.stats.get("opponents").get(opponent);
        result.name = opponent;
        result.portrait = opponentData.getString("portrait");
        result.bodyType = opponentData.getString("bodyType");
        if (result.bodyType.contains("#")) {
            result.bodyType = !game.saveGame.isEmpty() && !game.saveGame.get("phase").equalsIgnoreCase("pits") ? result.bodyType.split("#")[1] : result.bodyType.split("#")[0];
        }
        result.skinType = game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(result.bodyType).getString("skinType");
        result.bodySubType = opponentData.getString("bodySubType");
        result.armsType = opponentData.getString("armsType");
        result.headType = opponentData.getString("headType");
        result.accessoryTypes = opponentData.getString("accessoryTypes");
        if (result.accessoryTypes.contains("#")) {
            result.accessoryTypes = !game.saveGame.isEmpty() && !game.saveGame.get("phase").equalsIgnoreCase("pits") ? result.accessoryTypes.split("#")[1] : result.accessoryTypes.split("#")[0];
        }
        if (result.accessoryTypes.contains(";")) {
            result.accessoryTypes = !game.saveGame.isEmpty() && !game.saveGame.get("phase").equalsIgnoreCase("") ? (game.saveGame.get("phase").equalsIgnoreCase("coliseum") ? result.accessoryTypes.split(";")[result.accessoryTypes.split(":").length - 1] : (!game.saveGame.get("phase").equalsIgnoreCase("caravan") ? result.accessoryTypes.split(";")[MathUtils.clamp(result.accessoryTypes.split(":").length - 1, 0, 1)] : result.accessoryTypes.split(";")[0])) : result.accessoryTypes.split(";")[MathUtils.random(result.accessoryTypes.split(":").length - 1)];
        }
        result.skinColor = game.stats.get("parts").getJSONObject("portraits").getJSONObject(result.portrait).getString("skinColor");
        result.bodyColor = game.stats.get("parts").getJSONObject("portraits").getJSONObject(result.portrait).getString("bodyColor");
        result.accessoryColor = game.stats.get("parts").getJSONObject("portraits").getJSONObject(result.portrait).getString("accessoryColor");
        result.size = game.stats.get("parts").getJSONObject("portraits").getJSONObject(result.portrait).getString("size");
        result.hurt = game.stats.get("parts").getJSONObject("portraits").getJSONObject(result.portrait).getString("hurt");
        result = Fighter.updateSpecials(game, result, isTournament);
        if (opponentData.has("maxLife") && !opponentData.getString("maxLife").equalsIgnoreCase("")) {
            result.maxLife = Integer.parseInt(opponentData.getString("maxLife"));
        }
        if (opponentData.has("maxStamina") && !opponentData.getString("maxStamina").equalsIgnoreCase("")) {
            result.maxStamina = Integer.parseInt(opponentData.getString("maxStamina"));
        }
        if (opponentData.has("maxBalance") && !opponentData.getString("maxBalance").equalsIgnoreCase("")) {
            result.maxBalance = Integer.parseInt(opponentData.getString("maxBalance"));
        }
        result.behavior = opponentData.getString("behavior");
        if (!opponentData.getString("equipment").split(":")[0].equalsIgnoreCase("empty")) {
            result.weapon = new Equipment();
            result.weapon.id = opponentData.getString("equipment").split(":")[0];
            result.weapon.tier = "wood";
        }
        if (!opponentData.getString("equipment").split(":")[1].equalsIgnoreCase("empty")) {
            result.offHand = new Equipment();
            result.offHand.id = opponentData.getString("equipment").split(":")[1];
            result.offHand.tier = "wood";
        }
        if (!opponentData.getString("equipment").split(":")[2].equalsIgnoreCase("empty")) {
            result.body = new Equipment();
            result.body.id = opponentData.getString("equipment").split(":")[2];
            result.body.tier = "wood";
        }
        if (!opponentData.getString("equipment").split(":")[3].equalsIgnoreCase("empty")) {
            result.head = new Equipment();
            result.head.id = opponentData.getString("equipment").split(":")[3];
            result.head.tier = "wood";
        }
        if (!opponentData.getString("equipment").split(":")[4].equalsIgnoreCase("empty")) {
            result.arms = new Equipment();
            result.arms.id = opponentData.getString("equipment").split(":")[4];
            result.arms.tier = "wood";
        }
        String build = opponentData.getString("build");
        for (int currReputation = 0; (result.reputation < maxReputation || maxReputation == 0) && currReputation < build.split("#").length; ++currReputation) {
            String currBuildStep = build.split("#")[currReputation];
            if (currBuildStep.startsWith("tal")) {
                String currTalent = currBuildStep.split(";")[1];
                int currLevel = -1;
                if (currTalent.contains(":")) {
                    currLevel = Integer.parseInt(currTalent.split(":")[1]);
                    currTalent = currTalent.split(":")[0];
                }
                result.talents.put(currTalent, currLevel);
                int reputationCost = Integer.parseInt(((JSONObject)game.stats.get("talents").get(currBuildStep.split(";")[1])).getString("reputationCost"));
                result.reputation += reputationCost;
                continue;
            }
            if (!currBuildStep.startsWith("ser")) continue;
            String currService = currBuildStep.split(";")[1].substring(0, 2);
            String currValue = currBuildStep.split(";")[1].substring(2, 3);
            if (!result.services.equalsIgnoreCase("")) {
                result.services = result.services + ":";
            }
            if (currService.equalsIgnoreCase("eq")) {
                int currMultiplier;
                int serviceMultiplierPosition;
                if (currValue.equalsIgnoreCase("w")) {
                    result.weapon.upgradeTier();
                    if (result.offHand != null) {
                        result.offHand.tier = result.weapon.tier;
                    }
                    if (result.services.contains("upgradeweapon")) {
                        serviceMultiplierPosition = result.services.indexOf("upgradeweapon") + "upgradeweapon".length() + 1;
                        currMultiplier = Integer.parseInt(result.services.substring(serviceMultiplierPosition, serviceMultiplierPosition + 1)) + 1;
                        result.services = result.services.substring(0, serviceMultiplierPosition) + currMultiplier + result.services.substring(serviceMultiplierPosition + 2);
                    } else {
                        result.services = result.services + "upgradeweapon-1";
                    }
                } else {
                    if (currValue.equalsIgnoreCase("b")) {
                        result.body.upgradeTier();
                    } else if (currValue.equalsIgnoreCase("a")) {
                        result.arms.upgradeTier();
                    } else if (currValue.equalsIgnoreCase("h")) {
                        result.head.upgradeTier();
                    }
                    if (result.services.contains("upgradearmor")) {
                        serviceMultiplierPosition = result.services.indexOf("upgradearmor") + "upgradearmor".length() + 1;
                        currMultiplier = Integer.parseInt(result.services.substring(serviceMultiplierPosition, serviceMultiplierPosition + 1)) + 1;
                        result.services = result.services.substring(0, serviceMultiplierPosition) + currMultiplier + result.services.substring(serviceMultiplierPosition + 2);
                    } else {
                        result.services = result.services + "upgradearmor-1";
                    }
                    result.reputation -= 50;
                }
            } else if (currService.equalsIgnoreCase("it")) {
                if (currValue.equalsIgnoreCase("s")) {
                    result.services = result.services + "shard";
                } else if (currValue.equalsIgnoreCase("p")) {
                    result.services = result.services + "powder";
                } else if (currValue.equalsIgnoreCase("n")) {
                    result.services = result.services + "net";
                }
            } else if (currService.equalsIgnoreCase("ot") && currValue.equalsIgnoreCase("p")) {
                result.services = result.services + "potion";
            }
            result.reputation += 100;
        }
        if (isTournament) {
            String talentsBlocked = opponentData.getString("talentsBlocked");
            for (String currTalent : talentsBlocked.split(";")) {
                if (currTalent.contains(":")) {
                    if (result.talentsBlocked.get(currTalent.substring(0, 1)) != null && result.talentsBlocked.get(currTalent.substring(0, 1)) <= Integer.parseInt(currTalent.substring(2, 3))) continue;
                    result.talentsBlocked.put(currTalent.substring(0, 1), Integer.parseInt(currTalent.substring(2, 3)));
                    continue;
                }
                result.talentsBlocked.put(currTalent, 1);
            }
        }
        return result;
    }

    public static Fighter updateSpecials(SlavePitsGame g, Fighter fighter, boolean isTournament) {
        Fighter result = Fighter.clone(fighter, true);
        result.special = "";
        if (isTournament) {
            if (g.stats.get("tournament").getJSONObject("characters").has(result.name)) {
                JSONObject opponentData = (JSONObject)g.stats.get("tournament").getJSONObject("characters").get(result.name);
                result.special = opponentData.getString("special");
            }
        } else if (g.stats.get("opponents").has(result.name)) {
            JSONObject opponentData = (JSONObject)g.stats.get("opponents").get(result.name);
            result.special = opponentData.getString("special");
        }
        if (!g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(result.bodyType).getString("special").equalsIgnoreCase("")) {
            if (!result.special.equalsIgnoreCase("")) {
                result.special = result.special + "-";
            }
            result.special = result.special + g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(result.bodyType).getString("special");
        }
        if (!g.stats.get("parts").getJSONObject("portraits").getJSONObject(result.portrait).getString("special").equalsIgnoreCase("")) {
            if (!result.special.equalsIgnoreCase("")) {
                result.special = result.special + "-";
            }
            result.special = result.special + g.stats.get("parts").getJSONObject("portraits").getJSONObject(result.portrait).getString("special");
        }
        return result;
    }

    public static Fighter changeAppearance(SlavePitsGame g, String portraitName, Fighter fighter, boolean isTournament, boolean full) {
        Fighter result = Fighter.clone(fighter, true);
        result.portrait = portraitName;
        result.skinColor = g.stats.get("parts").getJSONObject("portraits").getJSONObject(portraitName).getString("skinColor");
        result.bodyColor = g.stats.get("parts").getJSONObject("portraits").getJSONObject(portraitName).getString("bodyColor");
        result.accessoryColor = g.stats.get("parts").getJSONObject("portraits").getJSONObject(portraitName).getString("accessoryColor");
        result.size = g.stats.get("parts").getJSONObject("portraits").getJSONObject(portraitName).getString("size");
        result.hurt = g.stats.get("parts").getJSONObject("portraits").getJSONObject(portraitName).getString("hurt");
        result = Fighter.updateSpecials(g, result, isTournament);
        if (!isTournament && full) {
            JSONObject opponentData = (JSONObject)g.stats.get("opponents").get(Fighter.getNameByPortrait(g, portraitName));
            result.bodyType = opponentData.getString("bodyType");
            if (result.bodyType.contains("#")) {
                result.bodyType = !g.saveGame.isEmpty() && !g.saveGame.get("phase").equalsIgnoreCase("pits") ? result.bodyType.split("#")[1] : result.bodyType.split("#")[0];
            }
            result.skinType = g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(result.bodyType).getString("skinType");
            result.bodySubType = opponentData.getString("bodySubType");
            result.armsType = opponentData.getString("armsType");
            result.headType = opponentData.getString("headType");
            result.accessoryTypes = opponentData.getString("accessoryTypes");
            if (result.accessoryTypes.contains("#")) {
                result.accessoryTypes = !g.saveGame.isEmpty() && !g.saveGame.get("phase").equalsIgnoreCase("pits") ? result.accessoryTypes.split("#")[1] : result.accessoryTypes.split("#")[0];
            }
            if (result.accessoryTypes.contains(";")) {
                result.accessoryTypes = !g.saveGame.isEmpty() && !g.saveGame.get("phase").equalsIgnoreCase("") ? (g.saveGame.get("phase").equalsIgnoreCase("coliseum") ? result.accessoryTypes.split(";")[result.accessoryTypes.split(":").length - 1] : (!g.saveGame.get("phase").equalsIgnoreCase("caravan") ? result.accessoryTypes.split(";")[MathUtils.clamp(result.accessoryTypes.split(":").length - 1, 0, 1)] : result.accessoryTypes.split(";")[0])) : result.accessoryTypes.split(";")[MathUtils.random(result.accessoryTypes.split(":").length - 1)];
            }
        }
        return result;
    }

    public static String getNameByPortrait(SlavePitsGame g, String portrait) {
        String result = "";
        if (portrait.equalsIgnoreCase("p231")) {
            portrait = "p230";
        }
        if (portrait.equalsIgnoreCase("p281") || portrait.equalsIgnoreCase("p282")) {
            portrait = "p280";
        }
        if (portrait.equalsIgnoreCase("p291")) {
            portrait = "p290";
        }
        for (String currOpponent : g.stats.get("opponents").keySet()) {
            if (!((JSONObject)g.stats.get("opponents").get(currOpponent)).getString("portrait").equalsIgnoreCase(portrait)) continue;
            result = currOpponent;
            break;
        }
        return result;
    }

    public static String getTalentsString(HashMap<String, Integer> talents) {
        StringBuilder result = new StringBuilder();
        if (!talents.isEmpty()) {
            for (String currTalent : talents.keySet()) {
                result.append(currTalent);
                result.append(":");
                result.append(talents.get(currTalent));
                result.append(",");
            }
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    public static HashMap<String, Integer> getTalentsHashMap(String talents) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (!talents.equalsIgnoreCase("")) {
            for (String currTalent : talents.split(",")) {
                result.put(currTalent.split(":")[0], Integer.parseInt(currTalent.split(":")[1]));
            }
        }
        return result;
    }

    public static int calculateCurrentReputation(SlavePitsGame g, Fighter fighter) {
        int reputation = 0;
        for (String currTalent : fighter.talents.keySet()) {
            int currTalentId = Integer.parseInt(currTalent);
            int currTalentLevel = fighter.talents.get(currTalent);
            if (currTalentLevel > 0) {
                for (int i = 0; i < currTalentLevel; ++i) {
                    int reputationCost = Integer.parseInt(((JSONObject)g.stats.get("talents").get(currTalent + ":" + (currTalentLevel - i))).getString("reputationCost"));
                    reputation += reputationCost;
                }
                continue;
            }
            int reputationCost = Integer.parseInt(((JSONObject)g.stats.get("talents").get(currTalent)).getString("reputationCost"));
            reputation += reputationCost;
        }
        return reputation;
    }

    public static int getMaxTierNumber(Fighter fighter, String type) {
        int result = 0;
        if (fighter.head != null && !type.equalsIgnoreCase("weapon")) {
            if (fighter.head.tier.equalsIgnoreCase("iron")) {
                result += 102;
            } else if (fighter.head.tier.equalsIgnoreCase("caparace")) {
                result += 11;
            }
        }
        if (fighter.arms != null && !type.equalsIgnoreCase("weapon")) {
            if (fighter.arms.tier.equalsIgnoreCase("iron")) {
                result += 102;
            } else if (fighter.arms.tier.equalsIgnoreCase("caparace")) {
                result += 11;
            }
        }
        if (fighter.body != null && !type.equalsIgnoreCase("weapon")) {
            if (fighter.body.tier.equalsIgnoreCase("iron")) {
                result += 102;
            } else if (fighter.body.tier.equalsIgnoreCase("caparace")) {
                result += 11;
            }
        }
        if (fighter.weapon != null && !type.equalsIgnoreCase("armor")) {
            if (fighter.weapon.tier.equalsIgnoreCase("iron")) {
                result += 102;
            } else if (fighter.weapon.tier.equalsIgnoreCase("caparace")) {
                result += 11;
            }
        }
        return result;
    }

    public static int getDiffTierNumber(Fighter fighter, String type, String targetTier, int minLevel) {
        int result = 0;
        int targetLevel = Equipment.tierLevel(targetTier);
        if (type.equalsIgnoreCase("head")) {
            return targetLevel - MathUtils.clamp(Equipment.tierLevel(fighter.head), minLevel, 5);
        }
        if (type.equalsIgnoreCase("arms")) {
            return targetLevel - MathUtils.clamp(Equipment.tierLevel(fighter.arms), minLevel, 5);
        }
        if (type.equalsIgnoreCase("body")) {
            return targetLevel - MathUtils.clamp(Equipment.tierLevel(fighter.body), minLevel, 5);
        }
        if (type.equalsIgnoreCase("weapon")) {
            return targetLevel - MathUtils.clamp(Equipment.tierLevel(fighter.weapon), minLevel, 5);
        }
        if (type.equalsIgnoreCase("offHand")) {
            return targetLevel - MathUtils.clamp(Equipment.tierLevel(fighter.offHand), minLevel, 5);
        }
        return result;
    }

    public static Fighter clone(Fighter fighter, boolean full) {
        Fighter result = null;
        if (fighter != null) {
            result = new Fighter();
            result.portrait = fighter.portrait;
            result.bodyType = fighter.bodyType;
            result.bodySubType = fighter.bodySubType;
            result.skinType = fighter.skinType;
            result.armsType = fighter.armsType;
            result.headType = fighter.headType;
            result.accessoryTypes = fighter.accessoryTypes;
            result.skinColor = fighter.skinColor;
            result.bodyColor = fighter.bodyColor;
            result.accessoryColor = fighter.accessoryColor;
            result.size = fighter.size;
            result.hurt = fighter.hurt;
            result.special = fighter.special;
            result.name = fighter.name;
            result.maxLife = fighter.maxLife;
            result.maxStamina = fighter.maxStamina;
            result.maxBalance = fighter.maxBalance;
            result.behavior = fighter.behavior;
            result.weapon = Equipment.clone(fighter.weapon);
            result.offHand = Equipment.clone(fighter.offHand);
            result.body = Equipment.clone(fighter.body);
            result.head = Equipment.clone(fighter.head);
            result.arms = Equipment.clone(fighter.arms);
            result.talents = (HashMap)fighter.talents.clone();
            result.talentsBlocked = (HashMap)fighter.talentsBlocked.clone();
            result.services = fighter.services;
            result.reputation = fighter.reputation;
            result.isPlayer = fighter.isPlayer;
            if (full) {
                result.buffs = new StringBuilder(fighter.buffs);
                result.debuffs = new StringBuilder(fighter.debuffs);
                result.effects = (ArrayList)fighter.effects.clone();
                result.knownCombos = (ArrayList)fighter.knownCombos.clone();
                result.comboStage = fighter.comboStage;
                result.life = fighter.life;
                result.balance = fighter.balance;
                result.surge = fighter.surge;
                result.stamina = fighter.stamina;
                result.itemUses = fighter.itemUses;
                result.preCalculatedCriticalChance = fighter.preCalculatedCriticalChance;
                result.preCalculatedDamageReduction = fighter.preCalculatedDamageReduction;
            }
        }
        return result;
    }

    public static void loadFighterAssets(SlavePitsGame g, Fighter fighter, boolean client, boolean onlyIdle) {
        if (client) {
            g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.skinType + fighter.bodySubType + "skin.png"), Texture.class);
            g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + fighter.bodySubType + ".png"), Texture.class);
            StringBuilder chosenAccessories = StringList.create(fighter.accessoryTypes, ":");
            for (int i = 0; i < StringList.size(chosenAccessories, ":"); ++i) {
                g.manager.load(g.getOverridenFilename("data/figures/bodycomp" + fighter.bodyType + "" + fighter.bodySubType + StringList.get(chosenAccessories, i, ":") + ".png"), Texture.class);
            }
            if (fighter.head != null && !fighter.special.contains("nohel")) {
                g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.headType + fighter.portrait + g.stats.get("tiers").getJSONObject(fighter.head.tier).getString("imageSuffix") + ".png"), Texture.class);
            } else {
                g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.headType + fighter.portrait + ".png"), Texture.class);
            }
            String suffix = "idle";
            String weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h1";
            }
            if (!weaponType.equalsIgnoreCase("1h")) {
                g.manager.load(g.getOverridenFilename("data/figures/arms1hright1.png"), Texture.class);
                g.manager.load(g.getOverridenFilename("data/figures/arms1hhit1.png"), Texture.class);
            }
            g.manager.load(g.getOverridenFilename("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
            if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                if (!fighter.special.contains("noaasl")) {
                    g.manager.load(g.getOverridenFilename("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                }
                if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                    g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                    if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                    if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                }
            }
            if (fighter.body != null) {
                if (!fighter.special.contains("nocut")) {
                    g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + fighter.bodySubType + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                }
                if (!fighter.special.contains("nocul")) {
                    g.manager.load(g.getOverridenFilename("data/figures/armorbodyl" + fighter.bodyType + fighter.bodySubType + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                }
            }
            if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"), Texture.class);
                if (fighter.body != null && !fighter.special.contains("nocut")) {
                    g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                }
            }
            if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"), Texture.class);
                if (fighter.body != null && !fighter.special.contains("nocut")) {
                    g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                }
            }
            if (fighter.offHand != null) {
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
            }
            g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
            if (!onlyIdle) {
                suffix = "parry";
                weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
                if (weaponType.equalsIgnoreCase("2h3")) {
                    weaponType = "2h1";
                }
                g.manager.load(g.getOverridenFilename("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
                if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                    if (!fighter.special.contains("noaasl")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"), Texture.class);
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"), Texture.class);
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                }
                if (fighter.offHand != null) {
                    g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
                }
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
                suffix = "hit";
                weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
                if (weaponType.equalsIgnoreCase("2h3")) {
                    weaponType = "2h2";
                }
                g.manager.load(g.getOverridenFilename("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
                if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                    if (!fighter.special.contains("noaasl")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"), Texture.class);
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"), Texture.class);
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                }
                if (fighter.offHand != null) {
                    g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
                }
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "r" + fighter.armsType + ".png"), Texture.class);
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "l" + fighter.armsType + ".png"), Texture.class);
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "m" + fighter.armsType + ".png"), Texture.class);
                suffix = "right";
                weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
                if (weaponType.equalsIgnoreCase("2h3")) {
                    weaponType = "2h1";
                }
                g.manager.load(g.getOverridenFilename("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
                if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                    if (!fighter.special.contains("noaasl")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"), Texture.class);
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"), Texture.class);
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                }
                if (fighter.offHand != null) {
                    g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
                }
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
                suffix = "left";
                weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
                if (weaponType.equalsIgnoreCase("2h3")) {
                    weaponType = "2h1";
                }
                g.manager.load(g.getOverridenFilename("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
                if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                    if (!fighter.special.contains("noaasl")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"), Texture.class);
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"), Texture.class);
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                }
                if (fighter.offHand != null) {
                    g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
                }
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
                suffix = "middle";
                weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
                if (weaponType.equalsIgnoreCase("2h3")) {
                    weaponType = "2h2";
                }
                g.manager.load(g.getOverridenFilename("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
                if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                    if (!fighter.special.contains("noaasl")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                            g.manager.load(g.getOverridenFilename("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class);
                        }
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"), Texture.class);
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.load(g.getOverridenFilename("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"), Texture.class);
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.load(g.getOverridenFilename("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
                    }
                }
                if (fighter.offHand != null) {
                    g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
                }
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
                if (fighter.name.contains("boss1")) {
                    g.manager.load(g.getOverridenFilename("data/figures/espdoghit.png"), Texture.class);
                    g.manager.load(g.getOverridenFilename("data/figures/espdogidle.png"), Texture.class);
                    g.manager.load(g.getOverridenFilename("data/figures/espdogright.png"), Texture.class);
                } else if (fighter.name.contains("boss2")) {
                    g.manager.load(g.getOverridenFilename("data/figures/esplightbolt.png"), Texture.class);
                    g.manager.load(g.getOverridenFilename("data/figures/esplightcloud.png"), Texture.class);
                    g.manager.load(g.getOverridenFilename("data/figures/esplightcharge.png"), Texture.class);
                } else if (fighter.name.contains("boss3")) {
                    g.manager.load(g.getOverridenFilename("data/figures/espspearback.png"), Texture.class);
                    g.manager.load(g.getOverridenFilename("data/figures/espsmoke.png"), Texture.class);
                }
            }
        } else {
            String suffix = "idle";
            String weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h1";
            }
            if (!weaponType.equalsIgnoreCase("1h")) {
                g.manager.load(g.getOverridenFilename("data/figures/pcarms1hright.png"), Texture.class);
                g.manager.load(g.getOverridenFilename("data/figures/pcarms1hhit.png"), Texture.class);
                g.manager.load(g.getOverridenFilename("data/figures/shardpc1hright" + fighter.armsType + ".png"), Texture.class);
                g.manager.load(g.getOverridenFilename("data/figures/powderpc1hright" + fighter.armsType + ".png"), Texture.class);
                g.manager.load(g.getOverridenFilename("data/figures/netpc1hright" + fighter.armsType + ".png"), Texture.class);
            }
            g.manager.load(g.getOverridenFilename("data/figures/pcarms" + weaponType + suffix + ".png"), Texture.class);
            if (fighter.arms != null) {
                g.manager.load(g.getOverridenFilename("data/figures/pcarmorarmsbr1hright.png"), Texture.class);
                g.manager.load(g.getOverridenFilename("data/figures/pcarmorarmsbr1hhit.png"), Texture.class);
                g.manager.load(g.getOverridenFilename("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"), Texture.class);
            }
            if (fighter.head != null) {
                g.manager.load(g.getOverridenFilename("data/figures/pcarmorhead" + g.stats.get("tiers").getJSONObject(fighter.head.tier).getString("imageSuffix") + ".png"), Texture.class);
            }
            if (fighter.body != null) {
                g.manager.load(g.getOverridenFilename("data/figures/pcarmorbody" + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class);
            }
            if (fighter.offHand != null) {
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
            }
            g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
            suffix = "parry";
            weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h1";
            }
            g.manager.load(g.getOverridenFilename("data/figures/pcarms" + weaponType + suffix + ".png"), Texture.class);
            if (fighter.arms != null) {
                g.manager.load(g.getOverridenFilename("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"), Texture.class);
            }
            if (fighter.offHand != null) {
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
            }
            g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
            suffix = "hit";
            weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h2";
            }
            g.manager.load(g.getOverridenFilename("data/figures/pcarms" + weaponType + suffix + ".png"), Texture.class);
            if (fighter.arms != null) {
                g.manager.load(g.getOverridenFilename("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"), Texture.class);
            }
            if (fighter.offHand != null) {
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
            }
            g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "r" + fighter.armsType + ".png"), Texture.class);
            g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "l" + fighter.armsType + ".png"), Texture.class);
            g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "m" + fighter.armsType + ".png"), Texture.class);
            suffix = "right";
            weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h1";
            }
            g.manager.load(g.getOverridenFilename("data/figures/pcarms" + weaponType + suffix + ".png"), Texture.class);
            if (fighter.arms != null) {
                g.manager.load(g.getOverridenFilename("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"), Texture.class);
            }
            if (fighter.offHand != null) {
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
            }
            g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
            suffix = "left";
            weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h1";
            }
            g.manager.load(g.getOverridenFilename("data/figures/pcarms" + weaponType + suffix + ".png"), Texture.class);
            if (fighter.arms != null) {
                g.manager.load(g.getOverridenFilename("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"), Texture.class);
            }
            if (fighter.offHand != null) {
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
            }
            g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
            suffix = "middle";
            weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h2";
            }
            g.manager.load(g.getOverridenFilename("data/figures/pcarms" + weaponType + suffix + ".png"), Texture.class);
            if (fighter.arms != null) {
                g.manager.load(g.getOverridenFilename("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"), Texture.class);
            }
            if (fighter.offHand != null) {
                g.manager.load(g.getOverridenFilename("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"), Texture.class);
            }
            g.manager.load(g.getOverridenFilename("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"), Texture.class);
        }
        while (!g.manager.update()) {
        }
    }

    public static void unloadFighterAssets(SlavePitsGame g, Fighter fighter, boolean client, boolean onlyIdle) {
        if (client) {
            g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.skinType + fighter.bodySubType + "skin.png"));
            g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + fighter.bodySubType + ".png"));
            StringBuilder chosenAccessories = StringList.create(fighter.accessoryTypes, ":");
            for (int i = 0; i < StringList.size(chosenAccessories, ":"); ++i) {
                g.manager.unload(g.getOverridenAsset("data/figures/bodycomp" + fighter.bodyType + "" + fighter.bodySubType + StringList.get(chosenAccessories, i, ":") + ".png"));
            }
            if (fighter.head != null && !fighter.special.contains("nohel")) {
                g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.headType + fighter.portrait + g.stats.get("tiers").getJSONObject(fighter.head.tier).getString("imageSuffix") + ".png"));
            } else {
                g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.headType + fighter.portrait + ".png"));
            }
            String suffix = "idle";
            String weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h1";
            }
            if (!weaponType.equalsIgnoreCase("1h")) {
                g.manager.unload(g.getOverridenAsset("data/figures/arms1hright1.png"));
                g.manager.unload(g.getOverridenAsset("data/figures/arms1hhit1.png"));
            }
            g.manager.unload(g.getOverridenAsset("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"));
            if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                if (!fighter.special.contains("noaasl")) {
                    g.manager.unload(g.getOverridenAsset("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                }
                if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                    g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                    }
                    if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                    }
                    if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                    }
                }
            }
            if (fighter.body != null) {
                if (!fighter.special.contains("nocut")) {
                    g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + fighter.bodySubType + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                }
                if (!fighter.special.contains("nocul")) {
                    g.manager.unload(g.getOverridenAsset("data/figures/armorbodyl" + fighter.bodyType + fighter.bodySubType + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                }
            }
            if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"));
                if (fighter.body != null && !fighter.special.contains("nocut")) {
                    g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                }
            }
            if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"));
                if (fighter.body != null && !fighter.special.contains("nocut")) {
                    g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                }
            }
            if (fighter.offHand != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
            }
            g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"));
            if (!onlyIdle) {
                suffix = "parry";
                weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
                if (weaponType.equalsIgnoreCase("2h3")) {
                    weaponType = "2h1";
                }
                g.manager.unload(g.getOverridenAsset("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"));
                if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                    if (!fighter.special.contains("noaasl")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                    }
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"));
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"));
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                    }
                }
                if (fighter.offHand != null) {
                    g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
                }
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"));
                suffix = "hit";
                weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
                if (weaponType.equalsIgnoreCase("2h3")) {
                    weaponType = "2h2";
                }
                g.manager.unload(g.getOverridenAsset("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"));
                if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                    if (!fighter.special.contains("noaasl")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                    }
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"));
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"));
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                    }
                }
                if (fighter.offHand != null) {
                    g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
                }
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "r" + fighter.armsType + ".png"));
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "l" + fighter.armsType + ".png"));
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "m" + fighter.armsType + ".png"));
                suffix = "right";
                weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
                if (weaponType.equalsIgnoreCase("2h3")) {
                    weaponType = "2h1";
                }
                g.manager.unload(g.getOverridenAsset("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"));
                if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                    if (!fighter.special.contains("noaasl")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                    }
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"));
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"));
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                    }
                }
                if (fighter.offHand != null) {
                    g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
                }
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"));
                suffix = "left";
                weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
                if (weaponType.equalsIgnoreCase("2h3")) {
                    weaponType = "2h1";
                }
                g.manager.unload(g.getOverridenAsset("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"));
                if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                    if (!fighter.special.contains("noaasl")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                    }
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"));
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"));
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                    }
                }
                if (fighter.offHand != null) {
                    g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
                }
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"));
                suffix = "middle";
                weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
                if (weaponType.equalsIgnoreCase("2h3")) {
                    weaponType = "2h2";
                }
                g.manager.unload(g.getOverridenAsset("data/figures/arms" + weaponType + suffix + fighter.armsType + ".png"));
                if (fighter.arms != null && !fighter.special.contains("noarmsarmor")) {
                    if (!fighter.special.contains("noaasl")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmssl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                    }
                    if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrl")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        if (!fighter.special.contains("noaabra") && !fighter.special.contains("noaabrr")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsbrr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspl")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspl" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                        if (!fighter.special.contains("noaaspa") && !fighter.special.contains("noaaspr")) {
                            g.manager.unload(g.getOverridenAsset("data/figures/armorarmsspr" + weaponType + suffix + fighter.armsType + g.stats.get("tiers").getJSONObject(fighter.arms.tier).getString("imageSuffix") + ".png"));
                        }
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("skinExtra"), ":"), "body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + fighter.bodySubType + "skin" + weaponType + suffix + ".png"));
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                    }
                }
                if (StringList.indexOf(StringList.create(g.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(fighter.bodyType).getString("bodyExtra"), ":"), "body" + fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                    g.manager.unload(g.getOverridenAsset("data/figures/body" + fighter.bodyType + weaponType + suffix + ".png"));
                    if (fighter.body != null && !fighter.special.contains("nocut")) {
                        g.manager.unload(g.getOverridenAsset("data/figures/armorbodyt" + fighter.bodyType + weaponType + suffix + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
                    }
                }
                if (fighter.offHand != null) {
                    g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
                }
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"));
                if (fighter.name.contains("boss1")) {
                    g.manager.unload(g.getOverridenAsset("data/figures/espdoghit.png"));
                    g.manager.unload(g.getOverridenAsset("data/figures/espdogidle.png"));
                    g.manager.unload(g.getOverridenAsset("data/figures/espdogright.png"));
                } else if (fighter.name.contains("boss2")) {
                    g.manager.unload(g.getOverridenAsset("data/figures/esplightbolt.png"));
                    g.manager.unload(g.getOverridenAsset("data/figures/esplightcloud.png"));
                    g.manager.unload(g.getOverridenAsset("data/figures/esplightcharge.png"));
                } else if (fighter.name.contains("boss3")) {
                    g.manager.unload(g.getOverridenAsset("data/figures/espspearback.png"));
                    g.manager.unload(g.getOverridenAsset("data/figures/espsmoke.png"));
                }
            }
        } else {
            String suffix = "idle";
            String weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h1";
            }
            if (!weaponType.equalsIgnoreCase("1h")) {
                g.manager.unload(g.getOverridenAsset("data/figures/pcarms1hright.png"));
                g.manager.unload(g.getOverridenAsset("data/figures/pcarms1hhit.png"));
                g.manager.unload(g.getOverridenAsset("data/figures/shardpc1hright" + fighter.armsType + ".png"));
                g.manager.unload(g.getOverridenAsset("data/figures/powderpc1hright" + fighter.armsType + ".png"));
                g.manager.unload(g.getOverridenAsset("data/figures/netpc1hright" + fighter.armsType + ".png"));
            }
            g.manager.unload(g.getOverridenAsset("data/figures/pcarms" + weaponType + suffix + ".png"));
            if (fighter.arms != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/pcarmorarmsbr1hright.png"));
                g.manager.unload(g.getOverridenAsset("data/figures/pcarmorarmsbr1hhit.png"));
                g.manager.unload(g.getOverridenAsset("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"));
            }
            if (fighter.head != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/pcarmorhead" + g.stats.get("tiers").getJSONObject(fighter.head.tier).getString("imageSuffix") + ".png"));
            }
            if (fighter.body != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/pcarmorbody" + g.stats.get("tiers").getJSONObject(fighter.body.tier).getString("imageSuffix") + ".png"));
            }
            if (fighter.offHand != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
            }
            g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"));
            suffix = "parry";
            weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h1";
            }
            g.manager.unload(g.getOverridenAsset("data/figures/pcarms" + weaponType + suffix + ".png"));
            if (fighter.arms != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"));
            }
            if (fighter.offHand != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
            }
            g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"));
            suffix = "hit";
            weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h2";
            }
            g.manager.unload(g.getOverridenAsset("data/figures/pcarms" + weaponType + suffix + ".png"));
            if (fighter.arms != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"));
            }
            if (fighter.offHand != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
            }
            g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "r" + fighter.armsType + ".png"));
            g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "l" + fighter.armsType + ".png"));
            g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + "m" + fighter.armsType + ".png"));
            suffix = "right";
            weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h1";
            }
            g.manager.unload(g.getOverridenAsset("data/figures/pcarms" + weaponType + suffix + ".png"));
            if (fighter.arms != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"));
            }
            if (fighter.offHand != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
            }
            g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"));
            suffix = "left";
            weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h1";
            }
            g.manager.unload(g.getOverridenAsset("data/figures/pcarms" + weaponType + suffix + ".png"));
            if (fighter.arms != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"));
            }
            if (fighter.offHand != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
            }
            g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"));
            suffix = "middle";
            weaponType = g.stats.get("weapons").getJSONObject(fighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h2";
            }
            g.manager.unload(g.getOverridenAsset("data/figures/pcarms" + weaponType + suffix + ".png"));
            if (fighter.arms != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/pcarmorarmsbr" + weaponType + suffix + ".png"));
            }
            if (fighter.offHand != null) {
                g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.offHand.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + fighter.armsType + ".png"));
            }
            g.manager.unload(g.getOverridenAsset("data/figures/" + fighter.weapon.id + "pc" + g.stats.get("tiers").getJSONObject(fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + fighter.armsType + ".png"));
        }
    }
}

