/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.game;

import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.game.CombatEngine;
import com.calimasaga.slavepits.game.CombatState;
import com.calimasaga.slavepits.util.Logger;
import com.calimasaga.slavepits.util.StringList;
import java.util.LinkedList;

public class CombatServer {
    public static SlavePitsGame game;
    public static Integer clientMessageNumber;
    public static Integer updateMessageNumber;
    public static LinkedList<String> messageHistory;

    public static void init(SlavePitsGame g) {
        game = g;
        clientMessageNumber = 0;
        updateMessageNumber = 0;
        messageHistory = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveMessage(String message) {
        block6: {
            StringBuilder parsedMessage = StringList.create(message, "_");
            try {
                int receivedClientMessageNumber = Integer.parseInt(StringList.get(parsedMessage, 0, "_"));
                Logger.write(Logger.DEBUG, "CombatServer.receiveMessage receivedClientMessageNumber " + receivedClientMessageNumber);
                if (receivedClientMessageNumber == clientMessageNumber) {
                    Logger.write(Logger.DEBUG, "CombatServer.receiveMessage handling message " + message);
                    clientMessageNumber = receivedClientMessageNumber + 1;
                    LinkedList<StringBuilder> linkedList = CombatServer.game.combatScreen.messagesToExecute;
                    synchronized (linkedList) {
                        CombatServer.game.combatScreen.messagesToExecute.addLast(parsedMessage);
                        break block6;
                    }
                }
                Logger.write(Logger.DEBUG, "CombatServer.receiveMessage ignoring out of order message " + message);
            }
            catch (NumberFormatException nfe) {
                Logger.write(Logger.DEBUG, "CombatServer.receiveMessage ignoring rogue message " + message);
            }
        }
    }

    public static void sendUpdates(float delta) {
        StringBuilder data = new StringBuilder();
        if (CombatEngine.combatStateChanges.stage != null) {
            data.append("sta");
            data.append(CombatEngine.combatStateChanges.stage);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.attacker != null) {
            data.append("ata");
            data.append(CombatEngine.combatStateChanges.attacker);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.defender != null) {
            data.append("def");
            data.append(CombatEngine.combatStateChanges.defender);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.direction != null) {
            data.append("dir");
            data.append(CombatEngine.combatStateChanges.direction);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.vulnerableDirection != null) {
            data.append("vdi");
            data.append(CombatEngine.combatStateChanges.vulnerableDirection);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.randomNumber != null) {
            data.append("ran");
            data.append(CombatEngine.combatStateChanges.randomNumber);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.timePressure != null) {
            data.append("tpr");
            data.append(CombatEngine.combatStateChanges.timePressure);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.assaultFighter != null) {
            data.append("asf");
            data.append(CombatEngine.combatStateChanges.assaultFighter);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.assaultPressure != null) {
            data.append("asp");
            data.append(CombatEngine.combatStateChanges.assaultPressure);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.hostComboHappenning != null) {
            data.append("hch");
            data.append(CombatEngine.combatStateChanges.hostComboHappenning);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.clientComboHappenning != null) {
            data.append("cch");
            data.append(CombatEngine.combatStateChanges.clientComboHappenning);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.hostSurgeType != null) {
            data.append("hse");
            data.append(CombatEngine.combatStateChanges.hostSurgeType);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.clientSurgeType != null) {
            data.append("cse");
            data.append(CombatEngine.combatStateChanges.clientSurgeType);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.isUse != null) {
            data.append("ius");
            data.append(CombatEngine.combatStateChanges.isUse != false ? 1 : 0);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.soundsToPlay != null) {
            data.append("aso");
            data.append(CombatEngine.combatStateChanges.soundsToPlay.toString());
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.effectsToPlay != null) {
            data.append("aef");
            data.append(CombatEngine.combatStateChanges.effectsToPlay.toString());
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.highlights != null) {
            data.append("ahi");
            data.append(CombatEngine.combatStateChanges.highlights.toString());
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.hostLog != null) {
            data.append("ahl");
            data.append(CombatEngine.combatStateChanges.hostLog.toString());
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.clientLog != null) {
            data.append("acl");
            data.append(CombatEngine.combatStateChanges.clientLog.toString());
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.scenarioLife != null) {
            data.append("scl");
            data.append(CombatEngine.combatStateChanges.scenarioLife);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendhli != null) {
            data.append("hli");
            data.append(CombatEngine.combatStateChanges.sendhli);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendhst != null) {
            data.append("hst");
            data.append(CombatEngine.combatStateChanges.sendhst);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendhba != null) {
            data.append("hba");
            data.append(CombatEngine.combatStateChanges.sendhba);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendhsu != null) {
            data.append("hsu");
            data.append(CombatEngine.combatStateChanges.sendhsu);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendhiu != null) {
            data.append("hiu");
            data.append(CombatEngine.combatStateChanges.sendhiu);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendhcs != null) {
            data.append("hcs");
            data.append(CombatEngine.combatStateChanges.sendhcs);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendhdb != null) {
            data.append("hdb");
            data.append((CharSequence)CombatEngine.combatStateChanges.sendhdb);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendhbu != null) {
            data.append("hbu");
            data.append((CharSequence)CombatEngine.combatStateChanges.sendhbu);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendcli != null) {
            data.append("cli");
            data.append(CombatEngine.combatStateChanges.sendcli);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendcst != null) {
            data.append("cst");
            data.append(CombatEngine.combatStateChanges.sendcst);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendcba != null) {
            data.append("cba");
            data.append(CombatEngine.combatStateChanges.sendcba);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendcsu != null) {
            data.append("csu");
            data.append(CombatEngine.combatStateChanges.sendcsu);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendciu != null) {
            data.append("ciu");
            data.append(CombatEngine.combatStateChanges.sendciu);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendccs != null) {
            data.append("ccs");
            data.append(CombatEngine.combatStateChanges.sendccs);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendcdb != null) {
            data.append("cdb");
            data.append((CharSequence)CombatEngine.combatStateChanges.sendcdb);
            data.append("&");
        }
        if (CombatEngine.combatStateChanges.sendcbu != null) {
            data.append("cbu");
            data.append((CharSequence)CombatEngine.combatStateChanges.sendcbu);
            data.append("&");
        }
        boolean send = false;
        if (data.length() > 0) {
            messageHistory.addLast(updateMessageNumber + "&" + data.substring(0, data.length() - 1));
            updateMessageNumber = updateMessageNumber + 1;
            if (messageHistory.size() > 5) {
                messageHistory.poll();
            }
            send = true;
            data = new StringBuilder();
        }
        if (CombatEngine.combatStateChanges.lastCombatEvent != null) {
            data.append("s");
            data.append("&");
            data.append(CombatEngine.combatStateChanges.lastCombatEvent);
            messageHistory.addLast(updateMessageNumber + "&" + data);
            updateMessageNumber = updateMessageNumber + 1;
            if (messageHistory.size() > 5) {
                messageHistory.poll();
            }
            send = true;
        }
        if (send) {
            StringBuilder finalMessage = new StringBuilder();
            for (int i = 0; i < messageHistory.size(); ++i) {
                finalMessage.append(messageHistory.get(i));
                finalMessage.append("$");
            }
            CombatServer.game.networkPort.sendData(finalMessage.substring(0, finalMessage.length() - 1));
            CombatEngine.combatStateChanges = new CombatState();
        }
    }

    static {
        clientMessageNumber = 0;
        updateMessageNumber = 0;
        messageHistory = new LinkedList();
    }
}

