/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.game;

import com.badlogic.gdx.math.MathUtils;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.game.CombatState;
import com.calimasaga.slavepits.game.Effect;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.util.PropertiesReader;
import com.calimasaga.slavepits.util.StringList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class CombatEngine {
    public static SlavePitsGame game;
    public static CombatState combatState;
    public static CombatState combatStateChanges;
    public static int attackerDeviation;
    public static int defenderDeviation;
    public static int damageReceived;
    public static int risposteStamina;
    public static float timePressureReduction;
    public static float assaultPressureReduction;
    public static float playerTimeMultiplier;
    public static String selectedInput;
    public static long recoverCounter;
    public static float recoverMultiplier;
    public static float damageMultiplier;
    public static String scenario;
    public static int scenarioLife;

    public static void initialize(SlavePitsGame g, Fighter startingPlayer, Fighter replyingPlayer, String difficulty, boolean startingHost, String selScenario, String input) {
        game = g;
        combatState = new CombatState();
        combatState.init();
        CombatEngine.combatState.stage = "start";
        if (startingHost) {
            CombatEngine.combatState.hostFighter = startingPlayer;
            CombatEngine.combatState.clientFighter = replyingPlayer;
            CombatEngine.combatState.attacker = "host";
            CombatEngine.combatState.defender = "client";
        } else {
            CombatEngine.combatState.hostFighter = replyingPlayer;
            CombatEngine.combatState.clientFighter = startingPlayer;
            CombatEngine.combatState.attacker = "client";
            CombatEngine.combatState.defender = "host";
        }
        CombatEngine.combatState.vulnerableDirection = "middle";
        combatStateChanges = new CombatState();
        attackerDeviation = 0;
        defenderDeviation = 0;
        damageReceived = 0;
        timePressureReduction = CombatEngine.stats("timings").getJSONObject("pressure").getFloat("timeReduction");
        assaultPressureReduction = CombatEngine.stats("timings").getJSONObject("pressure").getFloat("assaultReduction");
        recoverMultiplier = CombatEngine.stats("timings").getJSONObject("recover").getFloat("multiplier");
        if (!game.isMultiplayerGame()) {
            damageMultiplier = Float.parseFloat(((JSONObject)CombatEngine.game.stats.get("timings").get("ai")).getString("baseDamageMultiplier"));
            String aiModifiers = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("timings").get("ai")).get("difficultyThreshold")).getString(difficulty);
            damageMultiplier += Float.parseFloat(aiModifiers.split(":")[2]);
            playerTimeMultiplier = Float.parseFloat(((JSONObject)CombatEngine.game.stats.get("timings").get("ai")).getString("playerTimeMultiplier"));
            playerTimeMultiplier += Float.parseFloat(aiModifiers.split(":")[4]);
        }
        selectedInput = input;
        scenario = selScenario;
        if (!scenario.equalsIgnoreCase("")) {
            CombatEngine.combatState.scenarioLife = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getInt("life");
        }
    }

    public static void addEffect(Fighter fighter, Effect effect) {
        fighter.effects.add(effect);
        fighter.preCalculatedCriticalChance = CombatEngine.getCriticalChance(fighter, 50, "const", 0);
        fighter.preCalculatedDamageReduction = CombatEngine.getArmorReduction(fighter);
    }

    public static int getEffectChance(Effect effect) {
        if (effect != null) {
            if (effect.chance.equalsIgnoreCase("critic")) {
                return CombatEngine.combatState.getAttacker().preCalculatedCriticalChance;
            }
            if (effect.chance.equalsIgnoreCase("damred")) {
                return CombatEngine.combatState.getAttacker().preCalculatedDamageReduction;
            }
            if (effect.chance.startsWith("didd")) {
                return Integer.parseInt(effect.chance.substring(4)) + attackerDeviation - defenderDeviation;
            }
            if (effect.chance.startsWith("asra")) {
                return Integer.parseInt(effect.chance.substring(4)) * CombatEngine.combatState.assaultPressure;
            }
            return Integer.parseInt(effect.chance);
        }
        return 0;
    }

    public static Effect getEffect(Fighter fighter, String timing, String effectType, String effectSubtype, int randomSeed) {
        return CombatEngine.getEffect(fighter, timing, effectType, effectSubtype, "", randomSeed);
    }

    public static Effect getEffect(Fighter fighter, String timing, String effectType, String effectSubtype, String effectSource, int randomSeed) {
        for (Effect currEffect : fighter.effects) {
            if (!currEffect.type.equalsIgnoreCase(effectType) || !effectSubtype.equalsIgnoreCase("") && !currEffect.subtype.equalsIgnoreCase(effectSubtype) || !effectSource.equalsIgnoreCase("") && !currEffect.source.equalsIgnoreCase(effectSource)) continue;
            int chance = 0;
            if (randomSeed != 0) {
                chance = CombatEngine.getEffectChance(currEffect);
            }
            if (randomSeed != 0 && (chance <= 0 || randomSeed >= chance) || timing != null && !currEffect.trigger.equalsIgnoreCase("const") && !timing.contains(currEffect.trigger)) continue;
            return currEffect;
        }
        return null;
    }

    public static float getEffectValue(Fighter fighter, String timing, String effectType, String effectSubtype, int randomSeed) {
        return CombatEngine.getEffectValue(fighter, timing, effectType, effectSubtype, "", randomSeed);
    }

    public static float getEffectValue(Fighter fighter, String timing, String effectType, String effectSubtype, String effectSource, int randomSeed) {
        float add = 0.0f;
        float mul = 1.0f;
        for (Effect currEffect : fighter.effects) {
            if (!currEffect.type.equalsIgnoreCase(effectType) || !effectSubtype.equalsIgnoreCase("") && !currEffect.subtype.equalsIgnoreCase(effectSubtype) || !effectSource.equalsIgnoreCase("") && !currEffect.source.equalsIgnoreCase(effectSource)) continue;
            int chance = 0;
            if (randomSeed != 0) {
                chance = CombatEngine.getEffectChance(currEffect);
            }
            if (randomSeed != 0 && (chance <= 0 || randomSeed >= chance) || timing != null && !currEffect.trigger.equalsIgnoreCase("const") && !timing.contains(currEffect.trigger)) continue;
            if (currEffect.operation.equalsIgnoreCase("add")) {
                if (currEffect.value.equalsIgnoreCase("atadev")) {
                    add += (float)(50 - attackerDeviation) * CombatEngine.stats("weapons").getJSONObject(CombatEngine.combatState.getAttacker().weapon.id).getFloat("staminaCost") * 0.01f;
                    continue;
                }
                add += Float.parseFloat(currEffect.value);
                continue;
            }
            if (currEffect.operation.equalsIgnoreCase("mul")) {
                mul *= Float.parseFloat(currEffect.value);
                continue;
            }
            if (!currEffect.operation.equalsIgnoreCase("percen")) continue;
            if (currEffect.value.equalsIgnoreCase("critic")) {
                mul = mul * (100.0f + (float)fighter.preCalculatedCriticalChance) / 100.0f;
                continue;
            }
            if (!currEffect.value.equalsIgnoreCase("damred")) continue;
            mul = mul * (100.0f + (float)fighter.preCalculatedDamageReduction) / 100.0f;
        }
        if ((double)add != 0.0) {
            return add;
        }
        if (mul != 1.0f) {
            return mul;
        }
        return 0.0f;
    }

    public static void removeEffect(Fighter fighter, String timing, String effectType, String effectSubtype) {
        boolean changed = false;
        ListIterator<Effect> it = fighter.effects.listIterator();
        while (it.hasNext()) {
            int position;
            Effect currEffect = it.next();
            if (!currEffect.type.equalsIgnoreCase(effectType) || !effectSubtype.equalsIgnoreCase("") && !currEffect.subtype.equalsIgnoreCase(effectSubtype) || timing != null && !currEffect.trigger.equalsIgnoreCase("const") && !timing.contains(currEffect.trigger)) continue;
            if (currEffect.source.equalsIgnoreCase("buff")) {
                position = StringList.getPosition(fighter.buffs, currEffect.type, ",");
                if (position >= 0) {
                    if (currEffect.type.equalsIgnoreCase("surge")) {
                        fighter.surge = (fighter.services.contains("potion") ? 2500 : 0) + (fighter.isPlayer && CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && Tournament.getRewardStock(game, "concoction") > 0 ? Tournament.getRewardStock(game, "concoction") / 2 : 0);
                        if (combatState.getAttacker() == fighter) {
                            CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                        } else {
                            CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                        }
                    }
                    fighter.buffs = StringList.remove(fighter.buffs, position, ",");
                    if (fighter.isHost) {
                        CombatEngine.combatStateChanges.sendhbu = new StringBuilder(fighter.buffs);
                    } else {
                        CombatEngine.combatStateChanges.sendcbu = new StringBuilder(fighter.buffs);
                    }
                }
            } else if (currEffect.source.equalsIgnoreCase("debuff") && (position = StringList.getPosition(fighter.debuffs, currEffect.type, ",")) >= 0) {
                fighter.debuffs = StringList.remove(fighter.debuffs, position, ",");
                if (fighter.isHost) {
                    CombatEngine.combatStateChanges.sendhdb = new StringBuilder(fighter.debuffs);
                } else {
                    CombatEngine.combatStateChanges.sendcdb = new StringBuilder(fighter.debuffs);
                }
            }
            it.remove();
            changed = true;
        }
        if (changed) {
            fighter.preCalculatedCriticalChance = CombatEngine.getCriticalChance(fighter, 50, "const", 0);
            fighter.preCalculatedDamageReduction = CombatEngine.getArmorReduction(fighter);
        }
    }

    public static void removeEffectsByTime(Fighter fighter, long combatTime) {
        boolean changed = false;
        ListIterator<Effect> it = fighter.effects.listIterator();
        while (it.hasNext()) {
            int position;
            Effect currEffect = it.next();
            if (currEffect.source.equalsIgnoreCase("talent") || currEffect.time.equalsIgnoreCase("x") || Long.parseLong(currEffect.time) >= combatTime) continue;
            if (currEffect.source.equalsIgnoreCase("buff")) {
                position = StringList.getPosition(fighter.buffs, currEffect.type, ",");
                if (position >= 0) {
                    if (currEffect.type.equalsIgnoreCase("surge")) {
                        fighter.surge = (fighter.services.contains("potion") ? 2500 : 0) + (fighter.isPlayer && CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && Tournament.getRewardStock(game, "concoction") > 0 ? Tournament.getRewardStock(game, "concoction") / 2 : 0);
                        if (combatState.getAttacker() == fighter) {
                            CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                        } else {
                            CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                        }
                    }
                    fighter.buffs = StringList.remove(fighter.buffs, position, ",");
                    if (fighter.isHost) {
                        CombatEngine.combatStateChanges.sendhbu = new StringBuilder(fighter.buffs);
                    } else {
                        CombatEngine.combatStateChanges.sendcbu = new StringBuilder(fighter.buffs);
                    }
                }
            } else if (currEffect.source.equalsIgnoreCase("debuff") && (position = StringList.getPosition(fighter.debuffs, currEffect.type, ",")) >= 0) {
                fighter.debuffs = StringList.remove(fighter.debuffs, position, ",");
                if (fighter.isHost) {
                    CombatEngine.combatStateChanges.sendhdb = new StringBuilder(fighter.debuffs);
                } else {
                    CombatEngine.combatStateChanges.sendcdb = new StringBuilder(fighter.debuffs);
                }
            }
            it.remove();
            changed = true;
        }
        if (changed) {
            fighter.preCalculatedCriticalChance = CombatEngine.getCriticalChance(fighter, 50, "const", 0);
            fighter.preCalculatedDamageReduction = CombatEngine.getArmorReduction(fighter);
        }
    }

    public static void removeEffectBySource(Fighter fighter, String source) {
        boolean changed = false;
        ListIterator<Effect> it = fighter.effects.listIterator();
        while (it.hasNext()) {
            int position;
            Effect currEffect = it.next();
            if (!currEffect.source.equalsIgnoreCase(source)) continue;
            if (currEffect.source.equalsIgnoreCase("buff")) {
                position = StringList.getPosition(fighter.buffs, currEffect.type, ",");
                if (position >= 0) {
                    if (currEffect.type.equalsIgnoreCase("surge")) {
                        fighter.surge = (fighter.services.contains("potion") ? 2500 : 0) + (fighter.isPlayer && CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && Tournament.getRewardStock(game, "concoction") > 0 ? Tournament.getRewardStock(game, "concoction") / 2 : 0);
                        if (combatState.getAttacker() == fighter) {
                            CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                        } else {
                            CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                        }
                    }
                    fighter.buffs = StringList.remove(fighter.buffs, position, ",");
                    if (fighter.isHost) {
                        CombatEngine.combatStateChanges.sendhbu = new StringBuilder(fighter.buffs);
                    } else {
                        CombatEngine.combatStateChanges.sendcbu = new StringBuilder(fighter.buffs);
                    }
                }
            } else if (currEffect.source.equalsIgnoreCase("debuff") && (position = StringList.getPosition(fighter.debuffs, currEffect.type, ",")) >= 0) {
                fighter.debuffs = StringList.remove(fighter.debuffs, position, ",");
                if (fighter.isHost) {
                    CombatEngine.combatStateChanges.sendhdb = new StringBuilder(fighter.debuffs);
                } else {
                    CombatEngine.combatStateChanges.sendcdb = new StringBuilder(fighter.debuffs);
                }
            }
            it.remove();
            changed = true;
        }
        if (changed) {
            fighter.preCalculatedCriticalChance = CombatEngine.getCriticalChance(fighter, 50, "const", 0);
            fighter.preCalculatedDamageReduction = CombatEngine.getArmorReduction(fighter);
        }
    }

    public static void addItemEffect(Fighter fighter) {
        if (fighter.services.contains("shard")) {
            Effect newEffect = Effect.stringToEffect(CombatEngine.stats("effects").getString("shard") + ":talent");
            CombatEngine.addEffect(fighter, newEffect);
        } else if (fighter.services.contains("powder")) {
            Effect newEffect = Effect.stringToEffect(CombatEngine.stats("effects").getString("powder") + ":talent");
            CombatEngine.addEffect(fighter, newEffect);
        } else if (fighter.services.contains("net")) {
            Effect newEffect = Effect.stringToEffect(CombatEngine.stats("effects").getString("net") + ":talent");
            CombatEngine.addEffect(fighter, newEffect);
        }
    }

    public static void removeItemEffects(Fighter fighter) {
        ListIterator<Effect> ite = fighter.effects.listIterator();
        while (ite.hasNext()) {
            Effect currEffect = ite.next();
            if (currEffect.source == null || !currEffect.source.equalsIgnoreCase("item")) continue;
            ite.remove();
        }
    }

    public static void initTalentEffects(Fighter fighter) {
        float useCharges;
        fighter.effects.clear();
        fighter.knownCombos.clear();
        if (!fighter.talents.isEmpty()) {
            Iterator<String> iterator = fighter.talents.keySet().iterator();
            while (iterator.hasNext()) {
                String[] talentEffects;
                String currTalent;
                String realTalent = currTalent = iterator.next();
                if (fighter.talents.get(currTalent) > 0) {
                    realTalent = currTalent + ":" + fighter.talents.get(currTalent);
                }
                String type = CombatEngine.game.stats.get("talents").getJSONObject(realTalent).getString("type");
                for (String currEffect : talentEffects = type.split("#")) {
                    if (currEffect.contains("combo")) {
                        fighter.knownCombos.add(currEffect + "$" + currTalent);
                        continue;
                    }
                    fighter.effects.add(Effect.stringToEffect(currEffect + ":talent"));
                }
            }
            fighter.preCalculatedCriticalChance = CombatEngine.getCriticalChance(fighter, 50, "const", 0);
            fighter.preCalculatedDamageReduction = CombatEngine.getArmorReduction(fighter);
        }
        if ((double)(useCharges = CombatEngine.getEffectValue(fighter, "const", "useite", "charge", 0)) != 0.0) {
            fighter.itemUses = Float.valueOf(useCharges).intValue() * (!fighter.isPlayer ? 2 : 1);
            CombatEngine.addItemEffect(fighter);
        } else if (fighter.services.contains("shard") || fighter.services.contains("powder") || fighter.services.contains("net")) {
            if (fighter.itemUses == 0) {
                fighter.itemUses = !fighter.isPlayer ? 2 : 1;
            }
            CombatEngine.addItemEffect(fighter);
        }
        fighter.surge = 0;
        if (fighter.services.contains("potion")) {
            fighter.surge += 5000;
        }
        if (fighter.isPlayer && CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && Tournament.getRewardStock(game, "concoction") > 0) {
            fighter.surge += Tournament.getRewardStock(game, "concoction");
        }
    }

    public static void addBuff(Fighter fighter, String buffType, String buffSubtype, long buffTime, long combatTime, StringBuilder log) {
        long currBuffTime;
        Effect currBuff = CombatEngine.getEffect(fighter, null, buffType, "buff", 0);
        long l = currBuffTime = currBuff == null ? 0L : Long.parseLong(currBuff.time);
        if (currBuffTime - combatTime < buffTime) {
            String buffText;
            String[] buffEffects;
            if (currBuffTime > 0L) {
                CombatEngine.removeBuff(fighter, buffType);
            }
            Effect newBuff = Effect.stringToEffect(CombatEngine.game.stats.get("effects").getString("buff") + ":buff");
            newBuff.type = buffType;
            newBuff.time = "" + (buffTime + combatTime);
            CombatEngine.addEffect(fighter, newBuff);
            for (String buffEffect : buffEffects = CombatEngine.game.stats.get("effects").getString(buffSubtype).split("#")) {
                Effect newBuffEffect = Effect.stringToEffect(buffEffect + ":" + buffType);
                newBuffEffect.time = "" + (buffTime + combatTime);
                CombatEngine.addEffect(fighter, newBuffEffect);
            }
            fighter.buffs = StringList.append(fighter.buffs, buffType, ",");
            String string = buffText = buffType.equalsIgnoreCase("surge") ? buffSubtype : buffType;
            if (fighter.isHost) {
                CombatEngine.combatStateChanges.sendhbu = new StringBuilder(fighter.buffs);
                CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, "h:" + buffText, ",");
                CombatEngine.combatStateChanges.effectsToPlay = new StringBuilder(CombatEngine.combatState.effectsToPlay);
            } else {
                CombatEngine.combatStateChanges.sendcbu = new StringBuilder(fighter.buffs);
                CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, "c:" + buffText, ",");
                CombatEngine.combatStateChanges.effectsToPlay = new StringBuilder(CombatEngine.combatState.effectsToPlay);
            }
            CombatEngine.addLogTrace(log, "b;" + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.added") + " " + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.buff") + ": " + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.buff." + buffText));
        }
        fighter.preCalculatedCriticalChance = CombatEngine.getCriticalChance(fighter, 50, "const", 0);
        fighter.preCalculatedDamageReduction = CombatEngine.getArmorReduction(fighter);
    }

    public static void removeBuff(Fighter fighter, String buffType) {
        boolean changed = false;
        ListIterator<Effect> it = fighter.effects.listIterator();
        while (it.hasNext()) {
            Effect currEffect = it.next();
            if (!currEffect.type.equalsIgnoreCase(buffType) && !currEffect.source.equalsIgnoreCase(buffType)) continue;
            int position = StringList.getPosition(fighter.buffs, buffType, ",");
            if (position >= 0) {
                if (currEffect.type.equalsIgnoreCase("surge")) {
                    fighter.surge = (fighter.services.contains("potion") ? 2500 : 0) + (fighter.isPlayer && CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && Tournament.getRewardStock(game, "concoction") > 0 ? Tournament.getRewardStock(game, "concoction") / 2 : 0);
                    if (combatState.getAttacker() == fighter) {
                        CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                    } else {
                        CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                    }
                }
                fighter.buffs = StringList.remove(fighter.buffs, position, ",");
                if (fighter.isHost) {
                    CombatEngine.combatStateChanges.sendhbu = new StringBuilder(fighter.buffs);
                    if (buffType.equalsIgnoreCase("surge")) {
                        CombatEngine.combatState.hostSurgeType = "";
                        CombatEngine.combatStateChanges.hostSurgeType = "";
                    }
                } else {
                    CombatEngine.combatStateChanges.sendcbu = new StringBuilder(fighter.buffs);
                    if (buffType.equalsIgnoreCase("surge")) {
                        CombatEngine.combatState.clientSurgeType = "";
                        CombatEngine.combatStateChanges.clientSurgeType = "";
                    }
                }
            }
            it.remove();
            changed = true;
        }
        if (changed) {
            fighter.preCalculatedCriticalChance = CombatEngine.getCriticalChance(fighter, 50, "const", 0);
            fighter.preCalculatedDamageReduction = CombatEngine.getArmorReduction(fighter);
        }
    }

    public static void addDebuff(Fighter fighter, String debuffType, String debuffSubtype, long debuffTime, long combatTime, StringBuilder log, boolean stack) {
        long currDebuffTime;
        Effect currDebuff = CombatEngine.getEffect(fighter, null, debuffType, "debuff", 0);
        long l = currDebuffTime = currDebuff == null ? 0L : Long.parseLong(currDebuff.time);
        if (currDebuffTime - combatTime < debuffTime) {
            String[] debuffEffects;
            boolean present = false;
            if (currDebuffTime > 0L) {
                return;
            }
            Effect newDebuff = Effect.stringToEffect(CombatEngine.game.stats.get("effects").getString("debuff") + ":debuff");
            newDebuff.type = debuffType;
            newDebuff.time = "" + (debuffTime + combatTime);
            CombatEngine.addEffect(fighter, newDebuff);
            for (String debuffEffect : debuffEffects = CombatEngine.game.stats.get("effects").getString(debuffSubtype).split("#")) {
                Effect newDebuffEffect = Effect.stringToEffect(debuffEffect + ":" + debuffType);
                newDebuffEffect.value = "" + (double)Float.parseFloat(newDebuffEffect.value) * (present ? 2.0 : 1.0);
                newDebuffEffect.time = "" + (debuffTime + combatTime);
                CombatEngine.addEffect(fighter, newDebuffEffect);
            }
            fighter.debuffs = StringList.append(fighter.debuffs, debuffType, ",");
            if (fighter.isHost) {
                CombatEngine.combatStateChanges.sendhdb = new StringBuilder(fighter.debuffs);
                CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, "h:" + debuffType, ",");
                CombatEngine.combatStateChanges.effectsToPlay = new StringBuilder(CombatEngine.combatState.effectsToPlay);
            } else {
                CombatEngine.combatStateChanges.sendcdb = new StringBuilder(fighter.debuffs);
                CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, "c:" + debuffType, ",");
                CombatEngine.combatStateChanges.effectsToPlay = new StringBuilder(CombatEngine.combatState.effectsToPlay);
            }
            CombatEngine.combatState.soundsToPlay = StringList.append(CombatEngine.combatState.soundsToPlay, CombatEngine.getEffectSound(debuffType), ",");
            CombatEngine.combatStateChanges.soundsToPlay = new StringBuilder(CombatEngine.combatState.soundsToPlay);
            CombatEngine.addLogTrace(log, "r;" + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.added") + " " + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.debuff") + ": " + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.debuff." + debuffType));
        }
    }

    public static void removeDebuff(Fighter fighter, String debuffType) {
        boolean changed = false;
        ListIterator<Effect> it = fighter.effects.listIterator();
        while (it.hasNext()) {
            Effect currEffect = it.next();
            if (!currEffect.type.equalsIgnoreCase(debuffType) && !currEffect.source.equalsIgnoreCase(debuffType)) continue;
            int position = StringList.getPosition(fighter.debuffs, debuffType, ",");
            if (position >= 0) {
                fighter.debuffs = StringList.remove(fighter.debuffs, position, ",");
                if (fighter.isHost) {
                    CombatEngine.combatStateChanges.sendhbu = new StringBuilder(fighter.debuffs);
                } else {
                    CombatEngine.combatStateChanges.sendcbu = new StringBuilder(fighter.debuffs);
                }
            }
            it.remove();
            changed = true;
        }
        if (changed) {
            fighter.preCalculatedCriticalChance = CombatEngine.getCriticalChance(fighter, 50, "const", 0);
            fighter.preCalculatedDamageReduction = CombatEngine.getArmorReduction(fighter);
        }
    }

    public static boolean addComboEffect(Fighter fighter, String combo, String trigger, long combatTime) {
        String[] comboParts;
        boolean changed = false;
        for (String comboPart : comboParts = combo.split("#")) {
            String comboEffect = comboPart;
            if (!comboEffect.contains(trigger)) continue;
            comboEffect = "phase:attack" + comboEffect.substring(comboEffect.indexOf(";"));
            comboEffect = comboEffect.substring(0, comboEffect.indexOf("$"));
            Effect newEffect = Effect.stringToEffect(comboEffect + ":combo");
            CombatEngine.addEffect(fighter, newEffect);
            changed = true;
        }
        if (changed) {
            fighter.preCalculatedCriticalChance = CombatEngine.getCriticalChance(fighter, 50, "const", 0);
            fighter.preCalculatedDamageReduction = CombatEngine.getArmorReduction(fighter);
        }
        return changed;
    }

    public static void removeComboEffects(Fighter fighter) {
        ListIterator<Effect> ite = fighter.effects.listIterator();
        while (ite.hasNext()) {
            Effect currEffect = ite.next();
            if (currEffect.source == null || !currEffect.source.equalsIgnoreCase("combo")) continue;
            ite.remove();
        }
        fighter.preCalculatedCriticalChance = CombatEngine.getCriticalChance(fighter, 50, "const", 0);
        fighter.preCalculatedDamageReduction = CombatEngine.getArmorReduction(fighter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Boolean matchCombo(String aCombo, String currCombo) {
        Boolean matches = null;
        String[] aComboParts = aCombo.split("-");
        String[] currComboParts = currCombo.split("-");
        if (currComboParts.length > Integer.parseInt(aComboParts[0])) return matches;
        String previous = "";
        int i = 1;
        while (i < aComboParts.length) {
            String aComboAction = aComboParts[i].substring(0, 2);
            String currComboAction = currComboParts[i - 1].substring(0, 2);
            if (!aComboAction.equalsIgnoreCase("xx")) {
                if (!aComboAction.equalsIgnoreCase(currComboAction)) return false;
            }
            String aComboDirection = aComboParts[i].substring(2, 4);
            String currComboDirection = currComboParts[i - 1].substring(2, 4);
            if (aComboDirection.equalsIgnoreCase("xx")) {
                previous = currComboParts[i - 1];
            } else if (aComboDirection.equalsIgnoreCase(currComboDirection)) {
                previous = currComboParts[i - 1];
            } else {
                String previousDirection;
                if (aComboDirection.charAt(0) != 's') return false;
                if (currComboDirection.equalsIgnoreCase("mi")) return false;
                String string = previousDirection = previous.equalsIgnoreCase("") ? "" : previous.substring(2, 4);
                if (aComboDirection.charAt(1) == 'x') {
                    previous = currComboParts[i - 1];
                } else if (aComboDirection.charAt(1) == 'o' && (currComboDirection.equalsIgnoreCase("le") && previousDirection.equalsIgnoreCase("ri") || currComboDirection.equalsIgnoreCase("ri") && previousDirection.equalsIgnoreCase("le"))) {
                    previous = currComboParts[i - 1];
                } else {
                    if (aComboDirection.charAt(1) != 's') return false;
                    if (!currComboDirection.equalsIgnoreCase(previousDirection)) return false;
                    previous = currComboParts[i - 1];
                }
            }
            if (i == aComboParts.length - 1) {
                matches = true;
            } else if (i == currComboParts.length) {
                i = aComboParts.length;
            }
            ++i;
        }
        return matches;
    }

    public static void calculateComboStage(Fighter fighter, String action, String direction) {
        String currAction = "";
        if (action.equalsIgnoreCase("attack")) {
            currAction = "at";
        } else if (action.equalsIgnoreCase("parry")) {
            currAction = "pa";
        } else if (action.equalsIgnoreCase("dodge")) {
            currAction = "do";
        }
        if (CombatEngine.combatState.direction.equalsIgnoreCase("left")) {
            currAction = currAction + "le";
        } else if (CombatEngine.combatState.direction.equalsIgnoreCase("right")) {
            currAction = currAction + "ri";
        } else if (CombatEngine.combatState.direction.equalsIgnoreCase("middle")) {
            currAction = currAction + "mi";
        }
        if (!fighter.comboStage.equalsIgnoreCase("")) {
            fighter.comboStage = fighter.comboStage + "-";
        }
        fighter.comboStage = fighter.comboStage + currAction;
        if (CombatEngine.combatState.hostFighter == fighter) {
            CombatEngine.combatStateChanges.hostComboHappenning = CombatEngine.combatState.hostComboHappenning = CombatEngine.comboHappenning(fighter);
            CombatEngine.combatStateChanges.sendhcs = fighter.comboStage;
        } else {
            CombatEngine.combatStateChanges.clientComboHappenning = CombatEngine.combatState.clientComboHappenning = CombatEngine.comboHappenning(fighter);
            CombatEngine.combatStateChanges.sendccs = fighter.comboStage;
        }
    }

    public static String nextComboMovementCandidate(Fighter fighter) {
        StringBuilder movement = new StringBuilder();
        for (int i = 0; i < fighter.knownCombos.size(); ++i) {
            if (fighter.comboStage.equalsIgnoreCase("")) {
                if (!fighter.knownCombos.get(i).split(";")[0].split(":")[1].split("-")[1].startsWith("at")) continue;
                if (movement.length() != 0) {
                    movement.append(";");
                }
                movement.append(fighter.knownCombos.get(i).split(";")[0].split(":")[1].split("-")[1]);
                continue;
            }
            Boolean matches = CombatEngine.matchCombo(fighter.knownCombos.get(i).split(";")[0].split(":")[1], fighter.comboStage);
            if (matches != null) continue;
            if (movement.length() != 0) {
                movement.append(";");
            }
            movement.append(fighter.knownCombos.get(i).split(";")[0].split(":")[1].split("-")[fighter.comboStage.split("-").length + 1]);
        }
        return movement.toString().contains(";") ? movement.toString().split(";")[MathUtils.random(movement.toString().split(";").length - 1)] : movement.toString();
    }

    public static String comboHappenning(Fighter fighter) {
        StringBuilder combo = new StringBuilder();
        boolean comboMaybe = false;
        if (!fighter.comboStage.equalsIgnoreCase("")) {
            for (int i = 0; i < fighter.knownCombos.size(); ++i) {
                Boolean matches = CombatEngine.matchCombo(fighter.knownCombos.get(i).split(";")[0].split(":")[1], fighter.comboStage);
                if (matches != null) {
                    if (!matches.booleanValue()) continue;
                    if (combo.length() != 0) {
                        combo.append("#");
                    }
                    combo.append(fighter.knownCombos.get(i));
                    continue;
                }
                comboMaybe = true;
            }
            if (combo.length() == 0 && !comboMaybe) {
                fighter.comboStage = "";
                if (CombatEngine.combatState.hostFighter == fighter) {
                    CombatEngine.combatStateChanges.sendhcs = fighter.comboStage;
                } else {
                    CombatEngine.combatStateChanges.sendccs = fighter.comboStage;
                }
            }
        }
        return combo.toString();
    }

    public static void checkEventPhaseEffects(Fighter attacker, Fighter defender, String timing, int randomSeed, long combatTime, StringBuilder attackerLog, StringBuilder defenderLog) {
        float debuffModifier;
        String[] info;
        String debuffType;
        String realTiming = timing;
        realTiming = realTiming.replace("event:dam", "event:hit");
        realTiming = realTiming.replace("event:dod", "event:nul");
        realTiming = realTiming.replace("event:par", "event:nul");
        ArrayList<String> actions = new ArrayList<String>();
        StringBuilder attackerNewBuffs = new StringBuilder();
        ListIterator<Effect> ite = attacker.effects.listIterator();
        while (ite.hasNext()) {
            Effect currEffect = ite.next();
            if (!realTiming.contains(currEffect.trigger)) continue;
            int chance = 0;
            if (randomSeed != 0) {
                chance = CombatEngine.getEffectChance(currEffect);
            }
            if (randomSeed != 0 && (chance <= 0 || randomSeed >= chance)) continue;
            if (currEffect.type.equalsIgnoreCase("cure")) {
                if (!currEffect.subtype.equalsIgnoreCase("debuff")) continue;
                actions.add("remdebuff;*");
                if (attacker.debuffs.length() <= 0) continue;
                CombatEngine.addLogTrace(attackerLog, "b;" + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.removed") + " " + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.debuff"));
                if (attacker != CombatEngine.combatState.clientFighter) continue;
                CombatEngine.combatState.clientExceptionalEvent = "stoicstance";
                continue;
            }
            if (currEffect.type.equalsIgnoreCase("interr")) {
                if (!currEffect.subtype.equalsIgnoreCase("buff")) continue;
                actions.add("rembuff;*");
                if (defender.buffs.length() <= 0 || defender.buffs.length() <= 1 && defender.buffs.toString().contains("surge")) continue;
                CombatEngine.addLogTrace(defenderLog, "r;" + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.removed") + " " + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.buff"));
                if (defender != CombatEngine.combatState.hostFighter) continue;
                CombatEngine.combatState.clientExceptionalEvent = "safedisengage";
                continue;
            }
            if (currEffect.type.equalsIgnoreCase("buff")) {
                Effect gainBuff;
                String buffType = currEffect.subtype.substring(0, currEffect.subtype.length() - 1);
                if (buffType.equalsIgnoreCase("ready")) {
                    actions.add("addbuff;" + buffType + ":" + currEffect.subtype + ":" + currEffect.time);
                    if (attacker != CombatEngine.combatState.clientFighter) continue;
                    CombatEngine.combatState.clientExceptionalEvent = "ready";
                    continue;
                }
                if (buffType.equalsIgnoreCase("charge")) {
                    actions.add("addbuff;" + buffType + ":" + currEffect.subtype + ":" + currEffect.time);
                    if (attacker != CombatEngine.combatState.clientFighter) continue;
                    CombatEngine.combatState.clientExceptionalEvent = "charged";
                    continue;
                }
                if (buffType.equalsIgnoreCase("adrena")) {
                    actions.add("addbuff;" + buffType + ":" + currEffect.subtype + ":" + currEffect.time);
                    continue;
                }
                if (buffType.equalsIgnoreCase("frenzy")) {
                    actions.add("addbuff;" + buffType + ":" + currEffect.subtype + ":" + currEffect.time);
                    gainBuff = CombatEngine.getEffect(attacker, null, "gbufre", "", randomSeed);
                    if (gainBuff == null) continue;
                    actions.add("addbuff;rage:" + gainBuff.subtype + ":" + gainBuff.time);
                    if (attacker != CombatEngine.combatState.clientFighter) continue;
                    CombatEngine.combatState.clientExceptionalEvent = "rage";
                    continue;
                }
                if (!buffType.equalsIgnoreCase("rage")) continue;
                actions.add("addbuff;" + buffType + ":" + currEffect.subtype + ":" + currEffect.time);
                gainBuff = CombatEngine.getEffect(attacker, null, "gburag", "", randomSeed);
                if (gainBuff == null) continue;
                actions.add("addbuff;frenzy:" + gainBuff.subtype + ":" + gainBuff.time + ":1.0");
                if (attacker != CombatEngine.combatState.clientFighter) continue;
                CombatEngine.combatState.clientExceptionalEvent = "rage";
                continue;
            }
            if (currEffect.type.equalsIgnoreCase("debuff")) {
                String debuffType2 = currEffect.subtype.substring(0, currEffect.subtype.length() - 1);
                if (debuffType2.equalsIgnoreCase("stun")) {
                    actions.add("adddebuff;" + debuffType2 + ":" + currEffect.subtype + ":" + currEffect.time);
                    continue;
                }
                if (debuffType2.equalsIgnoreCase("bleed")) {
                    actions.add("adddebuff;" + debuffType2 + ":" + currEffect.subtype + ":" + currEffect.time);
                    continue;
                }
                if (debuffType2.equalsIgnoreCase("exhaus")) {
                    actions.add("adddebuff;" + debuffType2 + ":" + currEffect.subtype + ":" + currEffect.time);
                    continue;
                }
                if (!debuffType2.equalsIgnoreCase("weaken")) continue;
                actions.add("adddebuff;" + debuffType2 + ":" + currEffect.subtype + ":" + currEffect.time);
                continue;
            }
            if (!currEffect.type.equalsIgnoreCase("critic") || !currEffect.subtype.equalsIgnoreCase("weadeb")) continue;
            Effect weaponDebuff = Effect.stringToEffect("const;" + CombatEngine.game.stats.get("weapons").getJSONObject(attacker.weapon.id).getString("debuff") + ":debuff");
            debuffType = weaponDebuff.subtype.substring(0, weaponDebuff.subtype.length() - 1);
            actions.add("adddebuff;" + debuffType + ":" + weaponDebuff.subtype + ":" + weaponDebuff.time);
        }
        Effect opportunism = CombatEngine.getEffect(combatState.getAttacker(), "event:debuff", "buff", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10);
        for (String currAction : actions) {
            if (currAction.startsWith("addbuff")) {
                info = currAction.split(";")[1].split(":");
                CombatEngine.addBuff(attacker, info[0], info[1], Long.parseLong(info[2]), combatTime, attackerLog);
                attackerNewBuffs.append(info[0]);
                continue;
            }
            if (currAction.startsWith("rembuff")) {
                CombatEngine.removeBuff(defender, "adrena");
                CombatEngine.removeBuff(defender, "charge");
                CombatEngine.removeBuff(defender, "frenzy");
                CombatEngine.removeBuff(defender, "rage");
                CombatEngine.removeBuff(defender, "ready");
                continue;
            }
            if (currAction.startsWith("adddebuff")) {
                info = currAction.split(";")[1].split(":");
                float debuffTime = Float.parseFloat(info[2]);
                debuffModifier = CombatEngine.getEffectValue(attacker, null, "time", "debuff", randomSeed);
                if ((double)debuffModifier != 0.0) {
                    debuffTime *= debuffModifier;
                }
                CombatEngine.addDebuff(defender, info[0], info[1], (long)debuffTime, combatTime, defenderLog, false);
                if (opportunism == null) continue;
                CombatEngine.addBuff(attacker, opportunism.subtype.substring(0, opportunism.subtype.length() - 1), opportunism.subtype, new Long(opportunism.time), combatTime, attackerLog);
                opportunism = null;
                continue;
            }
            if (!currAction.startsWith("remdebuff")) continue;
            CombatEngine.removeDebuff(attacker, "bleed");
            CombatEngine.removeDebuff(attacker, "exhaus");
            CombatEngine.removeDebuff(attacker, "stun");
            CombatEngine.removeDebuff(attacker, "weaken");
        }
        actions.clear();
        realTiming = timing;
        realTiming = realTiming.replace("phase:attack", "phase:defend");
        realTiming = realTiming.replace("event:hit", "event:dam");
        realTiming = realTiming.replace("event:att", "event:nul");
        realTiming = realTiming.replace("event:ris", "event:nul");
        realTiming = realTiming.replace("event:cha", "event:nul");
        realTiming = realTiming.replace("event:use", "event:nul");
        ite = defender.effects.listIterator();
        while (ite.hasNext()) {
            Effect currEffect = ite.next();
            if (!realTiming.contains(currEffect.trigger)) continue;
            int chance = 0;
            if (randomSeed != 0) {
                chance = CombatEngine.getEffectChance(currEffect);
            }
            if (randomSeed != 0 && (chance <= 0 || randomSeed >= chance)) continue;
            if (currEffect.type.equalsIgnoreCase("cure")) {
                if (!currEffect.subtype.equalsIgnoreCase("debuff")) continue;
                actions.add("remdebuff;*");
                if (defender.debuffs.length() <= 0) continue;
                CombatEngine.addLogTrace(defenderLog, "b;" + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.removed") + " " + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.debuff"));
                continue;
            }
            if (currEffect.type.equalsIgnoreCase("interr")) {
                if (!currEffect.subtype.equalsIgnoreCase("buff")) continue;
                actions.add("rembuff;*");
                if (attacker.buffs.length() <= 0 || attacker.buffs.length() <= 1 && attacker.buffs.toString().contains("surge")) continue;
                CombatEngine.addLogTrace(attackerLog, "r;" + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.removed") + " " + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.buff"));
                continue;
            }
            if (currEffect.type.equalsIgnoreCase("buff")) {
                Effect gainBuff;
                String buffType = currEffect.subtype.substring(0, currEffect.subtype.length() - 1);
                if (buffType.equalsIgnoreCase("ready")) {
                    actions.add("addbuff;" + buffType + ":" + currEffect.subtype + ":" + currEffect.time);
                    if (defender != CombatEngine.combatState.clientFighter) continue;
                    CombatEngine.combatState.clientExceptionalEvent = "ready";
                    continue;
                }
                if (buffType.equalsIgnoreCase("charge")) {
                    actions.add("addbuff;" + buffType + ":" + currEffect.subtype + ":" + currEffect.time);
                    if (defender != CombatEngine.combatState.clientFighter) continue;
                    CombatEngine.combatState.clientExceptionalEvent = "charged";
                    continue;
                }
                if (buffType.equalsIgnoreCase("adrena")) {
                    actions.add("addbuff;" + buffType + ":" + currEffect.subtype + ":" + currEffect.time);
                    continue;
                }
                if (buffType.equalsIgnoreCase("frenzy")) {
                    actions.add("addbuff;" + buffType + ":" + currEffect.subtype + ":" + currEffect.time);
                    gainBuff = CombatEngine.getEffect(defender, null, "gbufre", "", randomSeed);
                    if (gainBuff == null) continue;
                    actions.add("addbuff;rage:" + gainBuff.subtype + ":" + gainBuff.time);
                    if (defender != CombatEngine.combatState.clientFighter) continue;
                    CombatEngine.combatState.clientExceptionalEvent = "rage";
                    continue;
                }
                if (!buffType.equalsIgnoreCase("rage")) continue;
                actions.add("addbuff;" + buffType + ":" + currEffect.subtype + ":" + currEffect.time);
                gainBuff = CombatEngine.getEffect(defender, null, "gburag", "", randomSeed);
                if (gainBuff == null) continue;
                actions.add("addbuff;frenzy:" + gainBuff.subtype + ":" + gainBuff.time + ":1.0");
                if (defender != CombatEngine.combatState.clientFighter) continue;
                CombatEngine.combatState.clientExceptionalEvent = "rage";
                continue;
            }
            if (!currEffect.type.equalsIgnoreCase("debuff")) continue;
            debuffType = currEffect.subtype.substring(0, currEffect.subtype.length() - 1);
            if (debuffType.equalsIgnoreCase("stun")) {
                actions.add("adddebuff;" + debuffType + ":" + currEffect.subtype + ":" + currEffect.time);
                continue;
            }
            if (debuffType.equalsIgnoreCase("bleed")) {
                actions.add("adddebuff;" + debuffType + ":" + currEffect.subtype + ":" + currEffect.time);
                continue;
            }
            if (debuffType.equalsIgnoreCase("exhaus")) {
                actions.add("adddebuff;" + debuffType + ":" + currEffect.subtype + ":" + currEffect.time);
                continue;
            }
            if (!debuffType.equalsIgnoreCase("weaken")) continue;
            actions.add("adddebuff;" + debuffType + ":" + currEffect.subtype + ":" + currEffect.time);
            if (attacker != CombatEngine.combatState.hostFighter || !currEffect.chance.startsWith("asra")) continue;
            CombatEngine.combatState.clientExceptionalEvent = "overtire";
        }
        opportunism = CombatEngine.getEffect(combatState.getDefender(), "event:debuff", "buff", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10);
        for (String currAction : actions) {
            if (currAction.startsWith("addbuff")) {
                info = currAction.split(";")[1].split(":");
                CombatEngine.addBuff(defender, info[0], info[1], Long.parseLong(info[2]), combatTime, defenderLog);
                continue;
            }
            if (currAction.startsWith("rembuff")) {
                if (attackerNewBuffs.indexOf("adrena") < 0) {
                    CombatEngine.removeBuff(attacker, "adrena");
                }
                if (attackerNewBuffs.indexOf("charge") < 0) {
                    CombatEngine.removeBuff(attacker, "charge");
                }
                if (attackerNewBuffs.indexOf("frenzy") < 0) {
                    CombatEngine.removeBuff(attacker, "frenzy");
                }
                if (attackerNewBuffs.indexOf("rage") < 0) {
                    CombatEngine.removeBuff(attacker, "rage");
                }
                if (attackerNewBuffs.indexOf("ready") >= 0) continue;
                CombatEngine.removeBuff(attacker, "ready");
                continue;
            }
            if (currAction.startsWith("adddebuff")) {
                info = currAction.split(";")[1].split(":");
                float debuffTime = Float.parseFloat(info[2]);
                debuffModifier = CombatEngine.getEffectValue(defender, null, "time", "debuff", randomSeed);
                if ((double)debuffModifier != 0.0) {
                    debuffTime *= debuffModifier;
                }
                CombatEngine.addDebuff(attacker, info[0], info[1], (long)debuffTime, combatTime, attackerLog, false);
                if (opportunism == null) continue;
                CombatEngine.addBuff(defender, opportunism.subtype.substring(0, opportunism.subtype.length() - 1), opportunism.subtype, new Long(opportunism.time), combatTime, defenderLog);
                opportunism = null;
                continue;
            }
            if (!currAction.startsWith("remdebuff")) continue;
            CombatEngine.removeDebuff(defender, "bleed");
            CombatEngine.removeDebuff(defender, "exhaus");
            CombatEngine.removeDebuff(defender, "stun");
            CombatEngine.removeDebuff(defender, "weaken");
        }
    }

    public static String applyCombatEvent(String type, String option, int deviation, Fighter active, Fighter passive, long combatTime) {
        String result = "";
        System.out.println("CombatEngine.applyCombatEvent state " + CombatEngine.combatState.stage + " type " + type + " option " + option + " ishost " + active.isPlayer);
        if (type.equalsIgnoreCase("surge")) {
            return CombatEngine.runSurgeStage(type, option, deviation, active, passive, combatTime);
        }
        if (CombatEngine.combatState.clientFighter.name.contains("boss1")) {
            CombatEngine.combatState.clientBossSpecial = "";
        }
        if (CombatEngine.combatState.stage.equalsIgnoreCase("")) {
            CombatEngine.combatStateChanges.vulnerableDirection = CombatEngine.combatState.vulnerableDirection = CombatEngine.getVulnerableDirection(CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827));
        } else if (CombatEngine.combatState.stage.equalsIgnoreCase("start")) {
            result = CombatEngine.runStartStage(type, option, deviation, active, passive, combatTime);
        } else if (CombatEngine.combatState.stage.equalsIgnoreCase("attack")) {
            result = CombatEngine.runAttackStage(type, option, deviation, active, passive, combatTime);
        } else if (CombatEngine.combatState.stage.equalsIgnoreCase("hit")) {
            result = CombatEngine.runHitStage(type, option, deviation, active, passive, combatTime);
        } else if (CombatEngine.combatState.stage.equalsIgnoreCase("miss-parry")) {
            result = CombatEngine.runMissParryStage(type, option, deviation, active, passive, combatTime);
        } else if (CombatEngine.combatState.stage.equalsIgnoreCase("miss-dodge")) {
            result = CombatEngine.runMissDodgeStage(type, option, deviation, active, passive, combatTime);
        } else if (CombatEngine.combatState.stage.equalsIgnoreCase("chain")) {
            result = CombatEngine.runChainStage(type, option, deviation, active, passive, combatTime);
        } else if (CombatEngine.combatState.stage.equalsIgnoreCase("risposte")) {
            result = CombatEngine.runRisposteStage(type, option, deviation, active, passive, combatTime);
        }
        System.out.println("CombatEngine.applyCombatEvent result " + result);
        CombatEngine.combatState.lastCombatEvent = result;
        CombatEngine.combatStateChanges.lastCombatEvent = result;
        return result;
    }

    public static String runSurgeStage(String type, String option, int deviation, Fighter active, Fighter passive, long combatTime) {
        CombatEngine.applySurge(active, option, combatTime);
        CombatEngine.combatState.lastCombatEvent = "surge";
        CombatEngine.combatStateChanges.lastCombatEvent = "surge";
        return "surge:" + (combatState.getAttacker() == active ? "attacker" : "defender");
    }

    public static String runStartStage(String type, String option, int deviation, Fighter active, Fighter passive, long combatTime) {
        Effect surge;
        StringBuilder passiveLog;
        String result = "";
        damageReceived = 0;
        String event = "";
        String phase = "";
        String combo = "";
        StringBuilder activeLog = active.isHost ? CombatEngine.combatState.hostLog : CombatEngine.combatState.clientLog;
        StringBuilder stringBuilder = passiveLog = active.isHost ? CombatEngine.combatState.clientLog : CombatEngine.combatState.hostLog;
        if (CombatEngine.combatState.isChain.booleanValue()) {
            CombatEngine.combatState.isChain = false;
            CombatEngine.combatStateChanges.timePressure = CombatEngine.combatState.timePressure = Float.valueOf(1.0f);
        }
        if (type.equalsIgnoreCase("attack")) {
            event = "event:attbas";
            phase = "phase:attack";
            int staminaCost = CombatEngine.getStaminaCost("attack", active, passive, deviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10);
            if (CombatEngine.canPayStamina(active, "attack", staminaCost, 0, true, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10)) {
                CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "attack";
                if (combatState.getAssaultFighter() == active) {
                    CombatEngine.combatStateChanges.assaultPressure = CombatEngine.combatState.assaultPressure = Integer.valueOf(CombatEngine.combatState.assaultPressure + 1);
                } else {
                    CombatEngine.combatStateChanges.assaultFighter = CombatEngine.combatState.assaultFighter = active.isHost ? "host" : "client";
                    CombatEngine.combatStateChanges.assaultPressure = CombatEngine.combatState.assaultPressure = Integer.valueOf(0);
                }
                CombatEngine.combatStateChanges.attacker = CombatEngine.combatState.attacker = active.isHost ? "host" : "client";
                CombatEngine.combatStateChanges.defender = CombatEngine.combatState.defender = passive.isHost ? "host" : "client";
                CombatEngine.combatStateChanges.direction = CombatEngine.combatState.direction = option;
                attackerDeviation = deviation;
                CombatEngine.addLogTrace(activeLog, "l;Attack " + option + ", deviation " + deviation);
                CombatEngine.calculateComboStage(combatState.getAttacker(), type, option);
                String string = combo = combatState.getAttacker() == CombatEngine.combatState.hostFighter ? CombatEngine.combatState.hostComboHappenning : CombatEngine.combatState.clientComboHappenning;
                if (!combo.equalsIgnoreCase("")) {
                    CombatEngine.addComboEffect(combatState.getAttacker(), combo, "comatt", combatTime);
                }
                combo = "";
                result = "parry:" + CombatEngine.getParryTime(combatState.getAttacker(), combatState.getDefender(), deviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10) + ";dodge:" + CombatEngine.getDodgeTime(combatState.getAttacker(), combatState.getDefender(), deviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10);
                if (CombatEngine.getEffect(combatState.getAttacker(), null, "surge", "", 0) == null) {
                    float isSurge = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "suradd", "attdev", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947) / 10);
                    if ((double)isSurge != 0.0) {
                        CombatEngine.combatState.getAttacker().surge += (50 - attackerDeviation) * Float.valueOf((float)staminaCost * isSurge).intValue();
                        CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:surge:1" : "c:surge:1", ",");
                    }
                    if (CombatEngine.combatState.getAttacker().surge > 10000) {
                        CombatEngine.combatState.getAttacker().surge = 10000;
                    }
                    if (CombatEngine.combatState.getAttacker().isHost) {
                        CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                    } else {
                        CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                    }
                }
                if (scenario.equalsIgnoreCase("coal") && combatState.getAttacker() == CombatEngine.combatState.hostFighter && attackerDeviation > 0) {
                    int scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getInt("deviationDamage");
                    CombatEngine.combatState.getAttacker().life -= scenarioModifier * attackerDeviation / 50;
                    CombatEngine.combatStateChanges.sendhli = CombatEngine.combatState.getAttacker().life;
                    CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:life:-1" : "c:life:-1", ",");
                    CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, "c:scenario", ",");
                    CombatEngine.combatStateChanges.effectsToPlay = new StringBuilder(CombatEngine.combatState.effectsToPlay);
                }
                CombatEngine.removeBuff(combatState.getAttacker(), "ready");
                if (combatState.getAttacker() == CombatEngine.combatState.clientFighter && CombatEngine.combatState.clientBossSpecial.contains("lightcharge")) {
                    CombatEngine.combatState.clientBossSpecial = "lightattack" + option;
                }
            }
        } else if (type.equalsIgnoreCase("use")) {
            event = "event:use";
            phase = "phase:attack";
            CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "attack";
            CombatEngine.combatStateChanges.attacker = CombatEngine.combatState.attacker = active.isHost ? "host" : "client";
            CombatEngine.combatStateChanges.defender = CombatEngine.combatState.defender = passive.isHost ? "host" : "client";
            CombatEngine.combatStateChanges.isUse = CombatEngine.combatState.isUse = Boolean.valueOf(true);
            CombatEngine.combatStateChanges.direction = CombatEngine.combatState.direction = option;
            attackerDeviation = deviation;
            CombatEngine.addLogTrace(activeLog, "l;Use " + option + ", deviation " + deviation);
            CombatEngine.combatState.getAttacker().comboStage = "";
            if (CombatEngine.combatState.hostFighter == combatState.getAttacker()) {
                CombatEngine.combatStateChanges.sendhcs = "";
            } else {
                CombatEngine.combatStateChanges.sendccs = "";
            }
            String item = "shard";
            if (CombatEngine.combatState.getAttacker().services.contains("powder")) {
                item = "powder";
            } else if (CombatEngine.combatState.getAttacker().services.contains("net")) {
                item = "net";
            }
            result = "parry:" + CombatEngine.getUseTime(combatState.getAttacker(), combatState.getDefender(), item, "parry", event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10) + ";dodge:" + CombatEngine.getUseTime(combatState.getAttacker(), combatState.getDefender(), item, "dodge", event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10);
            --CombatEngine.combatState.getAttacker().itemUses;
            if (CombatEngine.combatState.getAttacker().isHost) {
                CombatEngine.combatStateChanges.sendhiu = CombatEngine.combatState.getAttacker().itemUses;
            } else {
                CombatEngine.combatStateChanges.sendciu = CombatEngine.combatState.getAttacker().itemUses;
            }
        } else if (type.equalsIgnoreCase("idle")) {
            active.comboStage = "";
            passive.comboStage = "";
            CombatEngine.combatStateChanges.sendhcs = "";
            CombatEngine.combatStateChanges.sendccs = "";
            Fighter prevAttacker = combatState.getAttacker();
            CombatEngine.combatStateChanges.attacker = CombatEngine.combatState.attacker = CombatEngine.combatState.getDefender().isHost ? "host" : "client";
            CombatEngine.combatStateChanges.defender = CombatEngine.combatState.defender = prevAttacker.isHost ? "host" : "client";
            CombatEngine.combatStateChanges.vulnerableDirection = CombatEngine.combatState.vulnerableDirection = CombatEngine.getVulnerableDirection(CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827));
            if (combatState.getAttacker() == CombatEngine.combatState.hostFighter && CombatEngine.combatState.clientFighter.name.contains("boss1")) {
                int chanceForbidden;
                int n = CombatEngine.combatState.clientFighter.life < 3000 ? 100 : (chanceForbidden = CombatEngine.combatState.clientFighter.life < 6000 ? 50 : 0);
                CombatEngine.combatState.clientBossSpecial = MathUtils.random(99) > chanceForbidden ? "" : (chanceForbidden == 50 ? "left" : (MathUtils.random(1) == 0 ? "right" : "left"));
            }
        }
        CombatEngine.checkEventPhaseEffects(active, passive, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827) / 10, combatTime, activeLog, passiveLog);
        CombatEngine.removeItemEffects(active);
        CombatEngine.removeComboEffects(active);
        if (type.equalsIgnoreCase("idle") && (surge = CombatEngine.getEffect(combatState.getAttacker(), "event:idle", "brink", "", 0)) != null) {
            CombatEngine.addBuff(combatState.getAttacker(), "ready", "ready" + surge.subtype, Long.parseLong(surge.time), combatTime, passiveLog);
            CombatEngine.addBuff(combatState.getAttacker(), "charge", "charge" + surge.subtype, Long.parseLong(surge.time), combatTime, passiveLog);
        }
        if (!combo.equalsIgnoreCase("")) {
            active.comboStage = "";
            if (CombatEngine.combatState.hostFighter == active) {
                CombatEngine.combatStateChanges.sendhcs = "";
            } else {
                CombatEngine.combatStateChanges.sendccs = "";
            }
        }
        return result;
    }

    public static String runAttackStage(String type, String option, int deviation, Fighter active, Fighter passive, long combatTime) {
        int staminaCost;
        String result = "";
        damageReceived = 0;
        String event = "";
        String phase = "";
        String combo = "";
        StringBuilder activeLog = active.isHost ? CombatEngine.combatState.hostLog : CombatEngine.combatState.clientLog;
        StringBuilder passiveLog = active.isHost ? CombatEngine.combatState.clientLog : CombatEngine.combatState.hostLog;
        phase = "phase:attack";
        boolean wrongDirection = false;
        risposteStamina = 0;
        if (CombatEngine.combatState.isChain.booleanValue()) {
            CombatEngine.combatState.isChain = false;
            CombatEngine.combatStateChanges.timePressure = CombatEngine.combatState.timePressure = Float.valueOf(1.0f);
        }
        if (type.equalsIgnoreCase("parry")) {
            event = "event:parbas";
            if (option.equalsIgnoreCase("middle") && option.equalsIgnoreCase(CombatEngine.combatState.direction) || option.equalsIgnoreCase("right") && CombatEngine.combatState.direction.equalsIgnoreCase("left") || option.equalsIgnoreCase("left") && CombatEngine.combatState.direction.equalsIgnoreCase("right")) {
                defenderDeviation = deviation;
                staminaCost = CombatEngine.getStaminaCost("parry", combatState.getAttacker(), combatState.getDefender(), attackerDeviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10);
                if (CombatEngine.canPayStamina(combatState.getDefender(), "parry", staminaCost, 0, true, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10)) {
                    float damageToStamina;
                    boolean effectAdded;
                    CombatEngine.addLogTrace(activeLog, "l;Parry " + option + ", deviation " + deviation);
                    event = event + "&event:parsuc";
                    CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "miss-parry";
                    CombatEngine.combatStateChanges.timePressure = CombatEngine.combatState.timePressure = Float.valueOf(MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * timePressureReduction, 0.05f, 1.0f));
                    CombatEngine.calculateComboStage(combatState.getDefender(), type, option);
                    combo = combatState.getDefender() == CombatEngine.combatState.hostFighter ? CombatEngine.combatState.hostComboHappenning : CombatEngine.combatState.clientComboHappenning;
                    String string = combo = combatState.getAttacker() == CombatEngine.combatState.hostFighter ? CombatEngine.combatState.hostComboHappenning : CombatEngine.combatState.clientComboHappenning;
                    if (!combo.equalsIgnoreCase("") && (effectAdded = CombatEngine.addComboEffect(combatState.getAttacker(), combo, "commip", combatTime))) {
                        float staminaComboBonus;
                        float assaultComboBonus = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "assaul", "comsuc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10);
                        if ((double)assaultComboBonus != 0.0) {
                            CombatEngine.combatStateChanges.assaultPressure = CombatEngine.combatState.assaultPressure = Integer.valueOf(CombatEngine.combatState.assaultPressure + Float.valueOf(assaultComboBonus).intValue());
                            CombatEngine.combatState.clientExceptionalEvent = "impulse";
                        }
                        if ((double)(staminaComboBonus = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "stamin", "comsuc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10)) != 0.0) {
                            CombatEngine.combatState.getAttacker().stamina += Float.valueOf(staminaComboBonus * 100.0f).intValue();
                            CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:stamin:1" : "c:stamin:1", ",");
                            if (CombatEngine.combatState.getAttacker().stamina > CombatEngine.combatState.getAttacker().maxStamina) {
                                CombatEngine.combatState.getAttacker().stamina = CombatEngine.combatState.getAttacker().maxStamina;
                            }
                            if (CombatEngine.combatState.getAttacker().isHost) {
                                CombatEngine.combatStateChanges.sendhst = CombatEngine.combatState.getAttacker().stamina;
                            } else {
                                CombatEngine.combatStateChanges.sendcst = CombatEngine.combatState.getAttacker().stamina;
                            }
                        }
                    }
                    CombatEngine.combatState.getAttacker().comboStage = "";
                    if (CombatEngine.combatState.hostFighter == combatState.getAttacker()) {
                        CombatEngine.combatStateChanges.sendhcs = "";
                    } else {
                        CombatEngine.combatStateChanges.sendccs = "";
                    }
                    int damageDealt = 0;
                    int damageReduced = 0;
                    boolean barrier = false;
                    if (!CombatEngine.combatState.isUse.booleanValue()) {
                        float isSurge;
                        Effect surge;
                        damageDealt = CombatEngine.getDamageDealt(combatState.getAttacker(), combatState.getDefender(), defenderDeviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947) / 10, CombatEngine.combatState.vulnerableDirection.equalsIgnoreCase(CombatEngine.combatState.direction));
                        if (combatState.getDefender() == CombatEngine.combatState.clientFighter && scenario.equalsIgnoreCase("barricades") && CombatEngine.combatState.scenarioLife > 0) {
                            float scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getFloat("damageReduction");
                            if (CombatEngine.combatState.scenarioLife < Float.valueOf((float)damageDealt * scenarioModifier).intValue()) {
                                damageDealt -= CombatEngine.combatState.scenarioLife.intValue();
                                CombatEngine.combatState.scenarioLife = 0;
                                CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, "c:scenario", ",");
                                CombatEngine.combatStateChanges.effectsToPlay = new StringBuilder(CombatEngine.combatState.effectsToPlay);
                            } else {
                                CombatEngine.combatState.scenarioLife = CombatEngine.combatState.scenarioLife - Float.valueOf((float)damageDealt * scenarioModifier).intValue();
                                damageDealt = Float.valueOf((float)damageDealt * scenarioModifier).intValue();
                            }
                        }
                        damageReduced = damageDealt - CombatEngine.getArmorDamageReduction(damageDealt, combatState.getAttacker(), combatState.getDefender(), CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10);
                        damageDealt -= damageReduced;
                        if (combatState.getAttacker() == CombatEngine.combatState.clientFighter && CombatEngine.combatState.clientBossSpecial.contains("lightattack")) {
                            damageDealt += 1000;
                            CombatEngine.addDebuff(combatState.getDefender(), "weaken", "weaken1", 20000L, combatTime, activeLog, false);
                        }
                        if ((surge = CombatEngine.getEffect(combatState.getDefender(), null, "gain", "damsur", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10)) != null) {
                            barrier = true;
                        }
                        if (!barrier && CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10 < CombatEngine.getCriticalChance(combatState.getAttacker(), attackerDeviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10)) {
                            damageDealt = Float.valueOf((float)CombatEngine.getCriticalDamage(damageDealt, combatState.getAttacker(), event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827) / 10) * (CombatEngine.combatState.getDefender().isPlayer ? damageMultiplier : 1.0f)).intValue();
                            result = "miss-parry:" + damageDealt + ";critical:0";
                            CombatEngine.addLogTrace(activeLog, "l;Parry critical, damage " + damageDealt / 10);
                            if (CombatEngine.getEffect(combatState.getAttacker(), null, "surge", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10) == null && (double)(isSurge = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "suradd", "damage", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10)) != 0.0) {
                                CombatEngine.combatState.getAttacker().surge += Float.valueOf((float)damageDealt * isSurge * 1.5f).intValue();
                                if (CombatEngine.combatState.getAttacker().surge > 10000) {
                                    CombatEngine.combatState.getAttacker().surge = 10000;
                                }
                                if (CombatEngine.combatState.getAttacker().isHost) {
                                    CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                                } else {
                                    CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                                }
                                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:surge:1" : "c:surge:1", ",");
                            }
                        } else {
                            damageDealt = Float.valueOf((float)damageDealt * (CombatEngine.combatState.getDefender().isPlayer ? damageMultiplier : 1.0f)).intValue();
                            result = "miss-parry:" + damageDealt + ";normal:0";
                            CombatEngine.addLogTrace(activeLog, "l;Parry normal, damage " + damageDealt / 10);
                            if (CombatEngine.getEffect(combatState.getAttacker(), null, "surge", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10) == null && (double)(isSurge = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "suradd", "damage", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10)) != 0.0) {
                                CombatEngine.combatState.getAttacker().surge += Float.valueOf((float)damageDealt * isSurge).intValue();
                                if (CombatEngine.combatState.getAttacker().surge > 10000) {
                                    CombatEngine.combatState.getAttacker().surge = 10000;
                                }
                                if (CombatEngine.combatState.getAttacker().isHost) {
                                    CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                                } else {
                                    CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                                }
                                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:surge:1" : "c:surge:1", ",");
                            }
                        }
                    } else {
                        result = "miss-parry:" + damageDealt + ";normal:0";
                        CombatEngine.addLogTrace(activeLog, "l;Parry normal, damage " + damageDealt / 10);
                    }
                    risposteStamina = (int)CombatEngine.getRisposteStamina("parry", combatState.getDefender(), combatState.getAttacker(), defenderDeviation, event, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947));
                    if (scenario.equalsIgnoreCase("coal") && combatState.getDefender() == CombatEngine.combatState.hostFighter && defenderDeviation > 0) {
                        int scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getInt("deviationDamage");
                        damageDealt += scenarioModifier * defenderDeviation / 50;
                        CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, "c:scenario", ",");
                        CombatEngine.combatStateChanges.effectsToPlay = new StringBuilder(CombatEngine.combatState.effectsToPlay);
                    }
                    if ((damageToStamina = CombatEngine.getEffectValue(combatState.getDefender(), null, "gain", "damsta", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10)) != 0.0f) {
                        CombatEngine.combatState.getDefender().stamina += Float.valueOf((float)damageDealt * damageToStamina).intValue();
                        CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:stamin:1" : "c:stamin:1", ",");
                        if (CombatEngine.combatState.getDefender().stamina > CombatEngine.combatState.getDefender().maxStamina) {
                            CombatEngine.combatState.getDefender().stamina = CombatEngine.combatState.getDefender().maxStamina;
                        }
                        if (CombatEngine.combatState.getDefender().isHost) {
                            CombatEngine.combatStateChanges.sendhst = CombatEngine.combatState.getDefender().stamina;
                        } else {
                            CombatEngine.combatStateChanges.sendcst = CombatEngine.combatState.getDefender().stamina;
                        }
                        CombatEngine.addLogTrace(passiveLog, "l;Gain stamina: " + Float.valueOf((float)damageDealt * damageToStamina).intValue() / 10);
                    }
                    if ((damageToStamina = CombatEngine.getEffectValue(combatState.getDefender(), null, "gain", "stapar", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10)) != 0.0f) {
                        CombatEngine.combatState.getAttacker().stamina -= Float.valueOf(damageToStamina).intValue();
                        CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:stamin:-1" : "c:stamin:-1", ",");
                        if (CombatEngine.combatState.getAttacker().stamina < 0) {
                            CombatEngine.combatState.getAttacker().stamina = 0;
                        }
                        if (CombatEngine.combatState.getAttacker().isHost) {
                            CombatEngine.combatStateChanges.sendhst = CombatEngine.combatState.getAttacker().stamina;
                        } else {
                            CombatEngine.combatStateChanges.sendcst = CombatEngine.combatState.getAttacker().stamina;
                        }
                        CombatEngine.addLogTrace(activeLog, "l;Lose stamina: " + Float.valueOf(damageToStamina).intValue() / 10);
                    }
                    if (!barrier) {
                        Effect damageReturn = CombatEngine.getEffect(combatState.getDefender(), event + ";" + phase, "gain", "dameff", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10);
                        if (damageReturn != null && CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827) / 10 < CombatEngine.getEffectChance(damageReturn)) {
                            int damageRetributed = (int)(Float.parseFloat(damageReturn.value) * (float)(CombatEngine.combatState.getAttacker().debuffs.toString().split(",").length + CombatEngine.combatState.getDefender().buffs.toString().split(",").length));
                            CombatEngine.combatState.getAttacker().life -= damageRetributed;
                            CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:life:-1" : "c:life:-1", ",");
                            if (CombatEngine.combatState.getAttacker().life < 0) {
                                CombatEngine.combatState.getAttacker().life = 0;
                            }
                            if (CombatEngine.combatState.getAttacker().isHost) {
                                CombatEngine.combatStateChanges.sendhli = CombatEngine.combatState.getAttacker().life;
                            } else {
                                CombatEngine.combatStateChanges.sendcli = CombatEngine.combatState.getAttacker().life;
                            }
                        }
                        CombatEngine.combatState.getDefender().life -= damageDealt;
                        CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:life:-1" : "c:life:-1", ",");
                    } else {
                        if (CombatEngine.combatState.getDefender().surge >= damageDealt) {
                            CombatEngine.combatState.getDefender().surge -= damageDealt;
                            if (CombatEngine.combatState.getDefender().surge < 0) {
                                CombatEngine.combatState.getDefender().surge = 0;
                            }
                        } else {
                            Effect damageReturn = CombatEngine.getEffect(combatState.getDefender(), event + ";" + phase, "gain", "dameff", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10);
                            if (damageReturn != null && CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10 < CombatEngine.getEffectChance(damageReturn)) {
                                int damageRetributed = (int)(Float.parseFloat(damageReturn.value) * (float)(CombatEngine.combatState.getAttacker().debuffs.toString().split(",").length + CombatEngine.combatState.getDefender().buffs.toString().split(",").length));
                                CombatEngine.combatState.getAttacker().life -= damageRetributed;
                                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:life:-1" : "c:life:-1", ",");
                                if (CombatEngine.combatState.getAttacker().life < 0) {
                                    CombatEngine.combatState.getAttacker().life = 0;
                                }
                                if (CombatEngine.combatState.getAttacker().isHost) {
                                    CombatEngine.combatStateChanges.sendhli = CombatEngine.combatState.getAttacker().life;
                                } else {
                                    CombatEngine.combatStateChanges.sendcli = CombatEngine.combatState.getAttacker().life;
                                }
                            }
                            CombatEngine.combatState.getDefender().life -= damageDealt - CombatEngine.combatState.getDefender().surge;
                            CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:life:-1" : "c:life:-1", ",");
                            CombatEngine.combatState.getDefender().surge = 0;
                        }
                        if (CombatEngine.combatState.getDefender().isHost) {
                            CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getDefender().surge;
                        } else {
                            CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getDefender().surge;
                        }
                        CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:surge:-1" : "c:surge:-1", ",");
                    }
                    damageReceived = damageDealt;
                    if (CombatEngine.combatState.getDefender().life < 0) {
                        CombatEngine.combatState.getDefender().life = 0;
                    }
                    if (CombatEngine.combatState.getDefender().isHost) {
                        CombatEngine.combatStateChanges.sendhli = CombatEngine.combatState.getDefender().life;
                    } else {
                        CombatEngine.combatStateChanges.sendcli = CombatEngine.combatState.getDefender().life;
                    }
                    if (CombatEngine.getEffect(combatState.getDefender(), null, "surge", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10) == null) {
                        CombatEngine.combatState.getDefender().surge += damageDealt * 2;
                        CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:surge:1" : "c:surge:1", ",");
                        float isSurge = CombatEngine.getEffectValue(combatState.getDefender(), event + ";" + phase, "suradd", "pardev", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10);
                        if ((double)isSurge != 0.0) {
                            CombatEngine.combatState.getDefender().surge += (50 - defenderDeviation) * Float.valueOf((100.0f - CombatEngine.combatState.timePressure.floatValue() * 100.0f) * isSurge).intValue();
                        }
                        if ((double)(isSurge = CombatEngine.getEffectValue(combatState.getDefender(), event + ";" + phase, "suradd", "damred", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947) / 10)) != 0.0) {
                            CombatEngine.combatState.getDefender().surge += Float.valueOf((float)damageReduced * isSurge).intValue();
                        }
                        if (CombatEngine.combatState.getDefender().surge > 10000) {
                            CombatEngine.combatState.getDefender().surge = 10000;
                        }
                        if (CombatEngine.combatState.getDefender().isHost) {
                            CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getDefender().surge;
                        } else {
                            CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getDefender().surge;
                        }
                    }
                    CombatEngine.combatState.soundsToPlay = StringList.append(CombatEngine.combatState.soundsToPlay, CombatEngine.getCombatSound("parry"), ",");
                    CombatEngine.combatStateChanges.soundsToPlay = new StringBuilder(CombatEngine.combatState.soundsToPlay);
                } else {
                    event = event + "&event:parfai";
                }
            } else {
                event = event + "&event:parfai";
                wrongDirection = true;
            }
        } else if (type.equalsIgnoreCase("dodge")) {
            event = "event:dodbas";
            if (!(!CombatEngine.combatState.direction.equalsIgnoreCase("middle") && !option.equalsIgnoreCase(CombatEngine.combatState.direction) || CombatEngine.bossSpecialCondition(type, option) && combatState.getDefender() != CombatEngine.combatState.clientFighter)) {
                defenderDeviation = deviation;
                staminaCost = CombatEngine.getStaminaCost("dodge", combatState.getAttacker(), combatState.getDefender(), attackerDeviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10);
                int balanceCost = CombatEngine.getBalanceCost(combatState.getAttacker(), combatState.getDefender(), deviation, attackerDeviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10);
                float acrobatics = CombatEngine.getEffectValue(combatState.getDefender(), "const", "dodge", "stabal", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10);
                if ((double)acrobatics != 0.0) {
                    float acrobaticsReduction = CombatEngine.getEffectValue(combatState.getDefender(), "const", "dodge", "balcos", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827) / 10);
                    balanceCost += (int)((float)staminaCost * acrobatics * acrobaticsReduction);
                    staminaCost = 0;
                }
                if (balanceCost <= CombatEngine.combatState.getDefender().balance && CombatEngine.canPayStamina(combatState.getDefender(), "dodge", staminaCost, balanceCost, true, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10)) {
                    boolean effectAdded;
                    CombatEngine.addLogTrace(activeLog, "l;Dodge " + option + ", deviation " + deviation);
                    event = event + "&event:dodsuc";
                    Effect surgePress = CombatEngine.getEffect(combatState.getDefender(), null, "gain", "dambal", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10);
                    if (surgePress != null) {
                        balanceCost = Float.valueOf((float)CombatEngine.combatState.getDefender().balance * Float.parseFloat(surgePress.value)).intValue();
                        Effect surgeBarrie = CombatEngine.getEffect(combatState.getAttacker(), null, "gain", "damsur", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10);
                        if (surgeBarrie != null) {
                            CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:surge:-1" : "c:surge:-1", ",");
                            if (CombatEngine.combatState.getAttacker().surge >= balanceCost / 4) {
                                CombatEngine.combatState.getAttacker().surge -= balanceCost / 4;
                                if (CombatEngine.combatState.getAttacker().surge < 0) {
                                    CombatEngine.combatState.getAttacker().surge = 0;
                                }
                            } else {
                                CombatEngine.combatState.getAttacker().life -= balanceCost / 4 - CombatEngine.combatState.getDefender().surge;
                                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:life:-1" : "c:life:-1", ",");
                                CombatEngine.combatState.getAttacker().surge = 0;
                                if (CombatEngine.combatState.getAttacker().isHost) {
                                    CombatEngine.combatStateChanges.sendhli = CombatEngine.combatState.getAttacker().life;
                                } else {
                                    CombatEngine.combatStateChanges.sendcli = CombatEngine.combatState.getAttacker().life;
                                }
                            }
                            if (CombatEngine.combatState.getAttacker().isHost) {
                                CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                            } else {
                                CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                            }
                        } else {
                            CombatEngine.combatState.getAttacker().life -= balanceCost / 4;
                            CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:life:-1" : "c:life:-1", ",");
                            if (CombatEngine.combatState.getAttacker().life < 0) {
                                CombatEngine.combatState.getAttacker().life = 0;
                            }
                            if (CombatEngine.combatState.getAttacker().isHost) {
                                CombatEngine.combatStateChanges.sendhli = CombatEngine.combatState.getAttacker().life;
                            } else {
                                CombatEngine.combatStateChanges.sendcli = CombatEngine.combatState.getAttacker().life;
                            }
                        }
                    }
                    CombatEngine.combatState.getDefender().balance -= balanceCost;
                    if (CombatEngine.combatState.getDefender().isHost) {
                        CombatEngine.combatStateChanges.sendhba = CombatEngine.combatState.getDefender().balance;
                    } else {
                        CombatEngine.combatStateChanges.sendcba = CombatEngine.combatState.getDefender().balance;
                    }
                    CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:balanc:-1" : "c:balanc:-1", ",");
                    CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "miss-dodge";
                    CombatEngine.combatStateChanges.timePressure = CombatEngine.combatState.timePressure = Float.valueOf(MathUtils.clamp(CombatEngine.combatState.timePressure.floatValue() * timePressureReduction, 0.05f, 1.0f));
                    CombatEngine.calculateComboStage(combatState.getDefender(), type, option);
                    combo = combatState.getDefender() == CombatEngine.combatState.hostFighter ? CombatEngine.combatState.hostComboHappenning : CombatEngine.combatState.clientComboHappenning;
                    risposteStamina = (int)CombatEngine.getRisposteStamina("parry", combatState.getDefender(), combatState.getAttacker(), defenderDeviation, event, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353));
                    if (scenario.equalsIgnoreCase("coal") && combatState.getDefender() == CombatEngine.combatState.hostFighter && defenderDeviation > 0) {
                        int scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getInt("deviationDamage");
                        CombatEngine.combatState.getDefender().life -= scenarioModifier * defenderDeviation / 50;
                        CombatEngine.combatStateChanges.sendhli = CombatEngine.combatState.getDefender().life;
                        CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:life:-1" : "c:life:-1", ",");
                        CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, "c:scenario", ",");
                        CombatEngine.combatStateChanges.effectsToPlay = new StringBuilder(CombatEngine.combatState.effectsToPlay);
                    }
                    String string = combo = combatState.getAttacker() == CombatEngine.combatState.hostFighter ? CombatEngine.combatState.hostComboHappenning : CombatEngine.combatState.clientComboHappenning;
                    if (!combo.equalsIgnoreCase("") && (effectAdded = CombatEngine.addComboEffect(combatState.getAttacker(), combo, "commid", combatTime))) {
                        float staminaComboBonus;
                        float assaultComboBonus = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "assaul", "comsuc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947) / 10);
                        if ((double)assaultComboBonus != 0.0) {
                            CombatEngine.combatStateChanges.assaultPressure = CombatEngine.combatState.assaultPressure = Integer.valueOf(CombatEngine.combatState.assaultPressure + Float.valueOf(assaultComboBonus).intValue());
                        }
                        if ((double)(staminaComboBonus = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "stamin", "comsuc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10)) != 0.0) {
                            CombatEngine.combatState.getAttacker().stamina += Float.valueOf(staminaComboBonus * 100.0f).intValue();
                            CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:stamin:1" : "c:stamin:1", ",");
                            if (CombatEngine.combatState.getAttacker().stamina > CombatEngine.combatState.getAttacker().maxStamina) {
                                CombatEngine.combatState.getAttacker().stamina = CombatEngine.combatState.getAttacker().maxStamina;
                            }
                            if (CombatEngine.combatState.getAttacker().isHost) {
                                CombatEngine.combatStateChanges.sendhst = CombatEngine.combatState.getAttacker().stamina;
                            } else {
                                CombatEngine.combatStateChanges.sendcst = CombatEngine.combatState.getAttacker().stamina;
                            }
                        }
                    }
                    CombatEngine.combatState.getAttacker().comboStage = "";
                    if (CombatEngine.combatState.hostFighter == combatState.getAttacker()) {
                        CombatEngine.combatStateChanges.sendhcs = "";
                    } else {
                        CombatEngine.combatStateChanges.sendccs = "";
                    }
                    result = "miss-dodge:" + option;
                    if (CombatEngine.getEffect(combatState.getDefender(), null, "surge", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10) == null) {
                        float isSurge = CombatEngine.getEffectValue(combatState.getDefender(), event + ";" + phase, "suradd", "doddev", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10);
                        if ((double)isSurge != 0.0) {
                            int criticalChance = CombatEngine.getCriticalChance(combatState.getAttacker(), attackerDeviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827) / 10);
                            CombatEngine.combatState.getDefender().surge += (50 - defenderDeviation) * Float.valueOf((float)criticalChance * isSurge).intValue();
                            CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:surge:1" : "c:surge:1", ",");
                        }
                        if (CombatEngine.combatState.getDefender().surge > 10000) {
                            CombatEngine.combatState.getDefender().surge = 10000;
                        }
                        if (CombatEngine.combatState.getDefender().isHost) {
                            CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getDefender().surge;
                        } else {
                            CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getDefender().surge;
                        }
                    }
                    CombatEngine.combatState.soundsToPlay = StringList.append(CombatEngine.combatState.soundsToPlay, CombatEngine.getCombatSound("dodge"), ",");
                    CombatEngine.combatState.soundsToPlay = StringList.append(CombatEngine.combatState.soundsToPlay, CombatEngine.getCombatSound("miss"), ",");
                    CombatEngine.combatStateChanges.soundsToPlay = new StringBuilder(CombatEngine.combatState.soundsToPlay);
                } else {
                    event = event + "&event:dodfai";
                }
            } else {
                event = event + "&event:dodfai";
                wrongDirection = true;
            }
        } else if (type.equalsIgnoreCase("idle")) {
            event = "event:parfai&event:dodfai";
            wrongDirection = true;
        }
        if (wrongDirection) {
            if (CombatEngine.combatState.isUse.booleanValue()) {
                event = event + "&event:useite";
                CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "hit";
                result = "hit:0;normal:0";
            } else {
                float damageToStamina;
                Effect surge;
                event = event + "&event:hitbas";
                CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "hit";
                String string = combo = combatState.getAttacker() == CombatEngine.combatState.hostFighter ? CombatEngine.combatState.hostComboHappenning : CombatEngine.combatState.clientComboHappenning;
                if (!combo.equalsIgnoreCase("")) {
                    CombatEngine.addComboEffect(combatState.getAttacker(), combo, "comhit", combatTime);
                    Effect weakenComboBonus = CombatEngine.getEffect(combatState.getAttacker(), "event:comsuc", "debuff", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10);
                    if (weakenComboBonus != null) {
                        float debuffTime = Float.parseFloat(weakenComboBonus.time);
                        float debuffModifier = CombatEngine.getEffectValue(combatState.getAttacker(), null, "time", "debuff", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10);
                        if ((double)debuffModifier != 0.0) {
                            debuffTime *= debuffModifier;
                        }
                        CombatEngine.addDebuff(combatState.getDefender(), weakenComboBonus.subtype.substring(0, weakenComboBonus.subtype.length() - 1), weakenComboBonus.subtype, (long)debuffTime, combatTime, activeLog, false);
                    }
                    CombatEngine.addLogTrace(passiveLog, "g;Combo: " + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "game.stats.talents.name." + combo.substring(combo.lastIndexOf("$") + 1, combo.length())));
                }
                int damageDealt = 0;
                int damageReduced = 0;
                boolean barrier = false;
                damageDealt = CombatEngine.getDamageDealt(combatState.getAttacker(), combatState.getDefender(), -1, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10, CombatEngine.combatState.vulnerableDirection.equalsIgnoreCase(CombatEngine.combatState.direction));
                if (combatState.getDefender() == CombatEngine.combatState.clientFighter && scenario.equalsIgnoreCase("barricades") && CombatEngine.combatState.scenarioLife > 0) {
                    float scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getFloat("damageReduction");
                    if (CombatEngine.combatState.scenarioLife < Float.valueOf((float)damageDealt * scenarioModifier).intValue()) {
                        damageDealt -= CombatEngine.combatState.scenarioLife.intValue();
                        CombatEngine.combatState.scenarioLife = 0;
                        CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, "c:scenario", ",");
                        CombatEngine.combatStateChanges.effectsToPlay = new StringBuilder(CombatEngine.combatState.effectsToPlay);
                    } else {
                        CombatEngine.combatState.scenarioLife = CombatEngine.combatState.scenarioLife - Float.valueOf((float)damageDealt * scenarioModifier).intValue();
                        damageDealt = Float.valueOf((float)damageDealt * scenarioModifier).intValue();
                    }
                }
                damageReduced = damageDealt - CombatEngine.getArmorDamageReduction(damageDealt, combatState.getAttacker(), combatState.getDefender(), CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10);
                damageDealt -= damageReduced;
                if (combatState.getAttacker() == CombatEngine.combatState.clientFighter && CombatEngine.combatState.clientBossSpecial.contains("lightattack")) {
                    damageDealt += 1000;
                    CombatEngine.addDebuff(combatState.getDefender(), "weaken", "weaken1", 20000L, combatTime, activeLog, false);
                }
                if ((surge = CombatEngine.getEffect(combatState.getDefender(), null, "gain", "damsur", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947) / 10)) != null) {
                    barrier = true;
                }
                if (!barrier && CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10 < CombatEngine.getCriticalChance(combatState.getAttacker(), attackerDeviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10)) {
                    float isSurge;
                    event = event + "&event:hitcri";
                    damageDealt = Float.valueOf((float)CombatEngine.getCriticalDamage(damageDealt, combatState.getAttacker(), event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10) * (CombatEngine.combatState.getDefender().isPlayer ? damageMultiplier : 1.0f)).intValue();
                    result = "hit:" + (damageDealt + (CombatEngine.combatState.isUse != false ? 1000 : 0)) + ";critical:0";
                    CombatEngine.addLogTrace(passiveLog, "l;Hit critical, damage " + damageDealt / 10);
                    if (CombatEngine.getEffect(combatState.getAttacker(), null, "surge", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827) / 10) == null && (double)(isSurge = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "suradd", "damage", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10)) != 0.0) {
                        CombatEngine.combatState.getAttacker().surge += Float.valueOf((float)damageDealt * isSurge * 1.5f).intValue();
                        if (CombatEngine.combatState.getAttacker().surge > 10000) {
                            CombatEngine.combatState.getAttacker().surge = 10000;
                        }
                        if (CombatEngine.combatState.getAttacker().isHost) {
                            CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                        } else {
                            CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                        }
                        CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:surge:1" : "c:surge:1", ",");
                    }
                } else {
                    float isSurge;
                    event = event + "&event:hitnor";
                    damageDealt = Float.valueOf((float)damageDealt * (CombatEngine.combatState.getDefender().isPlayer ? damageMultiplier : 1.0f)).intValue();
                    result = "hit:" + (damageDealt + (CombatEngine.combatState.isUse != false ? 1000 : 0)) + ";normal:0";
                    CombatEngine.addLogTrace(passiveLog, "l;Hit normal, damage " + damageDealt / 10);
                    if (CombatEngine.getEffect(combatState.getAttacker(), null, "surge", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10) == null && (double)(isSurge = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "suradd", "damage", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10)) != 0.0) {
                        CombatEngine.combatState.getAttacker().surge += Float.valueOf((float)damageDealt * isSurge).intValue();
                        if (CombatEngine.combatState.getAttacker().surge > 10000) {
                            CombatEngine.combatState.getAttacker().surge = 10000;
                        }
                        if (CombatEngine.combatState.getAttacker().isHost) {
                            CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                        } else {
                            CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                        }
                        CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:surge:1" : "c:surge:1", ",");
                    }
                }
                if ((damageToStamina = CombatEngine.getEffectValue(combatState.getDefender(), null, "gain", "damsta", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10)) != 0.0f) {
                    CombatEngine.combatState.getDefender().stamina += Float.valueOf((float)damageDealt * damageToStamina).intValue();
                    CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:stamin:1" : "c:stamin:1", ",");
                    if (CombatEngine.combatState.getDefender().stamina > CombatEngine.combatState.getDefender().maxStamina) {
                        CombatEngine.combatState.getDefender().stamina = CombatEngine.combatState.getDefender().maxStamina;
                    }
                    if (CombatEngine.combatState.getDefender().isHost) {
                        CombatEngine.combatStateChanges.sendhst = CombatEngine.combatState.getDefender().stamina;
                    } else {
                        CombatEngine.combatStateChanges.sendcst = CombatEngine.combatState.getDefender().stamina;
                    }
                    CombatEngine.addLogTrace(passiveLog, "l;Gain stamina: " + Float.valueOf((float)damageDealt * damageToStamina).intValue() / 10);
                }
                if (!barrier) {
                    CombatEngine.combatState.getDefender().life -= damageDealt;
                    CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:life:-1" : "c:life:-1", ",");
                } else {
                    if (CombatEngine.combatState.getDefender().surge >= damageDealt) {
                        CombatEngine.combatState.getDefender().surge -= damageDealt;
                        if (CombatEngine.combatState.getDefender().surge < 0) {
                            CombatEngine.combatState.getDefender().surge = 0;
                        }
                    } else {
                        CombatEngine.combatState.getDefender().life -= damageDealt - CombatEngine.combatState.getDefender().surge;
                        CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:life:-1" : "c:life:-1", ",");
                        CombatEngine.combatState.getDefender().surge = 0;
                    }
                    if (CombatEngine.combatState.getDefender().isHost) {
                        CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getDefender().surge;
                    } else {
                        CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getDefender().surge;
                    }
                    CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:surge:-1" : "c:surge:-1", ",");
                }
                damageReceived = damageDealt;
                if (CombatEngine.combatState.getDefender().life < 0) {
                    CombatEngine.combatState.getDefender().life = 0;
                }
                if (CombatEngine.combatState.getDefender().isHost) {
                    CombatEngine.combatStateChanges.sendhli = CombatEngine.combatState.getDefender().life;
                } else {
                    CombatEngine.combatStateChanges.sendcli = CombatEngine.combatState.getDefender().life;
                }
                if (CombatEngine.getEffect(combatState.getDefender(), null, "surge", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947) / 10) == null) {
                    CombatEngine.combatState.getDefender().surge += damageDealt * 2;
                    float isSurge = CombatEngine.getEffectValue(combatState.getDefender(), event + ";" + phase, "suradd", "damred", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10);
                    if ((double)isSurge != 0.0) {
                        CombatEngine.combatState.getDefender().surge += Float.valueOf((float)damageReduced * isSurge).intValue();
                    }
                    if (CombatEngine.combatState.getDefender().surge > 10000) {
                        CombatEngine.combatState.getDefender().surge = 10000;
                    }
                    if (CombatEngine.combatState.getDefender().isHost) {
                        CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getDefender().surge;
                    } else {
                        CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getDefender().surge;
                    }
                    CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getDefender().isHost ? "h:surge:1" : "c:surge:1", ",");
                }
            }
            CombatEngine.combatStateChanges.assaultPressure = CombatEngine.combatState.assaultPressure = Integer.valueOf(0);
            if (!combo.equalsIgnoreCase("")) {
                float staminaComboBonus;
                float assaultComboBonus = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "assaul", "comsuc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10);
                if ((double)assaultComboBonus != 0.0) {
                    CombatEngine.combatStateChanges.assaultPressure = CombatEngine.combatState.assaultPressure = Integer.valueOf(CombatEngine.combatState.assaultPressure + Float.valueOf(assaultComboBonus).intValue());
                }
                if ((double)(staminaComboBonus = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "stamin", "comsuc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10)) != 0.0) {
                    CombatEngine.combatState.getAttacker().stamina += Float.valueOf(staminaComboBonus * 100.0f).intValue();
                    CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:stamin:1" : "c:stamin:1", ",");
                    if (CombatEngine.combatState.getAttacker().stamina > CombatEngine.combatState.getAttacker().maxStamina) {
                        CombatEngine.combatState.getAttacker().stamina = CombatEngine.combatState.getAttacker().maxStamina;
                    }
                    if (CombatEngine.combatState.getAttacker().isHost) {
                        CombatEngine.combatStateChanges.sendhst = CombatEngine.combatState.getAttacker().stamina;
                    } else {
                        CombatEngine.combatStateChanges.sendcst = CombatEngine.combatState.getAttacker().stamina;
                    }
                }
            }
            CombatEngine.combatState.soundsToPlay = StringList.append(CombatEngine.combatState.soundsToPlay, CombatEngine.getCombatSound("hit" + (result.contains("critical") ? "cri" : "nor")), ",");
            CombatEngine.combatStateChanges.soundsToPlay = new StringBuilder(CombatEngine.combatState.soundsToPlay);
        }
        CombatEngine.removeBuff(combatState.getAttacker(), "charge");
        CombatEngine.checkEventPhaseEffects(passive, active, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827) / 10, combatTime, passiveLog, activeLog);
        CombatEngine.removeItemEffects(passive);
        CombatEngine.removeComboEffects(passive);
        if (!combo.equalsIgnoreCase("")) {
            passive.comboStage = "";
            if (CombatEngine.combatState.hostFighter == passive) {
                CombatEngine.combatStateChanges.sendhcs = "";
            } else {
                CombatEngine.combatStateChanges.sendccs = "";
            }
        }
        return result;
    }

    public static String runHitStage(String type, String option, int deviation, Fighter active, Fighter passive, long combatTime) {
        float fastHands;
        String offHandBonus;
        String result = "";
        damageReceived = 0;
        String event = "";
        String phase = "";
        String combo = "";
        StringBuilder activeLog = active.isHost ? CombatEngine.combatState.hostLog : CombatEngine.combatState.clientLog;
        StringBuilder passiveLog = active.isHost ? CombatEngine.combatState.clientLog : CombatEngine.combatState.hostLog;
        phase = "phase:attack";
        event = "event:chabas";
        CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "chain";
        result = "chain:" + CombatEngine.getChainTime(combatState.getAttacker(), combatState.getDefender(), attackerDeviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10);
        CombatEngine.combatStateChanges.vulnerableDirection = CombatEngine.combatState.vulnerableDirection = CombatEngine.getVulnerableDirection(CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827));
        float pressureLost = (1.0f - CombatEngine.combatState.timePressure.floatValue()) / 2.0f;
        if (CombatEngine.combatState.getAttacker().offHand != null && (offHandBonus = CombatEngine.stats("weapons").getJSONObject(CombatEngine.combatState.getAttacker().offHand.id).getString("offHandBonus")).startsWith("chaipres")) {
            pressureLost = (1.0f - CombatEngine.combatState.timePressure.floatValue()) * Float.parseFloat(offHandBonus.split(":")[1]);
        }
        if (CombatEngine.combatState.isUse.booleanValue() && (double)(fastHands = CombatEngine.getEffectValue(combatState.getAttacker(), "event:hitite;" + phase, "pressu", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10)) != 0.0) {
            pressureLost = (1.0f - CombatEngine.combatState.timePressure.floatValue()) * fastHands;
        }
        CombatEngine.combatStateChanges.isUse = CombatEngine.combatState.isUse = Boolean.valueOf(false);
        CombatEngine.combatStateChanges.timePressure = CombatEngine.combatState.timePressure = Float.valueOf(1.0f - pressureLost);
        CombatEngine.checkEventPhaseEffects(active, passive, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10, combatTime, activeLog, passiveLog);
        CombatEngine.removeItemEffects(active);
        CombatEngine.removeComboEffects(active);
        if (!combo.equalsIgnoreCase("")) {
            active.comboStage = "";
            if (CombatEngine.combatState.hostFighter == active) {
                CombatEngine.combatStateChanges.sendhcs = "";
            } else {
                CombatEngine.combatStateChanges.sendccs = "";
            }
        }
        if (combatState.getAttacker() == CombatEngine.combatState.hostFighter && CombatEngine.combatState.clientFighter.name.contains("boss1")) {
            int chanceForbidden;
            int n = CombatEngine.combatState.clientFighter.life < 3000 ? 100 : (chanceForbidden = CombatEngine.combatState.clientFighter.life < 6000 ? 50 : 0);
            CombatEngine.combatState.clientBossSpecial = MathUtils.random(99) > chanceForbidden ? "" : (chanceForbidden == 50 ? "left" : (MathUtils.random(1) == 0 ? "right" : "left"));
        }
        return result;
    }

    public static String runMissParryStage(String type, String option, int deviation, Fighter active, Fighter passive, long combatTime) {
        String result = "";
        damageReceived = 0;
        String event = "";
        String phase = "";
        String combo = "";
        StringBuilder activeLog = active.isHost ? CombatEngine.combatState.hostLog : CombatEngine.combatState.clientLog;
        StringBuilder passiveLog = active.isHost ? CombatEngine.combatState.clientLog : CombatEngine.combatState.hostLog;
        phase = "phase:attack";
        event = "event:risbas&event:rispar";
        CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "risposte";
        Fighter auxFighter = combatState.getDefender();
        CombatEngine.combatStateChanges.defender = CombatEngine.combatState.defender = CombatEngine.combatState.getAttacker().isHost ? "host" : "client";
        CombatEngine.combatStateChanges.attacker = CombatEngine.combatState.attacker = auxFighter.isHost ? "host" : "client";
        result = "risposte:" + CombatEngine.getRisposteTime("parry", combatState.getAttacker(), combatState.getDefender(), defenderDeviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10);
        CombatEngine.combatStateChanges.vulnerableDirection = CombatEngine.combatState.vulnerableDirection = CombatEngine.getVulnerableDirection(CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827));
        CombatEngine.combatStateChanges.isUse = CombatEngine.combatState.isUse = Boolean.valueOf(false);
        CombatEngine.checkEventPhaseEffects(active, passive, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10, combatTime, activeLog, passiveLog);
        CombatEngine.removeItemEffects(active);
        CombatEngine.removeComboEffects(active);
        if (!combo.equalsIgnoreCase("")) {
            active.comboStage = "";
            if (CombatEngine.combatState.hostFighter == active) {
                CombatEngine.combatStateChanges.sendhcs = "";
            } else {
                CombatEngine.combatStateChanges.sendccs = "";
            }
        }
        if (combatState.getAttacker() == CombatEngine.combatState.hostFighter && CombatEngine.combatState.clientFighter.name.contains("boss1")) {
            int chanceForbidden;
            int n = CombatEngine.combatState.clientFighter.life < 3000 ? 100 : (chanceForbidden = CombatEngine.combatState.clientFighter.life < 6000 ? 50 : 0);
            CombatEngine.combatState.clientBossSpecial = MathUtils.random(99) > chanceForbidden ? "" : (chanceForbidden == 50 ? "left" : (MathUtils.random(1) == 0 ? "right" : "left"));
        }
        return result;
    }

    public static String runMissDodgeStage(String type, String option, int deviation, Fighter active, Fighter passive, long combatTime) {
        String result = "";
        damageReceived = 0;
        String event = "";
        String phase = "";
        String combo = "";
        StringBuilder activeLog = active.isHost ? CombatEngine.combatState.hostLog : CombatEngine.combatState.clientLog;
        StringBuilder passiveLog = active.isHost ? CombatEngine.combatState.clientLog : CombatEngine.combatState.hostLog;
        phase = "phase:attack";
        event = "event:risbas&event:risdod";
        CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "risposte";
        Fighter auxFighter = combatState.getDefender();
        CombatEngine.combatStateChanges.defender = CombatEngine.combatState.defender = CombatEngine.combatState.getAttacker().isHost ? "host" : "client";
        CombatEngine.combatStateChanges.attacker = CombatEngine.combatState.attacker = auxFighter.isHost ? "host" : "client";
        result = "risposte:" + CombatEngine.getRisposteTime("dodge", combatState.getAttacker(), combatState.getDefender(), defenderDeviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10);
        CombatEngine.combatStateChanges.vulnerableDirection = CombatEngine.combatState.vulnerableDirection = CombatEngine.getVulnerableDirection(CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827));
        CombatEngine.combatStateChanges.isUse = CombatEngine.combatState.isUse = Boolean.valueOf(false);
        CombatEngine.checkEventPhaseEffects(active, passive, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827) / 10, combatTime, activeLog, passiveLog);
        CombatEngine.removeItemEffects(active);
        CombatEngine.removeComboEffects(active);
        if (!combo.equalsIgnoreCase("")) {
            active.comboStage = "";
            if (CombatEngine.combatState.hostFighter == active) {
                CombatEngine.combatStateChanges.sendhcs = "";
            } else {
                CombatEngine.combatStateChanges.sendccs = "";
            }
        }
        if (combatState.getAttacker() == CombatEngine.combatState.hostFighter && CombatEngine.combatState.clientFighter.name.contains("boss1")) {
            int chanceForbidden;
            int n = CombatEngine.combatState.clientFighter.life < 3000 ? 100 : (chanceForbidden = CombatEngine.combatState.clientFighter.life < 6000 ? 50 : 0);
            CombatEngine.combatState.clientBossSpecial = MathUtils.random(99) > chanceForbidden ? "" : (chanceForbidden == 50 ? "left" : (MathUtils.random(1) == 0 ? "right" : "left"));
        }
        return result;
    }

    public static String runChainStage(String type, String option, int deviation, Fighter active, Fighter passive, long combatTime) {
        Effect surge;
        StringBuilder passiveLog;
        String result = "";
        damageReceived = 0;
        String event = "";
        String phase = "";
        String combo = "";
        StringBuilder activeLog = active.isHost ? CombatEngine.combatState.hostLog : CombatEngine.combatState.clientLog;
        StringBuilder stringBuilder = passiveLog = active.isHost ? CombatEngine.combatState.clientLog : CombatEngine.combatState.hostLog;
        if (type.equalsIgnoreCase("attack")) {
            phase = "phase:attack";
            event = "event:chabas";
            int staminaCost = CombatEngine.getStaminaCost("attack", active, passive, deviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10);
            if (CombatEngine.canPayStamina(active, "attack", staminaCost, 0, true, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10)) {
                event = event + "&event:chasuc";
                CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "attack";
                CombatEngine.combatStateChanges.assaultPressure = CombatEngine.combatState.assaultPressure = Integer.valueOf(CombatEngine.combatState.assaultPressure + 1);
                CombatEngine.combatStateChanges.assaultFighter = CombatEngine.combatState.assaultFighter = active.isHost ? "host" : "client";
                CombatEngine.combatStateChanges.attacker = CombatEngine.combatState.attacker = active.isHost ? "host" : "client";
                CombatEngine.combatStateChanges.defender = CombatEngine.combatState.defender = passive.isHost ? "host" : "client";
                CombatEngine.combatStateChanges.direction = CombatEngine.combatState.direction = option;
                attackerDeviation = deviation;
                CombatEngine.addLogTrace(activeLog, "l;Chain " + option + ", deviation " + deviation);
                CombatEngine.calculateComboStage(combatState.getAttacker(), type, option);
                String string = combo = combatState.getAttacker() == CombatEngine.combatState.hostFighter ? CombatEngine.combatState.hostComboHappenning : CombatEngine.combatState.clientComboHappenning;
                if (!combo.equalsIgnoreCase("")) {
                    CombatEngine.addComboEffect(combatState.getAttacker(), combo, "comatt", combatTime);
                }
                combo = "";
                result = "parry:" + CombatEngine.getParryTime(combatState.getAttacker(), combatState.getDefender(), deviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10) + ";dodge:" + CombatEngine.getDodgeTime(combatState.getAttacker(), combatState.getDefender(), deviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10);
                if (CombatEngine.getEffect(combatState.getAttacker(), null, "surge", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947) / 10) == null) {
                    float isSurge = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "suradd", "attdev", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10);
                    if ((double)isSurge != 0.0) {
                        CombatEngine.combatState.getAttacker().surge += (50 - attackerDeviation) * Float.valueOf((float)staminaCost * isSurge).intValue();
                        CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:surge:1" : "c:surge:1", ",");
                    }
                    if (CombatEngine.combatState.getAttacker().surge > 10000) {
                        CombatEngine.combatState.getAttacker().surge = 10000;
                    }
                    if (CombatEngine.combatState.getAttacker().isHost) {
                        CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                    } else {
                        CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                    }
                }
                if (scenario.equalsIgnoreCase("coal") && combatState.getAttacker() == CombatEngine.combatState.hostFighter && attackerDeviation > 0) {
                    int scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getInt("deviationDamage");
                    CombatEngine.combatState.getAttacker().life -= scenarioModifier * attackerDeviation / 50;
                    CombatEngine.combatStateChanges.sendhli = CombatEngine.combatState.getAttacker().life;
                    CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:life:-1" : "c:life:-1", ",");
                    CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, "c:scenario", ",");
                    CombatEngine.combatStateChanges.effectsToPlay = new StringBuilder(CombatEngine.combatState.effectsToPlay);
                }
                CombatEngine.removeBuff(combatState.getAttacker(), "ready");
                if (combatState.getAttacker() == CombatEngine.combatState.clientFighter && CombatEngine.combatState.clientBossSpecial.contains("lightcharge")) {
                    CombatEngine.combatState.clientBossSpecial = "lightattack" + option;
                }
            }
        } else if (type.equalsIgnoreCase("use")) {
            event = "event:use";
            phase = "phase:attack";
            CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "attack";
            CombatEngine.combatStateChanges.assaultPressure = CombatEngine.combatState.assaultPressure = Integer.valueOf(CombatEngine.combatState.assaultPressure + 1);
            CombatEngine.combatStateChanges.attacker = CombatEngine.combatState.attacker = active.isHost ? "host" : "client";
            CombatEngine.combatStateChanges.defender = CombatEngine.combatState.defender = passive.isHost ? "host" : "client";
            CombatEngine.combatStateChanges.isUse = CombatEngine.combatState.isUse = Boolean.valueOf(true);
            CombatEngine.combatStateChanges.direction = CombatEngine.combatState.direction = option;
            attackerDeviation = deviation;
            CombatEngine.addLogTrace(activeLog, "l;Use " + option + ", deviation " + deviation);
            CombatEngine.combatState.getAttacker().comboStage = "";
            if (CombatEngine.combatState.hostFighter == combatState.getAttacker()) {
                CombatEngine.combatStateChanges.sendhcs = "";
            } else {
                CombatEngine.combatStateChanges.sendccs = "";
            }
            combo = "";
            String item = "shard";
            if (CombatEngine.combatState.getAttacker().services.contains("powder")) {
                item = "powder";
            } else if (CombatEngine.combatState.getAttacker().services.contains("net")) {
                item = "net";
            }
            result = "parry:" + CombatEngine.getUseTime(combatState.getAttacker(), combatState.getDefender(), item, "parry", event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10) + ";dodge:" + CombatEngine.getUseTime(combatState.getAttacker(), combatState.getDefender(), item, "dodge", event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10);
            --CombatEngine.combatState.getAttacker().itemUses;
            if (CombatEngine.combatState.getAttacker().isHost) {
                CombatEngine.combatStateChanges.sendhiu = CombatEngine.combatState.getAttacker().itemUses;
            } else {
                CombatEngine.combatStateChanges.sendciu = CombatEngine.combatState.getAttacker().itemUses;
            }
        } else if (type.equalsIgnoreCase("idle")) {
            phase = "phase:idle";
            event = "event:chafor";
            CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "start";
            CombatEngine.combatState.getAttacker().comboStage = "";
            CombatEngine.combatState.getDefender().comboStage = "";
            CombatEngine.combatStateChanges.sendhcs = "";
            CombatEngine.combatStateChanges.sendccs = "";
            Fighter auxFighter = combatState.getAttacker();
            CombatEngine.combatStateChanges.attacker = CombatEngine.combatState.attacker = CombatEngine.combatState.getDefender().isHost ? "host" : "client";
            CombatEngine.combatStateChanges.defender = CombatEngine.combatState.defender = auxFighter.isHost ? "host" : "client";
            attackerDeviation = 0;
            defenderDeviation = 0;
            result = "start";
            CombatEngine.combatStateChanges.vulnerableDirection = CombatEngine.combatState.vulnerableDirection = CombatEngine.getVulnerableDirection(CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827));
            if (combatState.getAttacker() == CombatEngine.combatState.hostFighter && CombatEngine.combatState.clientFighter.name.contains("boss1")) {
                int chanceForbidden;
                int n = CombatEngine.combatState.clientFighter.life < 3000 ? 100 : (chanceForbidden = CombatEngine.combatState.clientFighter.life < 6000 ? 50 : 0);
                CombatEngine.combatState.clientBossSpecial = MathUtils.random(99) > chanceForbidden ? "" : (chanceForbidden == 50 ? "left" : (MathUtils.random(1) == 0 ? "right" : "left"));
            }
        }
        CombatEngine.combatState.isChain = true;
        CombatEngine.checkEventPhaseEffects(active, passive, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10, combatTime, activeLog, passiveLog);
        CombatEngine.removeItemEffects(active);
        CombatEngine.removeComboEffects(active);
        if (type.equalsIgnoreCase("idle") && (surge = CombatEngine.getEffect(combatState.getAttacker(), "event:idle", "brink", "", 0)) != null) {
            CombatEngine.addBuff(combatState.getAttacker(), "ready", "ready" + surge.subtype, Long.parseLong(surge.time), combatTime, passiveLog);
            CombatEngine.addBuff(combatState.getAttacker(), "charge", "charge" + surge.subtype, Long.parseLong(surge.time), combatTime, passiveLog);
        }
        if (!combo.equalsIgnoreCase("")) {
            active.comboStage = "";
            if (CombatEngine.combatState.hostFighter == active) {
                CombatEngine.combatStateChanges.sendhcs = "";
            } else {
                CombatEngine.combatStateChanges.sendccs = "";
            }
        }
        return result;
    }

    public static String runRisposteStage(String type, String option, int deviation, Fighter active, Fighter passive, long combatTime) {
        Effect surge;
        StringBuilder passiveLog;
        String result = "";
        damageReceived = 0;
        String event = "";
        String phase = "";
        String combo = "";
        StringBuilder activeLog = active.isHost ? CombatEngine.combatState.hostLog : CombatEngine.combatState.clientLog;
        StringBuilder stringBuilder = passiveLog = active.isHost ? CombatEngine.combatState.clientLog : CombatEngine.combatState.hostLog;
        if (type.equalsIgnoreCase("attack")) {
            phase = "phase:attack";
            event = "event:risbas";
            int staminaCost = CombatEngine.getStaminaCost("attack", active, passive, deviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10);
            if (CombatEngine.canPayStamina(active, "attack", staminaCost, 0, true, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10)) {
                event = event + "&event:rissuc";
                CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "attack";
                CombatEngine.combatStateChanges.attacker = CombatEngine.combatState.attacker = active.isHost ? "host" : "client";
                CombatEngine.combatStateChanges.defender = CombatEngine.combatState.defender = passive.isHost ? "host" : "client";
                CombatEngine.combatStateChanges.direction = CombatEngine.combatState.direction = option;
                attackerDeviation = deviation;
                CombatEngine.combatStateChanges.assaultPressure = CombatEngine.combatState.assaultPressure = Integer.valueOf(0);
                CombatEngine.combatStateChanges.assaultFighter = CombatEngine.combatState.assaultFighter = active.isHost ? "host" : "client";
                CombatEngine.addLogTrace(activeLog, "l;Risposte " + option + ", deviation " + deviation);
                CombatEngine.calculateComboStage(combatState.getAttacker(), type, option);
                String string = combo = combatState.getAttacker() == CombatEngine.combatState.hostFighter ? CombatEngine.combatState.hostComboHappenning : CombatEngine.combatState.clientComboHappenning;
                if (!combo.equalsIgnoreCase("")) {
                    CombatEngine.addComboEffect(combatState.getAttacker(), combo, "comatt", combatTime);
                }
                combo = "";
                result = "parry:" + CombatEngine.getParryTime(combatState.getAttacker(), combatState.getDefender(), deviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10) + ";dodge:" + CombatEngine.getDodgeTime(combatState.getAttacker(), combatState.getDefender(), deviation, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10);
                if (CombatEngine.getEffect(combatState.getAttacker(), null, "surge", "", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947) / 10) == null) {
                    float isSurge = CombatEngine.getEffectValue(combatState.getAttacker(), event + ";" + phase, "suradd", "attdev", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10);
                    if ((double)isSurge != 0.0) {
                        CombatEngine.combatState.getAttacker().surge += (50 - attackerDeviation) * Float.valueOf((float)staminaCost * isSurge).intValue();
                        CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:surge:1" : "c:surge:1", ",");
                    }
                    if (CombatEngine.combatState.getAttacker().surge > 10000) {
                        CombatEngine.combatState.getAttacker().surge = 10000;
                    }
                    if (CombatEngine.combatState.getAttacker().isHost) {
                        CombatEngine.combatStateChanges.sendhsu = CombatEngine.combatState.getAttacker().surge;
                    } else {
                        CombatEngine.combatStateChanges.sendcsu = CombatEngine.combatState.getAttacker().surge;
                    }
                }
                if (scenario.equalsIgnoreCase("coal") && combatState.getAttacker() == CombatEngine.combatState.hostFighter && attackerDeviation > 0) {
                    int scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getInt("deviationDamage");
                    CombatEngine.combatState.getAttacker().life -= scenarioModifier * attackerDeviation / 50;
                    CombatEngine.combatStateChanges.sendhli = CombatEngine.combatState.getAttacker().life;
                    CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, CombatEngine.combatState.getAttacker().isHost ? "h:life:-1" : "c:life:-1", ",");
                    CombatEngine.combatState.effectsToPlay = StringList.append(CombatEngine.combatState.effectsToPlay, "c:scenario", ",");
                    CombatEngine.combatStateChanges.effectsToPlay = new StringBuilder(CombatEngine.combatState.effectsToPlay);
                }
                CombatEngine.removeBuff(combatState.getAttacker(), "ready");
                if (combatState.getAttacker() == CombatEngine.combatState.clientFighter && CombatEngine.combatState.clientBossSpecial.contains("lightcharge")) {
                    CombatEngine.combatState.clientBossSpecial = "lightattack" + option;
                }
            }
        } else if (type.equalsIgnoreCase("use")) {
            event = "event:use";
            phase = "phase:attack";
            CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "attack";
            CombatEngine.combatStateChanges.attacker = CombatEngine.combatState.attacker = active.isHost ? "host" : "client";
            CombatEngine.combatStateChanges.defender = CombatEngine.combatState.defender = passive.isHost ? "host" : "client";
            CombatEngine.combatStateChanges.isUse = CombatEngine.combatState.isUse = Boolean.valueOf(true);
            CombatEngine.combatStateChanges.direction = CombatEngine.combatState.direction = option;
            attackerDeviation = deviation;
            CombatEngine.addLogTrace(activeLog, "l;Use " + option + ", deviation " + deviation);
            CombatEngine.combatState.getAttacker().comboStage = "";
            if (CombatEngine.combatState.hostFighter == combatState.getAttacker()) {
                CombatEngine.combatStateChanges.sendhcs = "";
            } else {
                CombatEngine.combatStateChanges.sendccs = "";
            }
            combo = "";
            String item = "shard";
            if (CombatEngine.combatState.getAttacker().services.contains("powder")) {
                item = "powder";
            } else if (CombatEngine.combatState.getAttacker().services.contains("net")) {
                item = "net";
            }
            result = "parry:" + CombatEngine.getUseTime(combatState.getAttacker(), combatState.getDefender(), item, "parry", event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10) + ";dodge:" + CombatEngine.getUseTime(combatState.getAttacker(), combatState.getDefender(), item, "dodge", event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10);
            --CombatEngine.combatState.getAttacker().itemUses;
            if (CombatEngine.combatState.getAttacker().isHost) {
                CombatEngine.combatStateChanges.sendhiu = CombatEngine.combatState.getAttacker().itemUses;
            } else {
                CombatEngine.combatStateChanges.sendciu = CombatEngine.combatState.getAttacker().itemUses;
            }
        } else if (type.equalsIgnoreCase("idle")) {
            phase = "phase:idle";
            event = "event:risfor";
            CombatEngine.combatStateChanges.stage = CombatEngine.combatState.stage = "start";
            CombatEngine.combatState.getAttacker().comboStage = "";
            CombatEngine.combatState.getDefender().comboStage = "";
            CombatEngine.combatStateChanges.sendhcs = "";
            CombatEngine.combatStateChanges.sendccs = "";
            Fighter auxFighter = combatState.getAttacker();
            CombatEngine.combatStateChanges.attacker = CombatEngine.combatState.attacker = CombatEngine.combatState.getDefender().isHost ? "host" : "client";
            CombatEngine.combatStateChanges.defender = CombatEngine.combatState.defender = auxFighter.isHost ? "host" : "client";
            attackerDeviation = 0;
            defenderDeviation = 0;
            result = "start:0";
            CombatEngine.combatStateChanges.vulnerableDirection = CombatEngine.combatState.vulnerableDirection = CombatEngine.getVulnerableDirection(CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827));
            if (combatState.getAttacker() == CombatEngine.combatState.hostFighter && CombatEngine.combatState.clientFighter.name.contains("boss1")) {
                int chanceForbidden;
                int n = CombatEngine.combatState.clientFighter.life < 3000 ? 100 : (chanceForbidden = CombatEngine.combatState.clientFighter.life < 6000 ? 50 : 0);
                CombatEngine.combatState.clientBossSpecial = MathUtils.random(99) > chanceForbidden ? "" : (chanceForbidden == 50 ? "left" : (MathUtils.random(1) == 0 ? "right" : "left"));
            }
        }
        CombatEngine.checkEventPhaseEffects(active, passive, event + ";" + phase, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10, combatTime, activeLog, passiveLog);
        CombatEngine.removeItemEffects(active);
        CombatEngine.removeComboEffects(active);
        if (type.equalsIgnoreCase("idle") && (surge = CombatEngine.getEffect(combatState.getAttacker(), "event:idle", "brink", "", 0)) != null) {
            CombatEngine.addBuff(combatState.getAttacker(), "ready", "ready" + surge.subtype, Long.parseLong(surge.time), combatTime, passiveLog);
            CombatEngine.addBuff(combatState.getAttacker(), "charge", "charge" + surge.subtype, Long.parseLong(surge.time), combatTime, passiveLog);
        }
        if (!combo.equalsIgnoreCase("")) {
            active.comboStage = "";
            if (CombatEngine.combatState.hostFighter == active) {
                CombatEngine.combatStateChanges.sendhcs = "";
            } else {
                CombatEngine.combatStateChanges.sendccs = "";
            }
        }
        return result;
    }

    public static void addLogTrace(StringBuilder log, String trace) {
        if ((log = StringList.append(log, trace, "#")) == CombatEngine.combatState.hostLog) {
            CombatEngine.combatStateChanges.hostLog = StringList.append(CombatEngine.combatStateChanges.hostLog, trace, "#");
        } else {
            CombatEngine.combatStateChanges.clientLog = StringList.append(CombatEngine.combatStateChanges.clientLog, trace, "#");
        }
    }

    public static int getStaminaCost(String action, Fighter attacker, Fighter defender, int attackerDeviation, String timing, int randomSeed) {
        float result = 0.0f;
        if (action.equalsIgnoreCase("attack")) {
            float staminaPressureReduction;
            float armorPenalty;
            result = CombatEngine.stats("weapons").getJSONObject(attacker.weapon.id).getFloat("staminaCost");
            result = result * (100.0f + CombatEngine.stats("tiers").getJSONObject(attacker.weapon.tier).getFloat("weaponStaminaCost")) / 100.0f;
            float totalArmorAttacker = 0.0f;
            if (attacker.body != null) {
                totalArmorAttacker = totalArmorAttacker + CombatEngine.stats("armors").getJSONObject(attacker.body.id).getFloat("staminaCost") + CombatEngine.stats("tiers").getJSONObject(attacker.body.tier).getFloat("armor") * 20.0f;
            }
            if (attacker.head != null) {
                totalArmorAttacker = totalArmorAttacker + CombatEngine.stats("armors").getJSONObject(attacker.head.id).getFloat("staminaCost") + CombatEngine.stats("tiers").getJSONObject(attacker.head.tier).getFloat("armor") * 10.0f;
            }
            if (attacker.arms != null) {
                totalArmorAttacker = totalArmorAttacker + CombatEngine.stats("armors").getJSONObject(attacker.arms.id).getFloat("staminaCost") + CombatEngine.stats("tiers").getJSONObject(attacker.arms.tier).getFloat("armor") * 10.0f;
            }
            if ((double)(armorPenalty = CombatEngine.getEffectValue(attacker, timing, "armpen", "stamin", randomSeed)) != 0.0) {
                totalArmorAttacker -= armorPenalty;
            }
            if (totalArmorAttacker > 0.0f) {
                result += totalArmorAttacker;
            }
            if (timing.contains("ris")) {
                result += (float)risposteStamina;
            }
            if ((double)(staminaPressureReduction = CombatEngine.getEffectValue(attacker, timing, "stacos", "pressu", randomSeed)) != 0.0) {
                result -= result * (1.0f - CombatEngine.combatState.timePressure.floatValue()) * staminaPressureReduction;
            }
        } else if (action.equalsIgnoreCase("parry")) {
            float surge;
            String offHandBonus;
            float armorPenalty;
            result = CombatEngine.stats("timings").getJSONObject("parry").getFloat("staminaCost");
            float totalArmorDefender = 0.0f;
            if (defender.body != null) {
                totalArmorDefender = totalArmorDefender + CombatEngine.stats("armors").getJSONObject(defender.body.id).getFloat("staminaCost") + CombatEngine.stats("tiers").getJSONObject(defender.body.tier).getFloat("armor") * 20.0f;
            }
            if (defender.head != null) {
                totalArmorDefender = totalArmorDefender + CombatEngine.stats("armors").getJSONObject(defender.head.id).getFloat("staminaCost") + CombatEngine.stats("tiers").getJSONObject(defender.head.tier).getFloat("armor") * 10.0f;
            }
            if (defender.arms != null) {
                totalArmorDefender = totalArmorDefender + CombatEngine.stats("armors").getJSONObject(defender.arms.id).getFloat("staminaCost") + CombatEngine.stats("tiers").getJSONObject(defender.arms.tier).getFloat("armor") * 10.0f;
            }
            if ((double)(armorPenalty = CombatEngine.getEffectValue(defender, timing.replace("phase:attack", "phase:defend"), "armpen", "stamin", randomSeed)) != 0.0) {
                totalArmorDefender -= armorPenalty;
            }
            if (totalArmorDefender > 0.0f) {
                result += totalArmorDefender;
            }
            if (attacker.offHand != null && (offHandBonus = CombatEngine.stats("weapons").getJSONObject(attacker.offHand.id).getString("offHandBonus")).startsWith("parrstam")) {
                float parrstam = Float.parseFloat(CombatEngine.stats("weapons").getJSONObject(attacker.weapon.id).getString("staminaCost")) * 0.35f;
                result += parrstam;
            }
            if ((double)(surge = CombatEngine.getEffectValue(attacker, null, "gain", "stacos", randomSeed)) != 0.0) {
                result += surge;
            }
            if (!scenario.equalsIgnoreCase("")) {
                float scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getFloat("parryCost");
                result *= scenarioModifier;
            }
        } else if (action.equalsIgnoreCase("dodge")) {
            float armorPenalty;
            result = CombatEngine.stats("timings").getJSONObject("dodge").getFloat("staminaCost");
            float totalArmorDefender = 0.0f;
            if (defender.body != null) {
                totalArmorDefender = totalArmorDefender + CombatEngine.stats("armors").getJSONObject(defender.body.id).getFloat("staminaCost") + CombatEngine.stats("tiers").getJSONObject(defender.body.tier).getFloat("armor") * 20.0f;
            }
            if (defender.head != null) {
                totalArmorDefender = totalArmorDefender + CombatEngine.stats("armors").getJSONObject(defender.head.id).getFloat("staminaCost") + CombatEngine.stats("tiers").getJSONObject(defender.head.tier).getFloat("armor") * 10.0f;
            }
            if (defender.arms != null) {
                totalArmorDefender = totalArmorDefender + CombatEngine.stats("armors").getJSONObject(defender.arms.id).getFloat("staminaCost") + CombatEngine.stats("tiers").getJSONObject(defender.arms.tier).getFloat("armor") * 10.0f;
            }
            if ((double)(armorPenalty = CombatEngine.getEffectValue(defender, timing.replace("phase:attack", "phase:defend"), "armpen", "stamin", randomSeed)) != 0.0) {
                totalArmorDefender -= armorPenalty;
            }
            if (totalArmorDefender > 0.0f) {
                result += totalArmorDefender;
            }
            if (!scenario.equalsIgnoreCase("")) {
                float scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getFloat("dodgeCost");
                result *= scenarioModifier;
            }
        }
        return (int)result;
    }

    public static int getBalanceCost(Fighter attacker, Fighter defender, int deviation, int attackerDeviation, String timing, int randomSeed) {
        float surge;
        float acrobatics;
        String offHandBonus;
        float result = 0.0f;
        int finalDodgeDeviation = deviation;
        result = CombatEngine.stats("timings").getJSONObject("dodge").getFloat("balanceCost");
        if (finalDodgeDeviation >= 0) {
            float bonusDeviation = CombatEngine.getEffectValue(defender, timing, "deviat", "dodge", randomSeed);
            if ((double)bonusDeviation != 0.0) {
                finalDodgeDeviation -= Float.valueOf(bonusDeviation).intValue();
            }
            if (finalDodgeDeviation < 0) {
                finalDodgeDeviation = 0;
            }
        }
        result *= CombatEngine.stats("timings").getJSONObject("dodge").getJSONObject("" + finalDodgeDeviation).getFloat("balanceCost");
        if (defender.offHand != null && (offHandBonus = CombatEngine.stats("weapons").getJSONObject(defender.offHand.id).getString("offHandBonus")).startsWith("bacoredu")) {
            float bacoredu = Float.parseFloat(offHandBonus.split(":")[1]);
            result -= bacoredu;
        }
        if ((double)(acrobatics = CombatEngine.getEffectValue(defender, "const", "dodge", "balcos", randomSeed)) != 0.0) {
            result *= acrobatics;
        }
        if ((double)(surge = CombatEngine.getEffectValue(attacker, null, "gain", "balcos", randomSeed)) != 0.0) {
            result += surge;
        }
        if (!scenario.equalsIgnoreCase("")) {
            float scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getFloat("dodgeCost");
            result *= scenarioModifier;
        }
        return (int)result;
    }

    public static long getParryTime(Fighter attacker, Fighter defender, int deviation, String timing, int randomSeed) {
        float stun;
        float parryTime;
        float attackTime;
        float armorPenaltyReduction;
        float result = 0.0f;
        int finalAttackDeviation = deviation;
        float weaponParryTime = CombatEngine.stats("weapons").getJSONObject(attacker.weapon.id).getFloat("parryTime");
        if (attacker.isPlayer && attacker.weapon.id.equalsIgnoreCase("dagger") && (CombatEngine.game.saveGame.isEmpty() || CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && CombatEngine.game.saveGame.get("rewards").contains("dagger-fighting") || CombatEngine.game.gameMode.equalsIgnoreCase("story") && CombatEngine.game.saveGame.get("rewards").contains("dagger-fighting"))) {
            weaponParryTime = 0.75f;
        }
        result = CombatEngine.stats("weapons").getJSONObject(attacker.weapon.id).getFloat("attackTime") * (1.0f + CombatEngine.stats("tiers").getJSONObject(attacker.weapon.tier).getFloat("weaponAttackTime") / 100.0f) * weaponParryTime * CombatEngine.combatState.timePressure.floatValue() * (1.0f - (float)CombatEngine.combatState.assaultPressure.intValue() * assaultPressureReduction);
        if (finalAttackDeviation >= 0) {
            float bonusDeviation = CombatEngine.getEffectValue(attacker, timing, "deviat", "attack", randomSeed);
            if ((double)bonusDeviation != 0.0) {
                finalAttackDeviation -= Float.valueOf(bonusDeviation).intValue();
            }
            if (finalAttackDeviation < 0) {
                finalAttackDeviation = 0;
            }
        }
        result *= CombatEngine.stats("timings").getJSONObject("attack").getJSONObject("" + finalAttackDeviation).getFloat("parryTime");
        float totalArmorAttacker = 0.0f;
        if (attacker.body != null) {
            totalArmorAttacker += CombatEngine.stats("armors").getJSONObject(attacker.body.id).getFloat("attackTime") - 1.0f + CombatEngine.stats("tiers").getJSONObject(attacker.body.tier).getFloat("armor") / 100.0f;
        }
        if (attacker.arms != null) {
            totalArmorAttacker += CombatEngine.stats("armors").getJSONObject(attacker.arms.id).getFloat("attackTime") - 1.0f + CombatEngine.stats("tiers").getJSONObject(attacker.arms.tier).getFloat("armor") / 100.0f;
        }
        if ((double)(armorPenaltyReduction = CombatEngine.getEffectValue(attacker, timing, "armpen", "time", randomSeed)) != 0.0) {
            float totalDodgePenalty = 0.0f;
            if (attacker.body != null) {
                totalDodgePenalty += 1.0f - CombatEngine.stats("armors").getJSONObject(attacker.body.id).getFloat("dodgeTime") + CombatEngine.stats("tiers").getJSONObject(attacker.body.tier).getFloat("armor") / 100.0f;
            }
            if (attacker.head != null) {
                totalDodgePenalty += 1.0f - CombatEngine.stats("armors").getJSONObject(attacker.head.id).getFloat("dodgeTime") + CombatEngine.stats("tiers").getJSONObject(attacker.head.tier).getFloat("armor") / 100.0f;
            }
            totalArmorAttacker = armorPenaltyReduction / 100.0f >= totalDodgePenalty + totalArmorAttacker ? 0.0f : totalArmorAttacker - armorPenaltyReduction / 200.0f - Math.max(armorPenaltyReduction / 200.0f - totalDodgePenalty, 0.0f);
        }
        if (totalArmorAttacker > 0.0f) {
            result *= 1.0f + totalArmorAttacker;
        }
        if ((double)(attackTime = CombatEngine.getEffectValue(attacker, timing, "time", "attack", randomSeed)) != 0.0) {
            result *= attackTime;
        }
        if ((double)(parryTime = CombatEngine.getEffectValue(defender, timing.replace("phase:attack", "phase:defend"), "time", "parry", randomSeed)) != 0.0) {
            result *= parryTime;
        }
        if ((double)(stun = CombatEngine.getEffectValue(defender, null, "stun", "", "stun", randomSeed)) != 0.0) {
            result *= 1.0f - stun;
        }
        if (!scenario.equalsIgnoreCase("")) {
            float scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getFloat("parryTime");
            result *= scenarioModifier;
        }
        if (!game.isMultiplayerGame() && defender.isPlayer) {
            result *= playerTimeMultiplier;
        }
        return (long)result;
    }

    public static long getDodgeTime(Fighter attacker, Fighter defender, int deviation, String timing, int randomSeed) {
        float stun;
        float dodgeTime;
        float attackTime;
        float armorPenaltyReduction;
        float result = 0.0f;
        int finalAttackDeviation = deviation;
        float weaponDodgeTime = CombatEngine.stats("weapons").getJSONObject(attacker.weapon.id).getFloat("dodgeTime");
        if (attacker.isPlayer && attacker.weapon.id.equalsIgnoreCase("dagger") && (CombatEngine.game.saveGame.isEmpty() || CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && CombatEngine.game.saveGame.get("rewards").contains("dagger-fighting") || CombatEngine.game.gameMode.equalsIgnoreCase("story") && CombatEngine.game.saveGame.get("rewards").contains("dagger-fighting"))) {
            weaponDodgeTime = 0.75f;
        }
        result = CombatEngine.stats("weapons").getJSONObject(attacker.weapon.id).getFloat("attackTime") * (1.0f + CombatEngine.stats("tiers").getJSONObject(attacker.weapon.tier).getFloat("weaponAttackTime") / 100.0f) * weaponDodgeTime * CombatEngine.combatState.timePressure.floatValue() * (1.0f - (float)CombatEngine.combatState.assaultPressure.intValue() * assaultPressureReduction);
        if (finalAttackDeviation >= 0) {
            float bonusDeviation = CombatEngine.getEffectValue(attacker, timing, "deviat", "attack", randomSeed);
            if ((double)bonusDeviation != 0.0) {
                finalAttackDeviation -= Float.valueOf(bonusDeviation).intValue();
            }
            if (finalAttackDeviation < 0) {
                finalAttackDeviation = 0;
            }
        }
        result *= CombatEngine.stats("timings").getJSONObject("attack").getJSONObject("" + finalAttackDeviation).getFloat("dodgeTime");
        float totalArmorAttacker = 0.0f;
        if (attacker.body != null) {
            totalArmorAttacker += CombatEngine.stats("armors").getJSONObject(attacker.body.id).getFloat("attackTime") - 1.0f + CombatEngine.stats("tiers").getJSONObject(attacker.body.tier).getFloat("armor") / 100.0f;
        }
        if (attacker.arms != null) {
            totalArmorAttacker += CombatEngine.stats("armors").getJSONObject(attacker.arms.id).getFloat("attackTime") - 1.0f + CombatEngine.stats("tiers").getJSONObject(attacker.arms.tier).getFloat("armor") / 100.0f;
        }
        if ((double)(armorPenaltyReduction = CombatEngine.getEffectValue(attacker, timing, "armpen", "time", randomSeed)) != 0.0) {
            float totalDodgePenalty = 0.0f;
            if (attacker.body != null) {
                totalDodgePenalty += 1.0f - CombatEngine.stats("armors").getJSONObject(attacker.body.id).getFloat("dodgeTime") + CombatEngine.stats("tiers").getJSONObject(attacker.body.tier).getFloat("armor") / 100.0f;
            }
            if (attacker.head != null) {
                totalDodgePenalty += 1.0f - CombatEngine.stats("armors").getJSONObject(attacker.head.id).getFloat("dodgeTime") + CombatEngine.stats("tiers").getJSONObject(attacker.head.tier).getFloat("armor") / 100.0f;
            }
            totalArmorAttacker = armorPenaltyReduction / 100.0f >= totalDodgePenalty + totalArmorAttacker ? 0.0f : totalArmorAttacker - armorPenaltyReduction / 200.0f - Math.max(armorPenaltyReduction / 200.0f - totalDodgePenalty, 0.0f);
        }
        if (totalArmorAttacker > 0.0f) {
            result *= 1.0f + totalArmorAttacker;
        }
        float totalArmorDefender = 0.0f;
        if (defender.body != null) {
            totalArmorDefender += 1.0f - CombatEngine.stats("armors").getJSONObject(defender.body.id).getFloat("dodgeTime") + CombatEngine.stats("tiers").getJSONObject(defender.body.tier).getFloat("armor") / 100.0f;
        }
        if (defender.head != null) {
            totalArmorDefender += 1.0f - CombatEngine.stats("armors").getJSONObject(defender.head.id).getFloat("dodgeTime") + CombatEngine.stats("tiers").getJSONObject(defender.head.tier).getFloat("armor") / 100.0f;
        }
        if ((double)(armorPenaltyReduction = CombatEngine.getEffectValue(defender, timing.replace("phase:attack", "phase:defend"), "armpen", "time", randomSeed)) != 0.0) {
            float totalAttackPenalty = 0.0f;
            if (defender.body != null) {
                totalAttackPenalty += CombatEngine.stats("armors").getJSONObject(defender.body.id).getFloat("attackTime") - 1.0f + CombatEngine.stats("tiers").getJSONObject(defender.body.tier).getFloat("armor") / 100.0f;
            }
            if (defender.arms != null) {
                totalAttackPenalty += CombatEngine.stats("armors").getJSONObject(defender.arms.id).getFloat("attackTime") - 1.0f + CombatEngine.stats("tiers").getJSONObject(defender.arms.tier).getFloat("armor") / 100.0f;
            }
            totalArmorDefender = armorPenaltyReduction / 100.0f >= totalAttackPenalty + totalArmorDefender ? 0.0f : totalArmorDefender - armorPenaltyReduction / 200.0f - Math.max(armorPenaltyReduction / 200.0f - totalAttackPenalty, 0.0f);
        }
        if (totalArmorDefender > 0.0f) {
            result *= 1.0f - totalArmorDefender;
        }
        if ((double)(attackTime = CombatEngine.getEffectValue(attacker, timing, "time", "attack", randomSeed)) != 0.0) {
            result *= attackTime;
        }
        if ((double)(dodgeTime = CombatEngine.getEffectValue(defender, timing.replace("phase:attack", "phase:defend"), "time", "dodge", randomSeed)) != 0.0) {
            result *= dodgeTime;
        }
        if ((double)(stun = CombatEngine.getEffectValue(defender, null, "stun", "", "stun", randomSeed)) != 0.0) {
            result *= 1.0f - stun;
        }
        if (!scenario.equalsIgnoreCase("")) {
            float scenarioModifier = ((JSONObject)((JSONObject)CombatEngine.game.stats.get("phases").get("scenarios")).get(scenario)).getFloat("dodgeTime");
            result *= scenarioModifier;
        }
        if (!game.isMultiplayerGame() && defender.isPlayer) {
            result *= playerTimeMultiplier;
        }
        return (long)result;
    }

    public static long getChainTime(Fighter attacker, Fighter defender, int deviation, String timing, int randomSeed) {
        float stun;
        float result = 0.0f;
        int finalAttackDeviation = deviation;
        result = (CombatEngine.stats("timings").getJSONObject("chain").getFloat("time") + CombatEngine.stats("timings").getJSONObject("platform").getFloat(selectedInput)) * CombatEngine.combatState.timePressure.floatValue() * 2.0f;
        if (finalAttackDeviation >= 0) {
            float bonusDeviation = CombatEngine.getEffectValue(attacker, timing, "deviat", "chain", randomSeed);
            if ((double)bonusDeviation != 0.0) {
                finalAttackDeviation -= Float.valueOf(bonusDeviation).intValue();
            }
            if (finalAttackDeviation < 0) {
                finalAttackDeviation = 0;
            }
        }
        result *= CombatEngine.stats("timings").getJSONObject("attack").getJSONObject("" + finalAttackDeviation).getFloat("chainTime");
        float chainTime = CombatEngine.getEffectValue(attacker, timing, "time", "chain", randomSeed);
        if ((double)chainTime != 0.0) {
            result *= chainTime;
        }
        if ((double)(stun = CombatEngine.getEffectValue(attacker, null, "stun", "", "stun", randomSeed)) != 0.0) {
            result *= 1.0f - stun;
        }
        if (!game.isMultiplayerGame() && attacker.isPlayer) {
            result *= playerTimeMultiplier;
        }
        return (long)result;
    }

    public static long getRisposteTime(String type, Fighter attacker, Fighter defender, int deviation, String timing, int randomSeed) {
        float stun;
        float result = 0.0f;
        int finalAttackDeviation = deviation;
        result = (CombatEngine.stats("timings").getJSONObject("risposte").getFloat("time") + CombatEngine.stats("timings").getJSONObject("platform").getFloat(selectedInput)) * CombatEngine.combatState.timePressure.floatValue() * 2.0f;
        if (finalAttackDeviation >= 0) {
            float bonusDeviation = CombatEngine.getEffectValue(attacker, timing, "deviat", "rispos", randomSeed);
            if ((double)bonusDeviation != 0.0) {
                finalAttackDeviation -= Float.valueOf(bonusDeviation).intValue();
            }
            if (finalAttackDeviation < 0) {
                finalAttackDeviation = 0;
            }
        }
        result *= CombatEngine.stats("timings").getJSONObject(type).getJSONObject("" + finalAttackDeviation).getFloat("risposteTime");
        float riposteTime = CombatEngine.getEffectValue(attacker, timing, "time", "rispre", randomSeed);
        if ((double)riposteTime != 0.0) {
            result *= 2.0f - timePressureReduction;
        }
        if ((double)(stun = CombatEngine.getEffectValue(attacker, null, "stun", "", "stun", randomSeed)) != 0.0) {
            result *= 1.0f - stun;
        }
        if (!game.isMultiplayerGame() && attacker.isPlayer) {
            result *= playerTimeMultiplier;
        }
        return (long)result;
    }

    public static long getRisposteStamina(String type, Fighter defender, Fighter attacker, int deviation, String timing, int randomSeed) {
        float result = 0.0f;
        result = CombatEngine.stats("timings").getJSONObject(type).getJSONObject("" + deviation).getFloat("risposteStamina");
        return (long)result;
    }

    public static long getUseTime(Fighter attacker, Fighter defender, String item, String type, String timing, int randomSeed) {
        float result = 0.0f;
        result = CombatEngine.stats("timings").getJSONObject("use").getFloat("time") + CombatEngine.stats("timings").getJSONObject("platform").getFloat(selectedInput);
        if (item.equalsIgnoreCase("shard")) {
            result = (result - (type.equalsIgnoreCase("parry") ? CombatEngine.stats("timings").getJSONObject("item").getFloat("shard") : 0.0f)) * CombatEngine.combatState.timePressure.floatValue();
        } else if (item.equalsIgnoreCase("powder")) {
            result = (result - (type.equalsIgnoreCase("dodge") ? CombatEngine.stats("timings").getJSONObject("item").getFloat("powder") : 0.0f)) * CombatEngine.combatState.timePressure.floatValue();
        } else if (item.equalsIgnoreCase("net")) {
            result = (result - CombatEngine.stats("timings").getJSONObject("item").getFloat("net")) * CombatEngine.combatState.timePressure.floatValue();
        }
        float useTime = CombatEngine.getEffectValue(attacker, timing, "useite", "time", randomSeed);
        if ((double)useTime != 0.0) {
            result *= useTime;
        }
        if (!game.isMultiplayerGame() && defender.isPlayer) {
            result *= playerTimeMultiplier;
        }
        return (long)result;
    }

    public static int getCriticalChance(Fighter attacker, int deviation, String timing, int randomSeed) {
        float result = 0.0f;
        result = CombatEngine.stats("weapons").getJSONObject(attacker.weapon.id).getFloat("criticalChance") * CombatEngine.stats("timings").getJSONObject("attack").getJSONObject("" + deviation).getFloat("criticalChance");
        result = result * (100.0f + CombatEngine.stats("tiers").getJSONObject(attacker.weapon.tier).getFloat("weaponCriticalChance")) / 100.0f;
        float criticalChance = CombatEngine.getEffectValue(attacker, timing, "critic", "chance", randomSeed);
        if ((double)criticalChance != 0.0) {
            result *= criticalChance;
        }
        return (int)result;
    }

    public static int getArmorReduction(Fighter fighter) {
        float result = 0.0f;
        if (fighter.body != null) {
            result += CombatEngine.stats("armors").getJSONObject(fighter.body.id).getFloat("damageReduction") + CombatEngine.stats("tiers").getJSONObject(fighter.body.tier).getFloat("armor") * 2.0f * (CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && CombatEngine.game.saveGame.get("rewards").contains("crafts") ? 100.0f + Float.valueOf(Tournament.getRewardStock(game, "crafts")).floatValue() : 100.0f) / 100.0f;
        }
        if (fighter.head != null) {
            result += CombatEngine.stats("armors").getJSONObject(fighter.head.id).getFloat("damageReduction") + CombatEngine.stats("tiers").getJSONObject(fighter.head.tier).getFloat("armor") * (CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && CombatEngine.game.saveGame.get("rewards").contains("crafts") ? 100.0f + Float.valueOf(Tournament.getRewardStock(game, "crafts")).floatValue() : 100.0f) / 100.0f;
        }
        if (fighter.arms != null) {
            result += CombatEngine.stats("armors").getJSONObject(fighter.arms.id).getFloat("damageReduction") + CombatEngine.stats("tiers").getJSONObject(fighter.arms.tier).getFloat("armor") * (CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && CombatEngine.game.saveGame.get("rewards").contains("crafts") ? 100.0f + Float.valueOf(Tournament.getRewardStock(game, "crafts")).floatValue() : 100.0f) / 100.0f;
        }
        if (CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && fighter.name.equalsIgnoreCase("boss3")) {
            result += 10.0f;
        }
        return (int)result;
    }

    public static int getDamageDealt(Fighter attacker, Fighter defender, int parryDeviation, String timing, int randomSeed, boolean isVulnerable) {
        float damageModifier;
        String offHandBonus;
        float result = 0.0f;
        int finalParryDeviation = parryDeviation;
        result = CombatEngine.stats("weapons").getJSONObject(attacker.weapon.id).getFloat("baseDamage") * (1.0f + CombatEngine.stats("tiers").getJSONObject(attacker.weapon.tier).getFloat("weaponBaseDamage") * (CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && CombatEngine.game.saveGame.get("rewards").contains("crafts") ? 100.0f + Float.valueOf(Tournament.getRewardStock(game, "crafts")).floatValue() : 100.0f) / 100.0f / 100.0f);
        float darepena = 0.0f;
        if (attacker.offHand != null && (offHandBonus = CombatEngine.stats("weapons").getJSONObject(attacker.offHand.id).getString("offHandBonus")).startsWith("darepena")) {
            darepena = Float.parseFloat(offHandBonus.split(":")[1]);
        }
        boolean barrier = false;
        float surge = CombatEngine.getEffectValue(attacker, null, "gain", "damsur", randomSeed);
        if ((double)surge != 0.0) {
            barrier = true;
        }
        if (isVulnerable && !barrier) {
            float vulnerableDamageBonus = CombatEngine.stats("timings").getJSONObject("vulnerable").getFloat("baseDamage") - 1.0f;
            float vulnerableExtraBonus = CombatEngine.getEffectValue(attacker, timing, "vulspo", "dambas", randomSeed);
            if ((double)vulnerableExtraBonus != 0.0) {
                vulnerableDamageBonus *= vulnerableExtraBonus;
            }
            if ((double)(vulnerableExtraBonus = CombatEngine.getEffectValue(attacker, timing, "vulspo", "pressu", randomSeed)) != 0.0) {
                vulnerableDamageBonus += vulnerableExtraBonus * (1.0f - CombatEngine.combatState.timePressure.floatValue() * (1.0f - (float)CombatEngine.combatState.assaultPressure.intValue() * assaultPressureReduction));
            }
            result *= 1.0f + vulnerableDamageBonus;
        }
        if (finalParryDeviation >= 0) {
            float bonusDeviation;
            String offHandBonus2;
            if (defender.offHand != null && (offHandBonus2 = CombatEngine.stats("weapons").getJSONObject(defender.offHand.id).getString("offHandBonus")).startsWith("parrdevi")) {
                float parrdevi = Float.parseFloat(offHandBonus2.split(":")[1]);
                finalParryDeviation -= Float.valueOf(parrdevi).intValue();
            }
            if ((double)(bonusDeviation = CombatEngine.getEffectValue(defender, timing.replace("phase:attack", "phase:defend"), "deviat", "parry", randomSeed)) != 0.0) {
                finalParryDeviation -= Float.valueOf(bonusDeviation).intValue();
            }
            if (finalParryDeviation < 0) {
                finalParryDeviation = 0;
            }
            result *= CombatEngine.stats("timings").getJSONObject("parry").getJSONObject("" + finalParryDeviation).getFloat("damageReduction") * (1.0f + darepena);
            float damageParry = CombatEngine.getEffectValue(attacker, timing, "damage", "parry", randomSeed);
            if ((double)damageParry != 0.0) {
                result *= damageParry;
            }
        }
        if ((double)(damageModifier = CombatEngine.getEffectValue(attacker, timing, "damage", "base", randomSeed)) != 0.0) {
            result *= damageModifier;
        }
        if ((double)(damageModifier = CombatEngine.getEffectValue(attacker, timing, "damage", "debuff", randomSeed)) != 0.0 && CombatEngine.combatState.getDefender().debuffs.length() > 0) {
            result *= damageModifier;
        }
        if ((double)(damageModifier = CombatEngine.getEffectValue(attacker, timing, "damage", "buff", randomSeed)) != 0.0 && CombatEngine.combatState.getAttacker().buffs.length() > 0) {
            result *= damageModifier;
        }
        if ((double)(damageModifier = CombatEngine.getEffectValue(attacker, timing, "weaken", "", "weaken", randomSeed)) != 0.0) {
            result *= 1.0f - damageModifier;
        }
        return (int)result;
    }

    public static int getArmorDamageReduction(int baseDamage, Fighter attacker, Fighter defender, int randomSeed) {
        float surge;
        String offHandBonus;
        float result = baseDamage;
        float darepena = 0.0f;
        if (attacker.offHand != null && (offHandBonus = CombatEngine.stats("weapons").getJSONObject(attacker.offHand.id).getString("offHandBonus")).startsWith("darepena")) {
            darepena = Float.parseFloat(offHandBonus.split(":")[1]);
        }
        if ((double)(surge = CombatEngine.getEffectValue(attacker, null, "ignore", "damred", randomSeed)) != 0.0) {
            darepena += surge;
        }
        if (darepena > 1.0f) {
            darepena = 1.0f;
        }
        float finalDamageReduction = (float)CombatEngine.getArmorReduction(defender) * (1.0f - darepena);
        result = result * (100.0f - finalDamageReduction) / 100.0f;
        return (int)result;
    }

    public static int getCriticalDamage(int baseDamage, Fighter attacker, String timing, int randomSeed) {
        float result = (float)baseDamage * 1.5f;
        float critMultip = CombatEngine.getEffectValue(attacker, timing, "critic", "multip", randomSeed);
        if ((double)critMultip != 0.0) {
            result *= critMultip;
        }
        return (int)result;
    }

    public static boolean bossSpecialCondition(String type, String option) {
        if (!game.isMultiplayerGame() && CombatEngine.combatState.clientFighter.name.equalsIgnoreCase("boss1")) {
            if (type.equalsIgnoreCase("attack") && CombatEngine.combatState.clientBossSpecial.equalsIgnoreCase(option)) {
                return true;
            }
            if (CombatEngine.combatState.clientFighter.life < 3000 && type.equalsIgnoreCase("dodge")) {
                return true;
            }
            if (CombatEngine.combatState.clientFighter.life < 6000 && type.equalsIgnoreCase("dodge") && option.equalsIgnoreCase("left")) {
                return true;
            }
        }
        return false;
    }

    public static boolean canPayActionCost(String type, String option, int deviation, Fighter actingFighter, Fighter passiveFighter, int randomSeed) {
        String phase = "phase:attack";
        String event = "";
        if (type.equalsIgnoreCase("attack")) {
            event = "event:attbas";
            if (CombatEngine.combatState.stage.equalsIgnoreCase("chain")) {
                event = "event:chabas";
            } else if (CombatEngine.combatState.stage.equalsIgnoreCase("risposte")) {
                event = "event:risbas";
            }
            int staminaCost = CombatEngine.getStaminaCost("attack", actingFighter, passiveFighter, deviation, event + ";" + phase, randomSeed / 10);
            return CombatEngine.canPayStamina(actingFighter, "attack", staminaCost, 0, false, randomSeed / 10);
        }
        if (type.equalsIgnoreCase("parry")) {
            phase = "phase:defend";
            event = "event:parbas";
            int staminaCost = CombatEngine.getStaminaCost("parry", passiveFighter, actingFighter, attackerDeviation, event + ";" + phase, randomSeed / 10);
            return CombatEngine.canPayStamina(actingFighter, "parry", staminaCost, 0, false, randomSeed / 10);
        }
        if (type.equalsIgnoreCase("dodge")) {
            phase = "phase:defend";
            event = "event:dodbas";
            float ignoreBalanceCheck = CombatEngine.getEffectValue(actingFighter, event + ";" + phase, "ignore", "chebal", randomSeed / 10);
            int staminaCost = CombatEngine.getStaminaCost("dodge", passiveFighter, actingFighter, attackerDeviation, event + ";" + phase, randomSeed / 10);
            int balanceCost = CombatEngine.getBalanceCost(passiveFighter, actingFighter, (double)ignoreBalanceCheck != 0.0 ? deviation : 50, attackerDeviation, event + ";" + phase, randomSeed / 10);
            float acrobatics = CombatEngine.getEffectValue(passiveFighter, "const", "dodge", "stabal", randomSeed);
            if ((double)acrobatics != 0.0) {
                float acrobaticsReduction = CombatEngine.getEffectValue(passiveFighter, "const", "dodge", "balcos", randomSeed);
                balanceCost += (int)((float)staminaCost * acrobatics * acrobaticsReduction);
                staminaCost = 0;
            }
            return CombatEngine.canPayStamina(actingFighter, "dodge", staminaCost, balanceCost, false, randomSeed / 10) && actingFighter.balance >= balanceCost;
        }
        return type.equalsIgnoreCase("idle") || type.equalsIgnoreCase("use") || type.equalsIgnoreCase("surge");
    }

    public static boolean canPayStamina(Fighter fighter, String action, int stamina, int balanceSurplus, boolean pay, int randomSeed) {
        float acrobatics = CombatEngine.getEffectValue(fighter, "const", "parry", "stabal", randomSeed);
        if (action.equalsIgnoreCase("parry") && (double)acrobatics != 0.0 && (float)fighter.balance >= (float)stamina * acrobatics) {
            if (pay) {
                fighter.balance -= (int)((float)stamina * acrobatics);
                if (fighter.isHost) {
                    CombatEngine.combatStateChanges.sendhba = fighter.balance;
                } else {
                    CombatEngine.combatStateChanges.sendcba = fighter.balance;
                }
                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, fighter.isHost ? "h:balanc:-1" : "c:balanc:-1", ",");
            }
            return true;
        }
        float balanceToStamina = CombatEngine.getEffectValue(fighter, "const", "stamin", "balanc", randomSeed / 10);
        if (balanceToStamina != 0.0f) {
            if (fighter.stamina >= stamina) {
                if (pay) {
                    fighter.stamina -= stamina;
                    if (fighter.isHost) {
                        CombatEngine.combatStateChanges.sendhst = fighter.stamina;
                    } else {
                        CombatEngine.combatStateChanges.sendcst = fighter.stamina;
                    }
                    CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, fighter.isHost ? "h:stamin:-1" : "c:stamin:-1", ",");
                }
                return true;
            }
            if ((float)fighter.balance >= (float)(stamina - fighter.stamina) * balanceToStamina + (float)balanceSurplus) {
                if (pay) {
                    fighter.balance -= Float.valueOf((float)(stamina - fighter.stamina) * balanceToStamina).intValue();
                    if (fighter.isHost) {
                        CombatEngine.combatStateChanges.sendhba = fighter.balance;
                    } else {
                        CombatEngine.combatStateChanges.sendcba = fighter.balance;
                    }
                    CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, fighter.isHost ? "h:balanc:-1" : "c:balanc:-1", ",");
                    fighter.stamina = 0;
                    if (fighter.isHost) {
                        CombatEngine.combatStateChanges.sendhst = fighter.stamina;
                    } else {
                        CombatEngine.combatStateChanges.sendcst = fighter.stamina;
                    }
                    CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, fighter.isHost ? "h:stamin:-1" : "c:stamin:-1", ",");
                }
                return true;
            }
        } else if (fighter.stamina >= stamina) {
            if (pay) {
                fighter.stamina -= stamina;
                if (fighter.isHost) {
                    CombatEngine.combatStateChanges.sendhst = fighter.stamina;
                } else {
                    CombatEngine.combatStateChanges.sendcst = fighter.stamina;
                }
                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, fighter.isHost ? "h:stamin:-1" : "c:stamin:-1", ",");
            }
            return true;
        }
        return false;
    }

    public static void checkFightersRecover(Fighter f1, Fighter f2, float delta) {
        boolean f1RecoverStamina = false;
        boolean f1RecoverBalance = false;
        boolean f2RecoverStamina = false;
        boolean f2RecoverBalance = false;
        recoverCounter += Float.valueOf(delta * 1000.0f).longValue();
        float finalRecoverMultiplier = recoverMultiplier;
        if (!CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && Tournament.getRewardStock(game, "stimulant") > 0) {
            finalRecoverMultiplier = finalRecoverMultiplier * (100.0f + (float)Tournament.getRewardStock(game, "stimulant")) / 100.0f;
        }
        if (recoverCounter > 100L) {
            float surge;
            String surgeType;
            int lifeLoss;
            Effect poison;
            int lifeLoss2;
            Effect laceration;
            int lifeLoss3;
            float bleedValue;
            int origf1life = f1.life;
            int origf1stamina = f1.stamina;
            int origf1balance = f1.balance;
            float origf1staminaGain = 1.0f;
            float origf1balanceGain = 1.0f;
            int origf1surge = f1.surge;
            int origf2life = f2.life;
            int origf2stamina = f2.stamina;
            int origf2balance = f2.balance;
            float origf2staminaGain = 1.0f;
            float origf2balanceGain = 1.0f;
            int origf2surge = f2.surge;
            if (CombatEngine.combatState.stage.equalsIgnoreCase("start") || CombatEngine.combatState.stage.equalsIgnoreCase("chain") || CombatEngine.combatState.stage.equalsIgnoreCase("risposte")) {
                f1RecoverStamina = true;
                f1RecoverBalance = true;
                f2RecoverStamina = true;
                f2RecoverBalance = true;
            } else if (CombatEngine.combatState.stage.equalsIgnoreCase("attack")) {
                float allowRecovery;
                if (f1 == combatState.getAttacker()) {
                    f2RecoverStamina = true;
                    f2RecoverBalance = true;
                    allowRecovery = CombatEngine.getEffectValue(f1, "phase:attack", "allrec", "stamin", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10);
                    if (allowRecovery != 0.0f) {
                        f1RecoverStamina = true;
                        origf1staminaGain = allowRecovery;
                    }
                    if ((allowRecovery = CombatEngine.getEffectValue(f1, "phase:attack", "allrec", "balanc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10)) != 0.0f) {
                        f1RecoverBalance = true;
                        origf1balanceGain = allowRecovery;
                    }
                } else {
                    f1RecoverStamina = true;
                    f1RecoverBalance = true;
                    allowRecovery = CombatEngine.getEffectValue(f2, "phase:attack", "allrec", "stamin", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10);
                    if (allowRecovery != 0.0f) {
                        f2RecoverStamina = true;
                        origf2staminaGain = allowRecovery;
                    }
                    if ((allowRecovery = CombatEngine.getEffectValue(f2, "phase:attack", "allrec", "balanc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947) / 10)) != 0.0f) {
                        f2RecoverBalance = true;
                        origf2balanceGain = allowRecovery;
                    }
                }
            }
            float f1exhausted = 1.0f - CombatEngine.getEffectValue(f1, null, "exhaus", "", "exhaus", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10);
            if (f1RecoverStamina && f1.stamina < f1.maxStamina) {
                float staminaGain = (float)recoverCounter / 100.0f * finalRecoverMultiplier * origf1staminaGain;
                float recoverStamina = CombatEngine.getEffectValue(f1, "const", "recove", "stamin", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10);
                if (CombatEngine.combatState.stage.equalsIgnoreCase("attack") && f1 == combatState.getAttacker()) {
                    recoverStamina = CombatEngine.getEffectValue(f1, "phase:attack", "recove", "stamin", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10);
                }
                if (recoverStamina != 0.0f) {
                    staminaGain *= recoverStamina;
                }
                f1.stamina += Float.valueOf(staminaGain * f1exhausted).intValue();
            }
            if (f1RecoverBalance && f1.balance < f1.maxBalance) {
                float balanceGain = (float)recoverCounter / 100.0f * finalRecoverMultiplier * origf1balanceGain;
                float recoverBalance = CombatEngine.getEffectValue(f1, "const", "recove", "balanc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827) / 10);
                if (CombatEngine.combatState.stage.equalsIgnoreCase("attack") && f1 == combatState.getAttacker()) {
                    recoverBalance = CombatEngine.getEffectValue(f1, "phase:attack", "recove", "balanc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10);
                }
                if (recoverBalance != 0.0f) {
                    balanceGain *= recoverBalance;
                }
                f1.balance += Float.valueOf(balanceGain * f1exhausted).intValue();
            }
            float f2exhausted = 1.0f - CombatEngine.getEffectValue(f2, null, "exhaus", "", "exhaus", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10);
            if (f2RecoverStamina && f2.stamina < f2.maxStamina) {
                float staminaGain = (float)recoverCounter / 100.0f * finalRecoverMultiplier * origf2staminaGain;
                float recoverStamina = CombatEngine.getEffectValue(f2, "const", "recove", "stamin", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10);
                if (CombatEngine.combatState.stage.equalsIgnoreCase("attack") && f2 == combatState.getAttacker()) {
                    recoverStamina = CombatEngine.getEffectValue(f2, "phase:attack", "recove", "stamin", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10);
                }
                if (recoverStamina != 0.0f) {
                    staminaGain *= recoverStamina;
                }
                f2.stamina += Float.valueOf(staminaGain * f2exhausted).intValue();
            }
            if (f2RecoverBalance && f2.balance < f2.maxBalance) {
                float balanceGain = (float)recoverCounter / 100.0f * finalRecoverMultiplier * origf2balanceGain;
                float recoverBalance = CombatEngine.getEffectValue(f2, "const", "recove", "balanc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947) / 10);
                if (CombatEngine.combatState.stage.equalsIgnoreCase("attack") && f2 == combatState.getAttacker()) {
                    recoverBalance = CombatEngine.getEffectValue(f2, "phase:attack", "recove", "balanc", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10);
                }
                if (recoverBalance != 0.0f) {
                    balanceGain *= recoverBalance;
                }
                f2.balance += Float.valueOf(balanceGain * f2exhausted).intValue();
            }
            if (f1.stamina > f1.maxStamina) {
                f1.stamina = f1.maxStamina;
            } else if (f1.stamina < 0) {
                f1.stamina = 0;
            }
            if (f1.balance > f1.maxBalance) {
                f1.balance = f1.maxBalance;
            } else if (f1.balance < 0) {
                f1.balance = 0;
            }
            if (f2.stamina > f2.maxStamina) {
                f2.stamina = f2.maxStamina;
            } else if (f2.stamina < 0) {
                f2.stamina = 0;
            }
            if (f2.balance > f2.maxBalance) {
                f2.balance = f2.maxBalance;
            } else if (f2.balance < 0) {
                f2.balance = 0;
            }
            Effect bleed = CombatEngine.getEffect(f1, null, "bleed", "", "bleed", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10);
            if (bleed != null) {
                bleedValue = Float.parseFloat(bleed.value);
                lifeLoss3 = Long.valueOf((long)((int)(bleedValue = (float)f1.maxLife * bleedValue / 1000.0f)) * (recoverCounter / 100L)).intValue();
                if (lifeLoss3 <= 0) {
                    lifeLoss3 = 1;
                }
                f1.life -= lifeLoss3;
                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, f1.isHost ? "h:life:-1" : "c:life:-1", ",");
                if (f1.life < 0) {
                    f1.life = 0;
                }
                f1.surge += lifeLoss3 * 2;
                if (f1.surge > 10000) {
                    f1.surge = 10000;
                }
            }
            if ((bleed = CombatEngine.getEffect(f2, null, "bleed", "", "bleed", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10)) != null) {
                bleedValue = Float.parseFloat(bleed.value);
                lifeLoss3 = Long.valueOf((long)((int)(bleedValue = (float)f2.maxLife * bleedValue / 1000.0f)) * (recoverCounter / 100L)).intValue();
                if (lifeLoss3 <= 0) {
                    lifeLoss3 = 1;
                }
                f2.life -= lifeLoss3;
                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, f2.isHost ? "h:life:-1" : "c:life:-1", ",");
                if (f2.life < 0) {
                    f2.life = 0;
                }
                f2.surge += lifeLoss3 * 2;
                if (f2.surge > 10000) {
                    f2.surge = 10000;
                }
            }
            if ((laceration = CombatEngine.getEffect(f1, null, "laceration", "", "laceration", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827) / 10)) != null) {
                float lacerationValue = Float.parseFloat(laceration.value);
                lifeLoss2 = Long.valueOf((long)((int)(lacerationValue = (float)f1.maxLife * lacerationValue / 1000.0f)) * (recoverCounter / 100L)).intValue();
                if (lifeLoss2 <= 0) {
                    lifeLoss2 = 1;
                }
                f1.life -= lifeLoss2;
                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, f1.isHost ? "h:life:-1" : "c:life:-1", ",");
                if (f1.life < 0) {
                    f1.life = 0;
                }
                f1.surge += lifeLoss2 * 2;
                if (f1.surge > 10000) {
                    f1.surge = 10000;
                }
            }
            if ((laceration = CombatEngine.getEffect(f2, null, "laceration", "", "laceration", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10)) != null) {
                float lacerationValue = Float.parseFloat(laceration.value);
                lifeLoss2 = Long.valueOf((long)((int)(lacerationValue = (float)f2.maxLife * lacerationValue / 1000.0f)) * (recoverCounter / 100L)).intValue();
                if (lifeLoss2 <= 0) {
                    lifeLoss2 = 1;
                }
                f2.life -= lifeLoss2;
                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, f2.isHost ? "h:life:-1" : "c:life:-1", ",");
                if (f2.life < 0) {
                    f2.life = 0;
                }
                f2.surge += lifeLoss2 * 2;
                if (f2.surge > 10000) {
                    f2.surge = 10000;
                }
            }
            if ((poison = CombatEngine.getEffect(f1, null, "poison", "", "poison", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 593) / 10)) != null) {
                float poisonValue = Float.parseFloat(poison.value);
                lifeLoss = Long.valueOf((long)((int)(poisonValue = (float)f1.maxLife * poisonValue / 1000.0f)) * (recoverCounter / 100L)).intValue();
                if (lifeLoss <= 0) {
                    lifeLoss = 1;
                }
                f1.life -= lifeLoss;
                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, f1.isHost ? "h:life:-1" : "c:life:-1", ",");
                if (f1.life < 0) {
                    f1.life = 0;
                }
                f1.surge += lifeLoss * 2;
                if (f1.surge > 10000) {
                    f1.surge = 10000;
                }
            }
            if ((poison = CombatEngine.getEffect(f2, null, "poison", "", "poison", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 241) / 10)) != null) {
                float poisonValue = Float.parseFloat(poison.value);
                lifeLoss = Long.valueOf((long)((int)(poisonValue = (float)f2.maxLife * poisonValue / 1000.0f)) * (recoverCounter / 100L)).intValue();
                if (lifeLoss <= 0) {
                    lifeLoss = 1;
                }
                f2.life -= lifeLoss;
                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, f2.isHost ? "h:life:-1" : "c:life:-1", ",");
                if (f2.life < 0) {
                    f2.life = 0;
                }
                f2.surge += lifeLoss * 2;
                if (f2.surge > 10000) {
                    f2.surge = 10000;
                }
            }
            String string = surgeType = f1.isHost ? CombatEngine.combatState.hostSurgeType : CombatEngine.combatState.clientSurgeType;
            if (surgeType != null && !surgeType.equalsIgnoreCase("") && (surge = CombatEngine.getEffectValue(f1, null, "suract", surgeType, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 353) / 10)) > 0.0f) {
                f1.surge -= (int)surge;
                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, f1.isHost ? "h:surge:-1" : "c:surge:-1", ",");
                if (f1.surge <= 0) {
                    CombatEngine.removeBuff(f1, "surge");
                    CombatEngine.removeEffectBySource(f1, "surge");
                    f1.surge = 0;
                }
            }
            String string2 = surgeType = f2.isHost ? CombatEngine.combatState.hostSurgeType : CombatEngine.combatState.clientSurgeType;
            if (surgeType != null && !surgeType.equalsIgnoreCase("") && (surge = CombatEngine.getEffectValue(f2, null, "suract", surgeType, CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 947) / 10)) > 0.0f) {
                f2.surge -= (int)surge;
                CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, f2.isHost ? "h:surge:-1" : "c:surge:-1", ",");
                if (f2.surge <= 0) {
                    CombatEngine.removeBuff(f2, "surge");
                    CombatEngine.removeEffectBySource(f2, "surge");
                    f2.surge = 0;
                }
            }
            if (f1.isHost) {
                if (f1.life != origf1life) {
                    CombatEngine.combatStateChanges.sendhli = f1.life;
                }
                if (f1.stamina != origf1stamina) {
                    CombatEngine.combatStateChanges.sendhst = f1.stamina;
                }
                if (f1.balance != origf1balance) {
                    CombatEngine.combatStateChanges.sendhba = f1.balance;
                }
                if (f1.surge != origf1surge) {
                    CombatEngine.combatStateChanges.sendhsu = f1.surge;
                }
                if (f2.life != origf2life) {
                    CombatEngine.combatStateChanges.sendcli = f2.life;
                }
                if (f2.stamina != origf2stamina) {
                    CombatEngine.combatStateChanges.sendcst = f2.stamina;
                }
                if (f2.balance != origf2balance) {
                    CombatEngine.combatStateChanges.sendcba = f2.balance;
                }
                if (f2.surge != origf2surge) {
                    CombatEngine.combatStateChanges.sendcsu = f2.surge;
                }
            } else {
                if (f1.life != origf1life) {
                    CombatEngine.combatStateChanges.sendcli = f1.life;
                }
                if (f1.stamina != origf1stamina) {
                    CombatEngine.combatStateChanges.sendcst = f1.stamina;
                }
                if (f1.balance != origf1balance) {
                    CombatEngine.combatStateChanges.sendcba = f1.balance;
                }
                if (f1.surge != origf1surge) {
                    CombatEngine.combatStateChanges.sendcsu = f1.surge;
                }
                if (f2.life != origf2life) {
                    CombatEngine.combatStateChanges.sendhli = f2.life;
                }
                if (f2.stamina != origf2stamina) {
                    CombatEngine.combatStateChanges.sendhst = f2.stamina;
                }
                if (f2.balance != origf2balance) {
                    CombatEngine.combatStateChanges.sendhba = f2.balance;
                }
                if (f2.surge != origf2surge) {
                    CombatEngine.combatStateChanges.sendhsu = f2.surge;
                }
            }
            recoverCounter %= 100L;
        }
    }

    public static String useSurge(Fighter fighter) {
        String result = "";
        result = (CombatEngine.combatState.stage.equalsIgnoreCase("start") || CombatEngine.combatState.stage.equalsIgnoreCase("chain") || CombatEngine.combatState.stage.equalsIgnoreCase("risposte")) && CombatEngine.getEffectValue(fighter, "surge:attack", "suract", "strain", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 683) / 10) != 0.0f ? "strain" : (CombatEngine.combatState.stage.equalsIgnoreCase("hit") && CombatEngine.getEffectValue(fighter, "surge:hit", "suract", "pierce", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 113) / 10) != 0.0f ? "pierce" : (CombatEngine.combatState.stage.equalsIgnoreCase("miss-dodge") && CombatEngine.getEffectValue(fighter, "surge:dodge", "suract", "press", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 461) / 10) != 0.0f ? "press" : (CombatEngine.combatState.stage.equalsIgnoreCase("miss-parry") && CombatEngine.getEffectValue(fighter, "surge:parry", "suract", "brink", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 827) / 10) != 0.0f ? "brink" : (CombatEngine.combatState.stage.equalsIgnoreCase("hit") && CombatEngine.getEffectValue(fighter, "surge:damage", "suract", "barrie", CombatEngine.derivedRandomNumber(CombatEngine.combatState.randomNumber, 719) / 10) != 0.0f ? "barrie" : "default"))));
        return result;
    }

    public static void applySurge(Fighter fighter, String type, long combatTime) {
        StringBuilder activeLog;
        StringBuilder stringBuilder = activeLog = fighter.isHost ? CombatEngine.combatState.hostLog : CombatEngine.combatState.clientLog;
        if (type.equalsIgnoreCase("default")) {
            fighter.stamina += 5000;
            CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, fighter.isHost ? "h:stamin:1" : "c:stamin:1", ",");
            if (fighter.stamina > fighter.maxStamina) {
                fighter.stamina = fighter.maxStamina;
            }
            if (fighter.isHost) {
                CombatEngine.combatStateChanges.sendhst = fighter.stamina;
            } else {
                CombatEngine.combatStateChanges.sendcst = fighter.stamina;
            }
            fighter.balance += 5000;
            CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, fighter.isHost ? "h:balanc:1" : "c:balanc:1", ",");
            if (fighter.balance > fighter.maxBalance) {
                fighter.balance = fighter.maxBalance;
            }
            if (fighter.isHost) {
                CombatEngine.combatStateChanges.sendhba = fighter.balance;
            } else {
                CombatEngine.combatStateChanges.sendcba = fighter.balance;
            }
            fighter.surge = (fighter.services.contains("potion") ? 2500 : 0) + (fighter.isPlayer && CombatEngine.game.gameMode.equalsIgnoreCase("tournament") && Tournament.getRewardStock(game, "concoction") > 0 ? Tournament.getRewardStock(game, "concoction") / 2 : 0);
            CombatEngine.combatStateChanges.highlights = CombatEngine.combatState.highlights = StringList.append(CombatEngine.combatState.highlights, fighter.isHost ? "h:surge:-1" : "c:surge:-1", ",");
        } else {
            Effect currBuff = CombatEngine.getEffect(fighter, null, "suract", type, 0);
            CombatEngine.addBuff(fighter, "surge", type, Long.parseLong(currBuff.time), combatTime, activeLog);
            fighter.surge = 9999;
        }
        if (fighter.isHost) {
            CombatEngine.combatStateChanges.sendhsu = fighter.surge;
            CombatEngine.combatState.hostSurgeType = type;
            CombatEngine.combatStateChanges.hostSurgeType = type;
        } else {
            CombatEngine.combatStateChanges.sendcsu = fighter.surge;
            CombatEngine.combatState.clientSurgeType = type;
            CombatEngine.combatStateChanges.clientSurgeType = type;
            CombatEngine.combatState.clientExceptionalEvent = type;
        }
        CombatEngine.addLogTrace(activeLog, "b;" + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.added") + " " + PropertiesReader.getMessage(CombatEngine.game.gameMessages, "common.surge"));
    }

    public static String getVulnerableDirection(int randomSeed) {
        if (randomSeed < 333) {
            return "middle";
        }
        if (randomSeed < 666) {
            return "right";
        }
        return "left";
    }

    public static String getCombatSound(String type) {
        String result = "dodnorm";
        if (type.startsWith("hit")) {
            if (CombatEngine.combatState.isUse.booleanValue()) {
                if (CombatEngine.combatState.getAttacker().services.contains("powder")) {
                    result = "powderhit";
                } else if (CombatEngine.combatState.getAttacker().services.contains("shard")) {
                    result = "shardhit";
                } else if (CombatEngine.combatState.getAttacker().services.contains("net")) {
                    result = "nethit";
                }
            } else {
                result = CombatEngine.stats("weapons").getJSONObject(CombatEngine.combatState.getAttacker().weapon.id).getString("soundHit");
                if (result.contains("-tier")) {
                    result = CombatEngine.combatState.getAttacker().weapon.tier.equalsIgnoreCase("iron") ? result.replace("-tier", "met") : result.replace("-tier", "nor");
                }
                if (type.equalsIgnoreCase("hitcri")) {
                    result = result.replace("nor", "cri");
                }
            }
        } else if (type.equalsIgnoreCase("miss")) {
            result = CombatEngine.stats("weapons").getJSONObject(CombatEngine.combatState.getAttacker().weapon.id).getString("soundMiss");
            if (result.contains("-tier")) {
                result = CombatEngine.combatState.getAttacker().weapon.tier.equalsIgnoreCase("iron") ? result.replace("-tier", "met") : result.replace("-tier", "nor");
            }
        } else if (type.equalsIgnoreCase("parry")) {
            result = CombatEngine.stats("weapons").getJSONObject(CombatEngine.combatState.getDefender().weapon.id).getString("soundParry");
            if (CombatEngine.combatState.getDefender().offHand != null) {
                result = CombatEngine.stats("weapons").getJSONObject(CombatEngine.combatState.getDefender().offHand.id).getString("soundParry");
            }
            if (result.contains("-tier")) {
                result = CombatEngine.combatState.getDefender().weapon.tier.equalsIgnoreCase("iron") ? result.replace("-tier", "met") : result.replace("-tier", "nor");
            }
        }
        return result;
    }

    public static String getEffectSound(String type) {
        String result = "";
        if (type.equalsIgnoreCase("exhaus")) {
            result = "exhaus";
        } else if (type.equalsIgnoreCase("bleed")) {
            result = "bleed";
        } else if (type.equalsIgnoreCase("stun")) {
            result = "stun";
        } else if (type.equalsIgnoreCase("weaken")) {
            result = "weaken";
        }
        return result;
    }

    private static JSONObject stats(String type) {
        return CombatEngine.game.stats.get(type);
    }

    private static int derivedRandomNumber(int randomNumber, int seed) {
        return (randomNumber + seed) % 1000;
    }

    static {
        attackerDeviation = 0;
        defenderDeviation = 0;
        damageReceived = 0;
        risposteStamina = 0;
        timePressureReduction = 0.75f;
        assaultPressureReduction = 0.25f;
        playerTimeMultiplier = 1.0f;
        selectedInput = "";
        recoverCounter = 0L;
        recoverMultiplier = 1.0f;
        damageMultiplier = 1.0f;
        scenario = "";
        scenarioLife = 0;
    }
}

