/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.actor;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.RepeatAction;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.SelectBoxFontScaling;
import com.calimasaga.slavepits.actor.TextFieldFontScaling;
import java.util.HashMap;

public class UIHelpers {
    public static SelectBoxFontScaling<String> createSelectBox(SlavePitsGame g, float width, float height, String style, float scaleChange) {
        SelectBoxFontScaling<String> sb = new SelectBoxFontScaling<String>(g.uiSkin.get(style, SelectBox.SelectBoxStyle.class));
        sb.setWidth(width);
        sb.setHeight(height);
        sb.selectBoxList.list.fontScale = sb.fontScale = height / 50.0f * scaleChange;
        sb.selectBoxList.list.layout();
        return sb;
    }

    public static TextFieldFontScaling createTextField(SlavePitsGame g, float width, float height, String style, float scaleChange) {
        TextFieldFontScaling t = new TextFieldFontScaling("", g.uiSkin.get(style, TextField.TextFieldStyle.class));
        t.setWidth(width);
        t.setHeight(height);
        t.fontScale = height / 50.0f * scaleChange;
        t.textHeight = t.getStyle().font.getCapHeight() * t.fontScale - t.getStyle().font.getDescent() * 2.0f;
        return t;
    }

    public static void fixLabelFontSize(Label label, float fontScale, float width, float height) {
        label.setFontScale(fontScale);
        label.invalidate();
        float sizeControl = 1.0f;
        while (width != 0.0f && label.getPrefWidth() >= width || height != 0.0f && label.getPrefHeight() >= height) {
            label.setFontScale(fontScale * (sizeControl -= 0.05f));
            label.invalidate();
        }
    }

    public static void fixSelectBoxFontSize(SelectBoxFontScaling sb, float width, float height) {
        float sizeControl = 1.0f;
        while ((width == 0.0f || sb.getPrefWidth() * sizeControl >= width) && (height == 0.0f || sb.getPrefHeight() * sizeControl >= height)) {
            sb.fontScale *= (sizeControl -= 0.05f);
            sb.selectBoxList.list.fontScale = sb.fontScale;
            sb.selectBoxList.list.layout();
        }
    }

    public static void portraitModeFixBackground(SlavePitsGame g, BaseActor background, String image, float width, float height, float x, float y) {
        if (g.portraitmode) {
            FileHandle file = Gdx.files.internal(image.replace(".jpg", "P.jpg").replace(".png", "P.png"));
            if (file == null || !file.exists()) {
                g.manager.load(image, Texture.class);
                g.manager.finishLoading();
                background.setTexture(g.manager.get(image, Texture.class), width * 16.0f / 9.0f, height);
                background.setPosition(x - (background.getWidth() - g.viewWidth.floatValue()) / 2.0f, y);
            } else {
                g.manager.load(image.replace(".jpg", "P.jpg").replace(".png", "P.png"), Texture.class);
                g.manager.finishLoading();
                background.setTexture(g.manager.get(image.replace(".jpg", "P.jpg").replace(".png", "P.png"), Texture.class), width, height);
                background.setPosition(x, y);
            }
        } else {
            g.manager.load(image, Texture.class);
            g.manager.finishLoading();
            background.setTexture(g.manager.get(image, Texture.class), width, height);
            background.setPosition(x, y);
        }
    }

    public static void portraitModeFixBackgroundDispose(SlavePitsGame g, String image) {
        if (g.portraitmode) {
            FileHandle file = Gdx.files.internal(image.replace(".jpg", "P.jpg").replace(".png", "P.png"));
            if (file == null || !file.exists()) {
                g.manager.unload(image);
            } else {
                g.manager.unload(image.replace(".jpg", "P.jpg").replace(".png", "P.png"));
            }
        } else {
            g.manager.unload(image);
        }
    }

    public static Float calcWidthProportion(SlavePitsGame g, float widthBase, float widthPortrait) {
        if (g.portraitmode) {
            return Float.valueOf(g.viewWidth.floatValue() * widthPortrait / 100.0f);
        }
        return Float.valueOf(g.viewWidth.floatValue() * widthBase / 100.0f);
    }

    public static Float calcHeightProportion(SlavePitsGame g, float heightBase, float heightPortrait) {
        if (g.portraitmode) {
            return Float.valueOf(g.viewHeight.floatValue() * heightPortrait / 100.0f);
        }
        return Float.valueOf(g.viewHeight.floatValue() * heightBase / 100.0f);
    }

    public static void hightlightUIElement(HashMap<BaseActor, String> highlights, BaseActor element, float duration, Color dest) {
        if (highlights.get(element) == null || Float.parseFloat(highlights.get(element).split(":")[1]) == 0.0f) {
            Color origColor = element.getColor();
            highlights.put(element, origColor.toString() + ":" + duration);
            RepeatAction highlight = Actions.repeat(-1, Actions.sequence((Action)Actions.color(dest, 0.25f), (Action)Actions.color(origColor, 0.25f)));
            element.addAction(highlight);
            element.highlightAction = highlight;
        }
    }

    public static void elapseHighlights(HashMap<BaseActor, String> highlights, float delta) {
        for (BaseActor currActor : highlights.keySet()) {
            String colorOrig = highlights.get(currActor).split(":")[0];
            float duration = Float.parseFloat(highlights.get(currActor).split(":")[1]);
            if (duration == 0.0f) continue;
            if (duration < delta) {
                highlights.put(currActor, colorOrig + ":" + 0.0f);
                currActor.removeAction(currActor.highlightAction);
                currActor.highlightAction = null;
                currActor.setColor(Color.valueOf(colorOrig));
                continue;
            }
            highlights.put(currActor, colorOrig + ":" + (duration - delta));
        }
    }

    public static Color hightlightColor(Actor element, int colorConst) {
        if (colorConst == 1) {
            return new Color(element.getColor()).add(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (colorConst == -1) {
            return new Color(element.getColor()).sub(1.0f, 1.0f, 1.0f, 0.0f);
        }
        return element.getColor();
    }
}

