/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.actor;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;

public class AnimatedActor
extends BaseActor {
    public float elapsedTime;
    public float delayTime;
    public float visibleTime;
    public Animation<TextureRegion> anim;

    public AnimatedActor(SlavePitsGame game, String atlasName, String regionName, Integer numFrames, float width, float height, boolean reversed) {
        int n;
        this.setWidth(width);
        this.setHeight(height);
        TextureAtlas atlas = game.manager.get(atlasName, TextureAtlas.class);
        TextureRegion[] frames = new TextureRegion[numFrames.intValue()];
        if (reversed) {
            for (n = 0; n < numFrames; ++n) {
                frames[n] = atlas.findRegion(regionName + (numFrames - n - 1));
                frames[n].getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        } else {
            for (n = 0; n < numFrames; ++n) {
                frames[n] = atlas.findRegion(regionName + n);
                frames[n].getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        }
        Array<TextureRegion> framesArray = new Array<TextureRegion>(frames);
        this.anim = new Animation<TextureRegion>(0.1f, framesArray, Animation.PlayMode.LOOP);
        this.elapsedTime = 0.0f;
        this.visibleTime = 0.0f;
    }

    public void setAnimation(Animation<TextureRegion> a) {
        TextureRegion t = a.getKeyFrame(0.0f);
        this.setTexture(t.getTexture());
        this.anim = a;
    }

    public void playAnimation(float time, float frameDuration, float delay) {
        this.anim.setFrameDuration(frameDuration);
        this.visibleTime = time;
        this.delayTime = delay;
        this.elapsedTime = 0.0f;
    }

    @Override
    public void act(float dt) {
        super.act(dt);
        this.elapsedTime += dt;
        if (this.elapsedTime > this.delayTime) {
            if (this.elapsedTime > this.delayTime + this.visibleTime) {
                this.setVisible(false);
                this.elapsedTime = 0.0f;
                this.visibleTime = 0.0f;
                this.delayTime = 0.0f;
            } else {
                this.setVisible(true);
            }
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.elapsedTime > this.delayTime) {
            this.region.setRegion(this.anim.getKeyFrame(this.elapsedTime - this.delayTime));
            this.regionX = this.region.getRegionX();
            this.regionY = this.region.getRegionY();
            this.regionWidth = this.region.getRegionWidth();
            this.regionHeight = this.region.getRegionHeight();
            super.draw(batch, parentAlpha);
        }
    }
}

