/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.peer.FramePeer;
import java.security.AccessController;
import sun.awt.AWTAccessor;
import sun.awt.im.InputMethodManager;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;
import sun.security.action.GetPropertyAction;

class WFramePeer
extends WWindowPeer
implements FramePeer {
    private static final boolean keepOnMinimize;

    private static native void initIDs();

    @Override
    public native void setState(int var1);

    @Override
    public native int getState();

    public void setExtendedState(int n) {
        AWTAccessor.getFrameAccessor().setExtendedState((Frame)this.target, n);
    }

    public int getExtendedState() {
        return AWTAccessor.getFrameAccessor().getExtendedState((Frame)this.target);
    }

    private native void setMaximizedBounds(int var1, int var2, int var3, int var4);

    private native void clearMaximizedBounds();

    @Override
    public void setMaximizedBounds(Rectangle rectangle) {
        if (rectangle == null) {
            this.clearMaximizedBounds();
        } else {
            Rectangle rectangle2 = (Rectangle)rectangle.clone();
            this.adjustMaximizedBounds(rectangle2);
            this.setMaximizedBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    private void adjustMaximizedBounds(Rectangle rectangle) {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration();
        if (graphicsConfiguration != null && graphicsConfiguration != graphicsConfiguration2) {
            boolean bl;
            Rectangle rectangle2 = graphicsConfiguration.getBounds();
            Rectangle rectangle3 = graphicsConfiguration2.getBounds();
            boolean bl2 = bl = rectangle2.width - rectangle3.width > 0 || rectangle2.height - rectangle3.height > 0;
            if (bl) {
                rectangle.width -= rectangle2.width - rectangle3.width;
                rectangle.height -= rectangle2.height - rectangle3.height;
            }
        }
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration graphicsConfiguration) {
        boolean bl = super.updateGraphicsData(graphicsConfiguration);
        Rectangle rectangle = AWTAccessor.getFrameAccessor().getMaximizedBounds((Frame)this.target);
        if (rectangle != null) {
            this.setMaximizedBounds(rectangle);
        }
        return bl;
    }

    @Override
    boolean isTargetUndecorated() {
        return ((Frame)this.target).isUndecorated();
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        if (((Frame)this.target).isUndecorated()) {
            super.reshape(n, n2, n3, n4);
        } else {
            this.reshapeFrame(n, n2, n3, n4);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension();
        if (!((Frame)this.target).isUndecorated()) {
            dimension.setSize(WFramePeer.getSysMinWidth(), WFramePeer.getSysMinHeight());
        }
        if (((Frame)this.target).getMenuBar() != null) {
            dimension.height += WFramePeer.getSysMenuHeight();
        }
        return dimension;
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
        WMenuBarPeer wMenuBarPeer = (WMenuBarPeer)WToolkit.targetToPeer(menuBar);
        this.setMenuBar0(wMenuBarPeer);
        this.updateInsets(this.insets_);
    }

    private native void setMenuBar0(WMenuBarPeer var1);

    WFramePeer(Frame frame) {
        super(frame);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
    }

    native void createAwtFrame(WComponentPeer var1);

    @Override
    void create(WComponentPeer wComponentPeer) {
        this.preCreate(wComponentPeer);
        this.createAwtFrame(wComponentPeer);
    }

    @Override
    void initialize() {
        super.initialize();
        Frame frame = (Frame)this.target;
        if (frame.getTitle() != null) {
            this.setTitle(frame.getTitle());
        }
        this.setResizable(frame.isResizable());
        this.setState(frame.getExtendedState());
    }

    private static native int getSysMenuHeight();

    native void pSetIMMOption(String var1);

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest((Component)this.target);
    }

    @Override
    public void setBoundsPrivate(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, 3);
    }

    @Override
    public Rectangle getBoundsPrivate() {
        return this.getBounds();
    }

    static {
        WFramePeer.initIDs();
        keepOnMinimize = "true".equals(AccessController.doPrivileged(new GetPropertyAction("sun.awt.keepWorkingSetOnMinimize")));
    }
}

