#ifdef GL_ES
   precision mediump float;
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform mat4 u_projTrans;

void main() {
   vec4 textcolor = texture2D(u_texture, v_texCoords);
   float gray = (textcolor.r * v_color.r  + textcolor.g * v_color.g + textcolor.b * v_color.b) / 3.0;

   gl_FragColor = vec4(gray, gray, gray, textcolor.a * v_color.a);
}
