/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.sun.nio.sctp.IllegalUnbindException;
import com.sun.nio.sctp.SctpChannel;
import com.sun.nio.sctp.SctpServerChannel;
import com.sun.nio.sctp.SctpSocketOption;
import com.sun.nio.sctp.SctpStandardSocketOptions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SctpChannelImpl;
import sun.nio.ch.SctpNet;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;
import sun.security.action.LoadLibraryAction;

public class SctpServerChannelImpl
extends SctpServerChannel
implements SelChImpl {
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long thread = 0L;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    private ChannelState state = ChannelState.UNINITIALIZED;
    int port = -1;
    private HashSet<InetSocketAddress> localAddresses = new HashSet();
    private boolean wildcard;

    public SctpServerChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = SctpNet.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = ChannelState.INUSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpServerChannel bind(SocketAddress socketAddress, int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.stateLock;
            synchronized (object2) {
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                if (this.isBound()) {
                    SctpNet.throwAlreadyBoundException();
                }
                InetSocketAddress inetSocketAddress = socketAddress == null ? new InetSocketAddress(0) : Net.checkAddress(socketAddress);
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkListen(inetSocketAddress.getPort());
                }
                Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                InetSocketAddress inetSocketAddress2 = Net.localAddress(this.fd);
                this.port = inetSocketAddress2.getPort();
                this.localAddresses.add(inetSocketAddress);
                if (inetSocketAddress.getAddress().isAnyLocalAddress()) {
                    this.wildcard = true;
                }
                SctpNet.listen(this.fdVal, n < 1 ? 50 : n);
            }
        }
        return this;
    }

    @Override
    public SctpServerChannel bindAddress(InetAddress inetAddress) throws IOException {
        return this.bindUnbindAddress(inetAddress, true);
    }

    @Override
    public SctpServerChannel unbindAddress(InetAddress inetAddress) throws IOException {
        return this.bindUnbindAddress(inetAddress, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SctpServerChannel bindUnbindAddress(InetAddress inetAddress, boolean bl) throws IOException {
        if (inetAddress == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.stateLock;
            synchronized (object2) {
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                if (!this.isBound()) {
                    throw new NotYetBoundException();
                }
                if (this.wildcard) {
                    throw new IllegalStateException("Cannot add or remove addresses from a channel that is bound to the wildcard address");
                }
                if (inetAddress.isAnyLocalAddress()) {
                    throw new IllegalArgumentException("Cannot add or remove the wildcard address");
                }
                if (bl) {
                    for (InetSocketAddress object3 : this.localAddresses) {
                        if (!object3.getAddress().equals(inetAddress)) continue;
                        SctpNet.throwAlreadyBoundException();
                    }
                } else {
                    if (this.localAddresses.size() <= 1) {
                        throw new IllegalUnbindException("Cannot remove address from a channel with only one address bound");
                    }
                    boolean bl2 = false;
                    for (InetSocketAddress inetSocketAddress : this.localAddresses) {
                        if (!inetSocketAddress.getAddress().equals(inetAddress)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        throw new IllegalUnbindException("Cannot remove address from a channel that is not bound to that address");
                    }
                }
                SctpNet.bindx(this.fdVal, new InetAddress[]{inetAddress}, this.port, bl);
                if (bl) {
                    this.localAddresses.add(new InetSocketAddress(inetAddress, this.port));
                } else {
                    for (InetSocketAddress inetSocketAddress : this.localAddresses) {
                        if (!inetSocketAddress.getAddress().equals(inetAddress)) continue;
                        this.localAddresses.remove(inetSocketAddress);
                        break;
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.port != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.thread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SctpChannel accept() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            InetSocketAddress[] inetSocketAddressArray;
            FileDescriptor fileDescriptor;
            int n;
            SctpChannelImpl sctpChannelImpl;
            block13: {
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                if (!this.isBound()) {
                    throw new NotYetBoundException();
                }
                sctpChannelImpl = null;
                n = 0;
                fileDescriptor = new FileDescriptor();
                inetSocketAddressArray = new InetSocketAddress[1];
                this.begin();
                if (this.isOpen()) break block13;
                SctpChannel sctpChannel = null;
                this.acceptCleanup();
                this.end(n > 0);
                assert (IOStatus.check(n));
                return sctpChannel;
            }
            try {
                this.thread = NativeThread.current();
                while ((n = SctpServerChannelImpl.accept0(this.fd, fileDescriptor, inetSocketAddressArray)) == -3 && this.isOpen()) {
                }
            }
            catch (Throwable throwable) {
                this.acceptCleanup();
                this.end(n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            this.acceptCleanup();
            this.end(n > 0);
            assert (IOStatus.check(n));
            if (n < 1) {
                return null;
            }
            IOUtil.configureBlocking(fileDescriptor, true);
            InetSocketAddress inetSocketAddress = inetSocketAddressArray[0];
            sctpChannelImpl = new SctpChannelImpl(this.provider(), fileDescriptor);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkAccept(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
            }
            return sctpChannelImpl;
        }
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            SctpNet.preClose(this.fdVal);
            if (this.thread != 0L) {
                NativeThread.signal(this.thread);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == ChannelState.KILLED) {
                return;
            }
            if (this.state == ChannelState.UNINITIALIZED) {
                this.state = ChannelState.KILLED;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.thread == 0L) {
                SctpNet.close(this.fdVal);
                this.state = ChannelState.KILLED;
            } else {
                this.state = ChannelState.KILLPENDING;
            }
        }
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    private boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & 0x20) != 0) {
            return false;
        }
        if ((n & 0x18) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            return (n5 & ~n4) != 0;
        }
        if ((n & 1) != 0 && (n3 & 0x10) != 0) {
            n5 |= 0x10;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 0x10) != 0) {
            n2 |= 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SctpServerChannel setOption(SctpSocketOption<T> sctpSocketOption, T t) throws IOException {
        if (sctpSocketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(sctpSocketOption)) {
            throw new UnsupportedOperationException("'" + sctpSocketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            SctpNet.setSocketOption(this.fdVal, sctpSocketOption, t, 0);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SctpSocketOption<T> sctpSocketOption) throws IOException {
        if (sctpSocketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(sctpSocketOption)) {
            throw new UnsupportedOperationException("'" + sctpSocketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return (T)SctpNet.getSocketOption(this.fdVal, sctpSocketOption, 0);
        }
    }

    @Override
    public final Set<SctpSocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getAllLocalAddresses() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isBound()) {
                return Collections.EMPTY_SET;
            }
            return SctpNet.getLocalAddresses(this.fdVal);
        }
    }

    private static native void initIDs();

    private static native int accept0(FileDescriptor var0, FileDescriptor var1, InetSocketAddress[] var2) throws IOException;

    static {
        Util.load();
        AccessController.doPrivileged(new LoadLibraryAction("sctp"));
        SctpServerChannelImpl.initIDs();
    }

    private static class DefaultOptionsHolder {
        static final Set<SctpSocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SctpSocketOption<?>> defaultOptions() {
            HashSet<SctpSocketOption<SctpStandardSocketOptions.InitMaxStreams>> hashSet = new HashSet<SctpSocketOption<SctpStandardSocketOptions.InitMaxStreams>>(1);
            hashSet.add(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS);
            return Collections.unmodifiableSet(hashSet);
        }
    }

    private static enum ChannelState {
        UNINITIALIZED,
        INUSE,
        KILLPENDING,
        KILLED;

    }
}

