/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class StringList {
    private static String delimiterList = "-:;#&$@|";

    public static StringBuilder create(String stringList, String delimiter) {
        return new StringBuilder(stringList == null ? "" : stringList);
    }

    public static String getNewDelimiter(StringBuilder stringList) {
        if (stringList == null || stringList.length() == 0) {
            return delimiterList.substring(0, 1);
        }
        for (int i = 0; i < delimiterList.length(); ++i) {
            if (stringList.indexOf(delimiterList.substring(i, i + 1)) >= 0) continue;
            return delimiterList.substring(i, i + 1);
        }
        return "";
    }

    public static int size(StringBuilder stringList, String delimiter) {
        return stringList != null && !stringList.toString().equals("") ? StringUtils.countMatches(stringList.toString(), delimiter) + 1 : 0;
    }

    public static StringBuilder append(StringBuilder stringList, String element, String delimiter) {
        if (stringList == null) {
            stringList = new StringBuilder();
        } else if (stringList.length() > 0) {
            stringList.append(delimiter);
        }
        stringList.append(element);
        return stringList;
    }

    public static String get(StringBuilder stringList, int position, String delimiter) {
        int sizeList = StringList.size(stringList, delimiter);
        if (sizeList == 0 || sizeList <= position || position < 0) {
            return "";
        }
        if (sizeList == 1 && position == 0) {
            return stringList.toString();
        }
        if (sizeList - 1 == position) {
            int startPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, position);
            return stringList.substring(startPosition + delimiter.length(), stringList.length());
        }
        if (position == 0) {
            int endPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, 1);
            return stringList.substring(0, endPosition);
        }
        int startPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, position);
        int endPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, position + 1);
        return stringList.substring(startPosition + delimiter.length(), endPosition);
    }

    public static StringBuilder set(StringBuilder stringList, int position, String element, String delimiter) {
        if (position < 0) {
            return stringList;
        }
        int sizeList = StringList.size(stringList, delimiter);
        if (sizeList == 0 || sizeList <= position) {
            return StringList.append(stringList, element, delimiter);
        }
        if (sizeList == 1 && position == 0) {
            return new StringBuilder(element);
        }
        if (sizeList - 1 == position) {
            int startPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, position);
            return new StringBuilder(stringList.substring(0, startPosition + delimiter.length())).append(element);
        }
        if (position == 0) {
            int endPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, 1);
            return new StringBuilder().append(element).append(stringList.substring(endPosition, stringList.length()));
        }
        int startPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, position);
        int endPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, position + 1);
        return new StringBuilder().append(stringList.substring(0, startPosition + delimiter.length())).append(element).append(stringList.substring(endPosition, stringList.length()));
    }

    public static StringBuilder insert(StringBuilder stringList, int position, String element, String delimiter) {
        if (position < 0) {
            return stringList;
        }
        int sizeList = StringList.size(stringList, delimiter);
        if (sizeList == 0 || sizeList <= position) {
            return StringList.append(stringList, element, delimiter);
        }
        if (position == 0) {
            return stringList.insert(0, element + delimiter);
        }
        int startPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, position);
        return stringList.insert(startPosition + delimiter.length(), element + delimiter);
    }

    public static StringBuilder remove(StringBuilder stringList, int position, String delimiter) {
        if (position < 0) {
            return stringList;
        }
        int sizeList = StringList.size(stringList, delimiter);
        if (sizeList == 0 || sizeList <= position) {
            return stringList;
        }
        if (sizeList == 1 && position == 0) {
            return new StringBuilder();
        }
        if (sizeList - 1 == position) {
            int startPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, position);
            return new StringBuilder(stringList.substring(0, startPosition));
        }
        if (position == 0) {
            int endPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, 1);
            return new StringBuilder(stringList.substring(endPosition + delimiter.length(), stringList.length()));
        }
        int startPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, position);
        int endPosition = StringUtils.ordinalIndexOf(stringList.toString(), delimiter, position + 1);
        return new StringBuilder().append(stringList.substring(0, startPosition)).append(stringList.substring(endPosition, stringList.length()));
    }

    public static int indexOf(StringBuilder stringList, String element, int fromIndex, String delimiter) {
        int result = -1;
        if (stringList != null && !stringList.toString().equals("")) {
            StringBuilder searchElement = new StringBuilder().append(delimiter).append(element).append(delimiter);
            result = stringList.indexOf(searchElement.toString(), fromIndex);
            if (result < 0) {
                searchElement = new StringBuilder().append(delimiter).append(element);
                result = stringList.indexOf(searchElement.toString(), fromIndex);
                int n = result = result >= stringList.lastIndexOf(delimiter) ? result : -1;
                result = result < 0 ? ((result = stringList.indexOf(element, fromIndex)) == 0 ? result : -1) : (result += delimiter.length());
            } else {
                result += delimiter.length();
            }
        }
        return result;
    }

    public static int lastIndexOf(StringBuilder stringList, String element, String delimiter) {
        int result = -1;
        if (stringList != null && !stringList.toString().equals("")) {
            StringBuilder searchElement = new StringBuilder().append(delimiter).append(element).append(delimiter);
            result = stringList.lastIndexOf(searchElement.toString());
            if (result < 0) {
                searchElement = new StringBuilder().append(delimiter).append(element);
                result = stringList.lastIndexOf(searchElement.toString());
                int n = result = result >= stringList.lastIndexOf(delimiter) ? result : -1;
                result = result < 0 ? ((result = stringList.lastIndexOf(element)) == 0 ? result : -1) : (result += delimiter.length());
            } else {
                result += delimiter.length();
            }
        }
        return result;
    }

    public static int getPosition(StringBuilder stringList, String element, String delimiter) {
        int result = StringList.indexOf(stringList, element, 0, delimiter);
        if (result >= 0) {
            result = StringList.size(stringList, delimiter) - StringUtils.countMatches(stringList.substring(result), delimiter) - 1;
        }
        return result;
    }

    public static StringBuilder listToStringList(List<String> list, String delimiter) {
        return new StringBuilder(StringUtils.join(list, delimiter));
    }

    public static ArrayList<String> stringListToList(StringBuilder stringList, String delimiter) {
        return new ArrayList<String>(Arrays.asList(stringList.toString().split(delimiter)));
    }
}

