/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.RepeatAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.SelectBoxFontScaling;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.EquipmentMenuScreen;
import com.calimasaga.slavepits.screen.GameMenuScreen;
import com.calimasaga.slavepits.screen.LexiconScreen;
import com.calimasaga.slavepits.screen.PortraitsMenuScreen;
import com.calimasaga.slavepits.screen.ServicesMenuScreen;
import com.calimasaga.slavepits.screen.TalentsMenuScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import com.calimasaga.slavepits.util.StringList;
import java.util.ArrayList;
import java.util.Arrays;

public class TournamentGameScreen
extends BaseScreen {
    NinePatchActor charBackground;
    public ArrayList<Stack> characters = new ArrayList();
    public ArrayList<Fighter> charactersFighters = new ArrayList();
    public ArrayList<String> charactersNames = new ArrayList();
    private int indexCharacter = 0;
    private Button equipment;
    private Button talents;
    private Button services;
    private Button nextCharacter;
    private Button previousCharacter;
    private Button continueButton;
    public ScrollPane charTextBackground;
    public Label selectedChar;
    public Label charText;
    public Label itemInfo;
    public Label statsLabel;
    public Label reputationLabel;
    public Label profitsLabel;
    public BaseActor portraitImage;
    public SelectBoxFontScaling<String> difficulty;
    public Button infoButton;
    public Fighter fighter;
    public BaseActor overlay;
    public NinePatchActor tooltipBackground;
    public Label tooltipLabel;
    public Button cancelInfoButton;

    public TournamentGameScreen(SlavePitsGame g) {
        super(g);
        this.create();
    }

    @Override
    public void create() {
        this.charactersNames = new ArrayList<String>(Arrays.asList(Tournament.getCharacterList(this.game).split(";")));
        this.charBackground = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.charBackground.setWidth(UIHelpers.calcWidthProportion(this.game, 98.0f, 98.0f).floatValue());
        this.charBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 48.0f, 48.0f).floatValue());
        this.charBackground.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.charBackground.getWidth() / 2.0f);
        this.charBackground.setY(UIHelpers.calcHeightProportion(this.game, 97.0f, 97.0f).floatValue() - this.charBackground.getHeight());
        this.stage.addActor(this.charBackground);
        this.charText = new Label("", this.game.uiSkin, "default");
        this.charText.setAlignment(10);
        this.charText.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.charText.setWrap(true);
        this.charText.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.charText.setWidth(UIHelpers.calcWidthProportion(this.game, 90.0f, 90.0f).floatValue());
        this.stage.addActor(this.charText);
        this.charTextBackground = new ScrollPane((Actor)this.charText, this.game.uiSkin, "chat");
        this.charTextBackground.setForceScroll(true, true);
        this.charTextBackground.setFlickScroll(false);
        this.charTextBackground.setOverscroll(false, true);
        this.charTextBackground.setWidth(UIHelpers.calcWidthProportion(this.game, 98.0f, 98.0f).floatValue());
        this.charTextBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 23.0f, 23.0f).floatValue());
        this.charTextBackground.setX(UIHelpers.calcWidthProportion(this.game, 1.0f, 1.0f).floatValue());
        this.charTextBackground.setY(this.charBackground.getY() - this.charTextBackground.getHeight());
        this.charTextBackground.getStyle().vScroll.setMinWidth(UIHelpers.calcHeightProportion(this.game, 2.55f, 2.55f).floatValue());
        this.charTextBackground.getStyle().vScrollKnob.setMinWidth(UIHelpers.calcHeightProportion(this.game, 2.55f, 2.55f).floatValue());
        this.stage.addActor(this.charTextBackground);
        this.charTextBackground.layout();
        this.charTextBackground.setVisible(true);
        this.charTextBackground.addListener(new InputListener(){

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                TournamentGameScreen.this.stage.setScrollFocus(null);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                TournamentGameScreen.this.stage.setScrollFocus(event.getListenerActor());
            }
        });
        this.charTextBackground.setForceScroll(false, true);
        this.charTextBackground.setFlickScroll(false);
        this.charTextBackground.setOverscroll(false, true);
        this.stage.addActor(this.charTextBackground);
        NinePatchActor statsBackground = new NinePatchActor(this.game.uiSkin.get("scrollpanel", NinePatch.class));
        statsBackground.setWidth(UIHelpers.calcWidthProportion(this.game, 48.0f, 98.0f).floatValue());
        statsBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 25.0f, 25.0f).floatValue());
        statsBackground.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - statsBackground.getWidth() / 2.0f);
        statsBackground.setY(this.charTextBackground.getY() - statsBackground.getHeight());
        this.stage.addActor(statsBackground);
        this.selectedChar = new Label("Char Name", this.game.uiSkin, "default");
        this.selectedChar.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.selectedChar.setAlignment(1);
        this.selectedChar.setVisible(true);
        this.selectedChar.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.selectedChar.setWidth(this.charBackground.getWidth());
        this.selectedChar.setX(this.charBackground.getX());
        this.selectedChar.setY(this.charBackground.getY() + this.charBackground.getHeight() * 90.0f / 100.0f - this.selectedChar.getPrefHeight() / 2.0f);
        this.stage.addActor(this.selectedChar);
        int iChar = 1;
        for (String currCharacter : this.charactersNames) {
            Fighter currFighter = Fighter.createOpponent(this.game, currCharacter, 1000, true);
            Fighter.loadFighterAssets(this.game, currFighter, true, true);
            Stack fighterCharacter = new Stack();
            fighterCharacter.sizeBy(this.charBackground.getHeight() * 75.0f / 100.0f, this.charBackground.getHeight() * 75.0f / 100.0f);
            BaseActor fighterSkin = new BaseActor();
            fighterSkin.params.put("type", "skin");
            fighterCharacter.add(fighterSkin);
            BaseActor fighterBody = new BaseActor();
            fighterBody.params.put("type", "body");
            fighterCharacter.add(fighterBody);
            BaseActor fighterBodyArmorL = new BaseActor();
            fighterBodyArmorL.params.put("type", "bodyArmorL");
            fighterCharacter.add(fighterBodyArmorL);
            BaseActor fighterBodyArmorT = new BaseActor();
            fighterBodyArmorT.params.put("type", "bodyArmorT");
            fighterCharacter.add(fighterBodyArmorT);
            BaseActor fighterHead = new BaseActor();
            fighterHead.params.put("type", "head");
            fighterCharacter.add(fighterHead);
            ArrayList<BaseActor> fighterAccessories = new ArrayList<BaseActor>();
            for (int i = 0; i < 5; ++i) {
                BaseActor accessory = new BaseActor();
                accessory.params.put("type", "accessory");
                accessory.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                fighterAccessories.add(accessory);
                fighterCharacter.add(accessory);
            }
            BaseActor fighterArms = new BaseActor();
            fighterArms.params.put("type", "arms");
            fighterCharacter.add(fighterArms);
            BaseActor fighterArmsArmorSL = new BaseActor();
            fighterArmsArmorSL.params.put("type", "armsArmorSL");
            fighterCharacter.add(fighterArmsArmorSL);
            BaseActor fighterArmsArmorSPL = new BaseActor();
            fighterArmsArmorSPL.params.put("type", "armsArmorSPL");
            fighterCharacter.add(fighterArmsArmorSPL);
            BaseActor fighterArmsArmorSPR = new BaseActor();
            fighterArmsArmorSPR.params.put("type", "armsArmorSPR");
            fighterCharacter.add(fighterArmsArmorSPR);
            BaseActor fighterArmsArmorBRL = new BaseActor();
            fighterArmsArmorBRL.params.put("type", "armsArmorBRL");
            fighterCharacter.add(fighterArmsArmorBRL);
            BaseActor fighterArmsArmorBRR = new BaseActor();
            fighterArmsArmorBRR.params.put("type", "armsArmorBRR");
            fighterCharacter.add(fighterArmsArmorBRR);
            BaseActor fighterSkinExtra = new BaseActor();
            fighterSkinExtra.params.put("type", "skinExtra");
            fighterCharacter.add(fighterSkinExtra);
            BaseActor fighterBodyExtra = new BaseActor();
            fighterBodyExtra.params.put("type", "bodyExtra");
            fighterCharacter.add(fighterBodyExtra);
            BaseActor fighterBodyArmorTExtra = new BaseActor();
            fighterBodyArmorTExtra.params.put("type", "bodyArmorTExtra");
            fighterCharacter.add(fighterBodyArmorTExtra);
            BaseActor fighterWeapon = new BaseActor();
            fighterWeapon.params.put("type", "weapon");
            fighterCharacter.add(fighterWeapon);
            BaseActor fighterOffHand = new BaseActor();
            fighterOffHand.params.put("type", "offHand");
            fighterCharacter.add(fighterOffHand);
            fighterCharacter.setTransform(true);
            if (this.game.portraitmode) {
                fighterCharacter.setX(this.charBackground.getX() + this.charBackground.getWidth() * (float)iChar / 2.0f - fighterCharacter.getWidth() / 2.0f);
            } else {
                fighterCharacter.setX(this.charBackground.getX() + this.charBackground.getWidth() / 2.0f + this.charBackground.getWidth() / 4.0f * (float)(iChar - 1) - fighterCharacter.getWidth() / 2.0f);
            }
            fighterCharacter.setY(this.charBackground.getY() + this.charBackground.getHeight() * 4.0f / 100.0f);
            this.stage.addActor(fighterCharacter);
            String suffix = "idle";
            String direction = "right";
            String weaponType = this.game.stats.get("weapons").getJSONObject(currFighter.weapon.id).getString("type");
            if (weaponType.equalsIgnoreCase("2h3")) {
                weaponType = "2h1";
            }
            fighterSkin.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + currFighter.skinType + currFighter.bodySubType + "skin.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            fighterSkin.setColor(Color.valueOf(currFighter.skinColor));
            fighterBody.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + currFighter.bodyType + currFighter.bodySubType + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            fighterBody.setColor(Color.valueOf(currFighter.bodyColor));
            if (currFighter.head != null && !currFighter.special.contains("nohel")) {
                fighterHead.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + currFighter.headType + currFighter.portrait + this.game.stats.get("tiers").getJSONObject(currFighter.head.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            } else {
                fighterHead.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + currFighter.headType + currFighter.portrait + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            }
            for (int i = 0; i < fighterAccessories.size(); ++i) {
                ((BaseActor)fighterAccessories.get(i)).setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            }
            StringBuilder chosenAccessories = StringList.create(currFighter.accessoryTypes, ":");
            for (int i = 0; i < StringList.size(chosenAccessories, ":"); ++i) {
                ((BaseActor)fighterAccessories.get(i)).setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/bodycomp" + currFighter.bodyType + "" + currFighter.bodySubType + StringList.get(chosenAccessories, i, ":") + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                ((BaseActor)fighterAccessories.get(i)).setColor(Color.valueOf(currFighter.accessoryColor));
            }
            fighterArms.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/arms" + weaponType + suffix + currFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            fighterArms.setColor(Color.valueOf(currFighter.skinColor));
            if (currFighter.arms != null && !currFighter.special.contains("noarmsarmor")) {
                if (!currFighter.special.contains("noaasl")) {
                    fighterArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmssl" + weaponType + suffix + currFighter.armsType + this.game.stats.get("tiers").getJSONObject(currFighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                } else {
                    fighterArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                }
                if (!currFighter.special.contains("noaabra") && !currFighter.special.contains("noaabrl")) {
                    fighterArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsbrl" + weaponType + suffix + currFighter.armsType + this.game.stats.get("tiers").getJSONObject(currFighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                } else {
                    fighterArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                }
                if (!currFighter.special.contains("noaabra") && !currFighter.special.contains("noaabrr")) {
                    fighterArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsbrr" + weaponType + suffix + currFighter.armsType + this.game.stats.get("tiers").getJSONObject(currFighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                } else {
                    fighterArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                }
                if (!currFighter.special.contains("noaaspa") && !currFighter.special.contains("noaaspl")) {
                    fighterArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsspl" + weaponType + suffix + currFighter.armsType + this.game.stats.get("tiers").getJSONObject(currFighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                } else {
                    fighterArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                }
                if (!currFighter.special.contains("noaaspa") && !currFighter.special.contains("noaaspr")) {
                    fighterArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsspr" + weaponType + suffix + currFighter.armsType + this.game.stats.get("tiers").getJSONObject(currFighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                } else {
                    fighterArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                }
            } else {
                fighterArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                fighterArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                fighterArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                fighterArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                fighterArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            }
            if (currFighter.body != null) {
                if (!currFighter.special.contains("nocut")) {
                    fighterBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + currFighter.bodyType + currFighter.bodySubType + this.game.stats.get("tiers").getJSONObject(currFighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                } else {
                    fighterBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                }
                if (!currFighter.special.contains("nocul")) {
                    fighterBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyl" + currFighter.bodyType + currFighter.bodySubType + this.game.stats.get("tiers").getJSONObject(currFighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                } else {
                    fighterBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                }
            } else {
                fighterBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                fighterBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            }
            if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(currFighter.bodyType).getString("skinExtra"), ":"), "body" + currFighter.bodyType + currFighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
                fighterSkinExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + currFighter.bodyType + currFighter.bodySubType + "skin" + weaponType + suffix + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                fighterSkinExtra.setColor(Color.valueOf(currFighter.skinColor));
                if (currFighter.body != null && !currFighter.special.contains("nocut")) {
                    fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + currFighter.bodyType + weaponType + suffix + this.game.stats.get("tiers").getJSONObject(currFighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                } else {
                    fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                }
            } else {
                fighterSkinExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            }
            if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(currFighter.bodyType).getString("bodyExtra"), ":"), "body" + currFighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
                fighterBodyExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + currFighter.bodyType + weaponType + suffix + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                fighterBodyExtra.setColor(Color.valueOf(currFighter.bodyColor));
                if (currFighter.body != null && !currFighter.special.contains("nocut")) {
                    fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + currFighter.bodyType + weaponType + suffix + this.game.stats.get("tiers").getJSONObject(currFighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                } else {
                    fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                }
            } else {
                fighterBodyExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
                fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            }
            if (currFighter.offHand != null) {
                fighterOffHand.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + currFighter.offHand.id + this.game.stats.get("tiers").getJSONObject(currFighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + currFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            } else {
                fighterOffHand.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            }
            fighterWeapon.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + currFighter.weapon.id + this.game.stats.get("tiers").getJSONObject(currFighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + currFighter.armsType + ".png"), Texture.class), (float)Float.valueOf(fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(fighterCharacter.getHeight()).intValue());
            fighterCharacter.clearActions();
            fighterCharacter.setScale(Float.parseFloat(currFighter.size), Float.parseFloat(currFighter.size));
            RepeatAction idleMotion = new RepeatAction();
            idleMotion.setAction(Actions.sequence((Action)Actions.scaleTo(Float.parseFloat(currFighter.size), Float.parseFloat(currFighter.size) + 0.005f, 1.5f), (Action)Actions.scaleTo(Float.parseFloat(currFighter.size), Float.parseFloat(currFighter.size), 1.5f)));
            idleMotion.setCount(-1);
            fighterCharacter.addAction(idleMotion);
            if (iChar > 1) {
                for (Actor currActorPart : fighterCharacter.getChildren()) {
                    currActorPart.setColor(0.0f, 0.0f, 0.0f, 1.0f);
                }
                if (this.game.portraitmode || iChar > 2) {
                    fighterCharacter.setVisible(false);
                }
            } else {
                this.fighter = Fighter.clone(currFighter, false);
            }
            this.charactersFighters.add(currFighter);
            this.characters.add(fighterCharacter);
            ++iChar;
        }
        this.previousCharacter = new Button(this.game.uiSkin, "next");
        this.previousCharacter.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                block9: {
                    if (PropertiesReader.verifyKey(TournamentGameScreen.this.game.mail, TournamentGameScreen.this.game.key, TournamentGameScreen.this.game.checksum).equalsIgnoreCase("free") || TournamentGameScreen.this.indexCharacter <= 0) break block9;
                    TournamentGameScreen.this.indexCharacter = TournamentGameScreen.this.indexCharacter - 1;
                    TournamentGameScreen.this.loadCharacter();
                    TournamentGameScreen.this.nextCharacter.setVisible(true);
                    if (TournamentGameScreen.this.indexCharacter == 0) {
                        TournamentGameScreen.this.previousCharacter.setVisible(false);
                    }
                    if (TournamentGameScreen.this.game.portraitmode) {
                        for (int i = 0; i < TournamentGameScreen.this.characters.size(); ++i) {
                            TournamentGameScreen.this.characters.get(i).setX(TournamentGameScreen.this.characters.get(i).getX() + TournamentGameScreen.this.charBackground.getWidth() / 2.0f);
                            if (i != TournamentGameScreen.this.indexCharacter) {
                                for (Actor currActorPart : TournamentGameScreen.this.characters.get(i).getChildren()) {
                                    currActorPart.setColor(0.0f, 0.0f, 0.0f, 1.0f);
                                }
                                TournamentGameScreen.this.characters.get(i).setVisible(false);
                                continue;
                            }
                            TournamentGameScreen.this.characters.get(i).setVisible(true);
                        }
                    } else {
                        for (int i = 0; i < TournamentGameScreen.this.characters.size(); ++i) {
                            TournamentGameScreen.this.characters.get(i).setX(TournamentGameScreen.this.characters.get(i).getX() + TournamentGameScreen.this.charBackground.getWidth() * 25.0f / 100.0f);
                            if (i != TournamentGameScreen.this.indexCharacter) {
                                for (Actor currActorPart : TournamentGameScreen.this.characters.get(i).getChildren()) {
                                    currActorPart.setColor(0.0f, 0.0f, 0.0f, 1.0f);
                                }
                                TournamentGameScreen.this.characters.get(i).setVisible(i == TournamentGameScreen.this.indexCharacter - 1 || i == TournamentGameScreen.this.indexCharacter + 1);
                                continue;
                            }
                            TournamentGameScreen.this.characters.get(i).setVisible(true);
                        }
                    }
                }
            }
        });
        this.previousCharacter.setTransform(true);
        this.previousCharacter.rotateBy(180.0f);
        this.previousCharacter.setOrigin(this.previousCharacter.getWidth() / 2.0f, this.previousCharacter.getHeight() / 2.0f);
        this.previousCharacter.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.previousCharacter.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.previousCharacter.setX(this.charBackground.getX() + this.charBackground.getWidth() * 2.0f / 100.0f);
        this.previousCharacter.setY(this.charBackground.getY() + this.charBackground.getHeight() * 3.0f / 100.0f);
        this.previousCharacter.setVisible(false);
        this.stage.addActor(this.previousCharacter);
        this.nextCharacter = new Button(this.game.uiSkin, "next");
        this.nextCharacter.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                block9: {
                    if (PropertiesReader.verifyKey(TournamentGameScreen.this.game.mail, TournamentGameScreen.this.game.key, TournamentGameScreen.this.game.checksum).equalsIgnoreCase("free") || TournamentGameScreen.this.indexCharacter >= TournamentGameScreen.this.charactersNames.size() - 1) break block9;
                    TournamentGameScreen.this.indexCharacter = TournamentGameScreen.this.indexCharacter + 1;
                    TournamentGameScreen.this.loadCharacter();
                    TournamentGameScreen.this.previousCharacter.setVisible(true);
                    if (TournamentGameScreen.this.indexCharacter == TournamentGameScreen.this.charactersNames.size() - 1) {
                        TournamentGameScreen.this.nextCharacter.setVisible(false);
                    }
                    if (TournamentGameScreen.this.game.portraitmode) {
                        for (int i = 0; i < TournamentGameScreen.this.characters.size(); ++i) {
                            TournamentGameScreen.this.characters.get(i).setX(TournamentGameScreen.this.characters.get(i).getX() - TournamentGameScreen.this.charBackground.getWidth() / 2.0f);
                            if (i != TournamentGameScreen.this.indexCharacter) {
                                for (Actor currActorPart : TournamentGameScreen.this.characters.get(i).getChildren()) {
                                    currActorPart.setColor(0.0f, 0.0f, 0.0f, 1.0f);
                                }
                                TournamentGameScreen.this.characters.get(i).setVisible(false);
                                continue;
                            }
                            TournamentGameScreen.this.characters.get(i).setVisible(true);
                        }
                    } else {
                        for (int i = 0; i < TournamentGameScreen.this.characters.size(); ++i) {
                            TournamentGameScreen.this.characters.get(i).setX(TournamentGameScreen.this.characters.get(i).getX() - TournamentGameScreen.this.charBackground.getWidth() * 25.0f / 100.0f);
                            if (i != TournamentGameScreen.this.indexCharacter) {
                                for (Actor currActorPart : TournamentGameScreen.this.characters.get(i).getChildren()) {
                                    currActorPart.setColor(0.0f, 0.0f, 0.0f, 1.0f);
                                }
                                TournamentGameScreen.this.characters.get(i).setVisible(i == TournamentGameScreen.this.indexCharacter - 1 || i == TournamentGameScreen.this.indexCharacter + 1);
                                continue;
                            }
                            TournamentGameScreen.this.characters.get(i).setVisible(true);
                        }
                    }
                }
            }
        });
        this.nextCharacter.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.nextCharacter.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.nextCharacter.setX(this.charBackground.getX() + this.charBackground.getWidth() * 98.0f / 100.0f - this.nextCharacter.getWidth());
        this.nextCharacter.setY(this.charBackground.getY() + this.charBackground.getHeight() * 3.0f / 100.0f);
        this.stage.addActor(this.nextCharacter);
        JSONObject currObjCharacter = this.game.stats.get("tournament").getJSONObject("characters").getJSONObject(this.fighter.name);
        StringBuilder statsText = new StringBuilder();
        statsText.append("[#BFBFBF]");
        statsText.append(PropertiesReader.getMessage(this.game.gameMessages, "common.stats", this.game.violenceFilter));
        statsText.append(": ");
        statsText.append("[#FF0000]");
        statsText.append(currObjCharacter.getInt("maxLife") / 100);
        statsText.append("%");
        statsText.append("[#BFBFBF]/[#FFFF00]");
        statsText.append(currObjCharacter.getInt("maxStamina") / 100);
        statsText.append("%");
        statsText.append("[#BFBFBF]/[#00FF00]");
        statsText.append(currObjCharacter.getInt("maxBalance") / 100);
        statsText.append("%");
        this.statsLabel = new Label(statsText, this.game.uiSkin, "default");
        this.statsLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.statsLabel.setAlignment(1);
        this.statsLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.statsLabel.setX(statsBackground.getX() + statsBackground.getWidth() * 25.0f / 100.0f);
        this.statsLabel.setY(statsBackground.getY() + statsBackground.getHeight() * 82.0f / 100.0f - this.statsLabel.getPrefHeight() / 2.0f);
        this.stage.addActor(this.statsLabel);
        this.reputationLabel = new Label(currObjCharacter.getString("reputation"), this.game.uiSkin, "default");
        this.reputationLabel.setAlignment(1);
        this.reputationLabel.setColor(Color.RED);
        this.reputationLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.reputationLabel.setWidth(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.reputationLabel.setX(statsBackground.getX() + statsBackground.getWidth() * 25.0f / 100.0f);
        this.reputationLabel.setY(statsBackground.getY() + statsBackground.getHeight() * 68.0f / 100.0f - this.reputationLabel.getPrefHeight() / 2.0f);
        this.stage.addActor(this.reputationLabel);
        this.profitsLabel = new Label(currObjCharacter.getString("profits"), this.game.uiSkin, "default");
        this.profitsLabel.setAlignment(1);
        this.profitsLabel.setColor(this.game.uiSkin.get("iron", Color.class));
        this.profitsLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.profitsLabel.setWidth(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.profitsLabel.setX(statsBackground.getX() + statsBackground.getWidth() * 42.0f / 100.0f);
        this.profitsLabel.setY(statsBackground.getY() + statsBackground.getHeight() * 68.0f / 100.0f - this.profitsLabel.getPrefHeight() / 2.0f);
        this.stage.addActor(this.profitsLabel);
        TextureAtlas portraitsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
        Stack portrait = new Stack();
        this.portraitImage = new BaseActor();
        this.portraitImage.setTexture(portraitsAtlas.findRegion(this.fighter.portrait), UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        this.portraitImage.setWidth(UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        this.portraitImage.setHeight(UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        this.portraitImage.params.put("name", this.fighter.portrait);
        portrait.add(this.portraitImage);
        BaseActor portraitFrame = new BaseActor();
        portraitFrame.setTexture(portraitsAtlas.findRegion("portraitframe"), UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        portraitFrame.setWidth(UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        portraitFrame.setHeight(UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        portrait.add(portraitFrame);
        portrait.setWidth(UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        portrait.setHeight(UIHelpers.calcHeightProportion(this.game, 6.0f, 6.0f).floatValue());
        portrait.setX(statsBackground.getX() + statsBackground.getWidth() * 11.0f / 100.0f);
        portrait.setY(statsBackground.getY() + statsBackground.getHeight() * 63.0f / 100.0f);
        this.stage.addActor(portrait);
        portrait.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TournamentGameScreen.this.game.portraitsMenuScreen = new PortraitsMenuScreen(TournamentGameScreen.this.game, TournamentGameScreen.this.game.tournamentGameScreen, "");
                TournamentGameScreen.this.game.setScreen(TournamentGameScreen.this.game.portraitsMenuScreen);
            }
        });
        if (!PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum).equalsIgnoreCase("extra")) {
            this.portraitImage.setVisible(false);
            portraitFrame.setVisible(false);
            portrait.setVisible(false);
        }
        this.equipment = new Button(this.game.uiSkin, "equipmentmenu");
        this.equipment.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TournamentGameScreen.this.game.equipmentMenuScreen = new EquipmentMenuScreen(TournamentGameScreen.this.game, TournamentGameScreen.this.game.tournamentGameScreen, TournamentGameScreen.this.fighter, "host", TournamentGameScreen.this.game.stats.get("tournament").getJSONObject("characters").getJSONObject(TournamentGameScreen.this.fighter.name).getInt("reputation"));
                TournamentGameScreen.this.game.setScreen(TournamentGameScreen.this.game.equipmentMenuScreen);
            }
        });
        this.equipment.setWidth(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.equipment.setHeight(this.equipment.getWidth());
        this.equipment.setX(statsBackground.getX() + statsBackground.getWidth() * 8.0f / 100.0f);
        this.equipment.setY(statsBackground.getY() + statsBackground.getHeight() * 20.0f / 100.0f);
        this.stage.addActor(this.equipment);
        this.talents = new Button(this.game.uiSkin, "talentmenu");
        this.talents.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TournamentGameScreen.this.game.talentsMenuScreen = new TalentsMenuScreen(TournamentGameScreen.this.game, TournamentGameScreen.this.game.tournamentGameScreen, TournamentGameScreen.this.fighter, "host", TournamentGameScreen.this.game.stats.get("tournament").getJSONObject("characters").getJSONObject(TournamentGameScreen.this.fighter.name).getInt("reputation"), 0, false);
                TournamentGameScreen.this.game.setScreen(TournamentGameScreen.this.game.talentsMenuScreen);
            }
        });
        this.talents.setWidth(this.equipment.getWidth());
        this.talents.setHeight(this.equipment.getWidth());
        this.talents.setX(statsBackground.getX() + statsBackground.getWidth() * 25.0f / 100.0f);
        this.talents.setY(this.equipment.getY());
        this.stage.addActor(this.talents);
        this.services = new Button(this.game.uiSkin, "servicesmenu");
        this.services.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TournamentGameScreen.this.game.servicesMenuScreen = new ServicesMenuScreen(TournamentGameScreen.this.game, TournamentGameScreen.this.game.tournamentGameScreen, TournamentGameScreen.this.fighter, "host", TournamentGameScreen.this.game.stats.get("tournament").getJSONObject("characters").getJSONObject(TournamentGameScreen.this.fighter.name).getInt("reputation"), "", TournamentGameScreen.this.game.stats.get("tournament").getJSONObject("characters").getJSONObject(TournamentGameScreen.this.fighter.name).getInt("profits"), "");
                TournamentGameScreen.this.game.setScreen(TournamentGameScreen.this.game.servicesMenuScreen);
            }
        });
        this.services.setWidth(this.equipment.getWidth());
        this.services.setHeight(this.equipment.getWidth());
        this.services.setX(statsBackground.getX() + statsBackground.getWidth() * 42.0f / 100.0f);
        this.services.setY(this.equipment.getY());
        this.stage.addActor(this.services);
        Label difficultyLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty"), this.game.uiSkin, "default");
        difficultyLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        difficultyLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        difficultyLabel.setAlignment(1);
        difficultyLabel.setX(statsBackground.getX() + statsBackground.getWidth() * 77.0f / 100.0f - difficultyLabel.getPrefWidth() / 2.0f);
        difficultyLabel.setY(statsBackground.getY() + statsBackground.getHeight() * (float)(this.game.portraitmode ? 75 : 65) / 100.0f - difficultyLabel.getPrefHeight() / 2.0f);
        this.stage.addActor(difficultyLabel);
        this.difficulty = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String[] availableDifficulties = new String[]{PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.normal"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.hard"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.hardcore")};
        this.difficulty.setItems((String[])availableDifficulties);
        this.difficulty.setSelected(availableDifficulties[0]);
        this.difficulty.setWidth(this.difficulty.getPrefWidth());
        this.difficulty.setX(statsBackground.getX() + statsBackground.getWidth() * 77.0f / 100.0f - this.difficulty.getPrefWidth() / 2.0f);
        this.difficulty.setY(statsBackground.getY() + statsBackground.getHeight() * (float)(this.game.portraitmode ? 50 : 35) / 100.0f);
        this.stage.addActor(this.difficulty);
        this.infoButton = new Button(this.game.uiSkin, "info");
        this.infoButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TournamentGameScreen.this.overlay.setVisible(true);
                TournamentGameScreen.this.tooltipBackground.setVisible(true);
                TournamentGameScreen.this.tooltipLabel.setVisible(true);
                TournamentGameScreen.this.cancelInfoButton.setVisible(true);
            }
        });
        this.infoButton.setWidth(UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.infoButton.setHeight(UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.infoButton.setX(statsBackground.getX() + statsBackground.getWidth() * 95.0f / 100.0f - this.infoButton.getWidth());
        this.infoButton.setY(statsBackground.getY() + statsBackground.getHeight() * 92.0f / 100.0f - this.infoButton.getHeight());
        this.stage.addActor(this.infoButton);
        this.continueButton = new Button(this.game.uiSkin, "next");
        this.continueButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                String finalDifficulty = "normal";
                if (TournamentGameScreen.this.difficulty.getSelected().equalsIgnoreCase(PropertiesReader.getMessage(TournamentGameScreen.this.game.gameMessages, "game.settings.difficulty.hard"))) {
                    finalDifficulty = "hard";
                } else if (TournamentGameScreen.this.difficulty.getSelected().equalsIgnoreCase(PropertiesReader.getMessage(TournamentGameScreen.this.game.gameMessages, "game.settings.difficulty.hardcore"))) {
                    finalDifficulty = "hardcore";
                }
                Tournament.newGame(TournamentGameScreen.this.game, TournamentGameScreen.this.fighter.name, (String)TournamentGameScreen.this.portraitImage.params.get("name"), finalDifficulty);
            }
        });
        this.continueButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.continueButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.continueButton.setX(UIHelpers.calcWidthProportion(this.game, 99.0f, 94.0f).floatValue() - this.continueButton.getWidth());
        this.continueButton.setY(UIHelpers.calcHeightProportion(this.game, 1.0f, 3.0f).floatValue());
        this.stage.addActor(this.continueButton);
        this.overlay = new BaseActor();
        this.overlay.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/overlay.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
        this.overlay.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.overlay.setPosition(0.0f, 0.0f);
        this.overlay.setVisible(false);
        this.stage.addActor(this.overlay);
        this.tooltipBackground = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.tooltipBackground.setWidth(UIHelpers.calcHeightProportion(this.game, 75.0f, 75.0f).floatValue());
        this.tooltipBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue());
        this.tooltipBackground.setPosition(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.tooltipBackground.getWidth() / 2.0f, UIHelpers.calcHeightProportion(this.game, 25.0f, 25.0f).floatValue());
        this.tooltipBackground.setVisible(false);
        this.stage.addActor(this.tooltipBackground);
        this.tooltipLabel = new Label("", this.game.uiSkin, "default");
        this.tooltipLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.tooltipLabel.setWrap(true);
        this.tooltipLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.tooltipLabel.setAlignment(2);
        this.tooltipLabel.setWidth(this.tooltipBackground.getWidth() * 94.0f / 100.0f);
        this.tooltipLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.tooltip"));
        UIHelpers.fixLabelFontSize(this.tooltipLabel, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.tooltipBackground.getHeight() * 75.0f / 100.0f);
        this.tooltipLabel.setX(this.tooltipBackground.getX() + this.tooltipBackground.getWidth() * 3.0f / 100.0f);
        this.tooltipLabel.setY(this.tooltipBackground.getY() + this.tooltipBackground.getHeight() * 95.0f / 100.0f);
        this.tooltipLabel.setVisible(false);
        this.stage.addActor(this.tooltipLabel);
        this.cancelInfoButton = new Button(this.game.uiSkin, "cancel");
        this.cancelInfoButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TournamentGameScreen.this.overlay.setVisible(false);
                TournamentGameScreen.this.tooltipBackground.setVisible(false);
                TournamentGameScreen.this.tooltipLabel.setVisible(false);
                TournamentGameScreen.this.cancelInfoButton.setVisible(false);
            }
        });
        this.cancelInfoButton.setVisible(false);
        this.cancelInfoButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.cancelInfoButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.cancelInfoButton.setX(this.tooltipBackground.getX() + this.tooltipBackground.getWidth() * 50.0f / 100.0f - this.cancelInfoButton.getWidth() / 2.0f);
        this.cancelInfoButton.setY(this.tooltipBackground.getY() + this.tooltipBackground.getHeight() * 10.0f / 100.0f);
        this.stage.addActor(this.cancelInfoButton);
        Label lexiconLabel = new Label(this.game.input.equalsIgnoreCase("keyboard") ? PropertiesReader.getMessage(this.game.gameMessages, "lexicon.key") : PropertiesReader.getMessage(this.game.gameMessages, "lexicon.touch"), this.game.uiSkin, "default");
        lexiconLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        lexiconLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        lexiconLabel.setPosition(UIHelpers.calcWidthProportion(this.game, 99.0f, 99.0f).floatValue() - lexiconLabel.getPrefWidth(), this.game.viewHeight.floatValue() - lexiconLabel.getPrefHeight());
        lexiconLabel.layout();
        lexiconLabel.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                TournamentGameScreen.this.game.lexiconScreen = new LexiconScreen(TournamentGameScreen.this.game, TournamentGameScreen.this.game.tournamentGameScreen);
                TournamentGameScreen.this.game.setScreen(TournamentGameScreen.this.game.lexiconScreen);
            }
        });
        this.stage.addActor(lexiconLabel);
        if (!this.game.input.equalsIgnoreCase("keyboard")) {
            Button menuButton = new Button(this.game.uiSkin, "menu");
            menuButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            menuButton.setHeight(menuButton.getWidth());
            menuButton.setX(10.0f);
            menuButton.setY(this.game.viewHeight.floatValue() - menuButton.getWidth() - 10.0f);
            menuButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    TournamentGameScreen.this.game.gameMenuScreen = new GameMenuScreen(TournamentGameScreen.this.game, TournamentGameScreen.this.game.tournamentGameScreen);
                    TournamentGameScreen.this.game.setScreen(TournamentGameScreen.this.game.gameMenuScreen);
                }
            });
            menuButton.setVisible(true);
            this.stage.addActor(menuButton);
        }
        this.loadCharacter();
    }

    @Override
    public void render(float delta) {
        this.game.manager.update();
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public void dispose() {
        for (Fighter currFighter : this.charactersFighters) {
            Fighter.unloadFighterAssets(this.game, currFighter, true, true);
        }
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4 || keycode == 82) {
            this.game.gameMenuScreen = new GameMenuScreen(this.game, this);
            this.game.setScreen(this.game.gameMenuScreen);
        } else if (keycode == 244) {
            this.game.lexiconScreen = new LexiconScreen(this.game, this.game.tournamentGameScreen);
            this.game.setScreen(this.game.lexiconScreen);
        } else if (keycode == Input.Keys.valueOf(this.game.nextkey) && this.continueButton != null && this.continueButton.isVisible()) {
            InputEvent event = new InputEvent();
            event.setType(InputEvent.Type.touchUp);
            this.continueButton.fire(event);
            return true;
        }
        return false;
    }

    public void loadCharacter() {
        StringBuilder statsText;
        TextureAtlas portraitsAtlas;
        String currCharacter = this.charactersNames.get(this.indexCharacter);
        this.fighter = Fighter.createOpponent(this.game, currCharacter, 1000, true);
        JSONObject currObjCharacter = this.game.stats.get("tournament").getJSONObject("characters").getJSONObject(this.fighter.name);
        this.game.saveGame.put("rewards", currObjCharacter.getString("rewards"));
        if (currCharacter.equalsIgnoreCase("soldier") || this.game.achievements.get("tournament." + currCharacter) != null) {
            for (Actor currActorPart : this.characters.get(this.indexCharacter).getChildren()) {
                if (!(currActorPart instanceof BaseActor)) continue;
                if (((String)((BaseActor)currActorPart).params.get("type")).equalsIgnoreCase("body")) {
                    currActorPart.setColor(Color.valueOf(this.fighter.bodyColor));
                    continue;
                }
                if (((String)((BaseActor)currActorPart).params.get("type")).equalsIgnoreCase("skin")) {
                    currActorPart.setColor(Color.valueOf(this.fighter.skinColor));
                    continue;
                }
                if (((String)((BaseActor)currActorPart).params.get("type")).equalsIgnoreCase("arms")) {
                    currActorPart.setColor(Color.valueOf(this.fighter.skinColor));
                    continue;
                }
                if (((String)((BaseActor)currActorPart).params.get("type")).equalsIgnoreCase("bodyExtra")) {
                    currActorPart.setColor(Color.valueOf(this.fighter.bodyColor));
                    continue;
                }
                if (((String)((BaseActor)currActorPart).params.get("type")).equalsIgnoreCase("skinExtra")) {
                    currActorPart.setColor(Color.valueOf(this.fighter.skinColor));
                    continue;
                }
                if (((String)((BaseActor)currActorPart).params.get("type")).equalsIgnoreCase("accessory")) {
                    currActorPart.setColor(Color.valueOf(this.fighter.accessoryColor));
                    continue;
                }
                currActorPart.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        this.selectedChar.setText(PropertiesReader.getMessage(this.game.gameMessages, "zone.tournament.character." + currCharacter + ".name", this.game.violenceFilter));
        if (currCharacter.equalsIgnoreCase("soldier") || this.game.achievements.get("tournament." + currCharacter) != null) {
            this.charText.setText(PropertiesReader.getMessage(this.game.gameMessages, "zone.tournament.character." + currCharacter + ".info", this.game.violenceFilter));
            this.reputationLabel.setText(currObjCharacter.getString("reputation"));
            this.profitsLabel.setText(currObjCharacter.getString("profits"));
            portraitsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
            this.portraitImage.setTexture(portraitsAtlas.findRegion(this.fighter.portrait), this.portraitImage.getWidth(), this.portraitImage.getHeight());
            this.portraitImage.params.put("name", this.fighter.portrait);
            statsText = new StringBuilder();
            statsText.append("[#BFBFBF]");
            statsText.append(PropertiesReader.getMessage(this.game.gameMessages, "common.stats", this.game.violenceFilter));
            statsText.append(": ");
            statsText.append("[#FF0000]");
            statsText.append(currObjCharacter.getInt("maxLife") / 100);
            statsText.append("%");
            statsText.append("[#BFBFBF]/[#FFFF00]");
            statsText.append(currObjCharacter.getInt("maxStamina") / 100);
            statsText.append("%");
            statsText.append("[#BFBFBF]/[#00FF00]");
            statsText.append(currObjCharacter.getInt("maxBalance") / 100);
            statsText.append("%");
            this.statsLabel.setText(statsText);
            this.equipment.setVisible(true);
            this.talents.setVisible(true);
            this.services.setVisible(true);
            this.continueButton.setVisible(true);
        } else {
            this.charText.setText(PropertiesReader.getMessage(this.game.gameMessages, "common.locked", this.game.violenceFilter));
            this.reputationLabel.setText("?");
            this.profitsLabel.setText("?");
            portraitsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
            this.portraitImage.setTexture(portraitsAtlas.findRegion("p00"), this.portraitImage.getWidth(), this.portraitImage.getHeight());
            statsText = new StringBuilder();
            statsText.append("[#BFBFBF]");
            statsText.append(PropertiesReader.getMessage(this.game.gameMessages, "common.stats", this.game.violenceFilter));
            statsText.append(": ");
            statsText.append("[#FF0000]");
            statsText.append("?%");
            statsText.append("[#BFBFBF]/[#FFFF00]");
            statsText.append("?%");
            statsText.append("[#BFBFBF]/[#00FF00]");
            statsText.append("?%");
            this.statsLabel.setText(statsText);
            this.equipment.setVisible(false);
            this.talents.setVisible(false);
            this.services.setVisible(false);
            this.continueButton.setVisible(false);
        }
    }
}

