/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.AnimatedActor;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.ParticleEffectActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import com.calimasaga.slavepits.util.StringList;
import java.util.ArrayList;
import java.util.HashMap;

public class TournamentEventScreen
extends BaseScreen {
    public String musicTrack = "";
    public String backgroundImage = "";
    public String story = "";
    public long time = 0L;
    public float timeElapsed = 0.0f;
    public BaseActor background;
    public Label storyLabel;
    public Table storyTable;
    public ScrollPane storyPane;
    public NinePatchActor textOverlay;
    public Button nextButton;
    private ArrayList<FrameBuffer> listFrameBuffer = new ArrayList();
    private ArrayList<BaseActor> listAnimatedActor = new ArrayList();
    private ArrayList<ParticleEffectActor> listParticleEffectActor = new ArrayList();
    public HashMap<Integer, Label> availableOptions = new HashMap();
    public NinePatchActor rewardBackground;
    public Label rewardLabel;
    public Button rewardButton;
    public BaseActor rewardOverlay;
    public ShaderProgram borderShader;
    public ShaderProgram petrifyShader;
    public boolean shaderDone = false;
    public Fighter fighter;
    public Stack fighterCharacter;
    public BaseActor fighterBody;
    public BaseActor fighterBodyExtra;
    public BaseActor fighterBodyArmorL;
    public BaseActor fighterBodyArmorT;
    public BaseActor fighterBodyArmorTExtra;
    public BaseActor fighterSkin;
    public BaseActor fighterSkinExtra;
    public BaseActor fighterHead;
    public ArrayList<BaseActor> fighterAccessories;
    public BaseActor fighterArms;
    public BaseActor fighterArmsArmorSL;
    public BaseActor fighterArmsArmorBRL;
    public BaseActor fighterArmsArmorBRR;
    public BaseActor fighterArmsArmorSPL;
    public BaseActor fighterArmsArmorSPR;
    public BaseActor fighterWeapon;
    public BaseActor fighterOffHand;

    public TournamentEventScreen(SlavePitsGame g, String selMusic, String selBackground, String selStory, long selTime) {
        super(g);
        this.musicTrack = selMusic;
        this.backgroundImage = selBackground;
        this.story = selStory;
        this.time = selTime;
        this.timeElapsed = 0.0f;
        this.create();
    }

    @Override
    public void create() {
        FrameBuffer frameBuffer;
        if (this.game.track != null && this.game.track.isPlaying()) {
            this.game.track.stop();
            this.game.track.dispose();
        }
        this.game.track = Gdx.audio.newMusic(Gdx.files.internal(this.musicTrack));
        this.game.track.setLooping(true);
        this.game.track.setVolume(this.game.musicVolume);
        this.game.track.play();
        this.background = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, this.background, this.backgroundImage, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.stage.addActor(this.background);
        if (this.backgroundImage.endsWith("backgroundLore3.jpg")) {
            frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, this.game.viewWidth.intValue(), this.game.viewHeight.intValue(), true);
            this.listFrameBuffer.add(frameBuffer);
            AnimatedActor l1 = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/misceffects.atlas"), "light", 3, this.game.viewWidth.floatValue() / 2.0f, this.game.viewWidth.floatValue() / 2.0f, false);
            l1.setPosition(this.game.viewWidth.floatValue() * 84.0f / 100.0f - l1.getWidth() / 2.0f, this.game.viewHeight.floatValue() * 90.0f / 100.0f - l1.getHeight() / 2.0f);
            l1.playAnimation(86400.0f, 0.1f, 5.0f);
            this.listAnimatedActor.add(l1);
            TextureAtlas misceffectsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/misceffects.atlas"), TextureAtlas.class);
            ParticleEffectActor t1 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenFilename("data/elements/torch.p")), misceffectsAtlas, this.game.viewWidth.floatValue() * 84.0f / 100.0f, this.game.viewHeight.floatValue() * 90.0f / 100.0f, true);
            this.listParticleEffectActor.add(t1);
            this.stage.addActor(t1);
        } else if (this.backgroundImage.endsWith("backgroundLore5.jpg")) {
            frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, this.game.viewWidth.intValue(), this.game.viewHeight.intValue(), true);
            this.listFrameBuffer.add(frameBuffer);
            AnimatedActor l1 = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/misceffects.atlas"), "light", 3, this.game.viewWidth.floatValue() / 2.0f, this.game.viewWidth.floatValue() / 2.0f, false);
            l1.setPosition(this.game.viewWidth.floatValue() * 50.0f / 100.0f - l1.getWidth() / 2.0f, this.game.viewHeight.floatValue() * 65.0f / 100.0f - l1.getHeight() / 2.0f);
            l1.playAnimation(86400.0f, 0.1f, 5.0f);
            this.listAnimatedActor.add(l1);
        } else if (this.backgroundImage.endsWith("backgroundLore11.jpg")) {
            frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, this.game.viewWidth.intValue(), this.game.viewHeight.intValue(), true);
            this.listFrameBuffer.add(frameBuffer);
        } else if (this.backgroundImage.endsWith("backgroundHall.jpg")) {
            frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, this.game.viewWidth.intValue(), this.game.viewHeight.intValue(), true);
            this.listFrameBuffer.add(frameBuffer);
            AnimatedActor l1 = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/misceffects.atlas"), "light", 3, this.game.viewWidth.floatValue() / 2.0f, this.game.viewWidth.floatValue() / 2.0f, false);
            l1.setPosition(this.game.viewWidth.floatValue() * 70.0f / 100.0f - l1.getWidth() / 2.0f, this.game.viewHeight.floatValue() * 90.0f / 100.0f - l1.getHeight() / 2.0f);
            l1.playAnimation(86400.0f, 0.1f, 5.0f);
            this.listAnimatedActor.add(l1);
            TextureAtlas misceffectsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/misceffects.atlas"), TextureAtlas.class);
            ParticleEffectActor t1 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenFilename("data/elements/torch.p")), misceffectsAtlas, this.game.viewWidth.floatValue() * 70.0f / 100.0f, this.game.viewHeight.floatValue() * 90.0f / 100.0f, true);
            this.listParticleEffectActor.add(t1);
            this.stage.addActor(t1);
        }
        this.textOverlay = new NinePatchActor(this.game.uiSkin.get("overlayfaded", NinePatch.class));
        this.textOverlay.getColor().a = 0.75f;
        this.textOverlay.setWidth(UIHelpers.calcWidthProportion(this.game, 72.0f, 76.0f).floatValue());
        this.textOverlay.setX(UIHelpers.calcWidthProportion(this.game, 14.0f, 12.0f).floatValue());
        this.stage.addActor(this.textOverlay);
        this.storyLabel = new Label("", this.game.uiSkin, "default");
        this.storyLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.storyLabel.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.storyLabel.setAlignment(10);
        this.storyLabel.setWrap(true);
        this.storyLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 70.0f, 74.0f).floatValue());
        this.storyLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "zone." + this.story, this.game.violenceFilter, "##:" + new Color(this.game.uiSkin.get("lightiron", Color.class)).mul(0.9f).toString()));
        this.storyLabel.invalidate();
        this.storyTable = new Table();
        this.storyTable.left().top();
        this.storyTable.setWidth(UIHelpers.calcWidthProportion(this.game, 70.0f, 74.0f).floatValue());
        this.storyTable.add(this.storyLabel).width(this.storyTable.getWidth());
        this.storyPane = new ScrollPane((Actor)this.storyTable);
        this.storyPane.addListener(new InputListener(){

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                TournamentEventScreen.this.stage.setScrollFocus(null);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                TournamentEventScreen.this.stage.setScrollFocus(event.getListenerActor());
            }
        });
        this.storyPane.setForceScroll(false, true);
        this.storyPane.setFlickScroll(false);
        this.storyPane.setOverscroll(false, true);
        this.storyPane.setWidth(this.storyTable.getWidth());
        this.storyPane.setX(UIHelpers.calcWidthProportion(this.game, 15.0f, 13.0f).floatValue());
        this.storyPane.setHeight(UIHelpers.calcHeightProportion(this.game, 80.0f, 80.0f).floatValue());
        this.storyPane.layout();
        this.storyPane.setY(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.storyPane.setScrollY(0.0f);
        if (this.game.portraitmode) {
            this.storyPane.addListener(new DragListener(){

                @Override
                public void drag(InputEvent event, float x, float y, int pointer) {
                    super.drag(event, x, y, pointer);
                    TournamentEventScreen.this.storyPane.setScrollY(TournamentEventScreen.this.storyPane.getScrollY() + (float)((int)this.getDeltaY()));
                }
            });
        } else {
            this.storyPane.addListener(new InputListener(){

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                    TournamentEventScreen.this.stage.setScrollFocus(null);
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    TournamentEventScreen.this.stage.setScrollFocus(event.getListenerActor());
                }
            });
        }
        this.stage.addActor(this.storyPane);
        float textOverlaySize = this.storyTable.getCell(this.storyLabel).getPrefHeight();
        this.textOverlay.setHeight(Math.min(textOverlaySize * 104.0f / 100.0f, this.storyPane.getHeight() * 104.0f / 100.0f));
        this.textOverlay.setY(UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue() - this.textOverlay.getHeight() * 98.0f / 100.0f);
        this.addActorsByLoreId();
    }

    @Override
    public void render(float delta) {
        this.timeElapsed += delta;
        this.renderByLoreId(delta);
    }

    @Override
    public void dispose() {
        UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset(this.backgroundImage));
        if (this.story.contains(".end")) {
            Fighter.unloadFighterAssets(this.game, this.fighter, true, true);
        }
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4 || keycode == 82) {
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
            this.dispose();
        } else if (keycode == Input.Keys.valueOf(this.game.nextkey)) {
            if (this.rewardButton != null && this.rewardButton.isVisible()) {
                InputEvent event = new InputEvent();
                event.setType(InputEvent.Type.touchUp);
                this.rewardButton.fire(event);
                return true;
            }
            if (this.nextButton != null && this.nextButton.isVisible()) {
                InputEvent event = new InputEvent();
                event.setType(InputEvent.Type.touchUp);
                this.nextButton.fire(event);
                return true;
            }
        } else if ((keycode >= 7 || keycode <= 16) && this.availableOptions.get(keycode - 7) != null) {
            InputEvent event = new InputEvent();
            event.setType(InputEvent.Type.touchUp);
            this.availableOptions.get(keycode - 7).fire(event);
            return true;
        }
        return false;
    }

    private void addActorsByLoreId() {
        if (this.story.contains("chapter") || this.story.contains("boss")) {
            this.addFadeOverlay(Float.valueOf(1.0f));
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    Tournament.getNextScreen(TournamentEventScreen.this.game, "event", "chapter");
                    TournamentEventScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(0.3f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(0.3f));
        } else if (this.story.contains(".end")) {
            this.addFadeOverlay(Float.valueOf(1.0f));
            this.petrifyShader = new ShaderProgram(Gdx.files.internal(this.game.getOverridenFilename("data/shaders/v_petrify.glsl")), Gdx.files.internal(this.game.getOverridenFilename("data/shaders/f_petrify.glsl")));
            this.borderShader = new ShaderProgram(Gdx.files.internal(this.game.getOverridenFilename("data/shaders/v_border.glsl")), Gdx.files.internal(this.game.getOverridenFilename("data/shaders/f_border.glsl")));
            this.fighter = this.game.campaignFighter;
            Fighter.loadFighterAssets(this.game, this.fighter, true, true);
            this.fighterCharacter = new Stack();
            this.fighterCharacter.setWidth(this.game.viewHeight.floatValue() * 45.0f / 100.0f);
            this.fighterCharacter.setHeight(this.game.viewHeight.floatValue() * 45.0f / 100.0f);
            this.fighterCharacter.setX(UIHelpers.calcWidthProportion(this.game, 63.0f, 72.0f).floatValue() - this.fighterCharacter.getWidth() / 2.0f);
            this.fighterCharacter.setY(this.game.viewHeight.floatValue() * 38.0f / 100.0f);
            this.fighterSkin = new BaseActor();
            this.fighterCharacter.add(this.fighterSkin);
            this.fighterBody = new BaseActor();
            this.fighterCharacter.add(this.fighterBody);
            this.fighterBodyArmorL = new BaseActor();
            this.fighterCharacter.add(this.fighterBodyArmorL);
            this.fighterBodyArmorT = new BaseActor();
            this.fighterCharacter.add(this.fighterBodyArmorT);
            this.fighterAccessories = new ArrayList();
            for (int i = 0; i < 15; ++i) {
                BaseActor accessory = new BaseActor();
                accessory.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
                this.fighterAccessories.add(accessory);
                this.fighterCharacter.add(accessory);
            }
            this.fighterHead = new BaseActor();
            this.fighterCharacter.add(this.fighterHead);
            this.fighterArms = new BaseActor();
            this.fighterCharacter.add(this.fighterArms);
            this.fighterArmsArmorSL = new BaseActor();
            this.fighterCharacter.add(this.fighterArmsArmorSL);
            this.fighterArmsArmorSPL = new BaseActor();
            this.fighterCharacter.add(this.fighterArmsArmorSPL);
            this.fighterArmsArmorSPR = new BaseActor();
            this.fighterCharacter.add(this.fighterArmsArmorSPR);
            this.fighterArmsArmorBRL = new BaseActor();
            this.fighterCharacter.add(this.fighterArmsArmorBRL);
            this.fighterArmsArmorBRR = new BaseActor();
            this.fighterCharacter.add(this.fighterArmsArmorBRR);
            this.fighterSkinExtra = new BaseActor();
            this.fighterCharacter.add(this.fighterSkinExtra);
            this.fighterBodyExtra = new BaseActor();
            this.fighterCharacter.add(this.fighterBodyExtra);
            this.fighterBodyArmorTExtra = new BaseActor();
            this.fighterCharacter.add(this.fighterBodyArmorTExtra);
            this.fighterWeapon = new BaseActor();
            this.fighterCharacter.add(this.fighterWeapon);
            this.fighterOffHand = new BaseActor();
            this.fighterCharacter.add(this.fighterOffHand);
            this.fighterCharacter.setTransform(true);
            this.fighterCharacter.setVisible(true);
            this.drawFighter("idle", "");
            this.storyPane.setY(0.0f - this.storyPane.getHeight());
            this.storyPane.clearActions();
            SequenceAction scroll = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.moveTo(UIHelpers.calcWidthProportion(this.game, 15.0f, 13.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), (float)this.time / 1000.0f));
            this.storyPane.addAction(scroll);
            this.textOverlay.setY(0.0f - this.textOverlay.getHeight() * 98.0f / 100.0f);
            this.textOverlay.clearActions();
            SequenceAction scrolloverlay = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.moveTo(UIHelpers.calcWidthProportion(this.game, 14.0f, 12.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue() - this.textOverlay.getHeight() * 98.0f / 100.0f, (float)this.time / 1000.0f));
            this.textOverlay.addAction(scrolloverlay);
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    Tournament.getNextScreen(TournamentEventScreen.this.game, "end", "");
                    TournamentEventScreen.this.dispose();
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(0.3f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
            this.stage.getRoot().getColor().a = 0.0f;
            this.stage.getRoot().addAction(Actions.fadeIn(0.3f));
        } else if (this.story.contains("event")) {
            this.addFadeOverlay(Float.valueOf(0.3f));
            float textOverlaySize = this.storyTable.getCell(this.storyLabel).getPrefHeight();
            if (!PropertiesReader.getMessage(this.game.gameMessages, "zone." + this.story + ".option1", this.game.violenceFilter).equalsIgnoreCase("")) {
                int i = 1;
                String text = PropertiesReader.getMessage(this.game.gameMessages, "zone." + this.story + ".option" + i, this.game.violenceFilter);
                while (!text.equalsIgnoreCase("")) {
                    if (Tournament.isValidEventCondition(this.game, this.story.replace("tournament.event.", ""), i)) {
                        Label optionLabel = new Label(i + ". " + text, this.game.uiSkin, "default");
                        optionLabel.setFontScale(this.storyLabel.getFontScaleX());
                        optionLabel.setColor(this.game.uiSkin.getColor("white"));
                        optionLabel.setAlignment(10);
                        optionLabel.setWrap(true);
                        optionLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 70.0f, 74.0f).floatValue());
                        optionLabel.addListener(new InputListener(){

                            @Override
                            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                                event.getListenerActor().setColor(TournamentEventScreen.this.game.uiSkin.getColor("red"));
                            }

                            @Override
                            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                                event.getListenerActor().setColor(TournamentEventScreen.this.game.uiSkin.getColor("white"));
                            }

                            @Override
                            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                                return true;
                            }

                            @Override
                            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                                for (Actor currActor : TournamentEventScreen.this.stage.getActors()) {
                                    if (currActor.getActions() == null || currActor.getActions().size <= 0) continue;
                                    for (Action currAction : currActor.getActions()) {
                                        currAction.act(10000.0f);
                                    }
                                }
                                StringBuilder currRewards = StringList.create(TournamentEventScreen.this.game.saveGame.get("rewards"), ";");
                                currRewards = StringList.set(currRewards, 1, ((Label)event.getListenerActor()).getText().toString().substring(0, 1), ";");
                                TournamentEventScreen.this.game.saveGame.put("rewards", currRewards.toString());
                                if (Tournament.getNextScreen(TournamentEventScreen.this.game, "event", ((Label)event.getListenerActor()).getText().toString().substring(0, 1))) {
                                    TournamentEventScreen.this.dispose();
                                }
                            }
                        });
                        this.stage.addActor(optionLabel);
                        this.availableOptions.put(i, optionLabel);
                        optionLabel.layout();
                        this.storyTable.row();
                        this.storyTable.add(optionLabel).width(this.storyTable.getWidth());
                        this.storyTable.getCell(optionLabel).padTop(UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
                        textOverlaySize = textOverlaySize + this.storyTable.getCell(optionLabel).getPrefHeight() + UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue();
                    }
                    text = PropertiesReader.getMessage(this.game.gameMessages, "zone." + this.story + ".option" + ++i, this.game.violenceFilter);
                }
                this.textOverlay.setHeight(Math.min(textOverlaySize * 104.0f / 100.0f, this.storyPane.getHeight() * 104.0f / 100.0f));
                this.textOverlay.setY(UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue() - this.textOverlay.getHeight() * 98.0f / 100.0f);
            }
            this.rewardOverlay = new BaseActor();
            this.rewardOverlay.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/overlay.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
            this.rewardOverlay.setColor(0.0f, 0.0f, 0.0f, 0.6f);
            this.rewardOverlay.setPosition(0.0f, 0.0f);
            this.rewardOverlay.setVisible(false);
            this.stage.addActor(this.rewardOverlay);
            this.rewardBackground = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
            this.rewardBackground.setVisible(false);
            this.rewardBackground.setWidth(UIHelpers.calcHeightProportion(this.game, 60.0f, 50.0f).floatValue());
            this.rewardBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 50.0f, 40.0f).floatValue());
            this.rewardBackground.setPosition(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.rewardBackground.getWidth() / 2.0f, UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue() - this.rewardBackground.getHeight() / 2.0f);
            this.stage.addActor(this.rewardBackground);
            this.rewardLabel = new Label("", this.game.uiSkin, "default");
            this.rewardLabel.setWrap(true);
            this.rewardLabel.setAlignment(1);
            this.rewardLabel.setVisible(false);
            this.rewardLabel.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
            this.rewardLabel.setWidth(this.rewardBackground.getWidth() * 80.0f / 100.0f);
            this.rewardLabel.layout();
            this.rewardLabel.setX(this.rewardBackground.getX() + this.rewardBackground.getWidth() / 2.0f - this.rewardLabel.getWidth() / 2.0f);
            this.rewardLabel.setY(this.rewardBackground.getY() + this.rewardBackground.getHeight() * 65.0f / 100.0f - this.rewardLabel.getHeight() / 2.0f);
            this.stage.addActor(this.rewardLabel);
            this.rewardButton = new Button(this.game.uiSkin, "ok");
            this.rewardButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    Tournament.getNextScreen(TournamentEventScreen.this.game, "reward", "");
                    TournamentEventScreen.this.dispose();
                }
            });
            this.rewardButton.setVisible(false);
            this.rewardButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.rewardButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.rewardButton.setX(this.rewardBackground.getX() + this.rewardBackground.getWidth() / 2.0f - this.rewardButton.getWidth() / 2.0f);
            this.rewardButton.setY(this.rewardBackground.getY() + this.rewardBackground.getHeight() * 4.0f / 100.0f);
            this.stage.addActor(this.rewardButton);
            this.doFade("in", Float.valueOf(0.3f));
        }
    }

    private void renderByLoreId(float delta) {
        this.game.manager.update();
        this.stage.act(delta);
        if (this.backgroundImage.endsWith("backgroundLore3.jpg")) {
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 771);
            this.listParticleEffectActor.get((int)0).pe.getEmitters().get(0).getTransparency().setHigh(MathUtils.clamp(this.timeElapsed / 10.0f, 0.0f, 1.0f));
            this.stage.draw();
            this.stage.getViewport().apply();
            this.listFrameBuffer.get(0).begin();
            Gdx.gl.glClearColor(0.8f, 0.8f, 0.8f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 1);
            this.stage.getBatch().begin();
            this.listAnimatedActor.get(0).act(delta);
            this.listAnimatedActor.get(0).draw(this.stage.getBatch(), 1.0f);
            this.stage.getBatch().end();
            this.listFrameBuffer.get(0).end(this.stage.getViewport().getScreenX(), this.stage.getViewport().getScreenY(), this.stage.getViewport().getScreenWidth(), this.stage.getViewport().getScreenHeight());
            this.stage.getBatch().setBlendFunction(774, 0);
            this.stage.getBatch().begin();
            this.stage.getBatch().draw((Texture)this.listFrameBuffer.get(0).getColorBufferTexture(), 0.0f, 0.0f, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f, 1.0f, 1.0f);
            this.stage.getBatch().end();
        } else if (this.backgroundImage.endsWith("backgroundLore5.jpg")) {
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 771);
            this.stage.draw();
            this.stage.getViewport().apply();
            this.listFrameBuffer.get(0).begin();
            Gdx.gl.glClearColor(0.8f, 0.8f, 0.8f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 1);
            this.stage.getBatch().begin();
            this.listAnimatedActor.get(0).act(delta);
            this.listAnimatedActor.get(0).draw(this.stage.getBatch(), 1.0f);
            this.stage.getBatch().end();
            this.listFrameBuffer.get(0).end(this.stage.getViewport().getScreenX(), this.stage.getViewport().getScreenY(), this.stage.getViewport().getScreenWidth(), this.stage.getViewport().getScreenHeight());
            this.stage.getBatch().setBlendFunction(774, 0);
            this.stage.getBatch().begin();
            this.stage.getBatch().draw((Texture)this.listFrameBuffer.get(0).getColorBufferTexture(), 0.0f, 0.0f, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f, 1.0f, 1.0f);
            this.stage.getBatch().end();
            this.stage.getViewport().apply();
        } else if (this.backgroundImage.endsWith("backgroundHall.jpg")) {
            this.stage.act(delta);
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 771);
            this.listParticleEffectActor.get((int)0).pe.getEmitters().get(0).getTransparency().setHigh(MathUtils.clamp(this.timeElapsed / 10.0f, 0.0f, 1.0f));
            this.stage.draw();
            this.stage.getViewport().apply();
            this.listFrameBuffer.get(0).begin();
            Gdx.gl.glClearColor(0.8f, 0.8f, 0.8f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setBlendFunction(770, 1);
            this.stage.getBatch().begin();
            this.listAnimatedActor.get(0).act(delta);
            this.listAnimatedActor.get(0).draw(this.stage.getBatch(), 1.0f);
            this.stage.getBatch().end();
            this.listFrameBuffer.get(0).end(this.stage.getViewport().getScreenX(), this.stage.getViewport().getScreenY(), this.stage.getViewport().getScreenWidth(), this.stage.getViewport().getScreenHeight());
            this.stage.getBatch().setBlendFunction(774, 0);
            this.stage.getBatch().begin();
            this.stage.getBatch().draw((Texture)this.listFrameBuffer.get(0).getColorBufferTexture(), 0.0f, 0.0f, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f, 1.0f, 1.0f);
            this.stage.getBatch().end();
            this.stage.getViewport().apply();
        } else if (this.backgroundImage.endsWith("backgroundLore11.jpg")) {
            Camera camera = this.stage.getViewport().getCamera();
            camera.update();
            this.stage.getBatch().setProjectionMatrix(camera.combined);
            if (!this.shaderDone) {
                this.stage.getViewport().apply();
                this.listFrameBuffer.get(0).begin();
                Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                Gdx.gl.glClear(16384);
                this.stage.getBatch().begin();
                this.stage.getBatch().setShader(this.borderShader);
                this.borderShader.setUniformf("u_imageSize", new Vector2(this.fighterCharacter.getWidth(), this.fighterCharacter.getHeight()));
                this.borderShader.setUniformf("u_borderColor", Color.BLACK);
                this.borderShader.setUniformf("u_borderSize", 3.0f);
                this.fighterCharacter.draw(this.stage.getBatch(), 1.0f);
                this.stage.getBatch().setShader(this.petrifyShader);
                this.fighterCharacter.draw(this.stage.getBatch(), 1.0f);
                this.stage.getBatch().end();
                this.listFrameBuffer.get(0).end(this.stage.getViewport().getScreenX(), this.stage.getViewport().getScreenY(), this.stage.getViewport().getScreenWidth(), this.stage.getViewport().getScreenHeight());
                this.shaderDone = true;
            }
            this.fighterCharacter.act(delta);
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.getBatch().setShader(null);
            this.stage.getBatch().begin();
            this.background.draw(this.stage.getBatch(), 1.0f);
            this.stage.getBatch().draw((Texture)this.listFrameBuffer.get(0).getColorBufferTexture(), 0.0f, 0.0f, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f, 1.0f, 1.0f);
            this.textOverlay.draw(this.stage.getBatch(), 1.0f);
            this.storyPane.draw(this.stage.getBatch(), 1.0f);
            this.nextButton.draw(this.stage.getBatch(), 1.0f);
            this.stage.getBatch().end();
        } else {
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.stage.draw();
        }
    }

    private void drawFighter(String status, String direction) {
        String suffix = status;
        String weaponType = this.game.stats.get("weapons").getJSONObject(this.fighter.weapon.id).getString("type");
        if (weaponType.equalsIgnoreCase("2h3")) {
            weaponType = suffix.equalsIgnoreCase("middle") || suffix.startsWith("hit") ? "2h2" : "2h1";
        }
        this.fighterSkin.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.skinType + this.fighter.bodySubType + "skin.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        this.fighterSkin.setColor(Color.valueOf(this.fighter.skinColor));
        this.fighterBody.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.bodyType + this.fighter.bodySubType + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        this.fighterBody.setColor(Color.valueOf(this.fighter.bodyColor));
        for (int i = 0; i < this.fighterAccessories.size(); ++i) {
            this.fighterAccessories.get(i).setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        StringBuilder chosenAccessories = StringList.create(this.fighter.accessoryTypes, ":");
        for (int i = 0; i < StringList.size(chosenAccessories, ":"); ++i) {
            this.fighterAccessories.get(i).setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/bodycomp" + this.fighter.bodyType + "" + this.fighter.bodySubType + StringList.get(chosenAccessories, i, ":") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterAccessories.get(i).setColor(Color.valueOf(this.fighter.accessoryColor));
        }
        if (this.fighter.head != null && !this.fighter.special.contains("nohel")) {
            this.fighterHead.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.headType + this.fighter.portrait + this.game.stats.get("tiers").getJSONObject(this.fighter.head.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        } else {
            this.fighterHead.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.headType + this.fighter.portrait + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        this.fighterArms.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/arms" + weaponType + suffix + this.fighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        this.fighterArms.setColor(Color.valueOf(this.fighter.skinColor));
        if (this.fighter.arms != null && !this.fighter.special.contains("noarmsarmor")) {
            if (!this.fighter.special.contains("noaasl")) {
                this.fighterArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmssl" + weaponType + suffix + this.fighter.armsType + this.game.stats.get("tiers").getJSONObject(this.fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
            if (!this.fighter.special.contains("noaabra") && !this.fighter.special.contains("noaabrl")) {
                this.fighterArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsbrl" + weaponType + suffix + this.fighter.armsType + this.game.stats.get("tiers").getJSONObject(this.fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
            if (!this.fighter.special.contains("noaabra") && !this.fighter.special.contains("noaabrr")) {
                this.fighterArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsbrr" + weaponType + suffix + this.fighter.armsType + this.game.stats.get("tiers").getJSONObject(this.fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
            if (!this.fighter.special.contains("noaaspa") && !this.fighter.special.contains("noaaspl")) {
                this.fighterArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsspl" + weaponType + suffix + this.fighter.armsType + this.game.stats.get("tiers").getJSONObject(this.fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
            if (!this.fighter.special.contains("noaaspa") && !this.fighter.special.contains("noaaspr")) {
                this.fighterArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorarmsspr" + weaponType + suffix + this.fighter.armsType + this.game.stats.get("tiers").getJSONObject(this.fighter.arms.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
        } else {
            this.fighterArmsArmorSL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterArmsArmorBRL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterArmsArmorBRR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterArmsArmorSPL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterArmsArmorSPR.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        if (this.fighter.body != null) {
            if (!this.fighter.special.contains("nocut")) {
                this.fighterBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + this.fighter.bodyType + this.fighter.bodySubType + this.game.stats.get("tiers").getJSONObject(this.fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
            if (!this.fighter.special.contains("nocul")) {
                this.fighterBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyl" + this.fighter.bodyType + this.fighter.bodySubType + this.game.stats.get("tiers").getJSONObject(this.fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
        } else {
            this.fighterBodyArmorT.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterBodyArmorL.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.fighter.bodyType).getString("skinExtra"), ":"), "body" + this.fighter.bodyType + this.fighter.bodySubType + "skin" + weaponType + suffix, 0, ":") >= 0) {
            this.fighterSkinExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.bodyType + this.fighter.bodySubType + "skin" + weaponType + suffix + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterSkinExtra.setColor(Color.valueOf(this.fighter.skinColor));
            if (this.fighter.body != null && !this.fighter.special.contains("nocut")) {
                this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + this.fighter.bodyType + weaponType + suffix + this.game.stats.get("tiers").getJSONObject(this.fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
        } else {
            this.fighterSkinExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        if (StringList.indexOf(StringList.create(this.game.stats.get("parts").getJSONObject("bodyTypes").getJSONObject(this.fighter.bodyType).getString("bodyExtra"), ":"), "body" + this.fighter.bodyType + weaponType + suffix, 0, ":") >= 0) {
            this.fighterBodyExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/body" + this.fighter.bodyType + weaponType + suffix + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterBodyExtra.setColor(Color.valueOf(this.fighter.bodyColor));
            if (this.fighter.body != null && !this.fighter.special.contains("nocut")) {
                this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/armorbodyt" + this.fighter.bodyType + weaponType + suffix + this.game.stats.get("tiers").getJSONObject(this.fighter.body.tier).getString("imageSuffix") + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            } else {
                this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            }
        } else {
            this.fighterBodyExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
            this.fighterBodyArmorTExtra.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        if (this.fighter.offHand != null) {
            this.fighterOffHand.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.fighter.offHand.id + this.game.stats.get("tiers").getJSONObject(this.fighter.offHand.tier).getString("imageSuffix") + "oh" + suffix + this.fighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        } else {
            this.fighterOffHand.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/empty.png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        }
        if (suffix.equalsIgnoreCase("hit")) {
            suffix = suffix + direction.substring(0, 1);
        }
        this.fighterWeapon.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/figures/" + this.fighter.weapon.id + this.game.stats.get("tiers").getJSONObject(this.fighter.weapon.tier).getString("imageSuffix") + weaponType + suffix + this.fighter.armsType + ".png"), Texture.class), (float)Float.valueOf(this.fighterCharacter.getWidth()).intValue(), (float)Float.valueOf(this.fighterCharacter.getHeight()).intValue());
        this.fighterCharacter.clearActions();
        this.fighterCharacter.setScale(Float.parseFloat(this.fighter.size), Float.parseFloat(this.fighter.size));
    }
}

