/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Equipment;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.game.Story;
import com.calimasaga.slavepits.screen.AIMenuScreen;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.EquipmentMenuScreen;
import com.calimasaga.slavepits.screen.GameMenuScreen;
import com.calimasaga.slavepits.screen.JournalScreen;
import com.calimasaga.slavepits.screen.LexiconScreen;
import com.calimasaga.slavepits.screen.ServicesMenuScreen;
import com.calimasaga.slavepits.screen.TalentsMenuScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.ArrayList;

public class PrepSetupScreen
extends BaseScreen {
    public Fighter hostFighter;
    public int maxReputation;
    public int finalLife;
    public int profits;
    public Label reputationLabel;
    public Label profitsLabel;
    public BaseActor hostNewLifeBar;
    public NinePatchActor nextPanel;
    public Label nextTitle;
    public BaseActor portraitNext;
    public BaseActor portraitLost;
    public BaseActor portraitNextFrame;
    public Label nextName;
    public ScrollPane infoPane;
    public String hostServices = "";
    public Button hostAI;
    public String hostAIbehavior = "parry:50#attack:stamin:own:more:39;attack:stamin:other:less:20;attack:pressu:any:less:40;attack:debuff:any:any:100#use:life:own:less:50;use:pressu:any:less:40";
    Button continueButton;
    public ArrayList<String> backgroundImages = new ArrayList();
    public boolean forceContinue = false;
    public BaseActor blackBackground;
    public NinePatchActor confirmationBackground;
    public Label warningLabel;
    public Button ignoreButton;
    public Button cancelButton;

    public PrepSetupScreen(SlavePitsGame g, int combatLife, int combatProfits) {
        super(g);
        this.hostFighter = Story.getDefaultPlayerFighter(g);
        if (!this.hostFighter.behavior.equalsIgnoreCase("")) {
            this.hostAIbehavior = this.hostFighter.behavior;
        }
        this.maxReputation = Integer.parseInt(this.game.saveGame.get("maxreputation"));
        this.hostFighter.reputation = Fighter.calculateCurrentReputation(this.game, this.hostFighter);
        this.finalLife = combatLife;
        this.profits = combatProfits + (this.game.saveGame.get("rewards").contains("profi2") ? 50 : 0);
        if (this.game.campaignFighter != null) {
            if (this.game.campaignFighter.head != null) {
                this.hostFighter.head = new Equipment();
                this.hostFighter.head.id = "helmet";
                this.hostFighter.head.tier = "wood";
            }
            if (this.game.campaignFighter.arms != null) {
                this.hostFighter.arms = new Equipment();
                this.hostFighter.arms.id = "bracers";
                this.hostFighter.arms.tier = "wood";
            }
            if (this.game.campaignFighter.body != null) {
                this.hostFighter.body = new Equipment();
                this.hostFighter.body.id = "cuirass";
                this.hostFighter.body.tier = "wood";
            }
        }
        Story.applyEarnedRewards(g, this.hostFighter);
        this.create();
    }

    @Override
    public void create() {
        if (this.game.track != null && this.game.track.isPlaying()) {
            this.game.track.stop();
            this.game.track.dispose();
        }
        this.game.track = Gdx.audio.newMusic(Gdx.files.internal(this.game.getOverridenFilename("music/sl04.ogg")));
        this.game.track.setLooping(true);
        this.game.track.setVolume(this.game.musicVolume);
        this.game.track.play();
        String prepInfo = Story.getNextPrepInfo(this.game, this.finalLife, this.profits, new Color(this.game.uiSkin.get("lightiron", Color.class)).mul(0.9f).toString());
        BaseActor background = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, background, this.game.getOverridenFilename("data/backgrounds/" + prepInfo.split("\\$")[4]), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.backgroundImages.add("data/backgrounds/" + prepInfo.split("\\$")[4]);
        this.stage.addActor(background);
        if (prepInfo.split("\\$")[4].equalsIgnoreCase("backgroundPrepColiseum.jpg")) {
            if (this.game.saveGame.get("rewards").contains("suphfo")) {
                BaseActor backgroundext1 = new BaseActor();
                UIHelpers.portraitModeFixBackground(this.game, backgroundext1, this.game.getOverridenFilename("data/backgrounds/backgroundPrepColiseumItem.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
                this.backgroundImages.add("data/backgrounds/backgroundPrepColiseumItem.png");
                this.stage.addActor(backgroundext1);
            }
            if (this.game.saveGame.get("rewards").contains("suphir")) {
                BaseActor backgroundext2 = new BaseActor();
                UIHelpers.portraitModeFixBackground(this.game, backgroundext2, this.game.getOverridenFilename("data/backgrounds/backgroundPrepColiseumUpgrade.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
                this.backgroundImages.add("data/backgrounds/backgroundPrepColiseumUpgrade.png");
                this.stage.addActor(backgroundext2);
            }
            if (this.game.saveGame.get("rewards").contains("suphfi")) {
                BaseActor backgroundext3 = new BaseActor();
                UIHelpers.portraitModeFixBackground(this.game, backgroundext3, this.game.getOverridenFilename("data/backgrounds/backgroundPrepColiseumOther.png"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
                this.backgroundImages.add("data/backgrounds/backgroundPrepColiseumOther.png");
                this.stage.addActor(backgroundext3);
            }
        }
        NinePatchActor masterPanel = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        masterPanel.setWidth(UIHelpers.calcWidthProportion(this.game, 50.0f, 80.0f).floatValue());
        masterPanel.setHeight(UIHelpers.calcHeightProportion(this.game, 30.0f, 30.0f).floatValue());
        masterPanel.setX(UIHelpers.calcWidthProportion(this.game, 30.0f, 50.0f).floatValue() - masterPanel.getWidth() / 2.0f);
        masterPanel.setY(UIHelpers.calcHeightProportion(this.game, 75.0f, 80.0f).floatValue() - masterPanel.getHeight() / 2.0f);
        this.stage.addActor(masterPanel);
        TextureAtlas portraitsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
        BaseActor portraitMaster = new BaseActor();
        portraitMaster.setTexture(portraitsAtlas.findRegion(prepInfo.split("\\$")[0]), UIHelpers.calcHeightProportion(this.game, 20.0f, 15.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 20.0f, 15.0f).floatValue());
        portraitMaster.setX(masterPanel.getX() + masterPanel.getWidth() * 5.0f / 100.0f);
        portraitMaster.setY(masterPanel.getY() + masterPanel.getHeight() / 2.0f - portraitMaster.getHeight() / 2.0f);
        this.stage.addActor(portraitMaster);
        BaseActor portraitMasterFrame = new BaseActor();
        portraitMasterFrame.setTexture(portraitsAtlas.findRegion("portraitframe"), UIHelpers.calcHeightProportion(this.game, 20.0f, 15.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 20.0f, 15.0f).floatValue());
        portraitMasterFrame.setX(masterPanel.getX() + masterPanel.getWidth() * 5.0f / 100.0f);
        portraitMasterFrame.setY(masterPanel.getY() + masterPanel.getHeight() / 2.0f - portraitMasterFrame.getHeight() / 2.0f);
        this.stage.addActor(portraitMasterFrame);
        Label masterLabel = new Label("", this.game.uiSkin, "default");
        masterLabel.setColor(this.game.uiSkin.get("lightiron", Color.class));
        masterLabel.setWrap(true);
        masterLabel.setAlignment(8);
        masterLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        masterLabel.layout();
        masterLabel.setWidth(masterPanel.getWidth() - portraitMasterFrame.getWidth() - masterPanel.getWidth() * 15.0f / 100.0f);
        masterLabel.setText(prepInfo.split("\\$")[1]);
        UIHelpers.fixLabelFontSize(masterLabel, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, masterPanel.getHeight() * 90.0f / 100.0f);
        masterLabel.setX(masterPanel.getX() + masterPanel.getWidth() * 8.0f / 100.0f + UIHelpers.calcHeightProportion(this.game, 20.0f, 15.0f).floatValue());
        masterLabel.setY(masterPanel.getY() + masterPanel.getHeight() / 2.0f - masterLabel.getHeight() / 2.0f);
        this.stage.addActor(masterLabel);
        NinePatchActor advancementPanel = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        advancementPanel.setHeight(UIHelpers.calcHeightProportion(this.game, 25.0f, 25.0f).floatValue());
        advancementPanel.setWidth(UIHelpers.calcHeightProportion(this.game, 40.0f, 40.0f).floatValue());
        advancementPanel.setX(UIHelpers.calcWidthProportion(this.game, 30.0f, 50.0f).floatValue() - advancementPanel.getWidth() / 2.0f);
        advancementPanel.setY(UIHelpers.calcHeightProportion(this.game, 35.0f, 51.5f).floatValue() - advancementPanel.getHeight() / 2.0f);
        this.stage.addActor(advancementPanel);
        this.reputationLabel = new Label(this.hostFighter.reputation + " / " + this.maxReputation, this.game.uiSkin, "default");
        this.reputationLabel.setAlignment(1);
        this.reputationLabel.setColor(Color.RED);
        this.reputationLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.reputationLabel.setWidth(advancementPanel.getWidth() / 3.0f - advancementPanel.getWidth() * 10.0f / 100.0f);
        this.reputationLabel.setX(advancementPanel.getX() + advancementPanel.getWidth() * 39.0f / 100.0f);
        this.reputationLabel.setY(advancementPanel.getY() + advancementPanel.getHeight() * 75.0f / 100.0f - this.reputationLabel.getPrefHeight() / 2.0f);
        this.stage.addActor(this.reputationLabel);
        this.profitsLabel = new Label("" + this.profits, this.game.uiSkin, "default");
        this.profitsLabel.setAlignment(1);
        this.profitsLabel.setColor(this.game.uiSkin.get("iron", Color.class));
        this.profitsLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.profitsLabel.setWidth(advancementPanel.getWidth() / 4.0f);
        this.profitsLabel.setX(advancementPanel.getX() + advancementPanel.getWidth() * 68.0f / 100.0f);
        this.profitsLabel.setY(advancementPanel.getY() + advancementPanel.getHeight() * 75.0f / 100.0f - this.profitsLabel.getPrefHeight() / 2.0f);
        this.stage.addActor(this.profitsLabel);
        BaseActor equipmentBorder = new BaseActor();
        equipmentBorder.setTexture(this.game.uiSkin.getRegion("highlightframe"), UIHelpers.calcHeightProportion(this.game, 10.5f, 10.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.5f, 10.5f).floatValue());
        equipmentBorder.setX(advancementPanel.getX() + advancementPanel.getWidth() * 8.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 0.25f, 0.25f).floatValue());
        equipmentBorder.setY(advancementPanel.getY() + advancementPanel.getHeight() * 20.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 0.25f, 0.25f).floatValue());
        equipmentBorder.setColor(new Color(1.0f, 0.0f, 0.0f, 1.0f));
        equipmentBorder.setVisible(false);
        this.stage.addActor(equipmentBorder);
        SequenceAction highlight = Actions.sequence((Action)Actions.show(), (Action)Actions.repeat(3, Actions.sequence((Action)Actions.color(new Color(1.0f, 1.0f, 1.0f, 1.0f)), (Action)Actions.color(new Color(1.0f, 0.0f, 0.0f, 1.0f), 1.0f))), (Action)Actions.hide());
        equipmentBorder.addAction(highlight);
        Button equipment = new Button(this.game.uiSkin, "equipmentmenu");
        equipment.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                PrepSetupScreen.this.game.equipmentMenuScreen = new EquipmentMenuScreen(PrepSetupScreen.this.game, PrepSetupScreen.this.game.prepSetupScreen, PrepSetupScreen.this.hostFighter, "host", PrepSetupScreen.this.maxReputation);
                PrepSetupScreen.this.game.setScreen(PrepSetupScreen.this.game.equipmentMenuScreen);
            }
        });
        equipment.setWidth(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        equipment.setHeight(equipment.getWidth());
        equipment.setX(advancementPanel.getX() + advancementPanel.getWidth() * 8.0f / 100.0f);
        equipment.setY(advancementPanel.getY() + advancementPanel.getHeight() * 20.0f / 100.0f);
        this.stage.addActor(equipment);
        BaseActor talentBorder = new BaseActor();
        talentBorder.setTexture(this.game.uiSkin.getRegion("highlightframe"), UIHelpers.calcHeightProportion(this.game, 10.5f, 10.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.5f, 10.5f).floatValue());
        talentBorder.setX(advancementPanel.getX() + advancementPanel.getWidth() * 38.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 0.25f, 0.25f).floatValue());
        talentBorder.setY(equipment.getY() - UIHelpers.calcHeightProportion(this.game, 0.25f, 0.25f).floatValue());
        talentBorder.setColor(new Color(1.0f, 0.0f, 0.0f, 1.0f));
        talentBorder.setVisible(false);
        this.stage.addActor(talentBorder);
        if (this.maxReputation - this.hostFighter.reputation >= 100) {
            highlight = Actions.sequence((Action)Actions.show(), (Action)Actions.repeat(3, Actions.sequence((Action)Actions.color(new Color(1.0f, 1.0f, 1.0f, 1.0f)), (Action)Actions.color(new Color(1.0f, 0.0f, 0.0f, 1.0f), 1.0f))), (Action)Actions.hide());
            talentBorder.addAction(highlight);
        }
        Button talent = new Button(this.game.uiSkin, "talentmenu");
        talent.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                PrepSetupScreen.this.game.talentsMenuScreen = new TalentsMenuScreen(PrepSetupScreen.this.game, PrepSetupScreen.this.game.prepSetupScreen, PrepSetupScreen.this.hostFighter, "host", PrepSetupScreen.this.maxReputation, 0, false);
                PrepSetupScreen.this.game.setScreen(PrepSetupScreen.this.game.talentsMenuScreen);
            }
        });
        talent.setWidth(equipment.getWidth());
        talent.setHeight(equipment.getWidth());
        talent.setX(advancementPanel.getX() + advancementPanel.getWidth() * 38.0f / 100.0f);
        talent.setY(equipment.getY());
        this.stage.addActor(talent);
        BaseActor servicesBorder = new BaseActor();
        servicesBorder.setTexture(this.game.uiSkin.getRegion("highlightframe"), UIHelpers.calcHeightProportion(this.game, 10.5f, 10.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.5f, 10.5f).floatValue());
        servicesBorder.setX(advancementPanel.getX() + advancementPanel.getWidth() * 68.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 0.25f, 0.25f).floatValue());
        servicesBorder.setY(equipment.getY() - UIHelpers.calcHeightProportion(this.game, 0.25f, 0.25f).floatValue());
        servicesBorder.setColor(new Color(1.0f, 0.0f, 0.0f, 1.0f));
        servicesBorder.setVisible(false);
        this.stage.addActor(servicesBorder);
        if (this.profits >= 100) {
            highlight = Actions.sequence((Action)Actions.show(), (Action)Actions.repeat(3, Actions.sequence((Action)Actions.color(new Color(1.0f, 1.0f, 1.0f, 1.0f)), (Action)Actions.color(new Color(1.0f, 0.0f, 0.0f, 1.0f), 1.0f))), (Action)Actions.hide());
            servicesBorder.addAction(highlight);
        }
        Button services = new Button(this.game.uiSkin, "servicesmenu");
        services.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                PrepSetupScreen.this.game.servicesMenuScreen = new ServicesMenuScreen(PrepSetupScreen.this.game, PrepSetupScreen.this.game.prepSetupScreen, PrepSetupScreen.this.hostFighter, "host", PrepSetupScreen.this.maxReputation, PrepSetupScreen.this.nextName.getText().toString().toLowerCase(), PrepSetupScreen.this.profits, "");
                PrepSetupScreen.this.game.setScreen(PrepSetupScreen.this.game.servicesMenuScreen);
            }
        });
        services.setWidth(equipment.getWidth());
        services.setHeight(equipment.getWidth());
        services.setX(advancementPanel.getX() + advancementPanel.getWidth() * 68.0f / 100.0f);
        services.setY(equipment.getY());
        this.stage.addActor(services);
        Label labelAI = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.ai") + ":", this.game.uiSkin, "default");
        labelAI.setColor(this.game.uiSkin.get("silver", Color.class));
        labelAI.setAlignment(1);
        labelAI.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        labelAI.setWidth(advancementPanel.getWidth() / 8.0f);
        labelAI.setX(advancementPanel.getX() + advancementPanel.getWidth() * 4.0f / 100.0f);
        labelAI.setY(advancementPanel.getY() + advancementPanel.getHeight() * 75.0f / 100.0f - labelAI.getPrefHeight() / 2.0f);
        this.stage.addActor(labelAI);
        this.hostAI = new Button(this.game.uiSkin, "check");
        this.hostAI.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PrepSetupScreen.this.hostFighter.behavior = PrepSetupScreen.this.hostAI.isChecked() ? PrepSetupScreen.this.hostAIbehavior : "";
            }
        });
        if (!this.hostFighter.behavior.equalsIgnoreCase("")) {
            this.hostAI.setChecked(true);
        }
        this.hostAI.setWidth(UIHelpers.calcHeightProportion(this.game, 3.0f, 3.0f).floatValue());
        this.hostAI.setHeight(this.hostAI.getWidth());
        this.hostAI.setX(advancementPanel.getX() + advancementPanel.getWidth() * 15.0f / 100.0f);
        this.hostAI.setY(advancementPanel.getY() + advancementPanel.getHeight() * 75.0f / 100.0f - this.hostAI.getHeight() / 2.0f);
        this.stage.addActor(this.hostAI);
        Button customAI = new Button(this.game.uiSkin, "aimenu");
        customAI.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                PrepSetupScreen.this.game.AIMenuScreen = new AIMenuScreen(PrepSetupScreen.this.game, PrepSetupScreen.this.game.prepSetupScreen, PrepSetupScreen.this.hostAIbehavior);
                PrepSetupScreen.this.game.setScreen(PrepSetupScreen.this.game.AIMenuScreen);
            }
        });
        customAI.setWidth(this.hostAI.getWidth());
        customAI.setHeight(this.hostAI.getWidth());
        customAI.setX(advancementPanel.getX() + advancementPanel.getWidth() * 25.0f / 100.0f);
        customAI.setY(advancementPanel.getY() + advancementPanel.getHeight() * 75.0f / 100.0f - customAI.getHeight() / 2.0f);
        this.stage.addActor(customAI);
        this.nextPanel = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.nextPanel.setHeight(UIHelpers.calcHeightProportion(this.game, 30.0f, 30.0f).floatValue());
        this.nextPanel.setWidth(this.nextPanel.getHeight());
        this.nextPanel.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - this.nextPanel.getWidth() / 2.0f);
        this.nextPanel.setY(UIHelpers.calcHeightProportion(this.game, 75.0f, 25.0f).floatValue() - this.nextPanel.getHeight() / 2.0f);
        if (this.game.portraitmode) {
            this.nextPanel.setHeight(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
            this.nextPanel.setWidth(this.nextPanel.getHeight());
            this.nextPanel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.nextPanel.getWidth() / 2.0f);
            this.nextPanel.setY(advancementPanel.getY() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue() - UIHelpers.calcHeightProportion(this.game, 13.5f, 13.5f).floatValue() - this.nextPanel.getHeight() / 2.0f);
        }
        this.stage.addActor(this.nextPanel);
        this.nextTitle = new Label("", this.game.uiSkin, "default");
        this.nextTitle.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.nextTitle.setAlignment(1);
        this.nextTitle.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * (float)(this.game.portraitmode ? 4 : 3) / 4.0f));
        this.nextTitle.layout();
        this.nextTitle.setWidth(this.nextPanel.getWidth() * 90.0f / 100.0f);
        this.nextTitle.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.opponent.next"));
        UIHelpers.fixLabelFontSize(this.nextTitle, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), this.nextPanel.getWidth() * 90.0f / 100.0f, 0.0f);
        this.nextTitle.setX(this.nextPanel.getX() + this.nextPanel.getWidth() / 2.0f - this.nextTitle.getWidth() / 2.0f);
        this.nextTitle.setY(this.nextPanel.getY() + this.nextPanel.getHeight() * (float)(this.game.portraitmode ? 85 : 90) / 100.0f - this.nextTitle.getHeight() / 2.0f);
        this.stage.addActor(this.nextTitle);
        this.portraitNext = new BaseActor();
        this.portraitNext.setTexture(portraitsAtlas.findRegion(prepInfo.split("\\$")[2]), UIHelpers.calcHeightProportion(this.game, 20.0f, 13.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 20.0f, 13.0f).floatValue());
        this.portraitNext.setX(this.nextPanel.getX() + this.nextPanel.getWidth() / 2.0f - this.portraitNext.getWidth() / 2.0f);
        this.portraitNext.setY(this.nextPanel.getY() + this.nextPanel.getHeight() / 2.0f - this.portraitNext.getHeight() / 2.0f);
        this.stage.addActor(this.portraitNext);
        this.portraitNextFrame = new BaseActor();
        this.portraitNextFrame.setTexture(portraitsAtlas.findRegion("portraitframe"), UIHelpers.calcHeightProportion(this.game, 20.0f, 13.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 20.0f, 13.0f).floatValue());
        this.portraitNextFrame.setX(this.nextPanel.getX() + this.nextPanel.getWidth() / 2.0f - this.portraitNext.getWidth() / 2.0f);
        this.portraitNextFrame.setY(this.nextPanel.getY() + this.nextPanel.getHeight() / 2.0f - this.portraitNext.getHeight() / 2.0f);
        this.stage.addActor(this.portraitNextFrame);
        TextureAtlas combatButtonsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/combatbuttons.atlas"), TextureAtlas.class);
        this.portraitLost = new BaseActor();
        this.portraitLost.setTexture(combatButtonsAtlas.findRegion("assaultindex"), UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 2.5f, 2.5f).floatValue());
        this.portraitLost.setX(this.portraitNextFrame.getX() + this.portraitNextFrame.getWidth() * 90.0f / 100.0f - this.portraitLost.getWidth());
        this.portraitLost.setY(this.portraitNextFrame.getY() + this.portraitNextFrame.getHeight() * 90.0f / 100.0f - this.portraitLost.getHeight());
        this.portraitLost.setColor(new Color(0.7f, 0.0f, 0.0f, 1.0f));
        this.portraitLost.rotateBy(180.0f);
        this.portraitLost.setOrigin(this.portraitLost.getWidth() / 2.0f, this.portraitLost.getHeight() / 2.0f);
        this.portraitLost.setVisible(Integer.parseInt(this.game.saveGame.get("lost")) > 0);
        this.stage.addActor(this.portraitLost);
        this.nextName = new Label("", this.game.uiSkin, "default");
        this.nextName.setColor(this.game.uiSkin.get("lightiron", Color.class));
        this.nextName.setAlignment(1);
        this.nextName.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.nextName.layout();
        this.nextName.setWidth(this.nextPanel.getWidth() * 90.0f / 100.0f);
        this.nextName.setText(prepInfo.split("\\$")[3].substring(0, 1).toUpperCase() + prepInfo.split("\\$")[3].substring(1));
        UIHelpers.fixLabelFontSize(this.nextName, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), this.nextPanel.getWidth() * 90.0f / 100.0f, 0.0f);
        this.nextName.setX(this.nextPanel.getX() + this.nextPanel.getWidth() / 2.0f - this.nextName.getWidth() / 2.0f);
        this.nextName.setY(this.nextPanel.getY() + this.nextPanel.getHeight() * (float)(this.game.portraitmode ? 15 : 10) / 100.0f - this.nextName.getHeight() / 2.0f);
        this.stage.addActor(this.nextName);
        Label nextInfoLabel = new Label(prepInfo.split("\\$")[5], this.game.uiSkin, "default");
        nextInfoLabel.setAlignment(10);
        nextInfoLabel.setColor(this.game.uiSkin.get("lightiron", Color.class));
        nextInfoLabel.setWrap(true);
        nextInfoLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        nextInfoLabel.setWidth(UIHelpers.calcWidthProportion(this.game, 30.0f, 30.0f).floatValue());
        this.stage.addActor(nextInfoLabel);
        this.infoPane = new ScrollPane((Actor)nextInfoLabel, this.game.uiSkin, "chat");
        this.infoPane.setForceScroll(true, true);
        this.infoPane.setFlickScroll(false);
        this.infoPane.setOverscroll(false, true);
        this.infoPane.setWidth(UIHelpers.calcWidthProportion(this.game, 40.0f, 60.0f).floatValue());
        this.infoPane.setHeight(UIHelpers.calcHeightProportion(this.game, 35.0f, 30.0f).floatValue());
        this.infoPane.setX(UIHelpers.calcWidthProportion(this.game, 55.0f, 50.0f).floatValue());
        this.infoPane.setY(UIHelpers.calcHeightProportion(this.game, 35.0f, 30.0f).floatValue() - this.infoPane.getHeight() / 2.0f);
        if (this.game.portraitmode) {
            this.infoPane.setHeight(UIHelpers.calcHeightProportion(this.game, 27.0f, 27.0f).floatValue());
            this.infoPane.setY(UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
            this.infoPane.setX(UIHelpers.calcWidthProportion(this.game, 5.0f, 5.0f).floatValue() + this.nextPanel.getWidth());
        }
        this.infoPane.getStyle().vScroll.setMinWidth(UIHelpers.calcHeightProportion(this.game, 2.55f, 2.55f).floatValue());
        this.infoPane.getStyle().vScrollKnob.setMinWidth(UIHelpers.calcHeightProportion(this.game, 2.55f, 2.55f).floatValue());
        this.stage.addActor(this.infoPane);
        this.infoPane.layout();
        if (this.hostFighter.services.contains("info")) {
            this.moveNextPane();
            this.infoPane.setVisible(true);
        } else {
            this.infoPane.setVisible(false);
        }
        Button journalButton = new Button(this.game.uiSkin, "journal");
        journalButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                PrepSetupScreen.this.game.journalScreen = new JournalScreen(PrepSetupScreen.this.game, PrepSetupScreen.this.game.prepSetupScreen);
                PrepSetupScreen.this.game.setScreen(PrepSetupScreen.this.game.journalScreen);
            }
        });
        journalButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        journalButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        journalButton.setX(UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        journalButton.setY(UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.stage.addActor(journalButton);
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        BaseActor baseLifeBarHost = new BaseActor();
        baseLifeBarHost.setTexture(uiAtlas.findRegion("statbar"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        baseLifeBarHost.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - baseLifeBarHost.getWidth() / 2.0f);
        baseLifeBarHost.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue() - baseLifeBarHost.getHeight() / 2.0f);
        this.stage.addActor(baseLifeBarHost);
        BaseActor hostLifeBarMax = new BaseActor();
        hostLifeBarMax.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        hostLifeBarMax.getColor().a = 0.4f;
        hostLifeBarMax.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - baseLifeBarHost.getWidth() / 2.0f);
        hostLifeBarMax.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue() - baseLifeBarHost.getHeight() / 2.0f);
        this.stage.addActor(hostLifeBarMax);
        this.hostNewLifeBar = new BaseActor();
        this.hostNewLifeBar.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.finalLife / 10000.0f, UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        this.hostNewLifeBar.regionWidth = Float.valueOf((float)(200 * this.finalLife) / 10000.0f).intValue();
        this.calculateFinalLife(false);
        this.hostNewLifeBar.setColor(1.0f, 0.5f, 0.5f, 1.0f);
        this.hostNewLifeBar.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - baseLifeBarHost.getWidth() / 2.0f);
        this.hostNewLifeBar.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue() - baseLifeBarHost.getHeight() / 2.0f);
        this.stage.addActor(this.hostNewLifeBar);
        BaseActor hostLifeBar = new BaseActor();
        hostLifeBar.setTexture(uiAtlas.findRegion("statbarfill"), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)this.finalLife / 10000.0f, UIHelpers.calcHeightProportion(this.game, 3.35f, 3.35f).floatValue());
        hostLifeBar.regionWidth = Float.valueOf((float)(200 * this.finalLife) / 10000.0f).intValue();
        hostLifeBar.setColor(1.0f, 0.0f, 0.0f, 1.0f);
        hostLifeBar.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - baseLifeBarHost.getWidth() / 2.0f);
        hostLifeBar.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue() - baseLifeBarHost.getHeight() / 2.0f);
        this.stage.addActor(hostLifeBar);
        this.continueButton = new Button(this.game.uiSkin, "next");
        this.continueButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (!PrepSetupScreen.this.forceContinue && (PrepSetupScreen.this.hostFighter.weapon.id.equalsIgnoreCase("dagger") || PrepSetupScreen.this.hostFighter.reputation < PrepSetupScreen.this.maxReputation - 100 || PrepSetupScreen.this.profits > 100)) {
                    PrepSetupScreen.this.blackBackground.setVisible(true);
                    PrepSetupScreen.this.confirmationBackground.setVisible(true);
                    PrepSetupScreen.this.warningLabel.setVisible(true);
                    PrepSetupScreen.this.ignoreButton.setVisible(true);
                    PrepSetupScreen.this.cancelButton.setVisible(true);
                } else {
                    PrepSetupScreen.this.calculateFinalLife(true);
                    PrepSetupScreen.this.game.campaignFighter = PrepSetupScreen.this.hostFighter;
                    PrepSetupScreen.this.game.saveGame.put("aftermatch", Story.getNextColiseumRanking(PrepSetupScreen.this.game));
                    Story.getNextScreen(PrepSetupScreen.this.game, "prep", "");
                    PrepSetupScreen.this.dispose();
                }
            }
        });
        this.continueButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.continueButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.continueButton.setX(this.game.viewWidth.floatValue() - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue() - this.continueButton.getWidth());
        this.continueButton.setY(UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.stage.addActor(this.continueButton);
        this.blackBackground = new BaseActor();
        this.blackBackground.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/overlay.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
        this.blackBackground.setColor(new Color(0.0f, 0.0f, 0.0f, 1.0f));
        this.blackBackground.setPosition(0.0f, 0.0f);
        this.blackBackground.setVisible(false);
        this.stage.addActor(this.blackBackground);
        this.confirmationBackground = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.confirmationBackground.setVisible(false);
        this.confirmationBackground.setWidth(UIHelpers.calcHeightProportion(this.game, 60.0f, 50.0f).floatValue());
        this.confirmationBackground.setHeight(UIHelpers.calcHeightProportion(this.game, 50.0f, 40.0f).floatValue());
        this.confirmationBackground.setPosition(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.confirmationBackground.getWidth() / 2.0f, UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue() - this.confirmationBackground.getHeight() / 2.0f);
        this.stage.addActor(this.confirmationBackground);
        this.warningLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.stats.warning") + "?", this.game.uiSkin, "default");
        this.warningLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.warningLabel.setWrap(true);
        this.warningLabel.setAlignment(1);
        this.warningLabel.setVisible(false);
        this.warningLabel.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        this.warningLabel.setWidth(this.confirmationBackground.getWidth() * 80.0f / 100.0f);
        this.warningLabel.layout();
        this.warningLabel.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() / 2.0f - this.warningLabel.getWidth() / 2.0f);
        this.warningLabel.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 65.0f / 100.0f - this.warningLabel.getHeight() / 2.0f);
        this.stage.addActor(this.warningLabel);
        this.ignoreButton = new Button(this.game.uiSkin, "ok");
        this.ignoreButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                PrepSetupScreen.this.forceContinue = true;
                InputEvent newEvent = new InputEvent();
                newEvent.setType(InputEvent.Type.touchUp);
                PrepSetupScreen.this.continueButton.fire(newEvent);
            }
        });
        this.ignoreButton.setVisible(false);
        this.ignoreButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.ignoreButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.ignoreButton.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() * 47.0f / 100.0f - this.ignoreButton.getWidth());
        this.ignoreButton.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 10.0f / 100.0f);
        this.stage.addActor(this.ignoreButton);
        this.cancelButton = new Button(this.game.uiSkin, "cancel");
        this.cancelButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                PrepSetupScreen.this.blackBackground.setVisible(false);
                PrepSetupScreen.this.confirmationBackground.setVisible(false);
                PrepSetupScreen.this.warningLabel.setVisible(false);
                PrepSetupScreen.this.ignoreButton.setVisible(false);
                PrepSetupScreen.this.cancelButton.setVisible(false);
            }
        });
        this.cancelButton.setVisible(false);
        this.cancelButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.cancelButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.cancelButton.setX(this.confirmationBackground.getX() + this.confirmationBackground.getWidth() * 53.0f / 100.0f);
        this.cancelButton.setY(this.confirmationBackground.getY() + this.confirmationBackground.getHeight() * 10.0f / 100.0f);
        this.stage.addActor(this.cancelButton);
        Label lexiconLabel = new Label(this.game.input.equalsIgnoreCase("keyboard") ? PropertiesReader.getMessage(this.game.gameMessages, "lexicon.key") : PropertiesReader.getMessage(this.game.gameMessages, "lexicon.touch"), this.game.uiSkin, "default");
        lexiconLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        lexiconLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        lexiconLabel.setPosition(UIHelpers.calcWidthProportion(this.game, 99.0f, 99.0f).floatValue() - lexiconLabel.getPrefWidth(), this.game.viewHeight.floatValue() - lexiconLabel.getPrefHeight());
        lexiconLabel.layout();
        lexiconLabel.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                PrepSetupScreen.this.game.lexiconScreen = new LexiconScreen(PrepSetupScreen.this.game, PrepSetupScreen.this.game.prepSetupScreen);
                PrepSetupScreen.this.game.setScreen(PrepSetupScreen.this.game.lexiconScreen);
            }
        });
        this.stage.addActor(lexiconLabel);
        if (!this.game.input.equalsIgnoreCase("keyboard")) {
            Button menuButton = new Button(this.game.uiSkin, "menu");
            menuButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            menuButton.setHeight(menuButton.getWidth());
            menuButton.setX(10.0f);
            menuButton.setY(this.game.viewHeight.floatValue() - menuButton.getWidth() - 10.0f);
            menuButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    PrepSetupScreen.this.game.gameMenuScreen = new GameMenuScreen(PrepSetupScreen.this.game, PrepSetupScreen.this.game.prepSetupScreen);
                    PrepSetupScreen.this.game.setScreen(PrepSetupScreen.this.game.gameMenuScreen);
                }
            });
            menuButton.setVisible(true);
            this.stage.addActor(menuButton);
        }
    }

    @Override
    public void render(float delta) {
        this.game.manager.update();
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public void dispose() {
        for (String currBackground : this.backgroundImages) {
            UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset(currBackground));
        }
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4 || keycode == 82) {
            this.game.gameMenuScreen = new GameMenuScreen(this.game, this);
            this.game.setScreen(this.game.gameMenuScreen);
        } else if (keycode == 244) {
            this.game.lexiconScreen = new LexiconScreen(this.game, this.game.prepSetupScreen);
            this.game.setScreen(this.game.lexiconScreen);
        } else if (keycode == Input.Keys.valueOf(this.game.nextkey)) {
            if (this.ignoreButton != null && this.ignoreButton.isVisible()) {
                InputEvent event = new InputEvent();
                event.setType(InputEvent.Type.touchUp);
                this.ignoreButton.fire(event);
                return true;
            }
            if (this.continueButton != null && this.continueButton.isVisible()) {
                InputEvent event = new InputEvent();
                event.setType(InputEvent.Type.touchUp);
                this.continueButton.fire(event);
                return true;
            }
        }
        return false;
    }

    public void moveNextPane() {
        if (this.game.portraitmode) {
            this.nextPanel.setX(UIHelpers.calcWidthProportion(this.game, 5.0f, 5.0f).floatValue());
            this.nextTitle.setX(this.nextPanel.getX() + this.nextPanel.getWidth() / 2.0f - this.nextTitle.getWidth() / 2.0f);
            this.portraitNext.setX(this.nextPanel.getX() + this.nextPanel.getWidth() / 2.0f - this.portraitNext.getWidth() / 2.0f);
            this.portraitNextFrame.setX(this.nextPanel.getX() + this.nextPanel.getWidth() / 2.0f - this.portraitNext.getWidth() / 2.0f);
            this.portraitLost.setX(this.portraitNextFrame.getX() + this.portraitNextFrame.getWidth() * 90.0f / 100.0f - this.portraitLost.getWidth());
            this.portraitLost.setY(this.portraitNextFrame.getY() + this.portraitNextFrame.getHeight() * 90.0f / 100.0f - this.portraitLost.getHeight());
            this.nextName.setX(this.nextPanel.getX() + this.nextPanel.getWidth() / 2.0f - this.nextName.getWidth() / 2.0f);
        }
    }

    public void calculateFinalLife(boolean assign) {
        Integer calculatedLife = this.hostFighter.life;
        if (this.game.saveGame.get("phase").equalsIgnoreCase("pits")) {
            calculatedLife = Math.min(this.hostFighter.life + 3000 + (this.hostFighter.services.contains("care") ? 5000 : 0), this.hostFighter.maxLife);
        } else if (this.game.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            calculatedLife = Math.min(this.hostFighter.life + 2500 + (this.hostFighter.services.contains("care") ? 3500 : 0), this.hostFighter.maxLife);
        } else if (this.game.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            calculatedLife = Math.min(this.hostFighter.life + 2500 + (this.hostFighter.services.contains("care") ? 3500 : 0) + (this.game.saveGame.get("rewards").contains("healin") ? 1000 : 0), this.hostFighter.maxLife);
        }
        this.hostNewLifeBar.setWidth(UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() * (float)calculatedLife.intValue() / 10000.0f);
        this.hostNewLifeBar.regionWidth = Float.valueOf((float)(200 * calculatedLife) / 10000.0f).intValue();
        if (assign) {
            this.hostFighter.life = calculatedLife;
        }
    }
}

