/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.utils.Array;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.DuelSetupScreen;
import com.calimasaga.slavepits.screen.TournamentGameScreen;
import com.calimasaga.slavepits.util.PropertiesReader;

public class PortraitsMenuScreen
extends BaseScreen {
    private BaseScreen previousScreen;
    public String owner;

    public PortraitsMenuScreen(SlavePitsGame g, BaseScreen s, String selectedPortrait) {
        super(g);
        this.previousScreen = s;
        this.owner = selectedPortrait;
        this.create();
    }

    @Override
    public void create() {
        TextureAtlas portraitsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
        Array<TextureAtlas.AtlasRegion> allPortraits = portraitsAtlas.getRegions();
        int rowCount = this.game.portraitmode ? 8 : 5;
        int columnCount = this.game.portraitmode ? 6 : 8;
        float iconSize = (this.game.portraitmode ? this.game.viewWidth : this.game.viewHeight).floatValue() / (float)(this.game.portraitmode ? columnCount + 1 : rowCount + 1);
        int numPortrait = 0;
        for (TextureAtlas.AtlasRegion currPortrait : allPortraits) {
            if (currPortrait.name.equalsIgnoreCase("portraitframe") || currPortrait.name.equalsIgnoreCase("portraitframeoutline") || currPortrait.name.equalsIgnoreCase("peiko") || currPortrait.name.equalsIgnoreCase("plaura") || currPortrait.name.equalsIgnoreCase("ptam") || currPortrait.name.equalsIgnoreCase("punknown") || currPortrait.name.equalsIgnoreCase("pcaravanmaster") || currPortrait.name.equalsIgnoreCase("ppitsmaster") || !PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum).equalsIgnoreCase("extra") && (currPortrait.name.equalsIgnoreCase("p01") || currPortrait.name.equalsIgnoreCase("p02") || currPortrait.name.equalsIgnoreCase("p03") || currPortrait.name.equalsIgnoreCase("p41") || currPortrait.name.equalsIgnoreCase("p42") || currPortrait.name.equalsIgnoreCase("p43")) || PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum).equalsIgnoreCase("free") && !currPortrait.name.equalsIgnoreCase("p00") && !currPortrait.name.equalsIgnoreCase("p04") && !currPortrait.name.equalsIgnoreCase("p11") && !currPortrait.name.equalsIgnoreCase("p12") && !currPortrait.name.equalsIgnoreCase("p13") && !currPortrait.name.equalsIgnoreCase("p14") && !currPortrait.name.equalsIgnoreCase("p15") && !currPortrait.name.equalsIgnoreCase("p16") && !currPortrait.name.equalsIgnoreCase("p17") && !currPortrait.name.equalsIgnoreCase("p18") && !currPortrait.name.equalsIgnoreCase("p19") && !currPortrait.name.equalsIgnoreCase("p20")) continue;
            BaseActor newPortrait = new BaseActor();
            newPortrait.setTexture(currPortrait, iconSize, iconSize);
            newPortrait.setPosition((this.game.viewWidth.floatValue() - iconSize * (float)columnCount) / 2.0f + iconSize * (float)(numPortrait % columnCount), this.game.viewHeight.floatValue() - iconSize * (float)(numPortrait / columnCount + 1) - iconSize / 2.0f - (this.game.portraitmode ? iconSize * 2.0f / 3.0f : 0.0f));
            newPortrait.params.put("name", currPortrait.name);
            newPortrait.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    BaseActor eventActor = (BaseActor)event.getListenerActor();
                    String portraitName = (String)eventActor.params.get("name");
                    if (PortraitsMenuScreen.this.previousScreen instanceof DuelSetupScreen) {
                        if (PortraitsMenuScreen.this.owner.equalsIgnoreCase("host")) {
                            ((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).hostFighter = Fighter.changeAppearance(PortraitsMenuScreen.this.game, portraitName, ((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).hostFighter, false, true);
                            ((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImageP1.setTexture(eventActor.region, (float)Float.valueOf(((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImageP1.getWidth()).intValue(), (float)Float.valueOf(((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImageP1.getHeight()).intValue());
                            ((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImageP1.params.put("name", portraitName);
                        } else {
                            ((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).clientFighter = Fighter.changeAppearance(PortraitsMenuScreen.this.game, portraitName, ((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).clientFighter, false, true);
                            ((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImageP2.setTexture(eventActor.region, (float)Float.valueOf(((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImageP2.getWidth()).intValue(), (float)Float.valueOf(((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImageP2.getHeight()).intValue());
                            ((DuelSetupScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImageP2.params.put("name", portraitName);
                        }
                        ((DuelSetupScreen)PortraitsMenuScreen.this.previousScreen).sendMessage("change", "");
                    } else if (PortraitsMenuScreen.this.previousScreen instanceof TournamentGameScreen) {
                        ((TournamentGameScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).fighter = Fighter.changeAppearance(PortraitsMenuScreen.this.game, portraitName, ((TournamentGameScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).fighter, true, false);
                        ((TournamentGameScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImage.setTexture(eventActor.region, (float)Float.valueOf(((TournamentGameScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImage.getWidth()).intValue(), (float)Float.valueOf(((TournamentGameScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImage.getHeight()).intValue());
                        ((TournamentGameScreen)((PortraitsMenuScreen)PortraitsMenuScreen.this).previousScreen).portraitImage.params.put("name", portraitName);
                    }
                    PortraitsMenuScreen.this.game.setScreen(PortraitsMenuScreen.this.previousScreen);
                }
            });
            this.stage.addActor(newPortrait);
            ++numPortrait;
        }
    }

    @Override
    public void render(float delta) {
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.1f, 0.1f, 0.1f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }
}

