/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.SelectBoxFontScaling;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.LoadingScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.util.Logger;
import com.calimasaga.slavepits.util.PropertiesReader;

public class OptionsMenuScreen
extends BaseScreen {
    public float tsp = 5.0f;
    public float sp = 4.25f;
    private boolean inGame = false;
    private boolean restart = false;
    private SelectBoxFontScaling<String> languageSelect;
    private SelectBoxFontScaling<String> resolutionSelect;
    private Button portraitMode;
    private Button fullscreenCheck;
    private SelectBoxFontScaling<String> inputSelect;
    private Slider musicSlider;
    private SelectBoxFontScaling<String> tracks;
    private Slider soundSlider;
    private Button violenceCheck;
    private Button debugMode;
    private Button retroMode;
    private Label nextkey;
    private Label upmiddlekey;
    private Label upleftkey;
    private Label uprightkey;
    private Label leftkey;
    private Label rightkey;
    private Label usekey;
    private Label surgekey;
    private float soundBlocked = 100.0f;
    private Label listenKeyLabel;

    public OptionsMenuScreen(SlavePitsGame g, boolean gameRunning) {
        super(g);
        this.inGame = gameRunning;
        this.create();
    }

    @Override
    public void create() {
        String languageSelected = this.game.settings.getProperty("language", "en");
        Label languageLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.language") + ":", this.game.uiSkin, "default");
        languageLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        languageLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        languageLabel.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - languageLabel.getPrefWidth());
        languageLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp, 100.0f - this.tsp).floatValue() - languageLabel.getHeight() / 2.0f);
        this.stage.addActor(languageLabel);
        this.languageSelect = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String[] availableLanguages = new String[]{PropertiesReader.getMessage(this.game.gameMessages, "options.language.cat") + "-cat", PropertiesReader.getMessage(this.game.gameMessages, "options.language.en") + "-en", PropertiesReader.getMessage(this.game.gameMessages, "options.language.es") + "-es"};
        this.languageSelect.setItems((String[])availableLanguages);
        this.languageSelect.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "options.language." + languageSelected) + "-" + languageSelected);
        this.languageSelect.setWidth(this.languageSelect.getPrefWidth());
        this.languageSelect.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.languageSelect.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp, 100.0f - this.tsp).floatValue() - this.languageSelect.getHeight() / 2.0f);
        this.stage.addActor(this.languageSelect);
        String resolutionSelected = this.game.settings.getProperty("resolution", "1440x1080");
        Label resolutionLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.resolution") + ":", this.game.uiSkin, "default");
        resolutionLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        resolutionLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        resolutionLabel.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - resolutionLabel.getPrefWidth());
        resolutionLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp, 100.0f - this.tsp - this.sp).floatValue() - resolutionLabel.getHeight() / 2.0f);
        this.stage.addActor(resolutionLabel);
        this.resolutionSelect = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String[] availableResolutions = new String[]{"1366x768", "1440x1080", "1680x1050", "1600x1200", "1920x1080"};
        this.resolutionSelect.setItems((String[])availableResolutions);
        this.resolutionSelect.setSelected(resolutionSelected);
        this.resolutionSelect.setWidth(this.languageSelect.getPrefWidth());
        this.resolutionSelect.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.resolutionSelect.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp, 100.0f - this.tsp - this.sp).floatValue() - this.resolutionSelect.getHeight() / 2.0f);
        this.stage.addActor(this.resolutionSelect);
        Label portraitModeLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.portraitmode") + ":", this.game.uiSkin, "default");
        portraitModeLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        portraitModeLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        portraitModeLabel.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - portraitModeLabel.getPrefWidth());
        portraitModeLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 2.0f, 100.0f - this.tsp - this.sp * 2.0f).floatValue() - portraitModeLabel.getHeight() / 2.0f);
        this.stage.addActor(portraitModeLabel);
        this.portraitMode = new Button(this.game.uiSkin, "check");
        if (!this.portraitMode.isChecked() && this.game.settings.getProperty("portraitmode").equalsIgnoreCase("true")) {
            this.portraitMode.setChecked(true);
        }
        this.portraitMode.setWidth(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.portraitMode.setHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.portraitMode.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.portraitMode.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 2.0f, 100.0f - this.tsp - this.sp * 2.0f).floatValue() - this.portraitMode.getHeight() / 2.0f);
        this.stage.addActor(this.portraitMode);
        Label fullscreenLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.fullscreen") + ":", this.game.uiSkin, "default");
        fullscreenLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        fullscreenLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        fullscreenLabel.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - fullscreenLabel.getPrefWidth());
        fullscreenLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 3.0f, 100.0f - this.tsp - this.sp * 3.0f).floatValue() - fullscreenLabel.getHeight() / 2.0f);
        this.stage.addActor(fullscreenLabel);
        this.fullscreenCheck = new Button(this.game.uiSkin, "check");
        if (!this.fullscreenCheck.isChecked() && this.game.settings.getProperty("fullscreen").equalsIgnoreCase("true")) {
            this.fullscreenCheck.setChecked(true);
        }
        this.fullscreenCheck.setWidth(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.fullscreenCheck.setHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.fullscreenCheck.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.fullscreenCheck.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 3.0f, 100.0f - this.tsp - this.sp * 3.0f).floatValue() - this.fullscreenCheck.getHeight() / 2.0f);
        this.stage.addActor(this.fullscreenCheck);
        String inputSelected = this.game.settings.getProperty("input", "keyboard");
        Label inputLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.input") + ":", this.game.uiSkin, "default");
        inputLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        inputLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        inputLabel.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - inputLabel.getPrefWidth());
        inputLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 4.0f, 100.0f - this.tsp - this.sp * 4.0f).floatValue() - inputLabel.getHeight() / 2.0f);
        this.stage.addActor(inputLabel);
        this.inputSelect = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String[] availableInputs = new String[]{PropertiesReader.getMessage(this.game.gameMessages, "options.input.keyboard"), PropertiesReader.getMessage(this.game.gameMessages, "options.input.mouse"), PropertiesReader.getMessage(this.game.gameMessages, "options.input.touch")};
        this.inputSelect.setItems((String[])availableInputs);
        this.inputSelect.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "options.input." + inputSelected));
        this.inputSelect.setWidth(this.inputSelect.getPrefWidth());
        this.inputSelect.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.inputSelect.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 4.0f, 100.0f - this.tsp - this.sp * 4.0f).floatValue() - this.inputSelect.getHeight() / 2.0f);
        this.stage.addActor(this.inputSelect);
        Label musicLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.music.volume") + ":", this.game.uiSkin, "default");
        musicLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        musicLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        musicLabel.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - musicLabel.getPrefWidth());
        musicLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 5.0f, 100.0f - this.tsp - this.sp * 5.0f).floatValue() - musicLabel.getHeight() / 2.0f);
        this.stage.addActor(musicLabel);
        this.musicSlider = new Slider(0.0f, 1.0f, 0.05f, false, this.game.uiSkin, "default-horizontal");
        this.musicSlider.setValue(this.game.musicVolume * 2.0f);
        this.musicSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                OptionsMenuScreen.this.game.track.setVolume(OptionsMenuScreen.this.musicSlider.getValue() / 2.0f);
            }
        });
        this.musicSlider.setWidth(UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue());
        this.musicSlider.setHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.musicSlider.getStyle().background.setMinHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.musicSlider.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.musicSlider.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 5.0f, 100.0f - this.tsp - this.sp * 5.0f).floatValue() - this.musicSlider.getHeight() / 2.0f);
        this.stage.addActor(this.musicSlider);
        if (PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum).equalsIgnoreCase("extra") && !this.inGame) {
            String[] availableTracks = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17"};
            this.tracks = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 12.75f, 12.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
            this.tracks.setItems((String[])availableTracks);
            this.tracks.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "1"));
            this.tracks.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (OptionsMenuScreen.this.game.track != null && OptionsMenuScreen.this.game.track.isPlaying()) {
                        OptionsMenuScreen.this.game.track.stop();
                        OptionsMenuScreen.this.game.track.dispose();
                    }
                    OptionsMenuScreen.this.game.track = Gdx.audio.newMusic(Gdx.files.internal(OptionsMenuScreen.this.game.getOverridenFilename("music/sl" + String.format("%02d", Integer.parseInt((String)OptionsMenuScreen.this.tracks.getSelected())) + ".ogg")));
                    OptionsMenuScreen.this.game.track.setLooping(true);
                    OptionsMenuScreen.this.game.track.play();
                }
            });
            this.tracks.setWidth(this.tracks.getPrefWidth());
            this.tracks.setX(this.musicSlider.getX() + this.musicSlider.getWidth() + UIHelpers.calcWidthProportion(this.game, 2.0f, 2.0f).floatValue());
            this.tracks.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 5.0f, 100.0f - this.tsp - this.sp * 5.0f).floatValue() - this.tracks.getHeight() / 2.0f);
            this.stage.addActor(this.tracks);
        }
        Label soundLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.sound.volume") + ":", this.game.uiSkin, "default");
        soundLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        soundLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        soundLabel.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - soundLabel.getPrefWidth());
        soundLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 6.0f, 100.0f - this.tsp - this.sp * 6.0f).floatValue() - soundLabel.getHeight() / 2.0f);
        this.stage.addActor(soundLabel);
        this.soundSlider = new Slider(0.0f, 1.0f, 0.05f, false, this.game.uiSkin, "default-horizontal");
        this.soundSlider.setValue(this.game.soundVolume);
        this.soundSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (OptionsMenuScreen.this.soundBlocked == 0.0f) {
                    OptionsMenuScreen.this.soundBlocked = 100.0f;
                    OptionsMenuScreen.this.game.manager.get("sound/whipcrack.ogg", Sound.class).play(OptionsMenuScreen.this.soundSlider.getValue());
                }
            }
        });
        this.soundSlider.setWidth(UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue());
        this.soundSlider.setHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.soundSlider.getStyle().background.setMinHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.soundSlider.getStyle().knob.setMinHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.soundSlider.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.soundSlider.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 6.0f, 100.0f - this.tsp - this.sp * 6.0f).floatValue() - this.soundSlider.getHeight() / 2.0f);
        this.stage.addActor(this.soundSlider);
        Label violenceLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.violence.filter") + ":", this.game.uiSkin, "default");
        violenceLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        violenceLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        violenceLabel.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - violenceLabel.getPrefWidth());
        violenceLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 7.0f, 100.0f - this.tsp - this.sp * 7.0f).floatValue() - violenceLabel.getHeight() / 2.0f);
        this.stage.addActor(violenceLabel);
        this.violenceCheck = new Button(this.game.uiSkin, "check");
        if (!this.violenceCheck.isChecked() && this.game.settings.getProperty("violencefilter").equalsIgnoreCase("true")) {
            this.violenceCheck.setChecked(true);
        }
        this.violenceCheck.setWidth(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.violenceCheck.setHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.violenceCheck.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.violenceCheck.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 7.0f, 100.0f - this.tsp - this.sp * 7.0f).floatValue() - this.violenceCheck.getHeight() / 2.0f);
        this.stage.addActor(this.violenceCheck);
        Label debugLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.debug.mode") + ":", this.game.uiSkin, "default");
        debugLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        debugLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        debugLabel.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - debugLabel.getPrefWidth());
        debugLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 8.0f, 100.0f - this.tsp - this.sp * 8.0f).floatValue() - debugLabel.getHeight() / 2.0f);
        this.stage.addActor(debugLabel);
        this.debugMode = new Button(this.game.uiSkin, "check");
        if (!this.debugMode.isChecked() && this.game.settings.getProperty("debugmode", "false").equalsIgnoreCase("true")) {
            this.debugMode.setChecked(true);
        }
        this.debugMode.setWidth(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.debugMode.setHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.debugMode.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.debugMode.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 8.0f, 100.0f - this.tsp - this.sp * 8.0f).floatValue() - this.debugMode.getHeight() / 2.0f);
        this.stage.addActor(this.debugMode);
        if (this.inGame) {
            debugLabel.setVisible(false);
            this.debugMode.setVisible(false);
        }
        Label retroLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.retro.mode") + ":", this.game.uiSkin, "default");
        retroLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        retroLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        retroLabel.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - retroLabel.getPrefWidth());
        retroLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 9.0f, 100.0f - this.tsp - this.sp * 9.0f).floatValue() - retroLabel.getHeight() / 2.0f);
        this.stage.addActor(retroLabel);
        this.retroMode = new Button(this.game.uiSkin, "check");
        if (!this.retroMode.isChecked() && this.game.settings.getProperty("retromode", "false").equalsIgnoreCase("true")) {
            this.retroMode.setChecked(true);
        }
        this.retroMode.setWidth(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.retroMode.setHeight(UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue());
        this.retroMode.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.retroMode.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 9.0f, 100.0f - this.tsp - this.sp * 9.0f).floatValue() - this.retroMode.getHeight() / 2.0f);
        this.stage.addActor(this.retroMode);
        if (this.inGame) {
            retroLabel.setVisible(false);
            this.retroMode.setVisible(false);
        }
        Label upmiddle = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.key.upmiddle") + ":", this.game.uiSkin, "default");
        upmiddle.setColor(this.game.uiSkin.get("silver", Color.class));
        upmiddle.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        upmiddle.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - upmiddle.getPrefWidth());
        upmiddle.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 11.0f, 100.0f - this.tsp - this.sp * 11.0f).floatValue() - upmiddle.getHeight() / 2.0f);
        this.stage.addActor(upmiddle);
        this.upmiddlekey = new Label(this.game.settings.getProperty("key.upmiddle"), this.game.uiSkin, "default");
        this.upmiddlekey.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                OptionsMenuScreen.this.listenKeyLabel = (Label)event.getListenerActor();
                OptionsMenuScreen.this.listenKeyLabel.setText(PropertiesReader.getMessage(OptionsMenuScreen.this.game.gameMessages, "options.keys.press"));
                OptionsMenuScreen.this.listenKeyLabel.setColor(OptionsMenuScreen.this.game.uiSkin.get("iron", Color.class));
            }
        });
        this.upmiddlekey.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.upmiddlekey.setColor(Color.RED);
        this.upmiddlekey.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.upmiddlekey.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 11.0f, 100.0f - this.tsp - this.sp * 11.0f).floatValue() - this.upmiddlekey.getHeight() / 2.0f);
        this.stage.addActor(this.upmiddlekey);
        Label upleft = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.key.upleft") + ":", this.game.uiSkin, "default");
        upleft.setColor(this.game.uiSkin.get("silver", Color.class));
        upleft.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        upleft.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - upleft.getPrefWidth());
        upleft.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 12.0f, 100.0f - this.tsp - this.sp * 12.0f).floatValue() - upleft.getHeight() / 2.0f);
        this.stage.addActor(upleft);
        this.upleftkey = new Label(this.game.settings.getProperty("key.upleft"), this.game.uiSkin, "default");
        this.upleftkey.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                OptionsMenuScreen.this.listenKeyLabel = (Label)event.getListenerActor();
                OptionsMenuScreen.this.listenKeyLabel.setText(PropertiesReader.getMessage(OptionsMenuScreen.this.game.gameMessages, "options.keys.press"));
                OptionsMenuScreen.this.listenKeyLabel.setColor(OptionsMenuScreen.this.game.uiSkin.get("iron", Color.class));
            }
        });
        this.upleftkey.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.upleftkey.setColor(Color.RED);
        this.upleftkey.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.upleftkey.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 12.0f, 100.0f - this.tsp - this.sp * 12.0f).floatValue() - this.upleftkey.getHeight() / 2.0f);
        this.stage.addActor(this.upleftkey);
        Label upright = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.key.upright") + ":", this.game.uiSkin, "default");
        upright.setColor(this.game.uiSkin.get("silver", Color.class));
        upright.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        upright.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - upright.getPrefWidth());
        upright.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 13.0f, 100.0f - this.tsp - this.sp * 13.0f).floatValue() - upright.getHeight() / 2.0f);
        this.stage.addActor(upright);
        this.uprightkey = new Label(this.game.settings.getProperty("key.upright"), this.game.uiSkin, "default");
        this.uprightkey.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                OptionsMenuScreen.this.listenKeyLabel = (Label)event.getListenerActor();
                OptionsMenuScreen.this.listenKeyLabel.setText(PropertiesReader.getMessage(OptionsMenuScreen.this.game.gameMessages, "options.keys.press"));
                OptionsMenuScreen.this.listenKeyLabel.setColor(OptionsMenuScreen.this.game.uiSkin.get("iron", Color.class));
            }
        });
        this.uprightkey.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.uprightkey.setColor(Color.RED);
        this.uprightkey.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.uprightkey.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 13.0f, 100.0f - this.tsp - this.sp * 13.0f).floatValue() - this.uprightkey.getHeight() / 2.0f);
        this.stage.addActor(this.uprightkey);
        Label left = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.key.left") + ":", this.game.uiSkin, "default");
        left.setColor(this.game.uiSkin.get("silver", Color.class));
        left.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        left.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - left.getPrefWidth());
        left.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 14.0f, 100.0f - this.tsp - this.sp * 14.0f).floatValue() - left.getHeight() / 2.0f);
        this.stage.addActor(left);
        this.leftkey = new Label(this.game.settings.getProperty("key.left"), this.game.uiSkin, "default");
        this.leftkey.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                OptionsMenuScreen.this.listenKeyLabel = (Label)event.getListenerActor();
                OptionsMenuScreen.this.listenKeyLabel.setText(PropertiesReader.getMessage(OptionsMenuScreen.this.game.gameMessages, "options.keys.press"));
                OptionsMenuScreen.this.listenKeyLabel.setColor(OptionsMenuScreen.this.game.uiSkin.get("iron", Color.class));
            }
        });
        this.leftkey.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.leftkey.setColor(Color.RED);
        this.leftkey.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.leftkey.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 14.0f, 100.0f - this.tsp - this.sp * 14.0f).floatValue() - this.leftkey.getHeight() / 2.0f);
        this.stage.addActor(this.leftkey);
        Label right = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.key.right") + ":", this.game.uiSkin, "default");
        right.setColor(this.game.uiSkin.get("silver", Color.class));
        right.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        right.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - right.getPrefWidth());
        right.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 15.0f, 100.0f - this.tsp - this.sp * 15.0f).floatValue() - right.getHeight() / 2.0f);
        this.stage.addActor(right);
        this.rightkey = new Label(this.game.settings.getProperty("key.right"), this.game.uiSkin, "default");
        this.rightkey.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                OptionsMenuScreen.this.listenKeyLabel = (Label)event.getListenerActor();
                OptionsMenuScreen.this.listenKeyLabel.setText(PropertiesReader.getMessage(OptionsMenuScreen.this.game.gameMessages, "options.keys.press"));
                OptionsMenuScreen.this.listenKeyLabel.setColor(OptionsMenuScreen.this.game.uiSkin.get("iron", Color.class));
            }
        });
        this.rightkey.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.rightkey.setColor(Color.RED);
        this.rightkey.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.rightkey.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 15.0f, 100.0f - this.tsp - this.sp * 15.0f).floatValue() - this.rightkey.getHeight() / 2.0f);
        this.stage.addActor(this.rightkey);
        Label use = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.key.use") + ":", this.game.uiSkin, "default");
        use.setColor(this.game.uiSkin.get("silver", Color.class));
        use.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        use.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - use.getPrefWidth());
        use.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 16.0f, 100.0f - this.tsp - this.sp * 16.0f).floatValue() - use.getHeight() / 2.0f);
        this.stage.addActor(use);
        this.usekey = new Label(this.game.settings.getProperty("key.use"), this.game.uiSkin, "default");
        this.usekey.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                OptionsMenuScreen.this.listenKeyLabel = (Label)event.getListenerActor();
                OptionsMenuScreen.this.listenKeyLabel.setText(PropertiesReader.getMessage(OptionsMenuScreen.this.game.gameMessages, "options.keys.press"));
                OptionsMenuScreen.this.listenKeyLabel.setColor(OptionsMenuScreen.this.game.uiSkin.get("iron", Color.class));
            }
        });
        this.usekey.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.usekey.setColor(Color.RED);
        this.usekey.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.usekey.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 16.0f, 100.0f - this.tsp - this.sp * 16.0f).floatValue() - this.usekey.getHeight() / 2.0f);
        this.stage.addActor(this.usekey);
        Label surge = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.key.surge") + ":", this.game.uiSkin, "default");
        surge.setColor(this.game.uiSkin.get("silver", Color.class));
        surge.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        surge.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - surge.getPrefWidth());
        surge.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 17.0f, 100.0f - this.tsp - this.sp * 17.0f).floatValue() - surge.getHeight() / 2.0f);
        this.stage.addActor(surge);
        this.surgekey = new Label(this.game.settings.getProperty("key.surge"), this.game.uiSkin, "default");
        this.surgekey.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                OptionsMenuScreen.this.listenKeyLabel = (Label)event.getListenerActor();
                OptionsMenuScreen.this.listenKeyLabel.setText(PropertiesReader.getMessage(OptionsMenuScreen.this.game.gameMessages, "options.keys.press"));
                OptionsMenuScreen.this.listenKeyLabel.setColor(OptionsMenuScreen.this.game.uiSkin.get("iron", Color.class));
            }
        });
        this.surgekey.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.surgekey.setColor(Color.RED);
        this.surgekey.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.surgekey.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 17.0f, 100.0f - this.tsp - this.sp * 17.0f).floatValue() - this.surgekey.getHeight() / 2.0f);
        this.stage.addActor(this.surgekey);
        Label next = new Label(PropertiesReader.getMessage(this.game.gameMessages, "options.key.next") + ":", this.game.uiSkin, "default");
        next.setColor(this.game.uiSkin.get("silver", Color.class));
        next.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        next.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - next.getPrefWidth());
        next.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 18.0f, 100.0f - this.tsp - this.sp * 18.0f).floatValue() - next.getHeight() / 2.0f);
        this.stage.addActor(next);
        this.nextkey = new Label(this.game.settings.getProperty("key.next"), this.game.uiSkin, "default");
        this.nextkey.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                OptionsMenuScreen.this.listenKeyLabel = (Label)event.getListenerActor();
                OptionsMenuScreen.this.listenKeyLabel.setText(PropertiesReader.getMessage(OptionsMenuScreen.this.game.gameMessages, "options.keys.press"));
                OptionsMenuScreen.this.listenKeyLabel.setColor(OptionsMenuScreen.this.game.uiSkin.get("iron", Color.class));
            }
        });
        this.nextkey.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.nextkey.setColor(Color.RED);
        this.nextkey.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        this.nextkey.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 18.0f, 100.0f - this.tsp - this.sp * 18.0f).floatValue() - this.nextkey.getHeight() / 2.0f);
        this.stage.addActor(this.nextkey);
        TextButton applyButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "common.apply"), this.game.uiSkin, "base");
        applyButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                OptionsMenuScreen.this.saveSettings();
                if (OptionsMenuScreen.this.restart) {
                    OptionsMenuScreen.this.game.manager.dispose();
                    OptionsMenuScreen.this.game.manager = new AssetManager();
                    OptionsMenuScreen.this.game.loadingScreen = new LoadingScreen(OptionsMenuScreen.this.game);
                    OptionsMenuScreen.this.game.setScreen(OptionsMenuScreen.this.game.loadingScreen);
                    OptionsMenuScreen.this.dispose();
                } else if (OptionsMenuScreen.this.inGame) {
                    OptionsMenuScreen.this.game.setScreen(OptionsMenuScreen.this.game.gameMenuScreen);
                    OptionsMenuScreen.this.dispose();
                } else {
                    OptionsMenuScreen.this.game.mainMenuScreen = new MainMenuScreen(OptionsMenuScreen.this.game);
                    OptionsMenuScreen.this.game.setScreen(OptionsMenuScreen.this.game.mainMenuScreen);
                    OptionsMenuScreen.this.dispose();
                }
            }
        });
        applyButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        applyButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        applyButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), applyButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        applyButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        applyButton.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - applyButton.getPrefWidth());
        applyButton.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 20.0f, 100.0f - this.tsp - this.sp * 20.0f).floatValue() - applyButton.getPrefHeight() / 2.0f);
        this.stage.addActor(applyButton);
        TextButton exitButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "common.exit"), this.game.uiSkin, "base");
        exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (OptionsMenuScreen.this.inGame) {
                    OptionsMenuScreen.this.game.setScreen(OptionsMenuScreen.this.game.gameMenuScreen);
                    Gdx.input.setInputProcessor(OptionsMenuScreen.this.game.gameMenuScreen.im);
                    OptionsMenuScreen.this.dispose();
                } else {
                    OptionsMenuScreen.this.game.mainMenuScreen = new MainMenuScreen(OptionsMenuScreen.this.game);
                    OptionsMenuScreen.this.game.setScreen(OptionsMenuScreen.this.game.mainMenuScreen);
                    OptionsMenuScreen.this.dispose();
                }
            }
        });
        exitButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        exitButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        exitButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), exitButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        exitButton.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 20.0f, 100.0f - this.tsp - this.sp * 20.0f).floatValue() - exitButton.getPrefHeight() / 2.0f);
        this.stage.addActor(exitButton);
    }

    @Override
    public void render(float delta) {
        this.soundBlocked = (double)this.soundBlocked > 0.0 ? (this.soundBlocked -= 2.0f) : 0.0f;
        this.game.manager.update();
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4 || keycode == 82) {
            if (this.inGame) {
                this.game.setScreen(this.game.gameMenuScreen);
                this.dispose();
            } else {
                this.game.mainMenuScreen = new MainMenuScreen(this.game);
                this.game.setScreen(this.game.mainMenuScreen);
                this.dispose();
            }
        }
        if (keycode != 253 && (keycode < 7 || keycode > 16) && this.listenKeyLabel != null) {
            this.listenKeyLabel.setText(Input.Keys.toString(keycode));
            this.listenKeyLabel.setColor(Color.RED);
            this.listenKeyLabel = null;
        }
        return false;
    }

    private void saveSettings() {
        String baseInput;
        boolean changeVideoMode = false;
        if (!this.languageSelect.getSelected().split("-")[1].equalsIgnoreCase(this.game.settings.getProperty("language", "en"))) {
            this.game.settings.setProperty("language", this.languageSelect.getSelected().split("-")[1]);
            this.game.language = this.languageSelect.getSelected().split("-")[1];
            this.game.gameMessages = PropertiesReader.loadLanguage(this.game.gameMessages, this.game.language);
        }
        if (!("" + this.portraitMode.isChecked()).equalsIgnoreCase(this.game.settings.getProperty("portraitmode"))) {
            this.game.settings.setProperty("portraitmode", "" + this.portraitMode.isChecked());
            this.game.portraitmode = this.portraitMode.isChecked();
            changeVideoMode = true;
        }
        if (!this.resolutionSelect.getSelected().equalsIgnoreCase(this.game.settings.getProperty("resolution")) || changeVideoMode) {
            this.game.settings.setProperty("resolution", this.resolutionSelect.getSelected());
            this.game.viewHeightMAX = Float.valueOf(1080.0f);
            this.game.viewWidth = this.game.viewWidthMAX = Float.valueOf(this.portraitMode.isChecked() ? this.game.viewHeightMAX.floatValue() * 3.0f / 4.0f : this.game.viewHeightMAX.floatValue() * 4.0f / 3.0f);
            this.game.viewHeight = this.game.viewHeightMAX;
            changeVideoMode = true;
        }
        if (!("" + this.fullscreenCheck.isChecked()).equalsIgnoreCase(this.game.settings.getProperty("fullscreen"))) {
            this.game.settings.setProperty("fullscreen", "" + this.fullscreenCheck.isChecked());
            this.game.fullscreen = this.fullscreenCheck.isChecked();
            changeVideoMode = true;
        }
        if ((baseInput = this.inputSelect.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "options.input.keyboard"))) {
            baseInput = "keyboard";
        } else if (baseInput.equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "options.input.mouse"))) {
            baseInput = "mouse";
        } else if (baseInput.equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "options.input.touch"))) {
            baseInput = "touch";
        }
        if (!baseInput.equalsIgnoreCase(this.game.settings.getProperty("input", "keyboard"))) {
            this.game.settings.setProperty("input", baseInput);
            this.game.input = baseInput;
        }
        if (this.musicSlider.getValue() != this.game.musicVolume * 2.0f) {
            this.game.settings.setProperty("music", "" + this.musicSlider.getValue());
            this.game.musicVolume = this.musicSlider.getValue() / 2.0f;
            this.game.track.setVolume(this.game.musicVolume);
        }
        if (this.soundSlider.getValue() != this.game.soundVolume) {
            this.game.settings.setProperty("sound", "" + this.soundSlider.getValue());
            this.game.soundVolume = this.soundSlider.getValue();
        }
        if (this.violenceCheck.isChecked() != this.game.violenceFilter) {
            this.game.settings.setProperty("violencefilter", "" + this.violenceCheck.isChecked());
            this.game.violenceFilter = this.violenceCheck.isChecked();
        }
        if (this.debugMode.isChecked() != this.game.debugMode) {
            this.game.settings.setProperty("debugmode", "" + this.debugMode.isChecked());
            this.game.debugMode = this.debugMode.isChecked();
            Logger.debug(this.game.debugMode);
            if (this.game.debugMode) {
                this.game.achievements = PropertiesReader.loadAchievements(this.game.mail, this.game.key, false);
                PropertiesReader.saveAchievements(this.game.achievements, this.game.mail, this.game.key, true);
                this.game.saveGame.clear();
                this.game.saveGame = PropertiesReader.loadGame(1, this.game.mail, this.game.key, false);
                PropertiesReader.saveGame(this.game.saveGame, 1, this.game.mail, this.game.key, true);
                this.game.saveGame.clear();
                this.game.saveGame = PropertiesReader.loadGame(2, this.game.mail, this.game.key, false);
                PropertiesReader.saveGame(this.game.saveGame, 2, this.game.mail, this.game.key, true);
                this.game.saveGame.clear();
                this.game.saveGame = PropertiesReader.loadGame(3, this.game.mail, this.game.key, false);
                PropertiesReader.saveGame(this.game.saveGame, 3, this.game.mail, this.game.key, true);
                this.game.saveGame.clear();
                this.game.saveGame = PropertiesReader.loadGame(4, this.game.mail, this.game.key, false);
                PropertiesReader.saveGame(this.game.saveGame, 4, this.game.mail, this.game.key, true);
            }
        }
        if (this.retroMode.isChecked() != this.game.retroMode) {
            this.game.settings.setProperty("retromode", "" + this.retroMode.isChecked());
            this.game.retroMode = this.retroMode.isChecked();
            this.restart = true;
        }
        if (!this.upmiddlekey.getText().toString().equalsIgnoreCase(this.game.settings.getProperty("key.upmiddle"))) {
            this.game.settings.setProperty("key.upmiddle", this.upmiddlekey.getText().toString());
            this.game.upmiddlekey = this.upmiddlekey.getText().toString();
        }
        if (!this.upleftkey.getText().toString().equalsIgnoreCase(this.game.settings.getProperty("key.upleft"))) {
            this.game.settings.setProperty("key.upleft", this.upleftkey.getText().toString());
            this.game.upleftkey = this.upleftkey.getText().toString();
        }
        if (!this.uprightkey.getText().toString().equalsIgnoreCase(this.game.settings.getProperty("key.upright"))) {
            this.game.settings.setProperty("key.upright", this.uprightkey.getText().toString());
            this.game.uprightkey = this.uprightkey.getText().toString();
        }
        if (!this.leftkey.getText().toString().equalsIgnoreCase(this.game.settings.getProperty("key.left"))) {
            this.game.settings.setProperty("key.left", this.leftkey.getText().toString());
            this.game.leftkey = this.leftkey.getText().toString();
        }
        if (!this.rightkey.getText().toString().equalsIgnoreCase(this.game.settings.getProperty("key.right"))) {
            this.game.settings.setProperty("key.right", this.rightkey.getText().toString());
            this.game.rightkey = this.rightkey.getText().toString();
        }
        if (!this.usekey.getText().toString().equalsIgnoreCase(this.game.settings.getProperty("key.use"))) {
            this.game.settings.setProperty("key.use", this.usekey.getText().toString());
            this.game.usekey = this.usekey.getText().toString();
        }
        if (!this.surgekey.getText().toString().equalsIgnoreCase(this.game.settings.getProperty("key.surge"))) {
            this.game.settings.setProperty("key.surge", this.surgekey.getText().toString());
            this.game.surgekey = this.surgekey.getText().toString();
        }
        if (!this.nextkey.getText().toString().equalsIgnoreCase(this.game.settings.getProperty("key.next"))) {
            this.game.settings.setProperty("key.next", this.nextkey.getText().toString());
            this.game.nextkey = this.nextkey.getText().toString();
        }
        PropertiesReader.saveSettings(this.game.settings);
        if (changeVideoMode) {
            Graphics.Monitor currMonitor = Gdx.graphics.getMonitor();
            Graphics.DisplayMode displayMode = Gdx.graphics.getDisplayMode(currMonitor);
            if (!this.game.fullscreen) {
                Gdx.graphics.setWindowedMode(Integer.parseInt(this.resolutionSelect.getSelected().split("x")[this.game.portraitmode ? 1 : 0]), Integer.parseInt(this.resolutionSelect.getSelected().split("x")[this.game.portraitmode ? 0 : 1]));
            } else if (!Gdx.graphics.setFullscreenMode(displayMode)) {
                Gdx.graphics.setWindowedMode(Integer.parseInt(this.resolutionSelect.getSelected().split("x")[this.game.portraitmode ? 1 : 0]), Integer.parseInt(this.resolutionSelect.getSelected().split("x")[this.game.portraitmode ? 0 : 1]));
            }
        }
    }
}

