/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.TextFieldFontScaling;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.DuelSetupScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.util.NetworkPort;
import com.calimasaga.slavepits.util.PropertiesReader;

public class MultiplayerScreen
extends BaseScreen {
    public float tsp = 30.0f;
    public float sp = 5.0f;
    private TextFieldFontScaling servername;
    private TextFieldFontScaling pass;
    private Label warningLabel;
    private float connectionTimeout = 0.0f;

    public MultiplayerScreen(SlavePitsGame g) {
        super(g);
        this.create();
    }

    @Override
    public void create() {
        Label passLabel;
        Label ipLabel;
        int numRows = 1;
        if (this.game.gameMode.equalsIgnoreCase("server")) {
            ipLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "multiplayer.name") + ":", this.game.uiSkin, "default");
            ipLabel.setColor(this.game.uiSkin.get("silver", Color.class));
            ipLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            ipLabel.setX(UIHelpers.calcWidthProportion(this.game, 44.65f, 44.65f).floatValue() - ipLabel.getPrefWidth());
            ipLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp, 100.0f - this.tsp).floatValue() - ipLabel.getHeight() / 2.0f);
            this.stage.addActor(ipLabel);
            this.servername = UIHelpers.createTextField(this.game, UIHelpers.calcHeightProportion(this.game, 32.0f, 32.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
            this.servername.setWidth(this.servername.getPrefWidth());
            this.servername.setX(UIHelpers.calcWidthProportion(this.game, 45.35f, 45.35f).floatValue());
            this.servername.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp, 100.0f - this.tsp).floatValue() - this.servername.getHeight() / 2.0f);
            this.stage.addActor(this.servername);
            this.stage.setKeyboardFocus(this.servername);
            passLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "multiplayer.pass") + ":", this.game.uiSkin, "default");
            passLabel.setColor(this.game.uiSkin.get("silver", Color.class));
            passLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            passLabel.setX(UIHelpers.calcWidthProportion(this.game, 44.65f, 44.65f).floatValue() - passLabel.getPrefWidth());
            passLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp, 100.0f - this.tsp - this.sp).floatValue() - passLabel.getHeight() / 2.0f);
            this.stage.addActor(passLabel);
            this.pass = UIHelpers.createTextField(this.game, UIHelpers.calcHeightProportion(this.game, 32.0f, 32.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
            this.pass.setWidth(this.pass.getPrefWidth());
            this.pass.setX(UIHelpers.calcWidthProportion(this.game, 45.35f, 45.35f).floatValue());
            this.pass.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp, 100.0f - this.tsp - this.sp).floatValue() - this.pass.getHeight() / 2.0f);
            this.stage.addActor(this.pass);
            numRows = 3;
        } else if (this.game.gameMode.equalsIgnoreCase("client")) {
            ipLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "multiplayer.ip") + " / " + PropertiesReader.getMessage(this.game.gameMessages, "multiplayer.name") + ":", this.game.uiSkin, "default");
            ipLabel.setColor(this.game.uiSkin.get("silver", Color.class));
            ipLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            ipLabel.setX(UIHelpers.calcWidthProportion(this.game, 44.65f, 44.65f).floatValue() - ipLabel.getPrefWidth());
            ipLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp, 100.0f - this.tsp).floatValue() - ipLabel.getHeight() / 2.0f);
            this.stage.addActor(ipLabel);
            this.servername = UIHelpers.createTextField(this.game, UIHelpers.calcHeightProportion(this.game, 32.0f, 32.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
            this.servername.setWidth(this.servername.getPrefWidth());
            this.servername.setX(UIHelpers.calcWidthProportion(this.game, 45.35f, 45.35f).floatValue());
            this.servername.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp, 100.0f - this.tsp).floatValue() - this.servername.getHeight() / 2.0f);
            this.stage.addActor(this.servername);
            this.stage.setKeyboardFocus(this.servername);
            passLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "multiplayer.pass") + ":", this.game.uiSkin, "default");
            passLabel.setColor(this.game.uiSkin.get("silver", Color.class));
            passLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
            passLabel.setX(UIHelpers.calcWidthProportion(this.game, 44.65f, 44.65f).floatValue() - passLabel.getPrefWidth());
            passLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp, 100.0f - this.tsp - this.sp).floatValue() - passLabel.getHeight() / 2.0f);
            this.stage.addActor(passLabel);
            this.pass = UIHelpers.createTextField(this.game, UIHelpers.calcHeightProportion(this.game, 32.0f, 32.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
            this.pass.setWidth(this.pass.getPrefWidth());
            this.pass.setX(UIHelpers.calcWidthProportion(this.game, 45.35f, 45.35f).floatValue());
            this.pass.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp, 100.0f - this.tsp - this.sp).floatValue() - this.pass.getHeight() / 2.0f);
            this.stage.addActor(this.pass);
            numRows = 3;
        }
        Label infoLabel = new Label("", this.game.uiSkin, "default");
        infoLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        infoLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        infoLabel.setAlignment(1);
        infoLabel.setWidth(infoLabel.getWidth() * 90.0f / 100.0f);
        infoLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, this.game.gameMode.equalsIgnoreCase("server") ? "multiplayer.info.server" : "multiplayer.info.client"));
        UIHelpers.fixLabelFontSize(infoLabel, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 90.0f, 90.0f).floatValue(), 0.0f);
        infoLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - infoLabel.getWidth() / 2.0f);
        infoLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * (float)numRows, 100.0f - this.tsp - this.sp * (float)numRows).floatValue() - infoLabel.getHeight() / 2.0f);
        this.stage.addActor(infoLabel);
        ++numRows;
        this.warningLabel = new Label("", this.game.uiSkin, "default");
        this.warningLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        this.warningLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.warningLabel.setVisible(false);
        this.warningLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.warningLabel.getPrefWidth() / 2.0f);
        this.warningLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * (float)numRows, 100.0f - this.tsp - this.sp * (float)numRows).floatValue() - this.warningLabel.getHeight() / 2.0f);
        this.stage.addActor(this.warningLabel);
        numRows += 2;
        TextButton connectButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "multiplayer.connect"), this.game.uiSkin, "base");
        connectButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                boolean error = false;
                if (MultiplayerScreen.this.game.networkPort != null) {
                    MultiplayerScreen.this.game.networkPort.terminate();
                    MultiplayerScreen.this.game.networkPort = null;
                }
                if (MultiplayerScreen.this.game.gameMode.equalsIgnoreCase("server")) {
                    if (MultiplayerScreen.this.servername.getText().equalsIgnoreCase("") || MultiplayerScreen.this.servername.getText().length() > 20 || MultiplayerScreen.this.servername.getText().contains("#")) {
                        MultiplayerScreen.this.warningLabel.setText(PropertiesReader.getMessage(MultiplayerScreen.this.game.gameMessages, "multiplayer.error.servername"));
                        error = true;
                    }
                    if (MultiplayerScreen.this.pass.getText().length() > 20 || MultiplayerScreen.this.pass.getText().contains("#")) {
                        MultiplayerScreen.this.warningLabel.setText(PropertiesReader.getMessage(MultiplayerScreen.this.game.gameMessages, "multiplayer.error.password"));
                        error = true;
                    }
                } else if (MultiplayerScreen.this.game.gameMode.equalsIgnoreCase("client")) {
                    if (MultiplayerScreen.this.servername.getText().length() > 20 || MultiplayerScreen.this.servername.getText().contains("#")) {
                        MultiplayerScreen.this.warningLabel.setText(PropertiesReader.getMessage(MultiplayerScreen.this.game.gameMessages, "multiplayer.error.servername"));
                        error = true;
                    }
                    if (MultiplayerScreen.this.pass.getText().length() > 20 || MultiplayerScreen.this.pass.getText().contains("#")) {
                        MultiplayerScreen.this.warningLabel.setText(PropertiesReader.getMessage(MultiplayerScreen.this.game.gameMessages, "multiplayer.error.password"));
                        error = true;
                    }
                }
                if (error) {
                    MultiplayerScreen.this.warningLabel.layout();
                    MultiplayerScreen.this.warningLabel.setX(UIHelpers.calcWidthProportion(MultiplayerScreen.this.game, 50.0f, 50.0f).floatValue() - MultiplayerScreen.this.warningLabel.getPrefWidth() / 2.0f);
                    MultiplayerScreen.this.warningLabel.setVisible(true);
                    MultiplayerScreen.this.warningLabel.setColor(Color.RED);
                } else {
                    MultiplayerScreen.this.warningLabel.setText(PropertiesReader.getMessage(MultiplayerScreen.this.game.gameMessages, "multiplayer.waiting"));
                    MultiplayerScreen.this.warningLabel.layout();
                    MultiplayerScreen.this.warningLabel.setX(UIHelpers.calcWidthProportion(MultiplayerScreen.this.game, 50.0f, 50.0f).floatValue() - MultiplayerScreen.this.warningLabel.getPrefWidth() / 2.0f);
                    MultiplayerScreen.this.warningLabel.setVisible(true);
                    MultiplayerScreen.this.warningLabel.setColor(Color.GREEN);
                    MultiplayerScreen.this.connectionTimeout = 5.0f;
                    MultiplayerScreen.this.game.networkPort = new NetworkPort(MultiplayerScreen.this.game);
                    if (MultiplayerScreen.this.game.networkPort.handshake(MultiplayerScreen.this.servername.getText(), MultiplayerScreen.this.pass.getText()) < 0) {
                        MultiplayerScreen.this.warningLabel.setText(PropertiesReader.getMessage(MultiplayerScreen.this.game.gameMessages, "multiplayer.error.connect"));
                    }
                }
            }
        });
        connectButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        connectButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        connectButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), connectButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        connectButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        connectButton.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - connectButton.getWidth());
        connectButton.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * (float)numRows, 100.0f - this.tsp - this.sp * (float)numRows).floatValue() - connectButton.getPrefHeight() / 2.0f);
        this.stage.addActor(connectButton);
        TextButton exitButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "common.exit"), this.game.uiSkin, "base");
        exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (MultiplayerScreen.this.game.networkPort != null) {
                    MultiplayerScreen.this.game.networkPort.terminate();
                    MultiplayerScreen.this.game.networkPort = null;
                }
                MultiplayerScreen.this.game.mainMenuScreen = new MainMenuScreen(MultiplayerScreen.this.game);
                MultiplayerScreen.this.game.setScreen(MultiplayerScreen.this.game.mainMenuScreen);
                MultiplayerScreen.this.dispose();
            }
        });
        exitButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        exitButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        exitButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), exitButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        exitButton.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * (float)numRows, 100.0f - this.tsp - this.sp * (float)numRows).floatValue() - exitButton.getPrefHeight() / 2.0f);
        this.stage.addActor(exitButton);
    }

    @Override
    public void render(float delta) {
        if (this.connectionTimeout > 0.0f) {
            if (this.connectionTimeout <= 0.5f) {
                if (this.game.networkPort.state.equalsIgnoreCase("none")) {
                    this.warningLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "multiplayer.error.connect.gameserver"));
                    this.warningLabel.setColor(Color.RED);
                    this.warningLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.warningLabel.getPrefWidth() / 2.0f);
                } else if (this.game.networkPort.state.equalsIgnoreCase("connected")) {
                    if (this.game.gameMode.equalsIgnoreCase("client")) {
                        this.warningLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "multiplayer.error.connect.host"));
                        this.warningLabel.setColor(Color.RED);
                        this.warningLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.warningLabel.getPrefWidth() / 2.0f);
                    } else {
                        this.game.networkPort.keepAlive();
                        this.connectionTimeout = 1.5f;
                    }
                }
            }
            this.connectionTimeout -= delta;
        }
        if (this.game.networkPort != null && this.game.networkPort.state.equalsIgnoreCase("setup")) {
            int maxReputation = 0;
            this.game.duelSetupScreen = new DuelSetupScreen(this.game, maxReputation);
            this.game.setScreen(this.game.duelSetupScreen);
            this.dispose();
        }
        this.game.manager.update();
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4 || keycode == 82) {
            if (this.game.networkPort != null) {
                this.game.networkPort.terminate();
                this.game.networkPort = null;
            }
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
            this.dispose();
        }
        return false;
    }
}

