/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Story;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.screen.PrepSetupScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.ArrayList;

public class MessageScreen
extends BaseScreen {
    public float tsp = 35.0f;
    public float sp = 20.0f;
    public String message = "";
    public String color = "FFFFFFFF";
    public float size = 1.0f;
    public String option = "";
    public String sound = "";
    public float soundDelay = 0.0f;
    public float elapsedTime = 0.0f;
    private float fightTimer = 0.0f;
    private float loreTimer = 0.0f;
    public String selectedEvent = "";
    public String selectedPrep = "";
    public String selectedBackground = "";
    public ArrayList<Label> multiLabel;
    public Button nextButton;
    public BaseActor baseLoadingBar;
    public BaseActor loadingBar;

    public MessageScreen(SlavePitsGame g, String selectedMessage, String selectedColor, float selectedSize, String selectedOption, String selectedSound) {
        super(g);
        String sTimer;
        this.message = selectedMessage;
        this.color = selectedColor;
        this.size = selectedSize * (g.portraitmode ? 0.7f : 1.0f);
        this.option = selectedOption;
        if (this.option.contains("fighttimer:")) {
            sTimer = this.option.substring(this.option.indexOf("fighttimer:"), this.option.indexOf(";", this.option.indexOf("fighttimer:")));
            this.fightTimer = Float.parseFloat(sTimer.substring(11));
        }
        if (this.option.contains("loretimer:")) {
            sTimer = this.option.substring(this.option.indexOf("loretimer:"), this.option.indexOf(";", this.option.indexOf("loretimer:")));
            this.loreTimer = Float.parseFloat(sTimer.substring(10));
        }
        if (this.option.contains("event:")) {
            this.selectedEvent = this.option.substring(this.option.indexOf("event:"), this.option.indexOf(";", this.option.indexOf("event:"))).substring(6);
        }
        if (this.option.contains("prep")) {
            this.selectedPrep = "prep";
        }
        if (this.option.contains("background:")) {
            this.selectedBackground = this.option.substring(this.option.indexOf("background:"), this.option.indexOf(";", this.option.indexOf("background:"))).substring(11);
        }
        this.sound = selectedSound;
        if (selectedSound.contains(":")) {
            this.sound = selectedSound.substring(0, selectedSound.indexOf(":"));
            this.soundDelay = Float.parseFloat(selectedSound.substring(selectedSound.indexOf(":") + 1));
        }
        this.create();
    }

    @Override
    public void create() {
        if (this.game.track != null && this.game.track.isPlaying() && !this.sound.equalsIgnoreCase("continue")) {
            this.game.track.stop();
            this.game.track.dispose();
        }
        if (!this.selectedBackground.equalsIgnoreCase("")) {
            BaseActor background = new BaseActor();
            UIHelpers.portraitModeFixBackground(this.game, background, this.selectedBackground, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
            this.stage.addActor(background);
        }
        Label messageLabel = new Label(this.message, this.game.uiSkin, "combat");
        messageLabel.setFontScale(this.size);
        messageLabel.setColor(Color.valueOf(this.color));
        messageLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - messageLabel.getPrefWidth() / 2.0f);
        messageLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp, 100.0f - this.tsp).floatValue() - messageLabel.getHeight() / 2.0f);
        this.stage.addActor(messageLabel);
        if (this.option.contains("mainmenu")) {
            TextButton exitButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.mainmenu"), this.game.uiSkin, "bigmenu");
            exitButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    MessageScreen.this.game.mainMenuScreen = new MainMenuScreen(MessageScreen.this.game);
                    MessageScreen.this.game.setScreen(MessageScreen.this.game.mainMenuScreen);
                }
            });
            exitButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
            exitButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
            exitButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 35.0f, 35.0f).floatValue(), exitButton.getPrefWidth(), this.game.viewHeight.floatValue()));
            exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 12.5f, 12.5f).floatValue());
            exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - exitButton.getWidth() / 2.0f);
            exitButton.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp, 100.0f - this.tsp - this.sp).floatValue() - exitButton.getPrefHeight() / 2.0f);
            this.stage.addActor(exitButton);
        }
        if (this.option.contains("restart")) {
            TextButton restartButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "common.tryagain"), this.game.uiSkin, "bigmenu");
            restartButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    int position = Integer.parseInt(MessageScreen.this.game.saveGame.get("position"));
                    MessageScreen.this.game.saveGame.clear();
                    MessageScreen.this.game.saveGame = PropertiesReader.loadGame(position, MessageScreen.this.game.mail, MessageScreen.this.game.key, MessageScreen.this.game.debugMode);
                    Story.loadState(MessageScreen.this.game);
                }
            });
            restartButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
            restartButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
            restartButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 35.0f, 35.0f).floatValue(), restartButton.getPrefWidth(), this.game.viewHeight.floatValue()));
            restartButton.setHeight(UIHelpers.calcHeightProportion(this.game, 12.5f, 12.5f).floatValue());
            restartButton.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - restartButton.getWidth() / 2.0f);
            restartButton.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 3.0f / 2.0f, 100.0f - this.tsp - this.sp * 3.0f / 2.0f).floatValue() - restartButton.getPrefHeight() / 2.0f);
            this.stage.addActor(restartButton);
        }
        if (this.option.contains("loretimer")) {
            messageLabel.setVisible(false);
            this.multiLabel = new ArrayList();
            String[] messageParts = this.message.split(System.getProperty("line.separator"));
            float sizeControl = 1.0f;
            for (int i = 0; i < messageParts.length; ++i) {
                Label label = new Label(messageParts[i], this.game.uiSkin, "combat");
                label.setFontScale(this.size);
                label.setAlignment(1);
                label.setColor(Color.valueOf(this.color.substring(0, this.color.length() - 2) + "00"));
                label.setText(messageParts[i]);
                label.layout();
                label.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - label.getPrefWidth() / 2.0f);
                label.setY(UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue() - (float)(i - 1 - messageParts.length / 2) * label.getPrefHeight() * 1.5f - label.getPrefHeight() / 2.0f);
                label.setVisible(false);
                while (label.getPrefWidth() * sizeControl >= this.game.viewWidth.floatValue() * 0.9f) {
                    sizeControl -= 0.05f;
                }
                this.stage.addActor(label);
                this.multiLabel.add(label);
            }
            for (Actor actor : this.multiLabel) {
                ((Label)actor).setFontScale(this.size * sizeControl);
                ((Label)actor).layout();
                actor.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - actor.getWidth() / 2.0f);
            }
            this.nextButton = new Button(this.game.uiSkin, "next");
            this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            this.nextButton.setHeight(this.nextButton.getWidth());
            this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
            this.nextButton.setY(10.0f);
            this.nextButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (MessageScreen.this.game.gameMode.equalsIgnoreCase("story")) {
                        if (!MessageScreen.this.selectedPrep.equalsIgnoreCase("")) {
                            MessageScreen.this.game.prepSetupScreen = new PrepSetupScreen(MessageScreen.this.game, Integer.parseInt(MessageScreen.this.game.saveGame.get("life")), Integer.parseInt(MessageScreen.this.game.saveGame.get("profits")));
                            MessageScreen.this.game.setScreen(MessageScreen.this.game.prepSetupScreen);
                        } else {
                            Story.getNextScreen(MessageScreen.this.game, MessageScreen.this.selectedEvent, "");
                        }
                    } else if (MessageScreen.this.game.gameMode.equalsIgnoreCase("tournament")) {
                        Tournament.getNextScreen(MessageScreen.this.game, MessageScreen.this.selectedEvent, "");
                    }
                }
            });
            this.nextButton.setVisible(false);
            SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(5.0f), (Action)Actions.show());
            this.nextButton.addAction(showDelayed);
            this.stage.addActor(this.nextButton);
        }
        if (this.option.contains("fadein")) {
            SequenceAction fading;
            this.addFadeOverlay(Float.valueOf(1.0f));
            String sFadeIn = this.option.substring(this.option.indexOf("fadein:"), this.option.indexOf(";", this.option.indexOf("fadein:")));
            sFadeIn = sFadeIn.substring(7);
            if (sFadeIn.contains(";")) {
                this.fadeOverlay.setColor(0.0f, 0.0f, 0.0f, 1.0f);
                fading = Actions.sequence(Actions.show(), Actions.fadeOut(new Float(sFadeIn.split(";")[0]).floatValue()), Actions.delay(new Float(sFadeIn.split(";")[1]).floatValue()), Actions.fadeIn(new Float(sFadeIn.split(";")[2]).floatValue()), Actions.delay(0.1f), Actions.hide());
            } else {
                this.fadeOverlay.setColor(0.0f, 0.0f, 0.0f, 1.0f);
                fading = Actions.sequence((Action)Actions.show(), (Action)Actions.fadeOut(new Float(sFadeIn.split(";")[0]).floatValue()), (Action)Actions.delay(0.1f), (Action)Actions.hide());
            }
            this.fadeOverlay.addAction(fading);
        }
    }

    @Override
    public void render(float delta) {
        this.stage.act(delta);
        this.elapsedTime += delta;
        if (this.fightTimer > 0.0f && this.elapsedTime > this.fightTimer) {
            if (this.game.gameMode.equalsIgnoreCase("story")) {
                Story.getNextScreen(this.game, "day", "");
            } else if (this.game.gameMode.equalsIgnoreCase("tournament")) {
                Tournament.getNextScreen(this.game, "day", "");
            }
        }
        if (this.loreTimer > 0.0f) {
            for (int i = 0; i < Float.valueOf(this.elapsedTime / this.loreTimer).intValue() && i < this.multiLabel.size(); ++i) {
                if (this.multiLabel.get(i).isVisible()) continue;
                this.multiLabel.get(i).setVisible(true);
                this.multiLabel.get(i).addAction(Actions.fadeIn(this.loreTimer / 2.0f));
            }
        }
        if (!this.sound.equalsIgnoreCase("") && !this.sound.equalsIgnoreCase("continue") && this.elapsedTime > this.soundDelay) {
            if (this.sound.startsWith("sl")) {
                this.game.track = Gdx.audio.newMusic(Gdx.files.internal(this.game.getOverridenFilename("music/" + this.sound + ".ogg")));
                this.game.track.setLooping(true);
                this.game.track.setVolume(this.game.musicVolume);
                this.game.track.play();
            } else {
                this.game.manager.get("sound/" + this.sound + ".ogg", Sound.class).play(this.game.soundVolume);
            }
            this.sound = "";
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4 || keycode == 82) {
            if (this.game.networkPort != null) {
                this.game.networkPort.terminate();
                this.game.networkPort = null;
            }
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
        } else if (keycode == Input.Keys.valueOf(this.game.nextkey) && this.nextButton != null && this.nextButton.isVisible()) {
            InputEvent event = new InputEvent();
            event.setType(InputEvent.Type.touchUp);
            this.nextButton.fire(event);
            return true;
        }
        return false;
    }
}

