/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.AnimatedActor;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.ParticleEffectActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Tournament;
import com.calimasaga.slavepits.screen.ActivationScreen;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.CreditsScreen;
import com.calimasaga.slavepits.screen.DuelSetupScreen;
import com.calimasaga.slavepits.screen.LexiconScreen;
import com.calimasaga.slavepits.screen.MultiplayerScreen;
import com.calimasaga.slavepits.screen.OptionsMenuScreen;
import com.calimasaga.slavepits.screen.SaveGameScreen;
import com.calimasaga.slavepits.screen.TournamentGameScreen;
import com.calimasaga.slavepits.util.NetworkPort;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.ArrayList;
import java.util.HashMap;

public class MainMenuScreen
extends BaseScreen {
    private float menuBlocked = 0.0f;
    private BaseActor bloodtext;
    private String selection;
    private int selectionLevel = 1;
    private ArrayList<TextButton> listButtons;
    private FrameBuffer frameBuffer;
    private AnimatedActor l1;
    private AnimatedActor l2;
    private ParticleEffectActor t1;
    private ParticleEffectActor t2;
    public Label gameUpdate;

    public MainMenuScreen(SlavePitsGame g) {
        super(g);
        this.create();
    }

    @Override
    public void create() {
        this.menuBlocked = 0.0f;
        if (this.game.track != null && this.game.track.isPlaying()) {
            this.game.track.stop();
            this.game.track.dispose();
        }
        this.game.track = Gdx.audio.newMusic(Gdx.files.internal(this.game.getOverridenFilename("music/sl01.ogg")));
        this.game.track.setLooping(true);
        this.game.track.setVolume(this.game.musicVolume);
        this.game.track.play();
        this.game.saveGame.clear();
        if (this.game.campaignFighter != null) {
            this.game.campaignFighter = null;
        }
        BaseActor background = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, background, this.game.getOverridenFilename("data/backgrounds/backgroundtitle.jpg"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.stage.addActor(background);
        this.frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, this.game.viewWidth.intValue(), this.game.viewHeight.intValue(), true);
        this.l1 = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/misceffects.atlas"), "light", 3, UIHelpers.calcWidthProportion(this.game, 35.0f, 70.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 35.0f, 70.0f).floatValue(), false);
        this.l1.setPosition(UIHelpers.calcWidthProportion(this.game, 15.0f, 2.0f).floatValue() - this.l1.getWidth() / 2.0f, UIHelpers.calcHeightProportion(this.game, 77.0f, 71.0f).floatValue() - this.l1.getHeight() / 2.0f);
        this.l1.playAnimation(86400.0f, 0.1f, 0.0f);
        this.l2 = new AnimatedActor(this.game, this.game.getOverridenAsset("data/elements/misceffects.atlas"), "light", 3, UIHelpers.calcWidthProportion(this.game, 35.0f, 70.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 35.0f, 70.0f).floatValue(), false);
        this.l2.setPosition(UIHelpers.calcWidthProportion(this.game, 85.0f, 98.0f).floatValue() - this.l2.getWidth() / 2.0f, UIHelpers.calcHeightProportion(this.game, 77.0f, 71.0f).floatValue() - this.l2.getHeight() / 2.0f);
        this.l2.playAnimation(86400.0f, 0.1f, 0.0f);
        TextureAtlas misceffectsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/elements/misceffects.atlas"), TextureAtlas.class);
        this.t1 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenFilename("data/elements/torch.p")), misceffectsAtlas, UIHelpers.calcWidthProportion(this.game, 15.0f, 2.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 70.0f, 64.0f).floatValue(), true);
        this.stage.addActor(this.t1);
        this.t2 = new ParticleEffectActor(Gdx.files.internal(this.game.getOverridenFilename("data/elements/torch.p")), misceffectsAtlas, UIHelpers.calcWidthProportion(this.game, 86.0f, 98.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 70.0f, 64.0f).floatValue(), true);
        this.stage.addActor(this.t2);
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        BaseActor menu4 = new BaseActor();
        menu4.setTexture(uiAtlas.findRegion("menuinitial4"), UIHelpers.calcWidthProportion(this.game, 35.0f, 70.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 40.0f, 40.0f).floatValue());
        menu4.setPosition((this.game.viewWidth.floatValue() - menu4.getWidth()) / 2.0f, (this.game.viewHeight.floatValue() - menu4.getHeight()) / 2.0f);
        this.stage.addActor(menu4);
        this.bloodtext = new BaseActor();
        this.bloodtext.setPosition(0.0f, 0.0f);
        this.bloodtext.setVisible(false);
        this.stage.addActor(this.bloodtext);
        this.listButtons = new ArrayList();
        TextButton playButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.play"), this.game.uiSkin, "menu");
        playButton.setWidth(menu4.getWidth());
        playButton.setHeight(menu4.getHeight() / 4.0f);
        playButton.getLabel().setFontScale(menu4.getWidth() / 300.0f);
        playButton.setPosition(this.game.viewWidth.floatValue() / 2.0f - menu4.getWidth() / 2.0f, this.game.viewHeight.floatValue() / 2.0f + menu4.getHeight() / 4.0f);
        playButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (MainMenuScreen.this.menuBlocked <= 0.0f) {
                    MainMenuScreen.this.selection = "option1";
                    MainMenuScreen.this.menuBlocked = 100.0f;
                    MainMenuScreen.this.game.manager.get(MainMenuScreen.this.game.getOverridenAsset("sound/whipcrack.ogg"), Sound.class).play(MainMenuScreen.this.game.soundVolume);
                    TextureAtlas uiAtlas = MainMenuScreen.this.game.manager.get(MainMenuScreen.this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
                    MainMenuScreen.this.bloodtext.setTexture(uiAtlas.findRegion(MainMenuScreen.this.game.violenceFilter ? "bloodtext" + (MathUtils.random(2) + 1) + "nonviolent" : "bloodtext" + (MathUtils.random(2) + 1)), UIHelpers.calcWidthProportion(MainMenuScreen.this.game, 31.5f, 63.0f).floatValue(), UIHelpers.calcHeightProportion(MainMenuScreen.this.game, 4.5f, 4.5f).floatValue());
                    MainMenuScreen.this.bloodtext.setPosition(event.getListenerActor().getX() + event.getListenerActor().getWidth() / 20.0f, event.getListenerActor().getY() + event.getListenerActor().getHeight() / 4.0f + event.getListenerActor().getHeight() / 25.0f);
                }
            }
        });
        this.stage.addActor(playButton);
        this.listButtons.add(playButton);
        TextButton optionsButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.options"), this.game.uiSkin, "menu");
        optionsButton.setWidth(menu4.getWidth());
        optionsButton.setHeight(menu4.getHeight() / 4.0f);
        optionsButton.getLabel().setFontScale(menu4.getWidth() / 300.0f);
        optionsButton.setPosition(this.game.viewWidth.floatValue() / 2.0f - menu4.getWidth() / 2.0f, this.game.viewHeight.floatValue() / 2.0f);
        optionsButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (MainMenuScreen.this.menuBlocked <= 0.0f) {
                    MainMenuScreen.this.selection = "option2";
                    MainMenuScreen.this.menuBlocked = 100.0f;
                    MainMenuScreen.this.game.manager.get(MainMenuScreen.this.game.getOverridenAsset("sound/whipcrack.ogg"), Sound.class).play(MainMenuScreen.this.game.soundVolume);
                    TextureAtlas uiAtlas = MainMenuScreen.this.game.manager.get(MainMenuScreen.this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
                    MainMenuScreen.this.bloodtext.setTexture(uiAtlas.findRegion(MainMenuScreen.this.game.violenceFilter ? "bloodtext" + (MathUtils.random(2) + 1) + "nonviolent" : "bloodtext" + (MathUtils.random(2) + 1)), UIHelpers.calcWidthProportion(MainMenuScreen.this.game, 31.5f, 63.0f).floatValue(), UIHelpers.calcHeightProportion(MainMenuScreen.this.game, 4.5f, 4.5f).floatValue());
                    MainMenuScreen.this.bloodtext.setPosition(event.getListenerActor().getX() + event.getListenerActor().getWidth() / 20.0f, event.getListenerActor().getY() + event.getListenerActor().getHeight() / 4.0f + event.getListenerActor().getHeight() / 25.0f);
                }
            }
        });
        this.stage.addActor(optionsButton);
        this.listButtons.add(optionsButton);
        TextButton creditsButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.credits"), this.game.uiSkin, "menu");
        creditsButton.setWidth(menu4.getWidth());
        creditsButton.setHeight(menu4.getHeight() / 4.0f);
        creditsButton.getLabel().setFontScale(menu4.getWidth() / 300.0f);
        creditsButton.setPosition(this.game.viewWidth.floatValue() / 2.0f - menu4.getWidth() / 2.0f, this.game.viewHeight.floatValue() / 2.0f - menu4.getHeight() / 4.0f);
        creditsButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (MainMenuScreen.this.menuBlocked <= 0.0f) {
                    MainMenuScreen.this.selection = "option3";
                    MainMenuScreen.this.menuBlocked = 100.0f;
                    MainMenuScreen.this.game.manager.get(MainMenuScreen.this.game.getOverridenAsset("sound/whipcrack.ogg"), Sound.class).play(MainMenuScreen.this.game.soundVolume);
                    TextureAtlas uiAtlas = MainMenuScreen.this.game.manager.get(MainMenuScreen.this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
                    MainMenuScreen.this.bloodtext.setTexture(uiAtlas.findRegion(MainMenuScreen.this.game.violenceFilter ? "bloodtext" + (MathUtils.random(2) + 1) + "nonviolent" : "bloodtext" + (MathUtils.random(2) + 1)), UIHelpers.calcWidthProportion(MainMenuScreen.this.game, 31.5f, 63.0f).floatValue(), UIHelpers.calcHeightProportion(MainMenuScreen.this.game, 4.5f, 4.5f).floatValue());
                    MainMenuScreen.this.bloodtext.setPosition(event.getListenerActor().getX() + event.getListenerActor().getWidth() / 20.0f, event.getListenerActor().getY() + event.getListenerActor().getHeight() / 4.0f + event.getListenerActor().getHeight() / 25.0f);
                }
            }
        });
        this.stage.addActor(creditsButton);
        this.listButtons.add(creditsButton);
        TextButton exitButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.exit"), this.game.uiSkin, "menu");
        exitButton.setWidth(menu4.getWidth());
        exitButton.setHeight(menu4.getHeight() / 4.0f);
        exitButton.getLabel().setFontScale(menu4.getWidth() / 300.0f);
        exitButton.setPosition(this.game.viewWidth.floatValue() / 2.0f - menu4.getWidth() / 2.0f, this.game.viewHeight.floatValue() / 2.0f - menu4.getHeight() / 2.0f);
        exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (MainMenuScreen.this.menuBlocked <= 0.0f) {
                    MainMenuScreen.this.selection = "option4";
                    MainMenuScreen.this.menuBlocked = 100.0f;
                    MainMenuScreen.this.game.manager.get(MainMenuScreen.this.game.getOverridenAsset("sound/whipcrack.ogg"), Sound.class).play(MainMenuScreen.this.game.soundVolume);
                    TextureAtlas uiAtlas = MainMenuScreen.this.game.manager.get(MainMenuScreen.this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
                    MainMenuScreen.this.bloodtext.setTexture(uiAtlas.findRegion(MainMenuScreen.this.game.violenceFilter ? "bloodtext" + (MathUtils.random(2) + 1) + "nonviolent" : "bloodtext" + (MathUtils.random(2) + 1)), UIHelpers.calcWidthProportion(MainMenuScreen.this.game, 31.5f, 63.0f).floatValue(), UIHelpers.calcHeightProportion(MainMenuScreen.this.game, 4.5f, 4.5f).floatValue());
                    MainMenuScreen.this.bloodtext.setPosition(event.getListenerActor().getX() + event.getListenerActor().getWidth() / 20.0f, event.getListenerActor().getY() + event.getListenerActor().getHeight() / 4.0f + event.getListenerActor().getHeight() / 25.0f);
                }
            }
        });
        this.stage.addActor(exitButton);
        this.listButtons.add(exitButton);
        TextButton activateButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "system.validate"), this.game.uiSkin, "base");
        activateButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                MainMenuScreen.this.game.activationScreen = new ActivationScreen(MainMenuScreen.this.game);
                MainMenuScreen.this.game.setScreen(MainMenuScreen.this.game.activationScreen);
                MainMenuScreen.this.dispose();
            }
        });
        if (PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum).equalsIgnoreCase("normal")) {
            activateButton.setText(PropertiesReader.getMessage(this.game.gameMessages, "system.upgrade"));
        } else if (PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum).equalsIgnoreCase("extra")) {
            activateButton.setVisible(false);
        }
        activateButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        activateButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        activateButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), activateButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        activateButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        activateButton.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - activateButton.getPrefWidth() / 2.0f);
        activateButton.setY(menu4.getY() - activateButton.getPrefHeight() - UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.stage.addActor(activateButton);
        this.gameUpdate = new Label(PropertiesReader.getMessage(this.game.gameMessages, "system.update"), this.game.uiSkin, "default");
        this.gameUpdate.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.gameUpdate.setAlignment(1);
        this.gameUpdate.setColor(this.game.uiSkin.get("iron", Color.class));
        this.gameUpdate.setPosition(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.gameUpdate.getPrefWidth() / 2.0f, UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
        this.gameUpdate.setVisible(false);
        this.stage.addActor(this.gameUpdate);
        Label versionLabel = new Label("[#BFBFBF]" + this.game.version, this.game.uiSkin, "default");
        versionLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        versionLabel.setPosition(UIHelpers.calcWidthProportion(this.game, 99.0f, 99.0f).floatValue() - versionLabel.getPrefWidth(), 0.0f);
        this.stage.addActor(versionLabel);
        BaseActor supporterIcon = new BaseActor();
        supporterIcon.setTexture(uiAtlas.findRegion("supporter"), UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        supporterIcon.setPosition(versionLabel.getX() - UIHelpers.calcWidthProportion(this.game, 1.0f, 1.0f).floatValue() - supporterIcon.getWidth(), UIHelpers.calcHeightProportion(this.game, 0.5f, 0.5f).floatValue());
        if (!PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum).equalsIgnoreCase("extra")) {
            supporterIcon.setVisible(false);
        }
        this.stage.addActor(supporterIcon);
        Label lexiconLabel = new Label(this.game.input.equalsIgnoreCase("keyboard") ? PropertiesReader.getMessage(this.game.gameMessages, "lexicon.key") : PropertiesReader.getMessage(this.game.gameMessages, "lexicon.touch"), this.game.uiSkin, "default");
        lexiconLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        lexiconLabel.setPosition(UIHelpers.calcWidthProportion(this.game, 99.0f, 99.0f).floatValue() - lexiconLabel.getPrefWidth(), this.game.viewHeight.floatValue() - lexiconLabel.getPrefHeight());
        lexiconLabel.layout();
        lexiconLabel.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                MainMenuScreen.this.game.lexiconScreen = new LexiconScreen(MainMenuScreen.this.game, MainMenuScreen.this.game.mainMenuScreen);
                MainMenuScreen.this.game.setScreen(MainMenuScreen.this.game.lexiconScreen);
            }
        });
        this.stage.addActor(lexiconLabel);
        this.game.networkPort = new NetworkPort(this.game);
        this.game.networkPort.sendHttpRequest("GET", "https://calimasaga.com/sp/version", "", null);
        this.addFadeOverlay(Float.valueOf(0.0f));
        this.doFade("in", Float.valueOf(0.1f));
    }

    @Override
    public void render(float delta) {
        if (this.menuBlocked > 0.0f) {
            if (this.menuBlocked > 2.0f && this.menuBlocked < 50.0f) {
                this.bloodtext.setVisible(true);
            } else if (this.menuBlocked <= 2.0f) {
                this.bloodtext.setVisible(false);
                if (this.selectionLevel == 1) {
                    if (this.selection.equalsIgnoreCase("option1")) {
                        this.selectionLevel = 11;
                        this.listButtons.get(0).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.story"));
                        this.listButtons.get(1).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.custom"));
                        this.listButtons.get(2).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.duel"));
                        this.listButtons.get(3).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.mainmenu"));
                    } else if (this.selection.equalsIgnoreCase("option2")) {
                        this.game.optionsMenuScreen = new OptionsMenuScreen(this.game, false);
                        this.game.setScreen(this.game.optionsMenuScreen);
                        this.dispose();
                    } else if (this.selection.equalsIgnoreCase("option3")) {
                        this.game.creditsScreen = new CreditsScreen(this.game, false);
                        this.game.setScreen(this.game.creditsScreen);
                    } else if (this.selection.equalsIgnoreCase("option4")) {
                        this.game.dispose();
                    }
                } else if (this.selectionLevel == 11) {
                    if (this.selection.equalsIgnoreCase("option1")) {
                        this.game.gameMode = "story";
                        this.game.saveGameScreen = new SaveGameScreen(this.game);
                        this.game.setScreen(this.game.saveGameScreen);
                        this.dispose();
                    } else if (this.selection.equalsIgnoreCase("option2")) {
                        this.game.gameMode = "tournament";
                        this.selectionLevel = 112;
                        this.listButtons.get(0).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.new"));
                        this.game.saveGame.clear();
                        this.game.saveGame = PropertiesReader.loadGame(4, this.game.mail, this.game.key, this.game.debugMode);
                        if (!this.game.saveGame.get("name").equalsIgnoreCase("0") && this.game.saveGame.get("delete") == null) {
                            this.listButtons.get(1).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.continue"));
                        } else {
                            PropertiesReader.deleteGame(4, this.game.mail, this.game.key);
                            this.listButtons.get(1).setText("");
                        }
                        this.listButtons.get(2).setText("");
                        this.listButtons.get(3).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.mainmenu"));
                    } else if (this.selection.equalsIgnoreCase("option3")) {
                        this.game.saveGame = new HashMap();
                        this.selectionLevel = 113;
                        this.listButtons.get(0).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.host"));
                        this.listButtons.get(1).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.join"));
                        this.listButtons.get(2).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.practice"));
                        this.listButtons.get(3).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.mainmenu"));
                    } else if (this.selection.equalsIgnoreCase("option4")) {
                        this.selectionLevel = 1;
                        this.listButtons.get(0).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.play"));
                        this.listButtons.get(1).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.options"));
                        this.listButtons.get(2).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.credits"));
                        this.listButtons.get(3).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.exit"));
                    }
                } else if (this.selectionLevel == 113) {
                    if (this.selection.equalsIgnoreCase("option1")) {
                        this.game.gameMode = "server";
                        this.game.multiplayerScreen = new MultiplayerScreen(this.game);
                        this.game.setScreen(this.game.multiplayerScreen);
                        this.dispose();
                    } else if (this.selection.equalsIgnoreCase("option2")) {
                        this.game.gameMode = "client";
                        this.game.multiplayerScreen = new MultiplayerScreen(this.game);
                        this.game.setScreen(this.game.multiplayerScreen);
                        this.dispose();
                    } else if (this.selection.equalsIgnoreCase("option3")) {
                        this.game.gameMode = "practice";
                        this.game.multiplayerPlayerNameServer = "Player";
                        this.game.multiplayerPlayerNameClient = "Computer";
                        this.game.duelSetupScreen = new DuelSetupScreen(this.game, Integer.parseInt(((JSONObject)((JSONObject)this.game.stats.get("phases").get("limits")).get("pits")).getString("maxReputation")));
                        this.game.setScreen(this.game.duelSetupScreen);
                        this.dispose();
                    } else if (this.selection.equalsIgnoreCase("option4")) {
                        this.selectionLevel = 1;
                        this.listButtons.get(0).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.play"));
                        this.listButtons.get(1).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.options"));
                        this.listButtons.get(2).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.credits"));
                        this.listButtons.get(3).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.exit"));
                    }
                } else if (this.selectionLevel == 112) {
                    if (this.selection.equalsIgnoreCase("option1")) {
                        this.game.gameMode = "tournament";
                        this.game.saveGame.clear();
                        this.game.saveGame = PropertiesReader.loadGame(4, this.game.mail, this.game.key, this.game.debugMode);
                        this.game.tournamentGameScreen = new TournamentGameScreen(this.game);
                        this.game.setScreen(this.game.tournamentGameScreen);
                        this.dispose();
                    } else if (this.selection.equalsIgnoreCase("option2")) {
                        this.game.gameMode = "tournament";
                        this.game.saveGame.clear();
                        this.game.saveGame = PropertiesReader.loadGame(4, this.game.mail, this.game.key, this.game.debugMode);
                        if (!this.game.saveGame.get("name").equalsIgnoreCase("0") && this.game.saveGame.get("delete") == null) {
                            Tournament.loadState(this.game);
                        }
                    } else if (!this.selection.equalsIgnoreCase("option3") && this.selection.equalsIgnoreCase("option4")) {
                        this.selectionLevel = 1;
                        this.listButtons.get(0).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.play"));
                        this.listButtons.get(1).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.options"));
                        this.listButtons.get(2).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.credits"));
                        this.listButtons.get(3).setText(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.exit"));
                    }
                }
            }
            this.menuBlocked -= 2.0f;
        }
        this.game.manager.update();
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.getBatch().setBlendFunction(770, 771);
        this.stage.draw();
        this.stage.getViewport().apply();
        this.frameBuffer.begin();
        Gdx.gl.glClearColor(0.8f, 0.8f, 0.8f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.getBatch().setBlendFunction(770, 1);
        this.stage.getBatch().begin();
        this.l1.act(delta);
        this.l2.act(delta);
        this.l1.draw(this.stage.getBatch(), 1.0f);
        this.l2.draw(this.stage.getBatch(), 1.0f);
        this.stage.getBatch().end();
        this.frameBuffer.end(this.stage.getViewport().getScreenX(), this.stage.getViewport().getScreenY(), this.stage.getViewport().getScreenWidth(), this.stage.getViewport().getScreenHeight());
        this.stage.getBatch().setBlendFunction(774, 0);
        this.stage.getBatch().begin();
        this.stage.getBatch().draw((Texture)this.frameBuffer.getColorBufferTexture(), 0.0f, 0.0f, this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f, 1.0f, 1.0f);
        this.stage.getBatch().end();
        this.stage.getViewport().apply();
    }

    @Override
    public void dispose() {
        UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset("data/backgrounds/backgroundtitle.jpg"));
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 244) {
            this.game.lexiconScreen = new LexiconScreen(this.game, this.game.mainMenuScreen);
            this.game.setScreen(this.game.lexiconScreen);
        } else if (keycode == 253) {
            this.game.achievements = PropertiesReader.loadAchievements(this.game.mail, this.game.key, true);
            PropertiesReader.saveAchievements(this.game.achievements, this.game.mail, this.game.key, true);
            this.game.saveGame.clear();
            this.game.saveGame = PropertiesReader.loadGame(1, this.game.mail, this.game.key, true);
            PropertiesReader.saveGame(this.game.saveGame, 1, this.game.mail, this.game.key, true);
            this.game.saveGame.clear();
            this.game.saveGame = PropertiesReader.loadGame(2, this.game.mail, this.game.key, true);
            PropertiesReader.saveGame(this.game.saveGame, 2, this.game.mail, this.game.key, true);
            this.game.saveGame.clear();
            this.game.saveGame = PropertiesReader.loadGame(3, this.game.mail, this.game.key, true);
            PropertiesReader.saveGame(this.game.saveGame, 3, this.game.mail, this.game.key, true);
            this.game.saveGame.clear();
            this.game.saveGame = PropertiesReader.loadGame(4, this.game.mail, this.game.key, true);
            PropertiesReader.saveGame(this.game.saveGame, 4, this.game.mail, this.game.key, true);
        }
        return false;
    }

    @Override
    public void receivedHttpResponse(Net.HttpResponse httpResponse) {
        if (httpResponse != null && httpResponse.getStatus().getStatusCode() == 200) {
            String result = httpResponse.getResultAsString();
            if (!result.equalsIgnoreCase("") && result.equalsIgnoreCase("kok")) {
                this.game.checksum = PropertiesReader.calculateChecksum(this.game.mail, this.game.key);
                this.game.settings.setProperty("checksum", "" + this.game.checksum);
                PropertiesReader.saveSettings(this.game.settings);
            } else if (!result.equalsIgnoreCase("") && result.equalsIgnoreCase("knok")) {
                this.game.checksum = -1L;
                this.game.settings.setProperty("checksum", "-1");
                PropertiesReader.saveSettings(this.game.settings);
            }
            if (!result.equalsIgnoreCase("") && !result.equalsIgnoreCase(PropertiesReader.getVersion())) {
                this.gameUpdate.setVisible(true);
                if (this.game.checksum != -1L && Math.abs(PropertiesReader.getChecksum(this.game.mail, this.game.key, this.game.checksum) - System.currentTimeMillis() / 1000L) > 84600L) {
                    this.game.networkPort = new NetworkPort(this.game);
                    this.game.networkPort.sendHttpRequest("GET", "https://calimasaga.com/sp/checksum?p1=" + PropertiesReader.getHashedValue(this.game.mail) + "&p2=" + PropertiesReader.getHashedValue(this.game.key), "", null);
                }
            }
        }
    }
}

