/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.SkinLoader;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.calimasaga.json.JSONException;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.util.Logger;
import java.util.HashMap;

public class LoadingScreen
extends BaseScreen {
    public BaseActor baseLoadingBar;
    public BaseActor loadingBar;

    public LoadingScreen(SlavePitsGame g) {
        super(g);
        this.create();
    }

    public void loadAssets(boolean retro) {
        this.game.loadGenericAsset("data/backgrounds/overlay.png", Texture.class);
        this.game.loadGenericAsset("data/backgrounds/overlay.png", Texture.class);
        this.game.loadGenericAsset("data/backgrounds/white.png", Texture.class);
        this.game.loadGenericAsset("data/figures/empty.png", Texture.class);
        this.game.loadGenericAsset("data/figures/bodybuff.png", Texture.class);
        this.game.loadGenericAsset("data/figures/bodyfloor.png", Texture.class);
        this.game.loadGenericAsset("data/figures/bodykneel.png", Texture.class);
        this.game.loadGenericAsset("data/figures/net1hright1.png", Texture.class);
        this.game.loadGenericAsset("data/figures/netpc1hright1.png", Texture.class);
        this.game.loadGenericAsset("data/figures/powder1hright1.png", Texture.class);
        this.game.loadGenericAsset("data/figures/powderpc1hright1.png", Texture.class);
        this.game.loadGenericAsset("data/figures/shard1hright1.png", Texture.class);
        this.game.loadGenericAsset("data/figures/shardpc1hright1.png", Texture.class);
        this.game.loadGenericAsset("data/figures/pcarmsbuff.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundb1.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundb2.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundb3.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundb4.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundb5.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundb6.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundc1.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundc2.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundc3.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundc4.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundc5.png", Texture.class);
        this.game.loadGenericAsset("data/figures/woundc6.png", Texture.class);
        FileHandle directoryListing = Gdx.files.internal("sound");
        for (FileHandle currFileName : directoryListing.list()) {
            this.game.loadGenericAsset(this.game.getOverridenAsset("sound/" + currFileName.name()), Sound.class);
        }
        this.game.loadGenericAsset("data/elements/combatbuttons.atlas", TextureAtlas.class);
        this.game.loadGenericAsset("data/elements/combateffects.atlas", TextureAtlas.class);
        this.game.loadGenericAsset("data/equipment/equipment.atlas", TextureAtlas.class);
        this.game.loadGenericAsset("data/equipment/services.atlas", TextureAtlas.class);
        this.game.loadGenericAsset("data/elements/misceffects.atlas", TextureAtlas.class);
        this.game.loadGenericAsset("data/portraits/portraits.atlas", TextureAtlas.class);
        this.game.loadGenericAsset("data/talents/talents.atlas", TextureAtlas.class);
        try {
            this.game.stats = new HashMap();
            this.game.loadGenericSettings("weapons", "data/weapons.json");
            this.game.loadGenericSettings("armors", "data/armors.json");
            this.game.loadGenericSettings("talents", "data/talents.json");
            this.game.loadGenericSettings("effects", "data/effects.json");
            this.game.loadGenericSettings("tiers", "data/tiers.json");
            this.game.loadGenericSettings("timings", "data/timings.json");
            this.game.loadGenericSettings("opponents", "data/opponents.json");
            this.game.loadGenericSettings("phases", "data/phases.json");
            this.game.loadGenericSettings("parts", "data/parts.json");
            this.game.loadGenericSettings("story", "data/story.json");
            this.game.loadGenericSettings("tournament", "data/tournament.json");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void create() {
        this.game.manager.load(this.game.getOverridenFilename("ui/uisl.atlas"), TextureAtlas.class);
        this.game.manager.load(this.game.getOverridenFilename("ui/uisl.json"), Skin.class, new SkinLoader.SkinParameter(this.game.getOverridenAsset("ui/uisl.atlas")));
        this.game.manager.finishLoading();
        BaseActor background = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, background, this.game.getOverridenFilename("data/backgrounds/loadscreen.jpg"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.stage.addActor(background);
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        this.baseLoadingBar = new BaseActor();
        this.baseLoadingBar.setTexture(uiAtlas.findRegion("statbar"), UIHelpers.calcWidthProportion(this.game, 25.0f, 35.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.baseLoadingBar.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.baseLoadingBar.getWidth() / 2.0f);
        this.baseLoadingBar.setY(UIHelpers.calcHeightProportion(this.game, 40.0f, 40.0f).floatValue());
        this.stage.addActor(this.baseLoadingBar);
        this.loadingBar = new BaseActor();
        this.loadingBar.setTexture(uiAtlas.findRegion("load"), this.baseLoadingBar.getHeight() * 0.65f, this.baseLoadingBar.getHeight() * 0.65f);
        this.loadingBar.setX(this.baseLoadingBar.getX() + 7.0f);
        this.loadingBar.setY(this.baseLoadingBar.getY() + this.baseLoadingBar.getHeight() * 0.18f);
        this.stage.addActor(this.loadingBar);
        Pixmap cursorImage = new Pixmap(Gdx.files.internal(this.game.getOverridenFilename("ui/cursor.png")));
        Cursor cursor = Gdx.graphics.newCursor(cursorImage, 0, 0);
        Gdx.graphics.setCursor(cursor);
        this.loadAssets(false);
    }

    @Override
    public void render(float delta) {
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
        if (this.game.manager.update()) {
            Logger.write(Logger.INFO, "Loaded base resources, memory used: " + Gdx.app.getJavaHeap());
            this.game.uiSkin = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.json"), Skin.class);
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
            this.dispose();
        } else {
            this.loadingBar.setWidth(Float.valueOf((this.baseLoadingBar.getWidth() - 14.0f) * this.game.manager.getProgress()).intValue());
        }
    }

    @Override
    public void dispose() {
        UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset("data/backgrounds/loadscreen.jpg"));
    }
}

