/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import com.calimasaga.slavepits.util.StringList;

public class JournalScreen
extends BaseScreen {
    private BaseScreen previousScreen;
    private NinePatchActor background;
    private Label description;
    private ScrollPane descriptionPane;

    public JournalScreen(SlavePitsGame g, BaseScreen s) {
        super(g);
        this.previousScreen = s;
        this.create();
    }

    @Override
    public void create() {
        this.background = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        this.background.setWidth(UIHelpers.calcWidthProportion(this.game, 80.0f, 98.0f).floatValue());
        this.background.setHeight(UIHelpers.calcHeightProportion(this.game, 80.0f, 89.0f).floatValue());
        this.background.setX(UIHelpers.calcWidthProportion(this.game, 10.0f, 1.0f).floatValue());
        this.background.setY(UIHelpers.calcHeightProportion(this.game, 15.0f, 10.0f).floatValue());
        this.stage.addActor(this.background);
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        StringBuilder descriptionText = new StringBuilder();
        if (this.game.gameMode.equalsIgnoreCase("story")) {
            Label lWorshippers = new Label(PropertiesReader.getMessage(this.game.gameMessages, "journal.stat.worshippers"), this.game.uiSkin, "default");
            lWorshippers.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * (float)(this.game.portraitmode ? 3 : 2) / 2.0f));
            lWorshippers.setColor(this.game.uiSkin.get("lightiron", Color.class));
            lWorshippers.setAlignment(16);
            lWorshippers.setVisible(true);
            lWorshippers.setX(this.background.getX() + this.background.getWidth() * 35.0f / 100.0f - lWorshippers.getWidth() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
            lWorshippers.setY(this.background.getY() + this.background.getHeight() * 95.0f / 100.0f - lWorshippers.getPrefHeight() / 2.0f);
            this.stage.addActor(lWorshippers);
            Label lCrafters = new Label(PropertiesReader.getMessage(this.game.gameMessages, "journal.stat.crafters"), this.game.uiSkin, "default");
            lCrafters.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * (float)(this.game.portraitmode ? 3 : 2) / 2.0f));
            lCrafters.setColor(this.game.uiSkin.get("lightiron", Color.class));
            lCrafters.setAlignment(8);
            lCrafters.setVisible(true);
            lCrafters.setX(this.background.getX() + this.background.getWidth() * 65.0f / 100.0f + UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
            lCrafters.setY(this.background.getY() + this.background.getHeight() * 95.0f / 100.0f - lCrafters.getPrefHeight() / 2.0f);
            this.stage.addActor(lCrafters);
            StringBuilder currRewards = StringList.create(this.game.saveGame.get("rewards"), ";");
            int facwor = 0;
            int facjus = 0;
            int facthreshold = 45;
            float reppen = 0.0f;
            for (int i = 2; i < StringList.size(currRewards, ";"); ++i) {
                String currReward = StringList.get(currRewards, i, ";");
                if (currReward.startsWith("facwor")) {
                    facwor += Integer.parseInt(currReward.split(":")[1]);
                    continue;
                }
                if (currReward.startsWith("facjus")) {
                    facjus += Integer.parseInt(currReward.split(":")[1]);
                    continue;
                }
                if (currReward.startsWith("reppen")) {
                    reppen += Float.parseFloat(currReward.split(":")[1]);
                    continue;
                }
                if (currReward.startsWith("upgrad")) {
                    descriptionText.append("- ");
                    descriptionText.append(PropertiesReader.getMessage(this.game.gameMessages, "journal.reward.upgrad"));
                    descriptionText.append("\n");
                    continue;
                }
                if (PropertiesReader.getMessage(this.game.gameMessages, "journal.reward." + currReward).equalsIgnoreCase("")) continue;
                descriptionText.append("- ");
                descriptionText.append(PropertiesReader.getMessage(this.game.gameMessages, "journal.reward." + currReward));
                descriptionText.append("\n");
            }
            if (facwor > facthreshold) {
                facwor = facthreshold;
            }
            if (facwor < facthreshold * -1) {
                facwor = facthreshold * -1;
            }
            if (facjus > facthreshold) {
                facjus = facthreshold;
            }
            if (facjus < facthreshold * -1) {
                facjus = facthreshold * -1;
            }
            if (reppen > 0.0f) {
                descriptionText.append("- ");
                descriptionText.append(PropertiesReader.getMessage(this.game.gameMessages, "journal.reward.reppen"));
                descriptionText.append("\n");
            }
            BaseActor worbar1 = new BaseActor();
            worbar1.setTexture(uiAtlas.findRegion("white"), MathUtils.clamp(this.background.getWidth() * 15.0f / 100.0f * (float)Math.abs(facwor) / (float)facthreshold, 0.0f, this.background.getWidth() * 15.0f / 100.0f), 10.0f);
            worbar1.setColor(new Color(1.0f, 0.5f, 0.0f, 1.0f));
            worbar1.setX(this.background.getX() + this.background.getWidth() / 2.0f + (facwor < 0 ? 0.0f : worbar1.getWidth() * -1.0f));
            worbar1.setY(this.background.getY() + this.background.getHeight() * 95.0f / 100.0f - 5.0f);
            this.stage.addActor(worbar1);
            BaseActor worbar2 = new BaseActor();
            worbar2.setTexture(uiAtlas.findRegion("white"), MathUtils.clamp(this.background.getWidth() * 15.0f / 100.0f * (float)Math.abs(facwor) / (float)facthreshold, 0.0f, this.background.getWidth() * 15.0f / 100.0f / 3.0f), 10.0f);
            worbar2.setColor(new Color(1.0f, 1.0f, 0.0f, 1.0f));
            worbar2.setX(this.background.getX() + this.background.getWidth() / 2.0f + (facwor < 0 ? 0.0f : worbar2.getWidth() * -1.0f));
            worbar2.setY(this.background.getY() + this.background.getHeight() * 95.0f / 100.0f - 5.0f);
            this.stage.addActor(worbar2);
            BaseActor sepbar1 = new BaseActor();
            sepbar1.setTexture(uiAtlas.findRegion("white"), 3.0f, lWorshippers.getPrefHeight());
            sepbar1.setColor(new Color(0.0f, 0.0f, 0.0f, 1.0f));
            sepbar1.setX(this.background.getX() + this.background.getWidth() / 2.0f);
            sepbar1.setY(this.background.getY() + this.background.getHeight() * 95.0f / 100.0f - lWorshippers.getPrefHeight() / 2.0f);
            this.stage.addActor(sepbar1);
            Label lJustice = new Label(PropertiesReader.getMessage(this.game.gameMessages, "journal.stat.justice"), this.game.uiSkin, "default");
            lJustice.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * (float)(this.game.portraitmode ? 3 : 2) / 2.0f));
            lJustice.setColor(this.game.uiSkin.get("lightiron", Color.class));
            lJustice.setAlignment(16);
            lJustice.setVisible(true);
            lJustice.setX(this.background.getX() + this.background.getWidth() * 35.0f / 100.0f - lJustice.getWidth() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
            lJustice.setY(this.background.getY() + this.background.getHeight() * 90.0f / 100.0f - lJustice.getPrefHeight() / 2.0f);
            this.stage.addActor(lJustice);
            Label lVengeance = new Label(PropertiesReader.getMessage(this.game.gameMessages, "journal.stat.vengeance"), this.game.uiSkin, "default");
            lVengeance.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * (float)(this.game.portraitmode ? 3 : 2) / 2.0f));
            lVengeance.setColor(this.game.uiSkin.get("lightiron", Color.class));
            lVengeance.setAlignment(8);
            lVengeance.setVisible(true);
            lVengeance.setX(this.background.getX() + this.background.getWidth() * 65.0f / 100.0f + UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
            lVengeance.setY(this.background.getY() + this.background.getHeight() * 90.0f / 100.0f - lVengeance.getPrefHeight() / 2.0f);
            this.stage.addActor(lVengeance);
            BaseActor worbar3 = new BaseActor();
            worbar3.setTexture(uiAtlas.findRegion("white"), MathUtils.clamp(this.background.getWidth() * 15.0f / 100.0f * (float)Math.abs(facjus) / (float)facthreshold, 0.0f, this.background.getWidth() * 15.0f / 100.0f), 10.0f);
            worbar3.setColor(new Color(1.0f, 0.5f, 0.0f, 1.0f));
            worbar3.setX(this.background.getX() + this.background.getWidth() / 2.0f + (facjus < 0 ? 0.0f : worbar3.getWidth() * -1.0f));
            worbar3.setY(this.background.getY() + this.background.getHeight() * 90.0f / 100.0f - 5.0f);
            this.stage.addActor(worbar3);
            BaseActor worbar4 = new BaseActor();
            worbar4.setTexture(uiAtlas.findRegion("white"), MathUtils.clamp(this.background.getWidth() * 15.0f / 100.0f * (float)Math.abs(facjus) / (float)facthreshold, 0.0f, this.background.getWidth() * 15.0f / 100.0f / 3.0f), 10.0f);
            worbar4.setColor(new Color(1.0f, 1.0f, 0.0f, 1.0f));
            worbar4.setX(this.background.getX() + this.background.getWidth() / 2.0f + (facjus < 0 ? 0.0f : worbar4.getWidth() * -1.0f));
            worbar4.setY(this.background.getY() + this.background.getHeight() * 90.0f / 100.0f - 5.0f);
            this.stage.addActor(worbar4);
            BaseActor sepbar2 = new BaseActor();
            sepbar2.setTexture(uiAtlas.findRegion("white"), 3.0f, lJustice.getPrefHeight());
            sepbar2.setColor(new Color(0.0f, 0.0f, 0.0f, 1.0f));
            sepbar2.setX(this.background.getX() + this.background.getWidth() / 2.0f);
            sepbar2.setY(this.background.getY() + this.background.getHeight() * 90.0f / 100.0f - lJustice.getPrefHeight() / 2.0f);
            this.stage.addActor(sepbar2);
        } else if (this.game.gameMode.equalsIgnoreCase("tournament")) {
            StringBuilder currRewards = StringList.create(this.game.saveGame.get("rewards"), ";");
            for (int i = 2; i < StringList.size(currRewards, ";"); ++i) {
                String currReward = StringList.get(currRewards, i, ";");
                if (currReward.startsWith("maintenance")) {
                    int maintenanceAmount = Integer.parseInt(currReward.split(":")[1]);
                    if (maintenanceAmount > 0) {
                        descriptionText.append("- ");
                        descriptionText.append(PropertiesReader.getMessage(this.game.gameMessages, "journal.reward.maintenance") + ": " + maintenanceAmount);
                        descriptionText.append("\n");
                        continue;
                    }
                    if (maintenanceAmount >= 0) continue;
                    descriptionText.append("- ");
                    descriptionText.append(PropertiesReader.getMessage(this.game.gameMessages, "journal.reward.pay") + ": " + maintenanceAmount * -1);
                    descriptionText.append("\n");
                    continue;
                }
                if (Integer.parseInt(currReward.split(":")[1]) <= 0 || PropertiesReader.getMessage(this.game.gameMessages, "journal.reward." + currReward.split(":")[0]).equalsIgnoreCase("")) continue;
                descriptionText.append("- ");
                descriptionText.append(PropertiesReader.getMessage(this.game.gameMessages, "journal.reward." + currReward.split(":")[0]));
                descriptionText.append("\n");
            }
        }
        this.description = new Label(descriptionText, this.game.uiSkin, "default");
        this.description.setAlignment(10);
        this.description.setColor(this.game.uiSkin.get("silver", Color.class));
        this.description.setWrap(true);
        this.description.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.description.setWidth(this.background.getWidth() - 68.0f);
        UIHelpers.fixLabelFontSize(this.description, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, this.background.getHeight() * 85.0f / 100.0f);
        this.stage.addActor(this.description);
        this.descriptionPane = new ScrollPane((Actor)this.description);
        this.descriptionPane.addListener(new InputListener(){

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                JournalScreen.this.stage.setScrollFocus(null);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                JournalScreen.this.stage.setScrollFocus(event.getListenerActor());
            }
        });
        this.descriptionPane.setForceScroll(false, true);
        this.descriptionPane.setFlickScroll(false);
        this.descriptionPane.setOverscroll(false, true);
        this.descriptionPane.setWidth(this.description.getWidth());
        this.descriptionPane.setX(this.background.getX() + 34.0f);
        this.descriptionPane.setHeight(this.description.getPrefHeight());
        this.descriptionPane.layout();
        this.descriptionPane.setY(this.background.getY() + this.background.getHeight() * (float)(87 + (this.game.gameMode.equalsIgnoreCase("tournament") ? 10 : 0)) / 100.0f - 34.0f - this.descriptionPane.getHeight());
        this.descriptionPane.setScrollY(0.0f);
        this.stage.addActor(this.descriptionPane);
        TextButton exitButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "common.exit"), this.game.uiSkin, "base");
        exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                JournalScreen.this.game.setScreen(JournalScreen.this.previousScreen);
                JournalScreen.this.dispose();
            }
        });
        exitButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        exitButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        exitButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), exitButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - exitButton.getPrefWidth() / 2.0f);
        exitButton.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 1.0f).floatValue());
        this.stage.addActor(exitButton);
    }

    @Override
    public void render(float delta) {
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }
}

