/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.CombatScreen;
import com.calimasaga.slavepits.screen.LexiconScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.screen.OptionsMenuScreen;
import com.calimasaga.slavepits.util.PropertiesReader;

public class GameMenuScreen
extends BaseScreen {
    private BaseScreen previousScreen;
    private float menuBlocked = 0.0f;
    private String selection;
    private BaseActor bloodtext;
    public TextButton resumeButton;

    public GameMenuScreen(SlavePitsGame g, BaseScreen s) {
        super(g);
        this.previousScreen = s;
        this.create();
    }

    @Override
    public void create() {
        BaseActor overlay = new BaseActor();
        overlay.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/overlay.png"), Texture.class), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
        overlay.setColor(new Color(0.0f, 0.0f, 0.0f, 0.7f));
        overlay.setPosition(0.0f, 0.0f);
        this.stage.addActor(overlay);
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        BaseActor menu4 = new BaseActor();
        menu4.setTexture(uiAtlas.findRegion("menuinitial4"), UIHelpers.calcWidthProportion(this.game, 35.0f, 70.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 40.0f, 40.0f).floatValue());
        menu4.setPosition((this.game.viewWidth.floatValue() - menu4.getWidth()) / 2.0f, (this.game.viewHeight.floatValue() - menu4.getHeight()) / 2.0f);
        this.stage.addActor(menu4);
        this.bloodtext = new BaseActor();
        this.bloodtext.setPosition(0.0f, 0.0f);
        this.bloodtext.setVisible(false);
        this.stage.addActor(this.bloodtext);
        this.resumeButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "gamemenu.resume"), this.game.uiSkin, "menu");
        this.resumeButton.setWidth(menu4.getWidth());
        this.resumeButton.setHeight(menu4.getHeight() / 4.0f);
        this.resumeButton.getLabel().setFontScale(menu4.getWidth() / 300.0f);
        this.resumeButton.setPosition(this.game.viewWidth.floatValue() / 2.0f - menu4.getWidth() / 2.0f, this.game.viewHeight.floatValue() / 2.0f + menu4.getHeight() / 4.0f);
        this.resumeButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (GameMenuScreen.this.menuBlocked <= 0.0f) {
                    GameMenuScreen.this.menuBlocked = 100.0f;
                    GameMenuScreen.this.selection = "option1";
                    GameMenuScreen.this.game.manager.get(GameMenuScreen.this.game.getOverridenAsset("sound/whipcrack.ogg"), Sound.class).play(GameMenuScreen.this.game.soundVolume);
                    TextureAtlas uiAtlas = GameMenuScreen.this.game.manager.get(GameMenuScreen.this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
                    GameMenuScreen.this.bloodtext.setTexture(uiAtlas.findRegion(GameMenuScreen.this.game.violenceFilter ? "bloodtext" + (MathUtils.random(2) + 1) + "nonviolent" : "bloodtext" + (MathUtils.random(2) + 1)), UIHelpers.calcWidthProportion(GameMenuScreen.this.game, 31.5f, 63.0f).floatValue(), UIHelpers.calcHeightProportion(GameMenuScreen.this.game, 4.5f, 4.5f).floatValue());
                    GameMenuScreen.this.bloodtext.setPosition(event.getListenerActor().getX() + event.getListenerActor().getWidth() / 20.0f, event.getListenerActor().getY() + event.getListenerActor().getHeight() / 4.0f + event.getListenerActor().getHeight() / 25.0f);
                }
            }
        });
        this.stage.addActor(this.resumeButton);
        TextButton optionsButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.options"), this.game.uiSkin, "menu");
        optionsButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (GameMenuScreen.this.menuBlocked <= 0.0f) {
                    GameMenuScreen.this.menuBlocked = 100.0f;
                    GameMenuScreen.this.selection = "option2";
                    GameMenuScreen.this.game.manager.get(GameMenuScreen.this.game.getOverridenAsset("sound/whipcrack.ogg"), Sound.class).play(GameMenuScreen.this.game.soundVolume);
                    TextureAtlas uiAtlas = GameMenuScreen.this.game.manager.get(GameMenuScreen.this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
                    GameMenuScreen.this.bloodtext.setTexture(uiAtlas.findRegion(GameMenuScreen.this.game.violenceFilter ? "bloodtext" + (MathUtils.random(2) + 1) + "nonviolent" : "bloodtext" + (MathUtils.random(2) + 1)), UIHelpers.calcWidthProportion(GameMenuScreen.this.game, 31.5f, 63.0f).floatValue(), UIHelpers.calcHeightProportion(GameMenuScreen.this.game, 4.5f, 4.5f).floatValue());
                    GameMenuScreen.this.bloodtext.setPosition(event.getListenerActor().getX() + event.getListenerActor().getWidth() / 20.0f, event.getListenerActor().getY() + event.getListenerActor().getHeight() / 4.0f + event.getListenerActor().getHeight() / 25.0f);
                }
            }
        });
        optionsButton.setWidth(menu4.getWidth());
        optionsButton.setHeight(menu4.getHeight() / 4.0f);
        optionsButton.getLabel().setFontScale(menu4.getWidth() / 300.0f);
        optionsButton.setPosition(this.game.viewWidth.floatValue() / 2.0f - menu4.getWidth() / 2.0f, this.game.viewHeight.floatValue() / 2.0f);
        this.stage.addActor(optionsButton);
        TextButton menuButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.mainmenu"), this.game.uiSkin, "menu");
        menuButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (GameMenuScreen.this.menuBlocked <= 0.0f) {
                    GameMenuScreen.this.menuBlocked = 100.0f;
                    GameMenuScreen.this.selection = "option3";
                    GameMenuScreen.this.game.manager.get(GameMenuScreen.this.game.getOverridenAsset("sound/whipcrack.ogg"), Sound.class).play(GameMenuScreen.this.game.soundVolume);
                    TextureAtlas uiAtlas = GameMenuScreen.this.game.manager.get(GameMenuScreen.this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
                    GameMenuScreen.this.bloodtext.setTexture(uiAtlas.findRegion(GameMenuScreen.this.game.violenceFilter ? "bloodtext" + (MathUtils.random(2) + 1) + "nonviolent" : "bloodtext" + (MathUtils.random(2) + 1)), UIHelpers.calcWidthProportion(GameMenuScreen.this.game, 31.5f, 63.0f).floatValue(), UIHelpers.calcHeightProportion(GameMenuScreen.this.game, 4.5f, 4.5f).floatValue());
                    GameMenuScreen.this.bloodtext.setPosition(event.getListenerActor().getX() + event.getListenerActor().getWidth() / 20.0f, event.getListenerActor().getY() + event.getListenerActor().getHeight() / 4.0f + event.getListenerActor().getHeight() / 25.0f);
                }
            }
        });
        menuButton.setWidth(menu4.getWidth());
        menuButton.setHeight(menu4.getHeight() / 4.0f);
        menuButton.getLabel().setFontScale(menu4.getWidth() / 300.0f);
        menuButton.setPosition(this.game.viewWidth.floatValue() / 2.0f - menu4.getWidth() / 2.0f, this.game.viewHeight.floatValue() / 2.0f - menu4.getHeight() / 4.0f);
        this.stage.addActor(menuButton);
        TextButton exitButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "mainmenu.exit"), this.game.uiSkin, "menu");
        exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (GameMenuScreen.this.menuBlocked <= 0.0f) {
                    GameMenuScreen.this.menuBlocked = 100.0f;
                    GameMenuScreen.this.selection = "option4";
                    GameMenuScreen.this.game.manager.get(GameMenuScreen.this.game.getOverridenAsset("sound/whipcrack.ogg"), Sound.class).play(GameMenuScreen.this.game.soundVolume);
                    TextureAtlas uiAtlas = GameMenuScreen.this.game.manager.get(GameMenuScreen.this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
                    GameMenuScreen.this.bloodtext.setTexture(uiAtlas.findRegion(GameMenuScreen.this.game.violenceFilter ? "bloodtext" + (MathUtils.random(2) + 1) + "nonviolent" : "bloodtext" + (MathUtils.random(2) + 1)), UIHelpers.calcWidthProportion(GameMenuScreen.this.game, 31.5f, 63.0f).floatValue(), UIHelpers.calcHeightProportion(GameMenuScreen.this.game, 4.5f, 4.5f).floatValue());
                    GameMenuScreen.this.bloodtext.setPosition(event.getListenerActor().getX() + event.getListenerActor().getWidth() / 20.0f, event.getListenerActor().getY() + event.getListenerActor().getHeight() / 4.0f + event.getListenerActor().getHeight() / 25.0f);
                }
            }
        });
        exitButton.setWidth(menu4.getWidth());
        exitButton.setHeight(menu4.getHeight() / 4.0f);
        exitButton.getLabel().setFontScale(menu4.getWidth() / 300.0f);
        exitButton.setPosition(this.game.viewWidth.floatValue() / 2.0f - menu4.getWidth() / 2.0f, this.game.viewHeight.floatValue() / 2.0f - menu4.getHeight() / 2.0f);
        this.stage.addActor(exitButton);
        Label lexiconLabel = new Label(this.game.input.equalsIgnoreCase("keyboard") ? PropertiesReader.getMessage(this.game.gameMessages, "lexicon.key") : PropertiesReader.getMessage(this.game.gameMessages, "lexicon.touch"), this.game.uiSkin, "default");
        lexiconLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        lexiconLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        lexiconLabel.setPosition(UIHelpers.calcWidthProportion(this.game, 99.0f, 99.0f).floatValue() - lexiconLabel.getPrefWidth(), this.game.viewHeight.floatValue() - lexiconLabel.getPrefHeight());
        lexiconLabel.layout();
        lexiconLabel.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                GameMenuScreen.this.game.lexiconScreen = new LexiconScreen(GameMenuScreen.this.game, GameMenuScreen.this.game.gameMenuScreen);
                GameMenuScreen.this.game.setScreen(GameMenuScreen.this.game.lexiconScreen);
            }
        });
        this.stage.addActor(lexiconLabel);
    }

    @Override
    public void render(float delta) {
        if (this.menuBlocked > 0.0f) {
            if (this.menuBlocked > 2.0f && this.menuBlocked < 50.0f) {
                this.bloodtext.setVisible(true);
            } else if (this.menuBlocked <= 2.0f) {
                this.bloodtext.setVisible(false);
                if (this.selection.equalsIgnoreCase("option1")) {
                    if (this.previousScreen instanceof CombatScreen) {
                        this.game.manager.get(this.game.getOverridenAsset("sound/" + ((JSONObject)((JSONObject)this.game.stats.get("phases").get("arenas")).get(((CombatScreen)this.previousScreen).arena)).getString("crowd") + ".ogg"), Sound.class).resume();
                        ((CombatScreen)this.previousScreen).paused = false;
                    }
                    this.game.setScreen(this.previousScreen);
                } else if (this.selection.equalsIgnoreCase("option2")) {
                    this.game.optionsMenuScreen = new OptionsMenuScreen(this.game, true);
                    this.game.setScreen(this.game.optionsMenuScreen);
                } else if (this.selection.equalsIgnoreCase("option3")) {
                    if (this.previousScreen instanceof CombatScreen && this.game.isMultiplayerGame()) {
                        this.game.networkPort.sendData("0_d_h");
                    }
                    if (this.game.networkPort != null) {
                        this.game.networkPort.terminate();
                        this.game.networkPort = null;
                    }
                    this.previousScreen.dispose();
                    this.game.mainMenuScreen = new MainMenuScreen(this.game);
                    this.game.setScreen(this.game.mainMenuScreen);
                } else if (this.selection.equalsIgnoreCase("option4")) {
                    if (this.previousScreen instanceof CombatScreen && this.game.isMultiplayerGame()) {
                        this.game.networkPort.sendData("0_d_h");
                    }
                    this.previousScreen.dispose();
                    this.game.dispose();
                }
            }
            this.menuBlocked -= 2.0f;
        }
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 244) {
            this.game.lexiconScreen = new LexiconScreen(this.game, this.game.gameMenuScreen);
            this.game.setScreen(this.game.lexiconScreen);
        } else if (keycode == Input.Keys.valueOf(this.game.nextkey) && this.resumeButton != null && this.resumeButton.isVisible()) {
            InputEvent event = new InputEvent();
            event.setType(InputEvent.Type.touchUp);
            this.resumeButton.fire(event);
            return true;
        }
        return false;
    }
}

