/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.StringBuilder;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.NinePatchActor;
import com.calimasaga.slavepits.actor.SelectBoxFontScaling;
import com.calimasaga.slavepits.actor.TextFieldFontScaling;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Equipment;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.screen.AIMenuScreen;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.CombatScreen;
import com.calimasaga.slavepits.screen.EquipmentMenuScreen;
import com.calimasaga.slavepits.screen.LexiconScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.screen.PortraitsMenuScreen;
import com.calimasaga.slavepits.screen.ServicesMenuScreen;
import com.calimasaga.slavepits.screen.TalentsMenuScreen;
import com.calimasaga.slavepits.util.Logger;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.ArrayList;

public class DuelSetupScreen
extends BaseScreen {
    private Button readyP1;
    private Button readyP2;
    public BaseActor portraitImageP1;
    public BaseActor portraitImageP2;
    public BaseActor supporterIconP1;
    public BaseActor supporterIconP2;
    public Label reputationP1;
    public Label reputationP2;
    private int maxReputation = 0;
    public Fighter hostFighter;
    public Fighter clientFighter;
    public String hostServices = "";
    public String clientServices = "";
    public Button hostAI;
    public String hostAIbehavior = "parry:50#attack:stamin:own:more:39;attack:stamin:other:less:20;attack:pressu:any:less:40;attack:debuff:any:any:100#use:life:own:less:50;use:pressu:any:less:40";
    private SelectBoxFontScaling<String> opponent;
    private SelectBoxFontScaling<String> arena;
    private SelectBoxFontScaling<String> music;
    private SelectBoxFontScaling<String> phase;
    private SelectBoxFontScaling<String> difficulty;
    private ScrollPane chatPane;
    private Table chatText;
    private TextFieldFontScaling message;
    private String serverLicense = "free";
    private String clientLicense = "free";
    private int syncTime = -1;
    private long startTime = 0L;
    public Boolean receivedDisconnect = null;

    public DuelSetupScreen(SlavePitsGame g, int initReputation) {
        super(g);
        this.maxReputation = initReputation;
        this.create();
    }

    public DuelSetupScreen(SlavePitsGame g, int initReputation, String selDifficulty, Fighter selHostFighter, Fighter selClientFighter) {
        super(g);
        this.maxReputation = initReputation;
        this.hostFighter = selHostFighter;
        this.hostFighter.isPlayer = true;
        this.clientFighter = selClientFighter;
        this.clientFighter.isPlayer = true;
        if (!this.game.isMultiplayerGame() && !selHostFighter.behavior.equalsIgnoreCase("")) {
            this.hostAIbehavior = selHostFighter.behavior;
            this.clientFighter.isPlayer = false;
        }
        this.create();
        this.difficulty.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.") + selDifficulty);
    }

    @Override
    public void create() {
        if (this.game.track != null && this.game.track.isPlaying()) {
            this.game.track.stop();
            this.game.track.dispose();
        }
        this.game.track = Gdx.audio.newMusic(Gdx.files.internal(this.game.getOverridenFilename("music/sl04.ogg")));
        this.game.track.setLooping(true);
        this.game.track.setVolume(this.game.musicVolume);
        this.game.track.play();
        BaseActor background = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, background, this.game.getOverridenFilename("data/backgrounds/backgroundPrepPits.jpg"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.stage.addActor(background);
        if (this.hostFighter == null) {
            this.hostFighter = new Fighter();
            this.hostFighter.portrait = "p00";
            this.hostFighter.skinColor = this.game.stats.get("parts").getJSONObject("portraits").getJSONObject(this.hostFighter.portrait).getString("skinColor");
            this.hostFighter.bodyColor = this.game.stats.get("parts").getJSONObject("portraits").getJSONObject(this.hostFighter.portrait).getString("bodyColor");
            this.hostFighter.accessoryColor = this.game.stats.get("parts").getJSONObject("portraits").getJSONObject(this.hostFighter.portrait).getString("accessoryColor");
            this.hostFighter.name = "Host";
            this.hostFighter.weapon = new Equipment();
            this.hostFighter.weapon.id = "dagger";
            this.hostFighter.weapon.tier = "wood";
        }
        if (this.clientFighter == null) {
            this.clientFighter = new Fighter();
            this.clientFighter.portrait = "p00";
            this.clientFighter.skinColor = this.game.stats.get("parts").getJSONObject("portraits").getJSONObject(this.clientFighter.portrait).getString("skinColor");
            this.clientFighter.bodyColor = this.game.stats.get("parts").getJSONObject("portraits").getJSONObject(this.clientFighter.portrait).getString("bodyColor");
            this.clientFighter.accessoryColor = this.game.stats.get("parts").getJSONObject("portraits").getJSONObject(this.clientFighter.portrait).getString("accessoryColor");
            this.clientFighter.name = "Client";
            if (!this.game.isMultiplayerGame()) {
                this.clientFighter.behavior = this.hostAIbehavior;
            }
            this.clientFighter.weapon = new Equipment();
            this.clientFighter.weapon.id = "dagger";
            this.clientFighter.weapon.tier = "wood";
        }
        NinePatchActor charPanel = new NinePatchActor(this.game.uiSkin.get("bigboard", NinePatch.class));
        charPanel.setHeight(UIHelpers.calcHeightProportion(this.game, 45.0f, 45.0f).floatValue());
        charPanel.setWidth(UIHelpers.calcHeightProportion(this.game, 70.0f, 70.0f).floatValue());
        charPanel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - charPanel.getWidth() / 2.0f);
        charPanel.setY(UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue());
        this.stage.addActor(charPanel);
        this.readyP1 = new Button(this.game.uiSkin, "check");
        if (!this.game.isMultiplayerGame()) {
            this.readyP1.setChecked(true);
        }
        if (this.game.gameMode.equalsIgnoreCase("client")) {
            this.readyP1.setDisabled(true);
            this.clientLicense = PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum);
        } else {
            this.readyP1.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    DuelSetupScreen.this.sendMessage("change", "");
                }
            });
            this.serverLicense = PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum);
        }
        this.readyP1.setWidth(charPanel.getWidth() / 20.0f);
        this.readyP1.setHeight(charPanel.getWidth() / 20.0f);
        this.readyP1.setX(charPanel.getX() + charPanel.getWidth() * 4.0f / 100.0f);
        this.readyP1.setY(charPanel.getY() + charPanel.getHeight() * 73.3f / 100.0f - this.readyP1.getHeight() / 2.0f);
        this.stage.addActor(this.readyP1);
        TextureAtlas portraitsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
        Stack portraitP1 = new Stack();
        this.portraitImageP1 = new BaseActor();
        this.portraitImageP1.setTexture(portraitsAtlas.findRegion(this.hostFighter.portrait), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.portraitImageP1.setWidth(charPanel.getHeight() * 40.0f / 100.0f);
        this.portraitImageP1.setHeight(charPanel.getHeight() * 40.0f / 100.0f);
        this.portraitImageP1.params.put("name", this.hostFighter.portrait);
        portraitP1.add(this.portraitImageP1);
        BaseActor portraitFrameP1 = new BaseActor();
        portraitFrameP1.setTexture(portraitsAtlas.findRegion("portraitframe"), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        portraitFrameP1.setWidth(charPanel.getHeight() * 40.0f / 100.0f);
        portraitFrameP1.setHeight(charPanel.getHeight() * 40.0f / 100.0f);
        portraitP1.add(portraitFrameP1);
        portraitP1.setWidth(charPanel.getHeight() * 40.0f / 100.0f);
        portraitP1.setHeight(charPanel.getHeight() * 40.0f / 100.0f);
        portraitP1.setX(charPanel.getX() + charPanel.getWidth() * 11.0f / 100.0f);
        portraitP1.setY(charPanel.getY() + charPanel.getHeight() * 53.3f / 100.0f);
        this.stage.addActor(portraitP1);
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        this.supporterIconP1 = new BaseActor();
        this.supporterIconP1.setTexture(uiAtlas.findRegion("supporter"), UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.supporterIconP1.setPosition(portraitP1.getX() + portraitP1.getWidth() - UIHelpers.calcWidthProportion(this.game, 1.5f, 1.5f).floatValue() - this.supporterIconP1.getWidth(), portraitP1.getY() + portraitP1.getHeight() - UIHelpers.calcWidthProportion(this.game, 1.5f, 1.5f).floatValue() - this.supporterIconP1.getHeight());
        this.supporterIconP1.setVisible(false);
        this.stage.addActor(this.supporterIconP1);
        if (!this.game.gameMode.equalsIgnoreCase("client")) {
            if (PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum).equalsIgnoreCase("extra")) {
                this.supporterIconP1.setVisible(true);
            }
            BaseActor portraitFrameP1Outline = new BaseActor();
            portraitFrameP1Outline.setTexture(portraitsAtlas.findRegion("portraitframeoutline"), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
            portraitFrameP1Outline.setWidth(charPanel.getHeight() * 40.0f / 100.0f + portraitFrameP1Outline.getWidth() / 25.0f);
            portraitFrameP1Outline.setHeight(charPanel.getHeight() * 40.0f / 100.0f + portraitFrameP1Outline.getWidth() / 25.0f);
            portraitP1.add(portraitFrameP1Outline);
            portraitP1.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (!(DuelSetupScreen.this.startTime != 0L || DuelSetupScreen.this.game.isMultiplayerGame() && DuelSetupScreen.this.readyP1.isChecked())) {
                        DuelSetupScreen.this.game.portraitsMenuScreen = new PortraitsMenuScreen(DuelSetupScreen.this.game, DuelSetupScreen.this.game.duelSetupScreen, "host");
                        DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.portraitsMenuScreen);
                    }
                }
            });
        }
        this.readyP2 = new Button(this.game.uiSkin, "check");
        if (!this.game.isMultiplayerGame()) {
            this.readyP2.setChecked(true);
        }
        if (this.game.gameMode.equalsIgnoreCase("server")) {
            this.readyP2.setDisabled(true);
        } else {
            this.readyP2.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    DuelSetupScreen.this.sendMessage("change", "");
                }
            });
        }
        this.readyP2.setWidth(charPanel.getWidth() / 20.0f);
        this.readyP2.setHeight(charPanel.getWidth() / 20.0f);
        this.readyP2.setX(charPanel.getX() + charPanel.getWidth() * 4.0f / 100.0f);
        this.readyP2.setY(charPanel.getY() + charPanel.getHeight() * 27.5f / 100.0f - this.readyP2.getHeight() / 2.0f);
        this.stage.addActor(this.readyP2);
        Stack portraitP2 = new Stack();
        this.portraitImageP2 = new BaseActor();
        this.portraitImageP2.setTexture(portraitsAtlas.findRegion(this.clientFighter.portrait), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        this.portraitImageP2.setWidth(charPanel.getHeight() * 40.0f / 100.0f);
        this.portraitImageP2.setHeight(charPanel.getHeight() * 40.0f / 100.0f);
        this.portraitImageP2.params.put("name", this.clientFighter.portrait);
        portraitP2.add(this.portraitImageP2);
        BaseActor portraitFrameP2 = new BaseActor();
        portraitFrameP2.setTexture(portraitsAtlas.findRegion("portraitframe"), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
        portraitFrameP2.setWidth(charPanel.getHeight() * 40.0f / 100.0f);
        portraitFrameP2.setHeight(charPanel.getHeight() * 40.0f / 100.0f);
        portraitP2.add(portraitFrameP2);
        portraitP2.setWidth(charPanel.getHeight() * 40.0f / 100.0f);
        portraitP2.setHeight(charPanel.getHeight() * 40.0f / 100.0f);
        portraitP2.setX(charPanel.getX() + charPanel.getWidth() * 11.0f / 100.0f);
        portraitP2.setY(charPanel.getY() + charPanel.getHeight() * 6.65f / 100.0f);
        this.stage.addActor(portraitP2);
        this.supporterIconP2 = new BaseActor();
        this.supporterIconP2.setTexture(uiAtlas.findRegion("supporter"), UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.supporterIconP2.setPosition(portraitP2.getX() + portraitP2.getWidth() - UIHelpers.calcWidthProportion(this.game, 1.5f, 1.5f).floatValue() - this.supporterIconP2.getWidth(), portraitP2.getY() + portraitP2.getHeight() - UIHelpers.calcWidthProportion(this.game, 1.5f, 1.5f).floatValue() - this.supporterIconP2.getHeight());
        this.supporterIconP2.setVisible(false);
        this.stage.addActor(this.supporterIconP2);
        if (!this.game.gameMode.equalsIgnoreCase("server")) {
            if (this.game.isMultiplayerGame() && PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum).equalsIgnoreCase("extra")) {
                this.supporterIconP2.setVisible(true);
            }
            if (this.game.gameMode.equalsIgnoreCase("client")) {
                BaseActor portraitFrameP2Outline = new BaseActor();
                portraitFrameP2Outline.setTexture(portraitsAtlas.findRegion("portraitframeoutline"), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 10.0f, 10.0f).floatValue());
                portraitFrameP2Outline.setWidth(charPanel.getHeight() * 40.0f / 100.0f + portraitFrameP2Outline.getWidth() / 25.0f);
                portraitFrameP2Outline.setHeight(charPanel.getHeight() * 40.0f / 100.0f + portraitFrameP2Outline.getWidth() / 25.0f);
                portraitP2.add(portraitFrameP2Outline);
            }
            portraitP2.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (!(DuelSetupScreen.this.startTime != 0L || DuelSetupScreen.this.game.isMultiplayerGame() && DuelSetupScreen.this.readyP2.isChecked())) {
                        DuelSetupScreen.this.game.portraitsMenuScreen = new PortraitsMenuScreen(DuelSetupScreen.this.game, DuelSetupScreen.this.game.duelSetupScreen, "client");
                        DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.portraitsMenuScreen);
                    }
                }
            });
        }
        this.reputationP1 = new Label(this.hostFighter.reputation + " / " + (this.maxReputation == 0 ? "-" : Integer.valueOf(this.maxReputation)), this.game.uiSkin, "default");
        this.reputationP1.setAlignment(1);
        this.reputationP1.setColor(Color.RED);
        this.reputationP1.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.reputationP1.setWidth(charPanel.getWidth() / 4.0f);
        this.reputationP1.setX(charPanel.getX() + charPanel.getWidth() * (float)(this.game.gameMode.equalsIgnoreCase("client") ? 54 : 44) / 100.0f);
        this.reputationP1.setY(charPanel.getY() + charPanel.getHeight() * 83.3f / 100.0f - this.reputationP1.getHeight() / 2.0f);
        this.stage.addActor(this.reputationP1);
        Button equipmentP1 = new Button(this.game.uiSkin, "equipmentmenu");
        if (this.game.gameMode.equalsIgnoreCase("client")) {
            equipmentP1.setDisabled(true);
            equipmentP1.setVisible(false);
        } else {
            equipmentP1.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (!(DuelSetupScreen.this.startTime != 0L || DuelSetupScreen.this.game.isMultiplayerGame() && DuelSetupScreen.this.readyP1.isChecked())) {
                        DuelSetupScreen.this.game.equipmentMenuScreen = new EquipmentMenuScreen(DuelSetupScreen.this.game, DuelSetupScreen.this.game.duelSetupScreen, DuelSetupScreen.this.hostFighter, "host", DuelSetupScreen.this.maxReputation);
                        DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.equipmentMenuScreen);
                    }
                }
            });
        }
        equipmentP1.setWidth(charPanel.getWidth() / 8.0f);
        equipmentP1.setHeight(charPanel.getWidth() / 8.0f);
        equipmentP1.setX(charPanel.getX() + charPanel.getWidth() * 46.0f / 100.0f);
        equipmentP1.setY(charPanel.getY() + charPanel.getHeight() * 55.3f / 100.0f);
        this.stage.addActor(equipmentP1);
        Button talentP1 = new Button(this.game.uiSkin, "talentmenu");
        if (this.game.gameMode.equalsIgnoreCase("client")) {
            talentP1.setDisabled(true);
            talentP1.setVisible(false);
        } else {
            talentP1.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (!(DuelSetupScreen.this.startTime != 0L || DuelSetupScreen.this.game.isMultiplayerGame() && DuelSetupScreen.this.readyP1.isChecked())) {
                        DuelSetupScreen.this.game.talentsMenuScreen = new TalentsMenuScreen(DuelSetupScreen.this.game, DuelSetupScreen.this.game.duelSetupScreen, DuelSetupScreen.this.hostFighter, "host", DuelSetupScreen.this.maxReputation, 0, false);
                        DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.talentsMenuScreen);
                    }
                }
            });
        }
        talentP1.setWidth(charPanel.getWidth() / 8.0f);
        talentP1.setHeight(charPanel.getWidth() / 8.0f);
        talentP1.setX(charPanel.getX() + charPanel.getWidth() * 60.0f / 100.0f);
        talentP1.setY(equipmentP1.getY());
        this.stage.addActor(talentP1);
        Button servicesP1 = new Button(this.game.uiSkin, "servicesmenu");
        if (this.game.gameMode.equalsIgnoreCase("client")) {
            servicesP1.setDisabled(true);
            servicesP1.setVisible(false);
        } else {
            servicesP1.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (!(DuelSetupScreen.this.startTime != 0L || DuelSetupScreen.this.game.isMultiplayerGame() && DuelSetupScreen.this.readyP1.isChecked())) {
                        DuelSetupScreen.this.game.servicesMenuScreen = new ServicesMenuScreen(DuelSetupScreen.this.game, DuelSetupScreen.this.game.duelSetupScreen, DuelSetupScreen.this.hostFighter, "host", DuelSetupScreen.this.maxReputation, "", 0, "");
                        DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.servicesMenuScreen);
                    }
                }
            });
        }
        servicesP1.setWidth(charPanel.getWidth() / 8.0f);
        servicesP1.setHeight(charPanel.getWidth() / 8.0f);
        servicesP1.setX(charPanel.getX() + charPanel.getWidth() * 74.0f / 100.0f);
        servicesP1.setY(equipmentP1.getY());
        this.stage.addActor(servicesP1);
        this.reputationP2 = new Label(this.clientFighter.reputation + " / " + (this.maxReputation == 0 ? "-" : Integer.valueOf(this.maxReputation)), this.game.uiSkin, "default");
        this.reputationP2.setAlignment(1);
        this.reputationP2.setColor(Color.RED);
        this.reputationP2.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.reputationP2.setWidth(charPanel.getWidth() / 4.0f);
        this.reputationP2.setX(charPanel.getX() + charPanel.getWidth() * 44.0f / 100.0f);
        this.reputationP2.setY(charPanel.getY() + charPanel.getHeight() * 36.65f / 100.0f - this.reputationP2.getPrefHeight() / 2.0f);
        this.stage.addActor(this.reputationP2);
        if (!this.game.isMultiplayerGame()) {
            this.reputationP2.setX(charPanel.getX() + charPanel.getWidth() * 44.0f / 100.0f);
            ArrayList<String> availableOpponents = new ArrayList<String>();
            availableOpponents.add("custom");
            if (this.game.achievements.get("adam") != null) {
                availableOpponents.add("adam");
            }
            if (this.game.achievements.get("ayla") != null) {
                availableOpponents.add("ayla");
            }
            if (this.game.achievements.get("boris") != null) {
                availableOpponents.add("boris");
            }
            if (this.game.achievements.get("diego") != null) {
                availableOpponents.add("diego");
            }
            if (this.game.achievements.get("emma") != null) {
                availableOpponents.add("emma");
            }
            if (this.game.achievements.get("min") != null) {
                availableOpponents.add("min");
            }
            if (this.game.achievements.get("onur") != null) {
                availableOpponents.add("onur");
            }
            if (this.game.achievements.get("scala") != null) {
                availableOpponents.add("scala");
            }
            if (this.game.achievements.get("trent") != null) {
                availableOpponents.add("trent");
            }
            if (this.game.achievements.get("zola") != null) {
                availableOpponents.add("zola");
            }
            if (this.game.achievements.get("tara") != null) {
                availableOpponents.add("tara");
            }
            if (this.game.achievements.get("lea") != null) {
                availableOpponents.add("lea");
            }
            if (this.game.achievements.get("fenris") != null) {
                availableOpponents.add("fenris");
            }
            if (this.game.achievements.get("ponte") != null) {
                availableOpponents.add("ponte");
            }
            if (this.game.achievements.get("roe") != null) {
                availableOpponents.add("roe");
            }
            if (this.game.achievements.get("luntian") != null) {
                availableOpponents.add("luntian");
            }
            if (this.game.achievements.get("blaire") != null) {
                availableOpponents.add("blaire");
            }
            if (this.game.achievements.get("nattfrid") != null) {
                availableOpponents.add("nattfrid");
            }
            if (this.game.achievements.get("sarah") != null) {
                availableOpponents.add("sarah");
            }
            if (this.game.achievements.get("rishi") != null) {
                availableOpponents.add("rishi");
            }
            if (this.game.achievements.get("bastien") != null) {
                availableOpponents.add("bastien");
            }
            if (this.game.achievements.get("san") != null) {
                availableOpponents.add("san");
            }
            this.opponent = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
            this.opponent.setItems((String[])availableOpponents.toArray(new String[0]));
            this.opponent.setSelected("custom");
            this.opponent.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    DuelSetupScreen.this.clientFighter = Fighter.createOpponent(DuelSetupScreen.this.game, (String)DuelSetupScreen.this.opponent.getSelected(), DuelSetupScreen.this.maxReputation, false);
                    TextureAtlas portraitsAtlas = DuelSetupScreen.this.game.manager.get(DuelSetupScreen.this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
                    DuelSetupScreen.this.portraitImageP2.setTexture(portraitsAtlas.findRegion(DuelSetupScreen.this.clientFighter.portrait), (float)Float.valueOf(DuelSetupScreen.this.portraitImageP2.getWidth()).intValue(), (float)Float.valueOf(DuelSetupScreen.this.portraitImageP2.getHeight()).intValue());
                    DuelSetupScreen.this.reputationP2.setText(DuelSetupScreen.this.clientFighter.reputation + " / " + (DuelSetupScreen.this.maxReputation == 0 ? "-" : Integer.valueOf(DuelSetupScreen.this.maxReputation)));
                }
            });
            this.opponent.setWidth(this.opponent.getPrefWidth());
            this.opponent.setX(charPanel.getX() + charPanel.getWidth() * 66.0f / 100.0f);
            this.opponent.setY(this.reputationP2.getY() + this.reputationP2.getPrefHeight() / 2.0f - this.opponent.getHeight() / 2.0f);
            this.stage.addActor(this.opponent);
        }
        Button equipmentP2 = new Button(this.game.uiSkin, "equipmentmenu");
        if (this.game.gameMode.equalsIgnoreCase("server")) {
            equipmentP2.setDisabled(true);
            equipmentP2.setVisible(false);
        } else {
            equipmentP2.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (!(DuelSetupScreen.this.startTime != 0L || DuelSetupScreen.this.game.isMultiplayerGame() && DuelSetupScreen.this.readyP2.isChecked())) {
                        DuelSetupScreen.this.game.equipmentMenuScreen = new EquipmentMenuScreen(DuelSetupScreen.this.game, DuelSetupScreen.this.game.duelSetupScreen, DuelSetupScreen.this.clientFighter, "client", DuelSetupScreen.this.maxReputation);
                        DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.equipmentMenuScreen);
                    }
                }
            });
        }
        equipmentP2.setWidth(charPanel.getWidth() / 8.0f);
        equipmentP2.setHeight(charPanel.getWidth() / 8.0f);
        equipmentP2.setX(charPanel.getX() + charPanel.getWidth() * 46.0f / 100.0f);
        equipmentP2.setY(charPanel.getY() + charPanel.getHeight() * 8.65f / 100.0f);
        this.stage.addActor(equipmentP2);
        Button talentP2 = new Button(this.game.uiSkin, "talentmenu");
        if (this.game.gameMode.equalsIgnoreCase("server")) {
            talentP2.setDisabled(true);
            talentP2.setVisible(false);
        } else {
            talentP2.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (!(DuelSetupScreen.this.startTime != 0L || DuelSetupScreen.this.game.isMultiplayerGame() && DuelSetupScreen.this.readyP2.isChecked())) {
                        DuelSetupScreen.this.game.talentsMenuScreen = new TalentsMenuScreen(DuelSetupScreen.this.game, DuelSetupScreen.this.game.duelSetupScreen, DuelSetupScreen.this.clientFighter, "client", DuelSetupScreen.this.maxReputation, 0, false);
                        DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.talentsMenuScreen);
                    }
                }
            });
        }
        talentP2.setWidth(charPanel.getWidth() / 8.0f);
        talentP2.setHeight(charPanel.getWidth() / 8.0f);
        talentP2.setX(charPanel.getX() + charPanel.getWidth() * 60.0f / 100.0f);
        talentP2.setY(equipmentP2.getY());
        this.stage.addActor(talentP2);
        Button servicesP2 = new Button(this.game.uiSkin, "servicesmenu");
        if (this.game.gameMode.equalsIgnoreCase("server")) {
            servicesP2.setDisabled(true);
            servicesP2.setVisible(false);
        } else {
            servicesP2.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (!(DuelSetupScreen.this.startTime != 0L || DuelSetupScreen.this.game.isMultiplayerGame() && DuelSetupScreen.this.readyP2.isChecked())) {
                        DuelSetupScreen.this.game.servicesMenuScreen = new ServicesMenuScreen(DuelSetupScreen.this.game, DuelSetupScreen.this.game.duelSetupScreen, DuelSetupScreen.this.clientFighter, "client", DuelSetupScreen.this.maxReputation, "", 0, "");
                        DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.servicesMenuScreen);
                    }
                }
            });
        }
        servicesP2.setWidth(charPanel.getWidth() / 8.0f);
        servicesP2.setHeight(charPanel.getWidth() / 8.0f);
        servicesP2.setX(charPanel.getX() + charPanel.getWidth() * 74.0f / 100.0f);
        servicesP2.setY(equipmentP2.getY());
        this.stage.addActor(servicesP2);
        Label labelAI = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.ai") + ":", this.game.uiSkin, "default");
        labelAI.setColor(this.game.uiSkin.get("silver", Color.class));
        labelAI.setAlignment(1);
        labelAI.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        labelAI.setWidth(charPanel.getWidth() / 8.0f);
        labelAI.setX(charPanel.getX() + charPanel.getWidth() * 62.0f / 100.0f);
        labelAI.setY((this.game.gameMode.equalsIgnoreCase("client") ? this.reputationP2.getY() + this.reputationP2.getHeight() / 2.0f : this.reputationP1.getY() + this.reputationP1.getHeight() / 2.0f) - labelAI.getHeight() / 2.0f);
        this.stage.addActor(labelAI);
        this.hostAI = new Button(this.game.uiSkin, "check");
        this.hostAI.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (DuelSetupScreen.this.hostAI.isChecked()) {
                    if (DuelSetupScreen.this.game.gameMode.equalsIgnoreCase("client")) {
                        DuelSetupScreen.this.clientFighter.behavior = DuelSetupScreen.this.hostAIbehavior;
                    } else {
                        DuelSetupScreen.this.hostFighter.behavior = DuelSetupScreen.this.hostAIbehavior;
                    }
                } else if (DuelSetupScreen.this.game.gameMode.equalsIgnoreCase("client")) {
                    DuelSetupScreen.this.clientFighter.behavior = "";
                } else {
                    DuelSetupScreen.this.hostFighter.behavior = "";
                }
            }
        });
        if (!this.hostFighter.behavior.equalsIgnoreCase("")) {
            this.hostAI.setChecked(true);
        }
        this.hostAI.setWidth(charPanel.getWidth() / 16.0f);
        this.hostAI.setHeight(charPanel.getWidth() / 16.0f);
        this.hostAI.setX(charPanel.getX() + charPanel.getWidth() * 71.0f / 100.0f);
        this.hostAI.setY(labelAI.getY() + labelAI.getPrefHeight() / 2.0f - this.hostAI.getHeight() / 2.0f);
        this.stage.addActor(this.hostAI);
        Button customAI = new Button(this.game.uiSkin, "aimenu");
        customAI.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                DuelSetupScreen.this.game.AIMenuScreen = new AIMenuScreen(DuelSetupScreen.this.game, DuelSetupScreen.this.game.duelSetupScreen, DuelSetupScreen.this.hostAIbehavior);
                DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.AIMenuScreen);
            }
        });
        customAI.setWidth(charPanel.getWidth() / 16.0f);
        customAI.setHeight(charPanel.getWidth() / 16.0f);
        customAI.setX(charPanel.getX() + charPanel.getWidth() * 80.0f / 100.0f);
        customAI.setY(this.hostAI.getY());
        this.stage.addActor(customAI);
        String[] availableArenas = new String[]{PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.tutorial"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.pits1"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.pits2"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.pitsnight"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.boss1"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.caravan1"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.caravan2"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.caravan3"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.boss2"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.coliseum1"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.coliseum2"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.coliseumnight"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.boss3")};
        this.arena = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.arena.setItems((String[])availableArenas);
        this.arena.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena.tutorial"));
        if (this.game.gameMode.equalsIgnoreCase("client")) {
            this.arena.setDisabled(true);
        } else {
            this.arena.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (!PropertiesReader.verifyKey(DuelSetupScreen.this.game.mail, DuelSetupScreen.this.game.key, DuelSetupScreen.this.game.checksum).equalsIgnoreCase("extra") && (((String)DuelSetupScreen.this.arena.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.arena.boss1")) || ((String)DuelSetupScreen.this.arena.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.arena.boss2")) || ((String)DuelSetupScreen.this.arena.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.arena.boss3")))) {
                        Label textLabel = new Label(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.extra"), DuelSetupScreen.this.game.uiSkin, "chat");
                        textLabel.setFontScale(DuelSetupScreen.this.game.viewHeight.floatValue() / DuelSetupScreen.this.game.viewHeightMAX.floatValue());
                        textLabel.setColor(Color.RED);
                        textLabel.setWrap(true);
                        textLabel.setWidth(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f));
                        float labelRealHeight = textLabel.getPrefHeight();
                        DuelSetupScreen.this.chatText.add(textLabel).pad(0.0f).left().bottom().size(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f), labelRealHeight);
                        DuelSetupScreen.this.chatText.row();
                        DuelSetupScreen.this.chatPane.layout();
                        DuelSetupScreen.this.chatPane.setScrollY(DuelSetupScreen.this.chatText.getHeight());
                        DuelSetupScreen.this.arena.setSelected(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.arena.tutorial"));
                    } else if (!(!PropertiesReader.verifyKey(DuelSetupScreen.this.game.mail, DuelSetupScreen.this.game.key, DuelSetupScreen.this.game.checksum).equalsIgnoreCase("free") || ((String)DuelSetupScreen.this.arena.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.arena.tutorial")) || ((String)DuelSetupScreen.this.arena.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.arena.pits1")) || ((String)DuelSetupScreen.this.arena.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.arena.pits2")) || ((String)DuelSetupScreen.this.arena.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.arena.pitsnight")))) {
                        Label textLabel = new Label(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.free"), DuelSetupScreen.this.game.uiSkin, "chat");
                        textLabel.setFontScale(DuelSetupScreen.this.game.viewHeight.floatValue() / DuelSetupScreen.this.game.viewHeightMAX.floatValue());
                        textLabel.setColor(Color.RED);
                        textLabel.setWrap(true);
                        textLabel.setWidth(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f));
                        float labelRealHeight = textLabel.getPrefHeight();
                        DuelSetupScreen.this.chatText.add(textLabel).pad(0.0f).left().bottom().size(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f), labelRealHeight);
                        DuelSetupScreen.this.chatText.row();
                        DuelSetupScreen.this.chatPane.layout();
                        DuelSetupScreen.this.chatPane.setScrollY(DuelSetupScreen.this.chatText.getHeight());
                        DuelSetupScreen.this.arena.setSelected(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.arena.tutorial"));
                    }
                    DuelSetupScreen.this.sendMessage("change", "");
                }
            });
        }
        this.arena.setWidth(this.arena.getPrefWidth());
        this.arena.setX(charPanel.getX() + charPanel.getWidth() * 12.0f / 100.0f + UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.arena.setY(charPanel.getY() - UIHelpers.calcHeightProportion(this.game, 1.97f, 1.97f).floatValue() - this.arena.getHeight());
        this.stage.addActor(this.arena);
        Label arenaLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena") + ":", this.game.uiSkin, "default");
        arenaLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        arenaLabel.setAlignment(16);
        arenaLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        arenaLabel.setWidth(charPanel.getWidth() * 14.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        arenaLabel.setX(charPanel.getX());
        arenaLabel.setY(this.arena.getY() + this.arena.getHeight() / 2.0f - arenaLabel.getPrefHeight() / 2.0f);
        this.stage.addActor(arenaLabel);
        String[] availableTracks = new String[]{"5", "6", "7", "8", "9", "10", "11", "12", "13", "14"};
        this.music = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.music.setItems((String[])availableTracks);
        this.music.setSelected("9");
        if (this.game.gameMode.equalsIgnoreCase("client")) {
            this.music.setDisabled(true);
        } else {
            this.music.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (!PropertiesReader.verifyKey(DuelSetupScreen.this.game.mail, DuelSetupScreen.this.game.key, DuelSetupScreen.this.game.checksum).equalsIgnoreCase("extra") && (((String)DuelSetupScreen.this.music.getSelected()).equalsIgnoreCase("12") || ((String)DuelSetupScreen.this.music.getSelected()).equalsIgnoreCase("13") || ((String)DuelSetupScreen.this.music.getSelected()).equalsIgnoreCase("14"))) {
                        Label textLabel = new Label(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.extra"), DuelSetupScreen.this.game.uiSkin, "chat");
                        textLabel.setFontScale(DuelSetupScreen.this.game.viewHeight.floatValue() / DuelSetupScreen.this.game.viewHeightMAX.floatValue());
                        textLabel.setColor(Color.RED);
                        textLabel.setWrap(true);
                        textLabel.setWidth(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f));
                        float labelRealHeight = textLabel.getPrefHeight();
                        DuelSetupScreen.this.chatText.add(textLabel).pad(0.0f).left().bottom().size(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f), labelRealHeight);
                        DuelSetupScreen.this.chatText.row();
                        DuelSetupScreen.this.chatPane.layout();
                        DuelSetupScreen.this.chatPane.setScrollY(DuelSetupScreen.this.chatText.getHeight());
                        DuelSetupScreen.this.music.setSelected("9");
                    } else if (!(!PropertiesReader.verifyKey(DuelSetupScreen.this.game.mail, DuelSetupScreen.this.game.key, DuelSetupScreen.this.game.checksum).equalsIgnoreCase("free") || ((String)DuelSetupScreen.this.music.getSelected()).equalsIgnoreCase("5") || ((String)DuelSetupScreen.this.music.getSelected()).equalsIgnoreCase("6") || ((String)DuelSetupScreen.this.music.getSelected()).equalsIgnoreCase("7") || ((String)DuelSetupScreen.this.music.getSelected()).equalsIgnoreCase("8") || ((String)DuelSetupScreen.this.music.getSelected()).equalsIgnoreCase("9"))) {
                        Label textLabel = new Label(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.free"), DuelSetupScreen.this.game.uiSkin, "chat");
                        textLabel.setFontScale(DuelSetupScreen.this.game.viewHeight.floatValue() / DuelSetupScreen.this.game.viewHeightMAX.floatValue());
                        textLabel.setColor(Color.RED);
                        textLabel.setWrap(true);
                        textLabel.setWidth(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f));
                        float labelRealHeight = textLabel.getPrefHeight();
                        DuelSetupScreen.this.chatText.add(textLabel).pad(0.0f).left().bottom().size(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f), labelRealHeight);
                        DuelSetupScreen.this.chatText.row();
                        DuelSetupScreen.this.chatPane.layout();
                        DuelSetupScreen.this.chatPane.setScrollY(DuelSetupScreen.this.chatText.getHeight());
                        DuelSetupScreen.this.music.setSelected("9");
                    }
                    DuelSetupScreen.this.sendMessage("change", "");
                }
            });
        }
        this.music.setWidth(this.music.getPrefWidth());
        this.music.setX(charPanel.getX() + charPanel.getWidth() * 76.0f / 100.0f + UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.music.setY(this.arena.getY());
        this.stage.addActor(this.music);
        Label musicLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.music") + ":", this.game.uiSkin, "default");
        musicLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        musicLabel.setAlignment(16);
        musicLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        musicLabel.setWidth(charPanel.getWidth() * 14.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        musicLabel.setX(charPanel.getX() + charPanel.getWidth() * 64.0f / 100.0f);
        musicLabel.setY(this.music.getY() + this.music.getHeight() / 2.0f - musicLabel.getPrefHeight() / 2.0f);
        this.stage.addActor(musicLabel);
        String[] availablePhases = new String[]{PropertiesReader.getMessage(this.game.gameMessages, "game.settings.phase.pits"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.phase.caravan"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.phase.coliseum")};
        this.phase = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.phase.setItems((String[])availablePhases);
        if (this.maxReputation <= Integer.parseInt(((JSONObject)((JSONObject)this.game.stats.get("phases").get("limits")).get("pits")).getString("maxReputation"))) {
            this.phase.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.phase.pits"));
        } else if (this.maxReputation <= Integer.parseInt(((JSONObject)((JSONObject)this.game.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation"))) {
            this.phase.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.phase.caravan"));
        } else {
            this.phase.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.phase.coliseum"));
        }
        this.phase.setWidth(this.phase.getPrefWidth());
        this.phase.setX(charPanel.getX() + charPanel.getWidth() * 12.0f / 100.0f + UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.phase.setY(arenaLabel.getY() - this.phase.getHeight() - UIHelpers.calcHeightProportion(this.game, 1.97f, 1.97f).floatValue());
        this.stage.addActor(this.phase);
        Label phaseLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "common.phase") + ":", this.game.uiSkin, "default");
        phaseLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        phaseLabel.setAlignment(16);
        phaseLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        phaseLabel.setWidth(charPanel.getWidth() * 14.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        phaseLabel.setX(charPanel.getX());
        phaseLabel.setY(this.phase.getY() + this.phase.getHeight() / 2.0f - phaseLabel.getPrefHeight() / 2.0f);
        this.stage.addActor(phaseLabel);
        if (this.game.isMultiplayerGame()) {
            phaseLabel.setVisible(false);
            this.phase.setVisible(false);
        } else {
            this.phase.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (PropertiesReader.verifyKey(DuelSetupScreen.this.game.mail, DuelSetupScreen.this.game.key, DuelSetupScreen.this.game.checksum).equalsIgnoreCase("free") && !((String)DuelSetupScreen.this.phase.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.phase.pits"))) {
                        Label textLabel = new Label(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.free"), DuelSetupScreen.this.game.uiSkin, "chat");
                        textLabel.setFontScale(DuelSetupScreen.this.game.viewHeight.floatValue() / DuelSetupScreen.this.game.viewHeightMAX.floatValue());
                        textLabel.setColor(Color.RED);
                        textLabel.setWrap(true);
                        textLabel.setWidth(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f));
                        float labelRealHeight = textLabel.getPrefHeight();
                        DuelSetupScreen.this.chatText.add(textLabel).pad(0.0f).left().bottom().size(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f), labelRealHeight);
                        DuelSetupScreen.this.chatText.row();
                        DuelSetupScreen.this.chatPane.layout();
                        DuelSetupScreen.this.chatPane.setScrollY(DuelSetupScreen.this.chatText.getHeight());
                        DuelSetupScreen.this.phase.setSelected(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.phase.pits"));
                    }
                    if (((String)DuelSetupScreen.this.phase.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.phase.pits"))) {
                        DuelSetupScreen.this.maxReputation = Integer.parseInt(((JSONObject)((JSONObject)DuelSetupScreen.this.game.stats.get("phases").get("limits")).get("pits")).getString("maxReputation"));
                        if (DuelSetupScreen.this.hostFighter.reputation > DuelSetupScreen.this.maxReputation) {
                            DuelSetupScreen.this.hostFighter = DuelSetupScreen.this.resetFighter();
                            if (!DuelSetupScreen.this.hostAIbehavior.equalsIgnoreCase("")) {
                                DuelSetupScreen.this.hostFighter.behavior = DuelSetupScreen.this.hostAIbehavior;
                            }
                        }
                        if (DuelSetupScreen.this.clientFighter.reputation > DuelSetupScreen.this.maxReputation) {
                            DuelSetupScreen.this.clientFighter = Fighter.createOpponent(DuelSetupScreen.this.game, (String)DuelSetupScreen.this.opponent.getSelected(), DuelSetupScreen.this.maxReputation, false);
                        }
                    } else if (((String)DuelSetupScreen.this.phase.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.phase.caravan"))) {
                        DuelSetupScreen.this.maxReputation = Integer.parseInt(((JSONObject)((JSONObject)DuelSetupScreen.this.game.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation"));
                        if (DuelSetupScreen.this.hostFighter.reputation > DuelSetupScreen.this.maxReputation) {
                            DuelSetupScreen.this.hostFighter = DuelSetupScreen.this.resetFighter();
                            if (!DuelSetupScreen.this.hostAIbehavior.equalsIgnoreCase("")) {
                                DuelSetupScreen.this.hostFighter.behavior = DuelSetupScreen.this.hostAIbehavior;
                            }
                        }
                        if (DuelSetupScreen.this.clientFighter.reputation > DuelSetupScreen.this.maxReputation) {
                            DuelSetupScreen.this.clientFighter = Fighter.createOpponent(DuelSetupScreen.this.game, (String)DuelSetupScreen.this.opponent.getSelected(), DuelSetupScreen.this.maxReputation, false);
                        }
                    } else if (((String)DuelSetupScreen.this.phase.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.phase.coliseum"))) {
                        DuelSetupScreen.this.maxReputation = 0;
                    }
                    DuelSetupScreen.this.reputationP1.setText(DuelSetupScreen.this.hostFighter.reputation + " / " + (DuelSetupScreen.this.maxReputation == 0 ? "-" : Integer.valueOf(DuelSetupScreen.this.maxReputation)));
                    DuelSetupScreen.this.reputationP2.setText(DuelSetupScreen.this.clientFighter.reputation + " / " + (DuelSetupScreen.this.maxReputation == 0 ? "-" : Integer.valueOf(DuelSetupScreen.this.maxReputation)));
                }
            });
        }
        String[] availableDifficulties = new String[]{PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.normal"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.hard"), PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.hardcore")};
        this.difficulty = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.difficulty.setItems((String[])availableDifficulties);
        this.difficulty.setSelected(availableDifficulties[0]);
        this.difficulty.setWidth(this.difficulty.getPrefWidth());
        this.difficulty.setX(charPanel.getX() + charPanel.getWidth() * 76.0f / 100.0f + UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.difficulty.setY(this.phase.getY());
        this.stage.addActor(this.difficulty);
        Label difficultyLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty") + ":", this.game.uiSkin, "default");
        difficultyLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        difficultyLabel.setAlignment(16);
        difficultyLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        difficultyLabel.setWidth(charPanel.getWidth() * 14.0f / 100.0f - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        difficultyLabel.setX(charPanel.getX() + charPanel.getWidth() * 64.0f / 100.0f);
        difficultyLabel.setY(this.difficulty.getY() + this.difficulty.getHeight() / 2.0f - difficultyLabel.getPrefHeight() / 2.0f);
        this.stage.addActor(difficultyLabel);
        if (this.game.isMultiplayerGame()) {
            difficultyLabel.setVisible(false);
            this.difficulty.setVisible(false);
        }
        this.chatText = new Table();
        this.chatText.setWidth(charPanel.getWidth() * 90.0f / 100.0f);
        this.chatText.setHeight(UIHelpers.calcHeightProportion(this.game, 9.0f, 9.0f).floatValue());
        if (this.game.isMultiplayerGame()) {
            this.chatText.setHeight(UIHelpers.calcHeightProportion(this.game, 19.0f, 19.0f).floatValue());
        }
        Label textLabel = new Label("", this.game.uiSkin, "chat");
        textLabel.setColor(this.game.uiSkin.get("iron", Color.class));
        textLabel.setWrap(true);
        textLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        textLabel.setWidth(this.chatText.getWidth());
        this.chatText.add(textLabel).left().bottom().pad(0.0f).size(this.chatText.getWidth(), charPanel.getHeight() * 80.0f / 100.0f);
        this.chatText.row();
        this.chatPane = new ScrollPane((Actor)this.chatText, this.game.uiSkin, "chat");
        this.chatPane.setForceScroll(false, true);
        this.chatPane.setFlickScroll(false);
        this.chatPane.setOverscroll(false, true);
        this.chatPane.setWidth(charPanel.getWidth());
        this.chatPane.setHeight(UIHelpers.calcHeightProportion(this.game, 16.0f, 16.0f).floatValue());
        if (this.game.isMultiplayerGame()) {
            this.chatPane.setHeight(UIHelpers.calcHeightProportion(this.game, 26.0f, 26.0f).floatValue());
        }
        this.chatPane.setX(charPanel.getX());
        this.chatPane.setY(UIHelpers.calcHeightProportion(this.game, 19.0f, 19.0f).floatValue());
        this.chatPane.getStyle().vScroll.setMinWidth(UIHelpers.calcHeightProportion(this.game, 2.55f, 2.55f).floatValue());
        this.chatPane.getStyle().vScrollKnob.setMinWidth(UIHelpers.calcHeightProportion(this.game, 2.55f, 2.55f).floatValue());
        this.stage.addActor(this.chatPane);
        this.message = UIHelpers.createTextField(this.game, charPanel.getWidth(), charPanel.getHeight() / 10.0f, "default", 1.0f);
        this.message.setMaxLength(500);
        this.message.setTextFieldListener(new TextFieldFontScaling.TextFieldListener(){

            @Override
            public void keyTyped(TextFieldFontScaling textField, char key) {
                if (key == '\n' || key == '\r') {
                    String playerName = DuelSetupScreen.this.game.gameMode.equalsIgnoreCase("server") || !DuelSetupScreen.this.game.isMultiplayerGame() ? DuelSetupScreen.this.game.multiplayerPlayerNameServer : DuelSetupScreen.this.game.multiplayerPlayerNameClient;
                    Label textLabel = new Label(playerName + ": " + DuelSetupScreen.this.message.getText(), DuelSetupScreen.this.game.uiSkin, "chat");
                    textLabel.setColor(DuelSetupScreen.this.game.uiSkin.get("iron", Color.class));
                    if (DuelSetupScreen.this.game.gameMode.equalsIgnoreCase("client") && DuelSetupScreen.this.clientLicense.equalsIgnoreCase("extra") || !DuelSetupScreen.this.game.gameMode.equalsIgnoreCase("client") && DuelSetupScreen.this.serverLicense.equalsIgnoreCase("extra")) {
                        textLabel.setColor(DuelSetupScreen.this.game.uiSkin.get("gold", Color.class));
                    }
                    textLabel.setFontScale(DuelSetupScreen.this.game.viewHeight.floatValue() / DuelSetupScreen.this.game.heightBASE.floatValue());
                    textLabel.setWrap(true);
                    textLabel.setWidth(DuelSetupScreen.this.chatText.getWidth());
                    float labelRealHeight = textLabel.getPrefHeight();
                    DuelSetupScreen.this.chatText.add(textLabel).pad(0.0f).left().bottom().size(DuelSetupScreen.this.chatText.getWidth(), labelRealHeight);
                    DuelSetupScreen.this.chatText.row();
                    DuelSetupScreen.this.sendMessage("chat", DuelSetupScreen.this.message.getText());
                    DuelSetupScreen.this.message.setText("");
                    DuelSetupScreen.this.chatPane.layout();
                    DuelSetupScreen.this.chatPane.setScrollY(DuelSetupScreen.this.chatText.getHeight());
                }
            }
        });
        this.message.setX(charPanel.getX());
        this.message.setY(UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue());
        this.stage.addActor(this.message);
        Label lexiconLabel = new Label(this.game.input.equalsIgnoreCase("keyboard") ? PropertiesReader.getMessage(this.game.gameMessages, "lexicon.key") : PropertiesReader.getMessage(this.game.gameMessages, "lexicon.touch"), this.game.uiSkin, "default");
        lexiconLabel.setColor(this.game.uiSkin.get("silver", Color.class));
        lexiconLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        lexiconLabel.setPosition(UIHelpers.calcWidthProportion(this.game, 99.0f, 99.0f).floatValue() - lexiconLabel.getPrefWidth(), this.game.viewHeight.floatValue() - lexiconLabel.getPrefHeight());
        lexiconLabel.layout();
        lexiconLabel.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                DuelSetupScreen.this.game.lexiconScreen = new LexiconScreen(DuelSetupScreen.this.game, DuelSetupScreen.this.game.duelSetupScreen);
                DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.lexiconScreen);
            }
        });
        this.stage.addActor(lexiconLabel);
        if (!this.game.input.equalsIgnoreCase("keyboard")) {
            Button menuButton = new Button(this.game.uiSkin, "menu");
            menuButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
            menuButton.setHeight(menuButton.getWidth());
            menuButton.setX(10.0f);
            menuButton.setY(this.game.viewHeight.floatValue() - menuButton.getWidth() - 10.0f);
            menuButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (DuelSetupScreen.this.game.networkPort != null) {
                        DuelSetupScreen.this.sendMessage("disconnect", "");
                        DuelSetupScreen.this.game.networkPort.terminate();
                        DuelSetupScreen.this.game.networkPort = null;
                    }
                    DuelSetupScreen.this.game.mainMenuScreen = new MainMenuScreen(DuelSetupScreen.this.game);
                    DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.mainMenuScreen);
                }
            });
            menuButton.setVisible(true);
            this.stage.addActor(menuButton);
        }
        TextButton startButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.start"), this.game.uiSkin, "base");
        startButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / 810.0f);
        startButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / 108.0f).padRight(this.game.viewHeight.floatValue() / 108.0f);
        startButton.setWidth(MathUtils.clamp(this.game.viewHeight.floatValue() * 8.0f / 100.0f, startButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        startButton.setHeight(this.game.viewHeight.floatValue() * 8.0f / 100.0f);
        if (this.game.gameMode.equalsIgnoreCase("client")) {
            startButton.setDisabled(true);
            startButton.setVisible(false);
        } else {
            startButton.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (DuelSetupScreen.this.startTime == 0L) {
                        if (!DuelSetupScreen.this.readyP1.isChecked() || !DuelSetupScreen.this.readyP2.isChecked()) {
                            Label textLabel = new Label(PropertiesReader.getMessage(DuelSetupScreen.this.game.gameMessages, "game.settings.warning.ready"), DuelSetupScreen.this.game.uiSkin, "chat");
                            textLabel.setFontScale(DuelSetupScreen.this.game.viewHeight.floatValue() / DuelSetupScreen.this.game.viewHeightMAX.floatValue());
                            textLabel.setColor(Color.RED);
                            textLabel.setWrap(true);
                            textLabel.setWidth(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f));
                            float labelRealHeight = textLabel.getPrefHeight();
                            DuelSetupScreen.this.chatText.add(textLabel).pad(0.0f).left().bottom().size(MathUtils.clamp(DuelSetupScreen.this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f), labelRealHeight);
                            DuelSetupScreen.this.chatText.row();
                            DuelSetupScreen.this.chatPane.layout();
                            DuelSetupScreen.this.chatPane.setScrollY(DuelSetupScreen.this.chatText.getHeight());
                        } else {
                            DuelSetupScreen.this.startTime = MathUtils.random(1) + 1;
                            DuelSetupScreen.this.sendMessage("start", "" + DuelSetupScreen.this.startTime);
                        }
                    }
                }
            });
        }
        startButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        startButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        startButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), startButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        startButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        startButton.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - startButton.getPrefWidth());
        startButton.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 1.0f).floatValue());
        this.stage.addActor(startButton);
        TextButton exitButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "common.exit"), this.game.uiSkin, "base");
        exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (DuelSetupScreen.this.game.networkPort != null) {
                    DuelSetupScreen.this.sendMessage("disconnect", "");
                    DuelSetupScreen.this.game.networkPort.terminate();
                    DuelSetupScreen.this.game.networkPort = null;
                }
                DuelSetupScreen.this.game.mainMenuScreen = new MainMenuScreen(DuelSetupScreen.this.game);
                DuelSetupScreen.this.game.setScreen(DuelSetupScreen.this.game.mainMenuScreen);
            }
        });
        exitButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        exitButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        exitButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), exitButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        exitButton.setY(UIHelpers.calcHeightProportion(this.game, 5.0f, 1.0f).floatValue());
        this.stage.addActor(exitButton);
    }

    @Override
    public void render(float delta) {
        if (this.receivedDisconnect != null) {
            if (this.game.networkPort != null) {
                this.game.networkPort.terminate();
                this.game.networkPort = null;
            }
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
        }
        if (this.game.gameMode.equalsIgnoreCase("client")) {
            if (this.syncTime == -1) {
                this.sendMessage("input", "");
                this.sendMessage("input", "");
                this.sendMessage("input", "");
            }
            ++this.syncTime;
            if (this.syncTime == 60) {
                this.sendMessage("sync", "");
                this.syncTime = 0;
            }
        }
        if (this.startTime > 0L) {
            Fighter finalHostFighter = this.hostFighter;
            Fighter finalClientFighter = this.clientFighter;
            if (this.game.gameMode.equalsIgnoreCase("client")) {
                finalHostFighter = this.clientFighter;
                finalClientFighter = this.hostFighter;
            }
            if (this.hostAI.isChecked() && !this.hostAIbehavior.equalsIgnoreCase("")) {
                finalHostFighter.behavior = this.hostAIbehavior;
            }
            Logger.write("EVENT", "DuelSetupScreen.render finalHostFighter " + Fighter.fighterToString(finalHostFighter));
            Logger.write("EVENT", "DuelSetupScreen.render finalClientFighter " + Fighter.fighterToString(finalClientFighter));
            String finalDifficulty = "normal";
            if (this.difficulty.getSelected().equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.hard"))) {
                finalDifficulty = "hard";
            } else if (this.difficulty.getSelected().equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.difficulty.hardcore"))) {
                finalDifficulty = "hardcore";
            }
            String arenaCode = "";
            for (String currKey : this.game.gameMessages.stringPropertyNames()) {
                if (!currKey.startsWith("game.settings.arena.") || !PropertiesReader.getMessage(this.game.gameMessages, currKey).equalsIgnoreCase(this.arena.getSelected())) continue;
                arenaCode = currKey.replace("game.settings.arena.", "");
                break;
            }
            this.game.combatScreen = new CombatScreen(this.game, finalHostFighter, finalClientFighter, this.maxReputation, arenaCode, "sl" + String.format("%02d", Integer.parseInt(this.music.getSelected())), finalDifficulty, this.hostAI.isChecked(), this.startTime, 0, "");
            Fighter.loadFighterAssets(this.game, finalClientFighter, true, false);
            Fighter.loadFighterAssets(this.game, finalHostFighter, false, false);
            this.game.combatScreen.create();
            this.game.setScreen(this.game.combatScreen);
        }
        this.game.manager.update();
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public void dispose() {
        UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset("data/backgrounds/backgroundPrepPits.jpg"));
    }

    private Fighter resetFighter() {
        Fighter fighter = new Fighter();
        fighter.weapon = new Equipment();
        fighter.weapon.id = "dagger";
        fighter.weapon.tier = "wood";
        fighter.portrait = "p00";
        fighter.skinColor = this.game.stats.get("parts").getJSONObject("portraits").getJSONObject(fighter.portrait).getString("skinColor");
        fighter.bodyColor = this.game.stats.get("parts").getJSONObject("portraits").getJSONObject(fighter.portrait).getString("bodyColor");
        fighter.accessoryColor = this.game.stats.get("parts").getJSONObject("portraits").getJSONObject(fighter.portrait).getString("accessoryColor");
        fighter.special = "";
        return fighter;
    }

    public void sendMessage(String type, String data) {
        if (this.game.isMultiplayerGame()) {
            if (type.equalsIgnoreCase("chat")) {
                StringBuilder content = new StringBuilder();
                content.append("c_");
                content.append(data.replace("_", "###"));
                this.game.networkPort.sendData(content.toString());
            } else if (type.equalsIgnoreCase("change")) {
                StringBuilder content = new StringBuilder();
                content.append("g_");
                if (this.game.gameMode.equalsIgnoreCase("server")) {
                    content.append(this.game.multiplayerPlayerNameServer);
                    content.append("_");
                    content.append(this.readyP1.isChecked() ? "1" : "0");
                    content.append("_");
                    content.append((String)this.portraitImageP1.params.get("name"));
                    content.append("_");
                    content.append(Fighter.fighterToString(this.hostFighter));
                    content.append("_");
                    content.append(this.hostFighter.reputation);
                    content.append("_");
                    String arenaCode = "";
                    for (String currKey : this.game.gameMessages.stringPropertyNames()) {
                        if (!currKey.startsWith("game.settings.arena.") || !PropertiesReader.getMessage(this.game.gameMessages, currKey).equalsIgnoreCase(this.arena.getSelected())) continue;
                        arenaCode = currKey.replace("game.settings.arena.", "");
                        break;
                    }
                    content.append(arenaCode);
                    content.append("_");
                    content.append(this.music.getSelected());
                } else {
                    content.append(this.game.multiplayerPlayerNameClient);
                    content.append("_");
                    content.append(this.readyP2.isChecked() ? "1" : "0");
                    content.append("_");
                    content.append((String)this.portraitImageP2.params.get("name"));
                    content.append("_");
                    content.append(Fighter.fighterToString(this.clientFighter));
                    content.append("_");
                    content.append(this.clientFighter.reputation);
                }
                this.game.networkPort.sendData(content.toString());
            } else if (type.equalsIgnoreCase("input")) {
                StringBuilder content = new StringBuilder();
                content.append("i_");
                if (this.game.gameMode.equalsIgnoreCase("server")) {
                    content.append(this.game.multiplayerInput);
                    content.append("_");
                    content.append(PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum));
                } else {
                    content.append(this.game.input);
                    content.append("_");
                    content.append(PropertiesReader.verifyKey(this.game.mail, this.game.key, this.game.checksum));
                }
                this.game.networkPort.sendData(content.toString());
            } else if (type.equalsIgnoreCase("sync")) {
                StringBuilder content = new StringBuilder();
                content.append("y_");
                content.append(this.game.multiplayerPlayerNameServer);
                content.append("_");
                content.append(this.game.multiplayerPlayerNameClient);
                content.append("_");
                content.append(this.readyP1.isChecked() ? "1" : "0");
                content.append("_");
                content.append((String)this.portraitImageP1.params.get("name"));
                content.append("_");
                content.append(Fighter.fighterToString(this.hostFighter));
                content.append("_");
                content.append(this.hostFighter.reputation);
                content.append("_");
                content.append(this.readyP2.isChecked() ? "1" : "0");
                content.append("_");
                content.append((String)this.portraitImageP2.params.get("name"));
                content.append("_");
                content.append(Fighter.fighterToString(this.clientFighter));
                content.append("_");
                content.append(this.clientFighter.reputation);
                content.append("_");
                String arenaCode = "";
                for (String currKey : this.game.gameMessages.stringPropertyNames()) {
                    if (!currKey.startsWith("game.settings.arena.") || !PropertiesReader.getMessage(this.game.gameMessages, currKey).equalsIgnoreCase(this.arena.getSelected())) continue;
                    arenaCode = currKey.replace("game.settings.arena.", "");
                    break;
                }
                content.append(arenaCode);
                content.append("_");
                content.append(this.music.getSelected());
                content.append("_");
                content.append(this.maxReputation);
                this.game.networkPort.sendData(content.toString());
            } else if (type.equalsIgnoreCase("start")) {
                StringBuilder content = new StringBuilder();
                content.append("s_");
                content.append(data.replace("_", "###"));
                this.game.networkPort.sendData(content.toString());
            } else if (type.equalsIgnoreCase("disconnect")) {
                StringBuilder content = new StringBuilder();
                content.append("d_");
                content.append(data);
                this.game.networkPort.sendData(content.toString());
            }
        }
    }

    @Override
    public void receivedPacket(String content) {
        if (this.game.gameMode.equalsIgnoreCase("server")) {
            if (content.startsWith("g")) {
                TextureAtlas portraitsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
                this.game.multiplayerPlayerNameClient = content.split("_")[1];
                this.readyP2.setDisabled(false);
                this.readyP2.setChecked(Integer.parseInt(content.split("_")[2]) != 0);
                this.portraitImageP2.setTexture(portraitsAtlas.findRegion(content.split("_")[3]), (float)Float.valueOf(this.portraitImageP2.getWidth()).intValue(), (float)Float.valueOf(this.portraitImageP2.getHeight()).intValue());
                this.portraitImageP2.params.put("name", content.split("_")[3]);
                this.clientFighter = Fighter.stringToFighter(content.split("_")[4]);
                this.clientFighter.reputation = Integer.parseInt(content.split("_")[5]);
                this.reputationP2.setText(this.clientFighter.reputation + " / " + (this.maxReputation == 0 ? "-" : Integer.valueOf(this.maxReputation)));
                this.readyP2.setDisabled(true);
            } else if (content.startsWith("i")) {
                if (this.game.multiplayerInput.equalsIgnoreCase("")) {
                    String clientInput = content.split("_")[1];
                    Label textLabel = new Label("", this.game.uiSkin, "chat");
                    if (clientInput.equalsIgnoreCase("keyboard") && this.game.input.equalsIgnoreCase("keyboard")) {
                        this.game.multiplayerInput = "keyboard";
                        textLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.input") + ": " + PropertiesReader.getMessage(this.game.gameMessages, "options.input.keyboard"));
                    } else {
                        this.game.multiplayerInput = "touch";
                        textLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.input") + ": " + PropertiesReader.getMessage(this.game.gameMessages, "options.input.touch") + "/" + PropertiesReader.getMessage(this.game.gameMessages, "options.input.mouse"));
                    }
                    textLabel.setColor(this.game.uiSkin.get("red", Color.class));
                    textLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.viewHeightMAX.floatValue());
                    textLabel.setWrap(true);
                    textLabel.setWidth(MathUtils.clamp(this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f));
                    float labelRealHeight = textLabel.getPrefHeight();
                    this.chatText.add(textLabel).pad(0.0f).left().bottom().size(MathUtils.clamp(this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f), labelRealHeight);
                    this.chatText.row();
                    this.chatPane.layout();
                    this.chatPane.setScrollY(this.chatText.getHeight());
                    this.clientLicense = content.split("_")[2];
                    if (this.clientLicense.equalsIgnoreCase("extra")) {
                        this.supporterIconP2.setVisible(true);
                    }
                    this.sendMessage("input", "");
                    this.sendMessage("input", "");
                    this.sendMessage("input", "");
                }
            } else if (content.startsWith("y")) {
                boolean checkSync = this.game.multiplayerPlayerNameServer.equalsIgnoreCase(content.split("_")[1]);
                boolean bl = checkSync = checkSync && this.game.multiplayerPlayerNameClient.equalsIgnoreCase(content.split("_")[2]);
                checkSync = checkSync && this.readyP1.isChecked() == (Integer.parseInt(content.split("_")[3]) != 0);
                checkSync = checkSync && ((String)this.portraitImageP1.params.get("name")).equalsIgnoreCase(content.split("_")[4]);
                checkSync = checkSync && Fighter.fighterToString(this.hostFighter).equalsIgnoreCase(content.split("_")[5]);
                boolean bl2 = checkSync = checkSync && this.hostFighter.reputation == Integer.parseInt(content.split("_")[6]);
                checkSync = checkSync && this.readyP2.isChecked() == (Integer.parseInt(content.split("_")[7]) != 0);
                checkSync = checkSync && ((String)this.portraitImageP2.params.get("name")).equalsIgnoreCase(content.split("_")[8]);
                checkSync = checkSync && Fighter.fighterToString(this.clientFighter).equalsIgnoreCase(content.split("_")[9]);
                checkSync = checkSync && this.clientFighter.reputation == Integer.parseInt(content.split("_")[10]);
                checkSync = checkSync && this.arena.getSelected().equalsIgnoreCase(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena." + content.split("_")[11]));
                checkSync = checkSync && this.music.getSelected().equalsIgnoreCase(content.split("_")[12]);
                boolean bl3 = checkSync = checkSync && this.maxReputation == Integer.parseInt(content.split("_")[13]);
                if (!checkSync) {
                    this.sendMessage("sync", "");
                }
            } else if (content.startsWith("d")) {
                this.receivedDisconnect = true;
            } else if (content.startsWith("c")) {
                Label textLabel = new Label(this.game.multiplayerPlayerNameClient + ": " + content.split("_")[1], this.game.uiSkin, "chat");
                textLabel.setColor(this.game.uiSkin.get("iron", Color.class));
                textLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.viewHeightMAX.floatValue());
                textLabel.setWrap(true);
                textLabel.setWidth(MathUtils.clamp(this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f));
                float labelRealHeight = textLabel.getPrefHeight();
                this.chatText.add(textLabel).pad(0.0f).left().bottom().size(MathUtils.clamp(this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f), labelRealHeight);
                this.chatText.row();
                this.chatPane.layout();
                this.chatPane.setScrollY(this.chatText.getHeight());
            }
        } else if (this.game.gameMode.equalsIgnoreCase("client")) {
            if (content.startsWith("g")) {
                TextureAtlas portraitsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
                this.readyP1.setDisabled(false);
                this.arena.setDisabled(false);
                this.music.setDisabled(false);
                this.game.multiplayerPlayerNameServer = content.split("_")[1];
                this.readyP1.setChecked(Integer.parseInt(content.split("_")[2]) != 0);
                this.portraitImageP1.setTexture(portraitsAtlas.findRegion(content.split("_")[3]), (float)Float.valueOf(this.portraitImageP1.getWidth()).intValue(), (float)Float.valueOf(this.portraitImageP1.getHeight()).intValue());
                this.portraitImageP1.params.put("name", content.split("_")[3]);
                this.hostFighter = Fighter.stringToFighter(content.split("_")[4]);
                this.hostFighter.reputation = Integer.parseInt(content.split("_")[5]);
                this.reputationP1.setText(this.hostFighter.reputation + " / " + (this.maxReputation == 0 ? "-" : Integer.valueOf(this.maxReputation)));
                this.arena.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena." + content.split("_")[6]));
                this.music.setSelected(content.split("_")[7]);
                this.readyP1.setDisabled(true);
                this.arena.setDisabled(true);
                this.music.setDisabled(true);
            } else if (content.startsWith("i")) {
                if (this.game.multiplayerInput.equalsIgnoreCase("")) {
                    this.game.multiplayerInput = content.split("_")[1];
                    Label textLabel = new Label("", this.game.uiSkin, "chat");
                    if (this.game.multiplayerInput.equalsIgnoreCase("keyboard")) {
                        this.game.multiplayerInput = "keyboard";
                        textLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.input") + ": " + PropertiesReader.getMessage(this.game.gameMessages, "options.input.keyboard"));
                    } else {
                        this.game.multiplayerInput = "touch";
                        textLabel.setText(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.input") + ": " + PropertiesReader.getMessage(this.game.gameMessages, "options.input.touch") + "/" + PropertiesReader.getMessage(this.game.gameMessages, "options.input.mouse"));
                    }
                    textLabel.setColor(this.game.uiSkin.get("red", Color.class));
                    textLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.viewHeightMAX.floatValue());
                    textLabel.setWrap(true);
                    textLabel.setWidth(MathUtils.clamp(this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f));
                    float labelRealHeight = textLabel.getPrefHeight();
                    this.chatText.add(textLabel).pad(0.0f).left().bottom().size(MathUtils.clamp(this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f), labelRealHeight);
                    this.chatText.row();
                    this.chatPane.layout();
                    this.chatPane.setScrollY(this.chatText.getHeight());
                    this.serverLicense = content.split("_")[2];
                    if (this.serverLicense.equalsIgnoreCase("extra")) {
                        this.supporterIconP1.setVisible(true);
                    }
                }
            } else if (content.startsWith("y")) {
                TextureAtlas portraitsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
                this.readyP1.setDisabled(false);
                this.arena.setDisabled(false);
                this.music.setDisabled(false);
                this.readyP1.setChecked(Integer.parseInt(content.split("_")[3]) != 0);
                this.portraitImageP1.setTexture(portraitsAtlas.findRegion(content.split("_")[4]), (float)Float.valueOf(this.portraitImageP1.getWidth()).intValue(), (float)Float.valueOf(this.portraitImageP1.getHeight()).intValue());
                this.portraitImageP1.params.put("name", content.split("_")[4]);
                this.hostFighter = Fighter.stringToFighter(content.split("_")[5]);
                this.hostFighter.reputation = Integer.parseInt(content.split("_")[6]);
                this.readyP2.setChecked(Integer.parseInt(content.split("_")[7]) != 0);
                this.portraitImageP2.setTexture(portraitsAtlas.findRegion(content.split("_")[8]), (float)Float.valueOf(this.portraitImageP2.getWidth()).intValue(), (float)Float.valueOf(this.portraitImageP2.getHeight()).intValue());
                this.portraitImageP2.params.put("name", content.split("_")[8]);
                this.clientFighter = Fighter.stringToFighter(content.split("_")[9]);
                this.clientFighter.reputation = Integer.parseInt(content.split("_")[10]);
                this.arena.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "game.settings.arena." + content.split("_")[11]));
                this.music.setSelected(content.split("_")[12]);
                this.maxReputation = Integer.parseInt(content.split("_")[13]);
                this.reputationP1.setText(this.hostFighter.reputation + " / " + (this.maxReputation == 0 ? "-" : Integer.valueOf(this.maxReputation)));
                this.reputationP2.setText(this.clientFighter.reputation + " / " + (this.maxReputation == 0 ? "-" : Integer.valueOf(this.maxReputation)));
                this.readyP1.setDisabled(true);
                this.arena.setDisabled(true);
                this.music.setDisabled(true);
            } else if (content.startsWith("s")) {
                this.startTime = Long.parseLong(content.split("_")[1]);
            } else if (content.startsWith("d")) {
                this.receivedDisconnect = true;
            } else if (content.startsWith("c")) {
                Label textLabel = new Label(this.game.multiplayerPlayerNameServer + ": " + content.split("_")[1].replace("###", "_"), this.game.uiSkin, "chat");
                textLabel.setColor(this.game.uiSkin.get("iron", Color.class));
                textLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.viewHeightMAX.floatValue());
                textLabel.setWrap(true);
                textLabel.setWidth(MathUtils.clamp(this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f));
                float labelRealHeight = textLabel.getPrefHeight();
                this.chatText.add(textLabel).pad(0.0f).left().bottom().size(MathUtils.clamp(this.game.viewWidth.floatValue() / 2.0f, 540.0f, 720.0f), labelRealHeight);
                this.chatText.row();
                this.chatPane.layout();
                this.chatPane.setScrollY(this.chatText.getHeight());
            }
        }
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4 || keycode == 82) {
            if (this.game.networkPort != null) {
                this.sendMessage("disconnect", "");
                this.game.networkPort.terminate();
                this.game.networkPort = null;
            }
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
        } else if (keycode == 244) {
            this.game.lexiconScreen = new LexiconScreen(this.game, this.game.duelSetupScreen);
            this.game.setScreen(this.game.lexiconScreen);
        }
        return false;
    }
}

