/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.ArrayList;

public class CreditsScreen
extends BaseScreen {
    public boolean end = false;
    public float elapsedTime = 0.0f;
    public ArrayList<String> backgroundImages = new ArrayList();

    public CreditsScreen(SlavePitsGame g, boolean isEnd) {
        super(g);
        this.end = isEnd;
        this.create();
    }

    @Override
    public void create() {
        if (this.game.track != null && this.game.track.isPlaying()) {
            this.game.track.stop();
            this.game.track.dispose();
        }
        this.game.track = Gdx.audio.newMusic(Gdx.files.internal(this.game.getOverridenFilename("music/sl16.ogg")));
        this.game.track.setVolume(this.game.musicVolume);
        this.game.track.play();
        this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/title.png"), Texture.class);
        this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/calimasaga.png"), Texture.class);
        this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/fog.jpg"), Texture.class);
        this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyFrame.png"), Texture.class);
        if (!this.end) {
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyCred1.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyCred2.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyCred3.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyCred4.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyCred5.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyCred6.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyCred7.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyCred8.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyCred9.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyCred10.jpg"), Texture.class);
        } else {
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyLore1.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyLore2.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyLore3.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyLore4.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyLore5.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyLore6.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyLore7.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyLore8.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyLore9nv.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyLore9.jpg"), Texture.class);
            this.game.manager.load(this.game.getOverridenFilename("data/backgrounds/storyLore10.jpg"), Texture.class);
        }
        while (!this.game.manager.update()) {
        }
        BaseActor fogImage = new BaseActor();
        fogImage.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/fog.jpg"), Texture.class), UIHelpers.calcWidthProportion(this.game, 100.0f, 100.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 100.0f, 100.0f).floatValue());
        this.backgroundImages.add("data/backgrounds/fog.jpg");
        fogImage.setX(UIHelpers.calcWidthProportion(this.game, 0.0f, 0.0f).floatValue());
        fogImage.setY(UIHelpers.calcHeightProportion(this.game, 0.0f, 0.0f).floatValue());
        fogImage.getColor().a = 0.0f;
        this.stage.addActor(fogImage);
        SequenceAction fogAction = Actions.sequence((Action)Actions.fadeIn(3.0f), (Action)Actions.parallel((Action)Actions.fadeOut(3.0f), (Action)Actions.moveBy(-UIHelpers.calcWidthProportion(this.game, 10.0f, 10.0f).floatValue(), -UIHelpers.calcWidthProportion(this.game, 10.0f, 10.0f).floatValue(), 3.0f), (Action)Actions.scaleTo(1.2f, 1.2f, 3.0f)), (Action)Actions.hide());
        fogImage.addAction(fogAction);
        BaseActor titleImage = new BaseActor();
        titleImage.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/title.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 75.0f, 75.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 25.0f, 25.0f).floatValue());
        this.backgroundImages.add("data/backgrounds/title.png");
        titleImage.setX(UIHelpers.calcWidthProportion(this.game, 12.5f, 12.5f).floatValue());
        titleImage.setY(UIHelpers.calcHeightProportion(this.game, 60.0f, 60.0f).floatValue());
        titleImage.getColor().a = 0.0f;
        this.stage.addActor(titleImage);
        SequenceAction titleAction = Actions.sequence((Action)Actions.delay(6.5f), (Action)Actions.fadeIn(2.0f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        titleImage.addAction(titleAction);
        Label by = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.by"), this.game.uiSkin, "default");
        by.setAlignment(1);
        by.setColor(this.game.uiSkin.get("silver", Color.class));
        by.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(by, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue(), 0.0f);
        by.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - by.getWidth() / 2.0f);
        by.setY(UIHelpers.calcHeightProportion(this.game, 50.0f, 50.0f).floatValue() - by.getPrefHeight());
        by.getColor().a = 0.0f;
        this.stage.addActor(by);
        SequenceAction byAction = Actions.sequence((Action)Actions.delay(6.5f), (Action)Actions.fadeIn(2.0f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        by.addAction(byAction);
        BaseActor calimaImage = new BaseActor();
        calimaImage.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/calimasaga.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 8.5f, 8.5f).floatValue());
        this.backgroundImages.add("data/backgrounds/calimasaga.png");
        calimaImage.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - calimaImage.getWidth() / 2.0f);
        calimaImage.setY(UIHelpers.calcHeightProportion(this.game, 40.0f, 40.0f).floatValue() - calimaImage.getHeight());
        calimaImage.getColor().a = 0.0f;
        this.stage.addActor(calimaImage);
        SequenceAction calimaAction = Actions.sequence((Action)Actions.delay(6.5f), (Action)Actions.fadeIn(2.0f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        calimaImage.addAction(calimaAction);
        Label design = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.design"), this.game.uiSkin, "combat");
        design.setAlignment(1);
        design.setColor(this.game.uiSkin.get("lightiron", Color.class));
        design.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(design, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        design.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - design.getWidth() / 2.0f);
        design.setY(UIHelpers.calcHeightProportion(this.game, 92.5f, 92.5f).floatValue() - design.getPrefHeight() - this.game.viewHeight.floatValue());
        this.stage.addActor(design);
        SequenceAction designAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        design.addAction(designAction);
        Label designNames = new Label("Om\nOmar Fern\u00e1ndez Varea", this.game.uiSkin, "default");
        designNames.setAlignment(1);
        designNames.setColor(this.game.uiSkin.get("silver", Color.class));
        designNames.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue() / 2.0f);
        UIHelpers.fixLabelFontSize(designNames, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue(), 0.0f);
        designNames.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - designNames.getWidth() / 2.0f);
        designNames.setY(UIHelpers.calcHeightProportion(this.game, 87.5f, 87.5f).floatValue() - designNames.getPrefHeight() - this.game.viewHeight.floatValue());
        this.stage.addActor(designNames);
        SequenceAction designNamesAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        designNames.addAction(designNamesAction);
        BaseActor storyImage1 = new BaseActor();
        storyImage1.setTexture(this.game.manager.get(!this.end ? this.game.getOverridenAsset("data/backgrounds/storyCred1.jpg") : this.game.getOverridenAsset("data/backgrounds/storyLore1.jpg"), Texture.class), UIHelpers.calcWidthProportion(this.game, 38.0f, 38.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 19.0f, 19.0f).floatValue());
        this.backgroundImages.add(!this.end ? "data/backgrounds/storyCred1.jpg" : "data/backgrounds/storyLore1.jpg");
        storyImage1.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyImage1.getWidth() / 2.0f);
        storyImage1.setY(UIHelpers.calcHeightProportion(this.game, 99.5f, 74.5f).floatValue() - storyImage1.getHeight() - this.game.viewHeight.floatValue());
        this.stage.addActor(storyImage1);
        SequenceAction storyImage1Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyImage1.addAction(storyImage1Action);
        BaseActor storyFrame1 = new BaseActor();
        storyFrame1.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/storyFrame.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 40.0f, 40.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        this.backgroundImages.add("data/backgrounds/storyFrame.png");
        storyFrame1.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyFrame1.getWidth() / 2.0f);
        storyFrame1.setY(UIHelpers.calcHeightProportion(this.game, 100.0f, 75.0f).floatValue() - storyFrame1.getHeight() - this.game.viewHeight.floatValue());
        this.stage.addActor(storyFrame1);
        SequenceAction storyFrame1Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyFrame1.addAction(storyFrame1Action);
        Label storyLore1 = new Label(!this.end ? "" : PropertiesReader.getMessage(this.game.gameMessages, "game.credits.lore1"), this.game.uiSkin, "default");
        storyLore1.setAlignment(2);
        storyLore1.setWrap(true);
        storyLore1.setWidth(UIHelpers.calcWidthProportion(this.game, 36.0f, 56.0f).floatValue());
        storyLore1.setColor(this.game.uiSkin.get("silver", Color.class));
        storyLore1.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(storyLore1, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, UIHelpers.calcWidthProportion(this.game, 20.0f, 12.0f).floatValue());
        storyLore1.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyLore1.getWidth() / 2.0f);
        storyLore1.setY(storyFrame1.getY() - UIHelpers.calcHeightProportion(this.game, 2.0f, 1.0f).floatValue() - storyLore1.getHeight());
        this.stage.addActor(storyLore1);
        SequenceAction storyLore1Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyLore1.addAction(storyLore1Action);
        Label story = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.story"), this.game.uiSkin, "combat");
        story.setAlignment(1);
        story.setColor(this.game.uiSkin.get("lightiron", Color.class));
        story.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(story, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        story.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - story.getWidth() / 2.0f);
        story.setY(UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue() - story.getPrefHeight() - this.game.viewHeight.floatValue() * 3.0f / 2.0f);
        this.stage.addActor(story);
        SequenceAction storyAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        story.addAction(storyAction);
        Label storyNames = new Label("Om", this.game.uiSkin, "default");
        storyNames.setAlignment(1);
        storyNames.setColor(this.game.uiSkin.get("silver", Color.class));
        storyNames.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue() / 2.0f);
        UIHelpers.fixLabelFontSize(storyNames, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue(), 0.0f);
        storyNames.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyNames.getWidth() / 2.0f);
        storyNames.setY(UIHelpers.calcHeightProportion(this.game, 85.0f, 85.0f).floatValue() - storyNames.getPrefHeight() - this.game.viewHeight.floatValue() * 3.0f / 2.0f);
        this.stage.addActor(storyNames);
        SequenceAction storyNamesAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyNames.addAction(storyNamesAction);
        BaseActor storyImage2 = new BaseActor();
        storyImage2.setTexture(this.game.manager.get(!this.end ? this.game.getOverridenAsset("data/backgrounds/storyCred2.jpg") : this.game.getOverridenAsset("data/backgrounds/storyLore2.jpg"), Texture.class), UIHelpers.calcWidthProportion(this.game, 38.0f, 38.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 19.0f, 19.0f).floatValue());
        this.backgroundImages.add(!this.end ? "data/backgrounds/storyCred2.jpg" : "data/backgrounds/storyLore2.jpg");
        storyImage2.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyImage2.getWidth() / 2.0f);
        storyImage2.setY(UIHelpers.calcHeightProportion(this.game, 99.5f, 74.5f).floatValue() - storyImage2.getHeight() - this.game.viewHeight.floatValue() * 3.0f / 2.0f);
        this.stage.addActor(storyImage2);
        SequenceAction storyImage2Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyImage2.addAction(storyImage2Action);
        BaseActor storyFrame2 = new BaseActor();
        storyFrame2.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/storyFrame.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 40.0f, 40.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        storyFrame2.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyFrame2.getWidth() / 2.0f);
        storyFrame2.setY(UIHelpers.calcHeightProportion(this.game, 100.0f, 75.0f).floatValue() - storyFrame2.getHeight() - this.game.viewHeight.floatValue() * 3.0f / 2.0f);
        this.stage.addActor(storyFrame2);
        SequenceAction storyFrame2Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyFrame2.addAction(storyFrame2Action);
        Label storyLore2 = new Label(!this.end ? "" : PropertiesReader.getMessage(this.game.gameMessages, "game.credits.lore2"), this.game.uiSkin, "default");
        storyLore2.setAlignment(2);
        storyLore2.setWrap(true);
        storyLore2.setWidth(UIHelpers.calcWidthProportion(this.game, 36.0f, 56.0f).floatValue());
        storyLore2.setColor(this.game.uiSkin.get("silver", Color.class));
        storyLore2.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(storyLore2, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, UIHelpers.calcWidthProportion(this.game, 20.0f, 12.0f).floatValue());
        storyLore2.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyLore2.getWidth() / 2.0f);
        storyLore2.setY(storyFrame2.getY() - UIHelpers.calcHeightProportion(this.game, 2.0f, 1.0f).floatValue() - storyLore2.getHeight());
        this.stage.addActor(storyLore2);
        SequenceAction storyLore2Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyLore2.addAction(storyLore2Action);
        Label programming = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.programming"), this.game.uiSkin, "combat");
        programming.setAlignment(1);
        programming.setColor(this.game.uiSkin.get("lightiron", Color.class));
        programming.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(programming, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        programming.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - programming.getWidth() / 2.0f);
        programming.setY(UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue() - programming.getPrefHeight() - this.game.viewHeight.floatValue() * 2.0f);
        this.stage.addActor(programming);
        SequenceAction programmingAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        programming.addAction(programmingAction);
        Label programmingNames = new Label("Om", this.game.uiSkin, "default");
        programmingNames.setAlignment(1);
        programmingNames.setColor(this.game.uiSkin.get("silver", Color.class));
        programmingNames.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue() / 2.0f);
        UIHelpers.fixLabelFontSize(programmingNames, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue(), 0.0f);
        programmingNames.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - programmingNames.getWidth() / 2.0f);
        programmingNames.setY(UIHelpers.calcHeightProportion(this.game, 85.0f, 85.0f).floatValue() - programmingNames.getPrefHeight() - this.game.viewHeight.floatValue() * 2.0f);
        this.stage.addActor(programmingNames);
        SequenceAction programmingNamesAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        programmingNames.addAction(programmingNamesAction);
        BaseActor storyImage3 = new BaseActor();
        storyImage3.setTexture(this.game.manager.get(!this.end ? this.game.getOverridenAsset("data/backgrounds/storyCred3.jpg") : this.game.getOverridenAsset("data/backgrounds/storyLore3.jpg"), Texture.class), UIHelpers.calcWidthProportion(this.game, 38.0f, 38.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 19.0f, 19.0f).floatValue());
        this.backgroundImages.add(!this.end ? "data/backgrounds/storyCred3.jpg" : "data/backgrounds/storyLore3.jpg");
        storyImage3.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyImage3.getWidth() / 2.0f);
        storyImage3.setY(UIHelpers.calcHeightProportion(this.game, 99.5f, 74.5f).floatValue() - storyImage3.getHeight() - this.game.viewHeight.floatValue() * 2.0f);
        this.stage.addActor(storyImage3);
        SequenceAction storyImage3Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyImage3.addAction(storyImage3Action);
        BaseActor storyFrame3 = new BaseActor();
        storyFrame3.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/storyFrame.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 40.0f, 40.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        storyFrame3.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyFrame3.getWidth() / 2.0f);
        storyFrame3.setY(UIHelpers.calcHeightProportion(this.game, 100.0f, 75.0f).floatValue() - storyFrame3.getHeight() - this.game.viewHeight.floatValue() * 2.0f);
        this.stage.addActor(storyFrame3);
        SequenceAction storyFrame3Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyFrame3.addAction(storyFrame3Action);
        Label storyLore3 = new Label(!this.end ? "" : PropertiesReader.getMessage(this.game.gameMessages, "game.credits.lore3"), this.game.uiSkin, "default");
        storyLore3.setAlignment(2);
        storyLore3.setWrap(true);
        storyLore3.setWidth(UIHelpers.calcWidthProportion(this.game, 36.0f, 56.0f).floatValue());
        storyLore3.setColor(this.game.uiSkin.get("silver", Color.class));
        storyLore3.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(storyLore3, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, UIHelpers.calcWidthProportion(this.game, 20.0f, 12.0f).floatValue());
        storyLore3.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyLore3.getWidth() / 2.0f);
        storyLore3.setY(storyFrame3.getY() - UIHelpers.calcHeightProportion(this.game, 2.0f, 1.0f).floatValue() - storyLore3.getHeight());
        this.stage.addActor(storyLore3);
        SequenceAction storyLore3Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyLore3.addAction(storyLore3Action);
        Label graphics = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.graphicssound"), this.game.uiSkin, "combat");
        graphics.setAlignment(1);
        graphics.setColor(this.game.uiSkin.get("lightiron", Color.class));
        graphics.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(graphics, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        graphics.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - graphics.getWidth() / 2.0f);
        graphics.setY(UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue() - graphics.getPrefHeight() - this.game.viewHeight.floatValue() * 5.0f / 2.0f);
        this.stage.addActor(graphics);
        SequenceAction graphicsAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        graphics.addAction(graphicsAction);
        Label graphicsNames = new Label("Om", this.game.uiSkin, "default");
        graphicsNames.setAlignment(1);
        graphicsNames.setColor(this.game.uiSkin.get("silver", Color.class));
        graphicsNames.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue() / 2.0f);
        UIHelpers.fixLabelFontSize(graphicsNames, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue(), 0.0f);
        graphicsNames.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - graphicsNames.getWidth() / 2.0f);
        graphicsNames.setY(UIHelpers.calcHeightProportion(this.game, 85.0f, 85.0f).floatValue() - graphicsNames.getPrefHeight() - this.game.viewHeight.floatValue() * 5.0f / 2.0f);
        this.stage.addActor(graphicsNames);
        SequenceAction graphicsNamesAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        graphicsNames.addAction(graphicsNamesAction);
        BaseActor storyImage4 = new BaseActor();
        storyImage4.setTexture(this.game.manager.get(!this.end ? this.game.getOverridenAsset("data/backgrounds/storyCred4.jpg") : this.game.getOverridenAsset("data/backgrounds/storyLore4.jpg"), Texture.class), UIHelpers.calcWidthProportion(this.game, 38.0f, 38.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 19.0f, 19.0f).floatValue());
        this.backgroundImages.add(!this.end ? "data/backgrounds/storyCred4.jpg" : "data/backgrounds/storyLore4.jpg");
        storyImage4.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyImage4.getWidth() / 2.0f);
        storyImage4.setY(UIHelpers.calcHeightProportion(this.game, 99.5f, 74.5f).floatValue() - storyImage4.getHeight() - this.game.viewHeight.floatValue() * 5.0f / 2.0f);
        this.stage.addActor(storyImage4);
        SequenceAction storyImage4Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyImage4.addAction(storyImage4Action);
        BaseActor storyFrame4 = new BaseActor();
        storyFrame4.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/storyFrame.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 40.0f, 40.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        storyFrame4.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyFrame4.getWidth() / 2.0f);
        storyFrame4.setY(UIHelpers.calcHeightProportion(this.game, 100.0f, 75.0f).floatValue() - storyFrame4.getHeight() - this.game.viewHeight.floatValue() * 5.0f / 2.0f);
        this.stage.addActor(storyFrame4);
        SequenceAction storyFrame4Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyFrame4.addAction(storyFrame4Action);
        Label storyLore4 = new Label(!this.end ? "" : PropertiesReader.getMessage(this.game.gameMessages, "game.credits.lore4"), this.game.uiSkin, "default");
        storyLore4.setAlignment(2);
        storyLore4.setWrap(true);
        storyLore4.setWidth(UIHelpers.calcWidthProportion(this.game, 36.0f, 56.0f).floatValue());
        storyLore4.setColor(this.game.uiSkin.get("silver", Color.class));
        storyLore4.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(storyLore4, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, UIHelpers.calcWidthProportion(this.game, 20.0f, 12.0f).floatValue());
        storyLore4.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyLore4.getWidth() / 2.0f);
        storyLore4.setY(storyFrame4.getY() - UIHelpers.calcHeightProportion(this.game, 2.0f, 1.0f).floatValue() - storyLore4.getHeight());
        this.stage.addActor(storyLore4);
        SequenceAction storyLore4Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyLore4.addAction(storyLore4Action);
        Label character = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.character"), this.game.uiSkin, "combat");
        character.setAlignment(1);
        character.setColor(this.game.uiSkin.get("lightiron", Color.class));
        character.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(character, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        character.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - character.getWidth() / 2.0f);
        character.setY(UIHelpers.calcHeightProportion(this.game, 92.5f, 92.5f).floatValue() - character.getPrefHeight() - this.game.viewHeight.floatValue() * 3.0f);
        this.stage.addActor(character);
        SequenceAction characterAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        character.addAction(characterAction);
        Label characterNames = new Label("Eneas Ribelles\nOm", this.game.uiSkin, "default");
        characterNames.setAlignment(1);
        characterNames.setColor(this.game.uiSkin.get("silver", Color.class));
        characterNames.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue() / 2.0f);
        UIHelpers.fixLabelFontSize(characterNames, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue(), 0.0f);
        characterNames.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - characterNames.getWidth() / 2.0f);
        characterNames.setY(UIHelpers.calcHeightProportion(this.game, 87.5f, 87.5f).floatValue() - characterNames.getPrefHeight() - this.game.viewHeight.floatValue() * 3.0f);
        this.stage.addActor(characterNames);
        SequenceAction characterNamesAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        characterNames.addAction(characterNamesAction);
        BaseActor storyImage5 = new BaseActor();
        storyImage5.setTexture(this.game.manager.get(!this.end ? this.game.getOverridenAsset("data/backgrounds/storyCred5.jpg") : this.game.getOverridenAsset("data/backgrounds/storyLore5.jpg"), Texture.class), UIHelpers.calcWidthProportion(this.game, 38.0f, 38.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 19.0f, 19.0f).floatValue());
        this.backgroundImages.add(!this.end ? "data/backgrounds/storyCred5.jpg" : "data/backgrounds/storyLore5.jpg");
        storyImage5.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyImage5.getWidth() / 2.0f);
        storyImage5.setY(UIHelpers.calcHeightProportion(this.game, 99.5f, 74.5f).floatValue() - storyImage5.getHeight() - this.game.viewHeight.floatValue() * 3.0f);
        this.stage.addActor(storyImage5);
        SequenceAction storyImage5Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyImage5.addAction(storyImage5Action);
        BaseActor storyFrame5 = new BaseActor();
        storyFrame5.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/storyFrame.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 40.0f, 40.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        storyFrame5.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyFrame5.getWidth() / 2.0f);
        storyFrame5.setY(UIHelpers.calcHeightProportion(this.game, 100.0f, 75.0f).floatValue() - storyFrame5.getHeight() - this.game.viewHeight.floatValue() * 3.0f);
        this.stage.addActor(storyFrame5);
        SequenceAction storyFrame5Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyFrame5.addAction(storyFrame5Action);
        Label storyLore5 = new Label(!this.end ? "" : PropertiesReader.getMessage(this.game.gameMessages, "game.credits.lore5"), this.game.uiSkin, "default");
        storyLore5.setAlignment(2);
        storyLore5.setWrap(true);
        storyLore5.setWidth(UIHelpers.calcWidthProportion(this.game, 36.0f, 56.0f).floatValue());
        storyLore5.setColor(this.game.uiSkin.get("silver", Color.class));
        storyLore5.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(storyLore5, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, UIHelpers.calcWidthProportion(this.game, 20.0f, 12.0f).floatValue());
        storyLore5.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyLore5.getWidth() / 2.0f);
        storyLore5.setY(storyFrame5.getY() - UIHelpers.calcHeightProportion(this.game, 2.0f, 1.0f).floatValue() - storyLore5.getHeight());
        this.stage.addActor(storyLore5);
        SequenceAction storyLore5Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyLore5.addAction(storyLore5Action);
        Label music = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.music"), this.game.uiSkin, "combat");
        music.setAlignment(1);
        music.setColor(this.game.uiSkin.get("lightiron", Color.class));
        music.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(music, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        music.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - music.getWidth() / 2.0f);
        music.setY(UIHelpers.calcHeightProportion(this.game, 92.5f, 92.5f).floatValue() - music.getPrefHeight() - this.game.viewHeight.floatValue() * 7.0f / 2.0f);
        this.stage.addActor(music);
        SequenceAction musicAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        music.addAction(musicAction);
        Label musicNames = new Label("David Berg\u00e9s\nRok Nardin", this.game.uiSkin, "default");
        musicNames.setAlignment(1);
        musicNames.setColor(this.game.uiSkin.get("silver", Color.class));
        musicNames.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue() / 2.0f);
        UIHelpers.fixLabelFontSize(musicNames, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue(), 0.0f);
        musicNames.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - musicNames.getWidth() / 2.0f);
        musicNames.setY(UIHelpers.calcHeightProportion(this.game, 87.5f, 87.5f).floatValue() - musicNames.getPrefHeight() - this.game.viewHeight.floatValue() * 7.0f / 2.0f);
        this.stage.addActor(musicNames);
        SequenceAction musicNamesAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        musicNames.addAction(musicNamesAction);
        BaseActor storyImage6 = new BaseActor();
        storyImage6.setTexture(this.game.manager.get(!this.end ? this.game.getOverridenAsset("data/backgrounds/storyCred6.jpg") : this.game.getOverridenAsset("data/backgrounds/storyLore6.jpg"), Texture.class), UIHelpers.calcWidthProportion(this.game, 38.0f, 38.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 19.0f, 19.0f).floatValue());
        this.backgroundImages.add(!this.end ? "data/backgrounds/storyCred6.jpg" : "data/backgrounds/storyLore6.jpg");
        storyImage6.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyImage6.getWidth() / 2.0f);
        storyImage6.setY(UIHelpers.calcHeightProportion(this.game, 99.5f, 74.5f).floatValue() - storyImage6.getHeight() - this.game.viewHeight.floatValue() * 7.0f / 2.0f);
        this.stage.addActor(storyImage6);
        SequenceAction storyImage6Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyImage6.addAction(storyImage6Action);
        BaseActor storyFrame6 = new BaseActor();
        storyFrame6.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/storyFrame.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 40.0f, 40.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        storyFrame6.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyFrame6.getWidth() / 2.0f);
        storyFrame6.setY(UIHelpers.calcHeightProportion(this.game, 100.0f, 75.0f).floatValue() - storyFrame6.getHeight() - this.game.viewHeight.floatValue() * 7.0f / 2.0f);
        this.stage.addActor(storyFrame6);
        SequenceAction storyFrame6Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyFrame6.addAction(storyFrame6Action);
        Label storyLore6 = new Label(!this.end ? "" : PropertiesReader.getMessage(this.game.gameMessages, "game.credits.lore6"), this.game.uiSkin, "default");
        storyLore6.setAlignment(2);
        storyLore6.setWrap(true);
        storyLore6.setWidth(UIHelpers.calcWidthProportion(this.game, 36.0f, 56.0f).floatValue());
        storyLore6.setColor(this.game.uiSkin.get("silver", Color.class));
        storyLore6.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(storyLore6, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, UIHelpers.calcWidthProportion(this.game, 20.0f, 12.0f).floatValue());
        storyLore6.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyLore6.getWidth() / 2.0f);
        storyLore6.setY(storyFrame6.getY() - UIHelpers.calcHeightProportion(this.game, 2.0f, 1.0f).floatValue() - storyLore6.getHeight());
        this.stage.addActor(storyLore6);
        SequenceAction storyLore6Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyLore6.addAction(storyLore6Action);
        Label sound = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.sound"), this.game.uiSkin, "combat");
        sound.setAlignment(1);
        sound.setColor(this.game.uiSkin.get("lightiron", Color.class));
        sound.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(sound, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        sound.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - sound.getWidth() / 2.0f);
        sound.setY(UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue() - sound.getPrefHeight() - this.game.viewHeight.floatValue() * 4.0f);
        this.stage.addActor(sound);
        SequenceAction soundAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        sound.addAction(soundAction);
        Label soundNames = new Label("Om", this.game.uiSkin, "default");
        soundNames.setAlignment(1);
        soundNames.setColor(this.game.uiSkin.get("silver", Color.class));
        soundNames.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue() / 2.0f);
        UIHelpers.fixLabelFontSize(soundNames, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue(), 0.0f);
        soundNames.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - soundNames.getWidth() / 2.0f);
        soundNames.setY(UIHelpers.calcHeightProportion(this.game, 85.0f, 85.0f).floatValue() - soundNames.getPrefHeight() - this.game.viewHeight.floatValue() * 4.0f);
        this.stage.addActor(soundNames);
        SequenceAction soundNamesAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        soundNames.addAction(soundNamesAction);
        BaseActor storyImage7 = new BaseActor();
        storyImage7.setTexture(this.game.manager.get(!this.end ? this.game.getOverridenAsset("data/backgrounds/storyCred7.jpg") : this.game.getOverridenAsset("data/backgrounds/storyLore7.jpg"), Texture.class), UIHelpers.calcWidthProportion(this.game, 38.0f, 38.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 19.0f, 19.0f).floatValue());
        this.backgroundImages.add(!this.end ? "data/backgrounds/storyCred7.jpg" : "data/backgrounds/storyLore7.jpg");
        storyImage7.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyImage7.getWidth() / 2.0f);
        storyImage7.setY(UIHelpers.calcHeightProportion(this.game, 99.5f, 74.5f).floatValue() - storyImage7.getHeight() - this.game.viewHeight.floatValue() * 4.0f);
        this.stage.addActor(storyImage7);
        SequenceAction storyImage7Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyImage7.addAction(storyImage7Action);
        BaseActor storyFrame7 = new BaseActor();
        storyFrame7.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/storyFrame.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 40.0f, 40.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        storyFrame7.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyFrame7.getWidth() / 2.0f);
        storyFrame7.setY(UIHelpers.calcHeightProportion(this.game, 100.0f, 75.0f).floatValue() - storyFrame7.getHeight() - this.game.viewHeight.floatValue() * 4.0f);
        this.stage.addActor(storyFrame7);
        SequenceAction storyFrame7Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyFrame7.addAction(storyFrame7Action);
        Label storyLore7 = new Label(!this.end ? "" : PropertiesReader.getMessage(this.game.gameMessages, "game.credits.lore7"), this.game.uiSkin, "default");
        storyLore7.setAlignment(2);
        storyLore7.setWrap(true);
        storyLore7.setWidth(UIHelpers.calcWidthProportion(this.game, 36.0f, 56.0f).floatValue());
        storyLore7.setColor(this.game.uiSkin.get("silver", Color.class));
        storyLore7.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(storyLore7, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, UIHelpers.calcWidthProportion(this.game, 20.0f, 12.0f).floatValue());
        storyLore7.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyLore7.getWidth() / 2.0f);
        storyLore7.setY(storyFrame7.getY() - UIHelpers.calcHeightProportion(this.game, 2.0f, 1.0f).floatValue() - storyLore7.getHeight());
        this.stage.addActor(storyLore7);
        SequenceAction storyLore7Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyLore7.addAction(storyLore7Action);
        Label testing = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.testing"), this.game.uiSkin, "combat");
        testing.setAlignment(1);
        testing.setColor(this.game.uiSkin.get("lightiron", Color.class));
        testing.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(testing, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        testing.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - testing.getWidth() / 2.0f);
        testing.setY(UIHelpers.calcHeightProportion(this.game, 95.0f, 95.0f).floatValue() - testing.getPrefHeight() - this.game.viewHeight.floatValue() * 9.0f / 2.0f);
        this.stage.addActor(testing);
        SequenceAction testingAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        testing.addAction(testingAction);
        Label testingNames = new Label("Om\nOmar Fern\u00e1ndez Varea\nAnna Mart\u00ednez Casals", this.game.uiSkin, "default");
        testingNames.setAlignment(1);
        testingNames.setColor(this.game.uiSkin.get("silver", Color.class));
        testingNames.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue() / 2.0f);
        UIHelpers.fixLabelFontSize(testingNames, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue(), 0.0f);
        testingNames.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - testingNames.getWidth() / 2.0f);
        testingNames.setY(UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue() - testingNames.getPrefHeight() - this.game.viewHeight.floatValue() * 9.0f / 2.0f);
        this.stage.addActor(testingNames);
        SequenceAction testingNamesAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        testingNames.addAction(testingNamesAction);
        BaseActor storyImage8 = new BaseActor();
        storyImage8.setTexture(this.game.manager.get(!this.end ? this.game.getOverridenAsset("data/backgrounds/storyCred8.jpg") : this.game.getOverridenAsset("data/backgrounds/storyLore8.jpg"), Texture.class), UIHelpers.calcWidthProportion(this.game, 38.0f, 38.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 19.0f, 19.0f).floatValue());
        this.backgroundImages.add(!this.end ? "data/backgrounds/storyCred8.jpg" : "data/backgrounds/storyLore8.jpg");
        storyImage8.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyImage8.getWidth() / 2.0f);
        storyImage8.setY(UIHelpers.calcHeightProportion(this.game, 99.5f, 74.5f).floatValue() - storyImage8.getHeight() - this.game.viewHeight.floatValue() * 9.0f / 2.0f);
        this.stage.addActor(storyImage8);
        SequenceAction storyImage8Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyImage8.addAction(storyImage8Action);
        BaseActor storyFrame8 = new BaseActor();
        storyFrame8.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/storyFrame.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 40.0f, 40.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        storyFrame8.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyFrame8.getWidth() / 2.0f);
        storyFrame8.setY(UIHelpers.calcHeightProportion(this.game, 100.0f, 75.0f).floatValue() - storyFrame8.getHeight() - this.game.viewHeight.floatValue() * 9.0f / 2.0f);
        this.stage.addActor(storyFrame8);
        SequenceAction storyFrame8Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyFrame8.addAction(storyFrame8Action);
        Label storyLore8 = new Label(!this.end ? "" : PropertiesReader.getMessage(this.game.gameMessages, "game.credits.lore8"), this.game.uiSkin, "default");
        storyLore8.setAlignment(2);
        storyLore8.setWrap(true);
        storyLore8.setWidth(UIHelpers.calcWidthProportion(this.game, 36.0f, 56.0f).floatValue());
        storyLore8.setColor(this.game.uiSkin.get("silver", Color.class));
        storyLore8.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(storyLore8, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, UIHelpers.calcWidthProportion(this.game, 20.0f, 12.0f).floatValue());
        storyLore8.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyLore8.getWidth() / 2.0f);
        storyLore8.setY(storyFrame8.getY() - UIHelpers.calcHeightProportion(this.game, 2.0f, 1.0f).floatValue() - storyLore8.getHeight());
        this.stage.addActor(storyLore8);
        SequenceAction storyLore8Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyLore8.addAction(storyLore8Action);
        Label special = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.special"), this.game.uiSkin, "combat");
        special.setAlignment(1);
        special.setColor(this.game.uiSkin.get("lightiron", Color.class));
        special.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(special, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        special.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - special.getWidth() / 2.0f);
        special.setY(UIHelpers.calcHeightProportion(this.game, 97.5f, 97.5f).floatValue() - special.getPrefHeight() - this.game.viewHeight.floatValue() * 5.0f);
        this.stage.addActor(special);
        SequenceAction specialAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        special.addAction(specialAction);
        Label specialNames = new Label("Anna Mart\u00ednez Casals\nJoan Garc\u00eda Esquerdo\nCarlos Jim\u00e9nez Leal\nIrene Estrada Carreres", this.game.uiSkin, "default");
        specialNames.setAlignment(1);
        specialNames.setColor(this.game.uiSkin.get("silver", Color.class));
        specialNames.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue() / 2.0f);
        UIHelpers.fixLabelFontSize(specialNames, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 80.0f, 80.0f).floatValue(), 0.0f);
        specialNames.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - specialNames.getWidth() / 2.0f);
        specialNames.setY(UIHelpers.calcHeightProportion(this.game, 92.5f, 92.5f).floatValue() - specialNames.getPrefHeight() - this.game.viewHeight.floatValue() * 5.0f);
        this.stage.addActor(specialNames);
        SequenceAction specialNamesAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        specialNames.addAction(specialNamesAction);
        BaseActor storyImage9 = new BaseActor();
        storyImage9.setTexture(this.game.manager.get(!this.end ? this.game.getOverridenAsset("data/backgrounds/storyCred9.jpg") : (this.game.violenceFilter ? this.game.getOverridenAsset("data/backgrounds/storyLore9nv.jpg") : this.game.getOverridenAsset("data/backgrounds/storyLore9.jpg")), Texture.class), UIHelpers.calcWidthProportion(this.game, 38.0f, 38.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 19.0f, 19.0f).floatValue());
        if (!this.end) {
            this.backgroundImages.add("data/backgrounds/storyCred9.jpg");
        } else {
            this.backgroundImages.add("data/backgrounds/storyLore9.jpg");
            this.backgroundImages.add("data/backgrounds/storyLore9nv.jpg");
        }
        storyImage9.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyImage9.getWidth() / 2.0f);
        storyImage9.setY(UIHelpers.calcHeightProportion(this.game, 99.5f, 74.5f).floatValue() - storyImage9.getHeight() - this.game.viewHeight.floatValue() * 5.0f);
        this.stage.addActor(storyImage9);
        SequenceAction storyImage9Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyImage9.addAction(storyImage9Action);
        BaseActor storyFrame9 = new BaseActor();
        storyFrame9.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/storyFrame.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 40.0f, 40.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        storyFrame9.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyFrame9.getWidth() / 2.0f);
        storyFrame9.setY(UIHelpers.calcHeightProportion(this.game, 100.0f, 75.0f).floatValue() - storyFrame9.getHeight() - this.game.viewHeight.floatValue() * 5.0f);
        this.stage.addActor(storyFrame9);
        SequenceAction storyFrame9Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyFrame9.addAction(storyFrame9Action);
        Label storyLore9 = new Label(!this.end ? "" : PropertiesReader.getMessage(this.game.gameMessages, "game.credits.lore9"), this.game.uiSkin, "default");
        storyLore9.setAlignment(2);
        storyLore9.setWrap(true);
        storyLore9.setWidth(UIHelpers.calcWidthProportion(this.game, 36.0f, 56.0f).floatValue());
        storyLore9.setColor(this.game.uiSkin.get("silver", Color.class));
        storyLore9.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(storyLore9, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, UIHelpers.calcWidthProportion(this.game, 20.0f, 12.0f).floatValue());
        storyLore9.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - storyLore9.getWidth() / 2.0f);
        storyLore9.setY(storyFrame9.getY() - UIHelpers.calcHeightProportion(this.game, 2.0f, 1.0f).floatValue() - storyLore9.getHeight());
        this.stage.addActor(storyLore9);
        SequenceAction storyLore9Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyLore9.addAction(storyLore9Action);
        Label acknowledgements = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.acknowledgments"), this.game.uiSkin, "combat");
        acknowledgements.setAlignment(1);
        acknowledgements.setColor(this.game.uiSkin.get("lightiron", Color.class));
        acknowledgements.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(acknowledgements, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        acknowledgements.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - acknowledgements.getWidth() / 2.0f);
        acknowledgements.setY(UIHelpers.calcHeightProportion(this.game, 90.0f, 90.0f).floatValue() - acknowledgements.getPrefHeight() - this.game.viewHeight.floatValue() * 11.0f / 2.0f);
        this.stage.addActor(acknowledgements);
        SequenceAction acknowledgementsAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        acknowledgements.addAction(acknowledgementsAction);
        Label acknowledgementsNames = new Label("LibGDX framework", this.game.uiSkin, "default");
        acknowledgementsNames.setWrap(true);
        acknowledgementsNames.setAlignment(1);
        acknowledgementsNames.setColor(this.game.uiSkin.get("silver", Color.class));
        acknowledgementsNames.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue() / 2.0f);
        UIHelpers.fixLabelFontSize(acknowledgementsNames, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        acknowledgementsNames.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 50.0f).floatValue() - acknowledgementsNames.getWidth() / 2.0f);
        acknowledgementsNames.setY(UIHelpers.calcHeightProportion(this.game, 85.0f, 85.0f).floatValue() - acknowledgementsNames.getPrefHeight() - this.game.viewHeight.floatValue() * 11.0f / 2.0f);
        this.stage.addActor(acknowledgementsNames);
        SequenceAction acknowledgementsNamesAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        acknowledgementsNames.addAction(acknowledgementsNamesAction);
        BaseActor storyImage10 = new BaseActor();
        storyImage10.setTexture(this.game.manager.get(!this.end ? this.game.getOverridenAsset("data/backgrounds/storyCred10.jpg") : this.game.getOverridenAsset("data/backgrounds/storyLore10.jpg"), Texture.class), UIHelpers.calcWidthProportion(this.game, 38.0f, 38.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 19.0f, 19.0f).floatValue());
        this.backgroundImages.add(!this.end ? "data/backgrounds/storyCred10.jpg" : "data/backgrounds/storyLore10.jpg");
        storyImage10.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyImage10.getWidth() / 2.0f);
        storyImage10.setY(UIHelpers.calcHeightProportion(this.game, 99.5f, 74.5f).floatValue() - storyImage10.getHeight() - this.game.viewHeight.floatValue() * 11.0f / 2.0f);
        this.stage.addActor(storyImage10);
        SequenceAction storyImage10Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyImage10.addAction(storyImage10Action);
        BaseActor storyFrame10 = new BaseActor();
        storyFrame10.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/storyFrame.png"), Texture.class), UIHelpers.calcWidthProportion(this.game, 40.0f, 40.0f).floatValue(), UIHelpers.calcWidthProportion(this.game, 20.0f, 20.0f).floatValue());
        storyFrame10.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyFrame10.getWidth() / 2.0f);
        storyFrame10.setY(UIHelpers.calcHeightProportion(this.game, 100.0f, 75.0f).floatValue() - storyFrame10.getHeight() - this.game.viewHeight.floatValue() * 11.0f / 2.0f);
        this.stage.addActor(storyFrame10);
        SequenceAction storyFrame10Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyFrame10.addAction(storyFrame10Action);
        Label storyLore10 = new Label(!this.end ? "" : PropertiesReader.getMessage(this.game.gameMessages, "game.credits.lore10"), this.game.uiSkin, "default");
        storyLore10.setAlignment(2);
        storyLore10.setWrap(true);
        storyLore10.setWidth(UIHelpers.calcWidthProportion(this.game, 36.0f, 56.0f).floatValue());
        storyLore10.setColor(this.game.uiSkin.get("silver", Color.class));
        storyLore10.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(storyLore10, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), 0.0f, UIHelpers.calcWidthProportion(this.game, 20.0f, 12.0f).floatValue());
        storyLore10.setX(UIHelpers.calcWidthProportion(this.game, 75.0f, 50.0f).floatValue() - storyLore10.getWidth() / 2.0f);
        storyLore10.setY(storyFrame10.getY() - UIHelpers.calcHeightProportion(this.game, 2.0f, 1.0f).floatValue() - storyLore10.getHeight());
        this.stage.addActor(storyLore10);
        SequenceAction storyLore10Action = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        storyLore10.addAction(storyLore10Action);
        Label thanks = new Label(PropertiesReader.getMessage(this.game.gameMessages, "game.credits.thanks"), this.game.uiSkin, "combat");
        thanks.setAlignment(1);
        thanks.setColor(this.game.uiSkin.get("lightiron", Color.class));
        thanks.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        UIHelpers.fixLabelFontSize(thanks, this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue(), UIHelpers.calcWidthProportion(this.game, 60.0f, 60.0f).floatValue(), 0.0f);
        thanks.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - thanks.getWidth() / 2.0f);
        thanks.setY(UIHelpers.calcHeightProportion(this.game, 60.0f, 60.0f).floatValue() - thanks.getPrefHeight() - this.game.viewHeight.floatValue() * 6.0f);
        this.stage.addActor(thanks);
        SequenceAction thanksAction = Actions.sequence((Action)Actions.delay(8.5f), (Action)Actions.delay(2.0f), (Action)Actions.moveBy(0.0f, this.game.viewHeight.floatValue() * 6.0f, 170.0f));
        thanks.addAction(thanksAction);
        this.addFadeOverlay(Float.valueOf(1.0f));
    }

    @Override
    public void render(float delta) {
        this.stage.act(delta);
        this.elapsedTime += delta;
        if (this.elapsedTime > 190.0f) {
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
            this.dispose();
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public void dispose() {
        for (String currImage : this.backgroundImages) {
            this.game.manager.unload(this.game.getOverridenAsset(currImage));
        }
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4) {
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
            this.dispose();
        }
        return false;
    }
}

