/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Story;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.util.StringList;
import java.util.ArrayList;

public class ColiseumScreen
extends BaseScreen {
    public Float elapsedTime = Float.valueOf(0.0f);
    public Button nextButton;
    StringBuilder houses = new StringBuilder();
    ArrayList<BaseActor> portraits = new ArrayList();
    ArrayList<BaseActor> portraitsFrame = new ArrayList();
    ArrayList<BaseActor> portraitsBorder = new ArrayList();
    String enemies = "";
    String player = "";
    String promotion = "";
    float borderSpace = UIHelpers.calcHeightProportion(this.game, 0.8f, 0.8f).floatValue();

    public ColiseumScreen(SlavePitsGame g, String selectedEnemies, String selectedPlayer, String selectedPromotion) {
        super(g);
        this.enemies = selectedEnemies;
        this.player = selectedPlayer;
        this.promotion = selectedPromotion;
        this.create();
    }

    @Override
    public void create() {
        int i;
        if (this.game.track != null && this.game.track.isPlaying()) {
            this.game.track.stop();
            this.game.track.dispose();
        }
        BaseActor background = new BaseActor();
        UIHelpers.portraitModeFixBackground(this.game, background, this.game.getOverridenFilename("data/backgrounds/backgroundColiseum.jpg"), this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), 0.0f, 0.0f);
        this.stage.addActor(background);
        TextureAtlas portraitsAtlas = this.game.manager.get(this.game.getOverridenAsset("data/portraits/portraits.atlas"), TextureAtlas.class);
        TextureAtlas uiAtlas = this.game.manager.get(this.game.getOverridenAsset("ui/uisl.atlas"), TextureAtlas.class);
        this.houses = new StringBuilder(this.game.saveGame.get("houses"));
        int fixPositions = Integer.parseInt(this.player) % 4;
        if (fixPositions > 0) {
            for (i = 0; i < fixPositions; ++i) {
                this.houses = StringList.set(this.houses, Integer.parseInt(this.player) - (fixPositions - i), StringList.get(this.houses, Integer.parseInt(this.player) - (fixPositions - i) + 1, "#"), "#");
            }
        }
        for (i = 0; i < StringList.size(this.houses, "#"); ++i) {
            BaseActor newLine;
            String currOpponent = StringList.get(this.houses, i, "#");
            JSONObject opponentData = (JSONObject)this.game.stats.get("opponents").get(currOpponent);
            String portrait = opponentData.getString("portrait");
            if (Integer.parseInt(this.player) == i) {
                portrait = "p00";
            }
            BaseActor newPortrait = new BaseActor();
            newPortrait.setTexture(portraitsAtlas.findRegion(portrait), UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue());
            this.portraits.add(newPortrait);
            BaseActor newPortraitFrame = new BaseActor();
            newPortraitFrame.setTexture(portraitsAtlas.findRegion("portraitframe"), UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue());
            this.portraitsFrame.add(newPortraitFrame);
            BaseActor newPortraitBorder = new BaseActor();
            newPortraitBorder.setTexture(this.game.uiSkin.getRegion("highlightframe"), UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue() + this.borderSpace, UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue() + this.borderSpace);
            newPortraitBorder.setColor(new Color(1.0f, 0.0f, 0.0f, 1.0f));
            newPortraitBorder.setVisible(false);
            this.portraitsBorder.add(newPortraitBorder);
            if (this.enemies.equalsIgnoreCase("" + i) || this.enemies.contains(i + ",") || this.enemies.contains("," + i) || this.player.equalsIgnoreCase("" + i)) {
                newPortraitBorder.setVisible(true);
            }
            if (i < 4) {
                newPortraitBorder.setPosition(UIHelpers.calcWidthProportion(this.game, 10.0f, 10.0f).floatValue() - this.borderSpace / 2.0f, UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue() + (float)i * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() - this.borderSpace / 2.0f);
                newPortrait.setPosition(UIHelpers.calcWidthProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue() + (float)i * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
                newPortraitFrame.setPosition(UIHelpers.calcWidthProportion(this.game, 10.0f, 10.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue() + (float)i * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
                if (i < 3) {
                    newLine = new BaseActor();
                    newLine.setTexture(uiAtlas.findRegion("white"), UIHelpers.calcHeightProportion(this.game, 0.5f, 0.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
                    newLine.setColor(new Color(0.0f, 0.0f, 0.0f, 1.0f));
                    newLine.setPosition(UIHelpers.calcWidthProportion(this.game, 10.0f, 10.0f).floatValue() + UIHelpers.calcHeightProportion(this.game, 7.5f, 7.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 30.0f, 30.0f).floatValue() + (float)i * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
                    this.stage.addActor(newLine);
                }
            } else if (i < 8) {
                newPortraitBorder.setPosition(UIHelpers.calcWidthProportion(this.game, 75.0f, 75.0f).floatValue() - this.borderSpace / 2.0f, UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue() + (float)(i - 4) * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() - this.borderSpace / 2.0f);
                newPortrait.setPosition(UIHelpers.calcWidthProportion(this.game, 75.0f, 75.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue() + (float)(i - 4) * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
                newPortraitFrame.setPosition(UIHelpers.calcWidthProportion(this.game, 75.0f, 75.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 15.0f, 15.0f).floatValue() + (float)(i - 4) * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
                if (i < 7) {
                    newLine = new BaseActor();
                    newLine.setTexture(uiAtlas.findRegion("white"), UIHelpers.calcHeightProportion(this.game, 0.5f, 0.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
                    newLine.setColor(new Color(0.0f, 0.0f, 0.0f, 1.0f));
                    newLine.setPosition(UIHelpers.calcWidthProportion(this.game, 75.0f, 75.0f).floatValue() + UIHelpers.calcHeightProportion(this.game, 7.5f, 7.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 30.0f, 30.0f).floatValue() + (float)(i - 4) * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
                    this.stage.addActor(newLine);
                }
            } else {
                newPortraitBorder.setPosition(UIHelpers.calcWidthProportion(this.game, 42.5f, 42.5f).floatValue() - this.borderSpace / 2.0f, UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() + (float)(i - 8) * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() - this.borderSpace / 2.0f);
                newPortrait.setPosition(UIHelpers.calcWidthProportion(this.game, 42.5f, 42.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() + (float)(i - 8) * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
                newPortraitFrame.setPosition(UIHelpers.calcWidthProportion(this.game, 42.5f, 42.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue() + (float)(i - 8) * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
                if (i < 11) {
                    newLine = new BaseActor();
                    newLine.setTexture(uiAtlas.findRegion("white"), UIHelpers.calcHeightProportion(this.game, 0.5f, 0.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 5.0f, 5.0f).floatValue());
                    newLine.setColor(new Color(0.0f, 0.0f, 0.0f, 1.0f));
                    newLine.setPosition(UIHelpers.calcWidthProportion(this.game, 42.5f, 42.5f).floatValue() + UIHelpers.calcHeightProportion(this.game, 7.5f, 7.5f).floatValue(), UIHelpers.calcHeightProportion(this.game, 35.0f, 35.0f).floatValue() + (float)(i - 8) * UIHelpers.calcHeightProportion(this.game, 20.0f, 20.0f).floatValue());
                    this.stage.addActor(newLine);
                }
            }
            this.stage.addActor(newPortraitBorder);
            this.stage.addActor(newPortrait);
            this.stage.addActor(newPortraitFrame);
        }
        this.nextButton = new Button(this.game.uiSkin, "next");
        this.nextButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        this.nextButton.setHeight(this.nextButton.getWidth());
        this.nextButton.setX(this.game.viewWidth.floatValue() - this.nextButton.getWidth() - 10.0f);
        this.nextButton.setY(10.0f);
        this.nextButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                ColiseumScreen.this.game.manager.get(ColiseumScreen.this.game.getOverridenAsset("sound/ambientcoliseumCrowd.ogg"), Sound.class).stop();
                Story.getNextScreen(ColiseumScreen.this.game, "ranking", "");
            }
        });
        this.nextButton.setVisible(false);
        SequenceAction showDelayed = Actions.sequence((Action)Actions.delay(3.0f), (Action)Actions.show());
        this.nextButton.addAction(showDelayed);
        this.stage.addActor(this.nextButton);
        this.addFadeOverlay(Float.valueOf(1.0f));
    }

    @Override
    public void render(float delta) {
        this.stage.act(delta);
        if (this.elapsedTime.floatValue() == 0.0f) {
            this.game.manager.get(this.game.getOverridenAsset("sound/ambientcoliseumCrowd.ogg"), Sound.class).loop(this.game.soundVolume);
            if (!this.promotion.equalsIgnoreCase("")) {
                SequenceAction movePortrait1 = Actions.sequence((Action)Actions.delay(0.5f), (Action)Actions.moveTo(this.portraits.get(Integer.parseInt(this.promotion)).getX(), this.portraits.get(Integer.parseInt(this.promotion)).getY(), 2.0f));
                this.portraits.get(Integer.parseInt(this.player)).addAction(movePortrait1);
                SequenceAction movePortrait2 = Actions.sequence((Action)Actions.delay(0.5f), (Action)Actions.moveTo(this.portraitsFrame.get(Integer.parseInt(this.promotion)).getX(), this.portraitsFrame.get(Integer.parseInt(this.promotion)).getY(), 2.0f));
                this.portraitsFrame.get(Integer.parseInt(this.player)).addAction(movePortrait2);
                SequenceAction movePortrait3 = Actions.sequence((Action)Actions.delay(0.5f), (Action)Actions.moveTo(this.portraitsBorder.get(Integer.parseInt(this.promotion)).getX(), this.portraitsBorder.get(Integer.parseInt(this.promotion)).getY(), 2.0f));
                this.portraitsBorder.get(Integer.parseInt(this.player)).addAction(movePortrait3);
                SequenceAction movePortrait4 = Actions.sequence((Action)Actions.delay(0.5f), (Action)Actions.moveTo(this.portraits.get(Integer.parseInt(this.player)).getX(), this.portraits.get(Integer.parseInt(this.player)).getY(), 2.0f));
                this.portraits.get(Integer.parseInt(this.promotion)).addAction(movePortrait4);
                SequenceAction movePortrait5 = Actions.sequence((Action)Actions.delay(0.5f), (Action)Actions.moveTo(this.portraitsFrame.get(Integer.parseInt(this.player)).getX(), this.portraitsFrame.get(Integer.parseInt(this.player)).getY(), 2.0f));
                this.portraitsFrame.get(Integer.parseInt(this.promotion)).addAction(movePortrait5);
                SequenceAction movePortrait6 = Actions.sequence((Action)Actions.delay(0.5f), (Action)Actions.moveTo(this.portraitsBorder.get(Integer.parseInt(this.player)).getX(), this.portraitsBorder.get(Integer.parseInt(this.player)).getY(), 2.0f));
                this.portraitsBorder.get(Integer.parseInt(this.promotion)).addAction(movePortrait6);
            }
        }
        this.elapsedTime = Float.valueOf(this.elapsedTime.floatValue() + delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public void dispose() {
        this.game.manager.get(this.game.getOverridenAsset("sound/ambientcoliseumCrowd.ogg"), Sound.class).stop();
        UIHelpers.portraitModeFixBackgroundDispose(this.game, this.game.getOverridenAsset("data/backgrounds/backgroundColiseum.jpg"));
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4) {
            this.game.manager.get(this.game.getOverridenAsset("sound/ambientcoliseumCrowd.ogg"), Sound.class).stop();
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
        } else if (keycode == Input.Keys.valueOf(this.game.nextkey) && this.nextButton != null && this.nextButton.isVisible()) {
            InputEvent event = new InputEvent();
            event.setType(InputEvent.Type.touchUp);
            this.nextButton.fire(event);
            return true;
        }
        return false;
    }
}

