/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.BaseActor;
import com.calimasaga.slavepits.util.Logger;
import java.util.HashMap;

public class BaseScreen
implements Screen,
InputProcessor {
    protected SlavePitsGame game;
    protected Stage stage;
    protected InputMultiplexer im;
    protected BaseActor fadeOverlay;
    public HashMap<BaseActor, String> highlights;

    public BaseScreen(SlavePitsGame g) {
        this.game = g;
        OrthographicCamera cam = new OrthographicCamera(this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue());
        this.stage = new Stage(new FitViewport(this.game.viewWidth.floatValue(), this.game.viewHeight.floatValue(), cam));
        this.im = new InputMultiplexer(this, this.stage);
        Gdx.input.setInputProcessor(this.im);
        this.highlights = new HashMap();
        Logger.write(Logger.DEBUG, "Memory used: " + Gdx.app.getJavaHeap());
    }

    public void create() {
    }

    public void update(float dt) {
    }

    @Override
    public void render(float delta) {
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    public void receivedPacket(String content) {
    }

    public void receivedHttpResponse(Net.HttpResponse httpResponse) {
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.im);
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    public void addFadeOverlay(Float alpha) {
        this.fadeOverlay = new BaseActor();
        this.fadeOverlay.setTexture(this.game.manager.get(this.game.getOverridenAsset("data/backgrounds/overlay.png"), Texture.class), (float)this.game.viewWidth.intValue(), (float)this.game.viewHeight.intValue());
        this.fadeOverlay.setColor(0.0f, 0.0f, 0.0f, alpha.floatValue());
        this.fadeOverlay.setPosition(0.0f, 0.0f);
        this.fadeOverlay.setVisible(false);
        this.fadeOverlay.setTouchable(Touchable.disabled);
        this.stage.addActor(this.fadeOverlay);
    }

    public void doFade(String fadeMode, Float duration) {
        this.fadeOverlay.toFront();
        if (fadeMode.equalsIgnoreCase("in")) {
            this.fadeOverlay.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            SequenceAction fading = Actions.sequence((Action)Actions.show(), (Action)Actions.fadeOut(duration.floatValue()), (Action)Actions.delay(0.1f), (Action)Actions.hide());
            this.fadeOverlay.addAction(fading);
        } else if (fadeMode.equalsIgnoreCase("out")) {
            this.fadeOverlay.setColor(0.0f, 0.0f, 0.0f, 0.0f);
            SequenceAction fading = Actions.sequence((Action)Actions.show(), (Action)Actions.fadeIn(duration.floatValue()), (Action)Actions.delay(0.1f), (Action)Actions.hide());
            this.fadeOverlay.addAction(fading);
        }
    }
}

