/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.TextFieldFontScaling;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.util.PropertiesReader;

public class ActivationScreen
extends BaseScreen {
    public float tsp = 40.0f;
    public float sp = 5.0f;
    private TextFieldFontScaling emailInput;
    private TextFieldFontScaling keyInput;
    private Label infoLabel;

    public ActivationScreen(SlavePitsGame g) {
        super(g);
        this.create();
    }

    @Override
    public void create() {
        Label emailLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "system.mail") + ":", this.game.uiSkin, "default");
        emailLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        emailLabel.setX(UIHelpers.calcWidthProportion(this.game, 44.65f, 44.65f).floatValue() - emailLabel.getPrefWidth());
        emailLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp, 100.0f - this.tsp).floatValue() - emailLabel.getHeight() / 2.0f);
        this.stage.addActor(emailLabel);
        this.emailInput = UIHelpers.createTextField(this.game, UIHelpers.calcHeightProportion(this.game, 32.0f, 32.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.emailInput.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent e, float x, float y) {
                ActivationScreen.this.infoLabel.setText(PropertiesReader.getMessage(ActivationScreen.this.game.gameMessages, "system.mail.description"));
                ActivationScreen.this.infoLabel.setColor(ActivationScreen.this.game.uiSkin.get("iron", Color.class));
                ActivationScreen.this.infoLabel.setX(UIHelpers.calcWidthProportion(ActivationScreen.this.game, 50.0f, 50.0f).floatValue() - ActivationScreen.this.infoLabel.getPrefWidth() / 2.0f);
                ActivationScreen.this.infoLabel.setY(UIHelpers.calcHeightProportion(ActivationScreen.this.game, 100.0f - ActivationScreen.this.tsp - ActivationScreen.this.sp * 3.0f, 100.0f - ActivationScreen.this.tsp - ActivationScreen.this.sp * 3.0f).floatValue() - ActivationScreen.this.infoLabel.getHeight() / 2.0f);
            }
        });
        this.emailInput.setWidth(this.emailInput.getPrefWidth());
        this.emailInput.setX(UIHelpers.calcWidthProportion(this.game, 45.35f, 45.35f).floatValue());
        this.emailInput.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp, 100.0f - this.tsp).floatValue() - this.emailInput.getHeight() / 2.0f);
        this.stage.addActor(this.emailInput);
        this.stage.setKeyboardFocus(this.emailInput);
        Label keyLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "system.key") + ":", this.game.uiSkin, "default");
        keyLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        keyLabel.setX(UIHelpers.calcWidthProportion(this.game, 44.65f, 44.65f).floatValue() - keyLabel.getPrefWidth());
        keyLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp, 100.0f - this.tsp - this.sp).floatValue() - keyLabel.getHeight() / 2.0f);
        this.stage.addActor(keyLabel);
        this.keyInput = UIHelpers.createTextField(this.game, UIHelpers.calcHeightProportion(this.game, 32.0f, 32.0f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.keyInput.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent e, float x, float y) {
                ActivationScreen.this.infoLabel.setText(PropertiesReader.getMessage(ActivationScreen.this.game.gameMessages, "system.key.description"));
                ActivationScreen.this.infoLabel.setColor(ActivationScreen.this.game.uiSkin.get("iron", Color.class));
                ActivationScreen.this.infoLabel.setX(UIHelpers.calcWidthProportion(ActivationScreen.this.game, 50.0f, 50.0f).floatValue() - ActivationScreen.this.infoLabel.getPrefWidth() / 2.0f);
                ActivationScreen.this.infoLabel.setY(UIHelpers.calcHeightProportion(ActivationScreen.this.game, 100.0f - ActivationScreen.this.tsp - ActivationScreen.this.sp * 3.0f, 100.0f - ActivationScreen.this.tsp - ActivationScreen.this.sp * 3.0f).floatValue() - ActivationScreen.this.infoLabel.getHeight() / 2.0f);
            }
        });
        this.keyInput.setWidth(this.keyInput.getPrefWidth());
        this.keyInput.setX(UIHelpers.calcWidthProportion(this.game, 45.35f, 45.35f).floatValue());
        this.keyInput.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp, 100.0f - this.tsp - this.sp).floatValue() - this.keyInput.getHeight() / 2.0f);
        this.stage.addActor(this.keyInput);
        this.infoLabel = new Label("", this.game.uiSkin, "default");
        this.infoLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.infoLabel.setX(UIHelpers.calcWidthProportion(this.game, 50.0f, 50.0f).floatValue() - this.infoLabel.getPrefWidth() / 2.0f);
        this.infoLabel.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 3.0f, 100.0f - this.tsp - this.sp * 3.0f).floatValue() - this.infoLabel.getHeight() / 2.0f);
        this.stage.addActor(this.infoLabel);
        TextButton applyButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "system.validate"), this.game.uiSkin, "base");
        applyButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                String mailFormatted = ActivationScreen.this.emailInput.getText().trim();
                String keyFormmated = ActivationScreen.this.keyInput.getText().trim();
                boolean error = false;
                if (keyFormmated.equalsIgnoreCase("") || PropertiesReader.verifyKey(mailFormatted, keyFormmated, 0L).equalsIgnoreCase("free")) {
                    ActivationScreen.this.infoLabel.setText(PropertiesReader.getMessage(ActivationScreen.this.game.gameMessages, "system.key.error"));
                    error = true;
                }
                if (mailFormatted.equalsIgnoreCase("") || !PropertiesReader.verifyMail(mailFormatted)) {
                    ActivationScreen.this.infoLabel.setText(PropertiesReader.getMessage(ActivationScreen.this.game.gameMessages, "system.mail.error"));
                    error = true;
                }
                ActivationScreen.this.infoLabel.setX(UIHelpers.calcWidthProportion(ActivationScreen.this.game, 50.0f, 50.0f).floatValue() - ActivationScreen.this.infoLabel.getPrefWidth() / 2.0f);
                if (error) {
                    ActivationScreen.this.infoLabel.setColor(Color.RED);
                    ActivationScreen.this.infoLabel.setX(UIHelpers.calcWidthProportion(ActivationScreen.this.game, 50.0f, 50.0f).floatValue() - ActivationScreen.this.infoLabel.getPrefWidth() / 2.0f);
                    ActivationScreen.this.infoLabel.setY(UIHelpers.calcHeightProportion(ActivationScreen.this.game, 100.0f - ActivationScreen.this.tsp - ActivationScreen.this.sp * 3.0f, 100.0f - ActivationScreen.this.tsp - ActivationScreen.this.sp * 3.0f).floatValue() - ActivationScreen.this.infoLabel.getHeight() / 2.0f);
                } else {
                    String saveData = PropertiesReader.readSaveDataRaw(ActivationScreen.this.game.key, ActivationScreen.this.game.mail, false);
                    PropertiesReader.writeSaveDataRaw(mailFormatted, keyFormmated, saveData, false);
                    PropertiesReader.setMailKeyPair(mailFormatted, keyFormmated);
                    ActivationScreen.this.game.key = keyFormmated;
                    ActivationScreen.this.game.mail = mailFormatted;
                    ActivationScreen.this.game.settings.setProperty("checksum", "" + PropertiesReader.calculateChecksum(ActivationScreen.this.game.mail, ActivationScreen.this.game.key));
                    PropertiesReader.saveSettings(ActivationScreen.this.game.settings);
                    ActivationScreen.this.game.mainMenuScreen = new MainMenuScreen(ActivationScreen.this.game);
                    ActivationScreen.this.game.setScreen(ActivationScreen.this.game.mainMenuScreen);
                    ActivationScreen.this.dispose();
                }
            }
        });
        applyButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        applyButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        applyButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), applyButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        applyButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        applyButton.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - applyButton.getPrefWidth());
        applyButton.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 5.0f, 100.0f - this.tsp - this.sp * 5.0f).floatValue() - applyButton.getPrefHeight() / 2.0f);
        this.stage.addActor(applyButton);
        TextButton exitButton = new TextButton(PropertiesReader.getMessage(this.game.gameMessages, "common.exit"), this.game.uiSkin, "base");
        exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                ActivationScreen.this.game.mainMenuScreen = new MainMenuScreen(ActivationScreen.this.game);
                ActivationScreen.this.game.setScreen(ActivationScreen.this.game.mainMenuScreen);
                ActivationScreen.this.dispose();
            }
        });
        exitButton.getLabel().setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 3.0f / 4.0f));
        exitButton.getLabelCell().padLeft(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f)).padRight(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() / 10.0f));
        exitButton.setWidth(MathUtils.clamp(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue(), exitButton.getPrefWidth(), this.game.viewHeight.floatValue()));
        exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        exitButton.setY(UIHelpers.calcHeightProportion(this.game, 100.0f - this.tsp - this.sp * 5.0f, 100.0f - this.tsp - this.sp * 5.0f).floatValue() - exitButton.getPrefHeight() / 2.0f);
        this.stage.addActor(exitButton);
    }

    @Override
    public void render(float delta) {
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 131 || keycode == 4 || keycode == 82) {
            this.game.mainMenuScreen = new MainMenuScreen(this.game);
            this.game.setScreen(this.game.mainMenuScreen);
            this.dispose();
        }
        return false;
    }
}

