/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.SelectBoxFontScaling;
import com.calimasaga.slavepits.actor.TextFieldFontScaling;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.screen.BaseScreen;
import com.calimasaga.slavepits.screen.DuelSetupScreen;
import com.calimasaga.slavepits.screen.PrepSetupScreen;
import com.calimasaga.slavepits.screen.TournamentSetupScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.ArrayList;

public class AIMenuScreen
extends BaseScreen {
    private BaseScreen previousScreen;
    private String behavior;
    private ArrayList<Actor> actorOrder = new ArrayList();
    private ArrayList<String> defenseValues = new ArrayList();
    private ArrayList<String> attackValues = new ArrayList();
    private ArrayList<String> useValues = new ArrayList();
    private SelectBoxFontScaling<String> defenseParam1Select;
    private TextFieldFontScaling defenseValueSelect;
    private SelectBoxFontScaling<String> attackParam1Select;
    private SelectBoxFontScaling<String> attackParam2Select;
    private SelectBoxFontScaling<String> attackParam3Select;
    private TextFieldFontScaling attackValueSelect;
    private SelectBoxFontScaling<String> useParam1Select;
    private SelectBoxFontScaling<String> useParam2Select;
    private SelectBoxFontScaling<String> useParam3Select;
    private TextFieldFontScaling useValueSelect;
    private Label attackLabel;
    private Label useLabel;
    private Label infoLabel;

    public AIMenuScreen(SlavePitsGame g, BaseScreen s, String currentBehavior) {
        super(g);
        this.previousScreen = s;
        this.behavior = currentBehavior;
        this.create();
    }

    @Override
    public void create() {
        Label defenseLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "common.defense") + ":", this.game.uiSkin, "default");
        defenseLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        defenseLabel.setX(UIHelpers.calcWidthProportion(this.game, 25.0f, 10.0f).floatValue());
        defenseLabel.setY(UIHelpers.calcHeightProportion(this.game, 97.0f, 97.0f).floatValue() - defenseLabel.getHeight() / 2.0f);
        this.stage.addActor(defenseLabel);
        this.actorOrder.add(defenseLabel);
        String defensePart = this.behavior.split("#")[0];
        this.defenseParam1Select = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String[] availableDefenses = new String[]{PropertiesReader.getMessage(this.game.gameMessages, "common.parry"), PropertiesReader.getMessage(this.game.gameMessages, "common.dodge")};
        this.defenseParam1Select.setItems((String[])availableDefenses);
        this.defenseParam1Select.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "common." + defensePart.substring(0, defensePart.indexOf(":"))));
        this.defenseParam1Select.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (((String)AIMenuScreen.this.defenseParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.parry"))) {
                    AIMenuScreen.this.defenseValues.set(0, "parry:" + AIMenuScreen.this.defenseValueSelect.getText());
                } else {
                    AIMenuScreen.this.defenseValues.set(0, "dodge:" + AIMenuScreen.this.defenseValueSelect.getText());
                }
            }
        });
        this.defenseParam1Select.setWidth(this.defenseParam1Select.getPrefWidth());
        this.defenseParam1Select.setX(defenseLabel.getX() + UIHelpers.calcWidthProportion(this.game, 2.0f, 2.0f).floatValue());
        this.defenseParam1Select.setY(defenseLabel.getY() - this.defenseParam1Select.getHeight());
        this.stage.addActor(this.defenseParam1Select);
        this.actorOrder.add(this.defenseParam1Select);
        this.defenseValueSelect = UIHelpers.createTextField(this.game, UIHelpers.calcHeightProportion(this.game, 9.1f, 9.1f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.defenseValueSelect.setText(defensePart.substring(defensePart.indexOf(":") + 1));
        this.defenseValueSelect.setAlignment(16);
        this.defenseValueSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (((String)AIMenuScreen.this.defenseParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.parry"))) {
                    AIMenuScreen.this.defenseValues.set(0, "parry:" + AIMenuScreen.this.defenseValueSelect.getText());
                } else {
                    AIMenuScreen.this.defenseValues.set(0, "dodge:" + AIMenuScreen.this.defenseValueSelect.getText());
                }
            }
        });
        this.defenseValueSelect.setWidth(this.defenseValueSelect.getPrefWidth());
        this.defenseValueSelect.setX(this.defenseParam1Select.getX() + this.defenseParam1Select.getWidth() + UIHelpers.calcWidthProportion(this.game, 0.5f, 0.5f).floatValue());
        this.defenseValueSelect.setY(this.defenseParam1Select.getY());
        this.stage.addActor(this.defenseValueSelect);
        this.actorOrder.add(this.defenseValueSelect);
        this.defenseValues.add(defensePart);
        this.attackLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "common.attack") + ":", this.game.uiSkin, "default");
        this.attackLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.attackLabel.setX(defenseLabel.getX());
        this.attackLabel.setY(this.defenseValueSelect.getY() - this.attackLabel.getPrefHeight() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.stage.addActor(this.attackLabel);
        this.actorOrder.add(this.attackLabel);
        this.attackParam1Select = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String[] availableAttackParams1 = new String[]{PropertiesReader.getMessage(this.game.gameMessages, "common.stamin"), PropertiesReader.getMessage(this.game.gameMessages, "common.balanc"), PropertiesReader.getMessage(this.game.gameMessages, "common.life"), PropertiesReader.getMessage(this.game.gameMessages, "common.pressu"), PropertiesReader.getMessage(this.game.gameMessages, "common.buff"), PropertiesReader.getMessage(this.game.gameMessages, "common.debuff")};
        this.attackParam1Select.setItems((String[])availableAttackParams1);
        this.attackParam1Select.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "common.stamin"));
        this.attackParam1Select.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.stamin")) || ((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.balanc")) || ((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.life"))) {
                    String[] availableAttackParams2 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.own"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.other")};
                    AIMenuScreen.this.attackParam2Select.setItems(availableAttackParams2);
                    AIMenuScreen.this.attackParam2Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.own"));
                    String[] availableAttackParams3 = new String[]{">", "<"};
                    AIMenuScreen.this.attackParam3Select.setItems(availableAttackParams3);
                    AIMenuScreen.this.attackParam3Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "<"));
                    AIMenuScreen.this.attackValueSelect.setText("100");
                } else if (((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.pressu"))) {
                    String[] availableAttackParams2 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any")};
                    AIMenuScreen.this.attackParam2Select.setItems(availableAttackParams2);
                    AIMenuScreen.this.attackParam2Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"));
                    String[] availableAttackParams3 = new String[]{">", "<"};
                    AIMenuScreen.this.attackParam3Select.setItems(availableAttackParams3);
                    AIMenuScreen.this.attackParam3Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "<"));
                    AIMenuScreen.this.attackValueSelect.setText("100");
                } else if (((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff"))) {
                    String[] availableAttackParams2 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.adrena"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.charge"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.frenzy"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.rage"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.ready")};
                    AIMenuScreen.this.attackParam2Select.setItems(availableAttackParams2);
                    AIMenuScreen.this.attackParam2Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"));
                    String[] availableAttackParams3 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any")};
                    AIMenuScreen.this.attackParam3Select.setItems(availableAttackParams3);
                    AIMenuScreen.this.attackParam3Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any")));
                    AIMenuScreen.this.attackValueSelect.setText("100");
                } else if (((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.debuff"))) {
                    String[] availableAttackParams2 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.debuff.bleed"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.debuff.exhaus"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.debuff.stun")};
                    AIMenuScreen.this.attackParam2Select.setItems(availableAttackParams2);
                    AIMenuScreen.this.attackParam2Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"));
                    String[] availableAttackParams3 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any")};
                    AIMenuScreen.this.attackParam3Select.setItems(availableAttackParams3);
                    AIMenuScreen.this.attackParam3Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any")));
                    AIMenuScreen.this.attackValueSelect.setText("100");
                }
            }
        });
        this.attackParam1Select.setWidth(this.attackParam1Select.getPrefWidth());
        this.attackParam1Select.setX(this.attackLabel.getX() + UIHelpers.calcWidthProportion(this.game, 2.0f, 2.0f).floatValue());
        this.attackParam1Select.setY(this.attackLabel.getY() - this.attackParam1Select.getHeight());
        this.stage.addActor(this.attackParam1Select);
        this.actorOrder.add(this.attackParam1Select);
        this.attackParam2Select = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String[] availableAttackParams2 = new String[]{PropertiesReader.getMessage(this.game.gameMessages, "common.own"), PropertiesReader.getMessage(this.game.gameMessages, "common.other")};
        this.attackParam2Select.setItems((String[])availableAttackParams2);
        this.attackParam2Select.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "common.own"));
        this.attackParam2Select.setWidth(this.attackParam2Select.getPrefWidth());
        this.attackParam2Select.setX(this.attackParam1Select.getX() + this.attackParam1Select.getWidth() + UIHelpers.calcWidthProportion(this.game, 0.5f, 0.5f).floatValue());
        this.attackParam2Select.setY(this.attackParam1Select.getY());
        this.stage.addActor(this.attackParam2Select);
        this.actorOrder.add(this.attackParam2Select);
        this.attackParam3Select = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        String[] availableAttackParams3 = new String[]{">", "<"};
        this.attackParam3Select.setItems((String[])availableAttackParams3);
        this.attackParam3Select.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "<"));
        this.attackParam3Select.setWidth(this.attackParam3Select.getPrefWidth());
        this.attackParam3Select.setX(this.attackParam2Select.getX() + this.attackParam2Select.getWidth() + UIHelpers.calcWidthProportion(this.game, 0.5f, 0.5f).floatValue());
        this.attackParam3Select.setY(this.attackParam2Select.getY());
        this.stage.addActor(this.attackParam3Select);
        this.actorOrder.add(this.attackParam3Select);
        this.attackValueSelect = UIHelpers.createTextField(this.game, UIHelpers.calcHeightProportion(this.game, 9.1f, 9.1f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.attackValueSelect.setText("100");
        this.attackValueSelect.setAlignment(16);
        this.attackValueSelect.setWidth(this.attackValueSelect.getPrefWidth());
        this.attackValueSelect.setX(this.attackParam3Select.getX() + this.attackParam3Select.getWidth() + UIHelpers.calcWidthProportion(this.game, 0.5f, 0.5f).floatValue());
        this.attackValueSelect.setY(this.attackParam3Select.getY());
        this.stage.addActor(this.attackValueSelect);
        this.actorOrder.add(this.attackValueSelect);
        Button attackAdd = new Button(this.game.uiSkin, "add");
        attackAdd.setWidth(this.attackValueSelect.getHeight());
        attackAdd.setHeight(this.attackValueSelect.getHeight());
        attackAdd.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                try {
                    int selectedValue = Integer.parseInt(AIMenuScreen.this.attackValueSelect.getText());
                    if (selectedValue >= 0 && selectedValue < 101) {
                        int indexModify;
                        String newAttackLogic = "attack:";
                        if (((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.stamin"))) {
                            newAttackLogic = newAttackLogic + "stamin:";
                        } else if (((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.balanc"))) {
                            newAttackLogic = newAttackLogic + "balanc:";
                        } else if (((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.life"))) {
                            newAttackLogic = newAttackLogic + "life:";
                        } else if (((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.pressu"))) {
                            newAttackLogic = newAttackLogic + "pressu:";
                        } else if (((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff"))) {
                            newAttackLogic = newAttackLogic + "buff:";
                        } else if (((String)AIMenuScreen.this.attackParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.debuff"))) {
                            newAttackLogic = newAttackLogic + "debuff:";
                        }
                        if (((String)AIMenuScreen.this.attackParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"))) {
                            newAttackLogic = newAttackLogic + "any:";
                        } else if (((String)AIMenuScreen.this.attackParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.own"))) {
                            newAttackLogic = newAttackLogic + "own:";
                        } else if (((String)AIMenuScreen.this.attackParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.other"))) {
                            newAttackLogic = newAttackLogic + "other:";
                        } else if (((String)AIMenuScreen.this.attackParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.adrena"))) {
                            newAttackLogic = newAttackLogic + "adrena:";
                        } else if (((String)AIMenuScreen.this.attackParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.charge"))) {
                            newAttackLogic = newAttackLogic + "charge:";
                        } else if (((String)AIMenuScreen.this.attackParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.frenzy"))) {
                            newAttackLogic = newAttackLogic + "frenzy:";
                        } else if (((String)AIMenuScreen.this.attackParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.rage"))) {
                            newAttackLogic = newAttackLogic + "rage:";
                        } else if (((String)AIMenuScreen.this.attackParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.ready"))) {
                            newAttackLogic = newAttackLogic + "ready:";
                        }
                        if (((String)AIMenuScreen.this.attackParam3Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"))) {
                            newAttackLogic = newAttackLogic + "any:";
                        } else if (((String)AIMenuScreen.this.attackParam3Select.getSelected()).equalsIgnoreCase(">")) {
                            newAttackLogic = newAttackLogic + "more:";
                        } else if (((String)AIMenuScreen.this.attackParam3Select.getSelected()).equalsIgnoreCase("<")) {
                            newAttackLogic = newAttackLogic + "less:";
                        }
                        newAttackLogic = newAttackLogic + selectedValue;
                        Actor lastActorCreated = AIMenuScreen.this.createNewRow("attack", newAttackLogic, AIMenuScreen.this.actorOrder.lastIndexOf(AIMenuScreen.this.useLabel));
                        for (int i = indexModify = AIMenuScreen.this.actorOrder.lastIndexOf(lastActorCreated) + 1; i < AIMenuScreen.this.actorOrder.size(); ++i) {
                            ((Actor)AIMenuScreen.this.actorOrder.get(i)).setY(((Actor)AIMenuScreen.this.actorOrder.get(i)).getY() - UIHelpers.calcHeightProportion(AIMenuScreen.this.game, 0.5f, 0.5f).floatValue() - AIMenuScreen.this.useValueSelect.getHeight());
                        }
                        AIMenuScreen.this.infoLabel.setText(" ");
                    } else {
                        AIMenuScreen.this.infoLabel.setText(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "game.ai.warning.number"));
                        AIMenuScreen.this.attackValueSelect.setText("100");
                    }
                }
                catch (NumberFormatException nfe) {
                    AIMenuScreen.this.infoLabel.setText(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "game.ai.warning.number"));
                    AIMenuScreen.this.attackValueSelect.setText("100");
                }
            }
        });
        attackAdd.setX(this.attackValueSelect.getX() + this.attackValueSelect.getWidth() + this.game.viewHeight.floatValue() / 216.0f);
        attackAdd.setY(this.attackValueSelect.getY());
        this.stage.addActor(attackAdd);
        this.actorOrder.add(attackAdd);
        String attackPart = this.behavior.split("#")[1];
        for (String currAttack : attackPart.split(";")) {
            this.createNewRow("attack", currAttack, 0);
        }
        this.useLabel = new Label(PropertiesReader.getMessage(this.game.gameMessages, "common.use") + ":", this.game.uiSkin, "default");
        this.useLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.useLabel.setX(this.attackLabel.getX());
        this.useLabel.setY(this.attackParam1Select.getY() - (UIHelpers.calcHeightProportion(this.game, 0.5f, 0.5f).floatValue() + this.attackValueSelect.getHeight()) * (float)this.attackValues.size() - this.useLabel.getPrefHeight() - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.stage.addActor(this.useLabel);
        this.actorOrder.add(this.useLabel);
        this.useParam1Select = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.useParam1Select.setItems((String[])availableAttackParams1);
        this.useParam1Select.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "common.stamin"));
        this.useParam1Select.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.stamin")) || ((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.balanc")) || ((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.life"))) {
                    String[] availableAttackParams2 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.own"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.other")};
                    AIMenuScreen.this.useParam2Select.setItems(availableAttackParams2);
                    AIMenuScreen.this.useParam2Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.own"));
                    String[] availableAttackParams3 = new String[]{">", "<"};
                    AIMenuScreen.this.useParam3Select.setItems(availableAttackParams3);
                    AIMenuScreen.this.useParam3Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "<"));
                    AIMenuScreen.this.useValueSelect.setText("100");
                } else if (((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.pressu"))) {
                    String[] availableAttackParams2 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any")};
                    AIMenuScreen.this.useParam2Select.setItems(availableAttackParams2);
                    AIMenuScreen.this.useParam2Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"));
                    String[] availableAttackParams3 = new String[]{">", "<"};
                    AIMenuScreen.this.useParam3Select.setItems(availableAttackParams3);
                    AIMenuScreen.this.useParam3Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "<"));
                    AIMenuScreen.this.useValueSelect.setText("100");
                } else if (((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff"))) {
                    String[] availableAttackParams2 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.adrena"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.charge"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.frenzy"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.rage"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.ready")};
                    AIMenuScreen.this.useParam2Select.setItems(availableAttackParams2);
                    AIMenuScreen.this.useParam2Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"));
                    String[] availableAttackParams3 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any")};
                    AIMenuScreen.this.useParam3Select.setItems(availableAttackParams3);
                    AIMenuScreen.this.useParam3Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any")));
                    AIMenuScreen.this.useValueSelect.setText("100");
                } else if (((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.debuff"))) {
                    String[] availableAttackParams2 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.debuff.bleed"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.debuff.exhaus"), PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.debuff.stun")};
                    AIMenuScreen.this.useParam2Select.setItems(availableAttackParams2);
                    AIMenuScreen.this.useParam2Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"));
                    String[] availableAttackParams3 = new String[]{PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any")};
                    AIMenuScreen.this.useParam3Select.setItems(availableAttackParams3);
                    AIMenuScreen.this.useParam3Select.setSelected(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any")));
                    AIMenuScreen.this.useValueSelect.setText("100");
                }
            }
        });
        this.useParam1Select.setWidth(this.useParam1Select.getPrefWidth());
        this.useParam1Select.setX(this.useLabel.getX() + UIHelpers.calcWidthProportion(this.game, 2.0f, 2.0f).floatValue());
        this.useParam1Select.setY(this.useLabel.getY() - this.useParam1Select.getHeight());
        this.stage.addActor(this.useParam1Select);
        this.actorOrder.add(this.useParam1Select);
        this.useParam2Select = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.useParam2Select.setItems((String[])availableAttackParams2);
        this.useParam2Select.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "common.own"));
        this.useParam2Select.setWidth(this.useParam2Select.getPrefWidth());
        this.useParam2Select.setX(this.useParam1Select.getX() + this.useParam1Select.getWidth() + UIHelpers.calcWidthProportion(this.game, 0.5f, 0.5f).floatValue());
        this.useParam2Select.setY(this.useParam1Select.getY());
        this.stage.addActor(this.useParam2Select);
        this.actorOrder.add(this.useParam2Select);
        this.useParam3Select = UIHelpers.createSelectBox(this.game, UIHelpers.calcHeightProportion(this.game, 22.75f, 22.75f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.useParam3Select.setItems((String[])availableAttackParams3);
        this.useParam3Select.setSelected(PropertiesReader.getMessage(this.game.gameMessages, "<"));
        this.useParam3Select.setWidth(this.useParam3Select.getPrefWidth());
        this.useParam3Select.setX(this.useParam2Select.getX() + this.useParam2Select.getWidth() + UIHelpers.calcWidthProportion(this.game, 0.5f, 0.5f).floatValue());
        this.useParam3Select.setY(this.useParam2Select.getY());
        this.stage.addActor(this.useParam3Select);
        this.actorOrder.add(this.useParam3Select);
        this.useValueSelect = UIHelpers.createTextField(this.game, UIHelpers.calcHeightProportion(this.game, 9.1f, 9.1f).floatValue(), UIHelpers.calcHeightProportion(this.game, 4.55f, 4.55f).floatValue(), "default", 1.0f);
        this.useValueSelect.setText("100");
        this.useValueSelect.setAlignment(16);
        this.useValueSelect.setWidth(this.attackValueSelect.getPrefWidth());
        this.useValueSelect.setX(this.useParam3Select.getX() + this.useParam3Select.getWidth() + UIHelpers.calcWidthProportion(this.game, 0.5f, 0.5f).floatValue());
        this.useValueSelect.setY(this.useParam3Select.getY());
        this.stage.addActor(this.useValueSelect);
        this.actorOrder.add(this.useValueSelect);
        Button useAdd = new Button(this.game.uiSkin, "add");
        useAdd.setWidth(this.useValueSelect.getHeight());
        useAdd.setHeight(this.useValueSelect.getHeight());
        useAdd.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                try {
                    int selectedValue = Integer.parseInt(AIMenuScreen.this.useValueSelect.getText());
                    if (selectedValue >= 0 && selectedValue < 101) {
                        int indexModify;
                        String newUseLogic = "use:";
                        if (((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.stamin"))) {
                            newUseLogic = newUseLogic + "stamin:";
                        } else if (((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.balanc"))) {
                            newUseLogic = newUseLogic + "balanc:";
                        } else if (((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.life"))) {
                            newUseLogic = newUseLogic + "life:";
                        } else if (((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.pressu"))) {
                            newUseLogic = newUseLogic + "pressu:";
                        } else if (((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff"))) {
                            newUseLogic = newUseLogic + "buff:";
                        } else if (((String)AIMenuScreen.this.useParam1Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.debuff"))) {
                            newUseLogic = newUseLogic + "debuff:";
                        }
                        if (((String)AIMenuScreen.this.useParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"))) {
                            newUseLogic = newUseLogic + "any:";
                        } else if (((String)AIMenuScreen.this.useParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.own"))) {
                            newUseLogic = newUseLogic + "own:";
                        } else if (((String)AIMenuScreen.this.useParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.other"))) {
                            newUseLogic = newUseLogic + "other:";
                        } else if (((String)AIMenuScreen.this.useParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.adrena"))) {
                            newUseLogic = newUseLogic + "adrena:";
                        } else if (((String)AIMenuScreen.this.useParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.charge"))) {
                            newUseLogic = newUseLogic + "charge:";
                        } else if (((String)AIMenuScreen.this.useParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.frenzy"))) {
                            newUseLogic = newUseLogic + "frenzy:";
                        } else if (((String)AIMenuScreen.this.useParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.rage"))) {
                            newUseLogic = newUseLogic + "rage:";
                        } else if (((String)AIMenuScreen.this.useParam2Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.buff.ready"))) {
                            newUseLogic = newUseLogic + "ready:";
                        }
                        if (((String)AIMenuScreen.this.useParam3Select.getSelected()).equalsIgnoreCase(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "common.any"))) {
                            newUseLogic = newUseLogic + "any:";
                        } else if (((String)AIMenuScreen.this.useParam3Select.getSelected()).equalsIgnoreCase(">")) {
                            newUseLogic = newUseLogic + "more:";
                        } else if (((String)AIMenuScreen.this.useParam3Select.getSelected()).equalsIgnoreCase("<")) {
                            newUseLogic = newUseLogic + "less:";
                        }
                        newUseLogic = newUseLogic + selectedValue;
                        Actor lastActorCreated = AIMenuScreen.this.createNewRow("use", newUseLogic, AIMenuScreen.this.actorOrder.lastIndexOf(AIMenuScreen.this.infoLabel));
                        for (int i = indexModify = AIMenuScreen.this.actorOrder.lastIndexOf(lastActorCreated) + 1; i < AIMenuScreen.this.actorOrder.size(); ++i) {
                            ((Actor)AIMenuScreen.this.actorOrder.get(i)).setY(((Actor)AIMenuScreen.this.actorOrder.get(i)).getY() - UIHelpers.calcHeightProportion(AIMenuScreen.this.game, 0.5f, 0.5f).floatValue() - AIMenuScreen.this.attackValueSelect.getHeight());
                        }
                        AIMenuScreen.this.infoLabel.setText(" ");
                    } else {
                        AIMenuScreen.this.infoLabel.setText(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "game.ai.warning.number"));
                        AIMenuScreen.this.useValueSelect.setText("100");
                    }
                }
                catch (NumberFormatException nfe) {
                    AIMenuScreen.this.infoLabel.setText(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "game.ai.warning.number"));
                    AIMenuScreen.this.useValueSelect.setText("100");
                }
            }
        });
        useAdd.setX(this.useValueSelect.getX() + this.useValueSelect.getWidth() + this.game.viewHeight.floatValue() / 216.0f);
        useAdd.setY(this.useValueSelect.getY());
        this.stage.addActor(useAdd);
        this.actorOrder.add(useAdd);
        String usePart = this.behavior.split("#")[2];
        for (String currUse : usePart.split(";")) {
            this.createNewRow("use", currUse, 0);
        }
        this.infoLabel = new Label("", this.game.uiSkin, "default");
        this.infoLabel.setFontScale(this.game.viewHeight.floatValue() / this.game.heightBASE.floatValue());
        this.infoLabel.setColor(Color.RED);
        this.infoLabel.setAlignment(1);
        this.infoLabel.setWrap(true);
        this.infoLabel.setWidth(this.game.viewWidth.floatValue());
        this.infoLabel.setX(0.0f);
        this.infoLabel.setY(this.useParam1Select.getY() - this.infoLabel.getPrefHeight() - (UIHelpers.calcHeightProportion(this.game, 0.5f, 0.5f).floatValue() + this.attackValueSelect.getHeight()) * (float)this.useValues.size() - UIHelpers.calcHeightProportion(this.game, 1.0f, 1.0f).floatValue());
        this.stage.addActor(this.infoLabel);
        this.actorOrder.add(this.infoLabel);
        Button applyButton = new Button(this.game.uiSkin, "ok");
        applyButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (AIMenuScreen.this.attackValues.size() == 0 || AIMenuScreen.this.useValues.size() == 0) {
                    AIMenuScreen.this.infoLabel.setText(PropertiesReader.getMessage(AIMenuScreen.this.game.gameMessages, "game.ai.warning.numberrules"));
                } else {
                    int i;
                    StringBuilder newBehavior = new StringBuilder((String)AIMenuScreen.this.defenseValues.get(0) + "#");
                    for (i = 0; i < AIMenuScreen.this.attackValues.size(); ++i) {
                        if (i > 0) {
                            newBehavior.append(";");
                        }
                        newBehavior.append((String)AIMenuScreen.this.attackValues.get(i));
                    }
                    newBehavior.append("#");
                    for (i = 0; i < AIMenuScreen.this.useValues.size(); ++i) {
                        if (i > 0) {
                            newBehavior.append(";");
                        }
                        newBehavior.append((String)AIMenuScreen.this.useValues.get(i));
                    }
                    AIMenuScreen.this.behavior = newBehavior.toString();
                    if (AIMenuScreen.this.previousScreen instanceof DuelSetupScreen) {
                        ((DuelSetupScreen)((AIMenuScreen)AIMenuScreen.this).previousScreen).hostAIbehavior = AIMenuScreen.this.behavior;
                    } else if (AIMenuScreen.this.previousScreen instanceof PrepSetupScreen) {
                        ((PrepSetupScreen)((AIMenuScreen)AIMenuScreen.this).previousScreen).hostAIbehavior = AIMenuScreen.this.behavior;
                    } else if (AIMenuScreen.this.previousScreen instanceof TournamentSetupScreen) {
                        ((TournamentSetupScreen)((AIMenuScreen)AIMenuScreen.this).previousScreen).hostAIbehavior = AIMenuScreen.this.behavior;
                    }
                    AIMenuScreen.this.game.setScreen(AIMenuScreen.this.previousScreen);
                    AIMenuScreen.this.dispose();
                }
            }
        });
        applyButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        applyButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        applyButton.setX(UIHelpers.calcWidthProportion(this.game, 49.65f, 49.65f).floatValue() - applyButton.getPrefWidth());
        applyButton.setY(this.infoLabel.getY() - applyButton.getHeight() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.stage.addActor(applyButton);
        this.actorOrder.add(applyButton);
        Button exitButton = new Button(this.game.uiSkin, "cancel");
        exitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                AIMenuScreen.this.game.setScreen(AIMenuScreen.this.previousScreen);
                AIMenuScreen.this.dispose();
            }
        });
        exitButton.setWidth(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        exitButton.setHeight(UIHelpers.calcHeightProportion(this.game, 8.0f, 8.0f).floatValue());
        exitButton.setX(UIHelpers.calcWidthProportion(this.game, 50.35f, 50.35f).floatValue());
        exitButton.setY(this.infoLabel.getY() - exitButton.getHeight() - UIHelpers.calcHeightProportion(this.game, 2.0f, 2.0f).floatValue());
        this.stage.addActor(exitButton);
        this.actorOrder.add(exitButton);
    }

    @Override
    public void render(float delta) {
        this.stage.act(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    @Override
    public void dispose() {
        this.actorOrder.clear();
    }

    private Actor createNewRow(String type, String currLogic, int orderIndex) {
        float x = 0.0f;
        float y = 0.0f;
        if (type.equalsIgnoreCase("attack")) {
            x = this.attackParam1Select.getX() + UIHelpers.calcWidthProportion(this.game, 2.0f, 2.0f).floatValue();
            y = this.attackParam1Select.getY() - (UIHelpers.calcHeightProportion(this.game, 0.5f, 0.5f).floatValue() + this.attackValueSelect.getHeight()) * (float)(this.attackValues.size() + 1);
        } else if (type.equalsIgnoreCase("use")) {
            x = this.useParam1Select.getX() + UIHelpers.calcWidthProportion(this.game, 2.0f, 2.0f).floatValue();
            y = this.useParam1Select.getY() - (UIHelpers.calcHeightProportion(this.game, 0.5f, 0.5f).floatValue() + this.useValueSelect.getHeight()) * (float)(this.useValues.size() + 1);
        }
        String logicDescription = PropertiesReader.getMessage(this.game.gameMessages, "common." + currLogic.split(":")[1]);
        logicDescription = logicDescription + " [" + PropertiesReader.getMessage(this.game.gameMessages, "common." + currLogic.split(":")[2]) + "]";
        logicDescription = currLogic.split(":")[1].contains("buff") ? logicDescription + " [%]" : logicDescription + " " + PropertiesReader.getMessage(this.game.gameMessages, "common." + currLogic.split(":")[3]);
        logicDescription = logicDescription + " " + currLogic.split(":")[4] + "%";
        if (type.equalsIgnoreCase("attack")) {
            this.attackValues.add(currLogic);
        } else if (type.equalsIgnoreCase("use")) {
            this.useValues.add(currLogic);
        }
        Label labelLogic = new Label(logicDescription, this.game.uiSkin, "default");
        labelLogic.setFontScale(this.game.viewHeight.floatValue() / (this.game.heightBASE.floatValue() * 5.0f / 4.0f));
        labelLogic.setColor(this.game.uiSkin.get("iron", Color.class));
        labelLogic.setWidth(labelLogic.getPrefWidth());
        labelLogic.setHeight(this.attackValueSelect.getHeight());
        labelLogic.setX(x + UIHelpers.calcWidthProportion(this.game, 2.5f, 2.5f).floatValue());
        labelLogic.setY(y);
        this.stage.addActor(labelLogic);
        if (orderIndex == 0) {
            this.actorOrder.add(labelLogic);
        } else {
            this.actorOrder.add(orderIndex, labelLogic);
        }
        Button attackRemove = new Button(this.game.uiSkin, "remove");
        attackRemove.setWidth(this.attackValueSelect.getHeight());
        attackRemove.setHeight(this.attackValueSelect.getHeight());
        attackRemove.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                int indexModify = AIMenuScreen.this.actorOrder.lastIndexOf(event.getListenerActor());
                int indexUseLabel = AIMenuScreen.this.actorOrder.lastIndexOf(AIMenuScreen.this.useLabel);
                if (indexUseLabel > indexModify) {
                    AIMenuScreen.this.attackValues.remove(AIMenuScreen.this.attackValues.size() - ((indexUseLabel - indexModify) / 2 + 1));
                } else {
                    AIMenuScreen.this.useValues.remove(AIMenuScreen.this.useValues.size() - ((AIMenuScreen.this.actorOrder.lastIndexOf(AIMenuScreen.this.infoLabel) - indexModify) / 2 + 1));
                }
                Actor actorToRemove = (Actor)AIMenuScreen.this.actorOrder.get(indexModify);
                AIMenuScreen.this.actorOrder.remove(indexModify);
                actorToRemove.remove();
                actorToRemove = (Actor)AIMenuScreen.this.actorOrder.get(--indexModify);
                AIMenuScreen.this.actorOrder.remove(indexModify);
                actorToRemove.remove();
                for (int i = indexModify; i < AIMenuScreen.this.actorOrder.size(); ++i) {
                    ((Actor)AIMenuScreen.this.actorOrder.get(i)).setY(((Actor)AIMenuScreen.this.actorOrder.get(i)).getY() + UIHelpers.calcHeightProportion(AIMenuScreen.this.game, 0.5f, 0.5f).floatValue() + AIMenuScreen.this.useValueSelect.getHeight());
                }
                AIMenuScreen.this.infoLabel.setText(" ");
            }
        });
        attackRemove.setX(labelLogic.getX() + labelLogic.getPrefWidth() + UIHelpers.calcWidthProportion(this.game, 0.5f, 0.5f).floatValue());
        attackRemove.setY(y);
        this.stage.addActor(attackRemove);
        if (orderIndex == 0) {
            this.actorOrder.add(attackRemove);
        } else {
            this.actorOrder.add(orderIndex + 1, attackRemove);
        }
        return attackRemove;
    }
}

