/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.game;

import com.badlogic.gdx.math.MathUtils;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.actor.UIHelpers;
import com.calimasaga.slavepits.game.Equipment;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.screen.CombatScreen;
import com.calimasaga.slavepits.screen.MessageScreen;
import com.calimasaga.slavepits.screen.ServicesMenuScreen;
import com.calimasaga.slavepits.screen.SmithMenuScreen;
import com.calimasaga.slavepits.screen.TalentsMenuScreen;
import com.calimasaga.slavepits.screen.TournamentEventScreen;
import com.calimasaga.slavepits.screen.TournamentSetupScreen;
import com.calimasaga.slavepits.screen.TrainerMenuScreen;
import com.calimasaga.slavepits.util.PropertiesReader;
import com.calimasaga.slavepits.util.StringList;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class Tournament {
    public static void newGame(SlavePitsGame g, String fighterName, String fighterPortrait, String difficulty) {
        g.campaignFighter = Fighter.createOpponent(g, fighterName, 1000, true);
        JSONObject currObjCharacter = g.stats.get("tournament").getJSONObject("characters").getJSONObject(fighterName);
        g.campaignFighter = Fighter.changeAppearance(g, fighterPortrait, g.campaignFighter, true, false);
        g.campaignFighter.life = g.campaignFighter.maxLife;
        g.campaignFighter.weapon = new Equipment();
        g.campaignFighter.weapon.id = "dagger";
        g.campaignFighter.weapon.tier = "wood";
        g.campaignFighter.behavior = "";
        g.saveGame.put("name", "1");
        g.saveGame.put("position", "4");
        g.saveGame.put("difficulty", difficulty);
        g.saveGame.put("phase", "pits");
        g.saveGame.put("step", "fight");
        g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
        g.saveGame.put("rewards", currObjCharacter.getString("rewards"));
        g.saveGame.put("profits", currObjCharacter.getString("profits"));
        g.saveGame.put("behavior", "");
        g.saveGame.put("search", "none");
        g.saveGame.remove("special");
        g.saveGame.remove("store");
        g.saveGame.put("events", "");
        g.saveGame.put("eventStep", "1");
        g.saveGame.put("opponents", "");
        g.saveGame.put("quests", "");
        g.saveGame.put("randomNumber", "" + MathUtils.random(99));
        g.saveGame.put("fight", "0");
        g.saveGame.put("lostDays", "0");
        g.saveGame.remove("delete");
        PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
        Tournament.getNextScreen(g, "chapter1", "");
    }

    public static String getCharacterList(SlavePitsGame g) {
        return g.stats.get("tournament").getString("characterOrder");
    }

    public static int getRewardStock(SlavePitsGame g, String type) {
        StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
        for (int j = 2; j < StringList.size(rewards, ";"); ++j) {
            String currReward = StringList.get(rewards, j, ";");
            if (!currReward.startsWith(type)) continue;
            return Integer.parseInt(currReward.substring(currReward.indexOf(":") + 1));
        }
        return 0;
    }

    public static void setRewardStock(SlavePitsGame g, String type, int amount) {
        StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
        if (rewards.toString().contains(type + ":")) {
            for (int j = 2; j < StringList.size(rewards, ";"); ++j) {
                String currReward = StringList.get(rewards, j, ";");
                if (!currReward.startsWith(type)) continue;
                rewards = amount == 0 ? StringList.remove(rewards, j, ";") : StringList.set(rewards, j, type + ":" + amount, ";");
                break;
            }
        } else if (amount != 0) {
            rewards = StringList.append(rewards, type + ":" + amount, ";");
        }
        g.saveGame.put("rewards", rewards.toString());
    }

    public static int getRewardStockBundle(SlavePitsGame g, String type, String filter) {
        if (type.equalsIgnoreCase("weapon")) {
            int result = 0;
            StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
            for (int j = 2; j < StringList.size(rewards, ";"); ++j) {
                String currReward = StringList.get(rewards, j, ";");
                if (!currReward.startsWith("hatchet") && !currReward.startsWith("mace") && !currReward.startsWith("sword") && !currReward.startsWith("axe") && !currReward.startsWith("hammer") && !currReward.startsWith("spear") && !currReward.startsWith("longsword") && !currReward.startsWith("whip") && !currReward.startsWith("shield")) continue;
                result += Integer.parseInt(currReward.substring(currReward.indexOf(":") + 1));
            }
            return result;
        }
        if (type.equalsIgnoreCase("service")) {
            int result = 0;
            StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
            for (int j = 2; j < StringList.size(rewards, ";"); ++j) {
                String currReward = StringList.get(rewards, j, ";");
                if (!currReward.startsWith("shard") && !currReward.startsWith("powder") && !currReward.startsWith("net") && !currReward.startsWith("upgradearmor") && !currReward.startsWith("upgradeweapon") && !currReward.startsWith("care") && !currReward.startsWith("info") && !currReward.startsWith("potion")) continue;
                result += Integer.parseInt(currReward.substring(currReward.indexOf(":") + 1));
            }
            return result;
        }
        return 0;
    }

    public static HashMap<String, Integer> getWeaponsAvailable(SlavePitsGame g) {
        StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("dagger", 2);
        result.put("hatchet", 0);
        result.put("mace", 0);
        result.put("sword", 0);
        result.put("axe", 0);
        result.put("hammer", 0);
        result.put("spear", 0);
        result.put("longsword", 0);
        result.put("whip", 0);
        result.put("shield", 0);
        result.put("cuirass", 0);
        result.put("helmet", 0);
        result.put("bracers", 0);
        for (int j = 2; j < StringList.size(rewards, ";"); ++j) {
            String currReward = StringList.get(rewards, j, ";");
            if (!currReward.startsWith("hatchet") && !currReward.startsWith("mace") && !currReward.startsWith("sword") && !currReward.startsWith("axe") && !currReward.startsWith("hammer") && !currReward.startsWith("spear") && !currReward.startsWith("longsword") && !currReward.startsWith("whip") && !currReward.startsWith("shield") && !currReward.startsWith("cuirass") && !currReward.startsWith("helmet") && !currReward.startsWith("bracers")) continue;
            result.put(currReward.substring(0, currReward.indexOf(":")), Integer.parseInt(currReward.substring(currReward.indexOf(":") + 1)));
        }
        return result;
    }

    public static void setWeaponsAvailable(SlavePitsGame g, HashMap<String, Integer> equipment) {
        StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
        for (String currEquipment : equipment.keySet()) {
            int i;
            if (currEquipment.equalsIgnoreCase("dagger")) continue;
            for (i = 0; i >= 0 && i < StringList.size(rewards, ";"); ++i) {
                if (!StringList.get(rewards, i, ";").startsWith(currEquipment)) continue;
                rewards = equipment.get(currEquipment) <= 0 ? StringList.remove(rewards, i, ";") : StringList.set(rewards, i, currEquipment + ":" + equipment.get(currEquipment), ";");
                i = -2;
            }
            if (i <= 0) continue;
            rewards = StringList.append(rewards, currEquipment + ":" + equipment.get(currEquipment), ";");
        }
        g.saveGame.put("rewards", rewards.toString());
    }

    public static HashMap<String, Integer> getServicesAvailable(SlavePitsGame g) {
        StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("shard", 0);
        result.put("powder", 0);
        result.put("net", 0);
        result.put("upgradearmor", 0);
        result.put("upgradeweapon", 0);
        result.put("care", 0);
        result.put("info", 0);
        result.put("potion", 0);
        for (int j = 2; j < StringList.size(rewards, ";"); ++j) {
            String currReward = StringList.get(rewards, j, ";");
            if (!currReward.startsWith("shard") && !currReward.startsWith("powder") && !currReward.startsWith("net") && !currReward.startsWith("upgradearmor") && !currReward.startsWith("upgradeweapon") && !currReward.startsWith("care") && !currReward.startsWith("info") && !currReward.startsWith("potion")) continue;
            result.put(currReward.substring(0, currReward.indexOf(":")), Integer.parseInt(currReward.substring(currReward.indexOf(":") + 1)));
        }
        return result;
    }

    public static void setServicesAvailable(SlavePitsGame g, HashMap<String, Integer> services) {
        StringBuilder rewards = StringList.create(g.saveGame.get("rewards"), ";");
        for (String currService : services.keySet()) {
            int i;
            for (i = 0; i >= 0 && i < StringList.size(rewards, ";"); ++i) {
                if (!StringList.get(rewards, i, ";").startsWith(currService)) continue;
                rewards = services.get(currService) <= 0 ? StringList.remove(rewards, i, ";") : StringList.set(rewards, i, currService + ":" + services.get(currService), ";");
                i = -2;
            }
            if (i <= 0) continue;
            rewards = StringList.append(rewards, currService + ":" + services.get(currService), ";");
        }
        g.saveGame.put("rewards", rewards.toString());
    }

    public static HashMap<String, Integer> getWeaponsStore(SlavePitsGame g, String create) {
        String store = g.saveGame.get("store");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (store == null) {
            if (!create.equalsIgnoreCase("")) {
                if (create.startsWith("armor")) {
                    int minRange = Integer.parseInt(create.split(":")[1]);
                    int bonusRange = Integer.parseInt(create.split(":")[2]) - minRange;
                    result.put("cuirass", minRange + MathUtils.random(bonusRange));
                    result.put("helmet", minRange + MathUtils.random(bonusRange));
                    result.put("bracers", minRange + MathUtils.random(bonusRange));
                    result.put("hatchet", 0);
                    result.put("mace", 0);
                    result.put("sword", 0);
                    result.put("axe", 0);
                    result.put("hammer", 0);
                    result.put("spear", 0);
                    result.put("longsword", 0);
                    result.put("whip", 0);
                    result.put("shield", 0);
                } else {
                    int minRange = Integer.parseInt(create.split(":")[1]);
                    int bonusRange = Integer.parseInt(create.split(":")[2]) - minRange;
                    result.put("hatchet", minRange + MathUtils.random(bonusRange));
                    result.put("mace", minRange + MathUtils.random(bonusRange));
                    result.put("sword", minRange + MathUtils.random(bonusRange));
                    result.put("axe", minRange + MathUtils.random(bonusRange));
                    result.put("hammer", minRange + MathUtils.random(bonusRange));
                    result.put("spear", minRange + MathUtils.random(bonusRange));
                    result.put("longsword", minRange + MathUtils.random(bonusRange));
                    result.put("whip", minRange + MathUtils.random(bonusRange));
                    result.put("shield", minRange + MathUtils.random(bonusRange));
                    result.put("cuirass", (minRange + MathUtils.random(bonusRange)) * 5);
                    result.put("helmet", (minRange + MathUtils.random(bonusRange)) * 5);
                    result.put("bracers", (minRange + MathUtils.random(bonusRange)) * 5);
                }
                Tournament.setWeaponsStore(g, result);
            }
        } else {
            StringBuilder currStore = new StringBuilder(store);
            for (int i = 0; i < StringList.size(currStore, ";"); ++i) {
                String currItem = StringList.get(currStore, i, ";");
                result.put(currItem.substring(0, currItem.indexOf(":")), Integer.parseInt(currItem.substring(currItem.indexOf(":") + 1)));
            }
        }
        return result;
    }

    public static void setWeaponsStore(SlavePitsGame g, HashMap<String, Integer> store) {
        StringBuilder finalStore = new StringBuilder();
        for (String currItem : store.keySet()) {
            finalStore.append(currItem);
            finalStore.append(":");
            finalStore.append(store.get(currItem));
            finalStore.append(";");
        }
        g.saveGame.put("store", finalStore.substring(0, finalStore.length() - 1));
    }

    public static HashMap<String, Integer> getServicesStore(SlavePitsGame g, String create) {
        String store = g.saveGame.get("store");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (store == null) {
            if (!create.equalsIgnoreCase("")) {
                if (create.startsWith("seer")) {
                    int minRange = Integer.parseInt(create.split(":")[1]);
                    int bonusRange = Integer.parseInt(create.split(":")[2]) - minRange;
                    result.put("shard", 0);
                    result.put("powder", 0);
                    result.put("net", 0);
                    result.put("upgradearmor", 0);
                    result.put("upgradeweapon", 0);
                    result.put("care", minRange + MathUtils.random(bonusRange));
                    result.put("info", minRange + MathUtils.random(bonusRange));
                    result.put("potion", minRange + MathUtils.random(bonusRange));
                    Tournament.setServicesStore(g, result);
                } else if (create.startsWith("veteran")) {
                    int minRange = Integer.parseInt(create.split(":")[1]);
                    int bonusRange = Integer.parseInt(create.split(":")[2]) - minRange;
                    result.put("shard", 0);
                    result.put("powder", 0);
                    result.put("net", minRange + MathUtils.random(bonusRange));
                    result.put("upgradearmor", minRange * 3 + MathUtils.random(bonusRange * 3));
                    result.put("upgradeweapon", minRange + MathUtils.random(bonusRange));
                    result.put("care", 0);
                    result.put("info", minRange + MathUtils.random(bonusRange));
                    result.put("potion", 0);
                    Tournament.setServicesStore(g, result);
                } else if (create.startsWith("seller")) {
                    result.put("shard", 0);
                    result.put("powder", 0);
                    result.put("net", 0);
                    result.put("upgradearmor", 0);
                    result.put("upgradeweapon", 0);
                    result.put("care", 0);
                    result.put("info", 0);
                    result.put("potion", 0);
                } else {
                    int minRange = Integer.parseInt(create.split(":")[1]);
                    int bonusRange = Integer.parseInt(create.split(":")[2]) - minRange;
                    result.put("shard", minRange + MathUtils.random(bonusRange));
                    result.put("powder", minRange + MathUtils.random(bonusRange));
                    result.put("net", minRange + MathUtils.random(bonusRange));
                    result.put("upgradearmor", minRange * 3 + MathUtils.random(bonusRange * 3));
                    result.put("upgradeweapon", minRange + MathUtils.random(bonusRange));
                    result.put("care", minRange + MathUtils.random(bonusRange));
                    result.put("info", minRange + MathUtils.random(bonusRange));
                    result.put("potion", minRange + MathUtils.random(bonusRange));
                    Tournament.setServicesStore(g, result);
                }
            }
        } else {
            StringBuilder currStore = new StringBuilder(store);
            for (int i = 0; i < StringList.size(currStore, ";"); ++i) {
                String currItem = StringList.get(currStore, i, ";");
                result.put(currItem.substring(0, currItem.indexOf(":")), Integer.parseInt(currItem.substring(currItem.indexOf(":") + 1)));
            }
        }
        return result;
    }

    public static void setServicesStore(SlavePitsGame g, HashMap<String, Integer> store) {
        StringBuilder finalStore = new StringBuilder();
        for (String currItem : store.keySet()) {
            finalStore.append(currItem);
            finalStore.append(":");
            finalStore.append(store.get(currItem));
            finalStore.append(";");
        }
        g.saveGame.put("store", finalStore.substring(0, finalStore.length() - 1));
    }

    public static String getRandomWeapon(String filterType) {
        String currWeapon = "";
        int randomWeapon = MathUtils.random(1) + 1;
        if (filterType.contains("oh")) {
            randomWeapon = 0;
        } else if (filterType.contains("1h")) {
            randomWeapon = 1;
        } else if (filterType.contains("2h")) {
            randomWeapon = 2;
        }
        if (randomWeapon == 2) {
            randomWeapon = MathUtils.random(3);
            if (randomWeapon == 0) {
                currWeapon = "axe";
            } else if (randomWeapon == 1) {
                currWeapon = "hammer";
            } else if (randomWeapon == 2) {
                currWeapon = "longsword";
            } else if (randomWeapon == 3) {
                currWeapon = "spear";
            }
        } else if (randomWeapon == 0) {
            randomWeapon = MathUtils.random(2 + (filterType.contains("nodagger") ? 0 : 1) + (filterType.contains("noshield") ? 0 : 1));
            if (randomWeapon == 0) {
                currWeapon = "hatchet";
            } else if (randomWeapon == 1) {
                currWeapon = "mace";
            } else if (randomWeapon == 2) {
                currWeapon = "sword";
            } else if (randomWeapon >= 3) {
                currWeapon = !filterType.contains("noshield") ? (MathUtils.random(1) == 0 || filterType.contains("nodagger") ? "shield" : "dagger") : "dagger";
            }
        } else {
            randomWeapon = MathUtils.random(3 + (filterType.contains("nodagger") ? 0 : 1) + (filterType.contains("noshield") ? 0 : 1));
            if (randomWeapon == 0) {
                currWeapon = "hatchet";
            } else if (randomWeapon == 1) {
                currWeapon = "mace";
            } else if (randomWeapon == 2) {
                currWeapon = "sword";
            } else if (randomWeapon == 3) {
                currWeapon = "whip";
            } else if (randomWeapon >= 4) {
                currWeapon = !filterType.contains("noshield") ? (MathUtils.random(1) == 0 || filterType.contains("nodagger") ? "shield" : "dagger") : "dagger";
            }
        }
        return currWeapon;
    }

    public static String getRandomService(String filterType) {
        String currService = "";
        int randomService = MathUtils.random(3 + (!filterType.contains("cheap") ? (!filterType.contains("expensive") ? 3 : 0) : 0) + (filterType.contains("care") ? 1 : 0)) + (filterType.contains("expensive") ? 3 : 0);
        if (randomService == 0) {
            currService = "shard";
        } else if (randomService == 1) {
            currService = "powder";
        } else if (randomService == 2) {
            currService = "net";
        } else if (randomService == 3) {
            currService = "upgradearmor";
        } else if (randomService == 4) {
            currService = "upgradeweapon";
        } else if (randomService == 5) {
            currService = "info";
        } else if (randomService == 6) {
            currService = "potion";
        } else if (randomService >= 7) {
            currService = "care";
        }
        return currService;
    }

    public static String getRandomArmor(String filterType) {
        String currArmor = "";
        int randomArmor = MathUtils.random(1);
        if (filterType.contains("nocuirass")) {
            randomArmor = 1;
        }
        currArmor = randomArmor == 0 ? "cuirass" : ((randomArmor = MathUtils.random(1)) == 0 ? "helmet" : "bracers");
        return currArmor;
    }

    public static boolean rearmPlayer(SlavePitsGame g, Fighter player, String option) {
        boolean equipmentModified = false;
        if (!option.contains("noweapon")) {
            String currWeapon;
            int tries;
            if (player.weapon == null || Tournament.getRewardStock(g, player.weapon.id) == 0) {
                if (Tournament.getRewardStockBundle(g, "weapon", "") > 0) {
                    for (tries = 10; tries > 0; --tries) {
                        currWeapon = Tournament.getRandomWeapon("noshield,nodagger");
                        if (Tournament.getRewardStock(g, currWeapon) <= 0) continue;
                        Tournament.setRewardStock(g, currWeapon, Tournament.getRewardStock(g, currWeapon) - 1);
                        player.weapon.id = currWeapon;
                        equipmentModified = true;
                        if (player.offHand != null && player.offHand.id.equalsIgnoreCase("shield") && g.stats.get("weapons").getJSONObject(player.weapon.id).getString("type").startsWith("2")) {
                            Tournament.setRewardStock(g, currWeapon, Tournament.getRewardStock(g, "shield") + 1);
                            player.offHand = null;
                        }
                        tries = 0;
                    }
                    if (tries == 0) {
                        player.weapon.id = "dagger";
                        equipmentModified = true;
                    }
                } else {
                    player.weapon.id = "dagger";
                    equipmentModified = true;
                }
            } else {
                Tournament.setRewardStock(g, player.weapon.id, Tournament.getRewardStock(g, player.weapon.id) - 1);
            }
            player.weapon.tier = "wood";
            if (player.offHand != null && player.offHand.id.equalsIgnoreCase("shield") && Tournament.getRewardStock(g, player.offHand.id) > 0) {
                Tournament.setRewardStock(g, player.offHand.id, Tournament.getRewardStock(g, player.offHand.id) - 1);
            } else if (player.offHand == null && g.stats.get("weapons").getJSONObject(player.weapon.id).getString("type").startsWith("1") || player.offHand != null && Tournament.getRewardStock(g, player.offHand.id) == 0) {
                if (Tournament.getRewardStockBundle(g, "weapon", "1h") > 0) {
                    for (tries = 10; tries > 0; --tries) {
                        currWeapon = Tournament.getRandomWeapon("oh");
                        if (Tournament.getRewardStock(g, currWeapon) <= 0) continue;
                        if (currWeapon.equalsIgnoreCase("shield")) {
                            Tournament.setRewardStock(g, currWeapon, Tournament.getRewardStock(g, currWeapon) - 1);
                        }
                        player.offHand = new Equipment();
                        player.offHand.id = currWeapon;
                        player.offHand.tier = "wood";
                        equipmentModified = true;
                        tries = 0;
                    }
                    if (tries == 0) {
                        player.offHand = new Equipment();
                        player.offHand.id = "dagger";
                        player.offHand.tier = "wood";
                        equipmentModified = true;
                    }
                } else {
                    player.offHand = new Equipment();
                    player.offHand.id = "dagger";
                    player.offHand.tier = "wood";
                    equipmentModified = true;
                }
            }
        }
        if (player.head != null) {
            if (Tournament.getRewardStock(g, player.head.id) > 0) {
                Tournament.setRewardStock(g, player.head.id, Tournament.getRewardStock(g, player.head.id) - 1);
                player.head.tier = "wood";
            } else {
                player.head = null;
                equipmentModified = true;
            }
        }
        if (player.arms != null) {
            if (Tournament.getRewardStock(g, player.arms.id) > 0) {
                Tournament.setRewardStock(g, player.arms.id, Tournament.getRewardStock(g, player.arms.id) - 1);
                player.arms.tier = "wood";
            } else {
                player.arms = null;
                equipmentModified = true;
            }
        }
        if (player.body != null) {
            if (Tournament.getRewardStock(g, player.body.id) > 0) {
                Tournament.setRewardStock(g, player.body.id, Tournament.getRewardStock(g, player.body.id) - 1);
                player.body.tier = "wood";
            } else {
                player.body = null;
                equipmentModified = true;
            }
        }
        return equipmentModified;
    }

    public static int getRandomTalent(SlavePitsGame g, Fighter fighter) {
        int result = MathUtils.random(44) + 6;
        boolean found = false;
        boolean cycle = false;
        int startingTalent = result;
        while (!(found || startingTalent == result && cycle)) {
            if (fighter.talents.get("" + result) == null && fighter.talentsBlocked.get("" + result) == null) {
                found = true;
                continue;
            }
            if (++result <= 50) continue;
            result = 6;
            cycle = true;
        }
        if (startingTalent == result && cycle) {
            result = -1;
        }
        return result;
    }

    public static String getRandomOpponent(SlavePitsGame g, String forceFilter) {
        ArrayList<String> listOpponents = new ArrayList<String>();
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            listOpponents.add("min");
            listOpponents.add("scala");
            listOpponents.add("tara");
            listOpponents.add("lea");
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            listOpponents.add("trent");
            listOpponents.add("onur");
            listOpponents.add("ponte");
            listOpponents.add("fenris");
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            if (forceFilter.equalsIgnoreCase("fillowfir")) {
                listOpponents.add("boris");
                listOpponents.add("scala");
                listOpponents.add("tara");
            } else if (forceFilter.equalsIgnoreCase("fillowiro")) {
                listOpponents.add("zola");
                listOpponents.add("roe");
                listOpponents.add("ponte");
            } else if (forceFilter.equalsIgnoreCase("fillowfor")) {
                listOpponents.add("ayla");
                listOpponents.add("lea");
                listOpponents.add("min");
                listOpponents.add("fenris");
            } else if (forceFilter.equalsIgnoreCase("fillowfiriro")) {
                listOpponents.add("boris");
                listOpponents.add("scala");
                listOpponents.add("tara");
                listOpponents.add("zola");
                listOpponents.add("roe");
                listOpponents.add("ponte");
            } else if (forceFilter.equalsIgnoreCase("filleader")) {
                listOpponents.add("sarah");
                listOpponents.add("rishi");
                listOpponents.add("bastien");
                listOpponents.add("san");
            } else if (forceFilter.equalsIgnoreCase("filoldcha")) {
                if (Tournament.getRewardStock(g, "bosty1") == 0) {
                    listOpponents.add("tournamentboss1");
                }
                if (Tournament.getRewardStock(g, "bosty2") == 0) {
                    listOpponents.add("tournamentboss2");
                }
                if (Tournament.getRewardStock(g, "bosty3") == 0) {
                    listOpponents.add("tournamentboss3");
                }
            } else if (forceFilter.equalsIgnoreCase("filcabal")) {
                listOpponents.add("min");
                listOpponents.add("fenris");
                listOpponents.add("nattfrid");
                listOpponents.add("san");
            } else {
                listOpponents.add("boris");
                listOpponents.add("scala");
                listOpponents.add("zola");
                listOpponents.add("roe");
                listOpponents.add("ponte");
                listOpponents.add("tara");
                listOpponents.add("ayla");
                listOpponents.add("lea");
                listOpponents.add("min");
                listOpponents.add("fenris");
                listOpponents.add("luntian");
                listOpponents.add("blaire");
                listOpponents.add("nattfrid");
                listOpponents.add("sarah");
                listOpponents.add("rishi");
                listOpponents.add("bastien");
                listOpponents.add("san");
            }
        }
        String selectedOpponent = (String)listOpponents.get(MathUtils.random(listOpponents.size() - 1));
        StringBuilder currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        String lastOpponent = StringList.get(currOpponents, fight, ",");
        while (selectedOpponent.equalsIgnoreCase(lastOpponent)) {
            selectedOpponent = (String)listOpponents.get(MathUtils.random(listOpponents.size() - 1));
        }
        return selectedOpponent;
    }

    public static String getNextOpponent(SlavePitsGame g) {
        if (g.saveGame.get("special") != null) {
            if (g.saveGame.get("special").contains("combat:")) {
                if (g.saveGame.get("special").split(":")[1].startsWith("fil")) {
                    Object[] specialFinal = g.saveGame.get("special").split(":");
                    String filteredOpponent = Tournament.getRandomOpponent(g, specialFinal[1].split("-")[0]);
                    specialFinal[1] = filteredOpponent + (specialFinal[1].contains("-") ? specialFinal[1].substring(specialFinal[1].indexOf("-")) : "");
                    specialFinal[2] = ((JSONObject)g.stats.get("opponents").get(filteredOpponent)).getString("portrait");
                    g.saveGame.put("special", StringUtils.join(specialFinal, ':'));
                    if (((String)specialFinal[1]).contains("leader") || ((String)specialFinal[1]).contains("oldcha")) {
                        StringBuilder currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
                        currOpponents = StringList.append(currOpponents, filteredOpponent, ",");
                        g.saveGame.put("opponents", currOpponents.toString());
                    }
                }
                return g.saveGame.get("special").split(":")[1].split("-")[0];
            }
            if (g.saveGame.get("special").equalsIgnoreCase("bet-double")) {
                return Tournament.getRandomOpponent(g, "");
            }
        }
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        StringBuilder currOpponents = StringList.create(g.saveGame.get("opponents"), ",");
        String selectedOpponent = "";
        if (StringList.size(currOpponents, ",") <= fight) {
            if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
                ArrayList<String> listOpponents = new ArrayList<String>();
                listOpponents.add("zola");
                listOpponents.add("min");
                listOpponents.add("scala");
                listOpponents.add("ayla");
                listOpponents.add("emma");
                listOpponents.add("diego");
                listOpponents.add("trent");
                listOpponents.add("boris");
                listOpponents.add("onur");
                listOpponents.add("adam");
                for (int i = 0; i < StringList.size(currOpponents, ","); ++i) {
                    String currCandidate = StringList.get(currOpponents, i, ",");
                    listOpponents.remove(currCandidate);
                }
                selectedOpponent = (String)listOpponents.get(MathUtils.random(listOpponents.size() - 1));
            } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
                StringBuilder filteredOpponents = new StringBuilder(currOpponents);
                for (int i = 6; i >= 0; --i) {
                    filteredOpponents = StringList.remove(filteredOpponents, i, ",");
                }
                ArrayList<String> listOpponents = new ArrayList<String>();
                listOpponents.add("tara");
                listOpponents.add("lea");
                listOpponents.add("diego");
                listOpponents.add("adam");
                listOpponents.add("onur");
                listOpponents.add("trent");
                listOpponents.add("emma");
                if (StringList.size(currOpponents, ",") > 10) {
                    listOpponents.add("ponte");
                    listOpponents.add("roe");
                    listOpponents.add("fenris");
                }
                for (int i = 0; i < StringList.size(filteredOpponents, ","); ++i) {
                    String currCandidate = StringList.get(filteredOpponents, i, ",");
                    listOpponents.remove(currCandidate);
                }
                selectedOpponent = (String)listOpponents.get(MathUtils.random(listOpponents.size() - 1));
            } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
                StringBuilder filteredOpponents = new StringBuilder(currOpponents);
                for (int i = 13; i >= 0; --i) {
                    filteredOpponents = StringList.remove(filteredOpponents, i, ",");
                }
                ArrayList<String> listOpponents = new ArrayList<String>();
                if (StringList.size(currOpponents, ",") < 17) {
                    listOpponents.add("boris");
                    listOpponents.add("tara");
                    listOpponents.add("zola");
                    listOpponents.add("ponte");
                    listOpponents.add("ayla");
                    listOpponents.add("lea");
                    listOpponents.add("min");
                } else if (StringList.size(currOpponents, ",") < 19) {
                    listOpponents.add("luntian");
                    listOpponents.add("blaire");
                    listOpponents.add("nattfrid");
                    listOpponents.add("fenris");
                    listOpponents.add("roe");
                    listOpponents.add("scala");
                } else if (StringList.size(currOpponents, ",") < 21) {
                    listOpponents.add("sarah");
                    listOpponents.add("rishi");
                    listOpponents.add("bastien");
                    listOpponents.add("san");
                }
                for (int i = 0; i < StringList.size(filteredOpponents, ","); ++i) {
                    String currCandidate = StringList.get(filteredOpponents, i, ",");
                    listOpponents.remove(currCandidate);
                }
                selectedOpponent = (String)listOpponents.get(MathUtils.random(listOpponents.size() - 1));
            } else if (g.saveGame.get("phase").equalsIgnoreCase("boss")) {
                ArrayList<String> listOpponents = new ArrayList<String>();
                if (Tournament.getRewardStock(g, "bosty1") == 1) {
                    listOpponents.add("tournamentboss1");
                } else if (Tournament.getRewardStock(g, "bosty2") == 1) {
                    listOpponents.add("tournamentboss2");
                } else if (Tournament.getRewardStock(g, "bosty3") == 1) {
                    listOpponents.add("tournamentboss3");
                } else {
                    if (!currOpponents.toString().contains("tournamentboss1")) {
                        listOpponents.add("tournamentboss1");
                    }
                    if (!currOpponents.toString().contains("tournamentboss2")) {
                        listOpponents.add("tournamentboss2");
                    }
                    if (!currOpponents.toString().contains("tournamentboss3")) {
                        listOpponents.add("tournamentboss3");
                    }
                }
                selectedOpponent = (String)listOpponents.get(MathUtils.random(listOpponents.size() - 1));
                currOpponents = StringList.append(currOpponents, selectedOpponent, ",");
                g.saveGame.put("opponents", currOpponents.toString());
                PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
            }
            currOpponents = StringList.append(currOpponents, selectedOpponent, ",");
            g.saveGame.put("opponents", currOpponents.toString());
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
        }
        return g.saveGame.get("opponents").split(",")[fight];
    }

    public static int getNextOpponentReputation(SlavePitsGame g) {
        int result = g.saveGame.get("special") != null && g.saveGame.get("special").contains("combat:") ? Integer.parseInt(g.stats.get("tournament").getString("combatReputationModifier")) : 0;
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            result += MathUtils.clamp(1 + fight * 100, 1, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("pits")).getString("maxReputation")));
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            result += MathUtils.clamp(1000 + (fight - 7) * 100, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("pits")).getString("maxReputation")), Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation")));
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            result += MathUtils.clamp(2000 + (fight - 14) * 100, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation")), Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("coliseum")).getString("maxReputation")));
        } else if (g.saveGame.get("phase").equalsIgnoreCase("boss")) {
            result = 3000;
        }
        return result;
    }

    public static String getNextPrepInfo(SlavePitsGame g, float lifeRatio, int profits, String markColor) {
        StringBuilder info = new StringBuilder();
        String colorMark = "##:" + markColor;
        if (g.campaignFighter.name.equalsIgnoreCase("bandit")) {
            if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
                info.append("p01");
            } else {
                info.append("ppitsmaster");
            }
        } else if (g.campaignFighter.name.equalsIgnoreCase("slave")) {
            info.append("p02");
        } else if (g.campaignFighter.name.equalsIgnoreCase("veteran")) {
            if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
                info.append("peiko");
            } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
                info.append("pcaravanmaster");
            } else {
                info.append("ppitsmaster");
            }
        } else {
            info.append("peiko");
        }
        info.append("$");
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        if (fight == 0) {
            info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.tournament.start", g.violenceFilter, colorMark));
        } else {
            if (profits >= 300) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.tournament.profits.high", g.violenceFilter, colorMark));
            } else if (profits >= 100) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.tournament.profits.medium", g.violenceFilter, colorMark));
            } else {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.tournament.profits.low", g.violenceFilter, colorMark));
            }
            info.append(System.getProperty("line.separator"));
            if ((double)lifeRatio >= 0.8) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.tournament.life.high", g.violenceFilter, colorMark));
            } else if ((double)lifeRatio >= 0.3) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.tournament.life.medium", g.violenceFilter, colorMark));
            } else {
                info.append(PropertiesReader.getMessage(g.gameMessages, "zone.master.tournament.life.low", g.violenceFilter, colorMark));
            }
        }
        info.append("$");
        String opponent = Tournament.getNextOpponent(g);
        JSONObject opponentData = (JSONObject)g.stats.get("opponents").get(opponent);
        if (g.saveGame.get("special") != null && g.saveGame.get("special").contains("combat:")) {
            opponent = g.saveGame.get("special").split(":")[1].split("-")[0];
        }
        if (g.saveGame.get("special") != null && g.saveGame.get("special").contains("combat:") && !g.saveGame.get("special").split(":")[2].equalsIgnoreCase("x")) {
            info.append(g.saveGame.get("special").split(":")[2]);
        } else {
            info.append(opponentData.getString("portrait"));
        }
        info.append("$");
        if (!PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".name", g.violenceFilter).equalsIgnoreCase("")) {
            info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".name", g.violenceFilter));
        } else {
            info.append(opponent);
        }
        info.append("$");
        if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            info.append("backgroundPrepPits.jpg");
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            info.append("backgroundPrepCaravan.jpg");
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum") || g.saveGame.get("phase").equalsIgnoreCase("boss")) {
            info.append("backgroundPrepColiseum.jpg");
        }
        info.append("$");
        if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            if (opponent.equalsIgnoreCase("diego") || opponent.equalsIgnoreCase("adam") || opponent.equalsIgnoreCase("onur") || opponent.equalsIgnoreCase("trent") || opponent.equalsIgnoreCase("emma")) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".infoextra"));
                info.append("\n\n");
            }
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum") && (opponent.equalsIgnoreCase("min") || opponent.equalsIgnoreCase("scala") || opponent.equalsIgnoreCase("ayla") || opponent.equalsIgnoreCase("zola") || opponent.equalsIgnoreCase("boris") || opponent.equalsIgnoreCase("tara") || opponent.equalsIgnoreCase("lea") || opponent.equalsIgnoreCase("fenris") || opponent.equalsIgnoreCase("ponte") || opponent.equalsIgnoreCase("roe"))) {
            info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".infoextra"));
            info.append("\n\n");
        }
        if (opponent.contains("boss")) {
            if (Tournament.getRewardStock(g, "infbos") > 0) {
                info.append(PropertiesReader.getMessage(g.gameMessages, "journal.reward.infbos"));
            } else {
                info.append("-");
            }
        } else {
            info.append(PropertiesReader.getMessage(g.gameMessages, "talk." + opponent + ".info"));
        }
        return info.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getNextScreen(SlavePitsGame g, String type, String option) {
        if (type.equalsIgnoreCase("prep")) {
            g.saveGame.remove("store");
            if (g.saveGame.get("special") == null || !g.saveGame.get("special").contains("combat:")) {
                g.saveGame.put("search", option + (g.saveGame.get("search").contains(option) ? ":2" : ""));
            }
            g.saveGame.put("delete", "true");
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
            Tournament.getNextFight(g);
            return true;
        }
        if (type.equalsIgnoreCase("event")) {
            String currCondition;
            g.campaignFighter.stamina = g.campaignFighter.maxStamina;
            g.campaignFighter.balance = g.campaignFighter.maxBalance;
            g.campaignFighter.surge = 0;
            if (option.equalsIgnoreCase("chapter")) {
                int fight = Integer.parseInt(g.saveGame.get("fight"));
                if (fight == 0 || fight == 21) {
                    g.saveGame.put("step", "fight");
                    g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                    g.saveGame.remove("delete");
                    PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                    g.tournamentSetupScreen = new TournamentSetupScreen(g);
                    g.setScreen(g.tournamentSetupScreen);
                    return true;
                } else {
                    StringBuilder currEvents = StringList.create(g.saveGame.get("events"), ",");
                    currEvents = StringList.append(currEvents, "chapter", ",");
                    g.saveGame.put("events", currEvents.toString());
                    g.saveGame.put("step", "event");
                    g.saveGame.put("eventStep", "2");
                    g.saveGame.remove("store");
                    Tournament.getNextEvent(g);
                    g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                    g.saveGame.remove("delete");
                    PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                }
                return true;
            }
            StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
            StringBuilder currQuests = StringList.create(g.saveGame.get("quests"), ";");
            String currReward = StringList.get(currRewards, 0, ";");
            String currChoice = StringList.get(currRewards, 1, ";");
            String currPrize = !currReward.equalsIgnoreCase("none") && !currChoice.equalsIgnoreCase("0") ? g.stats.get("tournament").getJSONObject("events").getJSONObject(g.saveGame.get("phase")).getJSONObject(currReward).getString("option" + currChoice) : "";
            String string = currCondition = !currReward.equalsIgnoreCase("none") && !currChoice.equalsIgnoreCase("0") ? g.stats.get("tournament").getJSONObject("events").getJSONObject(g.saveGame.get("phase")).getJSONObject(currReward).getString("condition" + currChoice) : "";
            if (!option.contains("skipcondition") && !currCondition.equalsIgnoreCase("")) {
                if (currCondition.startsWith("combat:") || currCondition.startsWith("bet-")) {
                    if (currCondition.startsWith("combat:")) {
                        if (currCondition.contains("randombandit") && MathUtils.randomBoolean()) {
                            g.saveGame.put("special", StringList.set(new StringBuilder(currCondition), 2, "p291", ":").toString());
                        } else if (currCondition.contains("randomworshipper") && MathUtils.randomBoolean()) {
                            g.saveGame.put("special", StringList.set(new StringBuilder(currCondition), 2, "p231", ":").toString());
                        } else if (currCondition.contains("randomcrafter") && MathUtils.randomBoolean()) {
                            g.saveGame.put("special", StringList.set(new StringBuilder(currCondition), 2, "p281", ":").toString());
                        } else {
                            g.saveGame.put("special", currCondition);
                        }
                    } else if (currCondition.equalsIgnoreCase("bet-double")) {
                        g.saveGame.put("special", currCondition + ":" + Tournament.getNextOpponent(g));
                    } else if (currCondition.equalsIgnoreCase("bet-scenario")) {
                        ArrayList<String> availableScenarios = new ArrayList<String>(g.stats.get("phases").getJSONObject("scenarios").keySet());
                        g.saveGame.put("special", currCondition + ":" + availableScenarios.get(MathUtils.random(availableScenarios.size() - 1)));
                    } else if (!currCondition.equalsIgnoreCase("debt")) {
                        g.saveGame.put("special", currCondition);
                    }
                    g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                    g.saveGame.remove("delete");
                    PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                    g.tournamentSetupScreen = new TournamentSetupScreen(g);
                    g.setScreen(g.tournamentSetupScreen);
                    return true;
                }
                String realCondition = g.stats.get("tournament").getJSONObject("conditions").getString(currCondition);
                if (realCondition.contains("#")) {
                    for (String orCondition : realCondition.split("#")) {
                        if (MathUtils.random(99) >= Integer.parseInt(orCondition.split(":")[0])) continue;
                        realCondition = orCondition;
                        break;
                    }
                }
                for (String subCondition : realCondition.split(";")) {
                    int removedItems;
                    String[] subConditionArr = subCondition.split(":");
                    if (subConditionArr[1].equalsIgnoreCase("unique") || subConditionArr[1].equalsIgnoreCase("debt")) continue;
                    if (subConditionArr[1].equalsIgnoreCase("weapon")) {
                        removedItems = Integer.parseInt(subConditionArr[2]) + MathUtils.random(Integer.parseInt(subConditionArr[3]) - Integer.parseInt(subConditionArr[2]));
                        while (removedItems > 0) {
                            String currWeapon = StringList.get(currRewards, MathUtils.random(StringList.size(currRewards, ";") - 1), ";");
                            if (!currWeapon.startsWith("hatchet") && !currWeapon.startsWith("mace") && !currWeapon.startsWith("sword") && !currWeapon.startsWith("axe") && !currWeapon.startsWith("hammer") && !currWeapon.startsWith("spear") && !currWeapon.startsWith("longsword") && !currWeapon.startsWith("whip") && !currWeapon.startsWith("shield") || Tournament.getRewardStock(g, currWeapon = currWeapon.substring(0, currWeapon.indexOf(":"))) <= 0) continue;
                            Tournament.setRewardStock(g, currWeapon, Tournament.getRewardStock(g, currWeapon) - 1);
                            --removedItems;
                        }
                        continue;
                    }
                    if (subConditionArr[1].equalsIgnoreCase("damage")) {
                        int removedLife = Integer.parseInt(subConditionArr[2]) + MathUtils.random(Integer.parseInt(subConditionArr[3]) - Integer.parseInt(subConditionArr[2]));
                        if (g.campaignFighter.life - (removedLife = g.campaignFighter.maxLife * removedLife / 100) < 0) {
                            removedLife = g.campaignFighter.life - 1;
                        }
                        g.campaignFighter.life -= removedLife;
                        g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                        continue;
                    }
                    if (subConditionArr[1].equalsIgnoreCase("sick")) {
                        int sick = Integer.parseInt(subConditionArr[2]) + MathUtils.random(Integer.parseInt(subConditionArr[3]) - Integer.parseInt(subConditionArr[2]));
                        g.saveGame.put("special", "sick:" + sick);
                        continue;
                    }
                    if (subConditionArr[1].equalsIgnoreCase("coin")) {
                        int removedProfits = Integer.parseInt(subConditionArr[2]) + MathUtils.random(Integer.parseInt(subConditionArr[3]) - Integer.parseInt(subConditionArr[2]));
                        g.saveGame.put("profits", "" + (Integer.parseInt(g.saveGame.get("profits")) - removedProfits));
                        continue;
                    }
                    removedItems = Integer.parseInt(subConditionArr[2]) + MathUtils.random(Integer.parseInt(subConditionArr[3]) - Integer.parseInt(subConditionArr[2]));
                    Tournament.setRewardStock(g, subConditionArr[1], Tournament.getRewardStock(g, subConditionArr[1]) - removedItems);
                }
            }
            StringBuilder showReward = new StringBuilder();
            if (!currPrize.equalsIgnoreCase("")) {
                String realReward = g.stats.get("tournament").getJSONObject("rewards").getString(currPrize);
                if (realReward.contains("#")) {
                    for (String orReward : realReward.split("#")) {
                        if (MathUtils.random(99) >= Integer.parseInt(orReward.split(":")[0]) || orReward.split(":")[1].equalsIgnoreCase("follow") && (orReward.split(":")[2].startsWith("quest") || g.stats.get("tournament").getJSONObject("conditions").has("no-" + orReward.split(":")[2]) && !Tournament.isValidCondition(g, g.stats.get("tournament").getJSONObject("conditions").getString("no-" + orReward.split(":")[2]))) && (!orReward.split(":")[2].startsWith("quest") || currQuests.indexOf(orReward.split(":")[2]) >= 0 || Tournament.getRewardStock(g, "no-" + orReward.split(":")[2]) > 0 || Tournament.getRewardStock(g, "questOngoing") != 0 || Integer.parseInt(g.saveGame.get("fight")) > g.stats.get("tournament").getJSONObject("quests").getJSONObject("fightLimit").getInt(orReward.split(":")[2]))) continue;
                        realReward = orReward;
                        break;
                    }
                }
                StringBuilder finalReward = new StringBuilder(realReward);
                int i = 0;
                while (i < StringList.size(finalReward, ";")) {
                    int fight;
                    StringBuilder currSubreward = new StringBuilder(StringList.get(finalReward, i, ";"));
                    if (MathUtils.random(99) >= Integer.parseInt(StringList.get(currSubreward, 0, ":"))) continue;
                    String rewardType = StringList.get(currSubreward, 1, ":");
                    if (rewardType.startsWith("dealer")) {
                        Tournament.getServicesStore(g, (currSubreward.toString().contains("seer") ? "seer:" : (currSubreward.toString().contains("veteran") ? "veteran:" : "all:")) + StringList.get(currSubreward, 2, ":") + ":" + StringList.get(currSubreward, 3, ":"));
                        g.servicesMenuScreen = new ServicesMenuScreen(g, g.tournamentEventScreen, g.campaignFighter, "", 0, "", Integer.parseInt(g.saveGame.get("profits")), currSubreward.toString().contains("surplus") ? "surplus" : (currSubreward.toString().contains("smuggler") ? "smuggler" : (currSubreward.toString().contains("sell") ? "sell" : "")));
                        g.setScreen(g.servicesMenuScreen);
                        return false;
                    }
                    if (rewardType.startsWith("master")) {
                        int freeTalents = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                        if (g.saveGame.get("store") == null && freeTalents > 0) {
                            g.saveGame.put("store", "" + freeTalents);
                        }
                        g.talentsMenuScreen = new TalentsMenuScreen(g, g.tournamentEventScreen, g.campaignFighter, "", 0, Integer.parseInt(g.saveGame.get("profits")), currSubreward.toString().contains("onlyfree"));
                        g.setScreen(g.talentsMenuScreen);
                        return false;
                    }
                    if (rewardType.startsWith("smith")) {
                        Tournament.getWeaponsStore(g, (currSubreward.toString().contains("armor") ? "armor:" : "all:") + StringList.get(currSubreward, 2, ":") + ":" + StringList.get(currSubreward, 3, ":"));
                        g.smithMenuScreen = new SmithMenuScreen(g, g.tournamentEventScreen, g.campaignFighter, Integer.parseInt(g.saveGame.get("profits")), currSubreward.toString().contains("surplus"));
                        g.setScreen(g.smithMenuScreen);
                        return false;
                    }
                    if (rewardType.startsWith("trainer")) {
                        int freeTraining = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                        if (g.saveGame.get("store") == null && freeTraining > 0) {
                            g.saveGame.put("store", "" + freeTraining);
                        }
                        g.trainerMenuScreen = new TrainerMenuScreen(g, g.tournamentEventScreen, g.campaignFighter, Integer.parseInt(g.saveGame.get("profits")), currSubreward.toString().contains("onlyfree"));
                        g.setScreen(g.trainerMenuScreen);
                        return false;
                    }
                    if (rewardType.startsWith("follow")) {
                        fight = Integer.parseInt(g.saveGame.get("fight"));
                        StringBuilder currEvents = StringList.create(g.saveGame.get("events"), ",");
                        currEvents = StringList.set(currEvents, StringList.size(currEvents, ",") - 1, StringList.get(currSubreward, 2, ":"), ",");
                        g.saveGame.put("events", currEvents.toString());
                        currRewards = StringList.create(g.saveGame.get("rewards"), ";");
                        currRewards = StringList.set(currRewards, 0, StringList.get(currSubreward, 2, ":"), ";");
                        currRewards = StringList.set(currRewards, 1, "1", ";");
                        g.saveGame.put("rewards", currRewards.toString());
                        g.saveGame.put("step", "event");
                        g.saveGame.remove("store");
                        Tournament.getNextEvent(g);
                        g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                        g.saveGame.remove("delete");
                        PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                        return true;
                    }
                    if (rewardType.equalsIgnoreCase("") || rewardType.equalsIgnoreCase("continue")) {
                        g.saveGame.remove("store");
                        if (g.saveGame.get("eventStep").equalsIgnoreCase("2")) {
                            g.saveGame.put("step", "fight");
                            g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                            g.saveGame.remove("delete");
                            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                            g.tournamentSetupScreen = new TournamentSetupScreen(g);
                            g.setScreen(g.tournamentSetupScreen);
                            return true;
                        }
                        g.saveGame.put("eventStep", "2");
                        g.saveGame.put("step", "event");
                        Tournament.getNextEvent(g);
                        g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                        g.saveGame.remove("delete");
                        PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                        return true;
                    }
                    if (rewardType.equalsIgnoreCase("quest1")) {
                        fight = Integer.parseInt(g.saveGame.get("fight"));
                        if ((fight += MathUtils.clamp(MathUtils.random(2) + 1, 1, 3)) >= 6) {
                            fight = 6;
                        }
                        currQuests = StringList.append(currQuests, "quest1", ",");
                        g.saveGame.put("quests", currQuests.toString());
                        Tournament.setRewardStock(g, "questOngoing", 1);
                        Tournament.setRewardStock(g, rewardType, fight);
                    } else if (rewardType.startsWith("quest11") || rewardType.startsWith("quest12")) {
                        g.saveGame.put("special", rewardType);
                    } else if (rewardType.startsWith("quest2")) {
                        fight = Integer.parseInt(g.saveGame.get("fight"));
                        if ((fight += MathUtils.clamp(MathUtils.random(2) + 1, 1, 3)) >= 6) {
                            fight = 6;
                        }
                        currQuests = StringList.append(currQuests, "quest2", ",");
                        g.saveGame.put("quests", currQuests.toString());
                        Tournament.setRewardStock(g, "questOngoing", 1);
                        Tournament.setRewardStock(g, rewardType, fight);
                    } else if (rewardType.equalsIgnoreCase("quest3")) {
                        currQuests = StringList.append(currQuests, "quest3", ",");
                        g.saveGame.put("quests", currQuests.toString());
                    } else if (rewardType.equalsIgnoreCase("quest4")) {
                        fight = Integer.parseInt(g.saveGame.get("fight")) + 1;
                        Tournament.setRewardStock(g, "quest4", fight);
                        currQuests = StringList.append(currQuests, "quest4", ",");
                        g.saveGame.put("quests", currQuests.toString());
                        Tournament.setRewardStock(g, "questOngoing", 1);
                    } else if (rewardType.equalsIgnoreCase("quest5")) {
                        fight = Integer.parseInt(g.saveGame.get("fight")) + 1;
                        Tournament.setRewardStock(g, "quest5", fight);
                        currQuests = StringList.append(currQuests, "quest5", ",");
                        g.saveGame.put("quests", currQuests.toString());
                        Tournament.setRewardStock(g, "questOngoing", 1);
                    } else if (rewardType.equalsIgnoreCase("quest6")) {
                        fight = Integer.parseInt(g.saveGame.get("fight"));
                        if ((fight += MathUtils.clamp(MathUtils.random(2) + 1, 1, 3)) >= 13) {
                            fight = 13;
                        }
                        Tournament.setRewardStock(g, "quest6", fight);
                        currQuests = StringList.append(currQuests, "quest6", ",");
                        g.saveGame.put("quests", currQuests.toString());
                        Tournament.setRewardStock(g, "questOngoing", 1);
                        Tournament.setRewardStock(g, "maintenance", Tournament.getRewardStock(g, "maintenance") + 25);
                        showReward.append("pay:");
                        showReward.append(25);
                        showReward.append(";");
                    } else {
                        if (rewardType.equalsIgnoreCase("quest7")) {
                            currQuests = StringList.append(currQuests, "quest7", ",");
                            g.saveGame.put("quests", currQuests.toString());
                            fight = Integer.parseInt(g.saveGame.get("fight"));
                            StringBuilder currEvents = StringList.create(g.saveGame.get("events"), ",");
                            currEvents = StringList.set(currEvents, StringList.size(currEvents, ",") - 1, "quest70", ",");
                            g.saveGame.put("events", currEvents.toString());
                            Tournament.setRewardStock(g, "quest7", 3);
                            Tournament.setRewardStock(g, "questOngoing", 1);
                            currRewards = StringList.create(g.saveGame.get("rewards"), ";");
                            currRewards = StringList.set(currRewards, 0, "quest70", ";");
                            currRewards = StringList.set(currRewards, 1, "1", ";");
                            g.saveGame.put("rewards", currRewards.toString());
                            g.saveGame.put("step", "event");
                            g.saveGame.remove("store");
                            Tournament.getNextEvent(g);
                            g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                            g.saveGame.remove("delete");
                            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                            return true;
                        }
                        if (rewardType.equalsIgnoreCase("quest8")) {
                            fight = Integer.parseInt(g.saveGame.get("fight")) + 1;
                            currQuests = StringList.append(currQuests, "quest8", ",");
                            g.saveGame.put("quests", currQuests.toString());
                            Tournament.setRewardStock(g, "questOngoing", 1);
                            Tournament.setRewardStock(g, rewardType, fight);
                        } else if (rewardType.startsWith("quest8")) {
                            g.saveGame.put("special", rewardType);
                        } else if (rewardType.equalsIgnoreCase("quest9")) {
                            currQuests = StringList.append(currQuests, "quest9", ",");
                            g.saveGame.put("quests", currQuests.toString());
                            Tournament.setRewardStock(g, "questOngoing", 1);
                            Tournament.setRewardStock(g, rewardType, 1);
                        } else {
                            int healing;
                            int addedProfits;
                            int addedItems;
                            if (rewardType.equalsIgnoreCase("quest10")) {
                                currQuests = StringList.append(currQuests, "quest10", ",");
                                g.saveGame.put("quests", currQuests.toString());
                                fight = Integer.parseInt(g.saveGame.get("fight"));
                                StringBuilder currEvents = StringList.create(g.saveGame.get("events"), ",");
                                currEvents = StringList.set(currEvents, StringList.size(currEvents, ",") - 1, "quest100", ",");
                                g.saveGame.put("events", currEvents.toString());
                                Tournament.setRewardStock(g, "quest10", 1);
                                Tournament.setRewardStock(g, "questOngoing", 1);
                                currRewards = StringList.create(g.saveGame.get("rewards"), ";");
                                currRewards = StringList.set(currRewards, 0, "quest100", ";");
                                currRewards = StringList.set(currRewards, 1, "1", ";");
                                g.saveGame.put("rewards", currRewards.toString());
                                g.saveGame.put("step", "event");
                                g.saveGame.remove("store");
                                Tournament.getNextEvent(g);
                                g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                                g.saveGame.remove("delete");
                                PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                                return true;
                            }
                            if (rewardType.equalsIgnoreCase("bostyp")) {
                                Tournament.setRewardStock(g, "bosty" + (MathUtils.random(2) + 1), 1);
                            } else if (rewardType.equalsIgnoreCase("instructor")) {
                                int chosenTalent;
                                addedItems = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                Tournament.setRewardStock(g, rewardType, Tournament.getRewardStock(g, rewardType) + addedItems);
                                int randomTalents = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":"))) + Tournament.getRewardStock(g, "quest6") / 2;
                                Tournament.setRewardStock(g, "quest6", 0);
                                for (int k = 0; k < randomTalents && (chosenTalent = Tournament.getRandomTalent(g, g.campaignFighter)) != -1; ++k) {
                                    g.campaignFighter.talents.put("" + chosenTalent, -1);
                                }
                                g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                            } else if (rewardType.equalsIgnoreCase("guild")) {
                                addedProfits = Tournament.getRewardStock(g, "quest7") == 3 ? 750 : (Tournament.getRewardStock(g, "quest7") == 2 ? 375 : (Tournament.getRewardStock(g, "quest7") == 1 ? 125 : 0));
                                g.saveGame.put("profits", "" + (Integer.parseInt(g.saveGame.get("profits")) + addedProfits));
                                showReward.append("coin:");
                                showReward.append(addedProfits);
                                showReward.append(";");
                                Tournament.setRewardStock(g, rewardType, Tournament.getRewardStock(g, "quest7"));
                                Tournament.setRewardStock(g, "quest7", 0);
                                Tournament.setRewardStock(g, "questOngoing", 0);
                            } else if (rewardType.equalsIgnoreCase("rest")) {
                                int addedLife = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                if (g.campaignFighter.life + (addedLife = (g.campaignFighter.maxLife - 5000) * addedLife / 100) > g.campaignFighter.maxLife) {
                                    addedLife = g.campaignFighter.maxLife - Math.min(g.campaignFighter.life, g.campaignFighter.maxLife);
                                }
                                g.campaignFighter.life += addedLife;
                                g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                                showReward.append("healing");
                                showReward.append(":");
                                showReward.append(addedLife / 10);
                                showReward.append(";");
                            } else if (rewardType.equalsIgnoreCase("gamble")) {
                                addedProfits = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                int rolledDice = MathUtils.random(99) + 1;
                                if (rolledDice < 17) {
                                    addedProfits *= 2;
                                } else if (rolledDice > 66) {
                                    addedProfits = 0;
                                }
                                g.saveGame.put("profits", "" + (Integer.parseInt(g.saveGame.get("profits")) + addedProfits));
                                showReward.append("coin:");
                                showReward.append(addedProfits);
                                showReward.append(";");
                            } else if (rewardType.equalsIgnoreCase("games")) {
                                addedProfits = 0;
                                int numGames = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                for (int k = 0; k < numGames; ++k) {
                                    int rolledDice = MathUtils.random(99) + 1;
                                    addedProfits = rolledDice < 17 ? 100 : (rolledDice < 67 ? 30 : 0);
                                }
                                g.saveGame.put("profits", "" + (Integer.parseInt(g.saveGame.get("profits")) + addedProfits));
                                showReward.append("coin:");
                                showReward.append(addedProfits);
                                showReward.append(";");
                            } else if (rewardType.equalsIgnoreCase("loan")) {
                                fight = Integer.parseInt(g.saveGame.get("fight"));
                                int addedProfits2 = Float.valueOf((float)((21.0 - (double)fight) / 21.0 * (double)Float.parseFloat(StringList.get(currSubreward, 2, ":")))).intValue();
                                int interest = Float.valueOf((float)((21.0 - (double)fight) / 21.0 * (double)Float.parseFloat(StringList.get(currSubreward, 3, ":")))).intValue();
                                g.saveGame.put("profits", "" + (Integer.parseInt(g.saveGame.get("profits")) + addedProfits2));
                                Tournament.setRewardStock(g, "loan", Tournament.getRewardStock(g, "loan") + addedProfits2);
                                Tournament.setRewardStock(g, "maintenance", Tournament.getRewardStock(g, "maintenance") + interest);
                                showReward.append("coin:");
                                showReward.append(addedProfits2);
                                showReward.append(";");
                                showReward.append("pay:");
                                showReward.append(interest);
                                showReward.append(";");
                            } else if (rewardType.equalsIgnoreCase("patronage")) {
                                fight = Integer.parseInt(g.saveGame.get("fight"));
                                int extraPay = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                Tournament.setRewardStock(g, "maintenance", Tournament.getRewardStock(g, "maintenance") - (extraPay /= 21 - fight));
                                showReward.append("gain:");
                                showReward.append(extraPay);
                                showReward.append(";");
                                Tournament.setRewardStock(g, rewardType, 1);
                            } else if (rewardType.equalsIgnoreCase("apprentice")) {
                                int upgradeweapon = Integer.parseInt(StringList.get(currSubreward, 2, ":"));
                                int maintenance = Integer.parseInt(StringList.get(currSubreward, 3, ":"));
                                Tournament.setRewardStock(g, "apprentice", Tournament.getRewardStock(g, "apprentice") + upgradeweapon);
                                Tournament.setRewardStock(g, "maintenance", Tournament.getRewardStock(g, "maintenance") + maintenance);
                                showReward.append("pay:");
                                showReward.append(maintenance);
                                showReward.append(";");
                            } else if (rewardType.equalsIgnoreCase("attendant")) {
                                healing = Integer.parseInt(StringList.get(currSubreward, 2, ":"));
                                int maintenance = Integer.parseInt(StringList.get(currSubreward, 3, ":"));
                                Tournament.setRewardStock(g, "attendant", Tournament.getRewardStock(g, "attendant") + healing);
                                Tournament.setRewardStock(g, "maintenance", Tournament.getRewardStock(g, "maintenance") + maintenance);
                                showReward.append("healing:");
                                showReward.append(healing);
                                showReward.append("%;");
                                showReward.append("pay:");
                                showReward.append(maintenance);
                                showReward.append(";");
                            } else if (rewardType.equalsIgnoreCase("bard")) {
                                fight = Integer.parseInt(g.saveGame.get("fight"));
                                int extraPay = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                Tournament.setRewardStock(g, "bard", Tournament.getRewardStock(g, "bard") + extraPay);
                                Tournament.setRewardStock(g, "maintenance", Tournament.getRewardStock(g, "maintenance") - (extraPay += fight));
                            } else if (rewardType.equalsIgnoreCase("kid")) {
                                int itemChance = Integer.parseInt(StringList.get(currSubreward, 2, ":"));
                                int maintenance = Integer.parseInt(StringList.get(currSubreward, 3, ":"));
                                Tournament.setRewardStock(g, "kid", Tournament.getRewardStock(g, "kid") + itemChance);
                                Tournament.setRewardStock(g, "maintenance", Tournament.getRewardStock(g, "maintenance") + maintenance);
                                showReward.append("pay:");
                                showReward.append(maintenance);
                                showReward.append(";");
                            } else if (rewardType.equalsIgnoreCase("tinkerer")) {
                                int armorChance = Integer.parseInt(StringList.get(currSubreward, 2, ":"));
                                int maintenance = Integer.parseInt(StringList.get(currSubreward, 3, ":"));
                                Tournament.setRewardStock(g, "tinkerer", Tournament.getRewardStock(g, "tinkerer") + armorChance);
                                Tournament.setRewardStock(g, "maintenance", Tournament.getRewardStock(g, "maintenance") + maintenance);
                                showReward.append("pay:");
                                showReward.append(maintenance);
                                showReward.append(";");
                            } else if (rewardType.equalsIgnoreCase("bet")) {
                                addedItems = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                Tournament.setRewardStock(g, rewardType, Tournament.getRewardStock(g, rewardType) + addedItems);
                                showReward.append(rewardType);
                                showReward.append(":");
                                showReward.append(String.format("%.1f", Float.valueOf(new Float(addedItems).floatValue() / 100.0f)));
                                showReward.append(";");
                            } else if (rewardType.equalsIgnoreCase("life")) {
                                healing = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                if (g.campaignFighter.life + (healing = g.campaignFighter.maxLife * healing / 100) > g.campaignFighter.maxLife) {
                                    healing = g.campaignFighter.maxLife - g.campaignFighter.life;
                                }
                                g.campaignFighter.life += healing;
                                showReward.append("healing:");
                                showReward.append(healing / 10);
                            } else if (rewardType.equalsIgnoreCase("poison")) {
                                int poison = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                Tournament.setRewardStock(g, rewardType, Tournament.getRewardStock(g, rewardType) + poison);
                            } else if (rewardType.equalsIgnoreCase("coin")) {
                                addedProfits = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                g.saveGame.put("profits", "" + (Integer.parseInt(g.saveGame.get("profits")) + addedProfits));
                                showReward.append(rewardType);
                                showReward.append(":");
                                showReward.append(addedProfits);
                                showReward.append(";");
                            } else if (rewardType.equalsIgnoreCase("coinlost")) {
                                addedProfits = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                if (addedProfits > Integer.parseInt(g.saveGame.get("profits"))) {
                                    addedProfits = Integer.parseInt(g.saveGame.get("profits"));
                                }
                                g.saveGame.put("profits", "" + (Integer.parseInt(g.saveGame.get("profits")) - addedProfits));
                                showReward.append("coin");
                                showReward.append(":-");
                                showReward.append(addedProfits);
                                showReward.append(";");
                            } else if (rewardType.equalsIgnoreCase("weapon")) {
                                for (addedItems = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":"))); addedItems > 0; --addedItems) {
                                    String currWeapon = Tournament.getRandomWeapon("nodagger");
                                    Tournament.setRewardStock(g, currWeapon, Tournament.getRewardStock(g, currWeapon) + 1);
                                    showReward.append(currWeapon);
                                    showReward.append(":");
                                    showReward.append("1");
                                    showReward.append(";");
                                }
                            } else if (rewardType.startsWith("default")) {
                                int rewardMultiplier = 100;
                                if (rewardType.equalsIgnoreCase("default-multiplier")) {
                                    rewardMultiplier = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                }
                                String[] defaultRewardArr = g.stats.get("tournament").getJSONObject("rewards").getString("default").split(":");
                                rewardMultiplier = rewardMultiplier * (Integer.parseInt(defaultRewardArr[2]) + MathUtils.random(Integer.parseInt(defaultRewardArr[3]) - Integer.parseInt(defaultRewardArr[2]))) / 100;
                                String defaultRealReward = g.stats.get("tournament").getJSONObject("rewards").getString("default-" + g.saveGame.get("difficulty"));
                                for (String currDefaultReward : defaultRealReward.split(";")) {
                                    StringBuilder finalCurrDefaultReward = StringList.set(new StringBuilder(currDefaultReward), 2, "" + Integer.parseInt(currDefaultReward.split(":")[2]) * rewardMultiplier / 100, ":");
                                    finalCurrDefaultReward = StringList.set(finalCurrDefaultReward, 3, "" + Integer.parseInt(currDefaultReward.split(":")[3]) * rewardMultiplier / 100, ":");
                                    finalReward = StringList.insert(finalReward, i + 1, finalCurrDefaultReward.toString(), ";");
                                }
                            } else if (rewardType.equalsIgnoreCase("concoction") || rewardType.equalsIgnoreCase("trade-help") || rewardType.equalsIgnoreCase("trade-route") || rewardType.equalsIgnoreCase("dagger-fighting") || rewardType.equalsIgnoreCase("stimulant") || rewardType.equalsIgnoreCase("crafts") || rewardType.equalsIgnoreCase("cabal-informant") || rewardType.equalsIgnoreCase("legkil") || rewardType.equalsIgnoreCase("carrier") || rewardType.equalsIgnoreCase("maintenance") || rewardType.startsWith("no-")) {
                                addedItems = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                Tournament.setRewardStock(g, rewardType, Tournament.getRewardStock(g, rewardType) + addedItems);
                            } else {
                                addedItems = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                                if (addedItems != 0) {
                                    Tournament.setRewardStock(g, rewardType, Tournament.getRewardStock(g, rewardType) + addedItems);
                                    showReward.append(rewardType);
                                    showReward.append(":");
                                    showReward.append(addedItems);
                                    showReward.append(";");
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            if (showReward.length() > 0) {
                if (g.saveGame.get("eventStep").equalsIgnoreCase("2")) {
                    g.saveGame.put("step", "fight");
                }
                g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                g.saveGame.remove("delete");
                PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                g.tournamentEventScreen.rewardLabel.setText(PropertiesReader.getMessage(g.gameMessages, "common.reward") + ":\n\n" + Tournament.checkRewardText(g, showReward.substring(0, showReward.length() - 1)));
                UIHelpers.fixLabelFontSize(g.tournamentEventScreen.rewardLabel, g.viewHeight.floatValue() / (g.heightBASE.floatValue() * 3.0f / 4.0f), 0.0f, g.tournamentEventScreen.rewardBackground.getHeight() * 3.0f / 4.0f);
                g.tournamentEventScreen.rewardLabel.setHeight(g.tournamentEventScreen.rewardLabel.getPrefHeight());
                g.tournamentEventScreen.rewardLabel.setY(g.tournamentEventScreen.rewardBackground.getY() + g.tournamentEventScreen.rewardBackground.getHeight() * 95.0f / 100.0f - g.tournamentEventScreen.rewardLabel.getPrefHeight());
                g.tournamentEventScreen.rewardLabel.layout();
                g.tournamentEventScreen.rewardOverlay.setVisible(true);
                g.tournamentEventScreen.rewardBackground.setVisible(true);
                g.tournamentEventScreen.rewardLabel.setVisible(true);
                g.tournamentEventScreen.rewardButton.setVisible(true);
                return false;
            }
            if (g.saveGame.get("eventStep").equalsIgnoreCase("2")) {
                g.saveGame.put("step", "fight");
                g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                g.saveGame.remove("delete");
                PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                g.tournamentSetupScreen = new TournamentSetupScreen(g);
                g.setScreen(g.tournamentSetupScreen);
                return true;
            }
            g.saveGame.put("eventStep", "2");
            g.saveGame.put("step", "event");
            g.saveGame.remove("store");
            Tournament.getNextEvent(g);
            g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
            g.saveGame.remove("delete");
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
            return true;
        }
        if (type.equalsIgnoreCase("fight")) {
            g.saveGame.remove("store");
            if (g.saveGame.get("aftermatch").equalsIgnoreCase("gameover")) {
                g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "game.settings.gameover"), "FF0000FF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "mainmenu;fadein:1.0;", "gameover:0.5");
                g.setScreen(g.messageScreen);
                return true;
            } else if (g.saveGame.get("aftermatch").equalsIgnoreCase("skipcondition")) {
                Tournament.getNextScreen(g, "event", "skipcondition");
                return true;
            } else if (g.saveGame.get("aftermatch").equalsIgnoreCase("day")) {
                g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "game.settings.day") + " " + (Integer.parseInt(g.saveGame.get("fight")) + 1 + Integer.parseInt(g.saveGame.get("lostDays"))), "E6E6E6FF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "fighttimer:3.5;fadein:0.5;2.0;1.0", "day:0.5");
                g.setScreen(g.messageScreen);
                return true;
            } else if (g.saveGame.get("aftermatch").equalsIgnoreCase("fight")) {
                g.saveGame.put("delete", "true");
                PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                Tournament.getNextFight(g);
                return true;
            } else {
                Tournament.getFixedEvent(g, g.saveGame.get("aftermatch"));
            }
            return true;
        } else if (type.equalsIgnoreCase("day")) {
            g.saveGame.remove("store");
            g.saveGame.put("step", "event");
            g.saveGame.put("eventStep", "1");
            Tournament.getNextEvent(g);
            g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
            g.saveGame.remove("delete");
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
            return true;
        } else if (type.equalsIgnoreCase("reward")) {
            g.saveGame.remove("store");
            if (g.saveGame.get("eventStep").equalsIgnoreCase("2")) {
                g.saveGame.put("step", "fight");
                g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                g.saveGame.remove("delete");
                PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                g.tournamentSetupScreen = new TournamentSetupScreen(g);
                g.setScreen(g.tournamentSetupScreen);
                return true;
            } else {
                g.saveGame.put("eventStep", "2");
                g.saveGame.put("step", "event");
                Tournament.getNextEvent(g);
                g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                g.saveGame.remove("delete");
                PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
            }
            return true;
        } else if (type.equalsIgnoreCase("end")) {
            if (g.campaignFighter.name.equalsIgnoreCase("soldier")) {
                g.achievements.put("tournament.warrior", "unlocked");
            } else if (g.campaignFighter.name.equalsIgnoreCase("warrior")) {
                g.achievements.put("tournament.bandit", "unlocked");
            } else if (g.campaignFighter.name.equalsIgnoreCase("bandit")) {
                g.achievements.put("tournament.slave", "unlocked");
            } else if (g.campaignFighter.name.equalsIgnoreCase("slave")) {
                g.achievements.put("tournament.veteran", "unlocked");
            }
            PropertiesReader.saveAchievements(g.achievements, g.mail, g.key, g.debugMode);
            g.saveGame.put("delete", "true");
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
            g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "game.settings.endfree"), "00B3B3FF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "mainmenu;fadein:1.0;", "chapter");
            g.setScreen(g.messageScreen);
            return true;
        } else {
            g.saveGame.remove("store");
            Tournament.getFixedEvent(g, type);
        }
        return true;
    }

    public static void getNextFight(SlavePitsGame g) {
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        g.saveGame.put("delete", "true");
        PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
        if (g.saveGame.get("special") != null && g.saveGame.get("special").contains("combat:")) {
            String music = g.saveGame.get("special").split(":")[4];
            if (music.equalsIgnoreCase("x")) {
                music = "sl0" + (5 + MathUtils.random(3));
            }
            String arena = g.saveGame.get("special").split(":")[3];
            Fighter opponent = Fighter.createOpponent(g, g.saveGame.get("special").split(":")[1].split("-")[0], Tournament.getNextOpponentReputation(g), false);
            opponent = Fighter.changeAppearance(g, g.saveGame.get("special").split(":")[2], opponent, false, false);
            g.combatScreen = new CombatScreen(g, g.campaignFighter, opponent, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get(g.saveGame.get("phase"))).getString("maxReputation")), arena, music, g.saveGame.get("difficulty"), g.campaignFighter != null && !g.campaignFighter.behavior.equalsIgnoreCase(""), MathUtils.random(1) + 1, g.saveGame.get("special") != null && (g.saveGame.get("special").contains("bet-performance") || g.saveGame.get("special").contains("-time")) ? Integer.parseInt(g.stats.get("tournament").getString("timeLimit")) : 0, g.saveGame.get("special") != null && g.saveGame.get("special").contains("bet-scenario") ? g.saveGame.get("special").split(":")[1] : "");
            Fighter.loadFighterAssets(g, opponent, true, false);
            Fighter.loadFighterAssets(g, g.campaignFighter, false, false);
            g.combatScreen.create();
            g.setScreen(g.combatScreen);
        } else if (g.saveGame.get("phase").equalsIgnoreCase("pits")) {
            String music = "sl09";
            if (fight > 0 && MathUtils.random(100) > 40) {
                music = "sl0" + (5 + MathUtils.random(3));
            }
            String arena = MathUtils.random(1) == 0 ? "pits1" : "pits2";
            Fighter opponent = Fighter.createOpponent(g, Tournament.getNextOpponent(g), Tournament.getNextOpponentReputation(g), false);
            g.combatScreen = new CombatScreen(g, g.campaignFighter, opponent, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("pits")).getString("maxReputation")), arena, music, g.saveGame.get("difficulty"), g.campaignFighter != null && !g.campaignFighter.behavior.equalsIgnoreCase(""), MathUtils.random(1) + 1, g.saveGame.get("special") != null && (g.saveGame.get("special").contains("bet-performance") || g.saveGame.get("special").contains("-time")) ? Integer.parseInt(g.stats.get("tournament").getString("timeLimit")) : 0, g.saveGame.get("special") != null && g.saveGame.get("special").contains("bet-scenario") ? g.saveGame.get("special").split(":")[1] : "");
            Fighter.loadFighterAssets(g, opponent, true, false);
            Fighter.loadFighterAssets(g, g.campaignFighter, false, false);
            g.combatScreen.create();
            g.setScreen(g.combatScreen);
        } else if (g.saveGame.get("phase").equalsIgnoreCase("caravan")) {
            String music = "sl10";
            if (fight > 7 && MathUtils.random(100) > 40) {
                music = "sl0" + (5 + MathUtils.random(3));
            }
            String arena = MathUtils.random(1) == 0 ? "caravan1" : "caravan2";
            Fighter opponent = Fighter.createOpponent(g, Tournament.getNextOpponent(g), Tournament.getNextOpponentReputation(g), false);
            g.combatScreen = new CombatScreen(g, g.campaignFighter, opponent, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation")), arena, music, g.saveGame.get("difficulty"), g.campaignFighter != null && !g.campaignFighter.behavior.equalsIgnoreCase(""), MathUtils.random(1) + 1, g.saveGame.get("special") != null && (g.saveGame.get("special").contains("bet-performance") || g.saveGame.get("special").contains("-time")) ? Integer.parseInt(g.stats.get("tournament").getString("timeLimit")) : 0, g.saveGame.get("special") != null && g.saveGame.get("special").contains("bet-scenario") ? g.saveGame.get("special").split(":")[1] : "");
            Fighter.loadFighterAssets(g, opponent, true, false);
            Fighter.loadFighterAssets(g, g.campaignFighter, false, false);
            g.combatScreen.create();
            g.setScreen(g.combatScreen);
        } else if (g.saveGame.get("phase").equalsIgnoreCase("coliseum")) {
            String music = "sl11";
            if (fight > 14 && MathUtils.random(100) > 40) {
                music = "sl0" + (5 + MathUtils.random(3));
            }
            String arena = MathUtils.random(1) == 0 ? "coliseum1" : "coliseum2";
            Fighter opponent = Fighter.createOpponent(g, Tournament.getNextOpponent(g), Tournament.getNextOpponentReputation(g), false);
            if (Tournament.getRewardStock(g, "poison") > 0) {
                opponent.life = opponent.maxLife * (100 - Tournament.getRewardStock(g, "poison")) / 100;
                Tournament.setRewardStock(g, "poison", 0);
            }
            g.combatScreen = new CombatScreen(g, g.campaignFighter, opponent, Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("coliseum")).getString("maxReputation")), arena, music, g.saveGame.get("difficulty"), g.campaignFighter != null && !g.campaignFighter.behavior.equalsIgnoreCase(""), MathUtils.random(1) + 1, g.saveGame.get("special") != null && (g.saveGame.get("special").contains("bet-performance") || g.saveGame.get("special").contains("-time")) ? Integer.parseInt(g.stats.get("tournament").getString("timeLimit")) : 0, g.saveGame.get("special") != null && g.saveGame.get("special").contains("bet-scenario") ? g.saveGame.get("special").split(":")[1] : "");
            Fighter.loadFighterAssets(g, opponent, true, false);
            Fighter.loadFighterAssets(g, g.campaignFighter, false, false);
            g.combatScreen.create();
            g.setScreen(g.combatScreen);
        } else if (g.saveGame.get("phase").equalsIgnoreCase("boss")) {
            String music = "sl14t";
            String arena = "boss3";
            Fighter finalBoss = Fighter.createOpponent(g, Tournament.getNextOpponent(g), Tournament.getNextOpponentReputation(g), false);
            finalBoss.name = finalBoss.name.replace("tournament", "");
            if (finalBoss.name.equalsIgnoreCase("boss1")) {
                music = "sl12";
            } else if (finalBoss.name.equalsIgnoreCase("boss2")) {
                music = "sl13";
            } else if (finalBoss.name.equalsIgnoreCase("boss3")) {
                finalBoss.life = 12000;
            }
            g.combatScreen = new CombatScreen(g, g.campaignFighter, finalBoss, 3000, arena, music, g.saveGame.get("difficulty"), g.campaignFighter != null && !g.campaignFighter.behavior.equalsIgnoreCase(""), MathUtils.random(1) + 1, 0, finalBoss.name.equalsIgnoreCase("boss3") ? "coal" : "");
            Fighter.loadFighterAssets(g, finalBoss, true, false);
            Fighter.loadFighterAssets(g, g.campaignFighter, false, false);
            g.combatScreen.create();
            g.setScreen(g.combatScreen);
        }
    }

    public static void getNextEvent(SlavePitsGame g) {
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        StringBuilder currEvents = StringList.create(g.saveGame.get("events"), ",");
        JSONObject selectedEvent = null;
        String selectedEventName = "";
        if (StringList.size(currEvents, ",") < fight * 2 - 1 + (g.saveGame.get("eventStep").equalsIgnoreCase("2") ? 1 : 0)) {
            if (fight == 7 && g.saveGame.get("eventStep").equalsIgnoreCase("1")) {
                Tournament.getFixedEvent(g, "chapter2");
                return;
            }
            if (fight == 14 && g.saveGame.get("eventStep").equalsIgnoreCase("1")) {
                Tournament.getFixedEvent(g, "chapter3");
                return;
            }
            if (g.saveGame.get("eventStep").equalsIgnoreCase("2") && Tournament.getRewardStock(g, "quest1") == fight) {
                Tournament.setRewardStock(g, "quest1", 0);
                Tournament.setRewardStock(g, "questOngoing", 0);
                selectedEventName = "quest11";
            } else if (g.saveGame.get("eventStep").equalsIgnoreCase("1") && Tournament.getRewardStock(g, "quest21") == fight) {
                Tournament.setRewardStock(g, "quest2", 0);
                Tournament.setRewardStock(g, "questOngoing", 0);
                selectedEventName = "quest21";
            } else if (g.saveGame.get("eventStep").equalsIgnoreCase("2") && Tournament.getRewardStock(g, "quest22") == fight) {
                Tournament.setRewardStock(g, "quest2", 0);
                Tournament.setRewardStock(g, "questOngoing", 0);
                selectedEventName = "quest22";
            } else if (g.saveGame.get("eventStep").equalsIgnoreCase("2") && Tournament.getRewardStock(g, "quest4") == fight) {
                Tournament.setRewardStock(g, "quest4", 0);
                Tournament.setRewardStock(g, "questOngoing", 0);
                selectedEventName = "quest41";
            } else if (g.saveGame.get("eventStep").equalsIgnoreCase("1") && Tournament.getRewardStock(g, "quest5") == fight) {
                Tournament.setRewardStock(g, "quest5", 0);
                Tournament.setRewardStock(g, "questOngoing", 0);
                selectedEventName = "quest51";
            } else if (g.saveGame.get("eventStep").equalsIgnoreCase("2") && Tournament.getRewardStock(g, "quest6") == fight) {
                Tournament.setRewardStock(g, "quest6", 0);
                Tournament.setRewardStock(g, "questOngoing", 0);
                selectedEventName = "quest61";
            } else if (g.saveGame.get("eventStep").equalsIgnoreCase("2") && Tournament.getRewardStock(g, "quest8") == fight) {
                Tournament.setRewardStock(g, "quest8", 0);
                Tournament.setRewardStock(g, "questOngoing", 0);
                selectedEventName = "quest80";
            } else if (g.saveGame.get("eventStep").equalsIgnoreCase("2") && Tournament.getRewardStock(g, "quest9") > 0) {
                selectedEventName = Tournament.getRewardStock(g, "quest9") == 2 ? "quest90" : "quest91";
                Tournament.setRewardStock(g, "quest9", 0);
                Tournament.setRewardStock(g, "questOngoing", 0);
            } else if (g.saveGame.get("eventStep").equalsIgnoreCase("2") && Tournament.getRewardStock(g, "carrier") > 0) {
                Tournament.setRewardStock(g, "carrier", 0);
                selectedEventName = "carrier-deliver";
            } else {
                int randomNumber = MathUtils.random(99);
                if (g.saveGame.get("eventStep").equalsIgnoreCase("1") && !g.saveGame.get("search").startsWith("none") && randomNumber < g.stats.get("tournament").getInt("searchEventChance") * (g.saveGame.get("search").contains(":") ? 2 : 1) + Tournament.getRewardStock(g, "trade-route")) {
                    randomNumber = MathUtils.random(99);
                    randomNumber = g.saveGame.get("search").startsWith("dealer") || g.saveGame.get("search").startsWith("any") && randomNumber > 75 ? Integer.parseInt(g.stats.get("tournament").getJSONObject("events").getJSONObject(g.saveGame.get("phase")).getJSONObject("dealer").getString("chance").split(":")[0]) : (g.saveGame.get("search").startsWith("smith") || g.saveGame.get("search").startsWith("any") && randomNumber > 50 ? Integer.parseInt(g.stats.get("tournament").getJSONObject("events").getJSONObject(g.saveGame.get("phase")).getJSONObject("smith").getString("chance").split(":")[0]) : (g.saveGame.get("search").startsWith("master") || g.saveGame.get("search").startsWith("any") && randomNumber > 25 ? Integer.parseInt(g.stats.get("tournament").getJSONObject("events").getJSONObject(g.saveGame.get("phase")).getJSONObject("master").getString("chance").split(":")[0]) : Integer.parseInt(g.stats.get("tournament").getJSONObject("events").getJSONObject(g.saveGame.get("phase")).getJSONObject("trainer").getString("chance").split(":")[0])));
                } else {
                    randomNumber = MathUtils.random(99) + (g.saveGame.get("eventStep").equalsIgnoreCase("2") ? 100 : 0);
                }
                for (String currEvent : g.stats.get("tournament").getJSONObject("events").getJSONObject(g.saveGame.get("phase")).keySet()) {
                    selectedEvent = g.stats.get("tournament").getJSONObject("events").getJSONObject(g.saveGame.get("phase")).getJSONObject(currEvent);
                    if (Integer.parseInt(selectedEvent.getString("chance").split(":")[0]) > randomNumber || Integer.parseInt(selectedEvent.getString("chance").split(":")[1]) < randomNumber) continue;
                    selectedEventName = currEvent;
                    break;
                }
            }
            currEvents = StringList.append(currEvents, selectedEventName, ",");
            g.saveGame.put("events", currEvents.toString());
            StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
            currRewards = StringList.set(currRewards, 0, selectedEventName, ";");
            currRewards = StringList.set(currRewards, 1, "1", ";");
            g.saveGame.put("rewards", currRewards.toString());
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
            selectedEvent = g.stats.get("tournament").getJSONObject("events").getJSONObject(g.saveGame.get("phase")).getJSONObject(selectedEventName);
        } else {
            selectedEventName = StringList.get(currEvents, StringList.size(currEvents, ",") - 1, ",");
            selectedEvent = g.stats.get("tournament").getJSONObject("events").getJSONObject(g.saveGame.get("phase")).getJSONObject(selectedEventName);
        }
        g.tournamentEventScreen = new TournamentEventScreen(g, g.getOverridenFilename("music/" + selectedEvent.getString("music") + ".ogg"), g.getOverridenFilename("data/backgrounds/" + selectedEvent.getString("background")), "tournament.event." + selectedEventName, 5000L);
        g.setScreen(g.tournamentEventScreen);
    }

    public static void getFixedEvent(SlavePitsGame g, String type) {
        if (type.equalsIgnoreCase("chapter1")) {
            g.tournamentEventScreen = new TournamentEventScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/arenaboss1.jpg"), "tournament.character." + g.campaignFighter.name + ".chapter1", 5000L);
            g.setScreen(g.tournamentEventScreen);
        } else if (type.equalsIgnoreCase("chapter2")) {
            g.tournamentEventScreen = new TournamentEventScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundLore6.jpg"), "tournament.character." + g.campaignFighter.name + ".chapter2", 5000L);
            g.setScreen(g.tournamentEventScreen);
        } else if (type.equalsIgnoreCase("chapter3")) {
            g.tournamentEventScreen = new TournamentEventScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundColiseum.jpg"), "tournament.character." + g.campaignFighter.name + ".chapter3", 5000L);
            g.setScreen(g.tournamentEventScreen);
        } else if (type.equalsIgnoreCase("boss")) {
            g.tournamentEventScreen = new TournamentEventScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundColiseum.jpg"), "tournament.character." + g.campaignFighter.name + ".boss", 5000L);
            g.setScreen(g.tournamentEventScreen);
        } else if (type.equalsIgnoreCase("end")) {
            g.tournamentEventScreen = new TournamentEventScreen(g, g.getOverridenFilename("music/sl02.ogg"), g.getOverridenFilename("data/backgrounds/backgroundLore11.jpg"), "tournament.character." + g.campaignFighter.name + ".end", 20000L);
            g.setScreen(g.tournamentEventScreen);
        } else if (type.equalsIgnoreCase("endfree")) {
            g.messageScreen = new MessageScreen(g, PropertiesReader.getMessage(g.gameMessages, "game.settings.endfree"), "00B3B3FF", g.viewHeight.floatValue() / (g.heightBASE.floatValue() / 2.0f), "mainmenu;fadein:1.0;", "chapter");
            g.setScreen(g.messageScreen);
        }
    }

    public static boolean isValidEventCondition(SlavePitsGame g, String event, int choice) {
        String conditionKey;
        String string = conditionKey = !event.equalsIgnoreCase("none") && choice > 0 ? g.stats.get("tournament").getJSONObject("events").getJSONObject(g.saveGame.get("phase")).getJSONObject(event).getString("condition" + choice) : "";
        if (!conditionKey.equalsIgnoreCase("") && g.stats.get("tournament").getJSONObject("conditions").has(conditionKey)) {
            String fullCondition = g.stats.get("tournament").getJSONObject("conditions").getString(conditionKey);
            return Tournament.isValidCondition(g, fullCondition);
        }
        return true;
    }

    public static boolean isValidCondition(SlavePitsGame g, String fullCondition) {
        for (String realCondition : fullCondition.split("#")) {
            for (String subCondition : realCondition.split(";")) {
                String[] subConditionArr = subCondition.split(":");
                if (subConditionArr[1].equalsIgnoreCase("damage") || subConditionArr[1].equalsIgnoreCase("sick") || !(subConditionArr[1].equalsIgnoreCase("weapon") ? Tournament.getRewardStockBundle(g, "weapon", "") < Integer.parseInt(subConditionArr[3]) : (subConditionArr[1].equalsIgnoreCase("coin") ? Integer.parseInt(g.saveGame.get("profits")) < Integer.parseInt(subConditionArr[3]) : (subConditionArr[1].equalsIgnoreCase("debt") ? Tournament.getRewardStock(g, "maintenance") > Integer.parseInt(subConditionArr[3]) : (subConditionArr[1].equalsIgnoreCase("unique") ? (subConditionArr[3].equalsIgnoreCase("0") ? Tournament.getRewardStock(g, subConditionArr[2]) == 0 : subConditionArr[3].equalsIgnoreCase("1") && Tournament.getRewardStock(g, subConditionArr[2]) > 0) : (subConditionArr[1].equalsIgnoreCase("life") ? (subConditionArr[3].equalsIgnoreCase("0") ? g.campaignFighter.life >= Integer.parseInt(subConditionArr[2]) : subConditionArr[3].equalsIgnoreCase("1") && g.campaignFighter.life <= Integer.parseInt(subConditionArr[2])) : Tournament.getRewardStock(g, subConditionArr[1]) < Integer.parseInt(subConditionArr[3]))))))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkRewardCondition(String condition, float lifeRatio) {
        if (!condition.equalsIgnoreCase("") && condition.startsWith("life")) {
            if (condition.contains("more")) {
                return lifeRatio * 100.0f > (float)Integer.parseInt(condition.split(":")[2]);
            }
            return lifeRatio * 100.0f < (float)Integer.parseInt(condition.split(":")[2]);
        }
        return true;
    }

    public static String checkRewardText(SlavePitsGame g, String rewardItems) {
        StringBuilder result = new StringBuilder();
        StringBuilder currPrizes = StringList.create(rewardItems, ";");
        for (int i = 0; i < StringList.size(currPrizes, ";"); ++i) {
            String currPrize = StringList.get(currPrizes, i, ";");
            result.append("- ");
            if (currPrize.startsWith("hatchet") || currPrize.startsWith("mace") || currPrize.startsWith("sword") || currPrize.startsWith("axe") || currPrize.startsWith("hammer") || currPrize.startsWith("spear") || currPrize.startsWith("longsword") || currPrize.startsWith("whip") || currPrize.startsWith("shield")) {
                result.append(PropertiesReader.getMessage(g.gameMessages, "game.stats.items.weapons.name." + currPrize.split(":")[0]));
            } else if (currPrize.startsWith("cuirass") || currPrize.startsWith("helmet") || currPrize.startsWith("bracers")) {
                result.append(PropertiesReader.getMessage(g.gameMessages, "game.stats.items.armors.name." + currPrize.split(":")[0]));
                result.append(" x");
                result.append(currPrize.split(":")[1]);
            } else if (currPrize.startsWith("shard") || currPrize.startsWith("powder") || currPrize.startsWith("net") || currPrize.startsWith("upgradearmor") || currPrize.startsWith("upgradeweapon") || currPrize.startsWith("care") || currPrize.startsWith("info") || currPrize.startsWith("potion")) {
                result.append(PropertiesReader.getMessage(g.gameMessages, "game.stats.services." + currPrize.split(":")[0] + ".name"));
                result.append(" x");
                result.append(currPrize.split(":")[1]);
            } else if (currPrize.contains(":")) {
                result.append(PropertiesReader.getMessage(g.gameMessages, "journal.tournament.reward." + currPrize.split(":")[0]));
                result.append(" x");
                result.append(currPrize.split(":")[1]);
            } else {
                result.append(PropertiesReader.getMessage(g.gameMessages, "journal.tournament.reward." + currPrize));
            }
            result.append("\n");
        }
        return result.toString();
    }

    public static String addCombatReward(SlavePitsGame g, int life, int initialLife, long timeLimit) {
        String defaultRealReward;
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        if (fight >= 21) {
            return "";
        }
        StringBuilder showReward = new StringBuilder();
        if (g.saveGame.get("special") != null) {
            if (g.saveGame.get("special").startsWith("combat:")) {
                if (Tournament.getRewardStock(g, "quest10") > 0 && life >= initialLife / 2) {
                    Tournament.setRewardStock(g, "infbos", 5);
                }
                if (g.saveGame.get("special").contains("-timein")) {
                    if (timeLimit <= 0L) {
                        StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
                        currRewards = StringList.set(currRewards, 1, "2", ";");
                    }
                } else if (g.saveGame.get("special").contains("-timeout") && timeLimit > 0L) {
                    StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
                    currRewards = StringList.set(currRewards, 1, "2", ";");
                }
                return "";
            }
            if (g.saveGame.get("special").startsWith("bet-double") && g.saveGame.get("special").contains(":")) {
                return "";
            }
            if (g.saveGame.get("special").startsWith("quest")) {
                String questRealReward = g.stats.get("tournament").getJSONObject("rewards").getString(g.saveGame.get("special") + "-reward");
                if (questRealReward.contains("#")) {
                    for (String orReward : questRealReward.split("#")) {
                        if (MathUtils.random(99) >= Integer.parseInt(orReward.split(":")[0])) continue;
                        questRealReward = orReward;
                        break;
                    }
                }
                for (String currDefaultReward : questRealReward.split(";")) {
                    int addedItems;
                    StringBuilder currSubreward = new StringBuilder(currDefaultReward);
                    String rewardType = StringList.get(currSubreward, 1, ":");
                    if (rewardType.equalsIgnoreCase("coin")) {
                        int addedProfits = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                        g.saveGame.put("profits", "" + (Integer.parseInt(g.saveGame.get("profits")) + addedProfits));
                        showReward.append(rewardType);
                        showReward.append(":");
                        showReward.append(addedProfits);
                        showReward.append(";");
                        continue;
                    }
                    if (rewardType.equalsIgnoreCase("cabal-informant")) {
                        addedItems = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                        Tournament.setRewardStock(g, rewardType, Tournament.getRewardStock(g, rewardType) + addedItems);
                        continue;
                    }
                    if (rewardType.equalsIgnoreCase("bostyp")) {
                        Tournament.setRewardStock(g, "bosty" + (MathUtils.random(2) + 1), 1);
                        continue;
                    }
                    addedItems = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                    Tournament.setRewardStock(g, rewardType, Tournament.getRewardStock(g, rewardType) + addedItems);
                    showReward.append(rewardType);
                    showReward.append(":");
                    showReward.append(addedItems);
                    showReward.append(";");
                }
                g.saveGame.remove("special");
            }
        }
        if (Tournament.getRewardStock(g, "quest9") == 1 && life >= initialLife / 2) {
            Tournament.setRewardStock(g, "quest9", 2);
        }
        int rewardMultiplier = 100;
        if (g.saveGame.get("special") != null && g.saveGame.get("special").contains("bet-")) {
            String[] defaultRewardArr = g.stats.get("tournament").getJSONObject("rewards").getString(g.saveGame.get("special").split(":")[0]).split(":");
            g.saveGame.remove("special");
            if (defaultRewardArr[1].equalsIgnoreCase("default-multiplier")) {
                rewardMultiplier = Integer.parseInt(defaultRewardArr[2]) + MathUtils.random(Integer.parseInt(defaultRewardArr[3]) - Integer.parseInt(defaultRewardArr[2]));
            } else if (defaultRewardArr[1].equalsIgnoreCase("default-time")) {
                rewardMultiplier = timeLimit > 0L ? Integer.parseInt(defaultRewardArr[3]) : Integer.parseInt(defaultRewardArr[2]);
            }
        }
        if ((defaultRealReward = g.stats.get("tournament").getJSONObject("rewards").getString("default-" + g.saveGame.get("difficulty"))).contains("#")) {
            for (String orReward : defaultRealReward.split("#")) {
                if (MathUtils.random(99) >= Integer.parseInt(orReward.split(":")[0])) continue;
                defaultRealReward = orReward;
                break;
            }
        }
        for (String currDefaultReward : defaultRealReward.split(";")) {
            int addedItems;
            StringBuilder currSubreward = new StringBuilder(currDefaultReward);
            String rewardType = StringList.get(currSubreward, 1, ":");
            if (MathUtils.random(99) >= Integer.parseInt(StringList.get(currSubreward, 0, ":"))) continue;
            if (rewardType.equalsIgnoreCase("coin")) {
                int addedProfits = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                addedProfits = addedProfits * rewardMultiplier / 100;
                if (Tournament.getRewardStock(g, "bet") > 0) {
                    addedProfits = addedProfits * Tournament.getRewardStock(g, "bet") / 100;
                    Tournament.setRewardStock(g, "bet", 0);
                }
                if (Tournament.getRewardStock(g, "bard") > 0) {
                    Tournament.setRewardStock(g, "maintenance", Tournament.getRewardStock(g, "maintenance") - 1);
                }
                g.saveGame.put("profits", "" + (Integer.parseInt(g.saveGame.get("profits")) + (addedProfits -= Tournament.getRewardStock(g, "maintenance"))));
                showReward.append(rewardType);
                showReward.append(":");
                showReward.append(addedProfits);
                showReward.append(";");
                continue;
            }
            if (rewardType.equalsIgnoreCase("weapon")) {
                addedItems = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                for (addedItems = (rewardMultiplier > 100 && addedItems == 0 ? 1 : addedItems) * rewardMultiplier / 100; addedItems > 0; --addedItems) {
                    String currWeapon = Tournament.getRandomWeapon("nodagger");
                    Tournament.setRewardStock(g, currWeapon, Tournament.getRewardStock(g, currWeapon) + 1);
                    showReward.append(currWeapon);
                    showReward.append(":");
                    showReward.append("1");
                    showReward.append(";");
                }
                continue;
            }
            if (rewardType.equalsIgnoreCase("armor")) {
                addedItems = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                addedItems = (rewardMultiplier > 100 && addedItems == 0 ? 1 : addedItems) * rewardMultiplier / 100;
                if (MathUtils.random(99) < Tournament.getRewardStock(g, "tinkerer")) {
                    addedItems = addedItems + MathUtils.random(1) + 1;
                }
                while (addedItems > 0) {
                    String currArmor = Tournament.getRandomArmor(addedItems <= 1 ? "nocuirass" : "");
                    Tournament.setRewardStock(g, currArmor, Tournament.getRewardStock(g, currArmor) + 1);
                    addedItems -= currArmor.equalsIgnoreCase("cuirass") ? 2 : 1;
                    showReward.append(currArmor);
                    showReward.append(":");
                    showReward.append("1");
                    showReward.append(";");
                }
                continue;
            }
            if (rewardType.equalsIgnoreCase("service")) {
                addedItems = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
                addedItems = (rewardMultiplier > 100 && addedItems == 0 ? 1 : addedItems) * rewardMultiplier / 100;
                while (addedItems > 0) {
                    String currService = Tournament.getRandomService(addedItems <= 1 ? "cheap" : (MathUtils.randomBoolean() ? "expensive-care" : "expensive"));
                    Tournament.setRewardStock(g, currService, Tournament.getRewardStock(g, currService) + 1);
                    addedItems = currService.equalsIgnoreCase("care") || currService.equalsIgnoreCase("info") || currService.equalsIgnoreCase("upgradeweapon") || currService.equalsIgnoreCase("potion") ? (addedItems -= 2) : --addedItems;
                    showReward.append(currService);
                    showReward.append(":");
                    showReward.append("1");
                    showReward.append(";");
                }
                if (MathUtils.random(99) >= Tournament.getRewardStock(g, "kid")) continue;
                String useItem = MathUtils.random(2) == 0 ? "shard" : (MathUtils.random(1) == 0 ? "powder" : "net");
                Tournament.setRewardStock(g, useItem, Tournament.getRewardStock(g, useItem) + 1);
                showReward.append(useItem);
                showReward.append(":");
                showReward.append("1");
                showReward.append(";");
                continue;
            }
            addedItems = Integer.parseInt(StringList.get(currSubreward, 2, ":")) + MathUtils.random(Integer.parseInt(StringList.get(currSubreward, 3, ":")) - Integer.parseInt(StringList.get(currSubreward, 2, ":")));
            addedItems = (rewardMultiplier > 100 && addedItems == 0 ? 1 : addedItems) * rewardMultiplier / 100;
            Tournament.setRewardStock(g, rewardType, Tournament.getRewardStock(g, rewardType) + addedItems);
            showReward.append(rewardType);
            showReward.append(":");
            showReward.append(addedItems);
            showReward.append(";");
        }
        if (showReward.length() > 0) {
            return Tournament.checkRewardText(g, showReward.substring(0, showReward.length() - 1));
        }
        return "";
    }

    public static void applyEarnedRewards(SlavePitsGame g, Fighter fighter) {
        if (Integer.parseInt(g.saveGame.get("randomNumber")) < Tournament.getRewardStock(g, "cabal-informant")) {
            if (!fighter.services.equalsIgnoreCase("")) {
                fighter.services = fighter.services + ",";
            }
            fighter.services = fighter.services + "info";
        }
        if (Tournament.getRewardStock(g, "apprentice") > 0) {
            if (!fighter.services.equalsIgnoreCase("")) {
                fighter.services = fighter.services + ",";
            }
            fighter.services = fighter.services + "upgradeweapon-" + Tournament.getRewardStock(g, "apprentice");
        }
    }

    public static void advancePlayer(SlavePitsGame g, int life, int initialLife, String opponentName) {
        int fight = Integer.parseInt(g.saveGame.get("fight"));
        g.saveGame.put("aftermatch", "day");
        g.saveGame.put("randomNumber", "" + MathUtils.random(99));
        if (life <= 0) {
            if (Tournament.getRewardStock(g, "quest7") == 0) {
                g.saveGame.put("aftermatch", "gameover");
                return;
            }
            g.campaignFighter.life = 1;
            StringBuilder currEvents = StringList.create(g.saveGame.get("events"), ",");
            int enemiesDefeated = Integer.parseInt(StringList.get(currEvents, StringList.size(currEvents, ",") - 1, ",").replace("quest7", ""));
            Tournament.setRewardStock(g, "quest7", enemiesDefeated);
            currEvents = StringList.set(currEvents, StringList.size(currEvents, ",") - 1, "quest72", ",");
            g.saveGame.put("events", currEvents.toString());
            StringBuilder currRewards = StringList.create(g.saveGame.get("rewards"), ";");
            currRewards = StringList.set(currRewards, 0, "quest72", ";");
            currRewards = StringList.set(currRewards, 1, "1", ";");
            g.saveGame.put("rewards", currRewards.toString());
            PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
        } else {
            g.campaignFighter.life = life;
            g.achievements.put(opponentName, "1");
            PropertiesReader.saveAchievements(g.achievements, g.mail, g.key, g.debugMode);
        }
        if (g.saveGame.get("special") != null) {
            if (g.saveGame.get("special").contains("combat:")) {
                g.saveGame.remove("special");
                g.campaignFighter.services = "";
                g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
                g.saveGame.remove("delete");
                PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
                g.saveGame.put("aftermatch", "skipcondition");
                return;
            }
            if (g.saveGame.get("special").startsWith("bet-double:")) {
                g.saveGame.put("special", "bet-double");
                g.saveGame.put("aftermatch", "fight");
                return;
            }
            if (g.saveGame.get("special").startsWith("sick:")) {
                g.campaignFighter.maxStamina = g.campaignFighter.maxStamina * 100 / (100 - Integer.parseInt(g.saveGame.get("special").split(":")[1]));
                g.campaignFighter.maxBalance = g.campaignFighter.maxBalance * 100 / (100 - Integer.parseInt(g.saveGame.get("special").split(":")[1]));
                g.saveGame.remove("special");
            }
        }
        g.saveGame.put("fight", "" + (fight + 1));
        if (fight + 1 == 7) {
            if (!PropertiesReader.verifyKey(g.mail, g.key, g.checksum).equalsIgnoreCase("free")) {
                g.saveGame.put("phase", "caravan");
            } else {
                g.saveGame.put("aftermatch", "endfree");
            }
        } else if (fight + 1 == 14) {
            g.saveGame.put("phase", "coliseum");
        } else if (fight + 1 == 21) {
            g.saveGame.put("phase", "boss");
            g.saveGame.put("aftermatch", "boss");
        } else if (fight + 1 == 22) {
            g.saveGame.put("aftermatch", "end");
        }
        g.campaignFighter.services = "";
        g.saveGame.put("fighter", Fighter.fighterToString(g.campaignFighter));
        g.saveGame.remove("delete");
        PropertiesReader.saveGame(g.saveGame, Integer.parseInt(g.saveGame.get("position")), g.mail, g.key, g.debugMode);
    }

    public static void loadState(SlavePitsGame g) {
        g.campaignFighter = Fighter.stringToFighter(g.saveGame.get("fighter"));
        if (g.saveGame.get("step").equalsIgnoreCase("event") && (g.saveGame.get("special") == null || !g.saveGame.get("special").contains("combat:"))) {
            Tournament.getNextEvent(g);
        } else {
            g.tournamentSetupScreen = new TournamentSetupScreen(g);
            g.setScreen(g.tournamentSetupScreen);
        }
    }
}

