/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.game;

import com.badlogic.gdx.math.MathUtils;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.SlavePitsGame;
import com.calimasaga.slavepits.game.CombatEngine;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.screen.CombatScreen;
import com.calimasaga.slavepits.util.Logger;
import com.calimasaga.slavepits.util.StringList;
import java.util.ArrayList;

public class AI {
    public SlavePitsGame game;
    public Fighter npc;
    public Fighter pc;
    public int reactionChance = 0;
    public int reactionWindow = 0;
    public int reactionTime = 0;
    public String previousAction = "idle";
    public String previousOption = "left";
    public String action = "idle";
    public String option = "left";
    public long deviation = 0L;
    public long actionTime = 0L;
    public String defendPreference = "dodge:50";
    public String attackPreference = "attack:stamin:own:35";
    public String itemPreference = "life:own:less:50";
    public int itemInterval = 0;
    public float inputDelay = 0.0f;

    public AI() {
    }

    public AI(SlavePitsGame g, Fighter computer, Fighter player, int reputation, String difficulty) {
        this.game = g;
        this.npc = computer;
        this.pc = player;
        this.inputDelay = ((JSONObject)this.game.stats.get("timings").get("platform")).getFloat(this.game.input);
        this.reactionChance = Integer.parseInt(((JSONObject)this.game.stats.get("timings").get("ai")).getString("baseReactionChance"));
        this.reactionWindow = Integer.parseInt(((JSONObject)this.game.stats.get("timings").get("ai")).getString("baseReactionWindow"));
        this.reactionTime = Integer.parseInt(((JSONObject)this.game.stats.get("timings").get("ai")).getString("baseReactionTime"));
        boolean chanceIncrement = false;
        boolean windowDecrement = false;
        boolean timeDecrement = false;
        String phaseAI = "pits";
        if (reputation > Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("caravan")).getString("maxReputation"))) {
            phaseAI = "coliseum";
        } else if (reputation > Integer.parseInt(((JSONObject)((JSONObject)g.stats.get("phases").get("limits")).get("pits")).getString("maxReputation"))) {
            phaseAI = "caravan";
        }
        String aiModifiers = ((JSONObject)((JSONObject)this.game.stats.get("timings").get("ai")).get("phaseThreshold")).getString(phaseAI);
        int aiModifierChance = Integer.parseInt(aiModifiers.split(":")[0]);
        int aiModifierWindow = Integer.parseInt(aiModifiers.split(":")[1]);
        int aiModifierTime = Integer.parseInt(aiModifiers.split(":")[3]);
        this.reactionChance += aiModifierChance;
        this.reactionWindow -= aiModifierWindow;
        this.reactionTime -= aiModifierTime;
        aiModifiers = ((JSONObject)((JSONObject)this.game.stats.get("timings").get("ai")).get("difficultyThreshold")).getString(difficulty);
        aiModifierChance = Integer.parseInt(aiModifiers.split(":")[0]);
        aiModifierWindow = Integer.parseInt(aiModifiers.split(":")[1]);
        aiModifierTime = Integer.parseInt(aiModifiers.split(":")[3]);
        this.reactionChance += aiModifierChance;
        this.reactionWindow -= aiModifierWindow;
        this.reactionTime -= aiModifierTime;
        if (this.game.gameMode.equalsIgnoreCase("story") || this.game.gameMode.equalsIgnoreCase("tournament")) {
            StringBuilder currRewards = StringList.create(this.game.saveGame.get("rewards"), ";");
            if (computer.name.contains("boss1") && StringList.indexOf(currRewards, "fambo1", 0, ";") > 0 || computer.name.contains("boss2") && StringList.indexOf(currRewards, "fambo2", 0, ";") > 0 || computer.name.contains("boss3") && StringList.indexOf(currRewards, "fambo3", 0, ";") > 0 || StringList.indexOf(currRewards, "infbos", 0, ";") > 0) {
                this.reactionChance = this.reactionChance * 9 / 10;
            } else if (player.services.contains("info")) {
                this.reactionChance = this.reactionChance * 9 / 10;
            }
            if (this.game.gameMode.equalsIgnoreCase("story") && Integer.parseInt(this.game.saveGame.get("lost")) > 0) {
                this.reactionChance -= Integer.parseInt(this.game.saveGame.get("lost")) * 5;
                this.reactionWindow += Integer.parseInt(this.game.saveGame.get("lost")) * 5;
                if (this.reactionChance < 50) {
                    this.reactionChance = 50;
                }
                if (this.reactionWindow > 50) {
                    this.reactionWindow = 50;
                }
            }
            if (computer.name.contains("boss2")) {
                this.itemInterval = 6;
            }
        }
        this.defendPreference = computer.behavior.split("#")[0];
        this.attackPreference = computer.behavior.split("#")[1];
        this.itemPreference = computer.behavior.split("#")[2];
        Logger.write(Logger.DEBUG, "AI.initialize: reactionChance " + this.reactionChance + ", reactionWindow " + this.reactionWindow + ", reactionTime " + this.reactionTime + ", defendPreference " + this.defendPreference + ", attackPreference " + this.attackPreference + ", itemPreference " + this.itemPreference);
    }

    public void takeDecision(ArrayList<Long> availableTime) {
        for (int i = 0; i < availableTime.size(); ++i) {
            availableTime.set(i, availableTime.get(i) - (long)CombatScreen.PHASE_TIME);
        }
        int currReactionChance = this.reactionChance;
        int currReactionWindow = this.reactionWindow;
        int currReactionTime = this.reactionTime;
        int stunned = Float.valueOf(CombatEngine.getEffectValue(this.npc, null, "stun", "stun", 0)).intValue();
        if (stunned > 0) {
            currReactionChance -= stunned;
            currReactionWindow += stunned;
        }
        this.previousAction = this.action;
        this.previousOption = this.option;
        this.action = "idle";
        this.actionTime = 0L;
        long chosenAvailableTime = 0L;
        if (CombatEngine.combatState.getAttacker() == this.npc && CombatEngine.combatState.stage.equalsIgnoreCase("start")) {
            chosenAvailableTime = availableTime.get(0);
            if (this.npc.itemUses > 0 && this.checkItemUsage()) {
                this.action = "use";
                this.option = "right";
                this.actionTime = availableTime.get(0) / 2L;
                this.deviation = 0L;
                this.itemInterval = 4;
            } else if (CombatEngine.canPayActionCost("attack", "middle", MathUtils.clamp(currReactionWindow / 10, 0, 5) * 10, this.npc, this.pc, CombatEngine.combatState.randomNumber) && this.checkAttack("start")) {
                this.action = "attack";
                this.option = this.getAttackDirection();
                int rolledChance = MathUtils.random(99);
                int thresholdChance = Float.valueOf((float)currReactionChance * Double.valueOf(Math.pow(Math.sqrt(Float.valueOf(availableTime.get(0).longValue()).floatValue() / ((float)currReactionTime + this.inputDelay)), 3.0)).floatValue()).intValue();
                CombatEngine.addLogTrace(this.npc == CombatEngine.combatState.hostFighter ? CombatEngine.combatState.hostLog : CombatEngine.combatState.clientLog, "l;Reaction chance: " + thresholdChance + ", Pressure: " + String.format("%.2f", CombatEngine.combatState.timePressure));
                if (rolledChance > 0 && rolledChance <= thresholdChance) {
                    rolledChance = 50 + Float.valueOf((float)currReactionWindow * ((float)rolledChance / (float)thresholdChance)).intValue();
                } else {
                    this.action = "idle";
                    this.option = "xxx";
                }
                this.actionTime = availableTime.get(0) * (long)rolledChance / 100L;
                this.deviation = (int)(Math.abs(((float)this.actionTime - (float)availableTime.get(0).longValue() / 2.0f) / ((float)availableTime.get(0).longValue() / 2.0f)) * 55.0f) / 10 * 10;
                if (this.deviation > 50L) {
                    this.deviation = 50L;
                }
            }
        } else if (CombatEngine.combatState.getAttacker() == this.npc && (CombatEngine.combatState.stage.equalsIgnoreCase("chain") || CombatEngine.combatState.stage.equalsIgnoreCase("risposte"))) {
            chosenAvailableTime = availableTime.get(0);
            if (!(this.npc.talents.get("10") != null && this.npc.debuffs.length() > 0 && CombatEngine.combatState.stage.equalsIgnoreCase("risposte") && (this.npc.debuffs.toString().contains("stun") || this.npc.debuffs.toString().contains("exhaus") && this.npc.stamina < 5000 || this.npc.debuffs.toString().contains("bleed") && this.npc.life < 5000) || this.npc.talents.get("18") != null && this.pc.buffs.length() > 0 && (this.pc.buffs.toString().split(",").length > 1 || !this.pc.buffs.toString().contains("surge")) && CombatEngine.combatState.stage.equalsIgnoreCase("chain"))) {
                if (this.npc.itemUses > 0 && this.checkItemUsage()) {
                    this.action = "use";
                    this.option = "right";
                    this.actionTime = availableTime.get(0) / 2L;
                    this.deviation = 0L;
                    this.itemInterval = 4;
                } else if (CombatEngine.canPayActionCost("attack", "middle", MathUtils.clamp(currReactionWindow / 10, 0, 5) * 10, this.npc, this.pc, CombatEngine.combatState.randomNumber) && this.checkAttack(CombatEngine.combatState.stage)) {
                    this.action = "attack";
                    this.option = this.getAttackDirection();
                    int rolledChance = MathUtils.random(99);
                    int thresholdChance = Float.valueOf((float)currReactionChance * Double.valueOf(Math.pow(Math.sqrt(Float.valueOf(availableTime.get(0).longValue()).floatValue() / ((float)currReactionTime + this.inputDelay)), 3.0)).floatValue()).intValue();
                    CombatEngine.addLogTrace(this.npc == CombatEngine.combatState.hostFighter ? CombatEngine.combatState.hostLog : CombatEngine.combatState.clientLog, "l;Reaction chance: " + thresholdChance + ", Pressure: " + String.format("%.2f", CombatEngine.combatState.timePressure));
                    if (rolledChance > 0 && rolledChance <= thresholdChance) {
                        rolledChance = 50 + Float.valueOf((float)currReactionWindow * ((float)rolledChance / (float)thresholdChance)).intValue();
                    } else {
                        this.action = "idle";
                        this.option = "xxx";
                    }
                    this.actionTime = availableTime.get(0) * (long)rolledChance / 100L;
                    this.deviation = (int)(Math.abs(((float)this.actionTime - (float)availableTime.get(0).longValue() / 2.0f) / ((float)availableTime.get(0).longValue() / 2.0f)) * 55.0f) / 10 * 10;
                    if (this.deviation > 50L) {
                        this.deviation = 50L;
                    }
                }
            }
        } else if (CombatEngine.combatState.getDefender() == this.npc && CombatEngine.combatState.stage.equalsIgnoreCase("attack")) {
            String dodgeOption;
            String parryOption;
            chosenAvailableTime = availableTime.get(0);
            int betterTime = -1;
            String string = CombatEngine.combatState.direction.equalsIgnoreCase("middle") ? "middle" : (parryOption = CombatEngine.combatState.direction.equalsIgnoreCase("left") ? "right" : "left");
            String string2 = CombatEngine.combatState.direction.equalsIgnoreCase("middle") ? "right" : (dodgeOption = CombatEngine.combatState.direction.equalsIgnoreCase("left") ? "left" : "right");
            if (CombatEngine.canPayActionCost("parry", parryOption, MathUtils.clamp(currReactionWindow / 10, 0, 5) * 10, this.npc, this.pc, CombatEngine.combatState.randomNumber)) {
                betterTime = CombatEngine.canPayActionCost("dodge", dodgeOption, MathUtils.clamp(currReactionWindow / 10, 0, 5) * 10, this.npc, this.pc, CombatEngine.combatState.randomNumber) ? (this.checkDefense(availableTime.get(0), availableTime.get(1)).equalsIgnoreCase("parry") ? 0 : 1) : 0;
            } else if (CombatEngine.canPayActionCost("dodge", dodgeOption, MathUtils.clamp(currReactionWindow / 10, 0, 5) * 10, this.npc, this.pc, CombatEngine.combatState.randomNumber)) {
                betterTime = 1;
            }
            if (betterTime >= 0) {
                chosenAvailableTime = availableTime.get(betterTime);
                if (betterTime == 0) {
                    this.action = "parry";
                    this.option = parryOption;
                } else {
                    this.action = "dodge";
                    this.option = dodgeOption;
                }
                int rolledChance = MathUtils.random(99);
                int thresholdChance = Float.valueOf((float)currReactionChance * Double.valueOf(Math.pow(Math.sqrt(Float.valueOf(availableTime.get(betterTime).longValue()).floatValue() / ((float)currReactionTime + this.inputDelay)), 3.0)).floatValue()).intValue();
                CombatEngine.addLogTrace(this.npc == CombatEngine.combatState.hostFighter ? CombatEngine.combatState.hostLog : CombatEngine.combatState.clientLog, "l;Reaction chance: " + thresholdChance + ", Pressure: " + String.format("%.2f", CombatEngine.combatState.timePressure));
                if (rolledChance > 0 && rolledChance <= thresholdChance) {
                    rolledChance = 50 + Float.valueOf((float)currReactionWindow * ((float)rolledChance / (float)thresholdChance)).intValue();
                } else {
                    this.action = "idle";
                    this.option = "xxx";
                }
                this.actionTime = availableTime.get(betterTime) * (long)rolledChance / 100L;
                this.deviation = (int)(Math.abs(((float)this.actionTime - (float)availableTime.get(betterTime).longValue() / 2.0f) / ((float)availableTime.get(betterTime).longValue() / 2.0f)) * 55.0f) / 10 * 10;
                if (this.deviation > 50L) {
                    this.deviation = 50L;
                }
            }
        }
        if (this.actionTime > 0L) {
            this.actionTime += (long)CombatScreen.PHASE_TIME;
            --this.itemInterval;
        }
        Logger.write(Logger.DEBUG, "AI.takeDecision  name " + this.npc.name + ", action " + this.action + ", actionTime " + this.actionTime + ", chosenAvailableTime " + chosenAvailableTime + ", option " + this.option + ", deviation " + this.deviation + ", stage " + CombatEngine.combatState.stage + ", attacker " + (CombatEngine.combatState.getAttacker() == this.npc));
    }

    public void reset() {
        this.previousAction = this.action;
        this.previousOption = this.option;
        this.action = "idle";
        this.actionTime = 0L;
    }

    public boolean act(float delta) {
        String surgeOption;
        this.actionTime -= Float.valueOf(delta * 1000.0f).longValue();
        if (this.action.equalsIgnoreCase("surge") && this.npc.surge < 10000) {
            this.action = this.previousAction;
            this.option = this.previousOption;
        }
        if (!this.action.equalsIgnoreCase("idle") && this.actionTime <= 0L) {
            return true;
        }
        if (!this.action.equalsIgnoreCase("surge") && !(surgeOption = this.checkSurge()).equalsIgnoreCase("")) {
            this.previousAction = this.action;
            this.previousOption = this.option;
            this.action = "surge";
            this.option = surgeOption;
            this.deviation = 0L;
            return true;
        }
        return false;
    }

    private String possibleCombo() {
        String comboMovement = CombatEngine.nextComboMovementCandidate(this.npc);
        if (!comboMovement.equalsIgnoreCase("") && MathUtils.random(100) <= 70) {
            String aComboDirection = comboMovement.substring(2, 4);
            if (aComboDirection.equalsIgnoreCase("xx")) {
                if (MathUtils.random(2) == 0) {
                    return "middle";
                }
                if (MathUtils.random(1) == 0) {
                    return "right";
                }
                return "left";
            }
            if (aComboDirection.equalsIgnoreCase("sx")) {
                if (MathUtils.random(1) == 0) {
                    return "right";
                }
                return "left";
            }
            if (aComboDirection.equalsIgnoreCase("so")) {
                String previousDirection = this.npc.comboStage.split("-")[this.npc.comboStage.split("-").length - 1].substring(2, 4);
                if (previousDirection.equalsIgnoreCase("le")) {
                    return "right";
                }
                return "left";
            }
            if (aComboDirection.equalsIgnoreCase("ss")) {
                String previousDirection = this.npc.comboStage.split("-")[this.npc.comboStage.split("-").length - 1].substring(2, 4);
                if (previousDirection.equalsIgnoreCase("le")) {
                    return "left";
                }
                return "right";
            }
            if (aComboDirection.equalsIgnoreCase("mi")) {
                return "middle";
            }
            if (aComboDirection.equalsIgnoreCase("ri")) {
                return "right";
            }
            return "left";
        }
        return "";
    }

    private String getAttackDirection() {
        String comboMovement = this.possibleCombo();
        if (!comboMovement.equalsIgnoreCase("")) {
            return comboMovement;
        }
        if (MathUtils.random(99) < this.reactionChance / 2 + (this.npc.talents.get("26") != null ? 20 : 0) + (this.npc.talents.get("25") != null ? 20 : 0)) {
            return CombatEngine.combatState.vulnerableDirection;
        }
        if (MathUtils.random(2) == 0) {
            return "middle";
        }
        if (MathUtils.random(1) == 0) {
            return "right";
        }
        return "left";
    }

    private String checkDefense(Long parryTime, Long dodgeTime) {
        if (this.defendPreference.split(":")[0].equalsIgnoreCase("parry")) {
            if ((float)MathUtils.random(100) <= (float)Integer.parseInt(this.defendPreference.split(":")[1]) * Math.min(parryTime.floatValue() / dodgeTime.floatValue(), 1.0f)) {
                return "parry";
            }
            return "dodge";
        }
        if ((float)MathUtils.random(100) <= (float)Integer.parseInt(this.defendPreference.split(":")[1]) * Math.min(dodgeTime.floatValue() / parryTime.floatValue(), 1.0f)) {
            return "dodge";
        }
        return "parry";
    }

    private boolean checkItemUsage() {
        if (this.itemInterval <= 0 && (this.npc.services.contains("shard") && !this.pc.debuffs.toString().contains("bleed") || this.npc.services.contains("powder") && !this.pc.debuffs.toString().contains("stun") || this.npc.services.contains("net") && !this.pc.debuffs.toString().contains("exhaus"))) {
            for (String currCondition : this.itemPreference.split(";")) {
                if (!this.checkValue(currCondition)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkAttack(String phase) {
        String currCondition;
        int n;
        int n2;
        String[] stringArray;
        String condition;
        String comboMovement = this.possibleCombo();
        if (!comboMovement.equalsIgnoreCase("")) {
            return true;
        }
        if (phase.equalsIgnoreCase("risposte") && this.attackPreference.contains("rispos:")) {
            condition = "";
            stringArray = this.attackPreference.split(";");
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                currCondition = stringArray[n];
                if (!currCondition.startsWith("rispos")) continue;
                condition = currCondition;
                break;
            }
            if (this.checkValue(condition)) {
                return true;
            }
        }
        if (phase.equalsIgnoreCase("chain") && this.attackPreference.contains("chain:")) {
            condition = "";
            stringArray = this.attackPreference.split(";");
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                currCondition = stringArray[n];
                if (!currCondition.startsWith("chain")) continue;
                condition = currCondition;
                break;
            }
            if (this.checkValue(condition)) {
                return true;
            }
        }
        for (String currCondition2 : this.attackPreference.split(";")) {
            if (!currCondition2.startsWith("attack") || !this.checkValue(currCondition2)) continue;
            return true;
        }
        return false;
    }

    private boolean checkValue(String condition) {
        String type = condition.split(":")[1];
        String target = condition.split(":")[2];
        String sign = condition.split(":")[3];
        String value = condition.split(":")[4];
        if (type.equalsIgnoreCase("life")) {
            if (target.equalsIgnoreCase("own")) {
                if (sign.equalsIgnoreCase("more")) {
                    return this.npc.life / 100 > Integer.parseInt(value);
                }
                return this.npc.life / 100 < Integer.parseInt(value);
            }
            if (sign.equalsIgnoreCase("more")) {
                return this.pc.life / 100 > Integer.parseInt(value);
            }
            return this.pc.life / 100 < Integer.parseInt(value);
        }
        if (type.equalsIgnoreCase("stamin")) {
            if (target.equalsIgnoreCase("own")) {
                if (sign.equalsIgnoreCase("more")) {
                    return this.npc.stamina / 100 > Integer.parseInt(value);
                }
                return this.npc.stamina / 100 < Integer.parseInt(value);
            }
            if (sign.equalsIgnoreCase("more")) {
                return this.pc.stamina / 100 > Integer.parseInt(value);
            }
            return this.pc.stamina / 100 < Integer.parseInt(value);
        }
        if (type.equalsIgnoreCase("balanc")) {
            if (target.equalsIgnoreCase("own")) {
                if (sign.equalsIgnoreCase("more")) {
                    return this.npc.balance / 100 > Integer.parseInt(value);
                }
                return this.npc.balance / 100 < Integer.parseInt(value);
            }
            if (sign.equalsIgnoreCase("more")) {
                return this.pc.balance / 100 > Integer.parseInt(value);
            }
            return this.pc.balance / 100 < Integer.parseInt(value);
        }
        if (type.equalsIgnoreCase("pressu")) {
            if (sign.equalsIgnoreCase("more")) {
                return Float.valueOf(CombatEngine.combatState.timePressure.floatValue() * 100.0f).intValue() > Integer.parseInt(value);
            }
            return Float.valueOf(CombatEngine.combatState.timePressure.floatValue() * 100.0f).intValue() < Integer.parseInt(value);
        }
        if (type.equalsIgnoreCase("buff")) {
            return target.equalsIgnoreCase("any") && this.npc.buffs.length() > 0 || StringList.indexOf(this.npc.buffs, target, 0, ",") >= 0 && Math.abs(100) <= Integer.parseInt(value);
        }
        if (type.equalsIgnoreCase("debuff")) {
            return target.equalsIgnoreCase("any") && this.pc.debuffs.length() > 0 || StringList.indexOf(this.pc.debuffs, target, 0, ",") >= 0 && Math.abs(100) <= Integer.parseInt(value);
        }
        return false;
    }

    private String checkSurge() {
        String surge = "";
        if (this.npc.surge == 10000) {
            String surgeOption = CombatEngine.useSurge(this.npc);
            int basicStaminaCheck = this.game.stats.get("weapons").getJSONObject(this.npc.weapon.id).getInt("staminaCost");
            if (this.npc.stamina >= basicStaminaCheck && (surgeOption.equalsIgnoreCase("strain") || surgeOption.equalsIgnoreCase("pierce")) || surgeOption.equalsIgnoreCase("press") || surgeOption.equalsIgnoreCase("brink") || surgeOption.equalsIgnoreCase("barrie") || surgeOption.equalsIgnoreCase("default") && this.npc.stamina < basicStaminaCheck) {
                surge = surgeOption;
            }
        }
        return surge;
    }
}

