/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits.actor;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import java.util.HashMap;

public class BaseActor
extends Actor {
    public TextureRegion region;
    public int regionX = 0;
    public int regionY = 0;
    public int regionWidth = 0;
    public int regionHeight = 0;
    public boolean flip = false;
    public HashMap<String, Object> params = new HashMap();
    public ShaderProgram shader = null;
    public String shaderName = "";
    public Action highlightAction;

    public BaseActor() {
        this.region = new TextureRegion();
    }

    public void setTexture(Texture t) {
        t.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        int w = t.getWidth();
        int h = t.getHeight();
        this.setWidth(w);
        this.setHeight(h);
        this.region.setRegion(t);
        this.regionX = this.region.getRegionX();
        this.regionY = this.region.getRegionY();
        this.regionWidth = this.region.getRegionWidth();
        this.regionHeight = this.region.getRegionHeight();
    }

    public void setTexture(Texture t, float width, float height) {
        t.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        this.setWidth(width);
        this.setHeight(height);
        this.region.setRegion(t);
        this.regionX = this.region.getRegionX();
        this.regionY = this.region.getRegionY();
        this.regionWidth = this.region.getRegionWidth();
        this.regionHeight = this.region.getRegionHeight();
    }

    public void setTexture(TextureRegion tr, float width, float height) {
        this.setWidth(width);
        this.setHeight(height);
        this.region = tr;
        this.regionX = this.region.getRegionX();
        this.regionY = this.region.getRegionY();
        this.regionWidth = this.region.getRegionWidth();
        this.regionHeight = this.region.getRegionHeight();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Color c = this.getColor();
        batch.setColor(c.r, c.g, c.b, c.a * parentAlpha);
        if (this.isVisible()) {
            this.region.setRegion(this.regionX, this.regionY, this.regionWidth, this.regionHeight);
            if (this.shader != null) {
                batch.setShader(this.shader);
                if (this.shaderName.equalsIgnoreCase("border")) {
                    this.shader.setUniformf("u_imageSize", new Vector2(this.getWidth(), this.getHeight()));
                    this.shader.setUniformf("u_borderColor", Color.RED);
                    this.shader.setUniformf("u_borderSize", 2.0f);
                }
            }
            batch.draw(this.region, this.flip ? this.getX() + this.getWidth() : this.getX(), this.getY(), this.getOriginX(), this.getOriginY(), this.flip ? -this.getWidth() : this.getWidth(), this.getHeight(), this.getScaleX(), this.getScaleY(), this.getRotation());
            if (this.shader != null) {
                batch.setShader(null);
            }
        }
    }
}

