/*
 * Decompiled with CFR 0.152.
 */
package com.calimasaga.slavepits;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.calimasaga.json.JSONObject;
import com.calimasaga.slavepits.game.Fighter;
import com.calimasaga.slavepits.screen.AIMenuScreen;
import com.calimasaga.slavepits.screen.ActivationScreen;
import com.calimasaga.slavepits.screen.ColiseumScreen;
import com.calimasaga.slavepits.screen.CombatScreen;
import com.calimasaga.slavepits.screen.CreditsScreen;
import com.calimasaga.slavepits.screen.DuelSetupScreen;
import com.calimasaga.slavepits.screen.EndScreen;
import com.calimasaga.slavepits.screen.EquipmentMenuScreen;
import com.calimasaga.slavepits.screen.GameMenuScreen;
import com.calimasaga.slavepits.screen.JournalScreen;
import com.calimasaga.slavepits.screen.LexiconScreen;
import com.calimasaga.slavepits.screen.LoadingScreen;
import com.calimasaga.slavepits.screen.LoreScreen;
import com.calimasaga.slavepits.screen.MainMenuScreen;
import com.calimasaga.slavepits.screen.MessageScreen;
import com.calimasaga.slavepits.screen.MultiplayerScreen;
import com.calimasaga.slavepits.screen.OptionsMenuScreen;
import com.calimasaga.slavepits.screen.PortraitsMenuScreen;
import com.calimasaga.slavepits.screen.PrepSetupScreen;
import com.calimasaga.slavepits.screen.SaveGameScreen;
import com.calimasaga.slavepits.screen.ServicesMenuScreen;
import com.calimasaga.slavepits.screen.SmithMenuScreen;
import com.calimasaga.slavepits.screen.TalentsMenuScreen;
import com.calimasaga.slavepits.screen.TournamentEventScreen;
import com.calimasaga.slavepits.screen.TournamentGameScreen;
import com.calimasaga.slavepits.screen.TournamentSetupScreen;
import com.calimasaga.slavepits.screen.TrainerMenuScreen;
import com.calimasaga.slavepits.util.Logger;
import com.calimasaga.slavepits.util.NetworkPort;
import com.calimasaga.slavepits.util.PropertiesReader;
import java.util.HashMap;
import java.util.Properties;

public class SlavePitsGame
extends Game {
    public String version = "";
    public String mail = "";
    public String key = "";
    public Float viewWidth = Float.valueOf(1440.0f);
    public Float viewHeight = Float.valueOf(1080.0f);
    public Float viewWidthMAX = Float.valueOf(1440.0f);
    public Float viewHeightMAX = Float.valueOf(1080.0f);
    public Float widthBASE = Float.valueOf(1440.0f);
    public Float heightBASE = Float.valueOf(1080.0f);
    public String language = "en";
    public boolean portraitmode = false;
    public boolean fullscreen = false;
    public boolean retroMode = false;
    public String input = "keyboard";
    public float musicVolume = 0.35f;
    public float soundVolume = 1.0f;
    public boolean violenceFilter = false;
    public boolean debugMode = false;
    public String nextkey = "";
    public String upmiddlekey = "";
    public String upleftkey = "";
    public String uprightkey = "";
    public String leftkey = "";
    public String rightkey = "";
    public String usekey = "";
    public String surgekey = "";
    public long checksum = 0L;
    public Properties settings;
    public Properties gameMessages;
    public HashMap<String, JSONObject> stats;
    public AssetManager manager;
    public Skin uiSkin;
    public LoadingScreen loadingScreen;
    public MainMenuScreen mainMenuScreen;
    public OptionsMenuScreen optionsMenuScreen;
    public ActivationScreen activationScreen;
    public LexiconScreen lexiconScreen;
    public SaveGameScreen saveGameScreen;
    public TournamentGameScreen tournamentGameScreen;
    public MessageScreen messageScreen;
    public MultiplayerScreen multiplayerScreen;
    public PrepSetupScreen prepSetupScreen;
    public TournamentSetupScreen tournamentSetupScreen;
    public DuelSetupScreen duelSetupScreen;
    public PortraitsMenuScreen portraitsMenuScreen;
    public EquipmentMenuScreen equipmentMenuScreen;
    public TalentsMenuScreen talentsMenuScreen;
    public ServicesMenuScreen servicesMenuScreen;
    public SmithMenuScreen smithMenuScreen;
    public TrainerMenuScreen trainerMenuScreen;
    public AIMenuScreen AIMenuScreen;
    public CombatScreen combatScreen;
    public GameMenuScreen gameMenuScreen;
    public LoreScreen loreScreen;
    public TournamentEventScreen tournamentEventScreen;
    public JournalScreen journalScreen;
    public ColiseumScreen coliseumScreen;
    public EndScreen endScreen;
    public CreditsScreen creditsScreen;
    public Music track;
    public NetworkPort networkPort;
    public HashMap<String, String> achievements = new HashMap();
    public HashMap<String, String> saveGame = new HashMap();
    public Fighter campaignFighter;
    public String gameMode;
    public String multiplayerPlayerNameServer;
    public String multiplayerPlayerNameClient;
    public String multiplayerInput;

    @Override
    public void create() {
        Logger.init();
        Gdx.input.setCatchBackKey(true);
        Gdx.input.setCatchMenuKey(true);
        this.version = PropertiesReader.getVersion();
        this.mail = PropertiesReader.getMailKeyPair();
        this.key = this.mail.substring(this.mail.lastIndexOf("@") + 1);
        this.mail = this.mail.substring(0, this.mail.lastIndexOf("@"));
        this.settings = PropertiesReader.loadSettings();
        this.portraitmode = Boolean.parseBoolean(this.settings.getProperty("portraitmode", "false"));
        this.retroMode = Boolean.parseBoolean(this.settings.getProperty("retromode", "false"));
        String resolution = this.settings.getProperty("resolution", "1440x1080");
        this.viewHeightMAX = Float.valueOf(1080.0f);
        this.viewWidth = this.viewWidthMAX = Float.valueOf(this.portraitmode ? this.viewHeightMAX.floatValue() * 3.0f / 4.0f : this.viewHeightMAX.floatValue() * 4.0f / 3.0f);
        this.viewHeight = this.viewHeightMAX;
        this.language = this.settings.getProperty("language", "en");
        this.input = this.settings.getProperty("input", "keyboard");
        this.fullscreen = Boolean.parseBoolean(this.settings.getProperty("fullscreen", "false"));
        this.musicVolume = Float.parseFloat(this.settings.getProperty("music", "0.7")) / 2.0f;
        this.soundVolume = Float.parseFloat(this.settings.getProperty("sound", "0.7"));
        this.violenceFilter = Boolean.parseBoolean(this.settings.getProperty("violencefilter", "false"));
        this.debugMode = Boolean.parseBoolean(this.settings.getProperty("debugmode", "false"));
        Logger.debug(this.debugMode);
        this.checksum = Long.parseLong(this.settings.getProperty("checksum", "0"));
        this.nextkey = this.settings.getProperty("key.next", " ");
        this.upmiddlekey = this.settings.getProperty("key.upmiddle", "W");
        this.upleftkey = this.settings.getProperty("key.upleft", "A");
        this.uprightkey = this.settings.getProperty("key.upright", "D");
        this.leftkey = this.settings.getProperty("key.left", "Z");
        this.rightkey = this.settings.getProperty("key.right", "C");
        this.usekey = this.settings.getProperty("key.use", "F");
        this.surgekey = this.settings.getProperty("key.surge", "R");
        this.gameMessages = new Properties();
        this.gameMessages = PropertiesReader.loadLanguage(this.gameMessages, "en");
        this.gameMessages = PropertiesReader.loadLanguage(this.gameMessages, this.language);
        this.achievements = PropertiesReader.loadAchievements(this.mail, this.key, this.debugMode);
        Graphics.Monitor currMonitor = Gdx.graphics.getMonitor();
        Graphics.DisplayMode displayMode = Gdx.graphics.getDisplayMode(currMonitor);
        if (!this.fullscreen) {
            Gdx.graphics.setWindowedMode(Integer.parseInt(resolution.split("x")[this.portraitmode ? 1 : 0]), Integer.parseInt(resolution.split("x")[this.portraitmode ? 0 : 1]));
        } else if (!Gdx.graphics.setFullscreenMode(displayMode)) {
            Gdx.graphics.setWindowedMode(Integer.parseInt(resolution.split("x")[this.portraitmode ? 1 : 0]), Integer.parseInt(resolution.split("x")[this.portraitmode ? 0 : 1]));
        }
        this.manager = new AssetManager();
        LoadingScreen ls = new LoadingScreen(this);
        this.setScreen(ls);
    }

    @Override
    public void render() {
        try {
            super.render();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispose() {
        if (this.track != null && this.track.isPlaying()) {
            this.track.stop();
            this.track.dispose();
        }
        if (this.manager != null) {
            this.manager.dispose();
        }
        Logger.dispose();
        Gdx.app.exit();
    }

    public boolean isMultiplayerGame() {
        return this.gameMode.equalsIgnoreCase("server") || this.gameMode.equalsIgnoreCase("client");
    }

    public String getOverridenFilename(String filename) {
        if (this.retroMode && Gdx.files.internal("retro/" + filename).exists()) {
            return "retro/" + filename;
        }
        return filename;
    }

    public String getOverridenAsset(String asset) {
        if (this.retroMode && this.manager.contains("retro/" + asset)) {
            return "retro/" + asset;
        }
        return asset;
    }

    public void loadGenericAsset(String filename, Class type) {
        this.manager.load(this.getOverridenFilename(filename), type);
    }

    public void loadGenericSettings(String setting, String filename) {
        this.stats.put(setting, new JSONObject(Gdx.files.internal(this.getOverridenFilename(filename)).readString("UTF-8")));
    }
}

